/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.load.GenericFileFilter;

public class SetLanguage
extends GenericFunction {
    private JDialog _dialog = null;
    private JComboBox<String> _languageDropDown = null;
    private JTextField _langFileBox = null;
    private int _startIndex = 0;
    private static final String[] LANGUAGE_NAMES = new String[]{"afrikaans", "\u010de\u0161tina", "deutsch", "english", "american english", "espa\u00f1ol", "fran\u00e7ais", "italiano", "magyar", "nederlands", "polski", "portugu\u00eas", "rom\u00e2n\u0103", "suomi", "svenska", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 (russian)", "\u4e2d\u6587 (chinese)", "\u65e5\u672c\u8a9e (japanese)", "\ud55c\uad6d\uc5b4/\uc870\uc120\ub9d0 (korean)", "schwiizerd\u00fc\u00fctsch"};
    private static final String[] LANGUAGE_CODES = new String[]{"af", "cz", "de", "en", "en_us", "es", "fr", "it", "hu", "nl", "pl", "pt", "ro", "fi", "sv", "ru", "zh", "ja", "ko", "de_ch"};

    public SetLanguage(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setlanguage";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel jLabel = new JLabel("<html>" + I18nManager.getText("dialog.setlanguage.firstintro") + "</html>");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel("<html>" + I18nManager.getText("dialog.setlanguage.secondintro") + "</html>");
        jLabel2.setAlignmentX(0.0f);
        jLabel2.setHorizontalAlignment(2);
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel(String.valueOf(I18nManager.getText("dialog.setlanguage.language")) + " : "));
        this._languageDropDown = new JComboBox<String>(LANGUAGE_NAMES);
        jPanel3.add(this._languageDropDown);
        jPanel3.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(I18nManager.getText("button.select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetLanguage.this.selectLanguage();
            }
        });
        jPanel3.add(jButton);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(4));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(new JLabel(String.valueOf(I18nManager.getText("dialog.setlanguage.languagefile")) + " : "));
        this._langFileBox = new JTextField("some_long_example_file_path.txt");
        jPanel4.add(this._langFileBox);
        JButton jButton2 = new JButton(I18nManager.getText("button.browse"));
        jPanel4.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetLanguage.this.chooseFile();
            }
        });
        jPanel4.add(Box.createHorizontalStrut(5));
        JButton jButton3 = new JButton(I18nManager.getText("button.select"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetLanguage.this.selectLanguageFile();
            }
        });
        jPanel4.add(jButton3);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createVerticalGlue());
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton4 = new JButton(I18nManager.getText("button.cancel"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetLanguage.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton4);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    @Override
    public void begin() {
        Object object;
        String string;
        int n;
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        if ((n = SetLanguage.getLanguageIndex(string = Config.getConfigString("prune.languagecode"))) < 0 && (n = SetLanguage.getLanguageIndex(String.valueOf(((Locale)(object = Locale.getDefault())).getLanguage()) + "_" + ((Locale)object).getCountry())) < 0) {
            n = SetLanguage.getLanguageIndex(((Locale)object).getLanguage());
        }
        if (n >= 0) {
            this._languageDropDown.setSelectedIndex(n);
        }
        this._startIndex = this._languageDropDown.getSelectedIndex();
        object = Config.getConfigString("prune.languagefile");
        this._langFileBox.setText((String)(object == null ? "" : object));
        this._dialog.setVisible(true);
    }

    private static int getLanguageIndex(String string) {
        int n = -1;
        if (string != null && !string.equals("")) {
            int n2 = 0;
            while (n2 < LANGUAGE_CODES.length) {
                if (LANGUAGE_CODES[n2].equalsIgnoreCase(string)) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    private void selectLanguage() {
        int n = this._languageDropDown.getSelectedIndex();
        if (n >= 0 && n != this._startIndex) {
            String string = LANGUAGE_CODES[n];
            Config.setConfigString("prune.languagecode", string);
            Config.setConfigString("prune.languagefile", null);
            this._dialog.dispose();
            this.showEndMessage();
        }
    }

    private void selectLanguageFile() {
        String string = Config.getConfigString("prune.languagefile");
        String string2 = this._langFileBox.getText();
        if (string2 != null && !string2.equals("")) {
            File file = new File(string2);
            if (!file.exists() || !file.canRead()) {
                this._app.showErrorMessage(this.getNameKey(), "error.load.noread");
            } else if (!SetLanguage.languageFileLooksOk(file)) {
                this._app.showErrorMessage(this.getNameKey(), "error.language.wrongfile");
            } else if (string == null || !file.getAbsolutePath().equalsIgnoreCase(string)) {
                Config.setConfigString("prune.languagefile", file.getAbsolutePath());
                this._dialog.dispose();
                this.showEndMessage();
            }
        } else if (string != null && string.length() > 0) {
            Config.setConfigString("prune.languagefile", null);
            this._dialog.dispose();
            this.showEndMessage();
        }
    }

    private static boolean languageFileLooksOk(File file) {
        boolean bl;
        boolean bl2;
        block14: {
            bl2 = false;
            bl = false;
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string = bufferedReader.readLine();
                    while (string != null && !bl2 && !bl) {
                        if (string.trim().length() > 0 && string.matches("[a-z.]+=.+")) {
                            bl2 = true;
                        }
                        if (string.indexOf(0, 0) >= 0) {
                            bl = true;
                        }
                        string = bufferedReader.readLine();
                    }
                }
                catch (Exception exception) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return bl2 && !bl;
    }

    private void chooseFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.txt", new String[]{"txt", "text"}));
        jFileChooser.setAcceptAllFileFilterUsed(true);
        String string = this._langFileBox.getText();
        if (string != null && string.length() > 1) {
            jFileChooser.setSelectedFile(new File(string));
        }
        if (jFileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._langFileBox.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void showEndMessage() {
        String string = Config.getConfigBoolean("prune.autosavesettings") ? "dialog.setlanguage.endmessagewithautosave" : "dialog.setlanguage.endmessage";
        JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText(string), I18nManager.getText(this.getNameKey()), 1);
    }
}

