/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Figure;
import com.microsoft.sqlserver.jdbc.Geometry;
import com.microsoft.sqlserver.jdbc.InternalSpatialDatatype;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.Point;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Segment;
import com.microsoft.sqlserver.jdbc.Shape;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

abstract class SQLServerSpatialDatatype {
    protected ByteBuffer buffer;
    protected InternalSpatialDatatype internalType;
    protected String wkt;
    protected String wktNoZM;
    protected byte[] wkb;
    protected byte[] wkbNoZM;
    protected int srid;
    protected byte version = 1;
    protected int numberOfPoints;
    protected int numberOfFigures;
    protected int numberOfShapes;
    protected int numberOfSegments;
    protected StringBuffer WKTsb;
    protected StringBuffer WKTsbNoZM;
    protected int currentPointIndex = 0;
    protected int currentFigureIndex = 0;
    protected int currentSegmentIndex = 0;
    protected int currentShapeIndex = 0;
    protected double[] xValues;
    protected double[] yValues;
    protected double[] zValues;
    protected double[] mValues;
    protected Figure[] figures;
    protected Shape[] shapes;
    protected Segment[] segments;
    protected boolean hasZvalues = false;
    protected boolean hasMvalues = false;
    protected boolean isValid = false;
    protected boolean isSinglePoint = false;
    protected boolean isSingleLineSegment = false;
    protected boolean isLargerThanHemisphere = false;
    protected boolean isNull = true;
    protected final byte FA_INTERIOR_RING = 0;
    protected final byte FA_STROKE = 1;
    protected final byte FA_EXTERIOR_RING = (byte)2;
    protected final byte FA_POINT = 0;
    protected final byte FA_LINE = 1;
    protected final byte FA_ARC = (byte)2;
    protected final byte FA_COMPOSITE_CURVE = (byte)3;
    protected int currentWktPos = 0;
    protected List<Point> pointList = new ArrayList<Point>();
    protected List<Figure> figureList = new ArrayList<Figure>();
    protected List<Shape> shapeList = new ArrayList<Shape>();
    protected List<Segment> segmentList = new ArrayList<Segment>();
    protected byte serializationProperties = 0;
    private final byte SEGMENT_LINE = 0;
    private final byte SEGMENT_ARC = 1;
    private final byte SEGMENT_FIRST_LINE = (byte)2;
    private final byte SEGMENT_FIRST_ARC = (byte)3;
    private final byte hasZvaluesMask = 1;
    private final byte hasMvaluesMask = (byte)2;
    private final byte isValidMask = (byte)4;
    private final byte isSinglePointMask = (byte)8;
    private final byte isSingleLineSegmentMask = (byte)16;
    private final byte isLargerThanHemisphereMask = (byte)32;
    private List<Integer> version_one_shape_indexes = new ArrayList<Integer>();

    SQLServerSpatialDatatype() {
    }

    protected void serializeToWkb(boolean noZM, SQLServerSpatialDatatype type) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(this.determineWkbCapacity());
        this.createSerializationProperties();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(this.srid);
        buf.put(this.version);
        buf.put(this.serializationProperties);
        if (!this.isSinglePoint && !this.isSingleLineSegment) {
            buf.putInt(this.numberOfPoints);
        }
        if (type instanceof Geometry) {
            for (i = 0; i < this.numberOfPoints; ++i) {
                buf.putDouble(this.xValues[i]);
                buf.putDouble(this.yValues[i]);
            }
        } else {
            for (i = 0; i < this.numberOfPoints; ++i) {
                buf.putDouble(this.yValues[i]);
                buf.putDouble(this.xValues[i]);
            }
        }
        if (!noZM) {
            if (this.hasZvalues) {
                for (i = 0; i < this.numberOfPoints; ++i) {
                    buf.putDouble(this.zValues[i]);
                }
            }
            if (this.hasMvalues) {
                for (i = 0; i < this.numberOfPoints; ++i) {
                    buf.putDouble(this.mValues[i]);
                }
            }
        }
        if (this.isSinglePoint || this.isSingleLineSegment) {
            this.wkb = buf.array();
            return;
        }
        buf.putInt(this.numberOfFigures);
        for (i = 0; i < this.numberOfFigures; ++i) {
            buf.put(this.figures[i].getFiguresAttribute());
            buf.putInt(this.figures[i].getPointOffset());
        }
        buf.putInt(this.numberOfShapes);
        for (i = 0; i < this.numberOfShapes; ++i) {
            buf.putInt(this.shapes[i].getParentOffset());
            buf.putInt(this.shapes[i].getFigureOffset());
            buf.put(this.shapes[i].getOpenGISType());
        }
        if (this.version == 2 && null != this.segments) {
            buf.putInt(this.numberOfSegments);
            for (i = 0; i < this.numberOfSegments; ++i) {
                buf.put(this.segments[i].getSegmentType());
            }
        }
        if (noZM) {
            this.wkbNoZM = buf.array();
        } else {
            this.wkb = buf.array();
        }
    }

    protected void parseWkb(SQLServerSpatialDatatype type) throws SQLServerException {
        this.srid = this.readInt();
        this.version = this.readByte();
        this.serializationProperties = this.readByte();
        this.interpretSerializationPropBytes();
        this.readNumberOfPoints();
        this.readPoints(type);
        if (this.hasZvalues) {
            this.readZvalues();
        }
        if (this.hasMvalues) {
            this.readMvalues();
        }
        if (!this.isSinglePoint && !this.isSingleLineSegment) {
            this.readNumberOfFigures();
            this.readFigures();
            this.readNumberOfShapes();
            this.readShapes();
        }
        this.determineInternalType();
        if (this.buffer.hasRemaining() && this.version == 2 && this.internalType.getTypeCode() != 8 && this.internalType.getTypeCode() != 11) {
            this.readNumberOfSegments();
            this.readSegments();
        }
    }

    protected void constructWKT(SQLServerSpatialDatatype sd, InternalSpatialDatatype isd, int pointIndexEnd, int figureIndexEnd, int segmentIndexEnd, int shapeIndexEnd) throws SQLServerException {
        if (this.numberOfPoints == 0) {
            if (isd.getTypeCode() == 11) {
                if (sd instanceof Geometry) {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_illegalTypeForGeometry"));
                    throw new SQLServerException(form.format(new Object[]{"Fullglobe"}), null, 0, null);
                }
                this.appendToWKTBuffers("FULLGLOBE");
                return;
            }
            if (isd.getTypeCode() == 7 && this.currentShapeIndex != shapeIndexEnd - 1) {
                ++this.currentShapeIndex;
                this.appendToWKTBuffers(isd.getTypeName() + "(");
                this.constructWKT(this, InternalSpatialDatatype.valueOf(this.shapes[this.currentShapeIndex].getOpenGISType()), this.numberOfPoints, this.numberOfFigures, this.numberOfSegments, this.numberOfShapes);
                this.appendToWKTBuffers(")");
                return;
            }
            this.appendToWKTBuffers(isd.getTypeName() + " EMPTY");
            return;
        }
        this.appendToWKTBuffers(isd.getTypeName());
        this.appendToWKTBuffers("(");
        switch (isd) {
            case POINT: {
                this.constructPointWKT(this.currentPointIndex);
                break;
            }
            case LINESTRING: 
            case CIRCULARSTRING: {
                this.constructLineWKT(this.currentPointIndex, pointIndexEnd);
                break;
            }
            case POLYGON: {
                this.constructShapeWKT(this.currentFigureIndex, figureIndexEnd);
                break;
            }
            case MULTIPOINT: 
            case MULTILINESTRING: {
                this.constructMultiShapeWKT(this.currentShapeIndex, shapeIndexEnd);
                break;
            }
            case COMPOUNDCURVE: {
                this.constructCompoundcurveWKT(this.currentSegmentIndex, segmentIndexEnd, pointIndexEnd);
                break;
            }
            case MULTIPOLYGON: {
                this.constructMultipolygonWKT(this.currentShapeIndex, shapeIndexEnd);
                break;
            }
            case GEOMETRYCOLLECTION: {
                this.constructGeometryCollectionWKT(shapeIndexEnd);
                break;
            }
            case CURVEPOLYGON: {
                this.constructCurvepolygonWKT(this.currentFigureIndex, figureIndexEnd, this.currentSegmentIndex, segmentIndexEnd);
                break;
            }
            default: {
                this.throwIllegalWKTPosition();
            }
        }
        this.appendToWKTBuffers(")");
    }

    protected void parseWKTForSerialization(SQLServerSpatialDatatype sd, int startPos, int parentShapeIndex, boolean isGeoCollection) throws SQLServerException {
        while (this.hasMoreToken()) {
            if (startPos != 0) {
                if (this.wkt.charAt(this.currentWktPos) == ')') {
                    return;
                }
                if (this.wkt.charAt(this.currentWktPos) == ',') {
                    ++this.currentWktPos;
                }
            }
            String nextToken = this.getNextStringToken().toUpperCase(Locale.US);
            InternalSpatialDatatype isd = InternalSpatialDatatype.INVALID_TYPE;
            try {
                isd = InternalSpatialDatatype.valueOf(nextToken);
            }
            catch (Exception e) {
                this.throwIllegalWKTPosition();
            }
            byte fa = 0;
            if (this.version == 1 && (nextToken.equals("CIRCULARSTRING") || nextToken.equals("COMPOUNDCURVE") || nextToken.equals("CURVEPOLYGON"))) {
                this.version = (byte)2;
            }
            if (nextToken.equals("FULLGLOBE")) {
                if (sd instanceof Geometry) {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_illegalTypeForGeometry"));
                    throw new SQLServerException(form.format(new Object[]{"Fullglobe"}), null, 0, null);
                }
                if (startPos != 0) {
                    this.throwIllegalWKTPosition();
                }
                this.shapeList.add(new Shape(parentShapeIndex, -1, isd.getTypeCode()));
                this.isLargerThanHemisphere = true;
                this.version = (byte)2;
                break;
            }
            if (this.checkEmptyKeyword(parentShapeIndex, isd, false)) continue;
            this.readOpenBracket();
            switch (nextToken) {
                case "POINT": {
                    if (startPos == 0 && nextToken.toUpperCase().equals("POINT")) {
                        this.isSinglePoint = true;
                        this.internalType = InternalSpatialDatatype.POINT;
                    }
                    if (isGeoCollection) {
                        this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                        this.figureList.add(new Figure(1, this.pointList.size()));
                    }
                    this.readPointWkt();
                    break;
                }
                case "LINESTRING": 
                case "CIRCULARSTRING": {
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    fa = isd.getTypeCode() == InternalSpatialDatatype.LINESTRING.getTypeCode() ? (byte)1 : 2;
                    this.figureList.add(new Figure(fa, this.pointList.size()));
                    this.readLineWkt();
                    if (startPos != 0 || !nextToken.toUpperCase().equals("LINESTRING") || this.pointList.size() != 2) break;
                    this.isSingleLineSegment = true;
                    break;
                }
                case "POLYGON": 
                case "MULTIPOINT": 
                case "MULTILINESTRING": {
                    int thisShapeIndex = this.shapeList.size();
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    this.readShapeWkt(thisShapeIndex, nextToken);
                    break;
                }
                case "MULTIPOLYGON": {
                    int thisShapeIndex = this.shapeList.size();
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    this.readMultiPolygonWkt(thisShapeIndex, nextToken);
                    break;
                }
                case "COMPOUNDCURVE": {
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    this.figureList.add(new Figure(3, this.pointList.size()));
                    this.readCompoundCurveWkt(true);
                    break;
                }
                case "CURVEPOLYGON": {
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    this.readCurvePolygon();
                    break;
                }
                case "GEOMETRYCOLLECTION": {
                    int thisShapeIndex = this.shapeList.size();
                    this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), isd.getTypeCode()));
                    this.parseWKTForSerialization(this, this.currentWktPos, thisShapeIndex, true);
                    break;
                }
                default: {
                    this.throwIllegalWKTPosition();
                }
            }
            this.readCloseBracket();
        }
        this.populateStructures();
    }

    protected void constructPointWKT(int pointIndex) {
        if (this.xValues[pointIndex] % 1.0 == 0.0) {
            this.appendToWKTBuffers((int)this.xValues[pointIndex]);
        } else {
            this.appendToWKTBuffers(this.xValues[pointIndex]);
        }
        this.appendToWKTBuffers(" ");
        if (this.yValues[pointIndex] % 1.0 == 0.0) {
            this.appendToWKTBuffers((int)this.yValues[pointIndex]);
        } else {
            this.appendToWKTBuffers(this.yValues[pointIndex]);
        }
        this.appendToWKTBuffers(" ");
        if (this.hasZvalues && !Double.isNaN(this.zValues[pointIndex])) {
            if (this.zValues[pointIndex] % 1.0 == 0.0) {
                this.WKTsb.append((long)this.zValues[pointIndex]);
            } else {
                this.WKTsb.append(this.zValues[pointIndex]);
            }
            this.WKTsb.append(" ");
        } else if (this.hasMvalues && !Double.isNaN(this.mValues[pointIndex])) {
            this.WKTsb.append("NULL ");
        }
        if (this.hasMvalues && !Double.isNaN(this.mValues[pointIndex])) {
            if (this.mValues[pointIndex] % 1.0 == 0.0) {
                this.WKTsb.append((long)this.mValues[pointIndex]);
            } else {
                this.WKTsb.append(this.mValues[pointIndex]);
            }
            this.WKTsb.append(" ");
        }
        ++this.currentPointIndex;
        this.WKTsb.setLength(this.WKTsb.length() - 1);
        this.WKTsbNoZM.setLength(this.WKTsbNoZM.length() - 1);
    }

    protected void constructLineWKT(int pointStartIndex, int pointEndIndex) {
        for (int i = pointStartIndex; i < pointEndIndex; ++i) {
            this.constructPointWKT(i);
            if (i == pointEndIndex - 1) continue;
            this.appendToWKTBuffers(", ");
        }
    }

    protected void constructShapeWKT(int figureStartIndex, int figureEndIndex) {
        for (int i = figureStartIndex; i < figureEndIndex; ++i) {
            this.appendToWKTBuffers("(");
            if (i != this.numberOfFigures - 1) {
                this.constructLineWKT(this.figures[i].getPointOffset(), this.figures[i + 1].getPointOffset());
            } else {
                this.constructLineWKT(this.figures[i].getPointOffset(), this.numberOfPoints);
            }
            if (i != figureEndIndex - 1) {
                this.appendToWKTBuffers("), ");
                continue;
            }
            this.appendToWKTBuffers(")");
        }
    }

    protected void constructMultiShapeWKT(int shapeStartIndex, int shapeEndIndex) {
        for (int i = shapeStartIndex + 1; i < shapeEndIndex; ++i) {
            if (this.shapes[i].getFigureOffset() == -1) {
                this.appendToWKTBuffers("EMPTY");
            } else {
                this.constructShapeWKT(this.shapes[i].getFigureOffset(), this.shapes[i].getFigureOffset() + 1);
            }
            if (i == shapeEndIndex - 1) continue;
            this.appendToWKTBuffers(", ");
        }
    }

    protected void constructCompoundcurveWKT(int segmentStartIndex, int segmentEndIndex, int pointEndIndex) {
        block4: for (int i = segmentStartIndex; i < segmentEndIndex; ++i) {
            byte segment = this.segments[i].getSegmentType();
            this.constructSegmentWKT(i, segment, pointEndIndex);
            if (i == segmentEndIndex - 1) {
                this.appendToWKTBuffers(")");
                break;
            }
            switch (segment) {
                case 0: 
                case 2: {
                    if (this.segments[i + 1].getSegmentType() == 0) continue block4;
                    this.appendToWKTBuffers("), ");
                    continue block4;
                }
                case 1: 
                case 3: {
                    if (this.segments[i + 1].getSegmentType() == 1) continue block4;
                    this.appendToWKTBuffers("), ");
                    continue block4;
                }
                default: {
                    return;
                }
            }
        }
    }

    protected void constructMultipolygonWKT(int shapeStartIndex, int shapeEndIndex) {
        for (int i = shapeStartIndex + 1; i < shapeEndIndex; ++i) {
            int figureEndIndex = this.figures.length;
            if (this.shapes[i].getFigureOffset() == -1) {
                this.appendToWKTBuffers("EMPTY");
                if (i == shapeEndIndex - 1) continue;
                this.appendToWKTBuffers(", ");
                continue;
            }
            int figureStartIndex = this.shapes[i].getFigureOffset();
            if (i == this.shapes.length - 1) {
                figureEndIndex = this.figures.length;
            } else {
                for (int tempCurrentShapeIndex = i + 1; tempCurrentShapeIndex < this.shapes.length; ++tempCurrentShapeIndex) {
                    if (this.shapes[tempCurrentShapeIndex].getFigureOffset() == -1) {
                        continue;
                    }
                    figureEndIndex = this.shapes[tempCurrentShapeIndex].getFigureOffset();
                    break;
                }
            }
            this.appendToWKTBuffers("(");
            for (int j = figureStartIndex; j < figureEndIndex; ++j) {
                this.appendToWKTBuffers("(");
                if (j == this.figures.length - 1) {
                    this.constructLineWKT(this.figures[j].getPointOffset(), this.numberOfPoints);
                } else {
                    this.constructLineWKT(this.figures[j].getPointOffset(), this.figures[j + 1].getPointOffset());
                }
                if (j == figureEndIndex - 1) {
                    this.appendToWKTBuffers(")");
                    continue;
                }
                this.appendToWKTBuffers("), ");
            }
            this.appendToWKTBuffers(")");
            if (i == shapeEndIndex - 1) continue;
            this.appendToWKTBuffers(", ");
        }
    }

    protected void constructCurvepolygonWKT(int figureStartIndex, int figureEndIndex, int segmentStartIndex, int segmentEndIndex) {
        for (int i = figureStartIndex; i < figureEndIndex; ++i) {
            switch (this.figures[i].getFiguresAttribute()) {
                case 1: {
                    this.appendToWKTBuffers("(");
                    if (i == this.figures.length - 1) {
                        this.constructLineWKT(this.currentPointIndex, this.numberOfPoints);
                    } else {
                        this.constructLineWKT(this.currentPointIndex, this.figures[i + 1].getPointOffset());
                    }
                    this.appendToWKTBuffers(")");
                    break;
                }
                case 2: {
                    this.appendToWKTBuffers("CIRCULARSTRING(");
                    if (i == this.figures.length - 1) {
                        this.constructLineWKT(this.currentPointIndex, this.numberOfPoints);
                    } else {
                        this.constructLineWKT(this.currentPointIndex, this.figures[i + 1].getPointOffset());
                    }
                    this.appendToWKTBuffers(")");
                    break;
                }
                case 3: {
                    this.appendToWKTBuffers("COMPOUNDCURVE(");
                    int pointEndIndex = 0;
                    pointEndIndex = i == this.figures.length - 1 ? this.numberOfPoints : this.figures[i + 1].getPointOffset();
                    while (this.currentPointIndex < pointEndIndex) {
                        byte segment = this.segments[segmentStartIndex].getSegmentType();
                        this.constructSegmentWKT(segmentStartIndex, segment, pointEndIndex);
                        if (this.currentPointIndex >= pointEndIndex) {
                            this.appendToWKTBuffers("))");
                        } else {
                            switch (segment) {
                                case 0: 
                                case 2: {
                                    if (this.segments[segmentStartIndex + 1].getSegmentType() == 0) break;
                                    this.appendToWKTBuffers("), ");
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    if (this.segments[segmentStartIndex + 1].getSegmentType() == 1) break;
                                    this.appendToWKTBuffers("), ");
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        ++segmentStartIndex;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (i == figureEndIndex - 1) continue;
            this.appendToWKTBuffers(", ");
        }
    }

    protected void constructSegmentWKT(int currentSegment, byte segment, int pointEndIndex) {
        switch (segment) {
            case 0: {
                this.appendToWKTBuffers(", ");
                this.constructLineWKT(this.currentPointIndex, this.currentPointIndex + 1);
                if (currentSegment == this.segments.length - 1 || this.segments[currentSegment + 1].getSegmentType() == 0) break;
                --this.currentPointIndex;
                this.incrementPointNumStartIfPointNotReused(pointEndIndex);
                break;
            }
            case 1: {
                this.appendToWKTBuffers(", ");
                this.constructLineWKT(this.currentPointIndex, this.currentPointIndex + 2);
                if (currentSegment == this.segments.length - 1 || this.segments[currentSegment + 1].getSegmentType() == 1) break;
                --this.currentPointIndex;
                this.incrementPointNumStartIfPointNotReused(pointEndIndex);
                break;
            }
            case 2: {
                this.appendToWKTBuffers("(");
                this.constructLineWKT(this.currentPointIndex, this.currentPointIndex + 2);
                if (currentSegment == this.segments.length - 1 || this.segments[currentSegment + 1].getSegmentType() == 0) break;
                --this.currentPointIndex;
                this.incrementPointNumStartIfPointNotReused(pointEndIndex);
                break;
            }
            case 3: {
                this.appendToWKTBuffers("CIRCULARSTRING(");
                this.constructLineWKT(this.currentPointIndex, this.currentPointIndex + 3);
                if (currentSegment == this.segments.length - 1 || this.segments[currentSegment + 1].getSegmentType() == 1) break;
                --this.currentPointIndex;
                this.incrementPointNumStartIfPointNotReused(pointEndIndex);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void constructGeometryCollectionWKT(int shapeEndIndex) throws SQLServerException {
        ++this.currentShapeIndex;
        this.constructGeometryCollectionWKThelper(shapeEndIndex);
    }

    protected void readPointWkt() throws SQLServerException {
        int numOfCoordinates = 0;
        double[] coords = new double[4];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = Double.NaN;
        }
        while (numOfCoordinates < 4) {
            double sign = 1.0;
            if (this.wkt.charAt(this.currentWktPos) == '-') {
                sign = -1.0;
            }
            int startPos = ++this.currentWktPos;
            if (this.wkt.charAt(this.currentWktPos) == ')') break;
            while (this.currentWktPos < this.wkt.length() && (Character.isDigit(this.wkt.charAt(this.currentWktPos)) || this.wkt.charAt(this.currentWktPos) == '.' || this.wkt.charAt(this.currentWktPos) == 'E' || this.wkt.charAt(this.currentWktPos) == 'e')) {
                ++this.currentWktPos;
            }
            try {
                coords[numOfCoordinates] = sign * new BigDecimal(this.wkt.substring(startPos, this.currentWktPos)).doubleValue();
                if (numOfCoordinates == 2) {
                    this.hasZvalues = true;
                } else if (numOfCoordinates == 3) {
                    this.hasMvalues = true;
                }
            }
            catch (Exception e) {
                if (this.wkt.length() > this.currentWktPos + 3 && this.wkt.substring(this.currentWktPos, this.currentWktPos + 4).equalsIgnoreCase("null")) {
                    coords[numOfCoordinates] = Double.NaN;
                    this.currentWktPos += 4;
                }
                this.throwIllegalWKTPosition();
            }
            this.skipWhiteSpaces();
            if (++numOfCoordinates == 4 && this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) != ',' && this.wkt.charAt(this.currentWktPos) != ')') {
                this.throwIllegalWKTPosition();
            }
            if (this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) == ',') {
                if (numOfCoordinates == 1) {
                    this.throwIllegalWKTPosition();
                }
                ++this.currentWktPos;
                this.skipWhiteSpaces();
                break;
            }
            this.skipWhiteSpaces();
        }
        this.pointList.add(new Point(coords[0], coords[1], coords[2], coords[3]));
    }

    protected void readLineWkt() throws SQLServerException {
        while (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            this.readPointWkt();
        }
    }

    protected void readShapeWkt(int parentShapeIndex, String nextToken) throws SQLServerException {
        byte fa = 0;
        while (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            if (!nextToken.equals("POLYGON") && this.checkEmptyKeyword(parentShapeIndex, InternalSpatialDatatype.valueOf(nextToken), true)) continue;
            if (nextToken.equals("MULTIPOINT")) {
                this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), InternalSpatialDatatype.POINT.getTypeCode()));
            } else if (nextToken.equals("MULTILINESTRING")) {
                this.shapeList.add(new Shape(parentShapeIndex, this.figureList.size(), InternalSpatialDatatype.LINESTRING.getTypeCode()));
            }
            if (this.version == 1) {
                if (nextToken.equals("MULTIPOINT")) {
                    fa = 1;
                } else if (nextToken.equals("MULTILINESTRING") || nextToken.equals("POLYGON")) {
                    fa = 2;
                }
                this.version_one_shape_indexes.add(this.figureList.size());
            } else if (this.version == 2 && (nextToken.equals("MULTIPOINT") || nextToken.equals("MULTILINESTRING") || nextToken.equals("POLYGON") || nextToken.equals("MULTIPOLYGON"))) {
                fa = 1;
            }
            this.figureList.add(new Figure(fa, this.pointList.size()));
            this.readOpenBracket();
            this.readLineWkt();
            this.readCloseBracket();
            this.skipWhiteSpaces();
            if (this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) == ',') {
                this.readComma();
                continue;
            }
            if (this.wkt.charAt(this.currentWktPos) == ')') continue;
            this.throwIllegalWKTPosition();
        }
    }

    protected void readCurvePolygon() throws SQLServerException {
        while (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            String nextPotentialToken = this.getNextStringToken().toUpperCase(Locale.US);
            if (nextPotentialToken.equals("CIRCULARSTRING")) {
                this.figureList.add(new Figure(2, this.pointList.size()));
                this.readOpenBracket();
                this.readLineWkt();
                this.readCloseBracket();
            } else if (nextPotentialToken.equals("COMPOUNDCURVE")) {
                this.figureList.add(new Figure(3, this.pointList.size()));
                this.readOpenBracket();
                this.readCompoundCurveWkt(true);
                this.readCloseBracket();
            } else if (this.wkt.charAt(this.currentWktPos) == '(') {
                this.figureList.add(new Figure(1, this.pointList.size()));
                this.readOpenBracket();
                this.readLineWkt();
                this.readCloseBracket();
            } else {
                this.throwIllegalWKTPosition();
            }
            if (this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) == ',') {
                this.readComma();
                continue;
            }
            if (this.wkt.charAt(this.currentWktPos) == ')') continue;
            this.throwIllegalWKTPosition();
        }
    }

    protected void readMultiPolygonWkt(int thisShapeIndex, String nextToken) throws SQLServerException {
        while (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            if (this.checkEmptyKeyword(thisShapeIndex, InternalSpatialDatatype.valueOf(nextToken), true)) continue;
            this.shapeList.add(new Shape(thisShapeIndex, this.figureList.size(), InternalSpatialDatatype.POLYGON.getTypeCode()));
            this.readOpenBracket();
            this.readShapeWkt(thisShapeIndex, nextToken);
            this.readCloseBracket();
            if (this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) == ',') {
                this.readComma();
                continue;
            }
            if (this.wkt.charAt(this.currentWktPos) == ')') continue;
            this.throwIllegalWKTPosition();
        }
    }

    protected void readSegmentWkt(int segmentType, boolean isFirstIteration) throws SQLServerException {
        this.segmentList.add(new Segment((byte)segmentType));
        int segmentLength = segmentType;
        if (segmentLength < 2) {
            ++segmentLength;
        }
        for (int i = 0; i < segmentLength; ++i) {
            if (i == 0 && !isFirstIteration && segmentType >= 2) {
                this.skipFirstPointWkt();
                continue;
            }
            this.readPointWkt();
        }
        if (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            if (segmentType == 3 || segmentType == 1) {
                this.readSegmentWkt(1, false);
            } else if (segmentType == 2 || segmentType == 0) {
                this.readSegmentWkt(0, false);
            }
        }
    }

    protected void readCompoundCurveWkt(boolean isFirstIteration) throws SQLServerException {
        while (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) != ')') {
            String nextPotentialToken = this.getNextStringToken().toUpperCase(Locale.US);
            if (nextPotentialToken.equals("CIRCULARSTRING")) {
                this.readOpenBracket();
                this.readSegmentWkt(3, isFirstIteration);
                this.readCloseBracket();
            } else if (this.wkt.charAt(this.currentWktPos) == '(') {
                this.readOpenBracket();
                this.readSegmentWkt(2, isFirstIteration);
                this.readCloseBracket();
            } else {
                this.throwIllegalWKTPosition();
            }
            isFirstIteration = false;
            if (this.checkSQLLength(this.currentWktPos + 1) && this.wkt.charAt(this.currentWktPos) == ',') {
                this.readComma();
                continue;
            }
            if (this.wkt.charAt(this.currentWktPos) == ')') continue;
            this.throwIllegalWKTPosition();
        }
    }

    protected String getNextStringToken() {
        int endIndex;
        this.skipWhiteSpaces();
        for (endIndex = this.currentWktPos; endIndex < this.wkt.length() && Character.isLetter(this.wkt.charAt(endIndex)); ++endIndex) {
        }
        int temp = this.currentWktPos;
        this.currentWktPos = endIndex;
        this.skipWhiteSpaces();
        return this.wkt.substring(temp, endIndex);
    }

    protected void populateStructures() {
        int i;
        if (this.pointList.size() > 0) {
            this.xValues = new double[this.pointList.size()];
            this.yValues = new double[this.pointList.size()];
            for (i = 0; i < this.pointList.size(); ++i) {
                this.xValues[i] = this.pointList.get(i).getX();
                this.yValues[i] = this.pointList.get(i).getY();
            }
            if (this.hasZvalues) {
                this.zValues = new double[this.pointList.size()];
                for (i = 0; i < this.pointList.size(); ++i) {
                    this.zValues[i] = this.pointList.get(i).getZ();
                }
            }
            if (this.hasMvalues) {
                this.mValues = new double[this.pointList.size()];
                for (i = 0; i < this.pointList.size(); ++i) {
                    this.mValues[i] = this.pointList.get(i).getM();
                }
            }
        }
        if (this.version == 2) {
            for (i = 0; i < this.version_one_shape_indexes.size(); ++i) {
                this.figureList.get(this.version_one_shape_indexes.get(i)).setFiguresAttribute((byte)1);
            }
        }
        if (this.figureList.size() > 0) {
            this.figures = new Figure[this.figureList.size()];
            for (i = 0; i < this.figureList.size(); ++i) {
                this.figures[i] = this.figureList.get(i);
            }
        }
        if (this.pointList.size() == 0 && this.shapeList.size() > 0 && this.shapeList.get(0).getOpenGISType() == 7) {
            this.shapeList.get(0).setFigureOffset(-1);
        }
        if (this.shapeList.size() > 0) {
            this.shapes = new Shape[this.shapeList.size()];
            for (i = 0; i < this.shapeList.size(); ++i) {
                this.shapes[i] = this.shapeList.get(i);
            }
        }
        if (this.segmentList.size() > 0) {
            this.segments = new Segment[this.segmentList.size()];
            for (i = 0; i < this.segmentList.size(); ++i) {
                this.segments[i] = this.segmentList.get(i);
            }
        }
        this.numberOfPoints = this.pointList.size();
        this.numberOfFigures = this.figureList.size();
        this.numberOfShapes = this.shapeList.size();
        this.numberOfSegments = this.segmentList.size();
    }

    protected void readOpenBracket() throws SQLServerException {
        this.skipWhiteSpaces();
        if (this.wkt.charAt(this.currentWktPos) == '(') {
            ++this.currentWktPos;
            this.skipWhiteSpaces();
        } else {
            this.throwIllegalWKTPosition();
        }
    }

    protected void readCloseBracket() throws SQLServerException {
        this.skipWhiteSpaces();
        if (this.wkt.charAt(this.currentWktPos) == ')') {
            ++this.currentWktPos;
            this.skipWhiteSpaces();
        } else {
            this.throwIllegalWKTPosition();
        }
    }

    protected boolean hasMoreToken() {
        this.skipWhiteSpaces();
        return this.currentWktPos < this.wkt.length();
    }

    protected void createSerializationProperties() {
        this.serializationProperties = 0;
        if (this.hasZvalues) {
            this.serializationProperties = (byte)(this.serializationProperties + 1);
        }
        if (this.hasMvalues) {
            this.serializationProperties = (byte)(this.serializationProperties + 2);
        }
        if (this.isValid) {
            this.serializationProperties = (byte)(this.serializationProperties + 4);
        }
        if (this.isSinglePoint) {
            this.serializationProperties = (byte)(this.serializationProperties + 8);
        }
        if (this.isSingleLineSegment) {
            this.serializationProperties = (byte)(this.serializationProperties + 16);
        }
        if (this.version == 2 && this.isLargerThanHemisphere) {
            this.serializationProperties = (byte)(this.serializationProperties + 32);
        }
    }

    protected int determineWkbCapacity() {
        int totalSize = 0;
        totalSize += 6;
        if (this.isSinglePoint || this.isSingleLineSegment) {
            totalSize += 16 * this.numberOfPoints;
            if (this.hasZvalues) {
                totalSize += 8 * this.numberOfPoints;
            }
            if (this.hasMvalues) {
                totalSize += 8 * this.numberOfPoints;
            }
            return totalSize;
        }
        int pointSize = 16;
        if (this.hasZvalues) {
            pointSize += 8;
        }
        if (this.hasMvalues) {
            pointSize += 8;
        }
        totalSize += 12;
        totalSize += this.numberOfPoints * pointSize;
        totalSize += this.numberOfFigures * 5;
        totalSize += this.numberOfShapes * 9;
        if (this.version == 2) {
            totalSize += 4;
            totalSize += this.numberOfSegments;
        }
        return totalSize;
    }

    protected void appendToWKTBuffers(Object o) {
        this.WKTsb.append(o);
        this.WKTsbNoZM.append(o);
    }

    protected void interpretSerializationPropBytes() {
        this.hasZvalues = (this.serializationProperties & 1) != 0;
        this.hasMvalues = (this.serializationProperties & 2) != 0;
        this.isValid = (this.serializationProperties & 4) != 0;
        this.isSinglePoint = (this.serializationProperties & 8) != 0;
        this.isSingleLineSegment = (this.serializationProperties & 0x10) != 0;
        this.isLargerThanHemisphere = (this.serializationProperties & 0x20) != 0;
    }

    protected void readNumberOfPoints() throws SQLServerException {
        if (this.isSinglePoint) {
            this.numberOfPoints = 1;
        } else if (this.isSingleLineSegment) {
            this.numberOfPoints = 2;
        } else {
            this.numberOfPoints = this.readInt();
            this.checkNegSize(this.numberOfPoints);
        }
    }

    protected void readZvalues() throws SQLServerException {
        this.zValues = new double[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.zValues[i] = this.readDouble();
        }
    }

    protected void readMvalues() throws SQLServerException {
        this.mValues = new double[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.mValues[i] = this.readDouble();
        }
    }

    protected void readNumberOfFigures() throws SQLServerException {
        this.numberOfFigures = this.readInt();
        this.checkNegSize(this.numberOfFigures);
    }

    protected void readFigures() throws SQLServerException {
        this.figures = new Figure[this.numberOfFigures];
        for (int i = 0; i < this.numberOfFigures; ++i) {
            byte fa = this.readByte();
            int po = this.readInt();
            this.figures[i] = new Figure(fa, po);
        }
    }

    protected void readNumberOfShapes() throws SQLServerException {
        this.numberOfShapes = this.readInt();
        this.checkNegSize(this.numberOfShapes);
    }

    protected void readShapes() throws SQLServerException {
        this.shapes = new Shape[this.numberOfShapes];
        for (int i = 0; i < this.numberOfShapes; ++i) {
            int po = this.readInt();
            int fo = this.readInt();
            byte ogt = this.readByte();
            this.shapes[i] = new Shape(po, fo, ogt);
        }
    }

    protected void readNumberOfSegments() throws SQLServerException {
        this.numberOfSegments = this.readInt();
        this.checkNegSize(this.numberOfSegments);
    }

    protected void readSegments() throws SQLServerException {
        this.segments = new Segment[this.numberOfSegments];
        for (int i = 0; i < this.numberOfSegments; ++i) {
            byte st = this.readByte();
            this.segments[i] = new Segment(st);
        }
    }

    protected void determineInternalType() {
        this.internalType = this.isSinglePoint ? InternalSpatialDatatype.POINT : (this.isSingleLineSegment ? InternalSpatialDatatype.LINESTRING : InternalSpatialDatatype.valueOf(this.shapes[0].getOpenGISType()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean checkEmptyKeyword(int parentShapeIndex, InternalSpatialDatatype isd, boolean isInsideAnotherShape) throws SQLServerException {
        String potentialEmptyKeyword;
        block8: {
            byte typeCode;
            block7: {
                block9: {
                    byte parentTypeCode;
                    block10: {
                        potentialEmptyKeyword = this.getNextStringToken().toUpperCase(Locale.US);
                        if (!potentialEmptyKeyword.equals("EMPTY")) break block8;
                        typeCode = 0;
                        if (!isInsideAnotherShape) break block9;
                        parentTypeCode = isd.getTypeCode();
                        if (parentTypeCode != 4) break block10;
                        typeCode = InternalSpatialDatatype.POINT.getTypeCode();
                        break block7;
                    }
                    if (parentTypeCode == 5) {
                        typeCode = InternalSpatialDatatype.LINESTRING.getTypeCode();
                        break block7;
                    } else if (parentTypeCode == 6) {
                        typeCode = InternalSpatialDatatype.POLYGON.getTypeCode();
                        break block7;
                    } else {
                        if (parentTypeCode != 7) {
                            String strError = SQLServerException.getErrString("R_illegalWKT");
                            throw new SQLServerException(strError, null, 0, null);
                        }
                        typeCode = InternalSpatialDatatype.GEOMETRYCOLLECTION.getTypeCode();
                    }
                    break block7;
                }
                typeCode = isd.getTypeCode();
            }
            this.shapeList.add(new Shape(parentShapeIndex, -1, typeCode));
            this.skipWhiteSpaces();
            if (this.currentWktPos < this.wkt.length() && this.wkt.charAt(this.currentWktPos) == ',') {
                ++this.currentWktPos;
                this.skipWhiteSpaces();
            }
            return true;
        }
        if (!potentialEmptyKeyword.equals("")) {
            this.throwIllegalWKTPosition();
        }
        return false;
    }

    protected void throwIllegalWKT() throws SQLServerException {
        String strError = SQLServerException.getErrString("R_illegalWKT");
        throw new SQLServerException(strError, null, 0, null);
    }

    protected void throwIllegalWKB() throws SQLServerException {
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
        Object[] msgArgs = new Object[]{JDBCType.VARBINARY};
        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
    }

    private void incrementPointNumStartIfPointNotReused(int pointEndIndex) {
        if (this.currentPointIndex + 1 >= pointEndIndex) {
            ++this.currentPointIndex;
        }
    }

    private void constructGeometryCollectionWKThelper(int shapeEndIndex) throws SQLServerException {
        block9: while (this.currentShapeIndex < shapeEndIndex) {
            InternalSpatialDatatype isd = InternalSpatialDatatype.valueOf(this.shapes[this.currentShapeIndex].getOpenGISType());
            int figureIndex = this.shapes[this.currentShapeIndex].getFigureOffset();
            int pointIndexEnd = this.numberOfPoints;
            int figureIndexEnd = this.numberOfFigures;
            int segmentIndexEnd = this.numberOfSegments;
            int shapeIndexEnd = this.numberOfShapes;
            int figureIndexIncrement = 0;
            int segmentIndexIncrement = 0;
            int shapeIndexIncrement = 0;
            int localCurrentSegmentIndex = 0;
            int localCurrentShapeIndex = 0;
            switch (isd) {
                case POINT: {
                    ++figureIndexIncrement;
                    ++this.currentShapeIndex;
                    break;
                }
                case LINESTRING: 
                case CIRCULARSTRING: {
                    ++figureIndexIncrement;
                    ++this.currentShapeIndex;
                    pointIndexEnd = this.figures[figureIndex + 1].getPointOffset();
                    break;
                }
                case POLYGON: 
                case CURVEPOLYGON: {
                    if (this.currentShapeIndex < this.shapes.length - 1) {
                        figureIndexEnd = this.shapes[this.currentShapeIndex + 1].getFigureOffset();
                    }
                    figureIndexIncrement = figureIndexEnd - this.currentFigureIndex;
                    ++this.currentShapeIndex;
                    localCurrentSegmentIndex = this.currentSegmentIndex;
                    if (isd.equals((Object)InternalSpatialDatatype.CURVEPOLYGON)) {
                        for (int i = this.currentFigureIndex; i < figureIndexEnd; ++i) {
                            if (this.figures[i].getFiguresAttribute() != 3) continue;
                            int pointOffsetEnd = i == this.figures.length - 1 ? this.numberOfPoints : this.figures[i + 1].getPointOffset();
                            int increment = this.calculateSegmentIncrement(localCurrentSegmentIndex, pointOffsetEnd - this.figures[i].getPointOffset());
                            segmentIndexIncrement += increment;
                            localCurrentSegmentIndex += increment;
                        }
                    }
                    segmentIndexEnd = localCurrentSegmentIndex;
                    break;
                }
                case MULTIPOINT: 
                case MULTILINESTRING: 
                case MULTIPOLYGON: {
                    int thisShapesParentOffset = this.shapes[this.currentShapeIndex].getParentOffset();
                    int tempShapeIndex = this.currentShapeIndex;
                    ++tempShapeIndex;
                    while (tempShapeIndex < this.shapes.length && this.shapes[tempShapeIndex].getParentOffset() != thisShapesParentOffset) {
                        if (tempShapeIndex != this.shapes.length - 1 && this.shapes[tempShapeIndex + 1].getFigureOffset() != -1) {
                            figureIndexEnd = this.shapes[tempShapeIndex + 1].getFigureOffset();
                        }
                        ++tempShapeIndex;
                    }
                    figureIndexIncrement = figureIndexEnd - this.currentFigureIndex;
                    shapeIndexIncrement = tempShapeIndex - this.currentShapeIndex;
                    shapeIndexEnd = tempShapeIndex;
                    break;
                }
                case GEOMETRYCOLLECTION: {
                    this.appendToWKTBuffers(isd.getTypeName());
                    if (this.shapes[this.currentShapeIndex].getFigureOffset() == -1) {
                        this.appendToWKTBuffers(" EMPTY");
                        ++this.currentShapeIndex;
                        if (this.currentShapeIndex >= shapeEndIndex) continue block9;
                        this.appendToWKTBuffers(", ");
                        continue block9;
                    }
                    this.appendToWKTBuffers("(");
                    int geometryCollectionParentIndex = this.shapes[this.currentShapeIndex].getParentOffset();
                    for (localCurrentShapeIndex = this.currentShapeIndex; localCurrentShapeIndex < this.shapes.length - 1 && this.shapes[localCurrentShapeIndex + 1].getParentOffset() > geometryCollectionParentIndex; ++localCurrentShapeIndex) {
                    }
                    ++this.currentShapeIndex;
                    this.constructGeometryCollectionWKThelper(++localCurrentShapeIndex);
                    if (this.currentShapeIndex < shapeEndIndex) {
                        this.appendToWKTBuffers("), ");
                        continue block9;
                    }
                    this.appendToWKTBuffers(")");
                    continue block9;
                }
                case COMPOUNDCURVE: {
                    int increment;
                    pointIndexEnd = this.currentFigureIndex == this.figures.length - 1 ? this.numberOfPoints : this.figures[this.currentFigureIndex + 1].getPointOffset();
                    segmentIndexIncrement = increment = this.calculateSegmentIncrement(this.currentSegmentIndex, pointIndexEnd - this.figures[this.currentFigureIndex].getPointOffset());
                    segmentIndexEnd = this.currentSegmentIndex + increment;
                    ++figureIndexIncrement;
                    ++this.currentShapeIndex;
                    break;
                }
                case FULLGLOBE: {
                    this.appendToWKTBuffers("FULLGLOBE");
                    break;
                }
            }
            this.constructWKT(this, isd, pointIndexEnd, figureIndexEnd, segmentIndexEnd, shapeIndexEnd);
            this.currentFigureIndex += figureIndexIncrement;
            this.currentSegmentIndex += segmentIndexIncrement;
            this.currentShapeIndex += shapeIndexIncrement;
            if (this.currentShapeIndex >= shapeEndIndex) continue;
            this.appendToWKTBuffers(", ");
        }
    }

    private int calculateSegmentIncrement(int segmentStart, int pointDifference) {
        int segmentIncrement = 0;
        while (pointDifference > 0) {
            switch (this.segments[segmentStart].getSegmentType()) {
                case 0: {
                    if (segmentStart == this.segments.length - 1 || --pointDifference < 1 || this.segments[segmentStart + 1].getSegmentType() == 0) break;
                    ++pointDifference;
                    break;
                }
                case 1: {
                    if (segmentStart == this.segments.length - 1 || (pointDifference -= 2) < 1 || this.segments[segmentStart + 1].getSegmentType() == 1) break;
                    ++pointDifference;
                    break;
                }
                case 2: {
                    if (segmentStart == this.segments.length - 1 || (pointDifference -= 2) < 1 || this.segments[segmentStart + 1].getSegmentType() == 0) break;
                    ++pointDifference;
                    break;
                }
                case 3: {
                    if (segmentStart == this.segments.length - 1 || (pointDifference -= 3) < 1 || this.segments[segmentStart + 1].getSegmentType() == 1) break;
                    ++pointDifference;
                    break;
                }
                default: {
                    return segmentIncrement;
                }
            }
            ++segmentStart;
            ++segmentIncrement;
        }
        return segmentIncrement;
    }

    private void skipFirstPointWkt() {
        for (int numOfCoordinates = 0; numOfCoordinates < 4; ++numOfCoordinates) {
            if (this.wkt.charAt(this.currentWktPos) == '-') {
                ++this.currentWktPos;
            }
            if (this.wkt.charAt(this.currentWktPos) == ')') break;
            while (this.currentWktPos < this.wkt.length() && (Character.isDigit(this.wkt.charAt(this.currentWktPos)) || this.wkt.charAt(this.currentWktPos) == '.' || this.wkt.charAt(this.currentWktPos) == 'E' || this.wkt.charAt(this.currentWktPos) == 'e')) {
                ++this.currentWktPos;
            }
            this.skipWhiteSpaces();
            if (this.wkt.charAt(this.currentWktPos) == ',') {
                ++this.currentWktPos;
                this.skipWhiteSpaces();
                ++numOfCoordinates;
                break;
            }
            this.skipWhiteSpaces();
        }
    }

    private void readComma() throws SQLServerException {
        this.skipWhiteSpaces();
        if (this.wkt.charAt(this.currentWktPos) == ',') {
            ++this.currentWktPos;
            this.skipWhiteSpaces();
        } else {
            this.throwIllegalWKTPosition();
        }
    }

    private void skipWhiteSpaces() {
        while (this.currentWktPos < this.wkt.length() && Character.isWhitespace(this.wkt.charAt(this.currentWktPos))) {
            ++this.currentWktPos;
        }
    }

    private void checkNegSize(int num) throws SQLServerException {
        if (num < 0) {
            this.throwIllegalWKB();
        }
    }

    private void readPoints(SQLServerSpatialDatatype type) throws SQLServerException {
        this.xValues = new double[this.numberOfPoints];
        this.yValues = new double[this.numberOfPoints];
        if (type instanceof Geometry) {
            for (int i = 0; i < this.numberOfPoints; ++i) {
                this.xValues[i] = this.readDouble();
                this.yValues[i] = this.readDouble();
            }
        } else {
            for (int i = 0; i < this.numberOfPoints; ++i) {
                this.yValues[i] = this.readDouble();
                this.xValues[i] = this.readDouble();
            }
        }
    }

    private void checkBuffer(int i) throws SQLServerException {
        if (this.buffer.remaining() < i) {
            this.throwIllegalWKB();
        }
    }

    private boolean checkSQLLength(int length) throws SQLServerException {
        if (null == this.wkt || this.wkt.length() < length) {
            this.throwIllegalWKTPosition();
        }
        return true;
    }

    private void throwIllegalWKTPosition() throws SQLServerException {
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_illegalWKTposition"));
        throw new SQLServerException(form.format(new Object[]{this.currentWktPos}), null, 0, null);
    }

    protected byte readByte() throws SQLServerException {
        this.checkBuffer(1);
        return this.buffer.get();
    }

    protected int readInt() throws SQLServerException {
        this.checkBuffer(4);
        return this.buffer.getInt();
    }

    protected double readDouble() throws SQLServerException {
        this.checkBuffer(8);
        return this.buffer.getDouble();
    }
}

