/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.httpsessions.HttpSessionToken;
import org.zaproxy.zap.utils.Enableable;

public class HttpSessionsParam
extends AbstractParam {
    private static final String DEFAULT_TOKENS_KEY = "httpsessions.tokens";
    private static final String ALL_DEFAULT_TOKENS_KEY = "httpsessions.tokens.token";
    private static final String TOKEN_NAME_KEY = "name";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String PROXY_ONLY_KEY = "httpsessions.proxyOnly";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "httpsessions.confirmRemoveToken";
    private static final String[] DEFAULT_TOKENS = new String[]{"asp.net_sessionid", "aspsessionid", "siteserver", "cfid", "cftoken", "jsessionid", "phpsessid", "sessid", "sid", "viewstate", "zenid"};
    private static final Logger log = LogManager.getLogger(HttpSessionsParam.class);
    private List<HttpSessionToken> defaultTokens = null;
    private List<String> defaultTokensEnabled = null;
    private boolean enabledProxyOnly = false;
    private boolean confirmRemove = true;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_DEFAULT_TOKENS_KEY);
            this.defaultTokens = new ArrayList<HttpSessionToken>(fields.size());
            this.defaultTokensEnabled = new ArrayList<String>(fields.size());
            ArrayList<String> tempTokensNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(TOKEN_NAME_KEY, "");
                if ("".equals(name) || tempTokensNames.contains(name)) continue;
                boolean enabled = sub.getBoolean(TOKEN_ENABLED_KEY, true);
                this.defaultTokens.add(new HttpSessionToken(name, enabled));
                tempTokensNames.add(name);
                if (!enabled) continue;
                this.defaultTokensEnabled.add(name);
            }
        }
        catch (ConversionException e) {
            this.defaultTokens = new ArrayList<HttpSessionToken>(DEFAULT_TOKENS.length);
            log.error("Error while parsing config file: " + e.getMessage(), (Throwable)e);
        }
        if (this.defaultTokens.size() == 0) {
            for (String tokenName : DEFAULT_TOKENS) {
                this.defaultTokens.add(new HttpSessionToken(tokenName));
                this.defaultTokensEnabled.add(tokenName);
            }
        }
        this.enabledProxyOnly = this.getBoolean(PROXY_ONLY_KEY, false);
        this.confirmRemove = this.getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
    }

    public final List<HttpSessionToken> getDefaultTokens() {
        return Collections.unmodifiableList(this.defaultTokens);
    }

    public final List<String> getDefaultTokensEnabled() {
        return Collections.unmodifiableList(this.defaultTokensEnabled);
    }

    public void setDefaultTokens(List<HttpSessionToken> tokens) {
        this.defaultTokens = tokens;
        this.saveDefaultTokens();
        this.defaultTokensEnabled = this.defaultTokens.stream().filter(Enableable::isEnabled).map(HttpSessionToken::getName).collect(Collectors.toList());
    }

    private void saveDefaultTokens() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DEFAULT_TOKENS_KEY);
        int size = this.defaultTokens.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "httpsessions.tokens.token(" + i + ").";
            HttpSessionToken token = this.defaultTokens.get(i);
            this.getConfig().setProperty(elementBaseKey + TOKEN_NAME_KEY, (Object)token.getName());
            this.getConfig().setProperty(elementBaseKey + TOKEN_ENABLED_KEY, (Object)token.isEnabled());
        }
    }

    public boolean addDefaultToken(String name, boolean enabled) {
        String normalisedName = HttpSessionsParam.getNormalisedSessionTokenName(name);
        if (!this.getDefaultToken(normalisedName).isPresent()) {
            this.defaultTokens.add(new HttpSessionToken(normalisedName, enabled));
            if (enabled) {
                this.defaultTokensEnabled.add(normalisedName);
            }
            this.saveDefaultTokens();
            return true;
        }
        return false;
    }

    private Optional<HttpSessionToken> getDefaultToken(String name) {
        return this.defaultTokens.stream().filter(e -> name.equalsIgnoreCase(e.getName())).findFirst();
    }

    public boolean setDefaultTokenEnabled(String name, boolean enabled) {
        Optional<HttpSessionToken> maybeToken = this.getDefaultToken(HttpSessionsParam.getNormalisedSessionTokenName(name));
        if (maybeToken.isPresent()) {
            HttpSessionToken token = maybeToken.get();
            if (token.isEnabled() == enabled) {
                return true;
            }
            if (token.isEnabled()) {
                this.defaultTokensEnabled.remove(token.getName());
            } else {
                this.defaultTokensEnabled.add(token.getName());
            }
            token.setEnabled(enabled);
            this.saveDefaultTokens();
            return true;
        }
        return false;
    }

    private static String getNormalisedSessionTokenName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public boolean removeDefaultToken(String name) {
        String normalisedName = HttpSessionsParam.getNormalisedSessionTokenName(name);
        Optional<HttpSessionToken> maybeToken = this.getDefaultToken(normalisedName);
        if (maybeToken.isPresent()) {
            this.defaultTokens.remove(maybeToken.get());
            this.defaultTokensEnabled.remove(normalisedName);
            this.saveDefaultTokens();
            return true;
        }
        return false;
    }

    public boolean isEnabledProxyOnly() {
        return this.enabledProxyOnly;
    }

    public void setEnabledProxyOnly(boolean enabledProxyOnly) {
        this.enabledProxyOnly = enabledProxyOnly;
        this.getConfig().setProperty(PROXY_ONLY_KEY, (Object)enabledProxyOnly);
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveDefaultToken() {
        return this.confirmRemove;
    }

    @ZapApiIgnore
    public void setConfirmRemoveDefaultToken(boolean confirmRemove) {
        this.confirmRemove = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)confirmRemove);
    }
}

