/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sa;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Properties;
import org.graalvm.visualvm.sa.Agent;
import org.graalvm.visualvm.sa.Arguments;
import org.graalvm.visualvm.sa.SAObject;
import org.graalvm.visualvm.sa.StackTrace;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.openide.ErrorManager;

public class SaModelImpl
extends SaModel {
    private Agent agent;
    private int pid;
    String executable;
    String core;
    private Properties sysProp;
    private String jvmFlags;
    private String jvmArgs;
    private String commandLine;

    SaModelImpl(File jdkHome, File saLib, int id) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, InvocationTargetException, NoSuchMethodException {
        this.agent = Agent.getAgent(jdkHome, saLib);
        this.pid = id;
        this.readData();
    }

    SaModelImpl(File jdkHome, File saLib, File execFile, File coreFile) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, MalformedURLException, NoSuchMethodException {
        this.agent = Agent.getAgent(jdkHome, saLib);
        this.executable = execFile.getAbsolutePath();
        this.core = coreFile.getAbsolutePath();
        this.readData();
    }

    public Properties getSystemProperties() {
        return this.sysProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean takeHeapDump(String file) {
        try {
            Agent agent = this.agent;
            synchronized (agent) {
                try {
                    if (!this.attach()) return false;
                    SAObject hprofWrite = this.agent.getHeapHprofBinWriter();
                    hprofWrite.invoke("write", file);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.agent.detach();
                }
            }
        }
        catch (Exception ex) {
            Throwable e = ex.getCause();
            ErrorManager.getDefault().notify(e == null ? ex : e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String takeThreadDump() {
        try {
            Agent agent = this.agent;
            synchronized (agent) {
                try {
                    if (!this.attach()) return null;
                    String string = new StackTrace(this.agent.getVM()).getStackTrace();
                    return string;
                }
                finally {
                    this.agent.detach();
                }
            }
        }
        catch (Exception ex) {
            Throwable e = ex.getCause();
            ErrorManager.getDefault().notify(e == null ? ex : e);
        }
        return null;
    }

    public String getJvmFlags() {
        return this.jvmFlags;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public String getJavaCommand() {
        return this.commandLine;
    }

    private boolean attach() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.core == null) {
            return this.agent.attach(this.pid);
        }
        return this.agent.attach(this.executable, this.core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Agent agent = this.agent;
        synchronized (agent) {
            try {
                if (this.attach()) {
                    Arguments args = this.agent.getArguments();
                    this.jvmFlags = args.getJVMFlags();
                    this.jvmArgs = args.getJVMArgs();
                    this.commandLine = args.getJavaCommand();
                    this.sysProp = (Properties)this.agent.getVM().getSystemProperties().clone();
                }
            }
            finally {
                this.agent.detach();
            }
        }
    }
}

