/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.management.RuntimeMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.impl.JmxHeartbeat;
import org.graalvm.visualvm.jmx.impl.ProxyClient;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;

public final class JmxApplication
extends Application {
    private static final Logger LOGGER = Logger.getLogger(JmxApplication.class.getName());
    static final String PROPERTY_DISABLE_HEARTBEAT = "prop_disable_heartbeat";
    private int pid = -1;
    private final JMXServiceURL url;
    private final EnvironmentProvider envProvider;
    private final Storage storage;
    private Jvm jvm;
    private JmxModel jmxModel;
    private ProxyClient client;
    private PropertyChangeListener modelListener;
    private final Object connectionLock = new Object();

    public JmxApplication(Host host, JMXServiceURL url, EnvironmentProvider envProvider, Storage storage) {
        super(host, JmxApplication.createId(url, envProvider, storage), 0);
        this.url = url;
        this.envProvider = envProvider;
        this.storage = storage;
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.url;
    }

    public EnvironmentProvider getEnvironmentProvider() {
        return this.envProvider;
    }

    public int getPid() {
        String name;
        RuntimeMXBean rt;
        JvmMXBeans mxbeans;
        if (this.pid == -1 && this.getState() == 1 && this.jmxModel != null && this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)this.jmxModel)) != null && (rt = mxbeans.getRuntimeMXBean()) != null && (name = rt.getName()) != null && name.indexOf("@") != -1) {
            name = name.substring(0, name.indexOf("@"));
            this.pid = Integer.parseInt(name);
        }
        return this.pid;
    }

    public boolean supportsUserRemove() {
        return true;
    }

    protected boolean supportsFinishedRemove() {
        return this.storage == null;
    }

    protected Storage createStorage() {
        return this.storage != null ? this.storage : super.createStorage();
    }

    protected void remove() {
        if (this.getStorage().directoryExists()) {
            Utils.delete((File)this.getStorage().getDirectory(), (boolean)true);
        }
    }

    public String toString() {
        return "JmxApplication [id: " + this.getId() + "]";
    }

    private static String createId(JMXServiceURL url, EnvironmentProvider envProvider, Storage storage) {
        String urlId = url.toString();
        if (envProvider == null) {
            return urlId;
        }
        String envId = envProvider.getEnvironmentId(storage);
        if (envId == null || "".equals(envId)) {
            return urlId;
        }
        return envId + "-" + urlId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProxyClient getProxyClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean tryConnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.isConnected()) {
                return true;
            }
            try {
                ProxyClient newClient = new ProxyClient(this);
                newClient.connect();
                if (newClient.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
                    this.client = newClient;
                    this.setStateImpl(1);
                    this.jmxModel = JmxModelFactory.getJmxModelFor((Application)this);
                    this.jvm = JvmFactory.getJVMFor((Application)this);
                    this.modelListener = new PropertyChangeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getNewValue() != JmxModel.ConnectionState.CONNECTED) {
                                Object object = JmxApplication.this.connectionLock;
                                synchronized (object) {
                                    JmxApplication.this.setStateImpl(0);
                                }
                            }
                        }
                    };
                    this.jmxModel.addPropertyChangeListener(this.modelListener);
                    return true;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "ProxyClient.connect", ex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disconnect() {
        ProxyClient _client;
        this.disableHeartbeat();
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.isConnected()) {
                return;
            }
            _client = this.client;
        }
        _client.disconnect();
    }

    private boolean isConnected() {
        return this.client != null && this.client.getConnectionState() == JmxModel.ConnectionState.CONNECTED;
    }

    private void setStateImpl(int newState) {
        if (newState != 1) {
            this.pid = -1;
            this.jvm = null;
            if (this.jmxModel != null && this.modelListener != null) {
                this.jmxModel.removePropertyChangeListener(this.modelListener);
            }
            this.jmxModel = null;
            this.client = null;
            if (JmxApplication.supportsHeartbeat(this)) {
                JmxHeartbeat.scheduleLazily(this);
            }
        }
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableHeartbeat() {
        this.getStorage().clearCustomProperty(PROPERTY_DISABLE_HEARTBEAT);
        if (JmxApplication.supportsHeartbeat(this)) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.isConnected()) {
                    return;
                }
            }
            JmxHeartbeat.scheduleImmediately(this);
        }
    }

    final void disableHeartbeat() {
        this.getStorage().setCustomProperty(PROPERTY_DISABLE_HEARTBEAT, Boolean.TRUE.toString());
    }

    final boolean isHeartbeatDisabled() {
        return Boolean.TRUE.toString().equals(this.getStorage().getCustomProperty(PROPERTY_DISABLE_HEARTBEAT));
    }

    static boolean supportsHeartbeat(JmxApplication app) {
        return !app.isRemoved() && !app.isHeartbeatDisabled();
    }
}

