/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.api;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public final class StringDecoder {
    private final byte coder;
    private final List<String> values;
    private int HI_BYTE_SHIFT;
    private int LO_BYTE_SHIFT;

    public StringDecoder(Heap heap, byte c, List<String> val) {
        this.coder = c;
        this.values = val;
        if (this.coder == 1) {
            if (heap != null) {
                JavaClass utf16Class = heap.getJavaClassByName("java.lang.StringUTF16");
                this.HI_BYTE_SHIFT = (Integer)utf16Class.getValueOfStaticField("HI_BYTE_SHIFT");
                this.LO_BYTE_SHIFT = (Integer)utf16Class.getValueOfStaticField("LO_BYTE_SHIFT");
            } else {
                this.HI_BYTE_SHIFT = 0;
                this.LO_BYTE_SHIFT = 8;
            }
        }
    }

    public int getStringLength() {
        int size = this.values.size();
        switch (this.coder) {
            case -1: {
                return size;
            }
            case 0: {
                return size;
            }
            case 1: {
                return size / 2;
            }
        }
        return size;
    }

    public String getValueAt(int index) {
        switch (this.coder) {
            case -1: {
                return this.values.get(index);
            }
            case 0: {
                char ch = (char)(Byte.valueOf(this.values.get(index)) & 0xFF);
                return String.valueOf(ch);
            }
            case 1: {
                byte hiByte = Byte.valueOf(this.values.get(index *= 2));
                byte lowByte = Byte.valueOf(this.values.get(index + 1));
                char ch = (char)((hiByte & 0xFF) << this.HI_BYTE_SHIFT | (lowByte & 0xFF) << this.LO_BYTE_SHIFT);
                return String.valueOf(ch);
            }
        }
        return "?";
    }
}

