/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.ui.UIUtils;

public abstract class TruffleObjectPreviewPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private InstanceScrollPane component;

    public TruffleObjectPreviewPlugin(HeapContext context) {
        super(Bundle.TruffleObjectPreviewPlugin_Name(), Bundle.TruffleObjectPreviewPlugin_Description(), Icons.getIcon((String)"HeapWalkerIcons.Properties"));
        this.heap = context.getFragment().getHeap();
    }

    protected abstract boolean supportsNode(HeapViewerNode var1);

    protected abstract Instance getPreviewInstance(HeapViewerNode var1);

    protected void closed() {
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        this.component.showInstance(this.supportsNode(node) ? this.getPreviewInstance(node) : null);
    }

    protected JComponent createComponent() {
        if (this.component == null) {
            this.component = new InstanceScrollPane();
        }
        return this.component;
    }

    private class InstanceScrollPane
    extends JScrollPane {
        private Instance selectedInstance = null;
        private boolean instancePending = false;

        InstanceScrollPane() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setViewportBorder(BorderFactory.createEmptyBorder());
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && InstanceScrollPane.this.instancePending && InstanceScrollPane.this.isShowing()) {
                        InstanceScrollPane.this.showInstanceImpl();
                    }
                }
            });
            this.showInstanceImpl();
        }

        void showInstance(Instance instance) {
            if (this.selectedInstance == instance) {
                return;
            }
            this.selectedInstance = instance;
            if (this.isShowing()) {
                this.showInstanceImpl();
            } else {
                this.instancePending = true;
            }
        }

        private void showInstanceImpl() {
            Object instanceView;
            Object object = instanceView = this.selectedInstance == null ? null : DetailsSupport.getDetailsView((Instance)this.selectedInstance);
            if (instanceView == null) {
                JLabel noDetails = new JLabel(Bundle.TruffleObjectPreviewPlugin_NoDetails(), 0);
                noDetails.setEnabled(false);
                instanceView = new JPanel(new BorderLayout());
                ((JComponent)instanceView).setOpaque(true);
                ((JComponent)instanceView).setBackground(UIUtils.getProfilerResultsBackground());
                ((Container)instanceView).add((Component)noDetails, "Center");
            }
            this.setViewportView((Component)instanceView);
            this.instancePending = false;
        }
    }
}

