/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.fileio;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.fileio.FileIONode;
import org.graalvm.visualvm.jfr.views.fileio.FileIOViewSupport;
import org.graalvm.visualvm.jfr.views.fileio.JFRSnapshotFileIOViewProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotFileIOView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/fileio.png";
    private JFRModel model;
    private DataViewComponent dvc;
    private FileIOViewSupport.MasterViewSupport masterView;
    private FileIOViewSupport.DataViewSupport dataView;

    JFRSnapshotFileIOView(JFRSnapshot jfrSnapshot) {
        super((DataSource)jfrSnapshot, "File IO", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 33, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        this.masterView = new FileIOViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                this.changeAggregation(FileIOViewSupport.Aggregation.FILE, FileIOViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(FileIOViewSupport.Aggregation primary, FileIOViewSupport.Aggregation secondary) {
                JFRSnapshotFileIOView.this.setAggregation(primary, secondary);
            }
        };
        boolean hasEvents = this.model != null && this.model.containsEvent(JFRSnapshotFileIOViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new FileIOViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final FileIOViewSupport.Aggregation primary, final FileIOViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new FileIONode.Root(), false);
        new RequestProcessor("JFR FileIO Initializer").post(new Runnable(){

            @Override
            public void run() {
                final FileIONode.Root root = new FileIONode.Root(primary, secondary);
                JFRSnapshotFileIOView.this.model.visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFRSnapshotFileIOView.this.dataView.setData(root, !FileIOViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotFileIOView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

