/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileObjectLkp;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class MultiFileObject
extends AbstractFolder
implements FileObject.PriorityFileChangeListener {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    static final String WEIGHT_ATTRIBUTE = "weight";
    private static final FileSystem.AtomicAction markAtomicAction = new FileSystem.AtomicAction(){

        @Override
        public void run() {
        }
    };
    static final ThreadLocal<FileObject> attrAskedFileObject = new ThreadLocal();
    private Set delegates;
    private FileObject leader;
    private Reference<MfLock> lock;
    protected Throwable lockedBy;
    private FileChangeListener weakL = (FileChangeListener)WeakListeners.create(FileObject.PriorityFileChangeListener.class, FileChangeListener.class, (EventListener)this, null);
    private static Map<MultiFileObject, AttributeCache> fo2AttribCache = new WeakHashMap<MultiFileObject, AttributeCache>();
    private static final Set<String> SPECIAL_ATTR_NAMES = new HashSet<String>(Arrays.asList("removeWritables", "weight", "java.io.File"));

    public MultiFileObject(MultiFileSystem multiFileSystem, MultiFileObject multiFileObject, String string) {
        super(multiFileSystem, multiFileObject, string);
        this.update();
        if (this.leader == null) {
            this.leader = new AbstractFileObject.Invalid(string);
            this.validFlag = false;
        }
    }

    public MultiFileObject(MultiFileSystem multiFileSystem) {
        this(multiFileSystem, null, "");
    }

    public FileSystem getLeaderFileSystem() throws FileStateInvalidException {
        return this.leader.getFileSystem();
    }

    static synchronized void freeAllAttribCaches() {
        fo2AttribCache.clear();
    }

    private void freeAttribCache() {
        this.getAttributeCache().free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeCache getAttributeCache() {
        Class<MultiFileObject> clazz = MultiFileObject.class;
        synchronized (MultiFileObject.class) {
            AttributeCache attributeCache = fo2AttribCache.get(this);
            if (attributeCache == null) {
                attributeCache = new AttributeCache();
                fo2AttribCache.put(this, attributeCache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return attributeCache;
        }
    }

    private boolean setAttributeOnFO(FileObject fileObject, String string, Object object, boolean bl) throws IOException {
        if (fileObject instanceof AbstractFolder) {
            ((AbstractFolder)fileObject).setAttribute(string, object, false);
        } else {
            bl = bl && fileObject.isRoot();
            fileObject.setAttribute(string, object);
        }
        return bl;
    }

    private void update() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        FileSystem[] fileSystemArray = multiFileSystem.getDelegates();
        Set set = this.delegates == null ? Collections.emptySet() : this.delegates;
        HashSet<FileObject> hashSet = new HashSet<FileObject>(fileSystemArray.length * 2);
        Number number = 0;
        Object object = null;
        String string = this.getPath();
        FileSystem fileSystem = multiFileSystem.writableLayer(string);
        for (int i = 0; i < fileSystemArray.length; ++i) {
            Number number2;
            FileObject fileObject;
            if (fileSystemArray[i] == null || (fileObject = multiFileSystem.findResourceOn(fileSystemArray[i], string)) == null) continue;
            hashSet.add(fileObject);
            if (!set.remove(fileObject)) {
                fileObject.addFileChangeListener(this.weakL);
            }
            if (!fileObject.isValid()) continue;
            Number number3 = number2 = fileObject.isRoot() && !multiFileSystem.canHaveRootAttributeOnReadOnlyFS(WEIGHT_ATTRIBUTE) ? (Number)0 : (Number)MultiFileObject.weightOf(fileObject, fileSystem);
            if (object != null && !(number2.doubleValue() > ((Number)number).doubleValue())) continue;
            object = fileObject;
            number = number2;
        }
        for (FileObject fileObject : set) {
            fileObject.removeFileChangeListener(this.weakL);
        }
        if (object != null) {
            if (!object.equals(this.leader) && this.leader != null) {
                if (this.isData() && this.isValid()) {
                    this.fileChanged0(new FileEvent(this));
                }
                this.getMultiFileSystem().notifyMigration(this);
            }
            this.leader = object;
        }
        this.delegates = hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAll() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        try {
            multiFileSystem.beginAtomicAction();
            Enumeration<AbstractFolder> enumeration = this.existingSubFiles(true);
            while (enumeration.hasMoreElements()) {
                MultiFileObject multiFileObject = (MultiFileObject)enumeration.nextElement();
                if (multiFileObject.isFolder() && !multiFileObject.isInitialized()) continue;
                multiFileObject.freeAttribCache();
                multiFileObject.superRefresh(true);
            }
        }
        finally {
            multiFileSystem.finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAllAfterSetDelegates(FileSystem[] fileSystemArray) {
        try {
            this.getMultiFileSystem().beginAtomicAction();
            FileSystem[] fileSystemArray2 = this.getMultiFileSystem().getDelegates();
            Enumeration<AbstractFolder> enumeration = this.existingSubFiles(true);
            while (enumeration.hasMoreElements()) {
                MultiFileObject multiFileObject = (MultiFileObject)enumeration.nextElement();
                if (multiFileObject.isFolder() && !multiFileObject.isInitialized()) continue;
                if (multiFileObject.hasListeners()) {
                    String string = multiFileObject.getPath();
                    FileObject fileObject = this.findLeader(fileSystemArray, string);
                    FileObject fileObject2 = this.findLeader(fileSystemArray2, string);
                    if (fileObject != null && fileObject2 != null && !fileObject.equals(fileObject2)) {
                        multiFileObject.fileAttributeChanged0(new FileAttributeEvent((FileObject)multiFileObject, null, null, null));
                    }
                }
                multiFileObject.freeAttribCache();
                multiFileObject.refresh(true);
            }
        }
        finally {
            this.getMultiFileSystem().finishAtomicAction();
        }
    }

    private void refreshAfterEvent(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        this.superRefresh(false);
        MultiFileObject multiFileObject = (MultiFileObject)this.getFileObject(fileObject.getName(), fileObject.getExt());
        if (multiFileObject != null) {
            multiFileObject.superRefresh(false);
        }
    }

    private void superRefresh(boolean bl) {
        super.refresh(bl);
    }

    private FileObject findLeader(FileSystem[] fileSystemArray, String string) {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        Number number = 0;
        FileObject fileObject = null;
        FileSystem fileSystem = multiFileSystem.writableLayer(string);
        for (FileSystem fileSystem2 : fileSystemArray) {
            FileObject fileObject2;
            if (fileSystem2 == null || (fileObject2 = multiFileSystem.findResourceOn(fileSystem2, string)) == null) continue;
            Number number2 = MultiFileObject.weightOf(fileObject2, fileSystem);
            if (fileObject != null && !(number2.doubleValue() > ((Number)number).doubleValue())) continue;
            fileObject = fileObject2;
            number = number2;
        }
        return fileObject;
    }

    private static Number weightOf(FileObject fileObject, FileSystem fileSystem) {
        try {
            if (fileObject.getFileSystem() == fileSystem) {
                return Double.MAX_VALUE;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        Object object = fileObject.getAttribute(WEIGHT_ATTRIBUTE);
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object == null) {
            return 0;
        }
        try {
            Logger.getLogger(MultiFileObject.class.getName()).log(Level.WARNING, "File {0} in {1} has nonnumeric weight {2} of type {3}", new Object[]{fileObject.getPath(), fileObject.getFileSystem(), object, object.getClass().getName()});
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return 0;
    }

    private MultiFileSystem getMultiFileSystem() {
        return (MultiFileSystem)this.getFileSystem();
    }

    private MultiFileObject getMultiChild(String string) {
        return (MultiFileObject)this.getChild(string);
    }

    private FileObject writable(boolean bl) throws IOException {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        FileSystem fileSystem = multiFileSystem.createWritableOn(this.getPath());
        if (fileSystem != this.leader.getFileSystem()) {
            FileObject fileObject;
            if (this.leader.isFolder()) {
                this.leader = FileUtil.createFolder(this.root(fileSystem), this.getPath());
            } else {
                fileObject = FileUtil.createFolder(this.root(fileSystem), this.getParent().getPath());
                this.leader = bl ? this.leader.copy(fileObject, this.leader.getName(), this.leader.getExt()) : fileObject.createData(this.leader.getNameExt());
            }
            FileObject fileObject2 = fileObject = this.lock == null ? null : this.lock.get();
            if (fileObject != null) {
                ((MfLock)((Object)fileObject)).addLock(this.leader);
            }
        }
        return this.leader;
    }

    private Enumeration<FileObject> delegates() {
        return this.getMultiFileSystem().delegates(this.getPath());
    }

    private static void updateFoldersLock(FileObject fileObject) throws IOException {
        while (fileObject != null) {
            MfLock mfLock;
            MultiFileObject multiFileObject = (MultiFileObject)fileObject;
            MfLock mfLock2 = mfLock = multiFileObject.lock == null ? null : multiFileObject.lock.get();
            if (mfLock != null) {
                multiFileObject.writable(true);
            }
            fileObject = fileObject.getParent();
        }
    }

    @Override
    protected final String[] list() {
        String[] stringArray;
        Properties properties = new Properties();
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>(101);
        Enumeration<FileObject> enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (stringArray == null || !stringArray.isFolder()) continue;
            FileObject[] fileObjectArray = stringArray.getChildren();
            Properties properties2 = null;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string = fileObjectArray[i].getNameExt();
                if (string.endsWith("_hidden")) {
                    String string2 = string.substring(0, string.length() - "_hidden".length());
                    if (properties2 == null) {
                        properties2 = new Properties();
                        properties2.putAll((Map<?, ?>)properties);
                    }
                    properties2.setProperty(string2, string2);
                    if (!this.getMultiFileSystem().getPropagateMasks()) continue;
                }
                if (hashSet.contains(string) || properties.getProperty(string) != null) continue;
                hashSet.add(string);
                linkedList.add(string);
            }
            if (properties2 == null) continue;
            properties = properties2;
        }
        if (this.getMultiFileSystem().getPropagateMasks()) {
            linkedList.removeAll(properties.keySet());
        }
        stringArray = linkedList.toArray(new String[linkedList.size()]);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                this.update();
                super.refresh(string, string2, bl, bl2);
            }
            this.validFlag &= this.leader.isValid();
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    protected final AbstractFolder createFile(String string) {
        return new MultiFileObject(this.getMultiFileSystem(), this, string);
    }

    @Override
    public boolean isFolder() {
        return this.parent == null || this.leader.isFolder();
    }

    @Override
    public Date lastModified() {
        return this.leader.lastModified();
    }

    @Override
    public boolean isData() {
        return this.leader.isData();
    }

    @Override
    public boolean isVirtual() {
        return this.leader.isVirtual();
    }

    @Override
    @Deprecated
    public boolean isReadOnly() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (multiFileSystem.isReadOnly()) {
            return true;
        }
        if (this.leader.isReadOnly()) {
            try {
                FileSystem fileSystem = multiFileSystem.createWritableOn(this.getPath());
                return fileSystem == this.leader.getFileSystem();
            }
            catch (IOException iOException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canWrite() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (multiFileSystem.isReadOnly()) {
            return false;
        }
        if (!this.leader.canWrite()) {
            try {
                FileSystem fileSystem = multiFileSystem.createWritableOn(this.getPath());
                return fileSystem != this.leader.getFileSystem();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getMIMEType() {
        return this.leader.getMIMEType();
    }

    @Override
    public long getSize() {
        return this.leader.getSize();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return this.leader.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        try {
            FileLock fileLock2;
            FileObject fileObject;
            this.getFileSystem().beginAtomicAction(markAtomicAction);
            Object object = this;
            synchronized (object) {
                MfLock mfLock = this.testLock(fileLock);
                fileObject = this.writable(false);
                fileLock2 = mfLock.findLock(fileObject);
            }
            object = fileObject.getOutputStream(fileLock2);
            return object;
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lock != null && this.lock.get() != null;
    }

    @Override
    public synchronized FileLock lock() throws IOException {
        Object object;
        if (this.lock != null && (object = (FileLock)this.lock.get()) != null) {
            FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(this.getPath());
            fileAlreadyLockedException.initCause(this.lockedBy);
            throw fileAlreadyLockedException;
        }
        object = this.getMultiFileSystem().createLocksOn(this.getPath());
        MfLock mfLock = new MfLock(this.leader, this.delegates(), (Set<? extends FileSystem>)object);
        this.lock = new WeakReference<MfLock>(mfLock);
        assert ((this.lockedBy = new Throwable("Locked by:")) != null);
        return mfLock;
    }

    private MfLock testLock(FileLock fileLock) throws IOException {
        if (this.lock == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_InvalidLock", (Object)fileLock, (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), this.lock, (Object[])new Object[0]));
        }
        if (this.lock.get() != fileLock) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_InvalidLock", (Object)fileLock, (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), (Object)this.lock.get(), (Object[])new Object[0]));
        }
        return (MfLock)fileLock;
    }

    @Override
    @Deprecated
    public void setImportant(boolean bl) {
        Enumeration<FileObject> enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            fileObject.setImportant(bl);
        }
        if (!bl) {
            this.getMultiFileSystem().markUnimportant(this);
        }
    }

    private static final Object voidify(Object object) {
        if (object == null) {
            return new VoidValue(0);
        }
        if (object instanceof VoidValue) {
            VoidValue voidValue = (VoidValue)object;
            return new VoidValue(voidValue.level + 1);
        }
        return object;
    }

    private static final Object devoidify(Object object) {
        if (object instanceof VoidValue) {
            VoidValue voidValue = (VoidValue)object;
            if (voidValue.level == 0) {
                return null;
            }
            return new VoidValue(voidValue.level - 1);
        }
        return object;
    }

    @Override
    public Object getAttribute(String string) {
        String string2 = this.getPath();
        if (string2.isEmpty() && string.indexOf(92) >= 0) {
            return null;
        }
        return this.getAttribute(string, string2);
    }

    private final Object getAttribute(String string, String string2) {
        boolean bl;
        Object object;
        FileSystem fileSystem;
        String string3 = string2.length() == 0 ? null : string2.replace('/', '\\') + '\\' + string;
        Serializable serializable = this.getAttributeCache().getDelegate();
        Object object2 = this.getAttributeCache().getAttributeName();
        if (serializable != null && !serializable.equals(this) && ((String)object2).equals(string)) {
            if (((FileObject)serializable).isRoot() && string3 != null) {
                try {
                    fileSystem = ((FileObject)serializable).getFileSystem();
                    if ((!fileSystem.isReadOnly() || this.getMultiFileSystem().canHaveRootAttributeOnReadOnlyFS(string3)) && (object = this.getAttribute((FileObject)(serializable = fileSystem.getRoot()), string3, "")) != null) {
                        return MultiFileObject.devoidify(object);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if ((object = this.getAttribute((FileObject)serializable, string, ((FileObject)serializable).getPath())) != null) {
                return MultiFileObject.devoidify(object);
            }
        }
        object = this.getMultiFileSystem().getDelegates();
        serializable = Integer.valueOf(0);
        object2 = null;
        fileSystem = this.getMultiFileSystem().writableLayer(string2);
        boolean bl2 = bl = this.isFolder() && "revealEntries".equals(string) && fileSystem != null && !fileSystem.isReadOnly();
        if (bl) {
            return this.collectRevealedFiles();
        }
        for (int i = 0; i < ((FileSystem[])object).length; ++i) {
            Number number;
            Object object3;
            if (object[i] == null) continue;
            FileObject fileObject = this.getMultiFileSystem().findResourceOn(object[i], string2);
            if (fileObject != null && (object3 = this.getAttribute(fileObject, string, fileObject.getPath())) != null) {
                if (SPECIAL_ATTR_NAMES.contains(string)) {
                    return MultiFileObject.devoidify(object3);
                }
                number = MultiFileObject.weightOf(fileObject, fileSystem);
                if (object2 == null || number.doubleValue() > ((Number)serializable).doubleValue()) {
                    this.getAttributeCache().setDelegate(fileObject);
                    this.getAttributeCache().setAttributeName(string);
                    object2 = object3;
                    serializable = number;
                }
            }
            if (string3 == null || object[i].isReadOnly() && !this.getMultiFileSystem().canHaveRootAttributeOnReadOnlyFS(string3) || (object3 = this.getAttribute(fileObject = object[i].getRoot(), string3, "")) == null) continue;
            number = MultiFileObject.weightOf(fileObject, fileSystem);
            if (object2 != null && !(number.doubleValue() > ((Number)serializable).doubleValue())) continue;
            this.getAttributeCache().setDelegate(fileObject);
            this.getAttributeCache().setAttributeName(string);
            object2 = object3;
            serializable = number;
        }
        return MultiFileObject.devoidify(object2);
    }

    private static boolean sameFullName(FileObject fileObject, FileObject fileObject2) {
        while (fileObject != null && fileObject2 != null) {
            if (!fileObject.getNameExt().equals(fileObject2.getNameExt())) {
                return false;
            }
            fileObject = fileObject.getParent();
            fileObject2 = fileObject2.getParent();
        }
        return fileObject == null && fileObject2 == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(FileObject fileObject, String string, String string2) {
        Object object;
        FileObject fileObject2 = attrAskedFileObject.get();
        if (fileObject2 == null || !MultiFileObject.sameFullName(fileObject2, this)) {
            attrAskedFileObject.set(this);
        }
        try {
            object = fileObject instanceof MultiFileObject ? ((MultiFileObject)fileObject).getAttribute(string, string2) : (fileObject instanceof AbstractFileObject ? ((AbstractFileObject)fileObject).getAttribute(string, string2) : fileObject.getAttribute(string));
        }
        finally {
            attrAskedFileObject.set(fileObject2);
        }
        return object;
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        this.setAttribute(string, object, true);
    }

    @Override
    void setAttribute(String string, Object object, boolean bl) throws IOException {
        String string2 = this.getPath();
        FileSystem fileSystem = this.getMultiFileSystem().createWritableOn(string2);
        FileObject fileObject = this.getMultiFileSystem().findResourceOn(fileSystem, string2);
        Object object2 = null;
        String string3 = string;
        if (bl && (object2 = this.getAttribute(string)) == object) {
            return;
        }
        if (fileObject == null) {
            fileObject = fileSystem.getRoot();
            string3 = string2.replace('/', '\\') + '\\' + string;
        }
        this.getAttributeCache().setDelegate(fileObject);
        this.getAttributeCache().setAttributeName(string3);
        if (object == null) {
            bl = this.setAttributeOnFO(fileObject, string3, null, bl);
            if (fileObject.getAttribute(string3) != null) {
                bl = this.setAttributeOnFO(fileObject, string3, MultiFileObject.voidify(null), bl);
            }
        } else {
            bl = this.setAttributeOnFO(fileObject, string3, MultiFileObject.voidify(object), bl);
        }
        if (bl && object2 != object && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent((FileObject)this, string, object2, object));
        }
    }

    @Override
    public Enumeration<String> getAttributes() {
        return this.getAttributes(this.getPath());
    }

    private final Enumeration<String> getAttributes(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        FileSystem[] fileSystemArray = this.getMultiFileSystem().getDelegates();
        boolean bl = string.length() == 0;
        String string2 = bl ? null : string.replace('/', '\\') + '\\';
        for (int i = 0; i < fileSystemArray.length; ++i) {
            String string3;
            Enumeration<String> enumeration;
            if (fileSystemArray[i] == null) continue;
            FileObject fileObject = this.getMultiFileSystem().findResourceOn(fileSystemArray[i], string);
            if (fileObject != null) {
                enumeration = fileObject.getAttributes();
                while (enumeration.hasMoreElements()) {
                    string3 = enumeration.nextElement();
                    if (bl && string3.indexOf(92) >= 0) continue;
                    hashSet.add(string3);
                }
            }
            if (string2 == null) continue;
            fileObject = fileSystemArray[i].getRoot();
            enumeration = fileObject instanceof MultiFileObject ? ((MultiFileObject)fileObject).getAttributes("") : (fileObject instanceof AbstractFileObject ? ((AbstractFileObject)fileObject).getAttributes("") : fileObject.getAttributes());
            while (enumeration.hasMoreElements()) {
                string3 = enumeration.nextElement();
                if (!string3.startsWith(string2) || string3.substring(string2.length()).indexOf(92) != -1) continue;
                hashSet.add(string3.substring(string2.length()));
            }
        }
        return Collections.enumeration(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createFolder(String string) throws IOException {
        MultiFileObject multiFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject2 = this;
            synchronized (multiFileObject2) {
                MultiFileSystem multiFileSystem = this.getMultiFileSystem();
                if (multiFileSystem.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)multiFileSystem.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    IOException iOException = new IOException("Read only: " + this.leader + " delegates: " + this.delegates);
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FisRO", (Object)string, (Object)multiFileSystem.getDisplayName()));
                    throw iOException;
                }
                String string2 = this.getPath() + '/' + string;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FoNotFolder", (Object)string, (Object)this.getPath(), (Object)multiFileSystem.getDisplayName()));
                }
                if (this.getFileObject(string) != null) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FolderAlreadyExist", (Object)string, (Object)multiFileSystem.getDisplayName(), (Object)this.getPath()));
                }
                FileSystem fileSystem = multiFileSystem.createWritableOn(string2);
                FileUtil.createFolder(this.root(fileSystem), string2);
                this.getMultiFileSystem().unmaskFileOnAll(fileSystem, string2);
                this.refresh(string, null, true, false);
                multiFileObject = this.getMultiChild(string);
                if (multiFileObject == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_ApplicationCreateError", (Object)this.getPath(), (Object)string));
                }
                FileObject[] fileObjectArray = multiFileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.getMultiFileSystem().maskFile(fileSystem, fileObjectArray[i].getPath());
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, multiFileObject), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return multiFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createData(String string, String string2) throws IOException {
        MultiFileObject multiFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject2 = this;
            synchronized (multiFileObject2) {
                String string3;
                MultiFileSystem multiFileSystem = this.getMultiFileSystem();
                if (multiFileSystem.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)multiFileSystem.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FisRO", (Object)string, (Object)multiFileSystem.getDisplayName()));
                }
                String string4 = string3 = "".equals(string2) ? string : string + '.' + string2;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FoNotFolder", (Object)string3, (Object)this.getPath(), (Object)multiFileSystem.getDisplayName()));
                }
                if (this.getFileObject(string, string2) != null) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_DataAlreadyExist", (Object)string3, (Object)multiFileSystem.getDisplayName(), (Object)this.getPath()));
                }
                String string5 = this.getPath() + '/' + string3;
                FileSystem fileSystem = multiFileSystem.createWritableOn(string5);
                FileUtil.createData(this.root(fileSystem), string5);
                this.getMultiFileSystem().unmaskFileOnAll(fileSystem, string5);
                this.refresh(string3, null, true, false);
                multiFileObject = this.getMultiChild(string3);
                if (multiFileObject == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_ApplicationCreateErrorMulti", (Object)this.getPath(), (Object)string3, (Object)fileSystem, (Object)fileSystem.getRoot().getFileObject(string5), (Object[])new Object[0]));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, multiFileObject), true);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return multiFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotRenameRoot", (Object)multiFileSystem.getDisplayName()));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                Object object;
                MfLock mfLock = this.testLock(fileLock);
                String string3 = this.parent.getPath() + '/' + string;
                if (this.isData() && string2 != null && string2.trim().length() > 0) {
                    string3 = string3 + '.' + string2;
                }
                String string4 = this.getPath();
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotRenameFromTo", (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), (Object)string3));
                }
                if (this.getFileSystem().isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)this.getMultiFileSystem().getDisplayName()));
                }
                String string5 = this.getName();
                String string6 = this.getExt();
                FileSystem fileSystem = multiFileSystem.createWritableOnForRename(string4, string3);
                if (fileSystem == this.leader.getFileSystem()) {
                    this.leader.rename(mfLock.findLock(this.leader), string, string2);
                    this.getMultiFileSystem().unmaskFileOnAll(fileSystem, string3);
                    MultiFileObject.copyContent(this, this.leader);
                } else {
                    object = this.leader;
                    if (this.isData()) {
                        FileObject fileObject = FileUtil.createFolder(this.root(fileSystem), this.getParent().getPath());
                        this.leader = this.leader.copy(fileObject, string, string2);
                        MultiFileObject.copyAttrs(this, this.leader);
                    } else {
                        FileObject fileObject = FileUtil.createFolder(this.root(fileSystem), string3);
                        MultiFileObject.copyContent(this, fileObject);
                        this.leader = fileObject;
                        this.name = string;
                        this.update();
                    }
                    mfLock.changeLocks((FileObject)object, this.leader);
                }
                if (this.getMultiFileSystem().delegates(string4).hasMoreElements()) {
                    this.getMultiFileSystem().maskFile(fileSystem, string4);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                if (this.isData()) {
                    string = string + '.' + string2;
                }
                object = this.name;
                this.name = string;
                this.parent.refresh(string, (String)object);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, string5, string6));
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleDelete(FileLock fileLock) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)this.getMultiFileSystem().getDisplayName()));
        }
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                String string = this.getPath();
                FileSystem fileSystem = multiFileSystem.createWritableOn(string);
                if (this.needsMask(fileLock, true)) {
                    this.getMultiFileSystem().maskFile(fileSystem, string);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                String string2 = this.name;
                this.validFlag = false;
                this.parent.refresh(null, string2, true, false);
                if (this.hasAtLeastOneListeners()) {
                    this.fileDeleted0(new FileEvent(this));
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        if (FileUtil.isParentOf(this, fileObject)) {
            throw new FSException(NbBundle.getMessage(FileObject.class, (String)"EXC_CopyChild", (Object)this, (Object)fileObject));
        }
        return this.leader.copy(fileObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        if (FileUtil.isParentOf(this, fileObject)) {
            throw new FSException(NbBundle.getMessage(FileObject.class, (String)"EXC_MoveChild", (Object)this, (Object)fileObject));
        }
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        try {
            multiFileSystem.beginAtomicAction();
            if (this.parent == null) {
                throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)multiFileSystem.getDisplayName()));
            }
            MfLock mfLock = this.testLock(fileLock);
            FileLock fileLock2 = mfLock.findLock(this.leader);
            FileSystem fileSystem = multiFileSystem.createWritableOn(this.getPath());
            if (multiFileSystem.isReadOnly()) {
                throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)multiFileSystem.getDisplayName()));
            }
            if (fileLock2 == null && this.leader.getFileSystem() != fileSystem) {
                this.leader = this.writable(true);
                fileLock2 = mfLock.findLock(this.leader);
            }
            if (this.needsMask(fileLock, false)) {
                this.getMultiFileSystem().maskFile(fileSystem, this.getPath());
                MultiFileObject.updateFoldersLock(this.getParent());
            }
            FileObject fileObject2 = this.leader.move(fileLock2, fileObject, string, string2);
            FileObjectLkp.reassign(this, fileObject2);
            FileObject fileObject3 = fileObject2;
            return fileObject3;
        }
        finally {
            multiFileSystem.finishAtomicAction();
        }
    }

    @Override
    public final void refresh(boolean bl) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        Enumeration<FileObject> enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            fileObject.refresh(bl);
        }
        super.refresh(bl);
    }

    @Override
    public void fileFolderCreated(FileEvent fileEvent) {
        this.updateAll();
    }

    @Override
    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshAfterEvent(fileEvent);
    }

    @Override
    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = this;
        if (fileEvent.getSource().equals(this.leader) && this.hasAtLeastOneListeners() && !fileEvent.firedFrom(markAtomicAction)) {
            if (!fileEvent.getFile().equals(fileEvent.getSource())) {
                fileObject = this.getFileObject(fileEvent.getFile().getName(), fileEvent.getFile().getExt());
            }
            if (fileObject != null) {
                this.fileChanged1(new FileEvent((FileObject)this, fileObject, fileEvent.getTime()));
            }
        }
    }

    @Override
    public void fileDeleted(FileEvent fileEvent) {
        if (fileEvent.getFile().isFolder()) {
            this.updateAll();
        } else {
            this.refreshAfterEvent(fileEvent);
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.updateAll();
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if (!this.hasAtLeastOneListeners() || this.leader == null) {
            return;
        }
        if (!fileAttributeEvent.getFile().equals(this.leader) && fileAttributeEvent.getName() != null && this.leader.getAttribute(fileAttributeEvent.getName()) != null) {
            return;
        }
        if (!fileAttributeEvent.getFile().equals(this.leader) && fileAttributeEvent.getNewValue() != null && fileAttributeEvent.getName() != null && !fileAttributeEvent.getNewValue().equals(this.getAttribute(fileAttributeEvent.getName()))) {
            return;
        }
        FileAttributeEvent fileAttributeEvent2 = new FileAttributeEvent((FileObject)this, fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue());
        try {
            fileAttributeEvent2.inheritPostNotify(fileAttributeEvent);
            this.fileAttributeChanged0(fileAttributeEvent2);
        }
        finally {
            fileAttributeEvent2.setPostNotify(null);
        }
    }

    private static void copyContent(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        MultiFileObject.copyAttrs(fileObject, fileObject2);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject3;
            FileObject fileObject4 = fileObjectArray[i];
            if (MultiFileSystem.isMaskFile(fileObject4) || fileObject2.getFileObject(fileObject4.getName(), fileObject4.getExt()) != null) continue;
            if (fileObject4.isData()) {
                fileObject3 = FileUtil.copyFile(fileObject4, fileObject2, fileObject4.getName(), fileObject4.getExt());
                if (fileObject3 == null) continue;
                MultiFileObject.copyAttrs(fileObject4, fileObject3);
                continue;
            }
            fileObject3 = fileObject2.createFolder(fileObject4.getName());
            MultiFileObject.copyContent(fileObject4, fileObject3);
        }
    }

    private static void copyAttrs(FileObject fileObject, FileObject fileObject2) {
        Enumeration<String> enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = fileObject.getAttribute(string);
            try {
                fileObject2.setAttribute(string, object);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean needsMask(FileLock fileLock, boolean bl) throws IOException {
        MfLock mfLock = this.testLock(fileLock);
        Enumeration<FileObject> enumeration = this.getMultiFileSystem().delegates(this.getPath());
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            FileLock fileLock2 = mfLock.findLock(fileObject);
            if (fileLock2 == null) {
                bl2 = true;
                continue;
            }
            if (!bl) continue;
            fileObject.delete(fileLock2);
        }
        return bl2;
    }

    private FileObject root(FileSystem fileSystem) {
        return this.getMultiFileSystem().findResourceOn(fileSystem, "");
    }

    final FileObject getLeader() {
        return this.leader;
    }

    private Collection<FileObject> collectRevealedFiles() {
        String string = this.getPath();
        FileSystem[] fileSystemArray = this.getMultiFileSystem().getDelegates();
        FileSystem fileSystem = this.getMultiFileSystem().writableLayer(string);
        if (fileSystem == null) {
            return Collections.emptyList();
        }
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            return Collections.emptyList();
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = fileSystemArray.length;
        ArrayList<RevealedFileObject> arrayList = null;
        String string2 = fileObject.getPath();
        block0: for (FileObject fileObject2 : fileObjectArray) {
            String string3 = fileObject2.getNameExt();
            if (string3.endsWith("_hidden")) {
                string3 = string3.substring(0, string3.length() - "_hidden".length());
            }
            String string4 = string2 + "/" + string3;
            for (int i = 0; i < n; ++i) {
                FileObject fileObject3;
                if (fileSystem == fileSystemArray[i] || (fileObject3 = fileSystemArray[i].findResource(string4)) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<RevealedFileObject>(fileObjectArray.length);
                }
                arrayList.add(new RevealedFileObject(fileObject2, fileObject3));
                continue block0;
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private final class RevealedFileObject
    extends FileObject
    implements Callable<FileObject> {
        private final FileObject maskFile;
        private final FileObject delegate;

        public RevealedFileObject(FileObject fileObject, FileObject fileObject2) {
            this.maskFile = fileObject;
            this.delegate = fileObject2;
        }

        @Override
        public Object getAttribute(String string) {
            return this.delegate.getAttribute(string);
        }

        @Override
        public FileObject call() throws IOException {
            if (this.maskFile.isValid()) {
                this.maskFile.delete();
            }
            return MultiFileObject.this.getFileObject(this.maskFile.getNameExt());
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getExt() {
            return this.delegate.getExt();
        }

        @Override
        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            return this.delegate.copy(fileObject, string, string2);
        }

        @Override
        public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String getPath() {
            return this.delegate.getPath();
        }

        @Override
        public String getPackageNameExt(char c, char c2) {
            return this.delegate.getPackageNameExt(c, c2);
        }

        @Override
        public String getPackageName(char c) {
            return this.delegate.getPackageName(c);
        }

        @Override
        public String getNameExt() {
            return this.delegate.getNameExt();
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            return MultiFileObject.this.getFileSystem();
        }

        @Override
        public FileObject getParent() {
            return MultiFileObject.this;
        }

        @Override
        public boolean isFolder() {
            return this.delegate.isFolder();
        }

        @Override
        public Date lastModified() {
            return this.delegate.lastModified();
        }

        @Override
        public boolean isRoot() {
            return this.delegate.isRoot();
        }

        @Override
        public boolean isData() {
            return this.delegate.isData();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean existsExt(String string) {
            return this.delegate.existsExt(string);
        }

        @Override
        public void delete(FileLock fileLock) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public Lookup getLookup() {
            return this.delegate.getLookup();
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public Enumeration<String> getAttributes() {
            return this.delegate.getAttributes();
        }

        @Override
        boolean isHasExtOverride() {
            return this.delegate.isHasExtOverride();
        }

        @Override
        boolean hasExtOverride(String string) {
            return this.delegate.hasExtOverride(string);
        }

        @Override
        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.delegate.addFileChangeListener(fileChangeListener);
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.delegate.removeFileChangeListener(fileChangeListener);
        }

        @Override
        public void addRecursiveListener(FileChangeListener fileChangeListener) {
            this.delegate.addRecursiveListener(fileChangeListener);
        }

        @Override
        public void removeRecursiveListener(FileChangeListener fileChangeListener) {
            this.delegate.removeRecursiveListener(fileChangeListener);
        }

        @Override
        protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        }

        @Override
        protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        }

        @Override
        protected void fireFileChangedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        }

        @Override
        protected void fireFileDeletedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
        }

        @Override
        protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> enumeration, FileAttributeEvent fileAttributeEvent) {
        }

        @Override
        protected void fireFileRenamedEvent(Enumeration<FileChangeListener> enumeration, FileRenameEvent fileRenameEvent) {
        }

        @Override
        public String getMIMEType() {
            return this.delegate.getMIMEType();
        }

        @Override
        public String getMIMEType(String ... stringArray) {
            return this.delegate.getMIMEType(stringArray);
        }

        @Override
        public long getSize() {
            return this.delegate.getSize();
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            return this.delegate.getInputStream();
        }

        @Override
        public byte[] asBytes() throws IOException {
            return this.delegate.asBytes();
        }

        @Override
        public String asText(String string) throws IOException {
            return this.delegate.asText(string);
        }

        @Override
        public String asText() throws IOException {
            return this.delegate.asText();
        }

        @Override
        public List<String> asLines() throws IOException {
            return this.delegate.asLines();
        }

        @Override
        public List<String> asLines(String string) throws IOException {
            return this.delegate.asLines(string);
        }

        @Override
        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public FileLock lock() throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public boolean isLocked() {
            return this.delegate.isLocked();
        }

        @Override
        public void setImportant(boolean bl) {
        }

        @Override
        public FileObject[] getChildren() {
            return new FileObject[0];
        }

        @Override
        public Enumeration<? extends FileObject> getChildren(boolean bl) {
            return Enumerations.empty();
        }

        @Override
        public Enumeration<? extends FileObject> getFolders(boolean bl) {
            return Enumerations.empty();
        }

        @Override
        public Enumeration<? extends FileObject> getData(boolean bl) {
            return Enumerations.empty();
        }

        @Override
        public FileObject getFileObject(String string, String string2) {
            if (this.maskFile.isFolder()) {
                return this.maskFile.getFileObject(string, string2);
            }
            return null;
        }

        @Override
        public FileObject getFileObject(String string) {
            if (this.maskFile.isFolder()) {
                return this.maskFile.getFileObject(string);
            }
            return null;
        }

        @Override
        public FileObject createFolder(String string) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public FileObject createData(String string, String string2) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public FileObject createData(String string) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public OutputStream createAndOpen(String string) throws IOException {
            throw new IOException("Unsupported oepration");
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public boolean canRead() {
            return this.delegate.canRead();
        }

        @Override
        public void refresh(boolean bl) {
            this.delegate.refresh(bl);
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }

        @Override
        public boolean isVirtual() {
            return this.delegate.isVirtual();
        }

        public int hashCode() {
            return 0xAA ^ this.delegate.hashCode() << 3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RevealedFileObject)) {
                return false;
            }
            RevealedFileObject revealedFileObject = (RevealedFileObject)object;
            return revealedFileObject.delegate.equals(this.delegate) && revealedFileObject.maskFile.equals(this.maskFile);
        }
    }

    private static class AttributeCache {
        private FileObject delegate;
        private String attribName = "";

        private AttributeCache() {
        }

        private void free() {
            this.delegate = null;
            this.attribName = "";
        }

        private void setDelegate(FileObject fileObject) {
            this.delegate = fileObject;
        }

        private void setAttributeName(String string) {
            this.attribName = string;
        }

        private FileObject getDelegate() {
            return this.delegate;
        }

        private String getAttributeName() {
            return this.attribName;
        }
    }

    private class MfLock
    extends FileLock {
        private Map<FileObject, FileLock> map = new HashMap<FileObject, FileLock>(11);

        public MfLock(FileObject fileObject, Enumeration<FileObject> enumeration, Set<? extends FileSystem> set) throws IOException {
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = enumeration.nextElement();
                if (!set.contains(fileObject2.getFileSystem())) continue;
                FileLock fileLock = fileObject2.lock();
                this.map.put(fileObject2, fileLock);
            }
        }

        public FileLock findLock(FileObject fileObject) {
            return this.map.get(fileObject);
        }

        public void addLock(FileObject fileObject) throws IOException {
            this.map.put(fileObject, fileObject.lock());
        }

        public void changeLocks(FileObject fileObject, FileObject fileObject2) throws IOException {
            FileLock fileLock = this.map.remove(fileObject);
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            this.addLock(fileObject2);
        }

        @Override
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                this.releaseLockForDelegates();
                if (this.getCurrentMfLock() == this) {
                    MultiFileObject.this.lock = null;
                }
            }
        }

        private FileLock getCurrentMfLock() {
            FileLock fileLock = null;
            if (MultiFileObject.this.lock != null) {
                fileLock = (FileLock)MultiFileObject.this.lock.get();
            }
            return fileLock;
        }

        private void releaseLockForDelegates() {
            for (FileLock fileLock : this.map.values()) {
                fileLock.releaseLock();
            }
            this.map.clear();
        }

        public String toString() {
            return super.toString() + " for " + MultiFileObject.this + " valid=" + this.isValid();
        }
    }

    static final class VoidValue
    implements Externalizable {
        private static final long serialVersionUID = -2743645909916238684L;
        int level;

        VoidValue(int n) {
            this.level = n;
        }

        public VoidValue() {
        }

        public String toString() {
            return "org.openide.filesystems.MultiFileObject.VoidValue#" + this.level;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.level);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.level = objectInput.readInt();
        }
    }
}

