/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.axis;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.charts.axis.BytesMark;

public class BytesAxisUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.charts.axis.Bundle");
    public static final String UNITS_B = messages.getString("BytesAxisUtils_AbbrBytes");
    public static final String UNITS_KB = messages.getString("BytesAxisUtils_AbbrKiloBytes");
    public static final String UNITS_MB = messages.getString("BytesAxisUtils_AbbrMegaBytes");
    public static final String UNITS_GB = messages.getString("BytesAxisUtils_AbbrGigaBytes");
    public static final String UNITS_TB = messages.getString("BytesAxisUtils_AbbrTeraBytes");
    public static final String UNITS_PB = messages.getString("BytesAxisUtils_AbbrPetaBytes");
    private static final String SIZE_FORMAT = messages.getString("BytesAxisUtils_SizeFormat");
    public static final long[] bytesUnitsGrid = new long[]{1L, 2L, 5L, 10L, 25L, 50L, 100L, 250L, 500L};
    public static final String[] radixUnits = new String[]{UNITS_B, UNITS_KB, UNITS_MB, UNITS_GB, UNITS_TB, UNITS_PB};
    private static final NumberFormat FORMAT = NumberFormat.getInstance();

    public static long[] getBytesUnits(double scale, int minDistance) {
        if (Double.isNaN(scale) || scale == Double.POSITIVE_INFINITY || scale <= 0.0) {
            return new long[]{-1L, -1L};
        }
        long bytesFactor = 1L;
        long bytesRadix = 0L;
        while (true) {
            for (int i = 0; i < bytesUnitsGrid.length; ++i) {
                if (!((double)bytesUnitsGrid[i] * scale * (double)bytesFactor >= (double)minDistance)) continue;
                return new long[]{bytesUnitsGrid[i] * bytesFactor, bytesRadix};
            }
            bytesFactor *= 1024L;
            ++bytesRadix;
        }
    }

    public static String getRadixUnits(BytesMark mark) {
        int radix = mark.getRadix();
        if (radix < 0 || radix >= radixUnits.length) {
            return "";
        }
        return radixUnits[radix];
    }

    public static String formatBytes(BytesMark mark) {
        int radix = mark.getRadix();
        long value = mark.getValue() / (long)Math.pow(1024.0, radix);
        String units = BytesAxisUtils.getRadixUnits(mark);
        return MessageFormat.format(SIZE_FORMAT, FORMAT.format(value), units);
    }
}

