/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.coredump.impl.OverviewViewSupport;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.graalvm.visualvm.tools.sa.SaModelFactory;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class CoreDumpOverviewView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/coredump/resources/overview.png";

    public CoreDumpOverviewView(CoreDump coreDump) {
        super((DataSource)coreDump, NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Overview"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 0, false);
    }

    protected DataViewComponent createComponent() {
        CoreDump coreDump = (CoreDump)this.getDataSource();
        SaModel saAgent = SaModelFactory.getSAAgentFor((DataSource)coreDump);
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(saAgent).getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        if (saAgent != null) {
            Properties jvmProperties = saAgent.getSystemProperties();
            String jvmargs = saAgent.getJvmArgs();
            dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.25, 0.0, -1.0, -1.0, -1.0, -1.0));
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Saved_data"), true), 1);
            dvc.addDetailsView(new OverviewViewSupport.SnapshotsViewSupport((DataSource)coreDump).getDetailsView(), 1);
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Details"), true), 2);
            dvc.addDetailsView(new OverviewViewSupport.JVMArgumentsViewSupport(jvmargs).getDetailsView(), 2);
            dvc.addDetailsView(new OverviewViewSupport.SystemPropertiesViewSupport(jvmProperties).getDetailsView(), 2);
        }
        return dvc;
    }

    private static class MasterViewSupport
    extends JPanel {
        public MasterViewSupport(SaModel saAgent) {
            this.initComponents(saAgent);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(SaModel saAgent) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralProperties(saAgent) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)area, "Center");
        }

        private String getGeneralProperties(SaModel saAgent) {
            StringBuilder data = new StringBuilder();
            if (saAgent != null) {
                String commandLine = saAgent.getJavaCommand();
                if (commandLine != null) {
                    String mainClass;
                    int firstSpace = commandLine.indexOf(32);
                    String mainArgs = null;
                    if (firstSpace == -1) {
                        mainClass = commandLine;
                    } else {
                        mainClass = commandLine.substring(0, firstSpace);
                        mainArgs = commandLine.substring(firstSpace + 1);
                    }
                    String mainClassLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Main_class");
                    String argsLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Arguments");
                    data.append("<b>" + mainClassLbl + ":</b> " + mainClass + "<br>");
                    data.append("<b>" + argsLbl + ":</b> " + (mainArgs == null ? NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_none") : mainArgs) + "<br>");
                }
                String jvmFlags = saAgent.getJvmFlags();
                String jvmLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_JVM");
                String jLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Java");
                String verLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Java_Version");
                String vendorLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Java_Vendor");
                String jhLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Java_Home");
                String flagsLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_JVM_Flags");
                data.append("<br>");
                data.append("<b>" + jvmLbl + ":</b> " + saAgent.getVmName() + " (" + saAgent.getVmVersion() + ", " + saAgent.getVmInfo() + ")<br>");
                Properties props = saAgent.getSystemProperties();
                if (props != null) {
                    String javaVersion = props.getProperty("java.version");
                    String javaVendor = props.getProperty("java.vendor");
                    if (javaVersion != null || javaVendor != null) {
                        data.append("<b>" + jLbl + ":</b>");
                        if (javaVersion != null) {
                            data.append(" " + verLbl + " " + javaVersion);
                        }
                        if (javaVendor != null) {
                            if (javaVersion != null) {
                                data.append(",");
                            }
                            data.append(" " + vendorLbl + " " + javaVendor);
                        }
                        data.append("<br>");
                    }
                }
                data.append("<b>" + jhLbl + ":</b> " + saAgent.getJavaHome() + "<br>");
                data.append("<b>" + flagsLbl + ":</b> " + (jvmFlags == null || jvmFlags.length() == 0 ? NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_none") : jvmFlags) + "<br><br>");
            } else {
                data.append(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"MSG_CoreDump_Failed"));
            }
            return data.toString();
        }
    }
}

