from .. import Provider as AddressProvider


class Provider(AddressProvider):
    address_formats = ['{{street_address}}, {{city}}, {{postcode}}']
    building_number_formats = ['#', '##', '###']
    city_formats = ['{{city_prefix}} {{first_name}}']
    street_address_formats = ['{{street_name}}, {{building_number}}']
    street_name_formats = ('{{street_prefix}} {{street_title}}', )

    city_prefixes = ['місто', 'село', 'селище', 'хутір']
    countries = [
        'Австралія', 'Австрія', 'Азербайджан', 'Албанія', 'Алжир', 'Ангола',
        'Андорра', 'Антигуа і Барбуда', 'Аргентина', 'Афганістан',
        'Багамські Острови', 'Бангладеш', 'Барбадос', 'Бахрейн', 'Беліз',
        'Бельгія', 'Бенін', 'Білорусь', 'Болгарія', 'Болівія',
        'Боснія і Герцеговина', 'Ботсвана', 'Бразилія', 'Бруней',
        'Буркіна-Фасо', 'Бурунді', 'Бутан', 'Вануату', 'Ватикан',
        'Велика Британія', 'Венесуела', 'В\'єтнам', 'Вірменія', 'Габон',
        'Гаїті', 'Гаяна', 'Гамбія', 'Гана', 'Гватемала', 'Гвінея',
        'Гвінея-Бісау', 'Гондурас', 'Гренада', 'Греція', 'Грузія', 'Данія',
        'Джибуті', 'Домініка', 'Домініканська Республіка', 'Еквадор',
        'Екваторіальна Гвінея', 'Еритрея', 'Естонія', 'Ефіопія', 'Єгипет',
        'Ємен', 'Замбія', 'Західна Сахара', 'Зімбабве', 'Ізраїль', 'Індія',
        'Індонезія', 'Ірак', 'Іран', 'Ірландія', 'Ісландія', 'Іспанія',
        'Італія', 'Йорданія', 'Кабо-Верде', 'Казахстан', 'Камбоджа', 'Камерун',
        'Канада', 'Катар', 'Кенія', 'Киргизстан', 'КНР', 'Кіпр', 'Кірибаті',
        'Колумбія', 'Коморські Острови', 'Конго', 'ДР Конго', 'Південна Корея',
        'Північна Корея', 'Косово', 'Коста-Рика', 'Кот-д\'Івуар', 'Куба',
        'Кувейт', 'Лаос', 'Латвія', 'Лесото', 'Литва', 'Ліберія', 'Ліван',
        'Лівія', 'Ліхтенштейн', 'Люксембург', 'Маврикій', 'Мавританія',
        'Мадагаскар', 'Республіка Македонія', 'Малаві', 'Малайзія', 'Малі',
        'Мальдіви', 'Мальта', 'Марокко', 'Маршаллові Острови', 'Мексика',
        'Федеративні Штати Мікронезії', 'Мозамбік', 'Молдова', 'Монако',
        'Монголія', 'М\'янма', 'Намібія', 'Науру', 'Непал', 'Нігер', 'Нігерія',
        'Нідерланди', 'Нікарагуа', 'Німеччина', 'Нова Зеландія', 'Норвегія',
        'ОАЕ', 'Оман', 'Пакистан', 'Палау', 'Палестинська держава', 'Панама',
        'Папуа Нова Гвінея', 'ПАР', 'Парагвай', 'Перу', 'Південний Судан',
        'Польща', 'Португалія', 'Росія', 'Руанда', 'Румунія', 'Сальвадор',
        'Самоа', 'Сан-Марино', 'Сан-Томе і Принсіпі', 'Саудівська Аравія',
        'Свазіленд', 'Сейшельські Острови', 'Сенегал',
        'Сент-Вінсент і Гренадини', 'Сент-Кіттс і Невіс', 'Сент-Люсія',
        'Сербія', 'Сінгапур', 'Сирія', 'Словаччина', 'Словенія',
        'Соломонові Острови', 'Сомалі', 'Судан', 'Суринам', 'Східний Тимор',
        'США', 'Сьєрра-Леоне', 'Таджикистан', 'Таїланд', 'Тайвань', 'Танзанія',
        'Того', 'Тонга', 'Тринідад і Тобаго', 'Тувалу', 'Туніс', 'Туреччина',
        'Туркменістан', 'Уганда', 'Угорщина', 'Узбекистан', 'Україна',
        'Уругвай', 'Фіджі', 'Філіппіни', 'Фінляндія', 'Франція', 'Хорватія',
        'Центральноафриканська Республіка', 'Чад', 'Чехія', 'Чилі',
        'Чорногорія', 'Швейцарія', 'Швеція', 'Шрі-Ланка', 'Ямайка', 'Японія',
    ]
    street_prefixes = [
        'вулиця', 'набережна',
    ]
    street_suffixes = ['узвіз']

    # https://data.gov.ua/en/dataset/__-120/resource/76e2684f-e75c-45e5-a0b2-6d5596ab47f8
    # https://opendata.drohobych-rada.gov.ua/sites/default/files/%D0%90%D0%B4%D1%80%D0%B5%D1%81%D0%B8%20%D0%94%D1%80%D0%BE%D0%B3%D0%BE%D0%B1%D0%B8%D1%87.xlsx
    street_titles = [
        '22 Січня',
        'Адама Міцкевича',
        'Академіка Сахарова',
        'Андрея Шептицького',
        'Андрія Мельника',
        'Андрія Чайковського',
        'Антона Чехова',
        'Архипа Люльки',
        'Байди',
        'Богдана Лепкого',
        'Богдана Хмельницького',
        'Бойківська',
        'Бориса Грінченка',
        'Бориславська',
        'Братів Кицилів',
        'Броніслава Козловського',
        'Бруно Шульца',
        'Будівельна',
        'Буковинська',
        "В'ячеслава Чорновола",
        'Василя Барського',
        'Василя Симоненка',
        'Василя Стуса',
        'Вербова',
        'Вокзальна',
        'Володимира Івасюка',
        'Володимира Бірчака',
        'Володимира Великого',
        'Володимира Вернадського',
        'Володимира Винниченка',
        'Володимира Гнатюка',
        'Володимира Чапельського',
        'Володимира Чапельського',
        'Гайдамацька',
        'Героїв Крут',
        'Глінки',
        'Гончарська',
        'Горішня Брама',
        'Григорія Коссака',
        'Григорія Сковороди',
        'Грюнвальдська',
        'Данила Галицького',
        'Данила Нечая',
        'Дмитра Бортнянського',
        'Дмитра Бурка',
        'Дмитра Вітовського',
        'Дмитра Грицая',
        'Дмитра Котка',
        'Дністровська',
        'Євгена Гребінки',
        'Євгена Коновальця',
        'Захарії Копистенського',
        'Зварицька',
        'Зелена',
        'Івана Вагилевича',
        'Івана Вендзиловича',
        'Івана Верхратського',
        'Івана Карпенка-Карого',
        'Івана Котляревського',
        'Івана Мазепи',
        'Івана Макуха',
        'Івана Пулюя',
        'Івана Підкови',
        'Івана Сірка',
        'Івана Труша',
        'Івана Франка',
        'Іллі Рєпіна',
        'Індустріальна',
        'Ірини Вільде',
        'Йосипа Левицького',
        'Йосипа Сліпого',
        'Йосифа Стадника',
        'Карпатська',
        'Кирило - Мефодіївська',
        'Київська',
        'Княгині Ольги',
        'Ковальська',
        'Козацька',
        'Коминярська',
        'Крушельницької',
        'Купальська',
        'Лева Толстого',
        'Лемківська',
        'Леся Курбаса',
        'Леся Мартовича',
        'Лесі Українки',
        'Львівська',
        'Людвіга ван Бетховена',
        'Лішнянська',
        'Максима Залізняка',
        'Максима Кривоноса',
        'Максима Рильського',
        'Малий Ринок',
        'Марка Кропивницького',
        'Маркіяна Шашкевича',
        'Марії Заньковецької',
        'Маріїнська',
        'Механізаторів',
        'Миколи Вороного',
        'Миколи Гоголя',
        'Миколи Леонтовича',
        'Миколи Лисенка',
        'Миколи Некрасова',
        'Мирона Тарнавського',
        'Мирослава Тураша',
        'Михайла Вербицького',
        'Михайла Грушевського',
        'Михайла Зубрицького',
        'Михайла Коцюбинського',
        'Михайла Лермонтова',
        'Михайла Остроградського',
        'Михайла Павлика',
        'Михайла Старицького',
        'Млинарська',
        'Модеста Менцинського',
        'Музична',
        'Нафтовиків',
        'Нова',
        'Озерна',
        'Олега Ольжича',
        'Олександра Кониського',
        'Олександра Пушкіна',
        'Олекси Довбуша',
        'Олексндра Довженка',
        'Олени Теліги',
        'Олеся Гончара',
        'Опришківська',
        'Осипа Турянського',
        'Остапа Вишні',
        'Остапа Нижанківського',
        'Павла Грабовського',
        'Павла Полуботка',
        'Панаса Мирного',
        'Паркова',
        'Петра Дорошенка',
        'Петра Сагайдачного',
        'Пилипа Орлика',
        'Пластунів',
        'Прорізна',
        'Південна',
        'Раневицька',
        'Рихтицька',
        'Рівна',
        'Різдвяна',
        'Ріпницька',
        'Самбірська',
        'Северина Наливайка',
        'Солоний Ставок',
        'Спартака',
        'Спортивна',
        'Станіслава Людкевича',
        'Станіславська',
        'Степана Коваліва',
        'Степана Рудавського',
        'Стрийська',
        'Східна',
        'Січових Стрільців',
        'Тараса Шевченка',
        'Твердохліба',
        'Тисменицька',
        'Тита Реваковича',
        'Тиха',
        'Трускавецька',
        'Уляни Кравченко',
        'Устима Кармелюка',
        'Устияновичів',
        'Фабрична',
        'Фредеріка Шопена',
        'Холмська',
        'Шевська',
        'Шкільна',
        'Шолом Алейхема',
        'Шота Руставелі',
        'Юліуша Словацького',
        'Юрія Дрогобича',
        'Юрія Федьковича',
        'Якова Головацького',
        'Ярослава Осмомисла',
    ]

    def city_prefix(self):
        return self.random_element(self.city_prefixes)

    def postcode(self):
        """The code consists of five digits (01000-99999)"""
        return f'{self.generator.random.randint(0, 10)}{self.generator.random.randint(1000, 10000)}'

    def street_prefix(self):
        return self.random_element(self.street_prefixes)

    def street_title(self):
        return self.random_element(self.street_titles)
