/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupportRedirector;
import org.openide.text.DocumentOpenClose;
import org.openide.text.DocumentStatus;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.LineVector;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintPreferences;
import org.openide.text.UndoRedoManager;
import org.openide.text.UserQuestionExceptionHandler;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    public static final String EDITOR_MODE = "editor";
    public static final UndoableEdit BEGIN_COMMIT_GROUP = UndoRedoManager.BEGIN_COMMIT_GROUP;
    public static final UndoableEdit END_COMMIT_GROUP = UndoRedoManager.END_COMMIT_GROUP;
    public static final UndoableEdit MARK_COMMIT_GROUP = UndoRedoManager.MARK_COMMIT_GROUP;
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final ThreadLocal<Boolean> LOCAL_CLOSE_DOCUMENT = new ThreadLocal();
    DocumentOpenClose openClose;
    static final Logger ERR = Logger.getLogger("org.openide.text.CloneableEditorSupport");
    private EditorKit kit;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set[] lineSet = new Line.Set[]{null};
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private Set<ChangeListener> listeners;
    private transient Reference<Pane> lastSelected = null;
    private long lastSaveTime;
    private transient boolean isSaving;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean preventModification;
    private boolean listeningOnEnv;
    private boolean inUserQuestionExceptionHandler;
    private LineVector lineSetLineVector;
    private boolean annotationsLoaded;
    private DocFilter docFilter;
    private final Object checkModificationLock = new Object();
    private static final Set<Class<?>> warnedClasses = new WeakSet();
    private static Reference<CloneableTopComponent> lastReusable = new WeakReference<Object>(null);

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup lookup) {
        super((CloneableOpenSupport.Env)env);
        Parameters.notNull((CharSequence)"l", (Object)lookup);
        this.lookup = lookup;
        this.openClose = new DocumentOpenClose(this);
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage(Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.createEditorKit();
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getUndoRedo();
        }
        if (this.undoRedo == null) {
            UndoRedo.Manager manager;
            this.undoRedo = manager = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set set = this.getLineSet();
            for (AnnotationProvider annotationProvider : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
                annotationProvider.annotate(set, this.lookup);
            }
        }
    }

    protected boolean asynchronousOpen() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (warnedClasses.add(clazz)) {
            ERR.warning(clazz.getName() + " should override asynchronousOpen(). See http://bits.netbeans.org/dev/javadoc/org-openide-text/apichanges.html#CloneableEditorSupport.asynchronousOpen");
        }
        return false;
    }

    public void open() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.open();
            return;
        }
        if (this.asynchronousOpen()) {
            super.open();
        } else {
            try {
                StyledDocument styledDocument = this.openDocument();
                super.open();
            }
            catch (UserQuestionException userQuestionException) {
                new UserQuestionExceptionHandler(this, userQuestionException){

                    @Override
                    protected void opened(StyledDocument styledDocument) {
                        CloneableEditorSupport.super.open();
                    }
                }.runInEDT();
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    public Task prepareDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.prepareDocument();
        }
        return this.openClose.openTask();
    }

    final void addDocListener(Document document) {
        if (Boolean.TRUE.equals(document.getProperty("supportsModificationListener"))) {
            document.putProperty("modificationListener", this.getListener());
        }
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            DocumentFilter documentFilter = abstractDocument.getDocumentFilter();
            this.docFilter = new DocFilter(documentFilter);
            abstractDocument.setDocumentFilter(this.docFilter);
        } else {
            DocumentFilter documentFilter = (DocumentFilter)document.getProperty(DocumentFilter.class);
            this.docFilter = new DocFilter(documentFilter);
            document.putProperty(DocumentFilter.class, this.docFilter);
        }
        document.addDocumentListener(this.getListener());
    }

    final void removeDocListener(Document document) {
        if (Boolean.TRUE.equals(document.getProperty("supportsModificationListener"))) {
            document.putProperty("modificationListener", null);
        }
        if (this.docFilter != null) {
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.setDocumentFilter(this.docFilter.origFilter);
            } else {
                document.putProperty(DocumentFilter.class, this.docFilter.origFilter);
            }
            this.docFilter = null;
        }
        document.removeDocumentListener(this.getListener());
    }

    public StyledDocument openDocument() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openDocument();
        }
        return this.openClose.open();
    }

    public StyledDocument getDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getDocument();
        }
        return this.openClose.getDocument();
    }

    public boolean isModified() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isModified();
        }
        return this.cesEnv().isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        boolean bl = ERR.isLoggable(Level.FINE);
        if (bl) {
            ERR.fine(this.documentID() + ": saveDocument() started.");
        }
        if (cloneableEditorSupport != null) {
            if (bl) {
                ERR.fine("  redirect to " + cloneableEditorSupport.documentID());
            }
            cloneableEditorSupport.saveDocument();
            return;
        }
        if (!this.cesEnv().isModified()) {
            if (bl) {
                ERR.fine(this.documentID() + "  No save performed because cesEnv().isModified() == false");
            }
            return;
        }
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            if (bl) {
                ERR.fine(this.documentID() + "  No save performed because getDocument() == null");
            }
            return;
        }
        CloneableEditorSupport cloneableEditorSupport2 = this;
        synchronized (cloneableEditorSupport2) {
            while (this.isSaving) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    ERR.log(Level.INFO, null, interruptedException);
                }
            }
            this.isSaving = true;
        }
        try {
            this.saveDocumentImpl(styledDocument, bl);
        }
        finally {
            cloneableEditorSupport2 = this;
            synchronized (cloneableEditorSupport2) {
                this.isSaving = false;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentImpl(final StyledDocument styledDocument, final boolean bl) throws IOException {
        Object object;
        long l;
        long l2 = this.lastSaveTime;
        if (l2 != -1L && (l = this.cesEnv().getTime().getTime()) > l2) {
            if (bl) {
                ERR.fine(this.documentID() + ":  externalMod=" + l + " > prevLST=" + l2 + " => throw new UserQuestionException()");
            }
            throw new UserQuestionException(this.mimeType){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change_write", (Object)styledDocument.getProperty("title"));
                }

                public void confirmed() throws IOException {
                    CloneableEditorSupport.this.setLastSaveTime(l);
                    CloneableEditorSupport.this.saveDocument();
                }
            };
        }
        class MemoryOutputStream
        extends ByteArrayOutputStream {
            public MemoryOutputStream(int n) {
                super(n);
            }

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(this.buf, 0, this.count);
            }
        }
        final MemoryOutputStream[] memoryOutputStreamArray = new MemoryOutputStream[1];
        final IOException[] iOExceptionArray = new IOException[1];
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    if (manager instanceof UndoRedoManager) {
                        UndoRedoManager undoRedoManager = (UndoRedoManager)manager;
                        if (blArray[0]) {
                            undoRedoManager.endOnSaveTasks();
                        }
                        undoRedoManager.markSavepoint();
                    }
                    int n = styledDocument.getLength() * 11 / 10;
                    memoryOutputStreamArray[0] = new MemoryOutputStream(n);
                    EditorKit editorKit = CloneableEditorSupport.this.createEditorKit();
                    CloneableEditorSupport.this.saveFromKitToStream(styledDocument, editorKit, memoryOutputStreamArray[0]);
                    CloneableEditorSupport.this.updateLineSet(true);
                    if (bl) {
                        ERR.fine(CloneableEditorSupport.this.documentID() + ": Saved " + memoryOutputStreamArray[0].size() + " bytes to memory output stream.");
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                catch (IOException iOException) {
                    iOExceptionArray[0] = iOException;
                }
            }
        };
        Runnable runnable2 = (Runnable)styledDocument.getProperty("beforeSaveRunnable");
        if (runnable2 != null) {
            object = new Runnable(){

                @Override
                public void run() {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    if (manager instanceof UndoRedoManager) {
                        ((UndoRedoManager)CloneableEditorSupport.this.undoRedo).startOnSaveTasks();
                        blArray[0] = true;
                    }
                }
            };
            styledDocument.putProperty("beforeSaveStart", object);
            styledDocument.putProperty("beforeSaveEnd", runnable);
            runnable2.run();
            if (memoryOutputStreamArray[0] == null) {
                styledDocument.render(runnable);
            }
        } else {
            styledDocument.render(runnable);
        }
        if (iOExceptionArray[0] != null) {
            if (bl) {
                ERR.log(Level.FINE, this.documentID() + ": Save broken due to IOException", iOExceptionArray[0]);
            }
            throw iOExceptionArray[0];
        }
        object = null;
        long l3 = this.lastSaveTime;
        try {
            this.setLastSaveTime(-1L);
            object = this.cesEnv().outputStream();
            memoryOutputStreamArray[0].writeTo((OutputStream)object);
            ((OutputStream)object).close();
            object = null;
            styledDocument.render(new Runnable(){

                @Override
                public void run() {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    boolean bl = false;
                    if (manager instanceof UndoRedoManager) {
                        if (((UndoRedoManager)manager).isAtSavepoint()) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        CloneableEditorSupport.this.callNotifyUnmodified();
                    }
                }
            });
            if (bl) {
                ERR.fine(this.documentID() + ": Save to file OK, oldSaveTime: " + l3 + ", " + new Date(l3));
            }
            this.setLastSaveTime(this.cesEnv().getTime().getTime());
        }
        finally {
            if (this.lastSaveTime == -1L) {
                if (bl) {
                    ERR.fine(this.documentID() + ": Save failed (lastSaveTime == -1) restoring old save time.");
                }
                this.setLastSaveTime(l3);
                this.callNotifyModified();
            }
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
    }

    public JEditorPane[] getOpenedPanes() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getOpenedPanes() must be called from AWT thread only";
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getOpenedPanes();
        }
        LinkedList<JEditorPane> linkedList = new LinkedList<JEditorPane>();
        Enumeration enumeration = this.allEditors.getComponents();
        Pane pane = this.getLastSelected();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane2 = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane2 == null && cloneableTopComponent instanceof Pane) {
                pane2 = (Pane)cloneableTopComponent;
            }
            if (pane2 != null) {
                JEditorPane jEditorPane = pane2.getEditorPane();
                if (jEditorPane == null) continue;
                if (pane == pane2 || pane != null && pane instanceof Component && pane2 instanceof Container && ((Container)((Object)pane2)).isAncestorOf((Component)((Object)pane))) {
                    linkedList.addFirst(jEditorPane);
                    continue;
                }
                linkedList.add(jEditorPane);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return linkedList.isEmpty() ? null : linkedList.toArray(new JEditorPane[linkedList.size()]);
    }

    JEditorPane getRecentPane() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getRecentPane must be called from AWT thread only";
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getRecentPane();
        }
        Enumeration enumeration = this.allEditors.getComponents();
        Pane pane = this.getLastSelected();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane2 = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane2 == null && cloneableTopComponent instanceof Pane) {
                pane2 = (Pane)cloneableTopComponent;
            }
            if (pane2 != null) {
                JEditorPane jEditorPane = null;
                if (pane == pane2 || pane != null && pane instanceof Component && pane2 instanceof Container && ((Container)((Object)pane2)).isAncestorOf((Component)((Object)pane))) {
                    if (pane2 instanceof CloneableEditor && ((CloneableEditor)pane2).isEditorPaneReady()) {
                        jEditorPane = pane2.getEditorPane();
                    }
                    if (pane instanceof CloneableEditor) {
                        if (((CloneableEditor)pane).isEditorPaneReady()) {
                            jEditorPane = pane2.getEditorPane();
                        }
                    } else {
                        jEditorPane = pane2.getEditorPane();
                    }
                }
                if (jEditorPane == null) continue;
                return jEditorPane;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    protected void afterRedirect(CloneableOpenSupport cloneableOpenSupport) {
        super.afterRedirect(cloneableOpenSupport);
        if (cloneableOpenSupport instanceof CloneableEditorSupport) {
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)cloneableOpenSupport;
            this.lastSelected = cloneableEditorSupport.lastSelected;
            this.openClose = cloneableEditorSupport.openClose;
            this.lineSet = cloneableEditorSupport.lineSet;
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("openedPanes", null, null);
        }
    }

    final Pane getLastSelected() {
        return this.lastSelected == null ? null : this.lastSelected.get();
    }

    final void setLastSelected(Pane pane) {
        this.lastSelected = new WeakReference<Pane>(pane);
    }

    public Line.Set getLineSet() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getLineSet();
        }
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LineVector findLineVector() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetLineVector != null) {
                return this.lineSetLineVector;
            }
            this.lineSetLineVector = new LineVector();
            return this.lineSetLineVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.print();
            return;
        }
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            object = PrinterJob.getPrinterJob();
            Object object2 = NbDocument.findPageable(this.openDocument());
            if (object2 instanceof Pageable) {
                ((PrinterJob)object).setPageable((Pageable)object2);
            } else {
                PageFormat pageFormat = PrintPreferences.getPageFormat((PrinterJob)object);
                ((PrinterJob)object).setPrintable((Printable)object2, pageFormat);
            }
            if (((PrinterJob)object).printDialog()) {
                ((PrinterJob)object).print();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CloneableEditorSupport.notifyProblem(fileNotFoundException, "CTL_Bad_File");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (PrinterAbortException printerAbortException) {
            CloneableEditorSupport.notifyProblem(printerAbortException, "CTL_Printer_Abort");
        }
        catch (PrinterException printerException) {
            CloneableEditorSupport.notifyProblem(printerException, "EXC_Printer_Problem");
        }
        finally {
            Object object3 = this.LOCK_PRINTING;
            synchronized (object3) {
                this.printing = false;
            }
        }
    }

    private static void notifyProblem(Exception exception, String string) {
        String string2 = NbBundle.getMessage(CloneableEditorSupport.class, (String)string, (Object)exception.getLocalizedMessage());
        Exceptions.attachLocalizedMessage((Throwable)exception, (String)string2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exception));
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor cloneableEditor = this.createCloneableEditor();
        this.initializeCloneableEditor(cloneableEditor);
        return cloneableEditor;
    }

    protected Component wrapEditorComponent(Component component) {
        return component;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SafeAWTAccess safeAWTAccess = this;
                    synchronized (safeAWTAccess) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                    }
                    finally {
                        safeAWTAccess = this;
                        synchronized (safeAWTAccess) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safeAWTAccess = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safeAWTAccess.run();
            } else {
                SwingUtilities.invokeLater(safeAWTAccess);
                try {
                    safeAWTAccess.waitForResult();
                }
                catch (InterruptedException interruptedException) {
                    ERR.log(Level.INFO, null, interruptedException);
                    return false;
                }
            }
            if (safeAWTAccess.ret == 0) {
                return false;
            }
            if (safeAWTAccess.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (UserCancelException userCancelException) {
                    return false;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String string = this.messageSave();
        ResourceBundle resourceBundle = NbBundle.getBundle(CloneableEditorSupport.class);
        JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
        jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
        jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
            return 0;
        }
        if (jButton.equals(object)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentLoaded();
        }
        return this.openClose.isDocumentLoadedOrLoading();
    }

    boolean isDocumentReady() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentReady();
        }
        return this.openClose.isDocumentOpened();
    }

    public void setMIMEType(String string) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this, true);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.setMIMEType(string);
            return;
        }
        this.mimeType = string;
    }

    @Deprecated
    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ChangeListener>(8);
        }
        this.listeners.add(changeListener);
    }

    @Deprecated
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), n, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getInputStream();
        }
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(styledDocument, this.createEditorKit(), byteArrayOutputStream);
        }
        catch (BadLocationException badLocationException) {
            ERR.log(Level.INFO, null, badLocationException);
            throw (IllegalStateException)new IllegalStateException(badLocationException.getMessage()).initCause(badLocationException);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(outputStream, (Document)styledDocument, 0, styledDocument.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected Task reloadDocument() {
        return this.openClose.reloadTask();
    }

    public static EditorKit getEditorKit(String string) {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
        EditorKit editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        if (editorKit == null) {
            lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain"));
            editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        }
        return editorKit != null ? (EditorKit)editorKit.clone() : new PlainEditorKit();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = CloneableEditorSupport.getEditorKit(this.mimeType);
        } else {
            String string = this.cesEnv().getMimeType();
            this.kit = CloneableEditorSupport.getEditorKit(string);
        }
        return this.kit;
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = CloneableEditorSupport.createNetBeansDocument(editorKit.createDefaultDocument());
        styledDocument.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return styledDocument;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        if (!Boolean.TRUE.equals(LOCAL_CLOSE_DOCUMENT.get())) {
            this.updateTitles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean callNotifyModified() {
        Object object = this.checkModificationLock;
        synchronized (object) {
            if (this.isAlreadyModified()) {
                return true;
            }
            if (this.preventModification) {
                return false;
            }
            this.setAlreadyModified(true);
        }
        if (!this.notifyModified()) {
            object = this.checkModificationLock;
            synchronized (object) {
                this.setAlreadyModified(false);
            }
            return false;
        }
        this.getPositionManager().documentOpened(this.openClose.docRef);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callNotifyUnmodified() {
        Object object = this.checkModificationLock;
        synchronized (object) {
            if (!this.isAlreadyModified()) {
                return;
            }
            this.setAlreadyModified(false);
        }
        this.notifyUnmodified();
        if (this.getAnyEditor() == null) {
            this.getPositionManager().documentClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean bl = true;
        try {
            this.env.markModified();
            Object object = this.checkModificationLock;
            synchronized (object) {
                if (!this.isAlreadyModified()) {
                    this.setAlreadyModified(true);
                }
            }
        }
        catch (UserQuestionException userQuestionException) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    DocumentOpenClose.RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                                try {
                                    userQuestionException.confirmed();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            bl = false;
            ERR.log(Level.FINE, "Could not lock document", userQuestionException);
        }
        catch (IOException iOException) {
            ERR.log(Level.FINE, "Could not lock document", iOException);
            String string = null;
            string = iOException.getMessage() != iOException.getLocalizedMessage() ? iOException.getLocalizedMessage() : Exceptions.findLocalizedMessage((Throwable)iOException);
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText(string);
            }
            bl = false;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
            ERR.log(Level.FINE, "notifyModified returns false");
            return false;
        }
        lastReusable.clear();
        this.updateTitles();
        if (ERR.isLoggable(Level.FINE)) {
            ERR.log(Level.FINE, "notifyModified returns true; env.isModified()=" + this.env.isModified());
        }
        return true;
    }

    protected void notifyClosed() {
        this.annotationsLoaded = false;
        this.closeDocument();
    }

    final StyledDocument getDocumentHack() {
        return this.getDoc();
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet[0] != null && !bl) {
                return this.lineSet[0];
            }
            this.lineSet[0] = this.getDoc() == null || this.openClose.getDocumentStatusLA() == DocumentStatus.RELOADING ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.getDoc());
            return this.lineSet[0];
        }
    }

    protected boolean close(boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.close(bl);
        }
        if (!super.close(bl)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    private void closeDocument() {
        this.openClose.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(JEditorPane[] jEditorPaneArray, boolean bl) {
        StyledDocument styledDocument;
        Object object = this.getLock();
        synchronized (object) {
            styledDocument = this.getDoc();
        }
        if (!bl && !this.reloadDialogOpened) {
            object = NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change", (Object)styledDocument.getProperty("title"));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, 0);
            this.reloadDialogOpened = true;
            try {
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (NotifyDescriptor.YES_OPTION.equals(object2)) {
                    bl = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        if (bl) {
            this.openClose.reload(jEditorPaneArray);
            this.reloadDocument();
        }
    }

    private static StyledDocument createNetBeansDocument(Document document) {
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    final void fireDocumentChange(StyledDocument styledDocument, boolean bl) {
        this.fireStateChangeEvent(styledDocument, bl);
        this.firePropertyChange("document", bl ? styledDocument : null, bl ? null : styledDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fireStateChangeEvent(StyledDocument styledDocument, boolean bl) {
        if (this.listeners == null) return;
        EnhancedChangeEvent enhancedChangeEvent = new EnhancedChangeEvent(this, styledDocument, bl);
        ChangeListener[] changeListenerArray = this;
        synchronized (this) {
            ChangeListener[] changeListenerArray2 = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (ChangeListener changeListener : changeListenerArray2) {
                changeListener.stateChanged(enhancedChangeEvent);
            }
            return;
        }
    }

    protected void updateTitles() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                pane.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    private static void replaceTc(TopComponent topComponent, TopComponent topComponent2) {
        int n = topComponent.getTabPosition();
        topComponent.close();
        topComponent2.openAtTabPosition(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane(boolean bl) {
        String string;
        Pane pane = null;
        boolean bl2 = false;
        Object object = this.getLock();
        synchronized (object) {
            pane = this.getAnyEditor();
            if (pane == null) {
                string = this.messageOpening();
                if (string != null) {
                    StatusDisplayer.getDefault().setStatusText(string);
                }
                this.prepareDocument();
                pane = this.createPane();
                pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
                pane.getComponent().setReference(this.allEditors);
                bl2 = true;
            }
        }
        object = pane.getComponent();
        if (bl && bl2) {
            string = lastReusable.get();
            if (string != null) {
                CloneableEditorSupport.replaceTc((TopComponent)string, (TopComponent)object);
            } else {
                object.open();
            }
            lastReusable = new WeakReference<Object>(object);
        } else {
            object.open();
        }
        if (bl2) {
            string = this.messageOpened();
            if (string == null) {
                string = "";
            }
            StatusDisplayer.getDefault().setStatusText(string);
        }
        return pane;
    }

    Pane getAnyEditor() {
        CloneableTopComponent cloneableTopComponent = this.allEditors.getArbitraryComponent();
        if (cloneableTopComponent == null) {
            return null;
        }
        Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
        if (pane != null) {
            return pane;
        }
        if (cloneableTopComponent instanceof Pane) {
            return (Pane)cloneableTopComponent;
        }
        Enumeration enumeration = this.allEditors.getComponents();
        if (enumeration.hasMoreElements()) {
            cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane != null) {
                return pane;
            }
            if (cloneableTopComponent instanceof Pane) {
                return (Pane)cloneableTopComponent;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    @Deprecated
    final Pane openReuse(PositionRef positionRef, int n, int n2) {
        if (n2 == 5) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    final Pane openReuse(PositionRef positionRef, int n, Line.ShowOpenType showOpenType) {
        if (showOpenType == Line.ShowOpenType.REUSE_NEW) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    protected final Pane openAt(PositionRef positionRef, int n) {
        return this.openAtImpl(positionRef, n, false);
    }

    private final Pane openAtImpl(final PositionRef positionRef, final int n, boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openAtImpl(positionRef, n, bl);
        }
        final Pane pane = this.openPane(bl);
        Task task = this.prepareDocument();
        pane.ensureVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private boolean documentLocked = false;

            Selector() {
            }

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(this);
                task.removeTaskListener((TaskListener)this);
            }

            @Override
            public void run() {
                JEditorPane jEditorPane = pane.getEditorPane();
                if (jEditorPane == null) {
                    return;
                }
                StyledDocument styledDocument = CloneableEditorSupport.this.getDocument();
                if (styledDocument == null) {
                    return;
                }
                if (!this.documentLocked) {
                    this.documentLocked = true;
                    styledDocument.render(this);
                } else {
                    Caret caret = jEditorPane.getCaret();
                    if (caret == null) {
                        return;
                    }
                    Document document = jEditorPane.getDocument();
                    if (document instanceof StyledDocument && document != styledDocument) {
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("paneDoc=" + document + "\n !=\ndoc=" + styledDocument);
                        }
                        styledDocument = (StyledDocument)document;
                    }
                    Element element = NbDocument.findLineRootElement(styledDocument);
                    int n2 = (element = element.getElement(element.getElementIndex(positionRef.getOffset()))).getStartOffset() + Math.max(0, n);
                    if (n2 > element.getEndOffset()) {
                        n2 = Math.max(element.getStartOffset(), element.getEndOffset() - 1);
                    }
                    caret.setDot(n2);
                    try {
                        Rectangle rectangle = jEditorPane.modelToView(n2);
                        if (rectangle != null) {
                            rectangle.height *= 5;
                            jEditorPane.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ERR.log(Level.WARNING, "Can't scroll to text: pos.getOffset=" + positionRef.getOffset() + ", column=" + n + ", offset=" + n2 + ", doc.getLength=" + styledDocument.getLength(), badLocationException);
                    }
                }
            }
        }
        task.addTaskListener((TaskListener)new Selector());
        return pane;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void setListeningOnEnv(boolean bl) {
        if (bl != this.listeningOnEnv) {
            this.listeningOnEnv = bl;
            if (bl) {
                this.cesEnv().addPropertyChangeListener(this.getListener());
            } else {
                this.cesEnv().removePropertyChangeListener(this.getListener());
            }
        }
    }

    void howToReproduceDeadlock40766(boolean bl) {
    }

    final void setLastSaveTime(long l) {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine(this.documentID() + ": Setting new lastSaveTime to " + l + ", " + new Date(l));
        }
        this.lastSaveTime = l;
    }

    final void updateLastSaveTime() {
        this.setLastSaveTime(this.cesEnv().getTime().getTime());
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setAlreadyModified(boolean bl) {
        if (bl != this.alreadyModified) {
            if (ERR.isLoggable(Level.FINE)) {
                boolean bl2;
                Object object = this.checkModificationLock;
                synchronized (object) {
                    bl2 = this.isAlreadyModified();
                }
                ERR.fine(this.documentID() + ": setAlreadyModified from " + bl2 + " to " + bl);
                ERR.log(Level.FINEST, null, new Exception("Setting to modified: " + bl));
            }
            this.alreadyModified = bl;
            this.openClose.setDocumentStronglyReferenced(bl);
        }
    }

    final void setPreventModification(boolean bl) {
        this.preventModification = bl;
    }

    StyledDocument getDoc() {
        return this.openClose.getRefDocument();
    }

    public String toString() {
        return "CES: " + this.openClose;
    }

    private final class DocFilter
    extends DocumentFilter {
        final DocumentFilter origFilter;

        DocFilter(DocumentFilter documentFilter) {
            this.origFilter = documentFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.insertString(filterBypass, n, string, attributeSet);
                } else {
                    super.insertString(filterBypass, n, string, attributeSet);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.remove(filterBypass, n, n2);
                } else {
                    super.remove(filterBypass, n, n2);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.replace(filterBypass, n, n2, string, attributeSet);
                } else {
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkModificationAllowed(int n) throws BadLocationException {
            boolean bl;
            Object object = CloneableEditorSupport.this.checkModificationLock;
            synchronized (object) {
                bl = CloneableEditorSupport.this.isAlreadyModified();
            }
            if (!CloneableEditorSupport.this.callNotifyModified()) {
                this.modificationNotAllowed(n);
            }
            return bl;
        }

        private void modificationNotAllowed(int n) throws BadLocationException {
            throw new BadLocationException("Modification not allowed", n);
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    DocumentListener,
    VetoableChangeListener {
        private boolean revertModifiedFlag;

        Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    boolean bl;
                    Object object = CloneableEditorSupport.this.checkModificationLock;
                    synchronized (object) {
                        bl = CloneableEditorSupport.this.isAlreadyModified();
                    }
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", propertyChangeEvent);
                    }
                    this.revertModifiedFlag = !bl;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            if ("expectedTime".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.lastSaveTime = ((Date)propertyChangeEvent.getNewValue()).getTime();
            }
            if ("time".equals(propertyChangeEvent.getPropertyName())) {
                object = (Date)propertyChangeEvent.getNewValue();
                ERR.fine(CloneableEditorSupport.this.documentID() + ": PROP_TIME new value: " + object + ", " + (object != null ? ((Date)object).getTime() : -1L));
                ERR.fine("       lastSaveTime: " + new Date(CloneableEditorSupport.this.lastSaveTime) + ", " + CloneableEditorSupport.this.lastSaveTime);
                boolean bl = CloneableEditorSupport.this.lastSaveTime != -1L && (object == null || ((Date)object).getTime() > CloneableEditorSupport.this.lastSaveTime || ((Date)object).getTime() + 10000L < CloneableEditorSupport.this.lastSaveTime);
                ERR.fine("             reload: " + bl);
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable((Date)object){
                        private boolean inRunAtomic;
                        private JEditorPane[] openedPanes;
                        final /* synthetic */ Date val$time;
                        {
                            this.val$time = date;
                        }

                        @Override
                        public void run() {
                            if (!this.inRunAtomic) {
                                this.inRunAtomic = true;
                                StyledDocument styledDocument = CloneableEditorSupport.this.getDoc();
                                if (styledDocument == null) {
                                    return;
                                }
                                this.openedPanes = CloneableEditorSupport.this.getOpenedPanes();
                                CloneableEditorSupport.this.preventModification = true;
                                try {
                                    NbDocument.runAtomic(styledDocument, this);
                                }
                                finally {
                                    CloneableEditorSupport.this.preventModification = false;
                                }
                                return;
                            }
                            boolean bl = this.val$time == null || !CloneableEditorSupport.this.isModified();
                            ERR.fine(CloneableEditorSupport.this.documentID() + ": checkReload noAsk: " + bl);
                            CloneableEditorSupport.this.checkReload(this.openedPanes, bl);
                        }
                    });
                    ERR.fine(CloneableEditorSupport.this.documentID() + ": reload task posted");
                }
            }
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if ("DataEditorSupport.read-only.changing".equals(propertyChangeEvent.getPropertyName())) {
                object = propertyChangeEvent.getNewValue();
                if (object == Boolean.TRUE) {
                    StyledDocument styledDocument = CloneableEditorSupport.this.getDoc();
                    styledDocument.putProperty("editable", Boolean.TRUE);
                }
                CloneableEditorSupport.this.updateTitles();
            }
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        @Override
        public Object clone() {
            return new PlainEditorKit();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this;
        }

        @Override
        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        @Override
        public void install(JEditorPane jEditorPane) {
            super.install(jEditorPane);
            jEditorPane.setFont(new Font("Monospaced", 0, jEditorPane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }
}

