/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WeakValuedMap<Key, Value>
implements Map<Key, Value>,
Serializable {
    private final Map<Key, KeyedReference<Key, Value>> map = this.newMap();
    private final ReferenceQueue<Value> deadRefs = new ReferenceQueue();

    @Override
    public Value put(Key key2, Value value2) {
        this.cleanReferences();
        KeyedReference<Key, Value> prev = this.map.put(key2, new KeyedReference<Key, Value>(value2, key2, this.deadRefs));
        return prev == null ? null : (Value)prev.get();
    }

    @Override
    public Value get(Object key2) {
        this.cleanReferences();
        KeyedReference<Key, Value> reference2 = this.map.get(key2);
        if (reference2 == null) {
            return null;
        }
        return (Value)reference2.get();
    }

    @Override
    public void clear() {
        this.cleanReferences();
        this.map.clear();
    }

    @Override
    public int size() {
        this.cleanReferences();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        this.cleanReferences();
        for (KeyedReference<Key, Value> ref : this.map.values()) {
            if (!(value2 == null ? ref.get() == null : value2.equals(ref.get()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value remove(Object key2) {
        this.cleanReferences();
        KeyedReference<Key, Value> prev = this.map.remove(key2);
        return prev == null ? null : (Value)prev.get();
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        for (Map.Entry<Key, Value> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Key> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Value> values() {
        return new AbstractCollection<Value>(){

            @Override
            public Iterator<Value> iterator() {
                return new Iterator<Value>(){
                    final Iterator<Map.Entry<Key, Value>> i;
                    {
                        this.i = WeakValuedMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Value next() {
                        return this.i.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return WeakValuedMap.this.size();
            }

            @Override
            public boolean contains(Object v) {
                return WeakValuedMap.this.containsValue(v);
            }

            @Override
            public void clear() {
                WeakValuedMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return new EntrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    protected Map<Key, KeyedReference<Key, Value>> newMap() {
        return new ConcurrentHashMap();
    }

    private void cleanReferences() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadRefs.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    private class EntrySet
    extends AbstractCollection<Map.Entry<Key, Value>>
    implements Set<Map.Entry<Key, Value>> {
        transient Set<Map.Entry<Key, KeyedReference<Key, Value>>> entries;

        private EntrySet() {
        }

        private Set<Map.Entry<Key, KeyedReference<Key, Value>>> getEntries() {
            if (this.entries == null) {
                this.entries = WeakValuedMap.this.map.entrySet();
            }
            return this.entries;
        }

        @Override
        public int size() {
            return WeakValuedMap.this.size();
        }

        @Override
        public void clear() {
            WeakValuedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                WeakValuedMap.this.cleanReferences();
                KeyedReference reference2 = (KeyedReference)WeakValuedMap.this.map.get(entry.getKey());
                if (reference2 == null) {
                    return false;
                }
                Object value2 = reference2.get();
                return value2 == null ? entry.getValue() == null : value2.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator() {
            WeakValuedMap.this.cleanReferences();
            return new Iterator<Map.Entry<Key, Value>>(){
                final Iterator<Map.Entry<Key, KeyedReference<Key, Value>>> i;
                {
                    this.i = WeakValuedMap.this.map.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<Key, Value> next() {
                    Map.Entry e = this.i.next();
                    return new AbstractMap.SimpleImmutableEntry(e.getKey(), e.getValue().get());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Key, Value> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        protected final Key key;

        public KeyedReference(Value object, Key key2, ReferenceQueue<? super Value> queue) {
            super(object, queue);
            this.key = key2;
        }
    }
}

