/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.rendercgo;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.renderspecial.DrawRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapecgo.CGO;
import org.jmol.shapecgo.CGOMesh;
import org.jmol.util.C;
import org.jmol.util.Logger;

public class CGORenderer
extends DrawRenderer {
    private CGOMesh cgoMesh;
    private Lst<Object> cmds;
    private P3 pt3 = new P3();
    private short colix0;
    private short colix1;
    private short colix2;
    private short normix0;
    private short normix1;
    private short normix2;
    private short normix;
    private boolean doColor;
    private int ptNormal;
    private int ptColor;
    private P3 map0;
    private P3 vX;
    private P3 vY;
    private float x0;
    private float y0;
    private float dx;
    private float dy;
    private float scaleX;
    private float scaleY;
    private boolean is2D;
    private boolean is2DPercent;
    private boolean isMapped;
    private boolean isPS;
    private int screenZ;

    @Override
    protected boolean render() {
        this.needTranslucent = false;
        this.imageFontScaling = this.vwr.imageFontScaling;
        CGO cgo = (CGO)this.shape;
        int i = cgo.meshCount;
        while (--i >= 0) {
            this.cgoMesh = (CGOMesh)cgo.meshes[i];
            this.mesh = this.cgoMesh;
            this.render2(this.cgoMesh);
        }
        return this.needTranslucent;
    }

    private void render2(Mesh mesh) {
        int type;
        this.diameter = this.cgoMesh.diameter;
        this.width = this.cgoMesh.width;
        this.cmds = this.cgoMesh.cmds;
        if (this.cmds == null || !this.cgoMesh.visible || this.cgoMesh.visibilityFlags == 0) {
            return;
        }
        if (!this.g3d.setC(this.cgoMesh.colix)) {
            this.needTranslucent = true;
            return;
        }
        int n = this.cmds.size();
        int glMode = -1;
        int nPts = 0;
        this.ptNormal = 0;
        this.ptColor = 0;
        this.width = 0.0f;
        this.screenZ = Integer.MAX_VALUE;
        this.doColor = !mesh.useColix;
        this.g3d.addRenderer(1073742182);
        this.isMapped = false;
        this.is2D = false;
        this.scaleY = 1.0f;
        this.scaleX = 1.0f;
        for (int j = 0; j < n && (type = this.cgoMesh.getInt(j)) != 0; ++j) {
            int len = CGOMesh.getSize(type, this.is2D);
            if (len < 0) {
                Logger.error("CGO unknown type: " + type);
                return;
            }
            switch (type) {
                default: {
                    System.out.println("CGO ? " + type);
                    break;
                }
                case -111: {
                    break;
                }
                case -107: {
                    this.diameter = this.cgoMesh.getInt(j + 1);
                    break;
                }
                case -100: {
                    this.width = this.cgoMesh.getFloat(j + 1);
                    break;
                }
                case -101: {
                    this.isMapped = false;
                    float f = this.cgoMesh.getFloat(j + 1);
                    if (f == 0.0f) {
                        this.is2D = false;
                        break;
                    }
                    this.is2DPercent = f > 0.0f;
                    this.screenZ = this.is2DPercent ? this.tm.zValueFromPercent((int)f) : -((int)f);
                    this.is2D = true;
                    break;
                }
                case -103: {
                    this.isPS = true;
                }
                case -102: {
                    this.isMapped = true;
                    this.is2D = true;
                    this.map0 = new P3();
                    this.vX = new P3();
                    this.vY = new P3();
                    this.cgoMesh.getPoint(j + 1, this.map0);
                    this.cgoMesh.getPoint(j + 4, this.vX);
                    this.vX.sub(this.map0);
                    this.cgoMesh.getPoint(j + 7, this.vY);
                    this.vY.sub(this.map0);
                    this.x0 = this.cgoMesh.getFloat(j + 10);
                    this.y0 = this.cgoMesh.getFloat(j + 11);
                    this.dx = this.cgoMesh.getFloat(j + 12) - this.x0;
                    this.dy = this.cgoMesh.getFloat(j + 13) - this.y0;
                    if (this.isPS) break;
                }
                case -108: {
                    this.scaleX = this.cgoMesh.getFloat(this.isPS ? j + 1 : j + 14);
                    this.scaleY = this.cgoMesh.getFloat(this.isPS ? j + 2 : j + 15);
                    break;
                }
                case 28: {
                    break;
                }
                case 1: {
                    this.getPoint(j + 2, this.pt0, this.pt0i);
                    this.getPoint(j + (this.is2D ? 4 : 5), this.pt1, this.pt1i);
                    this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    break;
                }
                case 2: {
                    glMode = this.cgoMesh.getInt(j + 1);
                }
                case -104: {
                    nPts = 0;
                    break;
                }
                case -105: {
                    glMode = -105;
                    break;
                }
                case -106: {
                    if (glMode != -105) break;
                    glMode = 2;
                }
                case 3: {
                    if (glMode == 2 && nPts >= 3) {
                        this.drawEdge(1, 2, true, this.pt0, this.pt3, this.pt0i, this.pt3i);
                    }
                    nPts = 0;
                    break;
                }
                case 6: {
                    this.getColix(true);
                    break;
                }
                case 5: {
                    this.normix = this.getNormix();
                    break;
                }
                case -109: {
                    nPts = 0;
                }
                case -110: {
                    glMode = 2;
                }
                case 4: {
                    if (nPts++ == 0) {
                        this.getPoint(j, this.pt0, this.pt0i);
                    }
                    block23 : switch (glMode) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            this.drawEdge(1, 1, false, this.pt0, this.pt0, this.pt0i, this.pt0i);
                            break;
                        }
                        case 1: {
                            if (nPts != 2) break;
                            this.getPoint(j, this.pt1, this.pt1i);
                            this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                            nPts = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (nPts == 1) {
                                if (glMode != 2) break;
                                this.pt3.setT(this.pt0);
                                this.pt3i.setT(this.pt0i);
                                break;
                            }
                            this.getPoint(j, this.pt1, this.pt1i);
                            P3 pt = this.pt0;
                            this.pt0 = this.pt1;
                            this.pt1 = pt;
                            P3i spt = this.pt0i;
                            this.pt0i = this.pt1i;
                            this.pt1i = spt;
                            this.drawEdge(1, 2, true, this.pt0, this.pt1, this.pt0i, this.pt1i);
                            break;
                        }
                        case 4: {
                            switch (nPts) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break;
                                }
                                case 2: {
                                    this.getPoint(j, this.pt1, this.pt1i);
                                    break;
                                }
                                case 3: {
                                    this.getPoint(j, this.pt2, this.pt2i);
                                    this.fillTriangle();
                                    nPts = 0;
                                }
                            }
                            break;
                        }
                        case 5: {
                            P3i spt;
                            P3 pt;
                            switch (nPts) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break block23;
                                }
                                case 2: {
                                    this.getPoint(j, this.pt2, this.pt2i);
                                    break block23;
                                }
                            }
                            if (nPts % 2 == 0) {
                                pt = this.pt0;
                                this.pt0 = this.pt2;
                                spt = this.pt0i;
                                this.pt0i = this.pt2i;
                            } else {
                                pt = this.pt1;
                                this.pt1 = this.pt2;
                                spt = this.pt1i;
                                this.pt1i = this.pt2i;
                            }
                            this.pt2 = pt;
                            this.pt2i = spt;
                            this.getPoint(j, this.pt2, this.pt2i);
                            this.fillTriangle();
                            break;
                        }
                        case 6: {
                            switch (nPts) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    this.pt1.setT(this.pt0);
                                    this.pt1i.setT(this.pt0i);
                                    break block23;
                                }
                                case 2: {
                                    this.getPoint(j, this.pt0, this.pt0i);
                                    break block23;
                                }
                            }
                            this.pt2.setT(this.pt0);
                            this.pt2i.setT(this.pt0i);
                            this.getPoint(j, this.pt0, this.pt0i);
                            this.fillTriangle();
                        }
                    }
                    break;
                }
                case 14: {
                    this.getPoint(j, this.pt0, this.pt0i);
                    this.getPoint(j + (this.is2D ? 2 : 3), this.pt1, this.pt1i);
                    this.width = this.cgoMesh.getFloat(j + 7);
                    this.getColix(true);
                    this.getColix(false);
                    this.drawEdge(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    this.width = 0.0f;
                    break;
                }
                case 8: {
                    this.getPoint(j, this.pt0, this.pt0i);
                    this.getPoint(j + (this.is2D ? 2 : 3), this.pt1, this.pt1i);
                    this.getPoint(j + (this.is2D ? 4 : 6), this.pt2, this.pt2i);
                    this.normix0 = this.getNormix();
                    this.normix1 = this.getNormix();
                    this.normix2 = this.getNormix();
                    this.colix0 = this.getColix(false);
                    this.colix1 = this.getColix(false);
                    this.colix2 = this.getColix(false);
                    this.fillTriangle();
                }
            }
            j += len;
        }
    }

    private short getNormix() {
        return (Short)this.cgoMesh.nList.get(this.ptNormal++);
    }

    private short getColix(boolean doSet) {
        if (this.doColor) {
            this.colix = C.copyColixTranslucency(this.cgoMesh.colix, (Short)this.cgoMesh.cList.get(this.ptColor++));
            if (doSet) {
                this.g3d.setC(this.colix);
            }
        }
        return this.colix;
    }

    void getPoint(int i, P3 pt, P3i pti) {
        this.cgoMesh.getPoint(i + 1, pt);
        if (this.isMapped) {
            float fx = (pt.x * this.scaleX - this.x0) / this.dx;
            float fy = (pt.y * this.scaleY - this.y0) / this.dy;
            pt.scaleAdd2(fx, this.vX, this.map0);
            pt.scaleAdd2(fy, this.vY, pt);
        } else if (this.is2D) {
            pti.x = this.is2DPercent ? this.tm.percentToPixels('x', pt.x) : (int)pt.x;
            pti.y = this.is2DPercent ? this.tm.percentToPixels('y', pt.y) : (int)pt.y;
            pti.z = this.screenZ;
            this.tm.unTransformPoint(pt, pt);
            return;
        }
        this.tm.transformPtScr(pt, pti);
    }

    private void fillTriangle() {
        this.g3d.fillTriangle3CNBits(this.pt0, this.colix0, this.normix0, this.pt1, this.colix1, this.normix1, this.pt2, this.colix2, this.normix2, true);
    }
}

