/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

public class RelationNodeMap<T extends IRelationMember<? extends IPrimitive>> {
    private static final String ROLE_BACKWARD = "backward";
    private final NodesWays map = new NodesWays(false);
    private final NodesWays onewayMap = new NodesWays(true);
    private final NodesWays onewayReverseMap = new NodesWays(true);
    private final Set<Integer> remaining = new TreeSet<Integer>();
    private final Map<Integer, Set<INode>> remainingOneway = new TreeMap<Integer, Set<INode>>();
    private final List<Integer> notSortable = new ArrayList<Integer>();
    private Integer firstOneway;
    private INode lastOnewayNode;
    private INode firstCircular;

    public static INode firstOnewayNode(IRelationMember<?> m) {
        if (!m.isWay()) {
            return null;
        }
        if (ROLE_BACKWARD.equals(m.getRole())) {
            return m.getWay().lastNode();
        }
        return m.getWay().firstNode();
    }

    public static INode lastOnewayNode(IRelationMember<?> m) {
        if (!m.isWay()) {
            return null;
        }
        if (ROLE_BACKWARD.equals(m.getRole())) {
            return m.getWay().firstNode();
        }
        return m.getWay().lastNode();
    }

    RelationNodeMap(List<T> members) {
        for (int i = 0; i < members.size(); ++i) {
            IRelationMember m = (IRelationMember)members.get(i);
            if (m.getMember().isIncomplete() || !m.isWay() || m.getWay().getNodesCount() < 2) {
                this.notSortable.add(i);
                continue;
            }
            IWay<?> w = m.getWay();
            if (RelationSortUtils.roundaboutType(w) != WayConnectionType.Direction.NONE) {
                for (INode nd : w.getNodes()) {
                    this.addPair(nd, i);
                }
                continue;
            }
            if (RelationSortUtils.isOneway(m)) {
                this.addNodeWayMap(RelationNodeMap.firstOnewayNode(m), i);
                this.addWayNodeMap(RelationNodeMap.lastOnewayNode(m), i);
                this.addNodeWayMapReverse(RelationNodeMap.lastOnewayNode(m), i);
                this.addWayNodeMapReverse(RelationNodeMap.firstOnewayNode(m), i);
                this.addRemainingForward(RelationNodeMap.firstOnewayNode(m), i);
                this.addRemainingForward(RelationNodeMap.lastOnewayNode(m), i);
                continue;
            }
            this.addPair((INode)w.firstNode(), i);
            this.addPair((INode)w.lastNode(), i);
        }
        this.remaining.addAll(this.map.ways.keySet());
    }

    private void addPair(INode n, int i) {
        this.map.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
        this.map.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addNodeWayMap(INode n, int i) {
        this.onewayMap.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
    }

    private void addWayNodeMap(INode n, int i) {
        this.onewayMap.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addNodeWayMapReverse(INode n, int i) {
        this.onewayReverseMap.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
    }

    private void addWayNodeMapReverse(INode n, int i) {
        this.onewayReverseMap.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addRemainingForward(INode n, int i) {
        this.remainingOneway.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    public Integer popAdjacent(Integer way) {
        if (this.lastOnewayNode != null) {
            return this.popBackwardOnewayPart(way);
        }
        if (this.firstOneway != null) {
            return this.popForwardOnewayPart(way);
        }
        if (this.map.ways.containsKey(way)) {
            for (INode n : this.map.ways.get(way)) {
                Integer i = this.deleteAndGetAdjacentNode(this.map, n);
                if (i != null) {
                    return i;
                }
                Integer j = this.deleteAndGetAdjacentNode(this.onewayMap, n);
                if (j == null) continue;
                this.firstOneway = j;
                return j;
            }
        }
        this.firstOneway = way;
        return this.popForwardOnewayPart(way);
    }

    private Integer popForwardOnewayPart(Integer way) {
        if (this.onewayMap.ways.containsKey(way)) {
            INode exitNode = this.onewayMap.ways.get(way).iterator().next();
            if (this.checkIfEndOfLoopReached(exitNode)) {
                this.lastOnewayNode = exitNode;
                return this.popBackwardOnewayPart(this.firstOneway);
            }
            Integer i = this.deleteAndGetAdjacentNode(this.onewayMap, exitNode);
            if (i != null) {
                return i;
            }
            this.lastOnewayNode = exitNode;
            return this.popBackwardOnewayPart(this.firstOneway);
        }
        this.firstOneway = null;
        return null;
    }

    private boolean checkIfEndOfLoopReached(INode n) {
        return this.map.nodes.containsKey(n) || this.onewayMap.nodes.containsKey(n) && this.onewayMap.nodes.get(n).size() > 1 || this.firstCircular != null && this.firstCircular == n;
    }

    private Integer popBackwardOnewayPart(int way) {
        if (this.lastOnewayNode != null) {
            TreeSet nodes = new TreeSet();
            if (this.onewayReverseMap.ways.containsKey(way)) {
                nodes.addAll(this.onewayReverseMap.ways.get(way));
            }
            if (this.map.ways.containsKey(way)) {
                nodes.addAll(this.map.ways.get(way));
            }
            for (INode n : nodes) {
                Integer j;
                if (n == this.lastOnewayNode) {
                    this.firstOneway = null;
                    this.lastOnewayNode = null;
                    j = this.deleteAndGetAdjacentNode(this.map, n);
                    if (j != null) {
                        return j;
                    }
                    Integer k = this.deleteAndGetAdjacentNode(this.onewayMap, n);
                    if (k != null) {
                        this.firstOneway = k;
                        return k;
                    }
                }
                if ((j = this.deleteAndGetAdjacentNode(this.onewayReverseMap, n)) == null) continue;
                return j;
            }
        }
        this.firstOneway = null;
        this.lastOnewayNode = null;
        return null;
    }

    private Integer deleteAndGetAdjacentNode(NodesWays nw, INode n) {
        Integer j = RelationNodeMap.findAdjacentWay(nw, n);
        if (j == null) {
            return null;
        }
        this.deleteWayNode(nw, j, n);
        return j;
    }

    private static Integer findAdjacentWay(NodesWays nw, INode n) {
        Set<Integer> adj = nw.nodes.get(n);
        if (adj == null || adj.isEmpty()) {
            return null;
        }
        return adj.iterator().next();
    }

    private void deleteWayNode(NodesWays nw, Integer way, INode n) {
        if (nw.oneWay) {
            this.doneOneway(way);
        } else {
            this.done(way);
            nw.ways.get(way).remove(n);
        }
    }

    public Integer pop() {
        if (!this.remaining.isEmpty()) {
            Integer i = this.remaining.iterator().next();
            this.done(i);
            return i;
        }
        if (this.remainingOneway.isEmpty()) {
            return null;
        }
        for (Integer i : this.remainingOneway.keySet()) {
            for (INode n : this.onewayReverseMap.ways.get(i)) {
                if (!this.onewayReverseMap.nodes.containsKey(n) || this.onewayReverseMap.nodes.get(n).size() <= 1) continue;
                this.doneOneway(i);
                this.firstCircular = n;
                return i;
            }
        }
        Integer i = this.remainingOneway.keySet().iterator().next();
        this.doneOneway(i);
        return i;
    }

    private void doneOneway(Integer i) {
        Set<INode> nodesForward = this.remainingOneway.get(i);
        for (INode n : nodesForward) {
            if (this.onewayMap.nodes.containsKey(n)) {
                this.onewayMap.nodes.get(n).remove(i);
            }
            if (!this.onewayReverseMap.nodes.containsKey(n)) continue;
            this.onewayReverseMap.nodes.get(n).remove(i);
        }
        this.remainingOneway.remove(i);
    }

    private void done(Integer i) {
        this.remaining.remove(i);
        Set<INode> nodes = this.map.ways.get(i);
        for (INode n : nodes) {
            boolean result = this.map.nodes.get(n).remove(i);
            if (!result) {
                throw new AssertionError();
            }
        }
    }

    public List<Integer> getNotSortableMembers() {
        return this.notSortable;
    }

    private static class NodesWays {
        public final Map<INode, Set<Integer>> nodes = new TreeMap<INode, Set<Integer>>();
        public final Map<Integer, Set<INode>> ways = new TreeMap<Integer, Set<INode>>();
        public final boolean oneWay;

        NodesWays(boolean oneWay) {
            this.oneWay = oneWay;
        }
    }
}

