/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.util.DocumentAdapter;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

public class Text
extends KeyedItem {
    private static int auto_increment_selected;
    public String default_;
    public String originalValue;
    public String use_last_as_default = "false";
    public String auto_increment;
    public short length;
    public String alternative_autocomplete_keys;
    private JComponent value;
    private transient TemplateEntry valueTemplate;

    @Override
    public boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        KeyedItem.Usage usage = Text.determineTextUsage(support.getSelected(), this.key);
        AutoCompletingTextField textField = new AutoCompletingTextField();
        if (this.alternative_autocomplete_keys != null) {
            this.initAutoCompletionField(textField, (this.key + ',' + this.alternative_autocomplete_keys).split(",", -1));
        } else {
            this.initAutoCompletionField(textField, this.key);
        }
        if (TaggingPresetItem.DISPLAY_KEYS_AS_HINT.get().booleanValue()) {
            textField.setHint(this.key);
        }
        if (this.length > 0) {
            textField.setMaxChars(Integer.valueOf(this.length));
        }
        if (usage.unused()) {
            if (auto_increment_selected != 0 && this.auto_increment != null) {
                try {
                    textField.setText(Integer.toString(Integer.parseInt((String)LAST_VALUES.get(this.key)) + auto_increment_selected));
                }
                catch (NumberFormatException ex) {
                    Logging.trace(ex);
                }
            } else if (!usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                if (!support.isPresetInitiallyMatches() && !"false".equals(this.use_last_as_default) && LAST_VALUES.containsKey(this.key)) {
                    textField.setText((String)LAST_VALUES.get(this.key));
                } else {
                    textField.setText(this.default_);
                }
            } else {
                textField.setText("");
            }
            this.value = textField;
            this.originalValue = null;
        } else if (usage.hasUniqueValue()) {
            textField.setText(usage.getFirst());
            this.value = textField;
            this.originalValue = usage.getFirst();
        } else {
            JosmComboBox<String> comboBox = new JosmComboBox<String>(usage.values.toArray(new String[0]));
            comboBox.setEditable(true);
            comboBox.setEditor(textField);
            comboBox.getEditor().setItem(DIFFERENT);
            this.value = comboBox;
            this.originalValue = DIFFERENT;
        }
        this.initializeLocaleText(null);
        this.setupListeners(textField, support);
        if (this.auto_increment != null) {
            ButtonGroup bg = new ButtonGroup();
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)this.value, GBC.std().fill(2));
            for (String ai : this.auto_increment.split(",", -1)) {
                JToggleButton aibutton = new JToggleButton(ai);
                aibutton.setToolTipText(I18n.tr("Select auto-increment of {0} for this field", ai));
                aibutton.setMargin(new Insets(0, 0, 0, 0));
                aibutton.setFocusable(false);
                Text.saveHorizontalSpace(aibutton);
                bg.add(aibutton);
                try {
                    int buttonvalue = NumberFormat.getIntegerInstance().parse(ai.replace("+", "")).intValue();
                    if (auto_increment_selected == buttonvalue) {
                        aibutton.setSelected(true);
                    }
                    aibutton.addActionListener(e -> {
                        auto_increment_selected = buttonvalue;
                    });
                    pnl.add((Component)aibutton, GBC.std());
                }
                catch (ParseException ex) {
                    Logging.error("Cannot parse auto-increment value of '" + ai + "' into an integer");
                }
            }
            JToggleButton clearbutton = new JToggleButton("X");
            clearbutton.setVisible(false);
            clearbutton.setFocusable(false);
            bg.add(clearbutton);
            JButton releasebutton = new JButton("X");
            releasebutton.setToolTipText(I18n.tr("Cancel auto-increment for this field", new Object[0]));
            releasebutton.setMargin(new Insets(0, 0, 0, 0));
            releasebutton.setFocusable(false);
            releasebutton.addActionListener(e -> {
                auto_increment_selected = 0;
                clearbutton.setSelected(true);
            });
            Text.saveHorizontalSpace(releasebutton);
            pnl.add((Component)releasebutton, GBC.eol());
            this.value = pnl;
        }
        JLabel label = new JLabel(I18n.tr("{0}:", this.locale_text));
        this.addIcon(label);
        label.setToolTipText(this.getKeyTooltipText());
        label.setComponentPopupMenu(this.getPopupMenu());
        label.setLabelFor(this.value);
        p.add((Component)label, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)this.value, GBC.eol().fill(2));
        this.value.setToolTipText(this.getKeyTooltipText());
        return true;
    }

    private static void saveHorizontalSpace(AbstractButton button) {
        Insets insets = button.getBorder().getBorderInsets(button);
        if (insets != null && insets.left + insets.right > insets.top + insets.bottom) {
            int min = Math.min(insets.top, insets.bottom);
            button.setBorder(BorderFactory.createEmptyBorder(insets.top, min, insets.bottom, min));
        }
    }

    private static String getValue(Component comp) {
        if (comp instanceof JosmComboBox) {
            return ((JosmComboBox)comp).getEditor().getItem().toString();
        }
        if (comp instanceof JosmTextField) {
            return ((JosmTextField)comp).getText();
        }
        if (comp instanceof JPanel) {
            return Text.getValue(((JPanel)comp).getComponent(0));
        }
        return null;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        String v = Text.getValue(this.value);
        if (v == null) {
            Logging.error("No 'last value' support for component " + this.value);
            return;
        }
        v = Utils.removeWhiteSpaces(v);
        if (!"false".equals(this.use_last_as_default) || this.auto_increment != null) {
            LAST_VALUES.put(this.key, v);
        }
        if (v.equals(this.originalValue) || this.originalValue == null && v.isEmpty()) {
            return;
        }
        changedTags.add(new Tag(this.key, v));
        AutoCompletionManager.rememberUserInput(this.key, v, true);
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    @Override
    public Collection<String> getValues() {
        if (this.default_ == null || this.default_.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.default_);
    }

    public void setValue_template(String pattern) throws SAXException {
        try {
            this.valueTemplate = new TemplateParser(pattern).parse();
        }
        catch (ParseError e) {
            Logging.error("Error while parsing " + pattern + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    private void setupListeners(AutoCompletingTextField textField, TaggingPresetItemGuiSupport support) {
        textField.getDocument().addDocumentListener(DocumentAdapter.create(ignore -> support.fireItemValueModified(this, this.key, textField.getText())));
        if (this.valueTemplate != null) {
            textField.setForeground(Color.BLUE);
            support.addListener((source, key, newValue) -> {
                if (source != this) {
                    String valueTemplateText = this.valueTemplate.getText(support);
                    Logging.trace("Evaluating value_template {0} for key {1} => {2}", this.valueTemplate, key, valueTemplateText);
                    SwingUtilities.invokeLater(() -> textField.setItem(valueTemplateText));
                }
            });
        }
    }
}

