/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.collect.ImmutableList;
import com.google.debugging.sourcemap.SourceMapObject;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SourceMapObjectParser {
    private static final Gson gson = new Gson();

    public static SourceMapObject parse(String contents) throws SourceMapParseException {
        SourceMapObject.Builder builder = SourceMapObject.builder();
        try {
            JsonObject sourceMapRoot = gson.fromJson(contents, JsonObject.class);
            builder.setVersion(sourceMapRoot.get("version").getAsInt());
            builder.setFile(SourceMapObjectParser.getStringOrNull(sourceMapRoot, "file"));
            builder.setLineCount(sourceMapRoot.has("lineCount") ? sourceMapRoot.get("lineCount").getAsInt() : -1);
            builder.setMappings(SourceMapObjectParser.getStringOrNull(sourceMapRoot, "mappings"));
            builder.setSourceRoot(SourceMapObjectParser.getStringOrNull(sourceMapRoot, "sourceRoot"));
            if (sourceMapRoot.has("sections")) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (JsonElement jsonElement : sourceMapRoot.get("sections").getAsJsonArray()) {
                    listBuilder.add(SourceMapObjectParser.buildSection(jsonElement.getAsJsonObject()));
                }
                builder.setSections((List<SourceMapSection>)((Object)listBuilder.build()));
            }
            builder.setSources(SourceMapObjectParser.getJavaStringArray(sourceMapRoot.get("sources")));
            builder.setSourcesContent(SourceMapObjectParser.getJavaStringArray(sourceMapRoot.get("sourcesContent")));
            builder.setNames(SourceMapObjectParser.getJavaStringArray(sourceMapRoot.get("names")));
            LinkedHashMap extensions = new LinkedHashMap();
            for (Map.Entry entry : sourceMapRoot.entrySet()) {
                if (!((String)entry.getKey()).startsWith("x_")) continue;
                extensions.put((String)entry.getKey(), entry.getValue());
            }
            builder.setExtensions(Collections.unmodifiableMap(extensions));
        }
        catch (JsonParseException ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
        return builder.build();
    }

    private static SourceMapSection buildSection(JsonObject section) throws SourceMapParseException {
        JsonObject offset = section.get("offset").getAsJsonObject();
        int line = offset.get("line").getAsInt();
        int column = offset.get("column").getAsInt();
        if (section.has("map") && section.has("url")) {
            throw new SourceMapParseException("Invalid map format: section may not have both 'map' and 'url'");
        }
        if (section.has("url")) {
            return SourceMapSection.forURL(section.get("url").getAsString(), line, column);
        }
        if (section.has("map")) {
            return SourceMapSection.forMap(section.get("map").toString(), line, column);
        }
        throw new SourceMapParseException("Invalid map format: section must have either 'map' or 'url'");
    }

    private static String getStringOrNull(JsonObject object, String key) {
        return object.has(key) ? object.get(key).getAsString() : null;
    }

    private static String[] getJavaStringArray(JsonElement element) {
        if (element == null || element instanceof JsonNull) {
            return null;
        }
        JsonArray array = element.getAsJsonArray();
        int len = array.size();
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            JsonElement item = array.get(i);
            result[i] = item.isJsonNull() ? null : item.getAsString();
        }
        return result;
    }

    private SourceMapObjectParser() {
    }
}

