/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

public class Ascii2Native {
    private static int HIGHEST_ASCII_CHARACTER = 127;
    private static String HEX_CHARACTERS = "0123456789ABCDEF";

    public static String native2Ascii(String nativeString) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < nativeString.length()) {
            char character = nativeString.charAt(index);
            if (character <= HIGHEST_ASCII_CHARACTER) {
                builder.append(character);
            } else {
                builder.append(String.format("\\u%1$04X", character));
            }
            ++index;
        }
        return builder.toString();
    }

    private static int decodeHexValue(String string, int index) {
        if (index + 6 <= string.length() && string.charAt(index) == '\\' && string.charAt(index + 1) == 'u') {
            boolean foundFourHex = true;
            int position = index + 2;
            while (position < index + 6) {
                if (HEX_CHARACTERS.indexOf(string.charAt(position)) == -1) {
                    foundFourHex = false;
                    break;
                }
                ++position;
            }
            if (foundFourHex) {
                String hexString = string.substring(index + 2, index + 6);
                int hex = Integer.parseInt(hexString, 16);
                return hex;
            }
        }
        return -1;
    }

    public static String ascii2Native(String ascii) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < ascii.length()) {
            int hexValue = Ascii2Native.decodeHexValue(ascii, index);
            if (hexValue == -1) {
                builder.append(ascii.charAt(index));
                ++index;
                continue;
            }
            builder.append((char)hexValue);
            index += 6;
        }
        return builder.toString();
    }
}

