/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolEnvCalc;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Trajectory;
import org.jmol.modelsetbio.BioModelSet;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public abstract class AtomCollection {
    private static final float almost180 = 2.984513f;
    private static final float sqrt3_2 = (float)(Math.sqrt(3.0) / 2.0);
    private static final V3 vRef = V3.new3(3.14159f, 2.71828f, 1.41421f);
    public Viewer vwr;
    protected GData g3d;
    public BioModelSet bioModelset;
    public Atom[] at;
    public int ac;
    public Trajectory trajectory;
    protected SymmetryInterface pointGroup;
    private LabelToken labeler;
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private boolean haveBSVisible;
    private boolean haveBSClickable;
    private BS bsSurface;
    private int nSurfaceAtoms;
    private int surfaceDistanceMax;
    protected boolean haveChirality;
    protected Bspf bspf = null;
    protected boolean preserveState = true;
    public boolean canSkipLoad = true;
    public boolean haveStraightness;
    private BS bsHidden;
    public BS bsVisible;
    public BS bsClickable;
    public BS bsModulated;
    public Object[][] atomTensorList;
    public Map<String, Lst<Object>> atomTensors;
    protected int[] surfaceDistance100s;
    public BS[] tainted;
    public static String[] userSettableValues;
    public static final int TAINT_ATOMNAME = 0;
    public static final int TAINT_ATOMTYPE = 1;
    public static final int TAINT_COORD = 2;
    public static final int TAINT_ELEMENT = 3;
    public static final int TAINT_FORMALCHARGE = 4;
    public static final int TAINT_HYDROPHOBICITY = 5;
    public static final int TAINT_BONDINGRADIUS = 6;
    public static final int TAINT_OCCUPANCY = 7;
    public static final int TAINT_PARTIALCHARGE = 8;
    public static final int TAINT_TEMPERATURE = 9;
    public static final int TAINT_VALENCE = 10;
    public static final int TAINT_VANDERWAALS = 11;
    public static final int TAINT_VIBRATION = 12;
    public static final int TAINT_ATOMNO = 13;
    public static final int TAINT_SEQID = 14;
    public static final int TAINT_RESNO = 15;
    public static final int TAINT_CHAIN = 16;
    public static final int TAINT_MAX = 17;
    String[] atomNames;
    String[] atomTypes;
    int[] atomSerials;
    int[] atomResnos;
    int[] atomSeqIDs;
    float[] dssrData;
    public Vibration[] vibrations;
    public float[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    float[] bondingRadii;
    float[] hydrophobicities;
    public BS bsPartialCharges;
    public static final int CALC_H_DOALL = 256;
    public static final int CALC_H_JUSTC = 512;
    public static final int CALC_H_HAVEH = 1024;
    public static final int CALC_H_QUICK = 4;
    public static final int CALC_H_IGNORE_H = 2048;
    int[] aaRet;
    private int atomCapacity;

    public Atom getAtom(int iatom) {
        return iatom >= 0 && iatom < this.at.length ? this.at[iatom] : null;
    }

    protected void setupAC() {
        this.bsHidden = new BS();
        this.bsVisible = new BS();
        this.bsClickable = new BS();
        if (userSettableValues == null) {
            userSettableValues = "atomName atomType coord element formalCharge hydrophobicity ionic occupancy partialCharge temperature valence vanderWaals vibrationVector atomNo seqID resNo chain".split(" ");
        }
    }

    protected void releaseModelSetAC() {
        this.at = null;
        this.vwr = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomTypes = null;
        this.atomResnos = null;
        this.dssrData = null;
        this.atomSerials = null;
        this.atomSeqIDs = null;
        this.vibrations = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.resetPartialCharges();
        this.bondingRadii = null;
        this.atomTensors = null;
    }

    protected void mergeAtomArrays(AtomCollection mergeModelSet) {
        this.tainted = mergeModelSet.tainted;
        this.atomNames = mergeModelSet.atomNames;
        this.atomTypes = mergeModelSet.atomTypes;
        this.atomResnos = mergeModelSet.atomResnos;
        this.dssrData = mergeModelSet.dssrData;
        this.atomSerials = mergeModelSet.atomSerials;
        this.atomSeqIDs = mergeModelSet.atomSeqIDs;
        this.vibrations = mergeModelSet.vibrations;
        this.occupancies = mergeModelSet.occupancies;
        this.bfactor100s = mergeModelSet.bfactor100s;
        this.bondingRadii = mergeModelSet.bondingRadii;
        this.partialCharges = mergeModelSet.partialCharges;
        this.bsPartialCharges = mergeModelSet.bsPartialCharges;
        this.atomTensors = mergeModelSet.atomTensors;
        this.atomTensorList = mergeModelSet.atomTensorList;
        this.bsModulated = mergeModelSet.bsModulated;
        this.haveStraightness = false;
        this.surfaceDistance100s = null;
    }

    public Lst<P3> getAtomPointVector(BS bs) {
        Lst<P3> v = new Lst<P3>();
        int n = this.ac;
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0 && i < n) {
                v.addLast(this.at[i]);
                i = bs.nextSetBit(i + 1);
            }
        }
        return v;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrations != null;
    }

    public String[] getAtomTypes() {
        return this.atomTypes;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public float[] getBondingRadii() {
        return this.bondingRadii;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public float[] getHydrophobicity() {
        return this.hydrophobicities;
    }

    public void setBsHidden(BS bs) {
        this.bsHidden = bs;
    }

    public boolean isAtomHidden(int iAtom) {
        return this.bsHidden.get(iAtom);
    }

    public LabelToken getLabeler() {
        return this.labeler == null ? (this.labeler = (LabelToken)Interface.getInterface("org.jmol.modelset.LabelToken", this.vwr, "ms")) : this.labeler;
    }

    public String getAtomInfo(int i, String format, P3 ptTemp) {
        return format == null ? this.at[i].getInfo() : this.getLabeler().formatLabel(this.vwr, this.at[i], format, ptTemp);
    }

    public String getElementName(int i) {
        return Elements.elementNameFromNumber(this.at[i].getAtomicAndIsotopeNumber());
    }

    public Quat getQuaternion(int i, char qtype) {
        return i < 0 ? null : this.at[i].group.getQuaternion(qtype);
    }

    public int getFirstAtomIndexFromAtomNumber(int atomNumber, BS bsVisibleFrames) {
        for (int i = 0; i < this.ac; ++i) {
            Atom atom = this.at[i];
            if (atom.getAtomNumber() != atomNumber || !bsVisibleFrames.get(atom.mi)) continue;
            return i;
        }
        return -1;
    }

    public void setFormalCharges(BS bs, int formalCharge) {
        if (bs != null) {
            this.resetPartialCharges();
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.at[i].setFormalCharge(formalCharge);
                this.taintAtom(i, 4);
                i = bs.nextSetBit(i + 1);
            }
        }
    }

    public float[] getAtomicCharges() {
        float[] charges = new float[this.ac];
        int i = this.ac;
        while (--i >= 0) {
            charges[i] = this.at[i].getElementNumber();
        }
        return charges;
    }

    protected float getRadiusVdwJmol(Atom atom) {
        return (float)Elements.getVanderwaalsMar(atom.getElementNumber(), VDW.JMOL) / 1000.0f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int i = this.ac;
        while (--i >= 0) {
            float f;
            float f2;
            Atom atom = this.at[i];
            float r = atom.getBondingRadius();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = r;
            }
            r = atom.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
            if (!(f > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = r;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BS bs) {
        if (this.hasBfactorRange) {
            return;
        }
        this.bfactor100Lo = Integer.MAX_VALUE;
        this.bfactor100Hi = Integer.MIN_VALUE;
        if (bs == null) {
            for (int i = 0; i < this.ac; ++i) {
                this.setBf(i);
            }
        } else {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.setBf(i);
                i = bs.nextSetBit(i + 1);
            }
        }
        this.hasBfactorRange = true;
    }

    private void setBf(int i) {
        int bf = this.at[i].getBfactor100();
        if (bf < this.bfactor100Lo) {
            this.bfactor100Lo = bf;
        } else if (bf > this.bfactor100Hi) {
            this.bfactor100Hi = bf;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.vwr.g.rangeSelected) {
                this.calcBfactorRange(this.vwr.bsA());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    public float calculateVolume(BS bs, VDW vType) {
        float volume = 0.0f;
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                volume += this.at[i].getVolume(this.vwr, vType);
                i = bs.nextSetBit(i + 1);
            }
        }
        return volume;
    }

    int getSurfaceDistance100(int atomIndex) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[atomIndex];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public P3[] calculateSurface(BS bsSelected, float envelopeRadius) {
        if (envelopeRadius < 0.0f) {
            envelopeRadius = 3.0f;
        }
        JmolEnvCalc ec = ((JmolEnvCalc)Interface.getOption("geodesic.EnvelopeCalculation", this.vwr, "ms")).set(this.vwr, this.ac, null);
        ec.calculate(new RadiusData(null, envelopeRadius, RadiusData.EnumType.ABSOLUTE, null), Float.MAX_VALUE, bsSelected, BSUtil.copyInvert(bsSelected, this.ac), false, false, false, true);
        P3[] points = ec.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = ec.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.ac];
        this.nSurfaceAtoms = BSUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || points == null || points.length == 0) {
            return points;
        }
        float radiusAdjust = envelopeRadius == Float.MAX_VALUE ? 0.0f : envelopeRadius;
        for (int i = 0; i < this.ac; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float dMin = Float.MAX_VALUE;
            Atom atom = this.at[i];
            int j = points.length;
            while (--j >= 0) {
                dMin = Math.min(Math.abs(points[j].distance(atom) - radiusAdjust), dMin);
            }
            int d = this.surfaceDistance100s[i] = (int)Math.floor(dMin * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, d);
        }
        return points;
    }

    protected void setAtomCoord2(BS bs, int tokType, Object xyzValues) {
        P3 xyz = null;
        P3[] values = null;
        Lst v = null;
        int type = 0;
        int nValues = 1;
        if (xyzValues instanceof P3) {
            xyz = (P3)xyzValues;
        } else if (xyzValues instanceof Lst) {
            v = (Lst)xyzValues;
            nValues = v.size();
            if (nValues == 0) {
                return;
            }
            type = 1;
        } else if (AU.isAP(xyzValues)) {
            values = (P3[])xyzValues;
            nValues = values.length;
            if (nValues == 0) {
                return;
            }
            type = 2;
        } else {
            return;
        }
        int n = 0;
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                switch (type) {
                    case 1: {
                        if (n >= nValues) {
                            return;
                        }
                        xyz = (P3)v.get(n++);
                        break;
                    }
                    case 2: {
                        if (n >= nValues) {
                            return;
                        }
                        xyz = values[n++];
                    }
                }
                if (xyz != null) {
                    switch (tokType) {
                        case 1145047050: {
                            this.setAtomCoord(i, xyz.x, xyz.y, xyz.z);
                            break;
                        }
                        case 1145047051: {
                            this.at[i].setFractionalCoordTo(xyz, true);
                            this.taintAtom(i, 2);
                            break;
                        }
                        case 1145047053: {
                            this.at[i].setFractionalCoordTo(xyz, false);
                            this.taintAtom(i, 2);
                            break;
                        }
                        case 1145047055: {
                            this.setAtomVibrationVector(i, xyz);
                        }
                    }
                }
                i = bs.nextSetBit(i + 1);
            }
        }
    }

    private void setAtomVibrationVector(int atomIndex, T3 vib) {
        this.setVibrationVector(atomIndex, vib);
        this.taintAtom(atomIndex, 12);
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.ac) {
            return;
        }
        Atom a = this.at[atomIndex];
        a.set(x, y, z);
        this.fixTrajectory(a);
        this.taintAtom(atomIndex, 2);
    }

    private void fixTrajectory(Atom a) {
        if (((ModelSet)this).isTrajectory(a.mi)) {
            this.trajectory.fixAtom(a);
        }
    }

    public void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.ac) {
            return;
        }
        Atom a = this.at[atomIndex];
        a.add3(x, y, z);
        this.fixTrajectory(a);
        this.taintAtom(atomIndex, 2);
    }

    protected void setAtomsCoordRelative(BS bs, float x, float y, float z) {
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.setAtomCoordRelative(i, x, y, z);
                i = bs.nextSetBit(i + 1);
            }
        }
    }

    protected void setAPa(BS bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        int n = 0;
        if (values != null && values.length == 0 || bs == null) {
            return;
        }
        boolean isAll = values != null && values.length == this.ac || list != null && list.length == this.ac;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            block41: {
                block42: {
                    block40: {
                        if (isAll) {
                            n = i;
                        }
                        if (values == null) break block40;
                        if (n >= values.length) {
                            return;
                        }
                        if (Float.isNaN(fValue = values[n++])) break block41;
                        iValue = (int)fValue;
                        break block42;
                    }
                    if (list != null) {
                        if (n >= list.length) {
                            return;
                        }
                        sValue = list[n++];
                    }
                }
                Atom atom = this.at[i];
                switch (tok) {
                    case 1086326786: {
                        this.setAtomName(i, sValue, true);
                        break;
                    }
                    case 1086326785: {
                        this.setAtomType(i, sValue);
                        break;
                    }
                    case 1086326788: {
                        this.setChainID(i, sValue);
                        break;
                    }
                    case 1094715393: {
                        this.setAtomNumber(i, iValue, true);
                        break;
                    }
                    case 1094713365: {
                        this.setAtomSeqID(i, iValue);
                        break;
                    }
                    case 1111492609: 
                    case 1111492629: {
                        this.setAtomCoord(i, fValue, atom.y, atom.z);
                        break;
                    }
                    case 1111492610: 
                    case 1111492630: {
                        this.setAtomCoord(i, atom.x, fValue, atom.z);
                        break;
                    }
                    case 1111492611: 
                    case 1111492631: {
                        this.setAtomCoord(i, atom.x, atom.y, fValue);
                        break;
                    }
                    case 1111492626: 
                    case 1111492627: 
                    case 1111492628: {
                        this.setVibrationVector2(i, tok, fValue);
                        break;
                    }
                    case 1111492612: 
                    case 1111492613: 
                    case 1111492614: {
                        atom.setFractionalCoord(tok, fValue, true);
                        this.taintAtom(i, 2);
                        break;
                    }
                    case 1111492615: 
                    case 1111492616: 
                    case 1111492617: {
                        atom.setFractionalCoord(tok, fValue, false);
                        this.taintAtom(i, 2);
                        break;
                    }
                    case 1086326789: 
                    case 1094715402: {
                        this.setElement(atom, iValue, true);
                        break;
                    }
                    case 1631586315: {
                        this.resetPartialCharges();
                        atom.setFormalCharge(iValue);
                        this.taintAtom(i, 4);
                        break;
                    }
                    case 1113589786: {
                        this.setHydrophobicity(i, fValue);
                        break;
                    }
                    case 1128269825: {
                        float f = fValue < 2.0f && fValue >= 0.01f ? 100.0f * fValue : fValue;
                        this.setOccupancy(i, f, true);
                        break;
                    }
                    case 1111492619: {
                        this.setPartialCharge(i, fValue, true);
                        break;
                    }
                    case 1111492618: {
                        this.setBondingRadius(i, fValue);
                        break;
                    }
                    case 1111492620: {
                        this.setBFactor(i, fValue, true);
                        break;
                    }
                    case 1094715412: {
                        this.setAtomResno(i, iValue);
                        break;
                    }
                    case 1287653388: 
                    case 1825200146: {
                        this.vwr.shm.setAtomLabel(sValue, i);
                        break;
                    }
                    case 1112152075: 
                    case 1665140738: {
                        float f = fValue;
                        if (f < 0.0f) {
                            f = 0.0f;
                        } else if (f > 16.0f) {
                            f = 16.1f;
                        }
                        atom.madAtom = (short)(f * 2000.0f);
                        break;
                    }
                    case 1113589787: {
                        this.vwr.slm.setSelectedAtom(atom.i, fValue != 0.0f);
                        break;
                    }
                    case 1094715417: {
                        atom.setValence(iValue);
                        this.taintAtom(i, 10);
                        break;
                    }
                    case 1648363544: {
                        if (atom.setRadius(fValue)) {
                            this.taintAtom(i, 11);
                            break;
                        }
                        this.untaint(i, 11);
                        break;
                    }
                    default: {
                        Logger.error("unsettable atom property: " + T.nameOf(tok));
                        return;
                    }
                }
            }
            i = bs.nextSetBit(i + 1);
        }
        switch (tok) {
            case 1113589787: {
                this.vwr.slm.setSelectedAtom(-1, false);
                break;
            }
            case 1112152075: 
            case 1665140738: {
                this.vwr.setShapeSize(0, Integer.MAX_VALUE, bs);
            }
        }
    }

    public float getVibCoord(int atomIndex, char c) {
        JmolModulationSet ms = null;
        Vibration v = null;
        switch (c) {
            case 'x': 
            case 'y': 
            case 'z': {
                v = this.getVibration(atomIndex, false);
                break;
            }
            default: {
                ms = this.getModulation(atomIndex);
                if (ms == null || (v = ms.getVibration(false)) != null) break;
                v = (Vibration)((Object)ms);
            }
        }
        if (v == null && ms == null) {
            return Float.NaN;
        }
        switch (c) {
            case 'X': 
            case 'x': {
                return v.x;
            }
            case 'Y': 
            case 'y': {
                return v.y;
            }
            case 'Z': 
            case 'z': {
                return v.z;
            }
            case 'O': {
                return ((Float)ms.getModulation('O', null)).floatValue();
            }
            case '1': 
            case '2': 
            case '3': {
                T3 t = (T3)ms.getModulation('T', null);
                float x = c == '1' ? t.x : (c == '2' ? t.y : t.z);
                return (float)((double)x - Math.floor(x));
            }
        }
        return Float.NaN;
    }

    public Vibration getVibration(int atomIndex, boolean forceNew) {
        Vibration v;
        Vibration vibration = v = this.vibrations == null ? null : this.vibrations[atomIndex];
        return v instanceof JmolModulationSet ? ((JmolModulationSet)((Object)v)).getVibration(forceNew) : (v == null && forceNew ? new Vibration() : v);
    }

    public JmolModulationSet getModulation(int iAtom) {
        Vibration v = this.vibrations == null ? null : this.vibrations[iAtom];
        return (JmolModulationSet)((Object)(v != null && v.modDim > 0 ? v : null));
    }

    protected void setVibrationVector(int atomIndex, T3 vib) {
        if (Float.isNaN(vib.x) || Float.isNaN(vib.y) || Float.isNaN(vib.z)) {
            return;
        }
        if (this.vibrations == null || this.vibrations.length < atomIndex) {
            this.vibrations = new Vibration[this.at.length];
        }
        if (vib instanceof Vibration) {
            this.vibrations[atomIndex] = (Vibration)vib;
        } else {
            if (this.vibrations[atomIndex] == null) {
                this.vibrations[atomIndex] = new Vibration();
            }
            this.vibrations[atomIndex].setXYZ(vib);
        }
        this.at[atomIndex].setVibrationVector();
    }

    private void setVibrationVector2(int atomIndex, int tok, float fValue) {
        Vibration v = this.getVibration(atomIndex, true);
        if (v == null) {
            return;
        }
        switch (tok) {
            case 1111492626: {
                v.x = fValue;
                break;
            }
            case 1111492627: {
                v.y = fValue;
                break;
            }
            case 1111492628: {
                v.z = fValue;
            }
        }
        this.setAtomVibrationVector(atomIndex, v);
    }

    public void setAtomName(int atomIndex, String name, boolean doTaint) {
        byte id;
        if (doTaint && name.equals(this.at[atomIndex].getAtomName())) {
            return;
        }
        this.at[atomIndex].atomID = id = ((ModelSet)this).am[this.at[atomIndex].mi].isBioModel ? this.vwr.getJBR().lookupSpecialAtomID(name) : (byte)0;
        if (id <= 0) {
            if (this.atomNames == null) {
                this.atomNames = new String[this.at.length];
            }
            this.atomNames[atomIndex] = name;
        }
        if (doTaint) {
            this.taintAtom(atomIndex, 0);
        }
    }

    private void setAtomType(int atomIndex, String type) {
        if (type.equals(this.at[atomIndex].getAtomType())) {
            return;
        }
        if (this.atomTypes == null) {
            this.atomTypes = new String[this.at.length];
        }
        this.atomTypes[atomIndex] = type;
    }

    private void setChainID(int atomIndex, String id) {
        if (id.equals(this.at[atomIndex].getChainIDStr())) {
            return;
        }
        int intid = this.at[atomIndex].getChainID();
        BS bs = this.getChainBits(intid);
        Chain c = this.at[atomIndex].group.chain;
        c.chainID = this.vwr.getChainID(id, true);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.taintAtom(i, 16);
            i = bs.nextSetBit(i + 1);
        }
    }

    public void setAtomNumber(int atomIndex, int atomno, boolean doTaint) {
        if (doTaint && atomno == this.at[atomIndex].getAtomNumber()) {
            return;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.at.length];
        }
        this.atomSerials[atomIndex] = atomno;
        if (doTaint) {
            this.taintAtom(atomIndex, 13);
        }
    }

    public void setElement(Atom atom, int atomicNumber, boolean doTaint) {
        if (doTaint && atom.getElementNumber() == atomicNumber) {
            return;
        }
        atom.setAtomicAndIsotopeNumber(atomicNumber);
        atom.paletteID = PAL.CPK.id;
        atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
        this.resetPartialCharges();
        if (doTaint) {
            this.taintAtom(atom.i, 3);
        }
    }

    private void resetPartialCharges() {
        this.partialCharges = null;
        this.bsPartialCharges = null;
    }

    private void setAtomResno(int atomIndex, int resno) {
        if (resno == this.at[atomIndex].getResno()) {
            return;
        }
        this.at[atomIndex].group.setResno(resno);
        if (this.atomResnos == null) {
            this.atomResnos = new int[this.at.length];
        }
        this.atomResnos[atomIndex] = resno;
        this.taintAtom(atomIndex, 15);
    }

    private void setAtomSeqID(int atomIndex, int seqID) {
        if (seqID == this.at[atomIndex].getSeqID()) {
            return;
        }
        if (this.atomSeqIDs == null) {
            this.atomSeqIDs = new int[this.at.length];
        }
        this.atomSeqIDs[atomIndex] = seqID;
        this.taintAtom(atomIndex, 14);
    }

    protected void setOccupancy(int atomIndex, float occupancy, boolean doTaint) {
        if (doTaint && occupancy == (float)this.at[atomIndex].getOccupancy100()) {
            return;
        }
        if (this.occupancies == null) {
            if (occupancy == 100.0f) {
                return;
            }
            this.occupancies = new float[this.at.length];
            int i = this.at.length;
            while (--i >= 0) {
                this.occupancies[i] = 100.0f;
            }
        }
        this.occupancies[atomIndex] = occupancy;
        if (doTaint) {
            this.taintAtom(atomIndex, 7);
        }
    }

    protected void setPartialCharge(int atomIndex, float partialCharge, boolean doTaint) {
        if (Float.isNaN(partialCharge)) {
            return;
        }
        if (this.partialCharges == null) {
            this.bsPartialCharges = new BS();
            if (partialCharge == 0.0f) {
                return;
            }
            this.partialCharges = new float[this.at.length];
        }
        this.bsPartialCharges.set(atomIndex);
        this.partialCharges[atomIndex] = partialCharge;
        if (doTaint) {
            this.taintAtom(atomIndex, 8);
        }
    }

    private void setBondingRadius(int atomIndex, float radius) {
        if (Float.isNaN(radius) || radius == this.at[atomIndex].getBondingRadius()) {
            return;
        }
        if (this.bondingRadii == null) {
            this.bondingRadii = new float[this.at.length];
        }
        this.bondingRadii[atomIndex] = radius;
        this.taintAtom(atomIndex, 6);
    }

    protected void setBFactor(int atomIndex, float bfactor, boolean doTaint) {
        if (Float.isNaN(bfactor) || doTaint && bfactor == (float)this.at[atomIndex].getBfactor100()) {
            return;
        }
        if (this.bfactor100s == null) {
            if (bfactor == 0.0f) {
                return;
            }
            this.bfactor100s = new short[this.at.length];
        }
        this.bfactor100s[atomIndex] = (short)((bfactor < -327.68f ? (double)-327.68f : ((double)bfactor > 327.67 ? 327.67 : (double)bfactor)) * 100.0 + (bfactor < 0.0f ? -0.5 : 0.5));
        if (doTaint) {
            this.taintAtom(atomIndex, 9);
        }
    }

    private void setHydrophobicity(int atomIndex, float value) {
        if (Float.isNaN(value) || value == this.at[atomIndex].getHydrophobicity()) {
            return;
        }
        if (this.hydrophobicities == null) {
            this.hydrophobicities = new float[this.at.length];
            for (int i = 0; i < this.at.length; ++i) {
                this.hydrophobicities[i] = Elements.getHydrophobicity(this.at[i].group.groupID);
            }
        }
        this.hydrophobicities[atomIndex] = value;
        this.taintAtom(atomIndex, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAtomData(int type, String name, String dataString, boolean isDefault) {
        float[] fData = null;
        BS bs = null;
        switch (type) {
            case 2: {
                this.loadCoordinates(dataString, false, !isDefault);
                return;
            }
            case 12: {
                this.loadCoordinates(dataString, true, true);
                return;
            }
            case 17: {
                fData = new float[this.ac];
                bs = BS.newN(this.ac);
                break;
            }
        }
        int[] lines = Parser.markLines(dataString, ';');
        int n = 0;
        try {
            int nData = PT.parseInt(dataString.substring(0, lines[0] - 1));
            int i = 1;
            while (true) {
                block27: {
                    if (i > nData) {
                        if (type != 17) return;
                        if (n <= 0) return;
                        this.vwr.setData(name, new Object[]{name, fData, bs, 1}, 0, 0, 0, 0, 0);
                        return;
                    }
                    String[] tokens = PT.getTokens(PT.parseTrimmed(dataString.substring(lines[i], lines[i + 1] - 1)));
                    int atomIndex = PT.parseInt(tokens[0]) - 1;
                    if (atomIndex >= 0 && atomIndex < this.ac) {
                        Atom atom = this.at[atomIndex];
                        ++n;
                        int pt = tokens.length - 1;
                        float x = PT.parseFloat(tokens[pt]);
                        switch (type) {
                            case 17: {
                                fData[atomIndex] = x;
                                bs.set(atomIndex);
                                break block27;
                            }
                            case 0: {
                                this.setAtomName(atomIndex, tokens[pt], true);
                                break;
                            }
                            case 13: {
                                this.setAtomNumber(atomIndex, (int)x, true);
                                break;
                            }
                            case 15: {
                                this.setAtomResno(atomIndex, (int)x);
                                break;
                            }
                            case 14: {
                                this.setAtomSeqID(atomIndex, (int)x);
                                break;
                            }
                            case 1: {
                                this.setAtomType(atomIndex, tokens[pt]);
                                break;
                            }
                            case 16: {
                                this.setChainID(atomIndex, tokens[pt]);
                                break;
                            }
                            case 3: {
                                atom.setAtomicAndIsotopeNumber((int)x);
                                atom.paletteID = PAL.CPK.id;
                                atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
                                break;
                            }
                            case 4: {
                                atom.setFormalCharge((int)x);
                                break;
                            }
                            case 5: {
                                this.setHydrophobicity(atomIndex, x);
                                break;
                            }
                            case 6: {
                                this.setBondingRadius(atomIndex, x);
                                break;
                            }
                            case 8: {
                                this.setPartialCharge(atomIndex, x, true);
                                break;
                            }
                            case 9: {
                                this.setBFactor(atomIndex, x, true);
                                break;
                            }
                            case 10: {
                                atom.setValence((int)x);
                                break;
                            }
                            case 11: {
                                atom.setRadius(x);
                            }
                        }
                        this.taintAtom(atomIndex, type);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.error("AtomCollection.loadData error: " + e);
        }
    }

    private void loadCoordinates(String data, boolean isVibrationVectors, boolean doTaint) {
        int[] lines = Parser.markLines(data, ';');
        V3 v = isVibrationVectors ? new V3() : null;
        try {
            int nData = PT.parseInt(data.substring(0, lines[0] - 1));
            for (int i = 1; i <= nData; ++i) {
                String[] tokens = PT.getTokens(PT.parseTrimmed(data.substring(lines[i], lines[i + 1])));
                int atomIndex = PT.parseInt(tokens[0]) - 1;
                float x = tokens[3].equalsIgnoreCase("1.4E-45") ? Float.MIN_VALUE : PT.parseFloat(tokens[3]);
                float y = tokens[4].equalsIgnoreCase("1.4E-45") ? Float.MIN_VALUE : PT.parseFloat(tokens[4]);
                float z = PT.parseFloat(tokens[5]);
                if (isVibrationVectors) {
                    v.set(x, y, z);
                    this.setAtomVibrationVector(atomIndex, v);
                    continue;
                }
                this.setAtomCoord(atomIndex, x, y, z);
                if (doTaint) continue;
                this.untaint(atomIndex, 2);
            }
        }
        catch (Exception e) {
            Logger.error("Frame.loadCoordinate error: " + e);
        }
    }

    public void validateBspf(boolean isValid) {
        if (this.bspf != null) {
            this.bspf.isValid = isValid;
        }
    }

    void validateBspfForModel(int modelIndex, boolean isValid) {
        if (this.bspf != null) {
            this.bspf.validateModel(modelIndex, isValid);
        }
    }

    public void setPreserveState(boolean TF) {
        this.preserveState = TF;
    }

    public static int getUserSettableType(String dataType) {
        boolean isExplicit = dataType.indexOf("property_") == 0;
        String check = isExplicit ? dataType.substring(9) : dataType;
        for (int i = 0; i < 17; ++i) {
            if (!userSettableValues[i].equalsIgnoreCase(check)) continue;
            return i;
        }
        return isExplicit ? 17 : -1;
    }

    public BS getTaintedAtoms(int type) {
        return this.tainted == null ? null : this.tainted[type];
    }

    public void taintAtoms(BS bsAtoms, int type) {
        this.canSkipLoad = false;
        if (!this.preserveState) {
            return;
        }
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            this.taintAtom(i, type);
            i = bsAtoms.nextSetBit(i + 1);
        }
    }

    public void taintAtom(int atomIndex, int type) {
        if (this.preserveState) {
            if (this.tainted == null) {
                this.tainted = new BS[17];
            }
            if (this.tainted[type] == null) {
                this.tainted[type] = BS.newN(this.ac);
            }
            this.tainted[type].set(atomIndex);
        }
        if (type == 2) {
            this.taintModelCoord(atomIndex);
        }
    }

    private void taintModelCoord(int atomIndex) {
        Model m = ((ModelSet)this).am[this.at[atomIndex].mi];
        this.validateBspfForModel(m.trajectoryBaseIndex, false);
        if (m.isBioModel) {
            m.resetDSSR(true);
        }
        this.pointGroup = null;
    }

    private void untaint(int atomIndex, int type) {
        if (!this.preserveState) {
            return;
        }
        if (this.tainted == null || this.tainted[type] == null) {
            return;
        }
        this.tainted[type].clear(atomIndex);
    }

    public void setTaintedAtoms(BS bs, int type) {
        int i;
        if (this.preserveState) {
            if (bs == null) {
                if (this.tainted == null) {
                    return;
                }
                this.tainted[type] = null;
                return;
            }
            if (this.tainted == null) {
                this.tainted = new BS[17];
            }
            if (this.tainted[type] == null) {
                this.tainted[type] = BS.newN(this.ac);
            }
            BSUtil.copy2(bs, this.tainted[type]);
        }
        if (type == 2 && (i = bs.nextSetBit(0)) >= 0) {
            this.taintModelCoord(i);
        }
    }

    public void unTaintAtoms(BS bs, int type) {
        if (this.tainted == null || this.tainted[type] == null) {
            return;
        }
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.tainted[type].clear(i);
            i = bs.nextSetBit(i + 1);
        }
        if (this.tainted[type].nextSetBit(0) < 0) {
            this.tainted[type] = null;
        }
    }

    protected void findNearest2(int x, int y, Atom[] closest, BS bsNot, int min) {
        Atom champion = null;
        int i = this.ac;
        while (--i >= 0) {
            Atom contender;
            if (bsNot != null && bsNot.get(i) || !(contender = this.at[i]).isClickable() || !this.isCursorOnTopOf(contender, x, y, min, champion)) continue;
            champion = contender;
        }
        closest[0] = champion;
    }

    boolean isCursorOnTopOf(Atom contender, int x, int y, int radius, Atom champion) {
        return contender.sZ > 1 && !this.g3d.isClippedZ(contender.sZ) && this.g3d.isInDisplayRange(contender.sX, contender.sY) && contender.isCursorOnTopOf(x, y, radius, champion);
    }

    protected void fillADa(AtomData atomData, int mode) {
        boolean includeRadii;
        atomData.atoms = this.at;
        atomData.xyz = this.at;
        atomData.ac = this.ac;
        atomData.atomicNumber = new int[this.ac];
        boolean bl = includeRadii = (mode & 2) != 0;
        if (includeRadii) {
            atomData.atomRadius = new float[this.ac];
        }
        boolean isMultiModel = (mode & 0x10) != 0;
        for (int i = 0; i < this.ac; ++i) {
            Atom atom = this.at[i];
            if (atom.isDeleted() || !isMultiModel && atomData.modelIndex >= 0 && atom.mi != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BS();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = atom.getElementNumber();
            atomData.lastModelIndex = atom.mi;
            if (!includeRadii) continue;
            atomData.atomRadius[i] = this.getWorkingRadius(atom, atomData);
        }
    }

    private float getWorkingRadius(Atom atom, AtomData atomData) {
        float r = 0.0f;
        RadiusData rd = atomData.radiusData;
        switch (rd.factorType) {
            case ABSOLUTE: {
                r = rd.value;
                break;
            }
            case FACTOR: 
            case OFFSET: {
                switch (rd.vdwType) {
                    case BONDING: {
                        r = atom.getBondingRadius();
                        break;
                    }
                    case ADPMAX: {
                        r = atom.getADPMinMax(true);
                        break;
                    }
                    case ADPMIN: {
                        r = atom.getADPMinMax(false);
                        break;
                    }
                    default: {
                        r = atom.getVanderwaalsRadiusFloat(this.vwr, atomData.radiusData.vdwType);
                    }
                }
                if (rd.factorType == RadiusData.EnumType.FACTOR) {
                    r *= rd.value;
                    break;
                }
                r += rd.value;
            }
        }
        return r + rd.valueExtended;
    }

    /*
     * Enabled aggressive block sorting
     */
    public P3[][] calculateHydrogens(BS bs, int[] nTotal, Lst<Atom> vConnect, int flags) {
        int nH;
        P3[][] hAtoms;
        block32: {
            boolean doAll = (flags & 0x100) == 256;
            boolean justCarbon = (flags & 0x200) == 512;
            boolean isQuick = (flags & 4) == 4;
            boolean ignoreH = (flags & 0x800) == 2048;
            V3 z = new V3();
            V3 x = new V3();
            hAtoms = new P3[this.ac][];
            BS bsDeleted = this.vwr.slm.bsDeleted;
            nH = 0;
            if (bs == null) break block32;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                block31: {
                    int hPt;
                    block34: {
                        P3 pt;
                        int nBonds;
                        int hybridization;
                        int targetValence;
                        int n;
                        float dHX;
                        int atomicNumber;
                        Atom atom;
                        block33: {
                            if (bsDeleted != null && bsDeleted.get(i)) break block31;
                            atom = this.at[i];
                            atomicNumber = atom.getElementNumber();
                            if (justCarbon && atomicNumber != 6) break block31;
                            dHX = atomicNumber <= 6 ? 1.1f : (atomicNumber <= 10 ? 1.0f : 1.3f);
                            switch (atomicNumber) {
                                case 7: 
                                case 8: {
                                    dHX = 1.0f;
                                    break;
                                }
                            }
                            int n2 = n = doAll || ignoreH ? atom.getCovalentHydrogenCount() : 0;
                            if (doAll && n > 0 || ignoreH && n == 0) break block31;
                            int nMissing = this.getMissingHydrogenCount(atom, false);
                            if (doAll && nMissing == 0) break block31;
                            if (!ignoreH) {
                                n = nMissing;
                            }
                            targetValence = this.aaRet[0];
                            hybridization = this.aaRet[2];
                            nBonds = this.aaRet[3] - (ignoreH ? n : 0);
                            if (nBonds == 0 && atom.isHetero()) break block31;
                            hAtoms[i] = new P3[n];
                            hPt = 0;
                            if (nBonds != 0) break block33;
                            switch (n) {
                                case 4: {
                                    z.set(0.635f, 0.635f, 0.635f);
                                    pt = P3.newP(z);
                                    pt.add(atom);
                                    hAtoms[i][hPt++] = pt;
                                    if (vConnect != null) {
                                        vConnect.addLast(atom);
                                    }
                                }
                                case 3: {
                                    z.set(-0.635f, -0.635f, 0.635f);
                                    pt = P3.newP(z);
                                    pt.add(atom);
                                    hAtoms[i][hPt++] = pt;
                                    if (vConnect != null) {
                                        vConnect.addLast(atom);
                                    }
                                }
                                case 2: {
                                    z.set(-0.635f, 0.635f, -0.635f);
                                    pt = P3.newP(z);
                                    pt.add(atom);
                                    hAtoms[i][hPt++] = pt;
                                    if (vConnect != null) {
                                        vConnect.addLast(atom);
                                    }
                                }
                                case 1: {
                                    z.set(0.635f, -0.635f, -0.635f);
                                    pt = P3.newP(z);
                                    pt.add(atom);
                                    hAtoms[i][hPt++] = pt;
                                    if (vConnect != null) {
                                        vConnect.addLast(atom);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block34;
                        }
                        block9 : switch (n) {
                            default: {
                                break;
                            }
                            case 3: {
                                this.getHybridizationAndAxes(i, atomicNumber, z, x, "sp3b", false, true, isQuick);
                                pt = new P3();
                                pt.scaleAdd2(dHX, z, atom);
                                hAtoms[i][hPt++] = pt;
                                if (vConnect != null) {
                                    vConnect.addLast(atom);
                                }
                                this.getHybridizationAndAxes(i, atomicNumber, z, x, "sp3c", false, true, isQuick);
                                pt = new P3();
                                pt.scaleAdd2(dHX, z, atom);
                                hAtoms[i][hPt++] = pt;
                                if (vConnect != null) {
                                    vConnect.addLast(atom);
                                }
                                this.getHybridizationAndAxes(i, atomicNumber, z, x, "sp3d", false, true, isQuick);
                                pt = new P3();
                                pt.scaleAdd2(dHX, z, atom);
                                hAtoms[i][hPt++] = pt;
                                if (vConnect == null) break;
                                vConnect.addLast(atom);
                                break;
                            }
                            case 2: {
                                boolean isEne;
                                boolean bl = isEne = hybridization == 2 || atomicNumber == 5 || nBonds == 1 && targetValence == 4 || atomicNumber == 7 && this.isAdjacentSp2(atom);
                                this.getHybridizationAndAxes(i, atomicNumber, z, x, isEne ? "sp2b" : (targetValence == 3 ? "sp3c" : "lpa"), false, true, isQuick);
                                pt = P3.newP(z);
                                pt.scaleAdd2(dHX, z, atom);
                                hAtoms[i][hPt++] = pt;
                                if (vConnect != null) {
                                    vConnect.addLast(atom);
                                }
                                this.getHybridizationAndAxes(i, atomicNumber, z, x, isEne ? "sp2c" : (targetValence == 3 ? "sp3d" : "lpb"), false, true, isQuick);
                                pt = P3.newP(z);
                                pt.scaleAdd2(dHX, z, atom);
                                hAtoms[i][hPt++] = pt;
                                if (vConnect == null) break;
                                vConnect.addLast(atom);
                                break;
                            }
                            case 1: {
                                switch (targetValence - nBonds) {
                                    case 1: {
                                        if (atomicNumber == 8 && atom == atom.group.getCarbonylOxygenAtom()) {
                                            hAtoms[i] = null;
                                            break block31;
                                        } else {
                                            if (this.getHybridizationAndAxes(i, atomicNumber, z, x, hybridization == 2 || atomicNumber == 5 || atomicNumber == 7 && (atom.group.getNitrogenAtom() == atom || this.isAdjacentSp2(atom)) ? "sp2c" : "sp3d", true, false, isQuick) != null) {
                                                pt = P3.newP(z);
                                                pt.scaleAdd2(dHX, z, atom);
                                                hAtoms[i][hPt++] = pt;
                                                if (vConnect == null) break block9;
                                                vConnect.addLast(atom);
                                                break block9;
                                            }
                                            hAtoms[i] = new P3[0];
                                            break block9;
                                        }
                                    }
                                    case 2: {
                                        this.getHybridizationAndAxes(i, atomicNumber, z, x, targetValence == 4 ? "sp2c" : "sp2b", false, false, isQuick);
                                        pt = P3.newP(z);
                                        pt.scaleAdd2(dHX, z, atom);
                                        hAtoms[i][hPt++] = pt;
                                        if (vConnect == null) break block9;
                                        vConnect.addLast(atom);
                                        break block9;
                                    }
                                    case 3: {
                                        this.getHybridizationAndAxes(i, atomicNumber, z, x, "spb", false, true, isQuick);
                                        pt = P3.newP(z);
                                        pt.scaleAdd2(dHX, z, atom);
                                        hAtoms[i][hPt++] = pt;
                                        if (vConnect == null) break block9;
                                        vConnect.addLast(atom);
                                    }
                                }
                            }
                        }
                    }
                    nH += hPt;
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        nTotal[0] = nH;
        return hAtoms;
    }

    private boolean isAdjacentSp2(Atom atom) {
        Bond[] bonds = atom.bonds;
        for (int i = 0; i < bonds.length; ++i) {
            Bond[] b2 = bonds[i].getOtherAtom((Atom)atom).bonds;
            for (int j = 0; j < b2.length; ++j) {
                switch (b2[j].order) {
                    case 2: 
                    case 3: 
                    case 514: 
                    case 515: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getMissingHydrogenCount(Atom atom, boolean allowNegative) {
        int n;
        String s;
        int targetCount = atom.getTargetValence();
        if (targetCount < 0) {
            return 0;
        }
        int charge = atom.getFormalCharge();
        int valence = atom.getValence();
        Model model = ((ModelSet)this).am[atom.mi];
        String string = s = model.isBioModel && !model.isPdbWithMultipleBonds ? atom.group.getGroup3() : null;
        if (this.aaRet == null) {
            this.aaRet = new int[5];
        }
        this.aaRet[0] = targetCount;
        this.aaRet[1] = charge;
        this.aaRet[2] = 0;
        this.aaRet[3] = atom.getCovalentBondCount();
        int n2 = this.aaRet[4] = s == null ? 0 : valence;
        if (s != null && charge == 0 && this.bioModelset.getAminoAcidValenceAndCharge(s, atom.getAtomName(), this.aaRet)) {
            targetCount = this.aaRet[0];
            charge = this.aaRet[1];
        }
        if (charge != 0) {
            this.aaRet[0] = targetCount += targetCount == 4 ? -Math.abs(charge) : charge;
        }
        return (n = targetCount - valence) < 0 && !allowNegative ? 0 : n;
    }

    public int fixFormalCharges(BS bs) {
        int n = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.at[i];
            int nH = this.getMissingHydrogenCount(a, true);
            if (nH != 0) {
                int c0 = a.getFormalCharge();
                int c = c0 - nH;
                a.setFormalCharge(c);
                this.taintAtom(i, 4);
                if (Logger.debugging) {
                    Logger.debug("atom " + a + " formal charge " + c0 + " -> " + c);
                }
                ++n;
            }
            i = bs.nextSetBit(i + 1);
        }
        return n;
    }

    public String getHybridizationAndAxes(int atomIndex, int atomicNumber, V3 z, V3 x, String lcaoTypeRaw, boolean hybridizationCompatible, boolean doAlignZ, boolean isQuick) {
        String lcaoType;
        String string = lcaoType = lcaoTypeRaw.length() > 0 && lcaoTypeRaw.charAt(0) == '-' ? lcaoTypeRaw.substring(1) : lcaoTypeRaw;
        if (lcaoTypeRaw.indexOf("d") >= 0 && !lcaoTypeRaw.endsWith("sp3d")) {
            return this.getHybridizationAndAxesD(atomIndex, z, x, lcaoType);
        }
        Atom atom = this.at[atomIndex];
        if (atomicNumber == 0) {
            atomicNumber = atom.getElementNumber();
        }
        Atom[] attached = this.getAttached(atom, 4, hybridizationCompatible, isQuick);
        int nAttached = attached.length;
        int pt = lcaoType.charAt(lcaoType.length() - 1) - 97;
        if (pt < 0 || pt > 6) {
            pt = 0;
        }
        z.set(0.0f, 0.0f, 0.0f);
        x.set(0.0f, 0.0f, 0.0f);
        V3[] v = new V3[4];
        for (int i = 0; i < nAttached; ++i) {
            Atom a = attached[i];
            if (a == null) {
                nAttached = i;
                break;
            }
            v[i] = V3.newVsub(atom, a);
            v[i].normalize();
            z.add(v[i]);
        }
        if (nAttached > 0) {
            x.setT(v[0]);
        }
        boolean isPlanar = false;
        V3 vTemp = new V3();
        if (nAttached >= 3) {
            if (x.angle(v[1]) < 2.984513f) {
                vTemp.cross(x, v[1]);
            } else {
                vTemp.cross(x, v[2]);
            }
            vTemp.normalize();
            V3 vTemp2 = new V3();
            if (v[1].angle(v[2]) < 2.984513f) {
                vTemp2.cross(v[1], v[2]);
            } else {
                vTemp2.cross(x, v[2]);
            }
            vTemp2.normalize();
            isPlanar = Math.abs(vTemp2.dot(vTemp)) >= 0.95f;
        }
        boolean isSp3 = lcaoType.indexOf("sp3") == 0;
        boolean isSp2 = !isSp3 && lcaoType.indexOf("sp2") == 0;
        boolean isSp = !isSp3 && !isSp2 && lcaoType.indexOf("sp") == 0;
        boolean isP = lcaoType.indexOf("p") == 0;
        boolean isLp = lcaoType.indexOf("lp") == 0;
        String hybridization = null;
        if (hybridizationCompatible) {
            if (nAttached == 0) {
                return null;
            }
            if (isSp3 ? pt > 3 || nAttached > 4 : (isSp2 ? pt > 2 || nAttached > 3 : isSp && (pt > 1 || nAttached > 2))) {
                return null;
            }
            switch (nAttached) {
                case 1: {
                    if (atomicNumber == 1 && !isSp3) {
                        return null;
                    }
                    if (isSp3) {
                        hybridization = "sp3";
                        break;
                    }
                    switch (attached[0].getCovalentBondCount()) {
                        case 1: {
                            if (attached[0].getValence() != 2) {
                                hybridization = "sp";
                                break;
                            }
                        }
                        case 2: {
                            hybridization = isSp ? "sp" : "sp2";
                            break;
                        }
                        case 3: {
                            if (!isSp2 && !isP) {
                                return null;
                            }
                            hybridization = "sp2";
                        }
                    }
                    break;
                }
                case 2: {
                    if (z.length() < 0.1f) {
                        if (lcaoType.indexOf("2") >= 0 || lcaoType.indexOf("3") >= 0) {
                            return null;
                        }
                        hybridization = "sp";
                        break;
                    }
                    String string2 = hybridization = isSp3 ? "sp3" : "sp2";
                    if (lcaoType.indexOf("sp") == 0) break;
                    if (isLp) {
                        hybridization = "lp";
                        break;
                    }
                    hybridization = lcaoType;
                    break;
                }
                default: {
                    if (isPlanar && !isQuick) {
                        hybridization = "sp2";
                        break;
                    }
                    if (isPlanar) {
                        z.setT(vTemp);
                    }
                    hybridization = isLp && nAttached == 3 ? "lp" : "sp3";
                }
            }
            if (hybridization == null) {
                return null;
            }
            if (lcaoType.indexOf("p") == 0 ? hybridization == "sp3" : lcaoType.indexOf(hybridization) < 0) {
                return null;
            }
        }
        if (pt < nAttached && !lcaoType.startsWith("p") && !lcaoType.startsWith("l")) {
            z.sub2(attached[pt], atom);
            z.normalize();
            return hybridization;
        }
        switch (nAttached) {
            case 0: {
                if (lcaoType.equals("sp3c") || lcaoType.equals("sp2d") || lcaoType.equals("lpa")) {
                    z.set(-0.5f, -0.7f, 1.0f);
                    x.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (lcaoType.equals("sp3b") || lcaoType.equals("lpb")) {
                    z.set(0.5f, -0.7f, -1.0f);
                    x.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (lcaoType.equals("sp3a")) {
                    z.set(0.0f, 1.0f, 0.0f);
                    x.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                z.set(0.0f, 0.0f, 1.0f);
                x.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                vTemp.setT(vRef);
                x.cross(vTemp, z);
                if (isSp3) {
                    int i = attached[0].getBondCount();
                    while (--i >= 0) {
                        if (!attached[0].bonds[i].isCovalent() || attached[0].getBondedAtomIndex(i) == atom.i) continue;
                        x.sub2(attached[0], attached[0].bonds[i].getOtherAtom(attached[0]));
                        x.cross(z, x);
                        if (x.length() == 0.0f) continue;
                        x.cross(x, z);
                        break;
                    }
                    x.normalize();
                    if (Float.isNaN(x.x)) {
                        x.setT(vRef);
                        x.cross(x, z);
                    }
                    vTemp.cross(z, x);
                    vTemp.normalize();
                    z.normalize();
                    x.scaleAdd2(2.828f, x, z);
                    if (pt != 3) {
                        x.normalize();
                        new M3().setAA(A4.new4(z.x, z.y, z.z, (float)(pt == 2 ? 1 : -1) * 2.0943952f)).rotate(x);
                    }
                    z.setT(x);
                    x.cross(vTemp, z);
                    break;
                }
                vTemp.cross(x, z);
                switch (attached[0].getCovalentBondCount()) {
                    case 1: {
                        if (attached[0].getValence() != 2) break;
                    }
                    case 2: {
                        boolean isCumulated = false;
                        Atom a0 = attached[0];
                        x.setT(z);
                        vTemp.setT(vRef);
                        while (a0 != null && a0.getCovalentBondCount() == 2) {
                            Bond[] bonds = a0.bonds;
                            Atom a = null;
                            isCumulated = !isCumulated;
                            for (int i = 0; i < bonds.length; ++i) {
                                if (!bonds[i].isCovalent() || (a = bonds[i].getOtherAtom(a0)) == atom) continue;
                                vTemp.sub2(a, a0);
                                break;
                            }
                            vTemp.cross(vTemp, x);
                            if (vTemp.length() > 0.1f || a.getCovalentBondCount() != 2) break;
                            atom = a0;
                            a0 = a;
                        }
                        if (vTemp.length() > 0.1f) {
                            z.cross(vTemp, x);
                            z.normalize();
                            if (pt == 1) {
                                z.scale(-1.0f);
                            }
                            z.scale(sqrt3_2);
                            z.scaleAdd2(0.5f, x, z);
                            if (isP) {
                                vTemp.cross(z, x);
                                z.setT(vTemp);
                                vTemp.setT(x);
                            }
                            x.cross(vTemp, z);
                            break;
                        }
                        z.setT(x);
                        x.cross(vRef, x);
                        break;
                    }
                    case 3: {
                        this.getHybridizationAndAxes(attached[0].i, 0, x, vTemp, "pz", false, doAlignZ, isQuick);
                        vTemp.setT(x);
                        if (isSp2) {
                            x.cross(x, z);
                            if (pt == 1) {
                                x.scale(-1.0f);
                            }
                            x.scale(sqrt3_2);
                            z.scaleAdd2(0.5f, z, x);
                        } else {
                            vTemp.setT(z);
                            z.setT(x);
                        }
                        x.cross(vTemp, z);
                    }
                }
                break;
            }
            case 2: {
                if (z.length() < 0.1f) {
                    if (!lcaoType.equals("pz")) {
                        boolean ok;
                        Atom a = attached[0];
                        boolean bl = ok = a.getCovalentBondCount() == 3;
                        if (!ok) {
                            a = attached[1];
                            boolean bl2 = ok = a.getCovalentBondCount() == 3;
                        }
                        if (ok) {
                            this.getHybridizationAndAxes(a.i, 0, x, z, "pz", false, doAlignZ, isQuick);
                            if (lcaoType.equals("px")) {
                                x.scale(-1.0f);
                            }
                            z.setT(v[0]);
                            break;
                        }
                        vTemp.setT(vRef);
                        z.cross(vTemp, x);
                        vTemp.cross(z, x);
                    }
                    z.setT(x);
                    x.cross(vTemp, z);
                    break;
                }
                vTemp.cross(z, x);
                if (isSp2) {
                    x.cross(z, vTemp);
                    break;
                }
                if (isSp3 || isLp) {
                    vTemp.normalize();
                    z.normalize();
                    if (!lcaoType.equals("lp")) {
                        if (pt == 0 || pt == 2) {
                            z.scaleAdd2(-1.2f, vTemp, z);
                        } else {
                            z.scaleAdd2(1.2f, vTemp, z);
                        }
                    }
                    x.cross(z, vTemp);
                    break;
                }
                x.cross(z, vTemp);
                z.setT(vTemp);
                if (!(z.z < 0.0f)) break;
                z.scale(-1.0f);
                x.scale(-1.0f);
                break;
            }
            default: {
                if (isSp3) break;
                if (!isPlanar) {
                    x.cross(z, x);
                    break;
                }
                z.setT(vTemp);
                if (!(z.z < 0.0f) || !doAlignZ) break;
                z.scale(-1.0f);
                x.scale(-1.0f);
            }
        }
        x.normalize();
        z.normalize();
        return hybridization;
    }

    private String getHybridizationAndAxesD(int atomIndex, V3 z, V3 x, String lcaoType) {
        if (lcaoType.startsWith("sp3d2")) {
            lcaoType = "d2sp3" + (lcaoType.length() == 5 ? "a" : lcaoType.substring(5));
        }
        if (lcaoType.startsWith("sp3d")) {
            lcaoType = "dsp3" + (lcaoType.length() == 4 ? "a" : lcaoType.substring(4));
        }
        if (lcaoType.equals("d2sp3") || lcaoType.equals("dsp3")) {
            lcaoType = lcaoType + "a";
        }
        boolean isTrigonal = lcaoType.startsWith("dsp3");
        int pt = lcaoType.charAt(lcaoType.length() - 1) - 97;
        if (z != null && (!isTrigonal && (pt > 5 || !lcaoType.startsWith("d2sp3")) || isTrigonal && pt > 4)) {
            return null;
        }
        Atom atom = this.at[atomIndex];
        Atom[] attached = this.getAttached(atom, 6, true, false);
        if (attached == null) {
            return z == null ? null : "?";
        }
        int nAttached = attached.length;
        if (nAttached < 3 && z != null) {
            return null;
        }
        boolean isLP = pt >= nAttached;
        int nAngles = nAttached * (nAttached - 1) / 2;
        int[][] angles = AU.newInt2(nAngles);
        int[] ntypes = new int[3];
        int[][] typePtrs = new int[3][nAngles];
        int n = 0;
        int _90 = 0;
        int _120 = 1;
        int _180 = 2;
        int n120_atom0 = 0;
        for (int i = 0; i < nAttached - 1; ++i) {
            for (int j = i + 1; j < nAttached; ++j) {
                float angle = Measure.computeAngleABC(attached[i], atom, attached[j], true);
                int itype = angle < 105.0f ? _90 : (angle >= 150.0f ? _180 : _120);
                typePtrs[itype][ntypes[itype]] = n;
                int n2 = itype;
                ntypes[n2] = ntypes[n2] + 1;
                angles[n++] = new int[]{i, j};
                if (i != 0 || itype != _120) continue;
                ++n120_atom0;
            }
        }
        n = ntypes[_90] * 100 + ntypes[_120] * 10 + ntypes[_180];
        if (z == null) {
            switch (n) {
                default: {
                    return "";
                }
                case 0: {
                    return "";
                }
                case 1: {
                    return "linear";
                }
                case 10: 
                case 100: {
                    return "bent";
                }
                case 111: 
                case 201: {
                    return "T-shaped";
                }
                case 30: 
                case 120: 
                case 210: 
                case 300: {
                    if (Math.abs(Measure.computeTorsion(attached[0], atom, attached[1], attached[2], true)) > 162.0f) {
                        return "trigonal planar";
                    }
                    return "trigonal pyramidal";
                }
                case 330: {
                    return n120_atom0 % 2 == 1 ? "tetrahedral" : "uncapped trigonal pyramid";
                }
                case 60: 
                case 150: 
                case 240: {
                    return "tetrahedral";
                }
                case 402: {
                    return "square planar";
                }
                case 411: 
                case 501: {
                    return "see-saw";
                }
                case 631: {
                    return "trigonal bipyramidal";
                }
                case 802: {
                    return "uncapped square pyramid";
                }
                case 1203: 
            }
            return "octahedral";
        }
        switch (n) {
            default: {
                return null;
            }
            case 201: {
                break;
            }
            case 210: 
            case 330: 
            case 411: 
            case 631: {
                if (isTrigonal) break;
                return null;
            }
            case 300: 
            case 402: 
            case 501: 
            case 802: 
            case 1203: {
                if (!isTrigonal) break;
                return null;
            }
        }
        if (isLP) {
            if (isTrigonal) {
                switch (ntypes[_120]) {
                    case 0: {
                        z.sub2(attached[angles[typePtrs[_90][0]][0]], atom);
                        x.sub2(attached[angles[typePtrs[_90][0]][1]], atom);
                        z.cross(z, x);
                        z.normalize();
                        if (pt == 4) {
                            z.scale(-1.0f);
                        }
                        BS bs = this.findNotAttached(nAttached, angles, typePtrs[_180], ntypes[_180]);
                        int i = bs.nextSetBit(0);
                        x.sub2(attached[i], atom);
                        x.normalize();
                        x.scale(0.5f);
                        z.scaleAdd2(sqrt3_2, z, x);
                        pt = -1;
                        break;
                    }
                    case 1: {
                        if (pt == 4) {
                            int[] a = angles[typePtrs[_120][0]];
                            z.add2(attached[a[0]], attached[a[1]]);
                            z.scaleAdd2(-2.0f, atom, z);
                            pt = -1;
                            break;
                        }
                        BS bs = this.findNotAttached(nAttached, angles, typePtrs[_120], ntypes[_120]);
                        pt = bs.nextSetBit(0);
                        break;
                    }
                    default: {
                        BS bs = this.findNotAttached(nAttached, angles, typePtrs[_120], ntypes[_120]);
                        pt = bs.nextSetBit(0);
                        break;
                    }
                }
            } else {
                int i;
                boolean isPlanar = false;
                if (nAttached == 4) {
                    switch (ntypes[_180]) {
                        case 1: {
                            BS bs = this.findNotAttached(nAttached, angles, typePtrs[_180], ntypes[_180]);
                            i = bs.nextSetBit(0);
                            if (pt == 4) {
                                pt = i;
                                break;
                            }
                            pt = bs.nextSetBit(i + 1);
                            break;
                        }
                        default: {
                            isPlanar = true;
                            break;
                        }
                    }
                } else {
                    BS bs = this.findNotAttached(nAttached, angles, typePtrs[_180], ntypes[_180]);
                    i = bs.nextSetBit(0);
                    for (int j = nAttached; j < pt && i >= 0; ++j) {
                        i = bs.nextSetBit(i + 1);
                    }
                    if (i == -1) {
                        isPlanar = true;
                    } else {
                        pt = i;
                    }
                }
                if (isPlanar) {
                    z.sub2(attached[angles[typePtrs[_90][0]][0]], atom);
                    x.sub2(attached[angles[typePtrs[_90][0]][1]], atom);
                    z.cross(z, x);
                    if (pt == 4) {
                        z.scale(-1.0f);
                    }
                    pt = -1;
                }
            }
        }
        if (pt >= 0) {
            z.sub2(attached[pt], atom);
        }
        if (isLP) {
            z.scale(-1.0f);
        }
        z.normalize();
        return isTrigonal ? "dsp3" : "d2sp3";
    }

    private Atom[] getAttached(Atom atom, int nMax, boolean doSort, boolean isQuick) {
        int nAttached = atom.getCovalentBondCount();
        if (nAttached > nMax) {
            return null;
        }
        Atom[] attached = new Atom[nAttached];
        if (nAttached > 0) {
            Bond[] bonds = atom.bonds;
            int n = 0;
            for (int i = 0; i < bonds.length; ++i) {
                if (!bonds[i].isCovalent()) continue;
                Atom a = bonds[i].getOtherAtom(atom);
                if (isQuick && a.getAtomicAndIsotopeNumber() == 1) continue;
                attached[n++] = a;
            }
            if (doSort && !isQuick) {
                Arrays.sort(attached, new AtomSorter());
            }
        }
        return attached;
    }

    private BS findNotAttached(int nAttached, int[][] angles, int[] ptrs, int nPtrs) {
        BS bs = BS.newN(nAttached);
        bs.setBits(0, nAttached);
        for (int i = 0; i < nAttached; ++i) {
            for (int j = 0; j < nPtrs; ++j) {
                int[] a = angles[ptrs[j]];
                if (a[0] != i && a[1] != i) continue;
                bs.clear(i);
            }
        }
        return bs;
    }

    public BS getAtomBitsMDa(int tokType, Object specInfo, BS bs) {
        int iSpec = specInfo instanceof Integer ? (Integer)specInfo : 0;
        switch (tokType) {
            case 1086326785: 
            case 1086326786: {
                boolean isType = tokType == 1086326785;
                String names = "," + specInfo + ",";
                int i = this.ac;
                while (--i >= 0) {
                    String s;
                    String string = s = isType ? this.at[i].getAtomType() : this.at[i].getAtomName();
                    if (names.indexOf("," + s + ",") < 0) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1094715393: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].getAtomNumber() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x200003: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].getCovalentBondCount() <= 0) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x200004: 
            case 0x20000E: 
            case 0x200010: 
            case 0x200012: 
            case 2097172: 
            case 2097174: 
            case 0x200020: 
            case 0x200024: 
            case 136314895: {
                return ((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getAtomBitsBS(tokType, null, bs) : bs;
            }
            case 1612709900: {
                iSpec = 1;
            }
            case 1094715402: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].getElementNumber() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x60200006: {
                int i = this.ac;
                while (--i >= 0) {
                    if (!this.at[i].isHetero()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x40000000: {
                return this.getIdentifierOrNull((String)specInfo);
            }
            case 0x20000D: {
                int i = this.ac;
                while (--i >= 0) {
                    if (!this.at[i].isLeadAtom()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1094713362: 
            case 1639976963: {
                return ((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getAtomBitsBS(tokType, (BS)specInfo, bs) : bs;
            }
            case 1094715412: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].getResno() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1612709912: {
                int[] hs = new int[2];
                int i = this.ac;
                while (--i >= 0) {
                    short g = this.at[i].group.groupID;
                    if (g >= 42 && g < 45) {
                        bs.set(i);
                        continue;
                    }
                    Atom a = this.at[i];
                    if (a.getElementNumber() != 8 || a.getCovalentBondCount() != 2) continue;
                    Bond[] bonds = a.bonds;
                    int n = 0;
                    int j = bonds.length;
                    while (--j >= 0 && n < 3) {
                        Atom b;
                        if (!bonds[j].isCovalent() || (b = bonds[j].getOtherAtom(a)).getElementNumber() != 1) continue;
                        hs[n++ % 2] = b.i;
                    }
                    if (n != 2) continue;
                    bs.set(hs[1]);
                    bs.set(hs[0]);
                    bs.set(i);
                }
                return bs;
            }
            case 1073742355: {
                String spec = (String)specInfo;
                int i = this.ac;
                while (--i >= 0) {
                    if (!this.isAltLoc(this.at[i].altloc, spec)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1073742356: {
                boolean allowStar;
                String atomSpec = ((String)specInfo).toUpperCase();
                if (atomSpec.indexOf("\\?") >= 0) {
                    atomSpec = PT.rep(atomSpec, "\\?", "\u0001");
                }
                if (allowStar = atomSpec.startsWith("?*")) {
                    atomSpec = atomSpec.substring(1);
                }
                int i = this.ac;
                while (--i >= 0) {
                    if (!this.isAtomNameMatch(this.at[i], atomSpec, allowStar, allowStar)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1073742357: {
                return BSUtil.copy(this.getChainBits(iSpec));
            }
            case 1073742360: {
                return this.getSpecName((String)specInfo);
            }
            case 1073742361: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].group.groupID != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1073742362: {
                return BSUtil.copy(this.getSeqcodeBits(iSpec, true));
            }
            case 5: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].group.getInsCode() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1296041986: {
                int i = this.ac;
                while (--i >= 0) {
                    if (this.at[i].getSymOp() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
        }
        BS bsInfo = (BS)specInfo;
        int i0 = bsInfo.nextSetBit(0);
        if (i0 < 0) {
            return bs;
        }
        switch (tokType) {
            case 1094717454: {
                BS bsTemp = BSUtil.copy(bsInfo);
                int i = i0;
                while (i >= 0) {
                    bs.or(((ModelSet)this).am[this.at[i].mi].bsAtoms);
                    bsTemp.andNot(bs);
                    i = bsTemp.nextSetBit(i + 1);
                }
                return bs;
            }
            case 1086326788: {
                BS bsTemp = BSUtil.copy(bsInfo);
                int i = i0;
                while (i >= 0) {
                    this.at[i].group.chain.setAtomBits(bs);
                    bsTemp.andNot(bs);
                    i = bsTemp.nextSetBit(i + 1);
                }
                return bs;
            }
            case 1086326789: {
                BS bsTemp = new BS();
                int i = i0;
                while (i >= 0) {
                    bsTemp.set(this.at[i].getElementNumber());
                    i = bsInfo.nextSetBit(i + 1);
                }
                i = this.ac;
                while (--i >= 0) {
                    if (!bsTemp.get(this.at[i].getElementNumber())) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1086324742: {
                BS bsTemp = BSUtil.copy(bsInfo);
                int i = i0;
                while (i >= 0) {
                    this.at[i].group.setAtomBits(bs);
                    bsTemp.andNot(bs);
                    i = bsTemp.nextSetBit(i + 1);
                }
                return bs;
            }
            case 1094713366: {
                BS bsTemp = new BS();
                int i = i0;
                while (i >= 0) {
                    bsTemp.set(this.at[i].atomSite);
                    i = bsInfo.nextSetBit(i + 1);
                }
                i = this.ac;
                while (--i >= 0) {
                    if (!bsTemp.get(this.at[i].atomSite)) continue;
                    bs.set(i);
                }
                return bs;
            }
        }
        Logger.error("MISSING getAtomBits entry for " + T.nameOf(tokType));
        return bs;
    }

    public BS getChainBits(int chainID) {
        boolean caseSensitive = this.vwr.getBoolean(603979822);
        if (chainID >= 0 && chainID < 300 && !caseSensitive) {
            chainID = this.chainToUpper(chainID);
        }
        BS bs = new BS();
        BS bsDone = BS.newN(this.ac);
        int i = bsDone.nextClearBit(0);
        while (i < this.ac) {
            Chain chain = this.at[i].group.chain;
            int id = chain.chainID;
            if (chainID == id || !caseSensitive && id >= 0 && id < 300 && chainID == this.chainToUpper(id)) {
                chain.setAtomBits(bs);
                bsDone.or(bs);
            } else {
                chain.setAtomBits(bsDone);
            }
            i = bsDone.nextClearBit(i + 1);
        }
        return bs;
    }

    public int chainToUpper(int chainID) {
        return chainID >= 97 && chainID <= 122 ? chainID - 32 : (chainID >= 256 && chainID < 300 ? chainID - 191 : chainID);
    }

    private boolean isAltLoc(char altloc, String strPattern) {
        if (strPattern == null) {
            return altloc == '\u0000';
        }
        if (strPattern.length() != 1) {
            return false;
        }
        char ch = strPattern.charAt(0);
        return ch == '*' || ch == '?' && altloc != '\u0000' || altloc == ch;
    }

    public BS getSeqcodeBits(int seqcode, boolean returnEmpty) {
        BS bs = new BS();
        int seqNum = Group.getSeqNumberFor(seqcode);
        boolean haveSeqNumber = seqNum != Integer.MAX_VALUE;
        boolean isEmpty = true;
        char insCode = Group.getInsertionCodeChar(seqcode);
        switch (insCode) {
            case '?': {
                int i = this.ac;
                while (--i >= 0) {
                    int atomSeqcode = this.at[i].group.seqcode;
                    if (haveSeqNumber && seqNum != Group.getSeqNumberFor(atomSeqcode) || Group.getInsertionCodeFor(atomSeqcode) == 0) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break;
            }
            default: {
                int i = this.ac;
                while (--i >= 0) {
                    int atomSeqcode = this.at[i].group.seqcode;
                    if (seqcode != atomSeqcode && (haveSeqNumber || seqcode != Group.getInsertionCodeFor(atomSeqcode)) && (insCode != '*' || seqNum != Group.getSeqNumberFor(atomSeqcode))) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break block0;
            }
        }
        return !isEmpty || returnEmpty ? bs : null;
    }

    private BS getIdentifierOrNull(String identifier) {
        BS bs = this.getSpecNameOrNull(identifier, false);
        if (identifier.indexOf("\\?") >= 0) {
            identifier = PT.rep(identifier, "\\?", "\u0001");
        }
        return bs != null || identifier.indexOf("?") > 0 ? bs : (identifier.indexOf("*") > 0 ? this.getSpecNameOrNull(identifier, true) : (((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getIdentifierOrNull(identifier) : null));
    }

    private BS getSpecName(String name) {
        BS bs = this.getSpecNameOrNull(name, false);
        if (bs != null) {
            return bs;
        }
        if (name.indexOf("*") > 0) {
            bs = this.getSpecNameOrNull(name, true);
        }
        return bs == null ? new BS() : bs;
    }

    public BS getSpecNameOrNull(String name, boolean checkStar) {
        boolean allowInitialStar;
        BS bs = null;
        if ((name = name.toUpperCase()).indexOf("\\?") >= 0) {
            name = PT.rep(name, "\\?", "\u0001");
        }
        if (allowInitialStar = name.startsWith("?*")) {
            name = name.substring(1);
        }
        int i = this.ac;
        while (--i >= 0) {
            String g3 = this.at[i].getGroup3(true);
            if (g3 != null && g3.length() > 0) {
                if (!PT.isMatch(g3, name, checkStar, true)) continue;
                if (bs == null) {
                    bs = BS.newN(i + 1);
                }
                bs.set(i);
                while (--i >= 0 && this.at[i].getGroup3(true).equals(g3)) {
                    bs.set(i);
                }
                ++i;
                continue;
            }
            if (!this.isAtomNameMatch(this.at[i], name, checkStar, allowInitialStar)) continue;
            if (bs == null) {
                bs = BS.newN(i + 1);
            }
            bs.set(i);
        }
        return bs;
    }

    private boolean isAtomNameMatch(Atom atom, String strPattern, boolean checkStar, boolean allowInitialStar) {
        return PT.isMatch(atom.getAtomName().toUpperCase(), strPattern, checkStar, allowInitialStar);
    }

    public int[] getAtomIndices(BS bs) {
        int n = 0;
        int[] indices = new int[this.ac];
        int j = bs.nextSetBit(0);
        while (j >= 0 && j < this.ac) {
            indices[j] = ++n;
            j = bs.nextSetBit(j + 1);
        }
        return indices;
    }

    public BS getAtomsNearPlane(float distance, P4 plane) {
        BS bsResult = new BS();
        int i = this.ac;
        while (--i >= 0) {
            Atom atom = this.at[i];
            float d = Measure.distanceToPlane(plane, atom);
            if (!(distance > 0.0f && (double)d >= -0.1 && d <= distance || distance < 0.0f && (double)d <= 0.1 && d >= distance) && (distance != 0.0f || !((double)Math.abs(d) < 0.01))) continue;
            bsResult.set(atom.i);
        }
        return bsResult;
    }

    public void clearVisibleSets() {
        this.haveBSVisible = false;
        this.haveBSClickable = false;
    }

    public void getAtomsInFrame(BS bsAtoms) {
        this.clearVisibleSets();
        bsAtoms.clearAll();
        int i = this.ac;
        while (--i >= 0) {
            if (!this.at[i].isVisible(1)) continue;
            bsAtoms.set(i);
        }
    }

    public BS getVisibleSet(boolean forceNew) {
        if (forceNew) {
            this.vwr.setModelVisibility();
            this.vwr.shm.finalizeAtoms(null, true);
        } else if (this.haveBSVisible) {
            return this.bsVisible;
        }
        this.bsVisible.clearAll();
        int i = this.ac;
        while (--i >= 0) {
            if (!this.at[i].checkVisible()) continue;
            this.bsVisible.set(i);
        }
        if (this.vwr.shm.bsSlabbedInternal != null) {
            this.bsVisible.andNot(this.vwr.shm.bsSlabbedInternal);
        }
        this.haveBSVisible = true;
        return this.bsVisible;
    }

    public BS getClickableSet(boolean forceNew) {
        if (forceNew) {
            this.vwr.setModelVisibility();
        } else if (this.haveBSClickable) {
            return this.bsClickable;
        }
        this.bsClickable.clearAll();
        int i = this.ac;
        while (--i >= 0) {
            if (!this.at[i].isClickable()) continue;
            this.bsClickable.set(i);
        }
        this.haveBSClickable = true;
        return this.bsClickable;
    }

    public boolean isModulated(int i) {
        return this.bsModulated != null && this.bsModulated.get(i);
    }

    protected void deleteModelAtoms(int firstAtomIndex, int nAtoms, BS bsAtoms) {
        this.at = (Atom[])AU.deleteElements(this.at, firstAtomIndex, nAtoms);
        this.ac = this.at.length;
        for (int j = firstAtomIndex; j < this.ac; ++j) {
            this.at[j].i = j;
            this.at[j].mi = (short)(this.at[j].mi - 1);
        }
        if (this.bsModulated != null) {
            BSUtil.deleteBits(this.bsModulated, bsAtoms);
        }
        this.deleteAtomTensors(bsAtoms);
        this.atomNames = (String[])AU.deleteElements(this.atomNames, firstAtomIndex, nAtoms);
        this.atomTypes = (String[])AU.deleteElements(this.atomTypes, firstAtomIndex, nAtoms);
        this.atomResnos = (int[])AU.deleteElements(this.atomResnos, firstAtomIndex, nAtoms);
        this.atomSerials = (int[])AU.deleteElements(this.atomSerials, firstAtomIndex, nAtoms);
        this.atomSeqIDs = (int[])AU.deleteElements(this.atomSeqIDs, firstAtomIndex, nAtoms);
        this.dssrData = (float[])AU.deleteElements(this.dssrData, firstAtomIndex, nAtoms);
        this.bfactor100s = (short[])AU.deleteElements(this.bfactor100s, firstAtomIndex, nAtoms);
        this.hasBfactorRange = false;
        this.occupancies = (float[])AU.deleteElements(this.occupancies, firstAtomIndex, nAtoms);
        this.resetPartialCharges();
        this.atomTensorList = (Object[][])AU.deleteElements(this.atomTensorList, firstAtomIndex, nAtoms);
        this.vibrations = (Vibration[])AU.deleteElements(this.vibrations, firstAtomIndex, nAtoms);
        this.nSurfaceAtoms = 0;
        this.bsSurface = null;
        this.surfaceDistance100s = null;
        if (this.tainted != null) {
            for (int i = 0; i < 17; ++i) {
                BSUtil.deleteBits(this.tainted[i], bsAtoms);
            }
        }
    }

    public void getAtomIdentityInfo(int i, Map<String, Object> info, P3 ptTemp) {
        info.put("_ipt", i);
        info.put("atomIndex", i);
        info.put("atomno", this.at[i].getAtomNumber());
        info.put("info", this.getAtomInfo(i, null, ptTemp));
        info.put("sym", this.at[i].getElementSymbol());
    }

    public Object[] getAtomTensorList(int i) {
        return i < 0 || this.atomTensorList == null || i >= this.atomTensorList.length ? null : this.atomTensorList[i];
    }

    private void deleteAtomTensors(BS bsAtoms) {
        if (this.atomTensors == null) {
            return;
        }
        Lst<String> toDelete = new Lst<String>();
        for (String key : this.atomTensors.keySet()) {
            Lst<Object> list = this.atomTensors.get(key);
            int i = list.size();
            while (--i >= 0) {
                Tensor t = (Tensor)list.get(i);
                if (!bsAtoms.get(t.atomIndex1) && (t.atomIndex2 < 0 || !bsAtoms.get(t.atomIndex2))) continue;
                list.removeItemAt(i);
            }
            if (list.size() != 0) continue;
            toDelete.addLast(key);
        }
        int i = toDelete.size();
        while (--i >= 0) {
            this.atomTensors.remove(toDelete.get(i));
        }
    }

    void setCapacity(int nAtoms) {
        this.atomCapacity += nAtoms;
    }

    public void setAtomTensors(int atomIndex, Lst<Object> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.atomTensors == null) {
            this.atomTensors = new Hashtable<String, Lst<Object>>();
        }
        if (this.atomTensorList == null) {
            this.atomTensorList = new Object[this.at.length][];
        }
        this.atomTensorList = (Object[][])AU.ensureLength(this.atomTensorList, this.at.length);
        this.atomTensorList[atomIndex] = AtomCollection.getTensorList(list);
        int i = list.size();
        while (--i >= 0) {
            Tensor t = (Tensor)list.get(i);
            t.atomIndex1 = atomIndex;
            t.atomIndex2 = -1;
            t.modelIndex = this.at[atomIndex].mi;
            this.addTensor(t, t.type);
            if (t.altType == null) continue;
            this.addTensor(t, t.altType);
        }
    }

    public void addTensor(Tensor t, String type) {
        Lst<Object> tensors = this.atomTensors.get(type = type.toLowerCase());
        if (tensors == null) {
            tensors = new Lst();
            this.atomTensors.put(type, tensors);
            tensors.ensureCapacity(this.atomCapacity);
        }
        tensors.addLast(t);
    }

    private static Object[] getTensorList(Lst<Object> list) {
        int n;
        int pt = -1;
        boolean haveTLS = false;
        int i = n = list.size();
        while (--i >= 0) {
            Tensor t = (Tensor)list.get(i);
            if (t.forThermalEllipsoid) {
                pt = i;
                continue;
            }
            if (t.iType != 2) continue;
            haveTLS = true;
        }
        Object[] a = new Object[(pt >= 0 || !haveTLS ? 0 : 1) + n];
        if (pt >= 0) {
            a[0] = list.get(pt);
            if (list.size() == 1) {
                return a;
            }
        }
        if (haveTLS) {
            pt = 0;
            int i2 = n;
            while (--i2 >= 0) {
                Tensor t = (Tensor)list.get(i2);
                if (t.forThermalEllipsoid) continue;
                a[++pt] = t;
            }
        } else {
            for (int i3 = 0; i3 < n; ++i3) {
                a[i3] = list.get(i3);
            }
        }
        return a;
    }

    public Tensor getAtomTensor(int i, String type) {
        Object[] tensors = this.getAtomTensorList(i);
        if (tensors != null && type != null) {
            type = type.toLowerCase();
            for (int j = 0; j < tensors.length; ++j) {
                Tensor t = (Tensor)tensors[j];
                if (t == null || !type.equals(t.type) && !type.equals(t.altType)) continue;
                return t;
            }
        }
        return null;
    }

    public Lst<Object> getAllAtomTensors(String type) {
        if (this.atomTensors == null) {
            return null;
        }
        if (type != null) {
            return this.atomTensors.get(type.toLowerCase());
        }
        Lst<Object> list = new Lst<Object>();
        for (Map.Entry<String, Lst<Object>> e : this.atomTensors.entrySet()) {
            list.addAll((Collection)e.getValue());
        }
        return list;
    }

    public void scaleVectorsToMax(float max) {
        if (this.vibrations == null) {
            return;
        }
        float m = 0.0f;
        BS bsVib = BS.newN(this.ac);
        int i = this.vibrations.length;
        while (--i >= 0) {
            Vibration v = this.getVibration(i, false);
            if (v == null || v.modDim != -1 && v.modDim != -2) continue;
            m = Math.max(m, v.length());
            bsVib.set(i);
        }
        if (m == max || m == 0.0f) {
            return;
        }
        m = max / m;
        boolean ok = false;
        int i2 = bsVib.nextSetBit(0);
        while (i2 >= 0) {
            Vibration v = this.getVibration(i2, false);
            JmolModulationSet mod = this.getModulation(i2);
            if (mod == null) {
                if (m == 0.0f) {
                    return;
                }
                v.scale(m);
            } else {
                mod.scaleVibration(m);
            }
            if (!ok) {
                this.taintAtom(i2, 12);
                ok = true;
            }
            i2 = bsVib.nextSetBit(i2 + 1);
        }
        this.tainted[12].or(bsVib);
    }

    public BS getAtomsFromAtomNumberInFrame(int atomNumber) {
        BS bs = this.vwr.getFrameAtoms();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (this.at[i].getAtomNumber() != atomNumber) {
                bs.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
        return bs;
    }

    public Lst<P3> generateCrystalClass(int atomIndex, P3 pt) {
        boolean isRandom;
        SymmetryInterface sym = atomIndex < 0 || atomIndex >= this.ac ? null : this.at[atomIndex].getUnitCell();
        boolean bl = isRandom = pt != null && Float.isNaN(pt.x);
        return sym == null ? new Lst<P3>() : sym.generateCrystalClass(isRandom ? null : (pt != null ? pt : this.at[atomIndex]));
    }

    protected class AtomSorter
    implements Comparator<Atom> {
        protected AtomSorter() {
        }

        @Override
        public int compare(Atom a1, Atom a2) {
            return a1.i > a2.i ? 1 : (a1.i < a2.i ? -1 : 0);
        }
    }
}

