/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteBuildReporter;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.BuildReportICReporter;
import org.jetbrains.kotlin.daemon.report.CompileIterationICReporter;
import org.jetbrains.kotlin.daemon.report.CompositeICReporter;
import org.jetbrains.kotlin.daemon.report.DebugMessagesICReporter;
import org.jetbrains.kotlin.daemon.report.RemoteBuildMetricsReporterAdapter;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getBuildReporter", "Lorg/jetbrains/kotlin/build/report/RemoteBuildReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/IncrementalCompilationOptions;", "kotlin-daemon"})
public final class GetICReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RemoteBuildReporter getBuildReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationResults compilationResults, @NotNull IncrementalCompilationOptions compilationOptions) {
        Iterator $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationResults, (String)"compilationResults");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        File root = compilationOptions.getModulesInfo().getProjectRoot();
        ArrayList<ICReporterBase> reporters = new ArrayList<ICReporterBase>();
        if (ArraysKt.contains((Object[])compilationOptions.getReportCategories(), (Object)ReportCategory.IC_MESSAGE.getCode())) {
            boolean isVerbose = compilationOptions.getReportSeverity() == ReportSeverity.DEBUG.getCode();
            reporters.add(new DebugMessagesICReporter(servicesFacade, root, isVerbose));
        }
        Integer[] integerArray = compilationOptions.getRequestedCompilationResults();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        void var11_17 = $this$forEach$iv$iv;
        int n = ((void)var11_17).length;
        for (int i = 0; i < n; ++i) {
            CompilationResultCategory compilationResultCategory;
            void element$iv$iv;
            void element$iv = element$iv$iv = var11_17[i];
            boolean bl = false;
            int resultCode = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if ((CompilationResultCategory)((Object)ArraysKt.getOrNull((Object[])CompilationResultCategory.values(), (int)resultCode)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            CompilationResultCategory it$iv = compilationResultCategory;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        HashSet requestedResults = (HashSet)destination$iv;
        $this$mapNotNullTo$iv = requestedResults.iterator();
        while ($this$mapNotNullTo$iv.hasNext()) {
            CompilationResultCategory requestedResult;
            CompilationResultCategory compilationResultCategory = requestedResult = (CompilationResultCategory)((Object)$this$mapNotNullTo$iv.next());
            int n2 = WhenMappings.$EnumSwitchMapping$0[compilationResultCategory.ordinal()];
            switch (n2) {
                case 1: {
                    reporters.add(new CompileIterationICReporter(compilationResults));
                    break;
                }
                case 2: {
                    reporters.add(new BuildReportICReporter(compilationResults, root, false, 4, null));
                    break;
                }
                case 3: {
                    reporters.add(new BuildReportICReporter(compilationResults, root, true));
                }
            }
        }
        boolean areBuildMetricsNeeded = requestedResults.contains((Object)CompilationResultCategory.BUILD_METRICS);
        BuildMetricsReporter buildMetricsReporter = areBuildMetricsNeeded ? (BuildMetricsReporter)new BuildMetricsReporterImpl() : (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE;
        boolean bl = false;
        boolean bl6 = false;
        BuildMetricsReporter it = buildMetricsReporter;
        boolean bl7 = false;
        RemoteBuildMetricsReporterAdapter metricsReporter = new RemoteBuildMetricsReporterAdapter(it, areBuildMetricsNeeded, compilationResults);
        return new RemoteBuildReporter((RemoteICReporter)new CompositeICReporter((Iterable<? extends RemoteICReporter>)reporters), (RemoteBuildMetricsReporter)metricsReporter);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilationResultCategory.values().length];
            nArray[CompilationResultCategory.IC_COMPILE_ITERATION.ordinal()] = 1;
            nArray[CompilationResultCategory.BUILD_REPORT_LINES.ordinal()] = 2;
            nArray[CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.ordinal()] = 3;
            nArray[CompilationResultCategory.BUILD_METRICS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

