/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlinx.io.ByteBuffer;
import kotlinx.io.ByteOrder;
import kotlinx.serialization.KInput;
import kotlinx.serialization.KOutput;
import kotlinx.serialization.KSerialClassDesc;
import kotlinx.serialization.KSerialLoader;
import kotlinx.serialization.KSerialSaver;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.ScopeKt;
import kotlinx.serialization.SerialContext;
import kotlinx.serialization.SerialId;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.TaggedInput;
import kotlinx.serialization.TaggedOutput;
import kotlinx.serialization.internal.HexConverter;
import kotlinx.serialization.internal.UtilKt;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufDecoder$WhenMappings;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufEncoder$WhenMappings;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufReader$WhenMappings;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufWriter$WhenMappings;
import kotlinx.serialization.protobuf.ProtoNumberType;
import kotlinx.serialization.protobuf.ProtoType;
import kotlinx.serialization.protobuf.ProtobufDecodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u001b2\u00020\u0001:\u000b\u001b\u001c\u001d\u001e\u001f !\"#$%B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\n\u001a\u0002H\tH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ+\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\n\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000f\u001a\u00020\u0010\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\n\u001a\u0002H\tH\u0086\b\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u0002H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\bH\u0086\b\u00a2\u0006\u0002\u0010\u0014J+\u0010\u0012\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\t0\u00162\u0006\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u0002H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf;", "", "context", "Lkotlinx/serialization/SerialContext;", "(Lkotlinx/serialization/SerialContext;)V", "getContext", "()Lkotlinx/serialization/SerialContext;", "dump", "", "T", "obj", "(Ljava/lang/Object;)[B", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)[B", "dumps", "", "(Ljava/lang/Object;)Ljava/lang/String;", "load", "raw", "([B)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;[B)Ljava/lang/Object;", "loads", "hex", "(Ljava/lang/String;)Ljava/lang/Object;", "Companion", "MapEntryReader", "MapEntryWriter", "ObjectWriter", "ProtobufDecoder", "ProtobufEncoder", "ProtobufReader", "ProtobufWriter", "RepeatedReader", "RepeatedWriter", "Varint", "kotlinx-serialization-runtime"})
public final class ProtoBuf {
    @Nullable
    private final SerialContext context;
    private static final int VARINT = 0;
    private static final int i64 = 1;
    private static final int SIZE_DELIMITED = 2;
    private static final int i32 = 5;
    @NotNull
    private static final ProtoBuf plain;
    public static final Companion Companion;

    @NotNull
    public final <T> byte[] dump(@NotNull KSerialSaver<? super T> saver, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ProtobufWriter dumper = new ProtobufWriter(new ProtobufEncoder(output));
        dumper.write(saver, obj);
        byte[] byArray = output.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"output.toByteArray()");
        return byArray;
    }

    private final <T> byte[] dump(T obj) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.dump(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> String dumps(T obj) {
        void this_$iv;
        ProtoBuf protoBuf = this;
        HexConverter hexConverter = HexConverter.INSTANCE;
        SerialContext serialContext = this_$iv.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        byte[] byArray = this_$iv.dump(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
        return hexConverter.printHexBinary(byArray, true);
    }

    @NotNull
    public final <T> T load(@NotNull KSerialLoader<T> loader, @NotNull byte[] raw) {
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
        ByteArrayInputStream stream = new ByteArrayInputStream(raw);
        ProtobufReader reader = new ProtobufReader(new ProtobufDecoder(stream));
        return reader.read(loader);
    }

    private final <T> T load(byte[] raw) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.load(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), raw);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T loads(String hex2) {
        void this_$iv;
        ProtoBuf protoBuf = this;
        byte[] raw$iv = HexConverter.INSTANCE.parseHexBinary(hex2);
        SerialContext serialContext = this_$iv.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this_$iv.load(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), raw$iv);
    }

    @Nullable
    public final SerialContext getContext() {
        return this.context;
    }

    public ProtoBuf(@Nullable SerialContext context) {
        this.context = context;
    }

    public /* synthetic */ ProtoBuf(SerialContext serialContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serialContext = null;
        }
        this(serialContext);
    }

    public ProtoBuf() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        plain = new ProtoBuf(null, 1, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0090\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u001dH\u0016JK\u0010\u001e\u001a\u00020\u0014\"\u000e\b\u0000\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"2\u0006\u0010\u0016\u001a\u0002H\u001fH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020%H\u0016J(\u0010&\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J(\u0010'\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020(H\u0016J(\u0010)\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020*H\u0016J(\u0010+\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020,H\u0016J$\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u000e2\u0006\u0010.\u001a\u00020\u0003H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006/"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/TaggedOutput;", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "encoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;)V", "getEncoder", "()Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "writeBegin", "Lkotlinx/serialization/KOutput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KOutput;", "writeTaggedBoolean", "", "tag", "value", "", "writeTaggedByte", "", "writeTaggedChar", "", "writeTaggedDouble", "", "writeTaggedEnum", "E", "", "enumClass", "Lkotlin/reflect/KClass;", "(Lkotlin/Pair;Lkotlin/reflect/KClass;Ljava/lang/Enum;)V", "writeTaggedFloat", "", "writeTaggedInt", "writeTaggedLong", "", "writeTaggedShort", "", "writeTaggedString", "", "getTag", "index", "kotlinx-serialization-runtime"})
    public class ProtobufWriter
    extends TaggedOutput<Pair<? extends Integer, ? extends ProtoNumberType>> {
        @NotNull
        private final ProtobufEncoder encoder;

        @Override
        @NotNull
        public KOutput writeBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KOutput kOutput;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            switch (ProtoBuf$ProtobufWriter$WhenMappings.$EnumSwitchMapping$0[desc.getKind().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    kOutput = new RepeatedWriter(this.encoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTag()));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    kOutput = new ObjectWriter(ProtoBuf.this, (Pair)this.getCurrentTagOrNull(), this.encoder, null, 4, null);
                    break;
                }
                case 8: {
                    kOutput = new MapEntryWriter((Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull()), this.encoder);
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Primitives are not supported at top-level");
                }
            }
            return kOutput;
        }

        @Override
        public void writeTaggedInt(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, int value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public void writeTaggedByte(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, byte value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public void writeTaggedShort(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, short value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public void writeTaggedLong(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, long value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeLong(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public void writeTaggedFloat(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, float value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeFloat(value, ((Number)tag.getFirst()).intValue());
        }

        @Override
        public void writeTaggedDouble(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, double value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeDouble(value, ((Number)tag.getFirst()).intValue());
        }

        @Override
        public void writeTaggedBoolean(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, boolean value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value ? 1 : 0, ((Number)tag.getFirst()).intValue(), ProtoNumberType.DEFAULT);
        }

        @Override
        public void writeTaggedChar(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, char value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public void writeTaggedString(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.encoder.writeString(value, ((Number)tag.getFirst()).intValue());
        }

        @Override
        public <E extends Enum<E>> void writeTaggedEnum(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull KClass<E> enumClass, @NotNull E value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            this.encoder.writeInt(value.ordinal(), ((Number)tag.getFirst()).intValue(), ProtoNumberType.DEFAULT);
        }

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return Companion.getProtoDesc($receiver, index);
        }

        @NotNull
        public final ProtobufEncoder getEncoder() {
            return this.encoder;
        }

        public ProtobufWriter(ProtobufEncoder encoder) {
            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
            this.encoder = encoder;
            this.setContext(ProtoBuf.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0090\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B7\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ObjectWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentEncoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "stream", "Ljava/io/ByteArrayOutputStream;", "Lkotlinx/io/ByteArrayOutputStream;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlin/Pair;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;Ljava/io/ByteArrayOutputStream;)V", "getParentTag", "()Lkotlin/Pair;", "writeFinished", "", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "kotlinx-serialization-runtime"})
    public class ObjectWriter
    extends ProtobufWriter {
        @Nullable
        private final Pair<Integer, ProtoNumberType> parentTag;
        private final ProtobufEncoder parentEncoder;
        private final ByteArrayOutputStream stream;
        final /* synthetic */ ProtoBuf this$0;

        @Override
        public void writeFinished(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.parentTag != null) {
                byte[] byArray = this.stream.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"stream.toByteArray()");
                this.parentEncoder.writeObject(byArray, ((Number)this.parentTag.getFirst()).intValue());
            } else {
                this.parentEncoder.getOut().write(this.stream.toByteArray());
            }
        }

        @Nullable
        public final Pair<Integer, ProtoNumberType> getParentTag() {
            return this.parentTag;
        }

        public ObjectWriter(@Nullable ProtoBuf $outer, @NotNull Pair<Integer, ? extends ProtoNumberType> parentTag, @NotNull ProtobufEncoder parentEncoder, ByteArrayOutputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)parentEncoder, (String)"parentEncoder");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            this.this$0 = $outer;
            super(new ProtobufEncoder(stream));
            this.parentTag = parentTag;
            this.parentEncoder = parentEncoder;
            this.stream = stream;
        }

        public /* synthetic */ ObjectWriter(ProtoBuf protoBuf, Pair pair, ProtobufEncoder protobufEncoder, ByteArrayOutputStream byteArrayOutputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            this(protoBuf, (Pair<Integer, ? extends ProtoNumberType>)pair, protobufEncoder, byteArrayOutputStream);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007*\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0014\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapEntryWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ObjectWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentEncoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlin/Pair;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;)V", "getTag", "Lkotlinx/serialization/KSerialClassDesc;", "index", "kotlinx-serialization-runtime"})
    public final class MapEntryWriter
    extends ObjectWriter {
        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (index == 0) {
                Integer n = 1;
                Object object = this.getParentTag();
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            } else {
                Integer n = 2;
                Object object = this.getParentTag();
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            }
            return pair;
        }

        public MapEntryWriter(@NotNull Pair<Integer, ? extends ProtoNumberType> parentTag, ProtobufEncoder parentEncoder) {
            Intrinsics.checkParameterIsNotNull((Object)parentEncoder, (String)"parentEncoder");
            super(ProtoBuf.this, parentTag, parentEncoder, null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\u0010\nJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0014R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "encoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "curTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;Lkotlin/Pair;)V", "getCurTag", "()Lkotlin/Pair;", "shouldWriteElement", "", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "tag", "index", "getTag", "kotlinx-serialization-runtime"})
    public final class RepeatedWriter
    extends ProtobufWriter {
        @NotNull
        private final Pair<Integer, ProtoNumberType> curTag;

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return this.curTag;
        }

        @Override
        public boolean shouldWriteElement(@NotNull KSerialClassDesc desc, @NotNull Pair<Integer, ? extends ProtoNumberType> tag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return index != 0;
        }

        @NotNull
        public final Pair<Integer, ProtoNumberType> getCurTag() {
            return this.curTag;
        }

        public RepeatedWriter(@NotNull ProtobufEncoder encoder, Pair<Integer, ? extends ProtoNumberType> curTag) {
            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
            Intrinsics.checkParameterIsNotNull(curTag, (String)"curTag");
            super(encoder);
            this.curTag = curTag;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000bJ\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "", "out", "Ljava/io/ByteArrayOutputStream;", "Lkotlinx/io/ByteArrayOutputStream;", "(Ljava/io/ByteArrayOutputStream;)V", "getOut", "()Ljava/io/ByteArrayOutputStream;", "encode32", "", "number", "", "format", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "encode64", "", "writeDouble", "", "value", "", "tag", "writeFloat", "", "writeInt", "writeLong", "writeObject", "bytes", "writeString", "", "kotlinx-serialization-runtime"})
    public static final class ProtobufEncoder {
        @NotNull
        private final ByteArrayOutputStream out;

        public final void writeObject(@NotNull byte[] bytes, int tag) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 2, null, 2, null);
            byte[] len = ProtobufEncoder.encode32$default(this, bytes.length, null, 2, null);
            this.out.write(header);
            this.out.write(len);
            this.out.write(bytes);
        }

        public final void writeInt(int value, int tag, @NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = Intrinsics.areEqual((Object)((Object)format), (Object)((Object)ProtoNumberType.FIXED)) ? 5 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode32(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeLong(long value, int tag, @NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = Intrinsics.areEqual((Object)((Object)format), (Object)((Object)ProtoNumberType.FIXED)) ? 1 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode64(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeString(@NotNull String value, int tag) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            byte[] bytes = SerializationKt.toUtf8Bytes(value);
            this.writeObject(bytes, tag);
        }

        public final void writeDouble(double value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 1, null, 2, null);
            byte[] content = ByteBuffer.Companion.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(value).array();
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeFloat(float value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 5, null, 2, null);
            byte[] content = ByteBuffer.Companion.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(value).array();
            this.out.write(header);
            this.out.write(content);
        }

        private final byte[] encode32(int number, ProtoNumberType format) {
            byte[] byArray;
            switch (ProtoBuf$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    byArray = ByteBuffer.Companion.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(number).array();
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_runtime((long)number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_runtime(number << 1 ^ number >> 31);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* bridge */ /* synthetic */ byte[] encode32$default(ProtobufEncoder protobufEncoder, int n, ProtoNumberType protoNumberType, int n2, Object object) {
            if ((n2 & 2) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufEncoder.encode32(n, protoNumberType);
        }

        private final byte[] encode64(long number, ProtoNumberType format) {
            byte[] byArray;
            switch (ProtoBuf$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
                case 1: {
                    byArray = ByteBuffer.Companion.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(number).array();
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_runtime(number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_runtime(number << 1 ^ number >> 63);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* bridge */ /* synthetic */ byte[] encode64$default(ProtobufEncoder protobufEncoder, long l, ProtoNumberType protoNumberType, int n, Object object) {
            if ((n & 2) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufEncoder.encode64(l, protoNumberType);
        }

        @NotNull
        public final ByteArrayOutputStream getOut() {
            return this.out;
        }

        public ProtobufEncoder(@NotNull ByteArrayOutputStream out) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            this.out = out;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\"\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010\u001f\u001a\u00020 2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016JC\u0010!\u001a\u0002H\"\"\u000e\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"0#2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%H\u0016\u00a2\u0006\u0002\u0010&J \u0010'\u001a\u00020(2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010)\u001a\u00020\u00032\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010*\u001a\u00020+2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010,\u001a\u00020-2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010.\u001a\u00020/2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J$\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u000f2\u0006\u00101\u001a\u00020\u0003H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/TaggedInput;", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;)V", "getDecoder", "()Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "indexByTag", "", "findIndexByTag", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "serialId", "readBegin", "Lkotlinx/serialization/KInput;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KInput;", "readElement", "readTaggedBoolean", "", "tag", "readTaggedByte", "", "readTaggedChar", "", "readTaggedDouble", "", "readTaggedEnum", "E", "", "enumClass", "Lkotlin/reflect/KClass;", "(Lkotlin/Pair;Lkotlin/reflect/KClass;)Ljava/lang/Enum;", "readTaggedFloat", "", "readTaggedInt", "readTaggedLong", "", "readTaggedShort", "", "readTaggedString", "", "getTag", "index", "kotlinx-serialization-runtime"})
    private class ProtobufReader
    extends TaggedInput<Pair<? extends Integer, ? extends ProtoNumberType>> {
        private final Map<Integer, Integer> indexByTag;
        @NotNull
        private final ProtobufDecoder decoder;

        private final int findIndexByTag(KSerialClassDesc desc, int serialId) {
            Object v0;
            block1: {
                Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)desc.getAssociatedFieldsCount());
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!(((Number)this.getTag(desc, it).getFirst()).intValue() == serialId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Integer n = v0;
            return n != null ? n : -1;
        }

        @Override
        @NotNull
        public KInput readBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KInput kInput;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            switch (ProtoBuf$ProtobufReader$WhenMappings.$EnumSwitchMapping$0[desc.getKind().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    kInput = new RepeatedReader(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTag()));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    kInput = new ProtobufReader(Companion.makeDelimited(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull())));
                    break;
                }
                case 8: {
                    kInput = new MapEntryReader(Companion.makeDelimited(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull())), (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull()));
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Primitives are not supported at top-level");
                }
            }
            return kInput;
        }

        @Override
        public boolean readTaggedBoolean(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            switch (this.decoder.nextInt(ProtoNumberType.DEFAULT)) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    throw (Throwable)new ProtobufDecodingException("Expected boolean value");
                }
            }
            return bl;
        }

        @Override
        public byte readTaggedByte(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (byte)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public short readTaggedShort(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (short)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public int readTaggedInt(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public long readTaggedLong(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextLong((ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        public float readTaggedFloat(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextFloat();
        }

        @Override
        public double readTaggedDouble(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextDouble();
        }

        @Override
        public char readTaggedChar(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (char)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        @Override
        @NotNull
        public String readTaggedString(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextString();
        }

        @Override
        @NotNull
        public <E extends Enum<E>> E readTaggedEnum(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull KClass<E> enumClass) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return SerializationKt.enumFromOrdinal(enumClass, this.decoder.nextInt(ProtoNumberType.DEFAULT));
        }

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return Companion.getProtoDesc($receiver, index);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            int ind;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (true) {
                Object object;
                void $receiver$iv;
                if (this.decoder.getCurId() == -1) {
                    return -1;
                }
                Map<Integer, Integer> map = this.indexByTag;
                Integer key$iv = this.decoder.getCurId();
                Object value$iv = $receiver$iv.get(key$iv);
                if (value$iv == null) {
                    Integer answer$iv = this.findIndexByTag(desc, this.decoder.getCurId());
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                if ((ind = ((Number)object).intValue()) != -1) break;
                this.decoder.skipElement();
            }
            return ind;
        }

        @NotNull
        public final ProtobufDecoder getDecoder() {
            return this.decoder;
        }

        public ProtobufReader(ProtobufDecoder decoder) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            this.decoder = decoder;
            this.setContext(ProtoBuf.this.getContext());
            ProtobufReader protobufReader = this;
            protobufReader.indexByTag = map = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0014R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedReader;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "targetTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;Lkotlin/Pair;)V", "ind", "getTargetTag", "()Lkotlin/Pair;", "readElement", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "getTag", "index", "kotlinx-serialization-runtime"})
    private final class RepeatedReader
    extends ProtobufReader {
        private int ind;
        @NotNull
        private final Pair<Integer, ProtoNumberType> targetTag;

        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.getDecoder().getCurId() == ((Number)this.targetTag.getFirst()).intValue()) {
                RepeatedReader repeatedReader = this;
                n = ++repeatedReader.ind;
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return this.targetTag;
        }

        @NotNull
        public final Pair<Integer, ProtoNumberType> getTargetTag() {
            return this.targetTag;
        }

        public RepeatedReader(@NotNull ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> targetTag) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            Intrinsics.checkParameterIsNotNull(targetTag, (String)"targetTag");
            super(decoder);
            this.targetTag = targetTag;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006j\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0014R%\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006j\u0004\u0018\u0001`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapEntryReader;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;Lkotlin/Pair;)V", "getParentTag", "()Lkotlin/Pair;", "getTag", "Lkotlinx/serialization/KSerialClassDesc;", "index", "kotlinx-serialization-runtime"})
    private final class MapEntryReader
    extends ProtobufReader {
        @Nullable
        private final Pair<Integer, ProtoNumberType> parentTag;

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull KSerialClassDesc $receiver, int index) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (index == 0) {
                Integer n = 1;
                Object object = this.parentTag;
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            } else {
                Integer n = 2;
                Object object = this.parentTag;
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            }
            return pair;
        }

        @Nullable
        public final Pair<Integer, ProtoNumberType> getParentTag() {
            return this.parentTag;
        }

        public MapEntryReader(@Nullable ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> parentTag) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            super(decoder);
            this.parentTag = parentTag;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "", "inp", "Ljava/io/ByteArrayInputStream;", "Lkotlinx/io/ByteArrayInputStream;", "(Ljava/io/ByteArrayInputStream;)V", "curId", "", "getCurId", "()I", "curTag", "Lkotlin/Pair;", "getInp", "()Ljava/io/ByteArrayInputStream;", "decode32", "format", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "eofAllowed", "", "decode64", "", "nextDouble", "", "nextFloat", "", "nextInt", "nextLong", "nextObject", "", "nextString", "", "readTag", "skipElement", "", "kotlinx-serialization-runtime"})
    public static final class ProtobufDecoder {
        private Pair<Integer, Integer> curTag;
        @NotNull
        private final ByteArrayInputStream inp;

        public final int getCurId() {
            return ((Number)this.curTag.getFirst()).intValue();
        }

        private final Pair<Integer, Integer> readTag() {
            Pair pair;
            int header = ProtobufDecoder.decode32$default(this, null, true, 1, null);
            if (header == -1) {
                pair = TuplesKt.to((Object)-1, (Object)-1);
            } else {
                int wireType = header & 7;
                int fieldId = header >>> 3;
                pair = TuplesKt.to((Object)fieldId, (Object)wireType);
            }
            this.curTag = pair;
            return this.curTag;
        }

        public final void skipElement() {
            switch (((Number)this.curTag.getSecond()).intValue()) {
                case 0: {
                    this.nextInt(ProtoNumberType.DEFAULT);
                    break;
                }
                case 1: {
                    this.nextLong(ProtoNumberType.FIXED);
                    break;
                }
                case 2: {
                    this.nextObject();
                    break;
                }
                case 5: {
                    this.nextInt(ProtoNumberType.FIXED);
                }
            }
            this.readTag();
        }

        @NotNull
        public final byte[] nextObject() {
            boolean bl;
            if (((Number)this.curTag.getSecond()).intValue() != 2) {
                throw (Throwable)new ProtobufDecodingException("Unexpected wire type: " + ((Number)this.curTag.getSecond()).intValue());
            }
            int len = ProtobufDecoder.decode32$default(this, null, false, 3, null);
            boolean bl2 = bl = len >= 0;
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            byte[] ans = UtilKt.readExactNBytes(this.inp, len);
            this.readTag();
            return ans;
        }

        public final int nextInt(@NotNull ProtoNumberType format) {
            int wireType;
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int n = wireType = Intrinsics.areEqual((Object)((Object)format), (Object)((Object)ProtoNumberType.FIXED)) ? 5 : 0;
            if (wireType != ((Number)this.curTag.getSecond()).intValue()) {
                throw (Throwable)new ProtobufDecodingException("Unexpected wire type: " + ((Number)this.curTag.getSecond()).intValue());
            }
            int ans = ProtobufDecoder.decode32$default(this, format, false, 2, null);
            this.readTag();
            return ans;
        }

        public final long nextLong(@NotNull ProtoNumberType format) {
            int wireType;
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int n = wireType = Intrinsics.areEqual((Object)((Object)format), (Object)((Object)ProtoNumberType.FIXED)) ? 1 : 0;
            if (wireType != ((Number)this.curTag.getSecond()).intValue()) {
                throw (Throwable)new ProtobufDecodingException("Unexpected wire type: " + ((Number)this.curTag.getSecond()).intValue());
            }
            long ans = this.decode64(format);
            this.readTag();
            return ans;
        }

        public final float nextFloat() {
            if (((Number)this.curTag.getSecond()).intValue() != 5) {
                throw (Throwable)new ProtobufDecodingException("Unexpected wire type: " + ((Number)this.curTag.getSecond()).intValue());
            }
            float ans = UtilKt.readToByteBuffer(this.inp, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            this.readTag();
            return ans;
        }

        public final double nextDouble() {
            if (((Number)this.curTag.getSecond()).intValue() != 1) {
                throw (Throwable)new ProtobufDecodingException("Unexpected wire type: " + ((Number)this.curTag.getSecond()).intValue());
            }
            double ans = UtilKt.readToByteBuffer(this.inp, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.readTag();
            return ans;
        }

        @NotNull
        public final String nextString() {
            byte[] bytes = this.nextObject();
            return SerializationKt.stringFromUtf8Bytes(bytes);
        }

        private final int decode32(ProtoNumberType format, boolean eofAllowed) {
            int n;
            switch (ProtoBuf$ProtobufDecoder$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    n = (int)Varint.INSTANCE.decodeVarint$kotlinx_serialization_runtime(this.inp, 64, eofAllowed);
                    break;
                }
                case 2: {
                    n = Varint.INSTANCE.decodeSignedVarintInt$kotlinx_serialization_runtime(this.inp);
                    break;
                }
                case 3: {
                    n = UtilKt.readToByteBuffer(this.inp, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        static /* bridge */ /* synthetic */ int decode32$default(ProtobufDecoder protobufDecoder, ProtoNumberType protoNumberType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return protobufDecoder.decode32(protoNumberType, bl);
        }

        private final long decode64(ProtoNumberType format) {
            long l;
            switch (ProtoBuf$ProtobufDecoder$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
                case 1: {
                    l = Varint.decodeVarint$kotlinx_serialization_runtime$default(Varint.INSTANCE, this.inp, 64, false, 4, null);
                    break;
                }
                case 2: {
                    l = Varint.INSTANCE.decodeSignedVarintLong$kotlinx_serialization_runtime(this.inp);
                    break;
                }
                case 3: {
                    l = UtilKt.readToByteBuffer(this.inp, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }

        static /* bridge */ /* synthetic */ long decode64$default(ProtobufDecoder protobufDecoder, ProtoNumberType protoNumberType, int n, Object object) {
            if ((n & 1) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufDecoder.decode64(protoNumberType);
        }

        @NotNull
        public final ByteArrayInputStream getInp() {
            return this.inp;
        }

        public ProtobufDecoder(@NotNull ByteArrayInputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            this.inp = inp;
            this.curTag = TuplesKt.to((Object)-1, (Object)-1);
            this.readTag();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0019\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ-\u0010\f\u001a\u00020\n2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$Varint;", "", "()V", "decodeSignedVarintInt", "", "inp", "Ljava/io/InputStream;", "Lkotlinx/io/InputStream;", "decodeSignedVarintInt$kotlinx_serialization_runtime", "decodeSignedVarintLong", "", "decodeSignedVarintLong$kotlinx_serialization_runtime", "decodeVarint", "bitLimit", "eofOnStartAllowed", "", "decodeVarint$kotlinx_serialization_runtime", "encodeVarint", "", "encodeVarint$kotlinx_serialization_runtime", "kotlinx-serialization-runtime"})
    public static final class Varint {
        public static final Varint INSTANCE;

        @NotNull
        public final byte[] encodeVarint$kotlinx_serialization_runtime(int inp) {
            int value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (int)0xFFFFFF80L) != 0) {
                byteArrayList[i++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7F);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        @NotNull
        public final byte[] encodeVarint$kotlinx_serialization_runtime(long inp) {
            long value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (0x7FL ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                byteArrayList[i++] = (byte)(value & 0x7FL | 0x80L);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7FL);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        public final long decodeVarint$kotlinx_serialization_runtime(@NotNull InputStream inp, int bitLimit, boolean eofOnStartAllowed) {
            int b;
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            long result = 0L;
            int shift = 0;
            do {
                if (shift >= bitLimit) {
                    throw (Throwable)new ProtobufDecodingException("Varint too long");
                }
                b = inp.read();
                if (b == -1) {
                    if (eofOnStartAllowed && shift == 0) {
                        return -1L;
                    }
                    throw (Throwable)new IOException("Unexpected EOF");
                }
                result |= ((long)b & 0x7FL) << shift;
                shift += 7;
            } while ((b & 0x80) != 0);
            return result;
        }

        public static /* bridge */ /* synthetic */ long decodeVarint$kotlinx_serialization_runtime$default(Varint varint, InputStream inputStream, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 32;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return varint.decodeVarint$kotlinx_serialization_runtime(inputStream, n, bl);
        }

        public final int decodeSignedVarintInt$kotlinx_serialization_runtime(@NotNull InputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            int raw = (int)Varint.decodeVarint$kotlinx_serialization_runtime$default(this, inp, 32, false, 4, null);
            int temp = (raw << 31 >> 31 ^ raw) >> 1;
            return temp ^ raw & Integer.MIN_VALUE;
        }

        public final long decodeSignedVarintLong$kotlinx_serialization_runtime(@NotNull InputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            long raw = Varint.decodeVarint$kotlinx_serialization_runtime$default(this, inp, 64, false, 4, null);
            long temp = (raw << 63 >> 63 ^ raw) >> 1;
            return temp ^ raw & Long.MIN_VALUE;
        }

        private Varint() {
        }

        static {
            Varint varint;
            INSTANCE = varint = new Varint();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\r\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u0010J+\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u000f\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u00020\u0015\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\rH\u0086\b\u00a2\u0006\u0002\u0010\u0019J+\u0010\u0017\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001b2\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001fJ,\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%\u0018\u00010$j\u0004\u0018\u0001`&H\u0002J$\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$j\u0002`&*\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$Companion;", "", "()V", "SIZE_DELIMITED", "", "VARINT", "i32", "i64", "plain", "Lkotlinx/serialization/protobuf/ProtoBuf;", "getPlain", "()Lkotlinx/serialization/protobuf/ProtoBuf;", "dump", "", "T", "obj", "(Ljava/lang/Object;)[B", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)[B", "dumps", "", "(Ljava/lang/Object;)Ljava/lang/String;", "load", "raw", "([B)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;[B)Ljava/lang/Object;", "loads", "hex", "(Ljava/lang/String;)Ljava/lang/Object;", "makeDelimited", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "decoder", "parentTag", "Lkotlin/Pair;", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "getProtoDesc", "Lkotlinx/serialization/KSerialClassDesc;", "index", "kotlinx-serialization-runtime"})
    public static final class Companion {
        private final ProtobufDecoder makeDelimited(ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> parentTag) {
            if (parentTag == null) {
                return decoder;
            }
            byte[] bytes = decoder.nextObject();
            return new ProtobufDecoder(new ByteArrayInputStream(bytes));
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, ProtoNumberType> getProtoDesc(@NotNull KSerialClassDesc $receiver, int index) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$receiver.getAnnotationsForIndex(index);
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                if (!(element$iv$iv instanceof SerialId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int tag = ((SerialId)CollectionsKt.single((List)((List)destination$iv$iv))).id();
            Iterable $receiver$iv2 = $receiver.getAnnotationsForIndex(index);
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ProtoType)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Object object = (ProtoType)UtilKt.onlySingleOrNull((List)destination$iv$iv2);
            if (object == null || (object = object.type()) == null) {
                object = ProtoNumberType.DEFAULT;
            }
            Object format = object;
            return TuplesKt.to((Object)tag, (Object)format);
        }

        @NotNull
        public final ProtoBuf getPlain() {
            return plain;
        }

        @NotNull
        public final <T> byte[] dump(@NotNull KSerialSaver<? super T> saver, @NotNull T obj) {
            Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return this.getPlain().dump(saver, obj);
        }

        private final <T> byte[] dump(T obj) {
            ProtoBuf this_$iv = this.getPlain();
            SerialContext serialContext = this_$iv.getContext();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this_$iv.dump(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> String dumps(T obj) {
            void this_$iv$iv;
            ProtoBuf this_$iv;
            ProtoBuf protoBuf = this_$iv = this.getPlain();
            HexConverter hexConverter = HexConverter.INSTANCE;
            SerialContext serialContext = this_$iv$iv.getContext();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            byte[] byArray = this_$iv$iv.dump(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
            return hexConverter.printHexBinary(byArray, true);
        }

        @NotNull
        public final <T> T load(@NotNull KSerialLoader<T> loader, @NotNull byte[] raw) {
            Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
            Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
            return this.getPlain().load(loader, raw);
        }

        private final <T> T load(byte[] raw) {
            ProtoBuf this_$iv = this.getPlain();
            SerialContext serialContext = this_$iv.getContext();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this_$iv.load(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), raw);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> T loads(String hex2) {
            void this_$iv$iv;
            ProtoBuf this_$iv;
            ProtoBuf protoBuf = this_$iv = this.getPlain();
            byte[] raw$iv$iv = HexConverter.INSTANCE.parseHexBinary(hex2);
            SerialContext serialContext = this_$iv$iv.getContext();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this_$iv$iv.load(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), raw$iv$iv);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

