/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.sort;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.sort.CollectionOfModulesToSort;
import org.jetbrains.kotlin.org.apache.ivy.core.sort.ModuleInSort;
import org.jetbrains.kotlin.org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.jetbrains.kotlin.org.apache.ivy.plugins.circular.CircularDependencyException;
import org.jetbrains.kotlin.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.VersionMatcher;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public class ModuleDescriptorSorter {
    private final CollectionOfModulesToSort moduleDescriptors;
    private final List<ModuleDescriptor> sorted = new LinkedList<ModuleDescriptor>();
    private final CircularDependencyStrategy circularDepStrategy;

    public ModuleDescriptorSorter(Collection<ModuleDescriptor> modulesDescriptorsToSort, VersionMatcher matcher, NonMatchingVersionReporter nonMatchingVersionReporter, CircularDependencyStrategy circularDepStrategy) {
        this.circularDepStrategy = circularDepStrategy;
        this.moduleDescriptors = new CollectionOfModulesToSort(modulesDescriptorsToSort, matcher, nonMatchingVersionReporter);
    }

    public List<ModuleDescriptor> sortModuleDescriptors() throws CircularDependencyException {
        Message.debug("Nbr of module to sort : " + this.moduleDescriptors.size());
        for (ModuleInSort m : this.moduleDescriptors) {
            this.sortModuleDescriptorsHelp(m, m);
        }
        return this.sorted;
    }

    private void sortModuleDescriptorsHelp(ModuleInSort current, ModuleInSort caller) throws CircularDependencyException {
        if (current.isProcessed()) {
            return;
        }
        if (current.checkLoop(caller, this.circularDepStrategy)) {
            return;
        }
        DependencyDescriptor[] descriptors = current.getDependencies();
        Message.debug("Sort dependencies of : " + current.toString() + " / Number of dependencies = " + descriptors.length);
        current.setCaller(caller);
        for (DependencyDescriptor descriptor : descriptors) {
            ModuleInSort child = this.moduleDescriptors.getModuleDescriptorDependency(descriptor);
            if (child == null) continue;
            this.sortModuleDescriptorsHelp(child, current);
        }
        current.endOfCall();
        Message.debug("Sort done for : " + current.toString());
        current.addToSortedListIfRequired(this.sorted);
    }
}

