// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f446.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32f446

// STM32F446
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F446"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Universal synchronous asynchronous receiver transmitter
	IRQ_WWDG = 0

	// Power control
	IRQ_TAMP_STAMP = 2

	IRQ_RTC_WKUP = 3

	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// Power control
	IRQ_EXTI0 = 6

	// Power control
	IRQ_EXTI1 = 7

	// Power control
	IRQ_EXTI2 = 8

	// Power control
	IRQ_EXTI3 = 9

	// Power control
	IRQ_EXTI4 = 10

	IRQ_DMA1_Stream0 = 11

	IRQ_DMA1_Stream1 = 12

	IRQ_DMA1_Stream2 = 13

	IRQ_DMA1_Stream3 = 14

	IRQ_DMA1_Stream4 = 15

	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Analog-to-digital converter //
	IRQ_ADC = 18

	// USB on the go high speed
	IRQ_CAN1_TX = 19

	// USB on the go high speed
	IRQ_CAN1_RX0 = 20

	// USB on the go high speed
	IRQ_CAN1_RX1 = 21

	// USB on the go high speed
	IRQ_CAN1_SCE = 22

	// Power control
	IRQ_EXTI9_5 = 23

	// General-purpose-timers
	IRQ_TIM1_BRK_TIM9 = 24

	IRQ_TIM1_UP_TIM10 = 25

	IRQ_TIM1_TRG_COM_TIM11 = 26

	// General purpose timers
	IRQ_TIM1_CC = 27

	IRQ_TIM2 = 28

	// General-purpose-timers
	IRQ_TIM3 = 29

	// General purpose timers
	IRQ_TIM4 = 30

	// Window watchdog
	IRQ_I2C1_EV = 31

	// Window watchdog
	IRQ_I2C1_ER = 32

	// Independent watchdog
	IRQ_I2C2_EV = 33

	// Independent watchdog
	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// Power control
	IRQ_EXTI15_10 = 40

	IRQ_RTC_Alarm = 41

	// Nested Vectored Interrupt Controller
	IRQ_OTG_FS_WKUP = 42

	IRQ_TIM8_BRK_TIM12 = 43

	// General purpose timers
	IRQ_TIM8_UP_TIM13 = 44

	// General purpose timers
	IRQ_TIM8_TRG_COM_TIM14 = 45

	// General purpose timers
	IRQ_TIM8_CC = 46

	IRQ_DMA1_Stream7 = 47

	// Flexible memory controller
	IRQ_FMC = 48

	// Secure digital input/output SD/SDIO MMC card host interface
	IRQ_SDIO = 49

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	// Common ADC registers
	IRQ_UART4 = 52

	// Advanced-timers
	IRQ_UART5 = 53

	// Cryptographic processor
	IRQ_TIM6_DAC = 54

	// USB on the go full speed
	IRQ_TIM7 = 55

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// USB on the go full speed
	IRQ_ETH = 61

	// USB on the go full speed
	IRQ_ETH_WKUP = 62

	// USB on the go high speed
	IRQ_CAN2_TX = 63

	// USB on the go high speed
	IRQ_CAN2_RX0 = 64

	// USB on the go high speed
	IRQ_CAN2_RX1 = 65

	// USB on the go high speed
	IRQ_CAN2_SCE = 66

	// Nested Vectored Interrupt Controller
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	IRQ_USART6 = 71

	// Inter-integrated circuit
	IRQ_I2C3_EV = 72

	// Inter-integrated circuit
	IRQ_I2C3_ER = 73

	// Digital camera interface
	IRQ_DCMI = 78

	// Floting point unit
	IRQ_FPU = 81

	// Digital-to-analog converter
	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	// QuadSPI interface
	IRQ_LCD_TFT = 88

	// QuadSPI interface
	IRQ_LCD_TFT_1 = 89

	// Highest interrupt number on this device.
	IRQ_max = 89
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream0, "DMA1_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream1, "DMA1_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream2, "DMA1_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream3, "DMA1_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream4, "DMA1_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream5, "DMA1_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream6, "DMA1_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_TX, "CAN1_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX0, "CAN1_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX1, "CAN1_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_SCE, "CAN1_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM9, "TIM1_BRK_TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM10, "TIM1_UP_TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM11, "TIM1_TRG_COM_TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_Alarm, "RTC_Alarm_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS_WKUP, "OTG_FS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK_TIM12, "TIM8_BRK_TIM12_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP_TIM13, "TIM8_UP_TIM13_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM_TIM14, "TIM8_TRG_COM_TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream7, "DMA1_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_SDIO, "SDIO_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream0, "DMA2_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream1, "DMA2_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream2, "DMA2_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream3, "DMA2_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream4, "DMA2_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_ETH, "ETH_IRQHandler")
	_ = interrupt.Register(IRQ_ETH_WKUP, "ETH_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_TX, "CAN2_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX0, "CAN2_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX1, "CAN2_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_SCE, "CAN2_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream5, "DMA2_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream6, "DMA2_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream7, "DMA2_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_USART6, "USART6_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_DCMI, "DCMI_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_UART7, "UART7_IRQHandler")
	_ = interrupt.Register(IRQ_UART8, "UART8_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT, "LCD_TFT_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT_1, "LCD_TFT_1_IRQHandler")
)

// Peripherals.
var (
	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))

	// Flexible memory controller
	FMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Common ADC registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// USB on the go high speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB on the go high speed
	OTG_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Receiver Interface
	SPDIFRX = (*SPDIF_RX_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Secure digital input/output SD/SDIO MMC card host interface
	SDIO = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// HDMI-CEC controller
	HDMI_CEC = (*HDMI_CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// fast-mode Inter-integrated circuit
	FMPI2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Analog-to-digital converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))

	// Analog-to-digital converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))
)

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [64]byte
	PCR2  volatile.Register32 // 0x60
	SR2   volatile.Register32 // 0x64
	PMEM2 volatile.Register32 // 0x68
	PATT2 volatile.Register32 // 0x6C
	_     [4]byte
	ECCR2 volatile.Register32 // 0x74
	_     [8]byte
	PCR3  volatile.Register32 // 0x80
	SR3   volatile.Register32 // 0x84
	PMEM3 volatile.Register32 // 0x88
	PATT3 volatile.Register32 // 0x8C
	_     [4]byte
	ECCR3 volatile.Register32 // 0x94
	_     [8]byte
	PCR4  volatile.Register32 // 0xA0
	SR4   volatile.Register32 // 0xA4
	PMEM4 volatile.Register32 // 0xA8
	PATT4 volatile.Register32 // 0xAC
	PIO4  volatile.Register32 // 0xB0
	_     [80]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		M0AR volatile.Register32
		M1AR volatile.Register32
		FCR  volatile.Register32
	} // 0x10
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DCKCFGR    volatile.Register32 // 0x8C
	CKGATENR   volatile.Register32 // 0x90
	DCKCFGR2   volatile.Register32 // 0x94
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
	_       [8]byte
	CFGR    volatile.Register32 // 0x2C
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
	FLTR  volatile.Register32 // 0x24
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Cryptographic processor
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	GOTGCTL        volatile.Register32 // 0x0
	GOTGINT        volatile.Register32 // 0x4
	GAHBCFG        volatile.Register32 // 0x8
	GUSBCFG        volatile.Register32 // 0xC
	GRSTCTL        volatile.Register32 // 0x10
	GINTSTS        volatile.Register32 // 0x14
	GINTMSK        volatile.Register32 // 0x18
	GRXSTSR_Device volatile.Register32 // 0x1C
	GRXSTSP_Device volatile.Register32 // 0x20
	GRXFSIZ        volatile.Register32 // 0x24
	DIEPTXF0       volatile.Register32 // 0x28
	GNPTXSTS       volatile.Register32 // 0x2C
	_              [8]byte
	GCCFG          volatile.Register32 // 0x38
	OTG_CID        volatile.Register32 // 0x3C
	_              [20]byte
	GLPMCFG        volatile.Register32 // 0x54
	_              [168]byte
	HPTXFSIZ       volatile.Register32 // 0x100
	DIEPTXF1       volatile.Register32 // 0x104
	DIEPTXF2       volatile.Register32 // 0x108
	DIEPTXF3       volatile.Register32 // 0x10C
	DIEPTXF4       volatile.Register32 // 0x110
	DIEPTXF5       volatile.Register32 // 0x114
}

// Controller area network
type CAN_Type struct {
	MCR  volatile.Register32 // 0x0
	MSR  volatile.Register32 // 0x4
	TSR  volatile.Register32 // 0x8
	RF0R volatile.Register32 // 0xC
	RF1R volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	ESR  volatile.Register32 // 0x18
	BTR  volatile.Register32 // 0x1C
	_    [352]byte
	TX   [3]struct {
		TIR  volatile.Register32
		TDTR volatile.Register32
		TDLR volatile.Register32
		TDHR volatile.Register32
	} // 0x180
	RX [2]struct {
		RIR  volatile.Register32
		RDTR volatile.Register32
		RDLR volatile.Register32
		RDHR volatile.Register32
	} // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]struct {
		FR1 volatile.Register32
		FR2 volatile.Register32
	} // 0x240
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	GOTGCTL      volatile.Register32 // 0x0
	GOTGINT      volatile.Register32 // 0x4
	GAHBCFG      volatile.Register32 // 0x8
	GUSBCFG      volatile.Register32 // 0xC
	GRSTCTL      volatile.Register32 // 0x10
	GINTSTS      volatile.Register32 // 0x14
	GINTMSK      volatile.Register32 // 0x18
	GRXSTSR_Host volatile.Register32 // 0x1C
	GRXSTSP_Host volatile.Register32 // 0x20
	GRXFSIZ      volatile.Register32 // 0x24
	GNPTXFSIZ    volatile.Register32 // 0x28
	GNPTXSTS     volatile.Register32 // 0x2C
	_            [8]byte
	GCCFG        volatile.Register32 // 0x38
	CID          volatile.Register32 // 0x3C
	_            [192]byte
	HPTXFSIZ     volatile.Register32 // 0x100
	DIEPTXF1     volatile.Register32 // 0x104
	DIEPTXF2     volatile.Register32 // 0x108
	DIEPTXF3     volatile.Register32 // 0x10C
	DIEPTXF4     volatile.Register32 // 0x110
	DIEPTXF5     volatile.Register32 // 0x114
}

// Serial audio interface
type SAI_Type struct {
	GCR volatile.Register32 // 0x0
	CH  [2]struct {
		CR1   volatile.Register32
		CR2   volatile.Register32
		FRCR  volatile.Register32
		SLOTR volatile.Register32
		IM    volatile.Register32
		SR    volatile.Register32
		CLRFR volatile.Register32
		DR    volatile.Register32
	} // 0x4
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// Receiver Interface
type SPDIF_RX_Type struct {
	CR   volatile.Register32 // 0x0
	IMR  volatile.Register32 // 0x4
	SR   volatile.Register32 // 0x8
	IFCR volatile.Register32 // 0xC
	DR   volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	DIR  volatile.Register32 // 0x18
}

// Secure digital input/output SD/SDIO MMC card host interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// HDMI-CEC controller
type HDMI_CEC_Type struct {
	CEC_CR   volatile.Register32 // 0x0
	CEC_CFGR volatile.Register32 // 0x4
	CEC_TXDR volatile.Register32 // 0x8
	CEC_RXDR volatile.Register32 // 0xC
	CEC_ISR  volatile.Register32 // 0x10
	CEC_IER  volatile.Register32 // 0x14
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for DCMI: Digital camera interface
const (
	// CR: control register 1
	// Position of CAPTURE field.
	DCMI_CR_CAPTURE_Pos = 0x0
	// Bit mask of CAPTURE field.
	DCMI_CR_CAPTURE_Msk = 0x1
	// Bit CAPTURE.
	DCMI_CR_CAPTURE = 0x1
	// Position of CM field.
	DCMI_CR_CM_Pos = 0x1
	// Bit mask of CM field.
	DCMI_CR_CM_Msk = 0x2
	// Bit CM.
	DCMI_CR_CM = 0x2
	// Position of CROP field.
	DCMI_CR_CROP_Pos = 0x2
	// Bit mask of CROP field.
	DCMI_CR_CROP_Msk = 0x4
	// Bit CROP.
	DCMI_CR_CROP = 0x4
	// Position of JPEG field.
	DCMI_CR_JPEG_Pos = 0x3
	// Bit mask of JPEG field.
	DCMI_CR_JPEG_Msk = 0x8
	// Bit JPEG.
	DCMI_CR_JPEG = 0x8
	// Position of ESS field.
	DCMI_CR_ESS_Pos = 0x4
	// Bit mask of ESS field.
	DCMI_CR_ESS_Msk = 0x10
	// Bit ESS.
	DCMI_CR_ESS = 0x10
	// Position of PCKPOL field.
	DCMI_CR_PCKPOL_Pos = 0x5
	// Bit mask of PCKPOL field.
	DCMI_CR_PCKPOL_Msk = 0x20
	// Bit PCKPOL.
	DCMI_CR_PCKPOL = 0x20
	// Position of HSPOL field.
	DCMI_CR_HSPOL_Pos = 0x6
	// Bit mask of HSPOL field.
	DCMI_CR_HSPOL_Msk = 0x40
	// Bit HSPOL.
	DCMI_CR_HSPOL = 0x40
	// Position of VSPOL field.
	DCMI_CR_VSPOL_Pos = 0x7
	// Bit mask of VSPOL field.
	DCMI_CR_VSPOL_Msk = 0x80
	// Bit VSPOL.
	DCMI_CR_VSPOL = 0x80
	// Position of EDM field.
	DCMI_CR_EDM_Pos = 0xa
	// Bit mask of EDM field.
	DCMI_CR_EDM_Msk = 0xc00
	// Position of ENABLE field.
	DCMI_CR_ENABLE_Pos = 0xe
	// Bit mask of ENABLE field.
	DCMI_CR_ENABLE_Msk = 0x4000
	// Bit ENABLE.
	DCMI_CR_ENABLE = 0x4000
	// Position of BSM field.
	DCMI_CR_BSM_Pos = 0x10
	// Bit mask of BSM field.
	DCMI_CR_BSM_Msk = 0x30000
	// Position of OEBS field.
	DCMI_CR_OEBS_Pos = 0x12
	// Bit mask of OEBS field.
	DCMI_CR_OEBS_Msk = 0x40000
	// Bit OEBS.
	DCMI_CR_OEBS = 0x40000
	// Position of LSM field.
	DCMI_CR_LSM_Pos = 0x13
	// Bit mask of LSM field.
	DCMI_CR_LSM_Msk = 0x80000
	// Bit LSM.
	DCMI_CR_LSM = 0x80000
	// Position of OELS field.
	DCMI_CR_OELS_Pos = 0x14
	// Bit mask of OELS field.
	DCMI_CR_OELS_Msk = 0x100000
	// Bit OELS.
	DCMI_CR_OELS = 0x100000
	// Position of FCRC field.
	DCMI_CR_FCRC_Pos = 0x8
	// Bit mask of FCRC field.
	DCMI_CR_FCRC_Msk = 0x300

	// SR: status register
	// Position of FNE field.
	DCMI_SR_FNE_Pos = 0x2
	// Bit mask of FNE field.
	DCMI_SR_FNE_Msk = 0x4
	// Bit FNE.
	DCMI_SR_FNE = 0x4
	// Position of VSYNC field.
	DCMI_SR_VSYNC_Pos = 0x1
	// Bit mask of VSYNC field.
	DCMI_SR_VSYNC_Msk = 0x2
	// Bit VSYNC.
	DCMI_SR_VSYNC = 0x2
	// Position of HSYNC field.
	DCMI_SR_HSYNC_Pos = 0x0
	// Bit mask of HSYNC field.
	DCMI_SR_HSYNC_Msk = 0x1
	// Bit HSYNC.
	DCMI_SR_HSYNC = 0x1

	// RIS: raw interrupt status register
	// Position of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Pos = 0x4
	// Bit mask of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Msk = 0x10
	// Bit LINE_RIS.
	DCMI_RIS_LINE_RIS = 0x10
	// Position of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Pos = 0x3
	// Bit mask of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Msk = 0x8
	// Bit VSYNC_RIS.
	DCMI_RIS_VSYNC_RIS = 0x8
	// Position of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Pos = 0x2
	// Bit mask of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Msk = 0x4
	// Bit ERR_RIS.
	DCMI_RIS_ERR_RIS = 0x4
	// Position of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Pos = 0x1
	// Bit mask of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Msk = 0x2
	// Bit OVR_RIS.
	DCMI_RIS_OVR_RIS = 0x2
	// Position of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Pos = 0x0
	// Bit mask of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Msk = 0x1
	// Bit FRAME_RIS.
	DCMI_RIS_FRAME_RIS = 0x1

	// IER: interrupt enable register
	// Position of LINE_IE field.
	DCMI_IER_LINE_IE_Pos = 0x4
	// Bit mask of LINE_IE field.
	DCMI_IER_LINE_IE_Msk = 0x10
	// Bit LINE_IE.
	DCMI_IER_LINE_IE = 0x10
	// Position of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Pos = 0x3
	// Bit mask of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Msk = 0x8
	// Bit VSYNC_IE.
	DCMI_IER_VSYNC_IE = 0x8
	// Position of ERR_IE field.
	DCMI_IER_ERR_IE_Pos = 0x2
	// Bit mask of ERR_IE field.
	DCMI_IER_ERR_IE_Msk = 0x4
	// Bit ERR_IE.
	DCMI_IER_ERR_IE = 0x4
	// Position of OVR_IE field.
	DCMI_IER_OVR_IE_Pos = 0x1
	// Bit mask of OVR_IE field.
	DCMI_IER_OVR_IE_Msk = 0x2
	// Bit OVR_IE.
	DCMI_IER_OVR_IE = 0x2
	// Position of FRAME_IE field.
	DCMI_IER_FRAME_IE_Pos = 0x0
	// Bit mask of FRAME_IE field.
	DCMI_IER_FRAME_IE_Msk = 0x1
	// Bit FRAME_IE.
	DCMI_IER_FRAME_IE = 0x1

	// MIS: masked interrupt status register
	// Position of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Pos = 0x4
	// Bit mask of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Msk = 0x10
	// Bit LINE_MIS.
	DCMI_MIS_LINE_MIS = 0x10
	// Position of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Pos = 0x3
	// Bit mask of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Msk = 0x8
	// Bit VSYNC_MIS.
	DCMI_MIS_VSYNC_MIS = 0x8
	// Position of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Pos = 0x2
	// Bit mask of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Msk = 0x4
	// Bit ERR_MIS.
	DCMI_MIS_ERR_MIS = 0x4
	// Position of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Pos = 0x1
	// Bit mask of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Msk = 0x2
	// Bit OVR_MIS.
	DCMI_MIS_OVR_MIS = 0x2
	// Position of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Pos = 0x0
	// Bit mask of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Msk = 0x1
	// Bit FRAME_MIS.
	DCMI_MIS_FRAME_MIS = 0x1

	// ICR: interrupt clear register
	// Position of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Pos = 0x4
	// Bit mask of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Msk = 0x10
	// Bit LINE_ISC.
	DCMI_ICR_LINE_ISC = 0x10
	// Position of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Pos = 0x3
	// Bit mask of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Msk = 0x8
	// Bit VSYNC_ISC.
	DCMI_ICR_VSYNC_ISC = 0x8
	// Position of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Pos = 0x2
	// Bit mask of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Msk = 0x4
	// Bit ERR_ISC.
	DCMI_ICR_ERR_ISC = 0x4
	// Position of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Pos = 0x1
	// Bit mask of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Msk = 0x2
	// Bit OVR_ISC.
	DCMI_ICR_OVR_ISC = 0x2
	// Position of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Pos = 0x0
	// Bit mask of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Msk = 0x1
	// Bit FRAME_ISC.
	DCMI_ICR_FRAME_ISC = 0x1

	// ESCR: embedded synchronization code register
	// Position of FEC field.
	DCMI_ESCR_FEC_Pos = 0x18
	// Bit mask of FEC field.
	DCMI_ESCR_FEC_Msk = 0xff000000
	// Position of LEC field.
	DCMI_ESCR_LEC_Pos = 0x10
	// Bit mask of LEC field.
	DCMI_ESCR_LEC_Msk = 0xff0000
	// Position of LSC field.
	DCMI_ESCR_LSC_Pos = 0x8
	// Bit mask of LSC field.
	DCMI_ESCR_LSC_Msk = 0xff00
	// Position of FSC field.
	DCMI_ESCR_FSC_Pos = 0x0
	// Bit mask of FSC field.
	DCMI_ESCR_FSC_Msk = 0xff

	// ESUR: embedded synchronization unmask register
	// Position of FEU field.
	DCMI_ESUR_FEU_Pos = 0x18
	// Bit mask of FEU field.
	DCMI_ESUR_FEU_Msk = 0xff000000
	// Position of LEU field.
	DCMI_ESUR_LEU_Pos = 0x10
	// Bit mask of LEU field.
	DCMI_ESUR_LEU_Msk = 0xff0000
	// Position of LSU field.
	DCMI_ESUR_LSU_Pos = 0x8
	// Bit mask of LSU field.
	DCMI_ESUR_LSU_Msk = 0xff00
	// Position of FSU field.
	DCMI_ESUR_FSU_Pos = 0x0
	// Bit mask of FSU field.
	DCMI_ESUR_FSU_Msk = 0xff

	// CWSTRT: crop window start
	// Position of VST field.
	DCMI_CWSTRT_VST_Pos = 0x10
	// Bit mask of VST field.
	DCMI_CWSTRT_VST_Msk = 0x1fff0000
	// Position of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Pos = 0x0
	// Bit mask of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Msk = 0x3fff

	// CWSIZE: crop window size
	// Position of VLINE field.
	DCMI_CWSIZE_VLINE_Pos = 0x10
	// Bit mask of VLINE field.
	DCMI_CWSIZE_VLINE_Msk = 0x3fff0000
	// Position of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Pos = 0x0
	// Bit mask of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Msk = 0x3fff

	// DR: data register
	// Position of Byte3 field.
	DCMI_DR_Byte3_Pos = 0x18
	// Bit mask of Byte3 field.
	DCMI_DR_Byte3_Msk = 0xff000000
	// Position of Byte2 field.
	DCMI_DR_Byte2_Pos = 0x10
	// Bit mask of Byte2 field.
	DCMI_DR_Byte2_Msk = 0xff0000
	// Position of Byte1 field.
	DCMI_DR_Byte1_Pos = 0x8
	// Bit mask of Byte1 field.
	DCMI_DR_Byte1_Msk = 0xff00
	// Position of Byte0 field.
	DCMI_DR_Byte0_Pos = 0x0
	// Bit mask of Byte0 field.
	DCMI_DR_Byte0_Msk = 0xff
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of CCLKEN field.
	FSMC_BCR1_CCLKEN_Pos = 0x14
	// Bit mask of CCLKEN field.
	FSMC_BCR1_CCLKEN_Msk = 0x100000
	// Bit CCLKEN.
	FSMC_BCR1_CCLKEN = 0x100000
	// The FMC_CLK is only generated during the synchronous memory access (read/write transaction)
	FSMC_BCR1_CCLKEN_Enabled = 0x1
	// The FMC_CLK is generated continuously during asynchronous and synchronous access. The FMC_CLK clock is activated when the CCLKEN is set
	FSMC_BCR1_CCLKEN_Disabled = 0x0
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of WFDIS field.
	FSMC_BCR1_WFDIS_Pos = 0x15
	// Bit mask of WFDIS field.
	FSMC_BCR1_WFDIS_Msk = 0x200000
	// Bit WFDIS.
	FSMC_BCR1_WFDIS = 0x200000
	// Write FIFO enabled
	FSMC_BCR1_WFDIS_Enabled = 0x0
	// Write FIFO disabled
	FSMC_BCR1_WFDIS_Disabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// PCR2: PC Card/NAND Flash control register 2
	// Position of ECCPS field.
	FSMC_PCR_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FSMC_PCR_ECCPS_Msk = 0xe0000
	// ECC page size 256 bytes
	FSMC_PCR_ECCPS_Bytes256 = 0x0
	// ECC page size 512 bytes
	FSMC_PCR_ECCPS_Bytes512 = 0x1
	// ECC page size 1024 bytes
	FSMC_PCR_ECCPS_Bytes1024 = 0x2
	// ECC page size 2048 bytes
	FSMC_PCR_ECCPS_Bytes2048 = 0x3
	// ECC page size 4096 bytes
	FSMC_PCR_ECCPS_Bytes4096 = 0x4
	// ECC page size 8192 bytes
	FSMC_PCR_ECCPS_Bytes8192 = 0x5
	// Position of TAR field.
	FSMC_PCR_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FSMC_PCR_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FSMC_PCR_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FSMC_PCR_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FSMC_PCR_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FSMC_PCR_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FSMC_PCR_ECCEN = 0x40
	// ECC logic is disabled and reset
	FSMC_PCR_ECCEN_Disabled = 0x0
	// ECC logic is enabled
	FSMC_PCR_ECCEN_Enabled = 0x1
	// Position of PWID field.
	FSMC_PCR_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FSMC_PCR_PWID_Msk = 0x30
	// External memory device width 8 bits
	FSMC_PCR_PWID_Bits8 = 0x0
	// External memory device width 16 bits
	FSMC_PCR_PWID_Bits16 = 0x1
	// Position of PTYP field.
	FSMC_PCR_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FSMC_PCR_PTYP_Msk = 0x8
	// Bit PTYP.
	FSMC_PCR_PTYP = 0x8
	// NAND Flash
	FSMC_PCR_PTYP_NANDFlash = 0x1
	// Position of PBKEN field.
	FSMC_PCR_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FSMC_PCR_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FSMC_PCR_PBKEN = 0x4
	// Corresponding memory bank is disabled
	FSMC_PCR_PBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_PCR_PBKEN_Enabled = 0x1
	// Position of PWAITEN field.
	FSMC_PCR_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FSMC_PCR_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FSMC_PCR_PWAITEN = 0x2
	// Wait feature disabled
	FSMC_PCR_PWAITEN_Disabled = 0x0
	// Wait feature enabled
	FSMC_PCR_PWAITEN_Enabled = 0x1

	// SR2: FIFO status and interrupt register 2
	// Position of FEMPT field.
	FSMC_SR_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FSMC_SR_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FSMC_SR_FEMPT = 0x40
	// FIFO not empty
	FSMC_SR_FEMPT_NotEmpty = 0x0
	// FIFO empty
	FSMC_SR_FEMPT_Empty = 0x1
	// Position of IFEN field.
	FSMC_SR_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FSMC_SR_IFEN_Msk = 0x20
	// Bit IFEN.
	FSMC_SR_IFEN = 0x20
	// Interrupt falling edge detection request disabled
	FSMC_SR_IFEN_Disabled = 0x0
	// Interrupt falling edge detection request enabled
	FSMC_SR_IFEN_Enabled = 0x1
	// Position of ILEN field.
	FSMC_SR_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FSMC_SR_ILEN_Msk = 0x10
	// Bit ILEN.
	FSMC_SR_ILEN = 0x10
	// Interrupt high-level detection request disabled
	FSMC_SR_ILEN_Disabled = 0x0
	// Interrupt high-level detection request enabled
	FSMC_SR_ILEN_Enabled = 0x1
	// Position of IREN field.
	FSMC_SR_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FSMC_SR_IREN_Msk = 0x8
	// Bit IREN.
	FSMC_SR_IREN = 0x8
	// Interrupt rising edge detection request disabled
	FSMC_SR_IREN_Disabled = 0x0
	// Interrupt rising edge detection request enabled
	FSMC_SR_IREN_Enabled = 0x1
	// Position of IFS field.
	FSMC_SR_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FSMC_SR_IFS_Msk = 0x4
	// Bit IFS.
	FSMC_SR_IFS = 0x4
	// Interrupt falling edge did not occur
	FSMC_SR_IFS_DidNotOccur = 0x0
	// Interrupt falling edge occurred
	FSMC_SR_IFS_Occurred = 0x1
	// Position of ILS field.
	FSMC_SR_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FSMC_SR_ILS_Msk = 0x2
	// Bit ILS.
	FSMC_SR_ILS = 0x2
	// Interrupt high-level did not occur
	FSMC_SR_ILS_DidNotOccur = 0x0
	// Interrupt high-level occurred
	FSMC_SR_ILS_Occurred = 0x1
	// Position of IRS field.
	FSMC_SR_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FSMC_SR_IRS_Msk = 0x1
	// Bit IRS.
	FSMC_SR_IRS = 0x1
	// Interrupt rising edge did not occur
	FSMC_SR_IRS_DidNotOccur = 0x0
	// Interrupt rising edge occurred
	FSMC_SR_IRS_Occurred = 0x1

	// PMEM2: Common memory space timing register 2
	// Position of MEMHIZ field.
	FSMC_PMEM2_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM2_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM2_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM2_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM2_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM2_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM2_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM2_MEMSET_Msk = 0xff

	// PATT2: Attribute memory space timing register 2
	// Position of ATTHIZ field.
	FSMC_PATT2_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT2_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT2_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT2_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT2_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT2_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT2_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT2_ATTSET_Msk = 0xff

	// ECCR2: ECC result register 2
	// Position of ECC field.
	FSMC_ECCR2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR2_ECC_Msk = 0xffffffff

	// PMEM3: Common memory space timing register 3
	// Position of MEMHIZ field.
	FSMC_PMEM3_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM3_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM3_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM3_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM3_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM3_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM3_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM3_MEMSET_Msk = 0xff

	// PATT3: Attribute memory space timing register 3
	// Position of ATTHIZ field.
	FSMC_PATT3_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT3_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT3_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT3_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT3_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT3_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT3_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT3_ATTSET_Msk = 0xff

	// ECCR3: ECC result register 3
	// Position of ECC field.
	FSMC_ECCR3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR3_ECC_Msk = 0xffffffff

	// PMEM4: Common memory space timing register 4
	// Position of MEMHIZ field.
	FSMC_PMEM4_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM4_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM4_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM4_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM4_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM4_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM4_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM4_MEMSET_Msk = 0xff

	// PATT4: Attribute memory space timing register 4
	// Position of ATTHIZ field.
	FSMC_PATT4_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT4_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT4_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT4_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT4_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT4_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT4_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT4_ATTSET_Msk = 0xff

	// PIO4: I/O space timing register 4
	// Position of IOHIZx field.
	FSMC_PIO4_IOHIZx_Pos = 0x18
	// Bit mask of IOHIZx field.
	FSMC_PIO4_IOHIZx_Msk = 0xff000000
	// Position of IOHOLDx field.
	FSMC_PIO4_IOHOLDx_Pos = 0x10
	// Bit mask of IOHOLDx field.
	FSMC_PIO4_IOHOLDx_Msk = 0xff0000
	// Position of IOWAITx field.
	FSMC_PIO4_IOWAITx_Pos = 0x8
	// Bit mask of IOWAITx field.
	FSMC_PIO4_IOWAITx_Msk = 0xff00
	// Position of IOSETx field.
	FSMC_PIO4_IOSETx_Pos = 0x0
	// Bit mask of IOSETx field.
	FSMC_PIO4_IOSETx_Msk = 0xff

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000

	// SDCR1: SDRAM Control Register 1
	// Position of NC field.
	FSMC_SDCR_NC_Pos = 0x0
	// Bit mask of NC field.
	FSMC_SDCR_NC_Msk = 0x3
	// 8 bits
	FSMC_SDCR_NC_Bits8 = 0x0
	// 9 bits
	FSMC_SDCR_NC_Bits9 = 0x1
	// 10 bits
	FSMC_SDCR_NC_Bits10 = 0x2
	// 11 bits
	FSMC_SDCR_NC_Bits11 = 0x3
	// Position of NR field.
	FSMC_SDCR_NR_Pos = 0x2
	// Bit mask of NR field.
	FSMC_SDCR_NR_Msk = 0xc
	// 11 bits
	FSMC_SDCR_NR_Bits11 = 0x0
	// 12 bits
	FSMC_SDCR_NR_Bits12 = 0x1
	// 13 bits
	FSMC_SDCR_NR_Bits13 = 0x2
	// Position of MWID field.
	FSMC_SDCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_SDCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_SDCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_SDCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_SDCR_MWID_Bits32 = 0x2
	// Position of NB field.
	FSMC_SDCR_NB_Pos = 0x6
	// Bit mask of NB field.
	FSMC_SDCR_NB_Msk = 0x40
	// Bit NB.
	FSMC_SDCR_NB = 0x40
	// Two internal Banks
	FSMC_SDCR_NB_NB2 = 0x0
	// Four internal Banks
	FSMC_SDCR_NB_NB4 = 0x1
	// Position of CAS field.
	FSMC_SDCR_CAS_Pos = 0x7
	// Bit mask of CAS field.
	FSMC_SDCR_CAS_Msk = 0x180
	// 1 cycle
	FSMC_SDCR_CAS_Clocks1 = 0x1
	// 2 cycles
	FSMC_SDCR_CAS_Clocks2 = 0x2
	// 3 cycles
	FSMC_SDCR_CAS_Clocks3 = 0x3
	// Position of WP field.
	FSMC_SDCR_WP_Pos = 0x9
	// Bit mask of WP field.
	FSMC_SDCR_WP_Msk = 0x200
	// Bit WP.
	FSMC_SDCR_WP = 0x200
	// Write accesses allowed
	FSMC_SDCR_WP_Disabled = 0x0
	// Write accesses ignored
	FSMC_SDCR_WP_Enabled = 0x1
	// Position of SDCLK field.
	FSMC_SDCR_SDCLK_Pos = 0xa
	// Bit mask of SDCLK field.
	FSMC_SDCR_SDCLK_Msk = 0xc00
	// SDCLK clock disabled
	FSMC_SDCR_SDCLK_Disabled = 0x0
	// SDCLK period = 2 x HCLK period
	FSMC_SDCR_SDCLK_Div2 = 0x2
	// SDCLK period = 3 x HCLK period
	FSMC_SDCR_SDCLK_Div3 = 0x3
	// Position of RBURST field.
	FSMC_SDCR_RBURST_Pos = 0xc
	// Bit mask of RBURST field.
	FSMC_SDCR_RBURST_Msk = 0x1000
	// Bit RBURST.
	FSMC_SDCR_RBURST = 0x1000
	// Single read requests are not managed as bursts
	FSMC_SDCR_RBURST_Disabled = 0x0
	// Single read requests are always managed as bursts
	FSMC_SDCR_RBURST_Enabled = 0x1
	// Position of RPIPE field.
	FSMC_SDCR_RPIPE_Pos = 0xd
	// Bit mask of RPIPE field.
	FSMC_SDCR_RPIPE_Msk = 0x6000
	// No clock cycle delay
	FSMC_SDCR_RPIPE_NoDelay = 0x0
	// One clock cycle delay
	FSMC_SDCR_RPIPE_Clocks1 = 0x1
	// Two clock cycles delay
	FSMC_SDCR_RPIPE_Clocks2 = 0x2

	// SDTR1: SDRAM Timing register 1
	// Position of TMRD field.
	FSMC_SDTR_TMRD_Pos = 0x0
	// Bit mask of TMRD field.
	FSMC_SDTR_TMRD_Msk = 0xf
	// Position of TXSR field.
	FSMC_SDTR_TXSR_Pos = 0x4
	// Bit mask of TXSR field.
	FSMC_SDTR_TXSR_Msk = 0xf0
	// Position of TRAS field.
	FSMC_SDTR_TRAS_Pos = 0x8
	// Bit mask of TRAS field.
	FSMC_SDTR_TRAS_Msk = 0xf00
	// Position of TRC field.
	FSMC_SDTR_TRC_Pos = 0xc
	// Bit mask of TRC field.
	FSMC_SDTR_TRC_Msk = 0xf000
	// Position of TWR field.
	FSMC_SDTR_TWR_Pos = 0x10
	// Bit mask of TWR field.
	FSMC_SDTR_TWR_Msk = 0xf0000
	// Position of TRP field.
	FSMC_SDTR_TRP_Pos = 0x14
	// Bit mask of TRP field.
	FSMC_SDTR_TRP_Msk = 0xf00000
	// Position of TRCD field.
	FSMC_SDTR_TRCD_Pos = 0x18
	// Bit mask of TRCD field.
	FSMC_SDTR_TRCD_Msk = 0xf000000

	// SDCMR: SDRAM Command Mode register
	// Position of MODE field.
	FSMC_SDCMR_MODE_Pos = 0x0
	// Bit mask of MODE field.
	FSMC_SDCMR_MODE_Msk = 0x7
	// Normal Mode
	FSMC_SDCMR_MODE_Normal = 0x0
	// Clock Configuration Enable
	FSMC_SDCMR_MODE_ClockConfigurationEnable = 0x1
	// PALL (All Bank Precharge) command
	FSMC_SDCMR_MODE_PALL = 0x2
	// Auto-refresh command
	FSMC_SDCMR_MODE_AutoRefreshCommand = 0x3
	// Load Mode Resgier
	FSMC_SDCMR_MODE_LoadModeRegister = 0x4
	// Self-refresh command
	FSMC_SDCMR_MODE_SelfRefreshCommand = 0x5
	// Power-down command
	FSMC_SDCMR_MODE_PowerDownCommand = 0x6
	// Position of CTB2 field.
	FSMC_SDCMR_CTB2_Pos = 0x3
	// Bit mask of CTB2 field.
	FSMC_SDCMR_CTB2_Msk = 0x8
	// Bit CTB2.
	FSMC_SDCMR_CTB2 = 0x8
	// Command not issued to SDRAM Bank 1
	FSMC_SDCMR_CTB2_NotIssued = 0x0
	// Command issued to SDRAM Bank 1
	FSMC_SDCMR_CTB2_Issued = 0x1
	// Position of CTB1 field.
	FSMC_SDCMR_CTB1_Pos = 0x4
	// Bit mask of CTB1 field.
	FSMC_SDCMR_CTB1_Msk = 0x10
	// Bit CTB1.
	FSMC_SDCMR_CTB1 = 0x10
	// Command not issued to SDRAM Bank 1
	FSMC_SDCMR_CTB1_NotIssued = 0x0
	// Command issued to SDRAM Bank 1
	FSMC_SDCMR_CTB1_Issued = 0x1
	// Position of NRFS field.
	FSMC_SDCMR_NRFS_Pos = 0x5
	// Bit mask of NRFS field.
	FSMC_SDCMR_NRFS_Msk = 0x1e0
	// Position of MRD field.
	FSMC_SDCMR_MRD_Pos = 0x9
	// Bit mask of MRD field.
	FSMC_SDCMR_MRD_Msk = 0x3ffe00

	// SDRTR: SDRAM Refresh Timer register
	// Position of CRE field.
	FSMC_SDRTR_CRE_Pos = 0x0
	// Bit mask of CRE field.
	FSMC_SDRTR_CRE_Msk = 0x1
	// Bit CRE.
	FSMC_SDRTR_CRE = 0x1
	// Refresh Error Flag is cleared
	FSMC_SDRTR_CRE_Clear = 0x1
	// Position of COUNT field.
	FSMC_SDRTR_COUNT_Pos = 0x1
	// Bit mask of COUNT field.
	FSMC_SDRTR_COUNT_Msk = 0x3ffe
	// Position of REIE field.
	FSMC_SDRTR_REIE_Pos = 0xe
	// Bit mask of REIE field.
	FSMC_SDRTR_REIE_Msk = 0x4000
	// Bit REIE.
	FSMC_SDRTR_REIE = 0x4000
	// Interrupt is disabled
	FSMC_SDRTR_REIE_Disabled = 0x0
	// Interrupt is generated if RE = 1
	FSMC_SDRTR_REIE_Enabled = 0x1

	// SDSR: SDRAM Status register
	// Position of RE field.
	FSMC_SDSR_RE_Pos = 0x0
	// Bit mask of RE field.
	FSMC_SDSR_RE_Msk = 0x1
	// Bit RE.
	FSMC_SDSR_RE = 0x1
	// No refresh error has been detected
	FSMC_SDSR_RE_NoError = 0x0
	// A refresh error has been detected
	FSMC_SDSR_RE_Error = 0x1
	// Position of MODES1 field.
	FSMC_SDSR_MODES1_Pos = 0x1
	// Bit mask of MODES1 field.
	FSMC_SDSR_MODES1_Msk = 0x6
	// Normal Mode
	FSMC_SDSR_MODES1_Normal = 0x0
	// Self-refresh mode
	FSMC_SDSR_MODES1_SelfRefresh = 0x1
	// Power-down mode
	FSMC_SDSR_MODES1_PowerDown = 0x2
	// Position of MODES2 field.
	FSMC_SDSR_MODES2_Pos = 0x3
	// Bit mask of MODES2 field.
	FSMC_SDSR_MODES2_Msk = 0x18
	// Normal Mode
	FSMC_SDSR_MODES2_Normal = 0x0
	// Self-refresh mode
	FSMC_SDSR_MODES2_SelfRefresh = 0x1
	// Power-down mode
	FSMC_SDSR_MODES2_PowerDown = 0x2
	// Position of BUSY field.
	FSMC_SDSR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	FSMC_SDSR_BUSY_Msk = 0x20
	// Bit BUSY.
	FSMC_SDSR_BUSY = 0x20
	// SDRAM Controller is ready to accept a new request
	FSMC_SDSR_BUSY_NotBusy = 0x0
	// SDRAM Controller is not ready to accept a new request
	FSMC_SDSR_BUSY_Busy = 0x1
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Control Register
	// Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBG_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBG_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: Debug MCU APB1 Freeze registe
	// Position of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBG_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBG_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIM6_STOP field.
	DBG_APB1_FZ_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBG_APB1_FZ_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBG_APB1_FZ_DBG_TIM6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBG_APB1_FZ_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBG_APB1_FZ_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBG_APB1_FZ_DBG_TIM7_STOP = 0x20
	// Position of DBG_TIM12_STOP field.
	DBG_APB1_FZ_DBG_TIM12_STOP_Pos = 0x6
	// Bit mask of DBG_TIM12_STOP field.
	DBG_APB1_FZ_DBG_TIM12_STOP_Msk = 0x40
	// Bit DBG_TIM12_STOP.
	DBG_APB1_FZ_DBG_TIM12_STOP = 0x40
	// Position of DBG_TIM13_STOP field.
	DBG_APB1_FZ_DBG_TIM13_STOP_Pos = 0x7
	// Bit mask of DBG_TIM13_STOP field.
	DBG_APB1_FZ_DBG_TIM13_STOP_Msk = 0x80
	// Bit DBG_TIM13_STOP.
	DBG_APB1_FZ_DBG_TIM13_STOP = 0x80
	// Position of DBG_TIM14_STOP field.
	DBG_APB1_FZ_DBG_TIM14_STOP_Pos = 0x8
	// Bit mask of DBG_TIM14_STOP field.
	DBG_APB1_FZ_DBG_TIM14_STOP_Msk = 0x100
	// Bit DBG_TIM14_STOP.
	DBG_APB1_FZ_DBG_TIM14_STOP = 0x100
	// Position of DBG_RTC_STOP field.
	DBG_APB1_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBG_APB1_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBG_APB1_FZ_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_J2C1_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT = 0x200000
	// Position of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit DBG_J2C2_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT = 0x400000
	// Position of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Pos = 0x17
	// Bit mask of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Msk = 0x800000
	// Bit DBG_J2C3SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT = 0x800000
	// Position of DBG_I2CFMP_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT_Pos = 0x18
	// Bit mask of DBG_I2CFMP_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT_Msk = 0x1000000
	// Bit DBG_I2CFMP_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT = 0x1000000
	// Position of DBG_CAN1_STOP field.
	DBG_APB1_FZ_DBG_CAN1_STOP_Pos = 0x19
	// Bit mask of DBG_CAN1_STOP field.
	DBG_APB1_FZ_DBG_CAN1_STOP_Msk = 0x2000000
	// Bit DBG_CAN1_STOP.
	DBG_APB1_FZ_DBG_CAN1_STOP = 0x2000000
	// Position of DBG_CAN2_STOP field.
	DBG_APB1_FZ_DBG_CAN2_STOP_Pos = 0x1a
	// Bit mask of DBG_CAN2_STOP field.
	DBG_APB1_FZ_DBG_CAN2_STOP_Msk = 0x4000000
	// Bit DBG_CAN2_STOP.
	DBG_APB1_FZ_DBG_CAN2_STOP = 0x4000000

	// APB2_FZ: Debug MCU APB2 Freeze registe
	// Position of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Pos = 0x0
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Msk = 0x1
	// Bit DBG_TIM1_STOP.
	DBG_APB2_FZ_DBG_TIM1_STOP = 0x1
	// Position of DBG_TIM8_STOP field.
	DBG_APB2_FZ_DBG_TIM8_STOP_Pos = 0x1
	// Bit mask of DBG_TIM8_STOP field.
	DBG_APB2_FZ_DBG_TIM8_STOP_Msk = 0x2
	// Bit DBG_TIM8_STOP.
	DBG_APB2_FZ_DBG_TIM8_STOP = 0x2
	// Position of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Pos = 0x10
	// Bit mask of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Msk = 0x10000
	// Bit DBG_TIM9_STOP.
	DBG_APB2_FZ_DBG_TIM9_STOP = 0x10000
	// Position of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11
	// Bit mask of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000
	// Bit DBG_TIM10_STOP.
	DBG_APB2_FZ_DBG_TIM10_STOP = 0x20000
	// Position of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12
	// Bit mask of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000
	// Bit DBG_TIM11_STOP.
	DBG_APB2_FZ_DBG_TIM11_STOP = 0x40000
)

// Bitfields for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	// Position of TCIF3 field.
	DMA_LISR_TCIF3_Pos = 0x1b
	// Bit mask of TCIF3 field.
	DMA_LISR_TCIF3_Msk = 0x8000000
	// Bit TCIF3.
	DMA_LISR_TCIF3 = 0x8000000
	// No transfer complete event on stream x
	DMA_LISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_LISR_HTIF3_Pos = 0x1a
	// Bit mask of HTIF3 field.
	DMA_LISR_HTIF3_Msk = 0x4000000
	// Bit HTIF3.
	DMA_LISR_HTIF3 = 0x4000000
	// No half transfer event on stream x
	DMA_LISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_LISR_TEIF3_Pos = 0x19
	// Bit mask of TEIF3 field.
	DMA_LISR_TEIF3_Msk = 0x2000000
	// Bit TEIF3.
	DMA_LISR_TEIF3 = 0x2000000
	// No transfer error on stream x
	DMA_LISR_TEIF3_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF3_Error = 0x1
	// Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Pos = 0x18
	// Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000
	// Bit DMEIF3.
	DMA_LISR_DMEIF3 = 0x1000000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF3_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF3_Error = 0x1
	// Position of FEIF3 field.
	DMA_LISR_FEIF3_Pos = 0x16
	// Bit mask of FEIF3 field.
	DMA_LISR_FEIF3_Msk = 0x400000
	// Bit FEIF3.
	DMA_LISR_FEIF3 = 0x400000
	// No FIFO error event on stream x
	DMA_LISR_FEIF3_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF3_Error = 0x1
	// Position of TCIF2 field.
	DMA_LISR_TCIF2_Pos = 0x15
	// Bit mask of TCIF2 field.
	DMA_LISR_TCIF2_Msk = 0x200000
	// Bit TCIF2.
	DMA_LISR_TCIF2 = 0x200000
	// No transfer complete event on stream x
	DMA_LISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_LISR_HTIF2_Pos = 0x14
	// Bit mask of HTIF2 field.
	DMA_LISR_HTIF2_Msk = 0x100000
	// Bit HTIF2.
	DMA_LISR_HTIF2 = 0x100000
	// No half transfer event on stream x
	DMA_LISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_LISR_TEIF2_Pos = 0x13
	// Bit mask of TEIF2 field.
	DMA_LISR_TEIF2_Msk = 0x80000
	// Bit TEIF2.
	DMA_LISR_TEIF2 = 0x80000
	// No transfer error on stream x
	DMA_LISR_TEIF2_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF2_Error = 0x1
	// Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Pos = 0x12
	// Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000
	// Bit DMEIF2.
	DMA_LISR_DMEIF2 = 0x40000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF2_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF2_Error = 0x1
	// Position of FEIF2 field.
	DMA_LISR_FEIF2_Pos = 0x10
	// Bit mask of FEIF2 field.
	DMA_LISR_FEIF2_Msk = 0x10000
	// Bit FEIF2.
	DMA_LISR_FEIF2 = 0x10000
	// No FIFO error event on stream x
	DMA_LISR_FEIF2_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF2_Error = 0x1
	// Position of TCIF1 field.
	DMA_LISR_TCIF1_Pos = 0xb
	// Bit mask of TCIF1 field.
	DMA_LISR_TCIF1_Msk = 0x800
	// Bit TCIF1.
	DMA_LISR_TCIF1 = 0x800
	// No transfer complete event on stream x
	DMA_LISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_LISR_HTIF1_Pos = 0xa
	// Bit mask of HTIF1 field.
	DMA_LISR_HTIF1_Msk = 0x400
	// Bit HTIF1.
	DMA_LISR_HTIF1 = 0x400
	// No half transfer event on stream x
	DMA_LISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_LISR_TEIF1_Pos = 0x9
	// Bit mask of TEIF1 field.
	DMA_LISR_TEIF1_Msk = 0x200
	// Bit TEIF1.
	DMA_LISR_TEIF1 = 0x200
	// No transfer error on stream x
	DMA_LISR_TEIF1_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF1_Error = 0x1
	// Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Pos = 0x8
	// Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100
	// Bit DMEIF1.
	DMA_LISR_DMEIF1 = 0x100
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF1_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF1_Error = 0x1
	// Position of FEIF1 field.
	DMA_LISR_FEIF1_Pos = 0x6
	// Bit mask of FEIF1 field.
	DMA_LISR_FEIF1_Msk = 0x40
	// Bit FEIF1.
	DMA_LISR_FEIF1 = 0x40
	// No FIFO error event on stream x
	DMA_LISR_FEIF1_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF1_Error = 0x1
	// Position of TCIF0 field.
	DMA_LISR_TCIF0_Pos = 0x5
	// Bit mask of TCIF0 field.
	DMA_LISR_TCIF0_Msk = 0x20
	// Bit TCIF0.
	DMA_LISR_TCIF0 = 0x20
	// No transfer complete event on stream x
	DMA_LISR_TCIF0_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF0_Complete = 0x1
	// Position of HTIF0 field.
	DMA_LISR_HTIF0_Pos = 0x4
	// Bit mask of HTIF0 field.
	DMA_LISR_HTIF0_Msk = 0x10
	// Bit HTIF0.
	DMA_LISR_HTIF0 = 0x10
	// No half transfer event on stream x
	DMA_LISR_HTIF0_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF0_Half = 0x1
	// Position of TEIF0 field.
	DMA_LISR_TEIF0_Pos = 0x3
	// Bit mask of TEIF0 field.
	DMA_LISR_TEIF0_Msk = 0x8
	// Bit TEIF0.
	DMA_LISR_TEIF0 = 0x8
	// No transfer error on stream x
	DMA_LISR_TEIF0_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF0_Error = 0x1
	// Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Pos = 0x2
	// Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4
	// Bit DMEIF0.
	DMA_LISR_DMEIF0 = 0x4
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF0_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF0_Error = 0x1
	// Position of FEIF0 field.
	DMA_LISR_FEIF0_Pos = 0x0
	// Bit mask of FEIF0 field.
	DMA_LISR_FEIF0_Msk = 0x1
	// Bit FEIF0.
	DMA_LISR_FEIF0 = 0x1
	// No FIFO error event on stream x
	DMA_LISR_FEIF0_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF0_Error = 0x1

	// HISR: high interrupt status register
	// Position of TCIF7 field.
	DMA_HISR_TCIF7_Pos = 0x1b
	// Bit mask of TCIF7 field.
	DMA_HISR_TCIF7_Msk = 0x8000000
	// Bit TCIF7.
	DMA_HISR_TCIF7 = 0x8000000
	// No transfer complete event on stream x
	DMA_HISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_HISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_HISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_HISR_HTIF7 = 0x4000000
	// No half transfer event on stream x
	DMA_HISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_HISR_TEIF7_Pos = 0x19
	// Bit mask of TEIF7 field.
	DMA_HISR_TEIF7_Msk = 0x2000000
	// Bit TEIF7.
	DMA_HISR_TEIF7 = 0x2000000
	// No transfer error on stream x
	DMA_HISR_TEIF7_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF7_Error = 0x1
	// Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Pos = 0x18
	// Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000
	// Bit DMEIF7.
	DMA_HISR_DMEIF7 = 0x1000000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF7_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF7_Error = 0x1
	// Position of FEIF7 field.
	DMA_HISR_FEIF7_Pos = 0x16
	// Bit mask of FEIF7 field.
	DMA_HISR_FEIF7_Msk = 0x400000
	// Bit FEIF7.
	DMA_HISR_FEIF7 = 0x400000
	// No FIFO error event on stream x
	DMA_HISR_FEIF7_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF7_Error = 0x1
	// Position of TCIF6 field.
	DMA_HISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_HISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_HISR_TCIF6 = 0x200000
	// No transfer complete event on stream x
	DMA_HISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_HISR_HTIF6_Pos = 0x14
	// Bit mask of HTIF6 field.
	DMA_HISR_HTIF6_Msk = 0x100000
	// Bit HTIF6.
	DMA_HISR_HTIF6 = 0x100000
	// No half transfer event on stream x
	DMA_HISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_HISR_TEIF6_Pos = 0x13
	// Bit mask of TEIF6 field.
	DMA_HISR_TEIF6_Msk = 0x80000
	// Bit TEIF6.
	DMA_HISR_TEIF6 = 0x80000
	// No transfer error on stream x
	DMA_HISR_TEIF6_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF6_Error = 0x1
	// Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Pos = 0x12
	// Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000
	// Bit DMEIF6.
	DMA_HISR_DMEIF6 = 0x40000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF6_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF6_Error = 0x1
	// Position of FEIF6 field.
	DMA_HISR_FEIF6_Pos = 0x10
	// Bit mask of FEIF6 field.
	DMA_HISR_FEIF6_Msk = 0x10000
	// Bit FEIF6.
	DMA_HISR_FEIF6 = 0x10000
	// No FIFO error event on stream x
	DMA_HISR_FEIF6_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF6_Error = 0x1
	// Position of TCIF5 field.
	DMA_HISR_TCIF5_Pos = 0xb
	// Bit mask of TCIF5 field.
	DMA_HISR_TCIF5_Msk = 0x800
	// Bit TCIF5.
	DMA_HISR_TCIF5 = 0x800
	// No transfer complete event on stream x
	DMA_HISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_HISR_HTIF5_Pos = 0xa
	// Bit mask of HTIF5 field.
	DMA_HISR_HTIF5_Msk = 0x400
	// Bit HTIF5.
	DMA_HISR_HTIF5 = 0x400
	// No half transfer event on stream x
	DMA_HISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_HISR_TEIF5_Pos = 0x9
	// Bit mask of TEIF5 field.
	DMA_HISR_TEIF5_Msk = 0x200
	// Bit TEIF5.
	DMA_HISR_TEIF5 = 0x200
	// No transfer error on stream x
	DMA_HISR_TEIF5_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF5_Error = 0x1
	// Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Pos = 0x8
	// Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100
	// Bit DMEIF5.
	DMA_HISR_DMEIF5 = 0x100
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF5_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF5_Error = 0x1
	// Position of FEIF5 field.
	DMA_HISR_FEIF5_Pos = 0x6
	// Bit mask of FEIF5 field.
	DMA_HISR_FEIF5_Msk = 0x40
	// Bit FEIF5.
	DMA_HISR_FEIF5 = 0x40
	// No FIFO error event on stream x
	DMA_HISR_FEIF5_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF5_Error = 0x1
	// Position of TCIF4 field.
	DMA_HISR_TCIF4_Pos = 0x5
	// Bit mask of TCIF4 field.
	DMA_HISR_TCIF4_Msk = 0x20
	// Bit TCIF4.
	DMA_HISR_TCIF4 = 0x20
	// No transfer complete event on stream x
	DMA_HISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_HISR_HTIF4_Pos = 0x4
	// Bit mask of HTIF4 field.
	DMA_HISR_HTIF4_Msk = 0x10
	// Bit HTIF4.
	DMA_HISR_HTIF4 = 0x10
	// No half transfer event on stream x
	DMA_HISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_HISR_TEIF4_Pos = 0x3
	// Bit mask of TEIF4 field.
	DMA_HISR_TEIF4_Msk = 0x8
	// Bit TEIF4.
	DMA_HISR_TEIF4 = 0x8
	// No transfer error on stream x
	DMA_HISR_TEIF4_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF4_Error = 0x1
	// Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Pos = 0x2
	// Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4
	// Bit DMEIF4.
	DMA_HISR_DMEIF4 = 0x4
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF4_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF4_Error = 0x1
	// Position of FEIF4 field.
	DMA_HISR_FEIF4_Pos = 0x0
	// Bit mask of FEIF4 field.
	DMA_HISR_FEIF4_Msk = 0x1
	// Bit FEIF4.
	DMA_HISR_FEIF4 = 0x1
	// No FIFO error event on stream x
	DMA_HISR_FEIF4_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF4_Error = 0x1

	// LIFCR: low interrupt flag clear register
	// Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Pos = 0x1b
	// Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk = 0x8000000
	// Bit CTCIF3.
	DMA_LIFCR_CTCIF3 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Pos = 0x1a
	// Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk = 0x4000000
	// Bit CHTIF3.
	DMA_LIFCR_CHTIF3 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Pos = 0x19
	// Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk = 0x2000000
	// Bit CTEIF3.
	DMA_LIFCR_CTEIF3 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF3_Clear = 0x1
	// Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Pos = 0x18
	// Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000
	// Bit CDMEIF3.
	DMA_LIFCR_CDMEIF3 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF3_Clear = 0x1
	// Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Pos = 0x16
	// Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk = 0x400000
	// Bit CFEIF3.
	DMA_LIFCR_CFEIF3 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF3_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Pos = 0x15
	// Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk = 0x200000
	// Bit CTCIF2.
	DMA_LIFCR_CTCIF2 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Pos = 0x14
	// Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk = 0x100000
	// Bit CHTIF2.
	DMA_LIFCR_CHTIF2 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Pos = 0x13
	// Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk = 0x80000
	// Bit CTEIF2.
	DMA_LIFCR_CTEIF2 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF2_Clear = 0x1
	// Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Pos = 0x12
	// Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000
	// Bit CDMEIF2.
	DMA_LIFCR_CDMEIF2 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF2_Clear = 0x1
	// Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Pos = 0x10
	// Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk = 0x10000
	// Bit CFEIF2.
	DMA_LIFCR_CFEIF2 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF2_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Pos = 0xb
	// Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk = 0x800
	// Bit CTCIF1.
	DMA_LIFCR_CTCIF1 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Pos = 0xa
	// Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk = 0x400
	// Bit CHTIF1.
	DMA_LIFCR_CHTIF1 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Pos = 0x9
	// Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk = 0x200
	// Bit CTEIF1.
	DMA_LIFCR_CTEIF1 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF1_Clear = 0x1
	// Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Pos = 0x8
	// Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100
	// Bit CDMEIF1.
	DMA_LIFCR_CDMEIF1 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF1_Clear = 0x1
	// Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Pos = 0x6
	// Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk = 0x40
	// Bit CFEIF1.
	DMA_LIFCR_CFEIF1 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF1_Clear = 0x1
	// Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Pos = 0x5
	// Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk = 0x20
	// Bit CTCIF0.
	DMA_LIFCR_CTCIF0 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF0_Clear = 0x1
	// Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Pos = 0x4
	// Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk = 0x10
	// Bit CHTIF0.
	DMA_LIFCR_CHTIF0 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF0_Clear = 0x1
	// Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Pos = 0x3
	// Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk = 0x8
	// Bit CTEIF0.
	DMA_LIFCR_CTEIF0 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF0_Clear = 0x1
	// Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Pos = 0x2
	// Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4
	// Bit CDMEIF0.
	DMA_LIFCR_CDMEIF0 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF0_Clear = 0x1
	// Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Pos = 0x0
	// Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk = 0x1
	// Bit CFEIF0.
	DMA_LIFCR_CFEIF0 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF0_Clear = 0x1

	// HIFCR: high interrupt flag clear register
	// Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Pos = 0x1b
	// Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk = 0x8000000
	// Bit CTCIF7.
	DMA_HIFCR_CTCIF7 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_HIFCR_CHTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Pos = 0x19
	// Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk = 0x2000000
	// Bit CTEIF7.
	DMA_HIFCR_CTEIF7 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF7_Clear = 0x1
	// Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Pos = 0x18
	// Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000
	// Bit CDMEIF7.
	DMA_HIFCR_CDMEIF7 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF7_Clear = 0x1
	// Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Pos = 0x16
	// Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk = 0x400000
	// Bit CFEIF7.
	DMA_HIFCR_CFEIF7 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF7_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_HIFCR_CTCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Pos = 0x14
	// Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk = 0x100000
	// Bit CHTIF6.
	DMA_HIFCR_CHTIF6 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Pos = 0x13
	// Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk = 0x80000
	// Bit CTEIF6.
	DMA_HIFCR_CTEIF6 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF6_Clear = 0x1
	// Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Pos = 0x12
	// Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000
	// Bit CDMEIF6.
	DMA_HIFCR_CDMEIF6 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF6_Clear = 0x1
	// Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Pos = 0x10
	// Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk = 0x10000
	// Bit CFEIF6.
	DMA_HIFCR_CFEIF6 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF6_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Pos = 0xb
	// Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk = 0x800
	// Bit CTCIF5.
	DMA_HIFCR_CTCIF5 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Pos = 0xa
	// Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk = 0x400
	// Bit CHTIF5.
	DMA_HIFCR_CHTIF5 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Pos = 0x9
	// Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk = 0x200
	// Bit CTEIF5.
	DMA_HIFCR_CTEIF5 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF5_Clear = 0x1
	// Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Pos = 0x8
	// Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100
	// Bit CDMEIF5.
	DMA_HIFCR_CDMEIF5 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF5_Clear = 0x1
	// Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Pos = 0x6
	// Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk = 0x40
	// Bit CFEIF5.
	DMA_HIFCR_CFEIF5 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF5_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Pos = 0x5
	// Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk = 0x20
	// Bit CTCIF4.
	DMA_HIFCR_CTCIF4 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Pos = 0x4
	// Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk = 0x10
	// Bit CHTIF4.
	DMA_HIFCR_CHTIF4 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Pos = 0x3
	// Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk = 0x8
	// Bit CTEIF4.
	DMA_HIFCR_CTEIF4 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF4_Clear = 0x1
	// Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Pos = 0x2
	// Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4
	// Bit CDMEIF4.
	DMA_HIFCR_CDMEIF4 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF4_Clear = 0x1
	// Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Pos = 0x0
	// Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk = 0x1
	// Bit CFEIF4.
	DMA_HIFCR_CFEIF4 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF4_Clear = 0x1

	// ST.CR: stream x configuration register
	// Position of CHSEL field.
	DMA_ST_CR_CHSEL_Pos = 0x19
	// Bit mask of CHSEL field.
	DMA_ST_CR_CHSEL_Msk = 0xe000000
	// Position of MBURST field.
	DMA_ST_CR_MBURST_Pos = 0x17
	// Bit mask of MBURST field.
	DMA_ST_CR_MBURST_Msk = 0x1800000
	// Single transfer
	DMA_ST_CR_MBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_MBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_MBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_MBURST_INCR16 = 0x3
	// Position of PBURST field.
	DMA_ST_CR_PBURST_Pos = 0x15
	// Bit mask of PBURST field.
	DMA_ST_CR_PBURST_Msk = 0x600000
	// Single transfer
	DMA_ST_CR_PBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_PBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_PBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_PBURST_INCR16 = 0x3
	// Position of CT field.
	DMA_ST_CR_CT_Pos = 0x13
	// Bit mask of CT field.
	DMA_ST_CR_CT_Msk = 0x80000
	// Bit CT.
	DMA_ST_CR_CT = 0x80000
	// The current target memory is Memory 0
	DMA_ST_CR_CT_Memory0 = 0x0
	// The current target memory is Memory 1
	DMA_ST_CR_CT_Memory1 = 0x1
	// Position of DBM field.
	DMA_ST_CR_DBM_Pos = 0x12
	// Bit mask of DBM field.
	DMA_ST_CR_DBM_Msk = 0x40000
	// Bit DBM.
	DMA_ST_CR_DBM = 0x40000
	// No buffer switching at the end of transfer
	DMA_ST_CR_DBM_Disabled = 0x0
	// Memory target switched at the end of the DMA transfer
	DMA_ST_CR_DBM_Enabled = 0x1
	// Position of PL field.
	DMA_ST_CR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA_ST_CR_PL_Msk = 0x30000
	// Low
	DMA_ST_CR_PL_Low = 0x0
	// Medium
	DMA_ST_CR_PL_Medium = 0x1
	// High
	DMA_ST_CR_PL_High = 0x2
	// Very high
	DMA_ST_CR_PL_VeryHigh = 0x3
	// Position of PINCOS field.
	DMA_ST_CR_PINCOS_Pos = 0xf
	// Bit mask of PINCOS field.
	DMA_ST_CR_PINCOS_Msk = 0x8000
	// Bit PINCOS.
	DMA_ST_CR_PINCOS = 0x8000
	// The offset size for the peripheral address calculation is linked to the PSIZE
	DMA_ST_CR_PINCOS_PSIZE = 0x0
	// The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)
	DMA_ST_CR_PINCOS_Fixed4 = 0x1
	// Position of MSIZE field.
	DMA_ST_CR_MSIZE_Pos = 0xd
	// Bit mask of MSIZE field.
	DMA_ST_CR_MSIZE_Msk = 0x6000
	// Byte (8-bit)
	DMA_ST_CR_MSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_MSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_ST_CR_PSIZE_Pos = 0xb
	// Bit mask of PSIZE field.
	DMA_ST_CR_PSIZE_Msk = 0x1800
	// Byte (8-bit)
	DMA_ST_CR_PSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_PSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_ST_CR_MINC_Pos = 0xa
	// Bit mask of MINC field.
	DMA_ST_CR_MINC_Msk = 0x400
	// Bit MINC.
	DMA_ST_CR_MINC = 0x400
	// Address pointer is fixed
	DMA_ST_CR_MINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_MINC_Incremented = 0x1
	// Position of PINC field.
	DMA_ST_CR_PINC_Pos = 0x9
	// Bit mask of PINC field.
	DMA_ST_CR_PINC_Msk = 0x200
	// Bit PINC.
	DMA_ST_CR_PINC = 0x200
	// Address pointer is fixed
	DMA_ST_CR_PINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_PINC_Incremented = 0x1
	// Position of CIRC field.
	DMA_ST_CR_CIRC_Pos = 0x8
	// Bit mask of CIRC field.
	DMA_ST_CR_CIRC_Msk = 0x100
	// Bit CIRC.
	DMA_ST_CR_CIRC = 0x100
	// Circular mode disabled
	DMA_ST_CR_CIRC_Disabled = 0x0
	// Circular mode enabled
	DMA_ST_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_ST_CR_DIR_Pos = 0x6
	// Bit mask of DIR field.
	DMA_ST_CR_DIR_Msk = 0xc0
	// Peripheral-to-memory
	DMA_ST_CR_DIR_PeripheralToMemory = 0x0
	// Memory-to-peripheral
	DMA_ST_CR_DIR_MemoryToPeripheral = 0x1
	// Memory-to-memory
	DMA_ST_CR_DIR_MemoryToMemory = 0x2
	// Position of PFCTRL field.
	DMA_ST_CR_PFCTRL_Pos = 0x5
	// Bit mask of PFCTRL field.
	DMA_ST_CR_PFCTRL_Msk = 0x20
	// Bit PFCTRL.
	DMA_ST_CR_PFCTRL = 0x20
	// The DMA is the flow controller
	DMA_ST_CR_PFCTRL_DMA = 0x0
	// The peripheral is the flow controller
	DMA_ST_CR_PFCTRL_Peripheral = 0x1
	// Position of TCIE field.
	DMA_ST_CR_TCIE_Pos = 0x4
	// Bit mask of TCIE field.
	DMA_ST_CR_TCIE_Msk = 0x10
	// Bit TCIE.
	DMA_ST_CR_TCIE = 0x10
	// TC interrupt disabled
	DMA_ST_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA_ST_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_ST_CR_HTIE_Pos = 0x3
	// Bit mask of HTIE field.
	DMA_ST_CR_HTIE_Msk = 0x8
	// Bit HTIE.
	DMA_ST_CR_HTIE = 0x8
	// HT interrupt disabled
	DMA_ST_CR_HTIE_Disabled = 0x0
	// HT interrupt enabled
	DMA_ST_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_ST_CR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	DMA_ST_CR_TEIE_Msk = 0x4
	// Bit TEIE.
	DMA_ST_CR_TEIE = 0x4
	// TE interrupt disabled
	DMA_ST_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA_ST_CR_TEIE_Enabled = 0x1
	// Position of DMEIE field.
	DMA_ST_CR_DMEIE_Pos = 0x1
	// Bit mask of DMEIE field.
	DMA_ST_CR_DMEIE_Msk = 0x2
	// Bit DMEIE.
	DMA_ST_CR_DMEIE = 0x2
	// DME interrupt disabled
	DMA_ST_CR_DMEIE_Disabled = 0x0
	// DME interrupt enabled
	DMA_ST_CR_DMEIE_Enabled = 0x1
	// Position of EN field.
	DMA_ST_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_ST_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_ST_CR_EN = 0x1
	// Stream disabled
	DMA_ST_CR_EN_Disabled = 0x0
	// Stream enabled
	DMA_ST_CR_EN_Enabled = 0x1

	// ST.NDTR: stream x number of data register
	// Position of NDT field.
	DMA_ST_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_ST_NDTR_NDT_Msk = 0xffff

	// ST.PAR: stream x peripheral address register
	// Position of PA field.
	DMA_ST_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_ST_PAR_PA_Msk = 0xffffffff

	// ST.M0AR: stream x memory 0 address register
	// Position of M0A field.
	DMA_ST_M0AR_M0A_Pos = 0x0
	// Bit mask of M0A field.
	DMA_ST_M0AR_M0A_Msk = 0xffffffff

	// ST.M1AR: stream x memory 1 address register
	// Position of M1A field.
	DMA_ST_M1AR_M1A_Pos = 0x0
	// Bit mask of M1A field.
	DMA_ST_M1AR_M1A_Msk = 0xffffffff

	// ST.FCR: stream x FIFO control register
	// Position of FEIE field.
	DMA_ST_FCR_FEIE_Pos = 0x7
	// Bit mask of FEIE field.
	DMA_ST_FCR_FEIE_Msk = 0x80
	// Bit FEIE.
	DMA_ST_FCR_FEIE = 0x80
	// FE interrupt disabled
	DMA_ST_FCR_FEIE_Disabled = 0x0
	// FE interrupt enabled
	DMA_ST_FCR_FEIE_Enabled = 0x1
	// Position of FS field.
	DMA_ST_FCR_FS_Pos = 0x3
	// Bit mask of FS field.
	DMA_ST_FCR_FS_Msk = 0x38
	// 0 < fifo_level < 1/4
	DMA_ST_FCR_FS_Quarter1 = 0x0
	// 1/4 <= fifo_level < 1/2
	DMA_ST_FCR_FS_Quarter2 = 0x1
	// 1/2 <= fifo_level < 3/4
	DMA_ST_FCR_FS_Quarter3 = 0x2
	// 3/4 <= fifo_level < full
	DMA_ST_FCR_FS_Quarter4 = 0x3
	// FIFO is empty
	DMA_ST_FCR_FS_Empty = 0x4
	// FIFO is full
	DMA_ST_FCR_FS_Full = 0x5
	// Position of DMDIS field.
	DMA_ST_FCR_DMDIS_Pos = 0x2
	// Bit mask of DMDIS field.
	DMA_ST_FCR_DMDIS_Msk = 0x4
	// Bit DMDIS.
	DMA_ST_FCR_DMDIS = 0x4
	// Direct mode is enabled
	DMA_ST_FCR_DMDIS_Enabled = 0x0
	// Direct mode is disabled
	DMA_ST_FCR_DMDIS_Disabled = 0x1
	// Position of FTH field.
	DMA_ST_FCR_FTH_Pos = 0x0
	// Bit mask of FTH field.
	DMA_ST_FCR_FTH_Msk = 0x3
	// 1/4 full FIFO
	DMA_ST_FCR_FTH_Quarter = 0x0
	// 1/2 full FIFO
	DMA_ST_FCR_FTH_Half = 0x1
	// 3/4 full FIFO
	DMA_ST_FCR_FTH_ThreeQuarters = 0x2
	// Full FIFO
	DMA_ST_FCR_FTH_Full = 0x3
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: clock control register
	// Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Pos = 0x1b
	// Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000
	// Bit PLLI2SRDY.
	RCC_CR_PLLI2SRDY = 0x8000000
	// Clock not ready
	RCC_CR_PLLI2SRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLI2SRDY_Ready = 0x1
	// Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Pos = 0x1a
	// Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk = 0x4000000
	// Bit PLLI2SON.
	RCC_CR_PLLI2SON = 0x4000000
	// Clock Off
	RCC_CR_PLLI2SON_Off = 0x0
	// Clock On
	RCC_CR_PLLI2SON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of PLLSAIRDY field.
	RCC_CR_PLLSAIRDY_Pos = 0x1d
	// Bit mask of PLLSAIRDY field.
	RCC_CR_PLLSAIRDY_Msk = 0x20000000
	// Bit PLLSAIRDY.
	RCC_CR_PLLSAIRDY = 0x20000000
	// Clock not ready
	RCC_CR_PLLSAIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLSAIRDY_Ready = 0x1
	// Position of PLLSAION field.
	RCC_CR_PLLSAION_Pos = 0x1c
	// Bit mask of PLLSAION field.
	RCC_CR_PLLSAION_Msk = 0x10000000
	// Bit PLLSAION.
	RCC_CR_PLLSAION = 0x10000000
	// Clock Off
	RCC_CR_PLLSAION_Off = 0x0
	// Clock On
	RCC_CR_PLLSAION_On = 0x1

	// PLLCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000
	// Bit PLLSRC.
	RCC_PLLCFGR_PLLSRC = 0x400000
	// HSI clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSI = 0x0
	// HSE oscillator clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSE = 0x1
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x1c
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0x70000000
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x0
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x3f
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x6
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7fc0
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x10
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x30000
	// PLLP=2
	RCC_PLLCFGR_PLLP_Div2 = 0x0
	// PLLP=4
	RCC_PLLCFGR_PLLP_Div4 = 0x1
	// PLLP=6
	RCC_PLLCFGR_PLLP_Div6 = 0x2
	// PLLP=8
	RCC_PLLCFGR_PLLP_Div8 = 0x3
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x18
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xf000000

	// CFGR: clock configuration register
	// Position of MCO2 field.
	RCC_CFGR_MCO2_Pos = 0x1e
	// Bit mask of MCO2 field.
	RCC_CFGR_MCO2_Msk = 0xc0000000
	// System clock (SYSCLK) selected
	RCC_CFGR_MCO2_SYSCLK = 0x0
	// PLLI2S clock selected
	RCC_CFGR_MCO2_PLLI2S = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO2_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO2_PLL = 0x3
	// Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b
	// Bit mask of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000
	// No division
	RCC_CFGR_MCO2PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO2PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO2PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO2PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO2PRE_Div5 = 0x7
	// Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18
	// Bit mask of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000
	// No division
	RCC_CFGR_MCO1PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO1PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO1PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO1PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO1PRE_Div5 = 0x7
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// PLLI2S clock used as I2S clock source
	RCC_CFGR_I2SSRC_PLLI2S = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCO1 field.
	RCC_CFGR_MCO1_Pos = 0x15
	// Bit mask of MCO1 field.
	RCC_CFGR_MCO1_Msk = 0x600000
	// HSI clock selected
	RCC_CFGR_MCO1_HSI = 0x0
	// LSE oscillator selected
	RCC_CFGR_MCO1_LSE = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO1_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO1_PLL = 0x3
	// Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Pos = 0x10
	// Bit mask of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk = 0x1f0000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xd
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0xe000
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0xa
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x1c00
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2

	// CIR: clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1
	// Position of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Pos = 0x16
	// Bit mask of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Msk = 0x400000
	// Bit PLLSAIRDYC.
	RCC_CIR_PLLSAIRDYC = 0x400000
	// Clear interrupt flag
	RCC_CIR_PLLSAIRDYC_Clear = 0x1
	// Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Pos = 0x15
	// Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk = 0x200000
	// Bit PLLI2SRDYC.
	RCC_CIR_PLLI2SRDYC = 0x200000
	// Clear interrupt flag
	RCC_CIR_PLLI2SRDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Pos = 0xe
	// Bit mask of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Msk = 0x4000
	// Bit PLLSAIRDYIE.
	RCC_CIR_PLLSAIRDYIE = 0x4000
	// Interrupt disabled
	RCC_CIR_PLLSAIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLSAIRDYIE_Enabled = 0x1
	// Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd
	// Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000
	// Bit PLLI2SRDYIE.
	RCC_CIR_PLLI2SRDYIE = 0x2000
	// Interrupt disabled
	RCC_CIR_PLLI2SRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLI2SRDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Pos = 0x6
	// Bit mask of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Msk = 0x40
	// Bit PLLSAIRDYF.
	RCC_CIR_PLLSAIRDYF = 0x40
	// No clock ready interrupt
	RCC_CIR_PLLSAIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLSAIRDYF_Interrupted = 0x1
	// Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Pos = 0x5
	// Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk = 0x20
	// Bit PLLI2SRDYF.
	RCC_CIR_PLLI2SRDYF = 0x20
	// No clock ready interrupt
	RCC_CIR_PLLI2SRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLI2SRDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Pos = 0x1d
	// Bit mask of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Msk = 0x20000000
	// Bit OTGHSRST.
	RCC_AHB1RSTR_OTGHSRST = 0x20000000
	// Reset the selected module
	RCC_AHB1RSTR_OTGHSRST_Reset = 0x1
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x16
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x400000
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x400000
	// Reset the selected module
	RCC_AHB1RSTR_DMA2RST_Reset = 0x1
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x15
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x200000
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x200000
	// Reset the selected module
	RCC_AHB1RSTR_DMA1RST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Reset the selected module
	RCC_AHB1RSTR_CRCRST_Reset = 0x1
	// Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOHRST = 0x80
	// Reset the selected module
	RCC_AHB1RSTR_GPIOHRST_Reset = 0x1
	// Position of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Pos = 0x6
	// Bit mask of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Msk = 0x40
	// Bit GPIOGRST.
	RCC_AHB1RSTR_GPIOGRST = 0x40
	// Reset the selected module
	RCC_AHB1RSTR_GPIOGRST_Reset = 0x1
	// Position of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Pos = 0x5
	// Bit mask of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Msk = 0x20
	// Bit GPIOFRST.
	RCC_AHB1RSTR_GPIOFRST = 0x20
	// Reset the selected module
	RCC_AHB1RSTR_GPIOFRST_Reset = 0x1
	// Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB1RSTR_GPIOERST = 0x10
	// Reset the selected module
	RCC_AHB1RSTR_GPIOERST_Reset = 0x1
	// Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB1RSTR_GPIODRST = 0x8
	// Reset the selected module
	RCC_AHB1RSTR_GPIODRST_Reset = 0x1
	// Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOCRST = 0x4
	// Reset the selected module
	RCC_AHB1RSTR_GPIOCRST_Reset = 0x1
	// Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOBRST = 0x2
	// Reset the selected module
	RCC_AHB1RSTR_GPIOBRST_Reset = 0x1
	// Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB1RSTR_GPIOARST = 0x1
	// Reset the selected module
	RCC_AHB1RSTR_GPIOARST_Reset = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7
	// Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80
	// Bit OTGFSRST.
	RCC_AHB2RSTR_OTGFSRST = 0x80
	// Reset the selected module
	RCC_AHB2RSTR_OTGFSRST_Reset = 0x1
	// Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Pos = 0x0
	// Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk = 0x1
	// Bit DCMIRST.
	RCC_AHB2RSTR_DCMIRST = 0x1
	// Reset the selected module
	RCC_AHB2RSTR_DCMIRST_Reset = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Pos = 0x0
	// Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk = 0x1
	// Bit FMCRST.
	RCC_AHB3RSTR_FMCRST = 0x1
	// Reset the selected module
	RCC_AHB3RSTR_FMCRST_Reset = 0x1
	// Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x1
	// Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x2
	// Bit QSPIRST.
	RCC_AHB3RSTR_QSPIRST = 0x2
	// Reset the selected module
	RCC_AHB3RSTR_QSPIRST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR_TIM5RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Reset the selected module
	RCC_APB1RSTR_TIM7RST_Reset = 0x1
	// Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Pos = 0x6
	// Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk = 0x40
	// Bit TIM12RST.
	RCC_APB1RSTR_TIM12RST = 0x40
	// Reset the selected module
	RCC_APB1RSTR_TIM12RST_Reset = 0x1
	// Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Pos = 0x7
	// Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk = 0x80
	// Bit TIM13RST.
	RCC_APB1RSTR_TIM13RST = 0x80
	// Reset the selected module
	RCC_APB1RSTR_TIM13RST_Reset = 0x1
	// Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Pos = 0x8
	// Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk = 0x100
	// Bit TIM14RST.
	RCC_APB1RSTR_TIM14RST = 0x100
	// Reset the selected module
	RCC_APB1RSTR_TIM14RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of SPDIFRST field.
	RCC_APB1RSTR_SPDIFRST_Pos = 0x10
	// Bit mask of SPDIFRST field.
	RCC_APB1RSTR_SPDIFRST_Msk = 0x10000
	// Bit SPDIFRST.
	RCC_APB1RSTR_SPDIFRST = 0x10000
	// Reset the selected module
	RCC_APB1RSTR_SPDIFRST_Reset = 0x1
	// Position of UART2RST field.
	RCC_APB1RSTR_UART2RST_Pos = 0x11
	// Bit mask of UART2RST field.
	RCC_APB1RSTR_UART2RST_Msk = 0x20000
	// Bit UART2RST.
	RCC_APB1RSTR_UART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_UART2RST_Reset = 0x1
	// Position of UART3RST field.
	RCC_APB1RSTR_UART3RST_Pos = 0x12
	// Bit mask of UART3RST field.
	RCC_APB1RSTR_UART3RST_Msk = 0x40000
	// Bit UART3RST.
	RCC_APB1RSTR_UART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_UART3RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR_UART4RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR_UART5RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1
	// Position of FMPI2C1RST field.
	RCC_APB1RSTR_FMPI2C1RST_Pos = 0x18
	// Bit mask of FMPI2C1RST field.
	RCC_APB1RSTR_FMPI2C1RST_Msk = 0x1000000
	// Bit FMPI2C1RST.
	RCC_APB1RSTR_FMPI2C1RST = 0x1000000
	// Reset the selected module
	RCC_APB1RSTR_FMPI2C1RST_Reset = 0x1
	// Position of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Pos = 0x19
	// Bit mask of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Msk = 0x2000000
	// Bit CAN1RST.
	RCC_APB1RSTR_CAN1RST = 0x2000000
	// Reset the selected module
	RCC_APB1RSTR_CAN1RST_Reset = 0x1
	// Position of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Pos = 0x1a
	// Bit mask of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Msk = 0x4000000
	// Bit CAN2RST.
	RCC_APB1RSTR_CAN2RST = 0x4000000
	// Reset the selected module
	RCC_APB1RSTR_CAN2RST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DACRST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0x0
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x1
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Pos = 0x1
	// Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk = 0x2
	// Bit TIM8RST.
	RCC_APB2RSTR_TIM8RST = 0x2
	// Reset the selected module
	RCC_APB2RSTR_TIM8RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0x4
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x10
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Pos = 0x5
	// Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20
	// Bit USART6RST.
	RCC_APB2RSTR_USART6RST = 0x20
	// Reset the selected module
	RCC_APB2RSTR_USART6RST_Reset = 0x1
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x8
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x100
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x100
	// Reset the selected module
	RCC_APB2RSTR_ADCRST_Reset = 0x1
	// Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Pos = 0xb
	// Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk = 0x800
	// Bit SDIORST.
	RCC_APB2RSTR_SDIORST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_SDIORST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Pos = 0xd
	// Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk = 0x2000
	// Bit SPI4RST.
	RCC_APB2RSTR_SPI4RST = 0x2000
	// Reset the selected module
	RCC_APB2RSTR_SPI4RST_Reset = 0x1
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Pos = 0x10
	// Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk = 0x10000
	// Bit TIM9RST.
	RCC_APB2RSTR_TIM9RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM9RST_Reset = 0x1
	// Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Pos = 0x11
	// Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk = 0x20000
	// Bit TIM10RST.
	RCC_APB2RSTR_TIM10RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM10RST_Reset = 0x1
	// Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Pos = 0x12
	// Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk = 0x40000
	// Bit TIM11RST.
	RCC_APB2RSTR_TIM11RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM11RST_Reset = 0x1
	// Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Pos = 0x16
	// Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk = 0x400000
	// Bit SAI1RST.
	RCC_APB2RSTR_SAI1RST = 0x400000
	// Reset the selected module
	RCC_APB2RSTR_SAI1RST_Reset = 0x1
	// Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Pos = 0x17
	// Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk = 0x800000
	// Bit SAI2RST.
	RCC_APB2RSTR_SAI2RST = 0x800000
	// Reset the selected module
	RCC_APB2RSTR_SAI2RST_Reset = 0x1

	// AHB1ENR: AHB1 peripheral clock register
	// Position of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Pos = 0x1e
	// Bit mask of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Msk = 0x40000000
	// Bit OTGHSULPIEN.
	RCC_AHB1ENR_OTGHSULPIEN = 0x40000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSULPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSULPIEN_Enabled = 0x1
	// Position of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Pos = 0x1d
	// Bit mask of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Msk = 0x20000000
	// Bit OTGHSEN.
	RCC_AHB1ENR_OTGHSEN = 0x20000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSEN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x16
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x400000
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x400000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2EN_Enabled = 0x1
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x15
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x200000
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x200000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA1EN_Enabled = 0x1
	// Position of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Pos = 0x12
	// Bit mask of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Msk = 0x40000
	// Bit BKPSRAMEN.
	RCC_AHB1ENR_BKPSRAMEN = 0x40000
	// The selected clock is disabled
	RCC_AHB1ENR_BKPSRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_BKPSRAMEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// The selected clock is disabled
	RCC_AHB1ENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CRCEN_Enabled = 0x1
	// Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB1ENR_GPIOHEN = 0x80
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOHEN_Enabled = 0x1
	// Position of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Pos = 0x6
	// Bit mask of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Msk = 0x40
	// Bit GPIOGEN.
	RCC_AHB1ENR_GPIOGEN = 0x40
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOGEN_Enabled = 0x1
	// Position of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Pos = 0x5
	// Bit mask of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Msk = 0x20
	// Bit GPIOFEN.
	RCC_AHB1ENR_GPIOFEN = 0x20
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOFEN_Enabled = 0x1
	// Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB1ENR_GPIOEEN = 0x10
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOEEN_Enabled = 0x1
	// Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB1ENR_GPIODEN = 0x8
	// The selected clock is disabled
	RCC_AHB1ENR_GPIODEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIODEN_Enabled = 0x1
	// Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB1ENR_GPIOCEN = 0x4
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOCEN_Enabled = 0x1
	// Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB1ENR_GPIOBEN = 0x2
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOBEN_Enabled = 0x1
	// Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB1ENR_GPIOAEN = 0x1
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOAEN_Enabled = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7
	// Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80
	// Bit OTGFSEN.
	RCC_AHB2ENR_OTGFSEN = 0x80
	// The selected clock is disabled
	RCC_AHB2ENR_OTGFSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_OTGFSEN_Enabled = 0x1
	// Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Pos = 0x0
	// Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk = 0x1
	// Bit DCMIEN.
	RCC_AHB2ENR_DCMIEN = 0x1
	// The selected clock is disabled
	RCC_AHB2ENR_DCMIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DCMIEN_Enabled = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Pos = 0x0
	// Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk = 0x1
	// Bit FMCEN.
	RCC_AHB3ENR_FMCEN = 0x1
	// The selected clock is disabled
	RCC_AHB3ENR_FMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_FMCEN_Enabled = 0x1
	// Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Pos = 0x1
	// Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x2
	// Bit QSPIEN.
	RCC_AHB3ENR_QSPIEN = 0x2
	// The selected clock is disabled
	RCC_AHB3ENR_QSPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_QSPIEN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM5EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// The selected clock is disabled
	RCC_APB1ENR_TIM7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM7EN_Enabled = 0x1
	// Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Pos = 0x6
	// Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk = 0x40
	// Bit TIM12EN.
	RCC_APB1ENR_TIM12EN = 0x40
	// The selected clock is disabled
	RCC_APB1ENR_TIM12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM12EN_Enabled = 0x1
	// Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Pos = 0x7
	// Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk = 0x80
	// Bit TIM13EN.
	RCC_APB1ENR_TIM13EN = 0x80
	// The selected clock is disabled
	RCC_APB1ENR_TIM13EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM13EN_Enabled = 0x1
	// Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Pos = 0x8
	// Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk = 0x100
	// Bit TIM14EN.
	RCC_APB1ENR_TIM14EN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR_TIM14EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM14EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of SPDIFEN field.
	RCC_APB1ENR_SPDIFEN_Pos = 0x10
	// Bit mask of SPDIFEN field.
	RCC_APB1ENR_SPDIFEN_Msk = 0x10000
	// Bit SPDIFEN.
	RCC_APB1ENR_SPDIFEN = 0x10000
	// The selected clock is disabled
	RCC_APB1ENR_SPDIFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPDIFEN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART4EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART5EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1
	// Position of FMPI2C1EN field.
	RCC_APB1ENR_FMPI2C1EN_Pos = 0x18
	// Bit mask of FMPI2C1EN field.
	RCC_APB1ENR_FMPI2C1EN_Msk = 0x1000000
	// Bit FMPI2C1EN.
	RCC_APB1ENR_FMPI2C1EN = 0x1000000
	// The selected clock is disabled
	RCC_APB1ENR_FMPI2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_FMPI2C1EN_Enabled = 0x1
	// Position of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Pos = 0x19
	// Bit mask of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Msk = 0x2000000
	// Bit CAN1EN.
	RCC_APB1ENR_CAN1EN = 0x2000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN1EN_Enabled = 0x1
	// Position of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Pos = 0x1a
	// Bit mask of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Msk = 0x4000000
	// Bit CAN2EN.
	RCC_APB1ENR_CAN2EN = 0x4000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN2EN_Enabled = 0x1
	// Position of CECEN field.
	RCC_APB1ENR_CECEN_Pos = 0x1b
	// Bit mask of CECEN field.
	RCC_APB1ENR_CECEN_Msk = 0x8000000
	// Bit CECEN.
	RCC_APB1ENR_CECEN = 0x8000000
	// The selected clock is disabled
	RCC_APB1ENR_CECEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CECEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DACEN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0x0
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x1
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Pos = 0x1
	// Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk = 0x2
	// Bit TIM8EN.
	RCC_APB2ENR_TIM8EN = 0x2
	// The selected clock is disabled
	RCC_APB2ENR_TIM8EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM8EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0x4
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x10
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Pos = 0x5
	// Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20
	// Bit USART6EN.
	RCC_APB2ENR_USART6EN = 0x20
	// The selected clock is disabled
	RCC_APB2ENR_USART6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART6EN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x8
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x100
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x100
	// The selected clock is disabled
	RCC_APB2ENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC1EN_Enabled = 0x1
	// Position of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Pos = 0x9
	// Bit mask of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Msk = 0x200
	// Bit ADC2EN.
	RCC_APB2ENR_ADC2EN = 0x200
	// The selected clock is disabled
	RCC_APB2ENR_ADC2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC2EN_Enabled = 0x1
	// Position of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Pos = 0xa
	// Bit mask of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Msk = 0x400
	// Bit ADC3EN.
	RCC_APB2ENR_ADC3EN = 0x400
	// The selected clock is disabled
	RCC_APB2ENR_ADC3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC3EN_Enabled = 0x1
	// Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	RCC_APB2ENR_SDIOEN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_SDIOEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SDIOEN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Pos = 0xd
	// Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk = 0x2000
	// Bit SPI4EN.
	RCC_APB2ENR_SPI4EN = 0x2000
	// The selected clock is disabled
	RCC_APB2ENR_SPI4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI4EN_Enabled = 0x1
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Pos = 0x10
	// Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk = 0x10000
	// Bit TIM9EN.
	RCC_APB2ENR_TIM9EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM9EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM9EN_Enabled = 0x1
	// Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Pos = 0x11
	// Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk = 0x20000
	// Bit TIM10EN.
	RCC_APB2ENR_TIM10EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM10EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM10EN_Enabled = 0x1
	// Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Pos = 0x12
	// Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk = 0x40000
	// Bit TIM11EN.
	RCC_APB2ENR_TIM11EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM11EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM11EN_Enabled = 0x1
	// Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Pos = 0x16
	// Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk = 0x400000
	// Bit SAI1EN.
	RCC_APB2ENR_SAI1EN = 0x400000
	// The selected clock is disabled
	RCC_APB2ENR_SAI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SAI1EN_Enabled = 0x1
	// Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Pos = 0x17
	// Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk = 0x800000
	// Bit SAI2EN.
	RCC_APB2ENR_SAI2EN = 0x800000
	// The selected clock is disabled
	RCC_APB2ENR_SAI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SAI2EN_Enabled = 0x1

	// AHB1LPENR: AHB1 peripheral clock enable in low power mode register
	// Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Pos = 0x0
	// Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk = 0x1
	// Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOALPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_EnabledInSleep = 0x1
	// Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Pos = 0x1
	// Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk = 0x2
	// Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOBLPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_EnabledInSleep = 0x1
	// Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Pos = 0x2
	// Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk = 0x4
	// Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIOCLPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_EnabledInSleep = 0x1
	// Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Pos = 0x3
	// Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk = 0x8
	// Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIODLPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_EnabledInSleep = 0x1
	// Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Pos = 0x4
	// Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk = 0x10
	// Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOELPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_EnabledInSleep = 0x1
	// Position of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Pos = 0x5
	// Bit mask of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Msk = 0x20
	// Bit GPIOFLPEN.
	RCC_AHB1LPENR_GPIOFLPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_EnabledInSleep = 0x1
	// Position of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Pos = 0x6
	// Bit mask of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Msk = 0x40
	// Bit GPIOGLPEN.
	RCC_AHB1LPENR_GPIOGLPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_EnabledInSleep = 0x1
	// Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Pos = 0x7
	// Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk = 0x80
	// Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOHLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_EnabledInSleep = 0x1
	// Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Pos = 0xc
	// Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk = 0x1000
	// Bit CRCLPEN.
	RCC_AHB1LPENR_CRCLPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_EnabledInSleep = 0x1
	// Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Pos = 0xf
	// Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk = 0x8000
	// Bit FLITFLPEN.
	RCC_AHB1LPENR_FLITFLPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_EnabledInSleep = 0x1
	// Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Pos = 0x10
	// Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk = 0x10000
	// Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM1LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_EnabledInSleep = 0x1
	// Position of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Pos = 0x11
	// Bit mask of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Msk = 0x20000
	// Bit SRAM2LPEN.
	RCC_AHB1LPENR_SRAM2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_EnabledInSleep = 0x1
	// Position of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Pos = 0x12
	// Bit mask of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Msk = 0x40000
	// Bit BKPSRAMLPEN.
	RCC_AHB1LPENR_BKPSRAMLPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_EnabledInSleep = 0x1
	// Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Pos = 0x15
	// Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk = 0x200000
	// Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_EnabledInSleep = 0x1
	// Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Pos = 0x16
	// Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk = 0x400000
	// Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_EnabledInSleep = 0x1
	// Position of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Pos = 0x1d
	// Bit mask of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Msk = 0x20000000
	// Bit OTGHSLPEN.
	RCC_AHB1LPENR_OTGHSLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_EnabledInSleep = 0x1
	// Position of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Pos = 0x1e
	// Bit mask of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Msk = 0x40000000
	// Bit OTGHSULPILPEN.
	RCC_AHB1LPENR_OTGHSULPILPEN = 0x40000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_EnabledInSleep = 0x1

	// AHB2LPENR: AHB2 peripheral clock enable in low power mode register
	// Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7
	// Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80
	// Bit OTGFSLPEN.
	RCC_AHB2LPENR_OTGFSLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_EnabledInSleep = 0x1
	// Position of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Pos = 0x0
	// Bit mask of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Msk = 0x1
	// Bit DCMILPEN.
	RCC_AHB2LPENR_DCMILPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_EnabledInSleep = 0x1

	// AHB3LPENR: AHB3 peripheral clock enable in low power mode register
	// Position of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Pos = 0x0
	// Bit mask of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Msk = 0x1
	// Bit FMCLPEN.
	RCC_AHB3LPENR_FMCLPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB3LPENR_FMCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB3LPENR_FMCLPEN_EnabledInSleep = 0x1
	// Position of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Pos = 0x1
	// Bit mask of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Msk = 0x2
	// Bit QSPILPEN.
	RCC_AHB3LPENR_QSPILPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB3LPENR_QSPILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB3LPENR_QSPILPEN_EnabledInSleep = 0x1

	// APB1LPENR: APB1 peripheral clock enable in low power mode register
	// Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Pos = 0x0
	// Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk = 0x1
	// Bit TIM2LPEN.
	RCC_APB1LPENR_TIM2LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_EnabledInSleep = 0x1
	// Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Pos = 0x1
	// Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk = 0x2
	// Bit TIM3LPEN.
	RCC_APB1LPENR_TIM3LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_EnabledInSleep = 0x1
	// Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Pos = 0x2
	// Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk = 0x4
	// Bit TIM4LPEN.
	RCC_APB1LPENR_TIM4LPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_EnabledInSleep = 0x1
	// Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Pos = 0x3
	// Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk = 0x8
	// Bit TIM5LPEN.
	RCC_APB1LPENR_TIM5LPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_EnabledInSleep = 0x1
	// Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Pos = 0x4
	// Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk = 0x10
	// Bit TIM6LPEN.
	RCC_APB1LPENR_TIM6LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_EnabledInSleep = 0x1
	// Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Pos = 0x5
	// Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk = 0x20
	// Bit TIM7LPEN.
	RCC_APB1LPENR_TIM7LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_EnabledInSleep = 0x1
	// Position of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Pos = 0x6
	// Bit mask of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Msk = 0x40
	// Bit TIM12LPEN.
	RCC_APB1LPENR_TIM12LPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_EnabledInSleep = 0x1
	// Position of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Pos = 0x7
	// Bit mask of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Msk = 0x80
	// Bit TIM13LPEN.
	RCC_APB1LPENR_TIM13LPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_EnabledInSleep = 0x1
	// Position of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Pos = 0x8
	// Bit mask of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Msk = 0x100
	// Bit TIM14LPEN.
	RCC_APB1LPENR_TIM14LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_EnabledInSleep = 0x1
	// Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Pos = 0xb
	// Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk = 0x800
	// Bit WWDGLPEN.
	RCC_APB1LPENR_WWDGLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_EnabledInSleep = 0x1
	// Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Pos = 0xe
	// Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk = 0x4000
	// Bit SPI2LPEN.
	RCC_APB1LPENR_SPI2LPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_EnabledInSleep = 0x1
	// Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Pos = 0xf
	// Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk = 0x8000
	// Bit SPI3LPEN.
	RCC_APB1LPENR_SPI3LPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_EnabledInSleep = 0x1
	// Position of SPDIFLPEN field.
	RCC_APB1LPENR_SPDIFLPEN_Pos = 0x10
	// Bit mask of SPDIFLPEN field.
	RCC_APB1LPENR_SPDIFLPEN_Msk = 0x10000
	// Bit SPDIFLPEN.
	RCC_APB1LPENR_SPDIFLPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPDIFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPDIFLPEN_EnabledInSleep = 0x1
	// Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11
	// Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000
	// Bit USART2LPEN.
	RCC_APB1LPENR_USART2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_EnabledInSleep = 0x1
	// Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Pos = 0x12
	// Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk = 0x40000
	// Bit USART3LPEN.
	RCC_APB1LPENR_USART3LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_EnabledInSleep = 0x1
	// Position of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Pos = 0x13
	// Bit mask of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Msk = 0x80000
	// Bit UART4LPEN.
	RCC_APB1LPENR_UART4LPEN = 0x80000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_EnabledInSleep = 0x1
	// Position of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Pos = 0x14
	// Bit mask of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Msk = 0x100000
	// Bit UART5LPEN.
	RCC_APB1LPENR_UART5LPEN = 0x100000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_EnabledInSleep = 0x1
	// Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Pos = 0x15
	// Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk = 0x200000
	// Bit I2C1LPEN.
	RCC_APB1LPENR_I2C1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_EnabledInSleep = 0x1
	// Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Pos = 0x16
	// Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk = 0x400000
	// Bit I2C2LPEN.
	RCC_APB1LPENR_I2C2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_EnabledInSleep = 0x1
	// Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Pos = 0x17
	// Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk = 0x800000
	// Bit I2C3LPEN.
	RCC_APB1LPENR_I2C3LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_EnabledInSleep = 0x1
	// Position of FMPI2C1LPEN field.
	RCC_APB1LPENR_FMPI2C1LPEN_Pos = 0x18
	// Bit mask of FMPI2C1LPEN field.
	RCC_APB1LPENR_FMPI2C1LPEN_Msk = 0x1000000
	// Bit FMPI2C1LPEN.
	RCC_APB1LPENR_FMPI2C1LPEN = 0x1000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_FMPI2C1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_FMPI2C1LPEN_EnabledInSleep = 0x1
	// Position of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Pos = 0x19
	// Bit mask of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Msk = 0x2000000
	// Bit CAN1LPEN.
	RCC_APB1LPENR_CAN1LPEN = 0x2000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_EnabledInSleep = 0x1
	// Position of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Pos = 0x1a
	// Bit mask of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Msk = 0x4000000
	// Bit CAN2LPEN.
	RCC_APB1LPENR_CAN2LPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_EnabledInSleep = 0x1
	// Position of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Pos = 0x1b
	// Bit mask of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Msk = 0x8000000
	// Bit CECLPEN.
	RCC_APB1LPENR_CECLPEN = 0x8000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CECLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CECLPEN_EnabledInSleep = 0x1
	// Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Pos = 0x1c
	// Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk = 0x10000000
	// Bit PWRLPEN.
	RCC_APB1LPENR_PWRLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_EnabledInSleep = 0x1
	// Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Pos = 0x1d
	// Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk = 0x20000000
	// Bit DACLPEN.
	RCC_APB1LPENR_DACLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_EnabledInSleep = 0x1

	// APB2LPENR: APB2 peripheral clock enabled in low power mode register
	// Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Pos = 0x0
	// Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk = 0x1
	// Bit TIM1LPEN.
	RCC_APB2LPENR_TIM1LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_EnabledInSleep = 0x1
	// Position of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Pos = 0x1
	// Bit mask of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Msk = 0x2
	// Bit TIM8LPEN.
	RCC_APB2LPENR_TIM8LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_EnabledInSleep = 0x1
	// Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4
	// Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10
	// Bit USART1LPEN.
	RCC_APB2LPENR_USART1LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_EnabledInSleep = 0x1
	// Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5
	// Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20
	// Bit USART6LPEN.
	RCC_APB2LPENR_USART6LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_EnabledInSleep = 0x1
	// Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Pos = 0x8
	// Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk = 0x100
	// Bit ADC1LPEN.
	RCC_APB2LPENR_ADC1LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_EnabledInSleep = 0x1
	// Position of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Pos = 0x9
	// Bit mask of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Msk = 0x200
	// Bit ADC2LPEN.
	RCC_APB2LPENR_ADC2LPEN = 0x200
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_EnabledInSleep = 0x1
	// Position of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Pos = 0xa
	// Bit mask of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Msk = 0x400
	// Bit ADC3LPEN.
	RCC_APB2LPENR_ADC3LPEN = 0x400
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_EnabledInSleep = 0x1
	// Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Pos = 0xb
	// Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk = 0x800
	// Bit SDIOLPEN.
	RCC_APB2LPENR_SDIOLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_EnabledInSleep = 0x1
	// Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Pos = 0xc
	// Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk = 0x1000
	// Bit SPI1LPEN.
	RCC_APB2LPENR_SPI1LPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_EnabledInSleep = 0x1
	// Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Pos = 0xd
	// Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk = 0x2000
	// Bit SPI4LPEN.
	RCC_APB2LPENR_SPI4LPEN = 0x2000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_EnabledInSleep = 0x1
	// Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe
	// Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000
	// Bit SYSCFGLPEN.
	RCC_APB2LPENR_SYSCFGLPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_EnabledInSleep = 0x1
	// Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Pos = 0x10
	// Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk = 0x10000
	// Bit TIM9LPEN.
	RCC_APB2LPENR_TIM9LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_EnabledInSleep = 0x1
	// Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Pos = 0x11
	// Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk = 0x20000
	// Bit TIM10LPEN.
	RCC_APB2LPENR_TIM10LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_EnabledInSleep = 0x1
	// Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Pos = 0x12
	// Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk = 0x40000
	// Bit TIM11LPEN.
	RCC_APB2LPENR_TIM11LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_EnabledInSleep = 0x1
	// Position of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Pos = 0x16
	// Bit mask of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Msk = 0x400000
	// Bit SAI1LPEN.
	RCC_APB2LPENR_SAI1LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SAI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SAI1LPEN_EnabledInSleep = 0x1
	// Position of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Pos = 0x17
	// Bit mask of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Msk = 0x800000
	// Bit SAI2LPEN.
	RCC_APB2LPENR_SAI2LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SAI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SAI2LPEN_EnabledInSleep = 0x1

	// BDCR: Backup domain control register
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3
	// Position of LSEMOD field.
	RCC_BDCR_LSEMOD_Pos = 0x3
	// Bit mask of LSEMOD field.
	RCC_BDCR_LSEMOD_Msk = 0x8
	// Bit LSEMOD.
	RCC_BDCR_LSEMOD = 0x8
	// LSE oscillator low power mode selection
	RCC_BDCR_LSEMOD_Low = 0x0
	// LSE oscillator high drive mode selection
	RCC_BDCR_LSEMOD_High = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1

	// CSR: clock control & status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Pos = 0x1d
	// Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk = 0x20000000
	// Bit WDGRSTF.
	RCC_CSR_WDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_WDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of PADRSTF field.
	RCC_CSR_PADRSTF_Pos = 0x1a
	// Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF_Msk = 0x4000000
	// Bit PADRSTF.
	RCC_CSR_PADRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PADRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PADRSTF_Reset = 0x1
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x19
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x2000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_BORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_BORRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1

	// SSCGR: spread spectrum clock generation register
	// Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Pos = 0x1f
	// Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk = 0x80000000
	// Bit SSCGEN.
	RCC_SSCGR_SSCGEN = 0x80000000
	// Spread spectrum modulation disabled
	RCC_SSCGR_SSCGEN_Disabled = 0x0
	// Spread spectrum modulation enabled
	RCC_SSCGR_SSCGEN_Enabled = 0x1
	// Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e
	// Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000
	// Bit SPREADSEL.
	RCC_SSCGR_SPREADSEL = 0x40000000
	// Center spread
	RCC_SSCGR_SPREADSEL_Center = 0x0
	// Down spread
	RCC_SSCGR_SPREADSEL_Down = 0x1
	// Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Pos = 0xd
	// Bit mask of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk = 0xfffe000
	// Position of MODPER field.
	RCC_SSCGR_MODPER_Pos = 0x0
	// Bit mask of MODPER field.
	RCC_SSCGR_MODPER_Msk = 0x1fff

	// PLLI2SCFGR: PLLI2S configuration register
	// Position of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SM_Pos = 0x0
	// Bit mask of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SM_Msk = 0x3f
	// Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6
	// Bit mask of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0
	// Position of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SP_Pos = 0x10
	// Bit mask of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SP_Msk = 0x30000
	// PLL*P=2
	RCC_PLLI2SCFGR_PLLI2SP_Div2 = 0x0
	// PLL*P=4
	RCC_PLLI2SCFGR_PLLI2SP_Div4 = 0x1
	// PLL*P=6
	RCC_PLLI2SCFGR_PLLI2SP_Div6 = 0x2
	// PLL*P=8
	RCC_PLLI2SCFGR_PLLI2SP_Div8 = 0x3
	// Position of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Pos = 0x18
	// Bit mask of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Msk = 0xf000000
	// Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c
	// Bit mask of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000

	// PLLSAICFGR: PLL configuration register
	// Position of PLLSAIM field.
	RCC_PLLSAICFGR_PLLSAIM_Pos = 0x0
	// Bit mask of PLLSAIM field.
	RCC_PLLSAICFGR_PLLSAIM_Msk = 0x3f
	// Position of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Pos = 0x6
	// Bit mask of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Msk = 0x7fc0
	// Position of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Pos = 0x10
	// Bit mask of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Msk = 0x30000
	// PLL*P=2
	RCC_PLLSAICFGR_PLLSAIP_Div2 = 0x0
	// PLL*P=4
	RCC_PLLSAICFGR_PLLSAIP_Div4 = 0x1
	// PLL*P=6
	RCC_PLLSAICFGR_PLLSAIP_Div6 = 0x2
	// PLL*P=8
	RCC_PLLSAICFGR_PLLSAIP_Div8 = 0x3
	// Position of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Pos = 0x18
	// Bit mask of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Msk = 0xf000000

	// DCKCFGR: Dedicated Clock Configuration Register
	// Position of PLLI2SDIVQ field.
	RCC_DCKCFGR_PLLI2SDIVQ_Pos = 0x0
	// Bit mask of PLLI2SDIVQ field.
	RCC_DCKCFGR_PLLI2SDIVQ_Msk = 0x1f
	// PLLI2SDIVQ = /1
	RCC_DCKCFGR_PLLI2SDIVQ_Div1 = 0x0
	// PLLI2SDIVQ = /2
	RCC_DCKCFGR_PLLI2SDIVQ_Div2 = 0x1
	// PLLI2SDIVQ = /3
	RCC_DCKCFGR_PLLI2SDIVQ_Div3 = 0x2
	// PLLI2SDIVQ = /4
	RCC_DCKCFGR_PLLI2SDIVQ_Div4 = 0x3
	// PLLI2SDIVQ = /5
	RCC_DCKCFGR_PLLI2SDIVQ_Div5 = 0x4
	// PLLI2SDIVQ = /6
	RCC_DCKCFGR_PLLI2SDIVQ_Div6 = 0x5
	// PLLI2SDIVQ = /7
	RCC_DCKCFGR_PLLI2SDIVQ_Div7 = 0x6
	// PLLI2SDIVQ = /8
	RCC_DCKCFGR_PLLI2SDIVQ_Div8 = 0x7
	// PLLI2SDIVQ = /9
	RCC_DCKCFGR_PLLI2SDIVQ_Div9 = 0x8
	// PLLI2SDIVQ = /10
	RCC_DCKCFGR_PLLI2SDIVQ_Div10 = 0x9
	// PLLI2SDIVQ = /11
	RCC_DCKCFGR_PLLI2SDIVQ_Div11 = 0xa
	// PLLI2SDIVQ = /12
	RCC_DCKCFGR_PLLI2SDIVQ_Div12 = 0xb
	// PLLI2SDIVQ = /13
	RCC_DCKCFGR_PLLI2SDIVQ_Div13 = 0xc
	// PLLI2SDIVQ = /14
	RCC_DCKCFGR_PLLI2SDIVQ_Div14 = 0xd
	// PLLI2SDIVQ = /15
	RCC_DCKCFGR_PLLI2SDIVQ_Div15 = 0xe
	// PLLI2SDIVQ = /16
	RCC_DCKCFGR_PLLI2SDIVQ_Div16 = 0xf
	// PLLI2SDIVQ = /17
	RCC_DCKCFGR_PLLI2SDIVQ_Div17 = 0x10
	// PLLI2SDIVQ = /18
	RCC_DCKCFGR_PLLI2SDIVQ_Div18 = 0x11
	// PLLI2SDIVQ = /19
	RCC_DCKCFGR_PLLI2SDIVQ_Div19 = 0x12
	// PLLI2SDIVQ = /20
	RCC_DCKCFGR_PLLI2SDIVQ_Div20 = 0x13
	// PLLI2SDIVQ = /21
	RCC_DCKCFGR_PLLI2SDIVQ_Div21 = 0x14
	// PLLI2SDIVQ = /22
	RCC_DCKCFGR_PLLI2SDIVQ_Div22 = 0x15
	// PLLI2SDIVQ = /23
	RCC_DCKCFGR_PLLI2SDIVQ_Div23 = 0x16
	// PLLI2SDIVQ = /24
	RCC_DCKCFGR_PLLI2SDIVQ_Div24 = 0x17
	// PLLI2SDIVQ = /25
	RCC_DCKCFGR_PLLI2SDIVQ_Div25 = 0x18
	// PLLI2SDIVQ = /26
	RCC_DCKCFGR_PLLI2SDIVQ_Div26 = 0x19
	// PLLI2SDIVQ = /27
	RCC_DCKCFGR_PLLI2SDIVQ_Div27 = 0x1a
	// PLLI2SDIVQ = /28
	RCC_DCKCFGR_PLLI2SDIVQ_Div28 = 0x1b
	// PLLI2SDIVQ = /29
	RCC_DCKCFGR_PLLI2SDIVQ_Div29 = 0x1c
	// PLLI2SDIVQ = /30
	RCC_DCKCFGR_PLLI2SDIVQ_Div30 = 0x1d
	// PLLI2SDIVQ = /31
	RCC_DCKCFGR_PLLI2SDIVQ_Div31 = 0x1e
	// PLLI2SDIVQ = /32
	RCC_DCKCFGR_PLLI2SDIVQ_Div32 = 0x1f
	// Position of PLLSAIDIVQ field.
	RCC_DCKCFGR_PLLSAIDIVQ_Pos = 0x8
	// Bit mask of PLLSAIDIVQ field.
	RCC_DCKCFGR_PLLSAIDIVQ_Msk = 0x1f00
	// PLLSAIDIVQ = /1
	RCC_DCKCFGR_PLLSAIDIVQ_Div1 = 0x0
	// PLLSAIDIVQ = /2
	RCC_DCKCFGR_PLLSAIDIVQ_Div2 = 0x1
	// PLLSAIDIVQ = /3
	RCC_DCKCFGR_PLLSAIDIVQ_Div3 = 0x2
	// PLLSAIDIVQ = /4
	RCC_DCKCFGR_PLLSAIDIVQ_Div4 = 0x3
	// PLLSAIDIVQ = /5
	RCC_DCKCFGR_PLLSAIDIVQ_Div5 = 0x4
	// PLLSAIDIVQ = /6
	RCC_DCKCFGR_PLLSAIDIVQ_Div6 = 0x5
	// PLLSAIDIVQ = /7
	RCC_DCKCFGR_PLLSAIDIVQ_Div7 = 0x6
	// PLLSAIDIVQ = /8
	RCC_DCKCFGR_PLLSAIDIVQ_Div8 = 0x7
	// PLLSAIDIVQ = /9
	RCC_DCKCFGR_PLLSAIDIVQ_Div9 = 0x8
	// PLLSAIDIVQ = /10
	RCC_DCKCFGR_PLLSAIDIVQ_Div10 = 0x9
	// PLLSAIDIVQ = /11
	RCC_DCKCFGR_PLLSAIDIVQ_Div11 = 0xa
	// PLLSAIDIVQ = /12
	RCC_DCKCFGR_PLLSAIDIVQ_Div12 = 0xb
	// PLLSAIDIVQ = /13
	RCC_DCKCFGR_PLLSAIDIVQ_Div13 = 0xc
	// PLLSAIDIVQ = /14
	RCC_DCKCFGR_PLLSAIDIVQ_Div14 = 0xd
	// PLLSAIDIVQ = /15
	RCC_DCKCFGR_PLLSAIDIVQ_Div15 = 0xe
	// PLLSAIDIVQ = /16
	RCC_DCKCFGR_PLLSAIDIVQ_Div16 = 0xf
	// PLLSAIDIVQ = /17
	RCC_DCKCFGR_PLLSAIDIVQ_Div17 = 0x10
	// PLLSAIDIVQ = /18
	RCC_DCKCFGR_PLLSAIDIVQ_Div18 = 0x11
	// PLLSAIDIVQ = /19
	RCC_DCKCFGR_PLLSAIDIVQ_Div19 = 0x12
	// PLLSAIDIVQ = /20
	RCC_DCKCFGR_PLLSAIDIVQ_Div20 = 0x13
	// PLLSAIDIVQ = /21
	RCC_DCKCFGR_PLLSAIDIVQ_Div21 = 0x14
	// PLLSAIDIVQ = /22
	RCC_DCKCFGR_PLLSAIDIVQ_Div22 = 0x15
	// PLLSAIDIVQ = /23
	RCC_DCKCFGR_PLLSAIDIVQ_Div23 = 0x16
	// PLLSAIDIVQ = /24
	RCC_DCKCFGR_PLLSAIDIVQ_Div24 = 0x17
	// PLLSAIDIVQ = /25
	RCC_DCKCFGR_PLLSAIDIVQ_Div25 = 0x18
	// PLLSAIDIVQ = /26
	RCC_DCKCFGR_PLLSAIDIVQ_Div26 = 0x19
	// PLLSAIDIVQ = /27
	RCC_DCKCFGR_PLLSAIDIVQ_Div27 = 0x1a
	// PLLSAIDIVQ = /28
	RCC_DCKCFGR_PLLSAIDIVQ_Div28 = 0x1b
	// PLLSAIDIVQ = /29
	RCC_DCKCFGR_PLLSAIDIVQ_Div29 = 0x1c
	// PLLSAIDIVQ = /30
	RCC_DCKCFGR_PLLSAIDIVQ_Div30 = 0x1d
	// PLLSAIDIVQ = /31
	RCC_DCKCFGR_PLLSAIDIVQ_Div31 = 0x1e
	// PLLSAIDIVQ = /32
	RCC_DCKCFGR_PLLSAIDIVQ_Div32 = 0x1f
	// Position of SAI1SRC field.
	RCC_DCKCFGR_SAI1SRC_Pos = 0x14
	// Bit mask of SAI1SRC field.
	RCC_DCKCFGR_SAI1SRC_Msk = 0x300000
	// SAI1 clock frequency = f(PLLSAI_Q) / PLLSAIDIVQ
	RCC_DCKCFGR_SAI1SRC_PLLSAI = 0x0
	// SAI1 clock frequency = f(PLLI2S_Q) / PLLI2SDIVQ
	RCC_DCKCFGR_SAI1SRC_PLLI2S = 0x1
	// SAI1 clock frequency = f(PLL_R)
	RCC_DCKCFGR_SAI1SRC_PLLR = 0x2
	// I2S_CKIN Alternate function input frequency
	RCC_DCKCFGR_SAI1SRC_I2S_CKIN = 0x3
	// Position of SAI2SRC field.
	RCC_DCKCFGR_SAI2SRC_Pos = 0x16
	// Bit mask of SAI2SRC field.
	RCC_DCKCFGR_SAI2SRC_Msk = 0xc00000
	// SAI2 clock frequency = f(PLLSAI_Q) / PLLSAIDIVQ
	RCC_DCKCFGR_SAI2SRC_PLLSAI = 0x0
	// SAI2 clock frequency = f(PLLI2S_Q) / PLLI2SDIVQ
	RCC_DCKCFGR_SAI2SRC_PLLI2S = 0x1
	// SAI2 clock frequency = f(PLL_R)
	RCC_DCKCFGR_SAI2SRC_PLLR = 0x2
	// SAI2 clock frequency = Alternate function input frequency
	RCC_DCKCFGR_SAI2SRC_HSI_HSE = 0x3
	// Position of TIMPRE field.
	RCC_DCKCFGR_TIMPRE_Pos = 0x18
	// Bit mask of TIMPRE field.
	RCC_DCKCFGR_TIMPRE_Msk = 0x1000000
	// Bit TIMPRE.
	RCC_DCKCFGR_TIMPRE = 0x1000000
	// If the APB prescaler is configured 1, TIMxCLK = PCLKx. Otherwise, TIMxCLK = 2xPCLKx
	RCC_DCKCFGR_TIMPRE_Mul2 = 0x0
	// If the APB prescaler is configured 1, 2 or 4, TIMxCLK = HCLK. Otherwise, TIMxCLK = 4xPCLKx
	RCC_DCKCFGR_TIMPRE_Mul4 = 0x1
	// Position of I2S1SRC field.
	RCC_DCKCFGR_I2S1SRC_Pos = 0x19
	// Bit mask of I2S1SRC field.
	RCC_DCKCFGR_I2S1SRC_Msk = 0x6000000
	// I2Sx clock frequency = f(PLLI2S_R)
	RCC_DCKCFGR_I2S1SRC_PLLI2SR = 0x0
	// I2Sx clock frequency = I2S_CKIN Alternate function input frequency
	RCC_DCKCFGR_I2S1SRC_I2S_CKIN = 0x1
	// I2Sx clock frequency = f(PLL_R)
	RCC_DCKCFGR_I2S1SRC_PLLR = 0x2
	// I2Sx clock frequency = HSI/HSE depends on PLLSRC bit (PLLCFGR[22])
	RCC_DCKCFGR_I2S1SRC_HSI_HSE = 0x3
	// Position of I2S2SRC field.
	RCC_DCKCFGR_I2S2SRC_Pos = 0x1b
	// Bit mask of I2S2SRC field.
	RCC_DCKCFGR_I2S2SRC_Msk = 0x18000000
	// I2Sx clock frequency = f(PLLI2S_R)
	RCC_DCKCFGR_I2S2SRC_PLLI2SR = 0x0
	// I2Sx clock frequency = I2S_CKIN Alternate function input frequency
	RCC_DCKCFGR_I2S2SRC_I2S_CKIN = 0x1
	// I2Sx clock frequency = f(PLL_R)
	RCC_DCKCFGR_I2S2SRC_PLLR = 0x2
	// I2Sx clock frequency = HSI/HSE depends on PLLSRC bit (PLLCFGR[22])
	RCC_DCKCFGR_I2S2SRC_HSI_HSE = 0x3

	// CKGATENR: clocks gated enable register
	// Position of AHB2APB1_CKEN field.
	RCC_CKGATENR_AHB2APB1_CKEN_Pos = 0x0
	// Bit mask of AHB2APB1_CKEN field.
	RCC_CKGATENR_AHB2APB1_CKEN_Msk = 0x1
	// Bit AHB2APB1_CKEN.
	RCC_CKGATENR_AHB2APB1_CKEN = 0x1
	// The clock gating is enabled
	RCC_CKGATENR_AHB2APB1_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_AHB2APB1_CKEN_Disabled = 0x1
	// Position of AHB2APB2_CKEN field.
	RCC_CKGATENR_AHB2APB2_CKEN_Pos = 0x1
	// Bit mask of AHB2APB2_CKEN field.
	RCC_CKGATENR_AHB2APB2_CKEN_Msk = 0x2
	// Bit AHB2APB2_CKEN.
	RCC_CKGATENR_AHB2APB2_CKEN = 0x2
	// The clock gating is enabled
	RCC_CKGATENR_AHB2APB2_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_AHB2APB2_CKEN_Disabled = 0x1
	// Position of CM4DBG_CKEN field.
	RCC_CKGATENR_CM4DBG_CKEN_Pos = 0x2
	// Bit mask of CM4DBG_CKEN field.
	RCC_CKGATENR_CM4DBG_CKEN_Msk = 0x4
	// Bit CM4DBG_CKEN.
	RCC_CKGATENR_CM4DBG_CKEN = 0x4
	// The clock gating is enabled
	RCC_CKGATENR_CM4DBG_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_CM4DBG_CKEN_Disabled = 0x1
	// Position of SPARE_CKEN field.
	RCC_CKGATENR_SPARE_CKEN_Pos = 0x3
	// Bit mask of SPARE_CKEN field.
	RCC_CKGATENR_SPARE_CKEN_Msk = 0x8
	// Bit SPARE_CKEN.
	RCC_CKGATENR_SPARE_CKEN = 0x8
	// The clock gating is enabled
	RCC_CKGATENR_SPARE_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_SPARE_CKEN_Disabled = 0x1
	// Position of SRAM_CKEN field.
	RCC_CKGATENR_SRAM_CKEN_Pos = 0x4
	// Bit mask of SRAM_CKEN field.
	RCC_CKGATENR_SRAM_CKEN_Msk = 0x10
	// Bit SRAM_CKEN.
	RCC_CKGATENR_SRAM_CKEN = 0x10
	// The clock gating is enabled
	RCC_CKGATENR_SRAM_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_SRAM_CKEN_Disabled = 0x1
	// Position of FLITF_CKEN field.
	RCC_CKGATENR_FLITF_CKEN_Pos = 0x5
	// Bit mask of FLITF_CKEN field.
	RCC_CKGATENR_FLITF_CKEN_Msk = 0x20
	// Bit FLITF_CKEN.
	RCC_CKGATENR_FLITF_CKEN = 0x20
	// The clock gating is enabled
	RCC_CKGATENR_FLITF_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_FLITF_CKEN_Disabled = 0x1
	// Position of RCC_CKEN field.
	RCC_CKGATENR_RCC_CKEN_Pos = 0x6
	// Bit mask of RCC_CKEN field.
	RCC_CKGATENR_RCC_CKEN_Msk = 0x40
	// Bit RCC_CKEN.
	RCC_CKGATENR_RCC_CKEN = 0x40
	// The clock gating is enabled
	RCC_CKGATENR_RCC_CKEN_Enabled = 0x0
	// The clock gating is disabled, the clock is always enabled
	RCC_CKGATENR_RCC_CKEN_Disabled = 0x1

	// DCKCFGR2: dedicated clocks configuration register 2
	// Position of FMPI2C1SEL field.
	RCC_DCKCFGR2_FMPI2C1SEL_Pos = 0x16
	// Bit mask of FMPI2C1SEL field.
	RCC_DCKCFGR2_FMPI2C1SEL_Msk = 0xc00000
	// APB clock selected as I2C clock
	RCC_DCKCFGR2_FMPI2C1SEL_APB = 0x0
	// System clock selected as I2C clock
	RCC_DCKCFGR2_FMPI2C1SEL_SYSCLK = 0x1
	// HSI clock selected as I2C clock
	RCC_DCKCFGR2_FMPI2C1SEL_HSI = 0x2
	// Position of CECSEL field.
	RCC_DCKCFGR2_CECSEL_Pos = 0x1a
	// Bit mask of CECSEL field.
	RCC_DCKCFGR2_CECSEL_Msk = 0x4000000
	// Bit CECSEL.
	RCC_DCKCFGR2_CECSEL = 0x4000000
	// LSE clock is selected as HDMI-CEC clock
	RCC_DCKCFGR2_CECSEL_LSE = 0x0
	// HSI divided by 488 clock is selected as HDMI-CEC clock
	RCC_DCKCFGR2_CECSEL_HSI_Div488 = 0x1
	// Position of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL_Pos = 0x1b
	// Bit mask of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL_Msk = 0x8000000
	// Bit CK48MSEL.
	RCC_DCKCFGR2_CK48MSEL = 0x8000000
	// 48MHz clock from PLL is selected
	RCC_DCKCFGR2_CK48MSEL_PLL = 0x0
	// 48MHz clock from PLLSAI is selected
	RCC_DCKCFGR2_CK48MSEL_PLLSAI = 0x1
	// Position of SDIOSEL field.
	RCC_DCKCFGR2_SDIOSEL_Pos = 0x1c
	// Bit mask of SDIOSEL field.
	RCC_DCKCFGR2_SDIOSEL_Msk = 0x10000000
	// Bit SDIOSEL.
	RCC_DCKCFGR2_SDIOSEL = 0x10000000
	// 48 MHz clock is selected as SD clock
	RCC_DCKCFGR2_SDIOSEL_CK48M = 0x0
	// System clock is selected as SD clock
	RCC_DCKCFGR2_SDIOSEL_SYSCLK = 0x1
	// Position of SPDIFRXSEL field.
	RCC_DCKCFGR2_SPDIFRXSEL_Pos = 0x1d
	// Bit mask of SPDIFRXSEL field.
	RCC_DCKCFGR2_SPDIFRXSEL_Msk = 0x20000000
	// Bit SPDIFRXSEL.
	RCC_DCKCFGR2_SPDIFRXSEL = 0x20000000
	// SPDIF-Rx clock from PLL is selected
	RCC_DCKCFGR2_SPDIFRXSEL_PLL = 0x0
	// SPDIF-Rx clock from PLLI2S is selected
	RCC_DCKCFGR2_SPDIFRXSEL_PLLI2S = 0x1
)

// Bitfields for GPIOH: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x7
	// Position of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Pos = 0x8
	// Bit mask of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Msk = 0x100
	// Bit FB_MODE.
	SYSCFG_MEMRM_FB_MODE = 0x100
	// Position of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Pos = 0xa
	// Bit mask of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Msk = 0xc00

	// PMC: peripheral mode configuration register
	// Position of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Pos = 0x17
	// Bit mask of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Msk = 0x800000
	// Bit MII_RMII_SEL.
	SYSCFG_PMC_MII_RMII_SEL = 0x800000
	// Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Pos = 0x10
	// Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk = 0x10000
	// Bit ADC1DC2.
	SYSCFG_PMC_ADC1DC2 = 0x10000
	// Position of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Pos = 0x11
	// Bit mask of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Msk = 0x20000
	// Bit ADC2DC2.
	SYSCFG_PMC_ADC2DC2 = 0x20000
	// Position of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Pos = 0x12
	// Bit mask of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Msk = 0x40000
	// Bit ADC3DC2.
	SYSCFG_PMC_ADC3DC2 = 0x40000

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf

	// CMPCR: Compensation cell control register
	// Position of READY field.
	SYSCFG_CMPCR_READY_Pos = 0x8
	// Bit mask of READY field.
	SYSCFG_CMPCR_READY_Msk = 0x100
	// Bit READY.
	SYSCFG_CMPCR_READY = 0x100
	// Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0
	// Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1
	// Bit CMP_PD.
	SYSCFG_CMPCR_CMP_PD = 0x1

	// CFGR: Configuration register
	// Position of FMPI2C1_SCL field.
	SYSCFG_CFGR_FMPI2C1_SCL_Pos = 0x0
	// Bit mask of FMPI2C1_SCL field.
	SYSCFG_CFGR_FMPI2C1_SCL_Msk = 0x1
	// Bit FMPI2C1_SCL.
	SYSCFG_CFGR_FMPI2C1_SCL = 0x1
	// Position of FMPI2C1_SDA field.
	SYSCFG_CFGR_FMPI2C1_SDA_Pos = 0x1
	// Bit mask of FMPI2C1_SDA field.
	SYSCFG_CFGR_FMPI2C1_SDA_Msk = 0x2
	// Bit FMPI2C1_SDA.
	SYSCFG_CFGR_FMPI2C1_SDA = 0x2
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// 8-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_EightBit = 0x0
	// 16-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1

	// SR: status register
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// No frame format error
	SPI_SR_FRE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_FRE_Error = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Bitfields for ADC1: Analog-to-digital converter
const (
	// SR: status register
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// No overrun occurred
	ADC_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_SR_OVR_Overrun = 0x1
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected channel conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected channel conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Overrun interrupt disabled
	ADC_CR1_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_CR1_OVRIE_Enabled = 0x1
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// 12-bit (15 ADCCLK cycles)
	ADC_CR1_RES_TwelveBit = 0x0
	// 10-bit (13 ADCCLK cycles)
	ADC_CR1_RES_TenBit = 0x1
	// 8-bit (11 ADCCLK cycles)
	ADC_CR1_RES_EightBit = 0x2
	// 6-bit (9 ADCCLK cycles)
	ADC_CR1_RES_SixBit = 0x3
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_SingleChannel = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analogue watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analogue watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Starts conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Trigger detection disabled
	ADC_CR2_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_TIM1CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_TIM1CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_TIM1CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_TIM2CC2 = 0x3
	// Timer 2 CC3 event
	ADC_CR2_EXTSEL_TIM2CC3 = 0x4
	// Timer 2 CC4 event
	ADC_CR2_EXTSEL_TIM2CC4 = 0x5
	// Timer 2 TRGO event
	ADC_CR2_EXTSEL_TIM2TRGO = 0x6
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Starts conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Trigger detection disabled
	ADC_CR2_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_TIM1TRGO = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_TIM1CC4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_TIM2TRGO = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_TIM2CC1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_TIM3CC4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_TIM4TRGO = 0x5
	// Timer 8 CC4 event
	ADC_CR2_JEXTSEL_TIM8CC4 = 0x7
	// Timer 1 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM1TRGO2 = 0x8
	// Timer 8 TRGO event
	ADC_CR2_JEXTSEL_TIM8TRGO = 0x9
	// Timer 8 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM8TRGO2 = 0xa
	// Timer 3 CC3 event
	ADC_CR2_JEXTSEL_TIM3CC3 = 0xb
	// Timer 5 TRGO event
	ADC_CR2_JEXTSEL_TIM5TRGO = 0xc
	// Timer 3 CC1 event
	ADC_CR2_JEXTSEL_TIM3CC1 = 0xd
	// Timer 6 TRGO event
	ADC_CR2_JEXTSEL_TIM6TRGO = 0xe
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// The EOC bit is set at the end of each sequence of regular conversions
	ADC_CR2_EOCS_EachSequence = 0x0
	// The EOC bit is set at the end of each regular conversion
	ADC_CR2_EOCS_EachConversion = 0x1
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// No new DMA request is issued after the last transfer
	ADC_CR2_DDS_Single = 0x0
	// DMA requests are issued as long as data are converted and DMA=1
	ADC_CR2_DDS_Continuous = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP18 field.
	ADC_SMPR1_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR1_SMP18_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR1_SMP18_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP18_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP18_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP18_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP18_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP18_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP18_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP18_Cycles480 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR1_SMP17_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP17_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP17_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP17_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP17_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP17_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP17_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP17_Cycles480 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR1_SMP16_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP16_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP16_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP16_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP16_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP16_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP16_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP16_Cycles480 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 3 cycles
	ADC_SMPR1_SMP15_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP15_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP15_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP15_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP15_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP15_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP15_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP15_Cycles480 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 3 cycles
	ADC_SMPR1_SMP14_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP14_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP14_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP14_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP14_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP14_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP14_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP14_Cycles480 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 3 cycles
	ADC_SMPR1_SMP13_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP13_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP13_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP13_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP13_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP13_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP13_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP13_Cycles480 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR1_SMP12_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP12_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP12_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP12_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP12_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP12_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP12_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP12_Cycles480 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 3 cycles
	ADC_SMPR1_SMP11_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP11_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP11_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP11_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP11_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP11_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP11_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP11_Cycles480 = 0x7
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 3 cycles
	ADC_SMPR1_SMP10_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP10_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP10_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP10_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP10_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP10_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP10_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP10_Cycles480 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 3 cycles
	ADC_SMPR2_SMP9_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP9_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP9_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP9_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP9_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP9_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP9_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP9_Cycles480 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR2_SMP8_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP8_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP8_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP8_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP8_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP8_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP8_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP8_Cycles480 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR2_SMP7_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP7_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP7_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP7_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP7_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP7_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP7_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP7_Cycles480 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR2_SMP6_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP6_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP6_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP6_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP6_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP6_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP6_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP6_Cycles480 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 3 cycles
	ADC_SMPR2_SMP5_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP5_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP5_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP5_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP5_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP5_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP5_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP5_Cycles480 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 3 cycles
	ADC_SMPR2_SMP4_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP4_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP4_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP4_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP4_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP4_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP4_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP4_Cycles480 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 3 cycles
	ADC_SMPR2_SMP3_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP3_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP3_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP3_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP3_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP3_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP3_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP3_Cycles480 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR2_SMP2_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP2_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP2_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP2_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP2_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP2_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP2_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP2_Cycles480 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 3 cycles
	ADC_SMPR2_SMP1_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP1_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP1_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP1_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP1_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP1_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP1_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP1_Cycles480 = 0x7
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 3 cycles
	ADC_SMPR2_SMP0_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP0_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP0_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP0_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP0_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP0_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP0_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP0_Cycles480 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET field.
	ADC_JOFR_JOFFSET_Pos = 0x0
	// Bit mask of JOFFSET field.
	ADC_JOFR_JOFFSET_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	// Position of CTS field.
	USART_SR_CTS_Pos = 0x9
	// Bit mask of CTS field.
	USART_SR_CTS_Msk = 0x200
	// Bit CTS.
	USART_SR_CTS = 0x200
	// Position of LBD field.
	USART_SR_LBD_Pos = 0x8
	// Bit mask of LBD field.
	USART_SR_LBD_Msk = 0x100
	// Bit LBD.
	USART_SR_LBD = 0x100
	// Position of TXE field.
	USART_SR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_SR_TXE_Msk = 0x80
	// Bit TXE.
	USART_SR_TXE = 0x80
	// Position of TC field.
	USART_SR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_SR_TC_Msk = 0x40
	// Bit TC.
	USART_SR_TC = 0x40
	// Position of RXNE field.
	USART_SR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_SR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_SR_RXNE = 0x20
	// Position of IDLE field.
	USART_SR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_SR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_SR_IDLE = 0x10
	// Position of ORE field.
	USART_SR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_SR_ORE_Msk = 0x8
	// Bit ORE.
	USART_SR_ORE = 0x8
	// Position of NF field.
	USART_SR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_SR_NF_Msk = 0x4
	// Bit NF.
	USART_SR_NF = 0x4
	// Position of FE field.
	USART_SR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_SR_FE_Msk = 0x2
	// Bit FE.
	USART_SR_FE = 0x2
	// Position of PE field.
	USART_SR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_SR_PE_Msk = 0x1
	// Bit PE.
	USART_SR_PE = 0x1

	// DR: Data register
	// Position of DR field.
	USART_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	USART_DR_DR_Msk = 0x1ff

	// BRR: Baud rate register
	// Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Pos = 0x4
	// Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0
	// Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Pos = 0x0
	// Bit mask of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf

	// CR1: Control register 1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversample16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversample8 = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0xd
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x2000
	// Bit UE.
	USART_CR1_UE = 0x2000
	// USART prescaler and outputs disabled
	USART_CR1_UE_Disabled = 0x0
	// USART enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 8 data bits
	USART_CR1_M_M8 = 0x0
	// 9 data bits
	USART_CR1_M_M9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// USART wakeup on idle line
	USART_CR1_WAKE_IdleLine = 0x0
	// USART wakeup on address mark
	USART_CR1_WAKE_AddressMark = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// PE interrupt disabled
	USART_CR1_PEIE_Disabled = 0x0
	// PE interrupt enabled
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// TXE interrupt disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// TXE interrupt enabled
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// TC interrupt disabled
	USART_CR1_TCIE_Disabled = 0x0
	// TC interrupt enabled
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// RXNE interrupt disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// RXNE interrupt enabled
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// IDLE interrupt disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// IDLE interrupt enabled
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of RWU field.
	USART_CR1_RWU_Pos = 0x1
	// Bit mask of RWU field.
	USART_CR1_RWU_Msk = 0x2
	// Bit RWU.
	USART_CR1_RWU = 0x2
	// Receiver in active mode
	USART_CR1_RWU_Active = 0x0
	// Receiver in mute mode
	USART_CR1_RWU_Mute = 0x1
	// Position of SBK field.
	USART_CR1_SBK_Pos = 0x0
	// Bit mask of SBK field.
	USART_CR1_SBK_Msk = 0x1
	// Bit SBK.
	USART_CR1_SBK = 0x1
	// No break character is transmitted
	USART_CR1_SBK_NoBreak = 0x0
	// Break character transmitted
	USART_CR1_SBK_Break = 0x1

	// CR2: Control register 2
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bits
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bits
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// LIN break detection interrupt disabled
	USART_CR2_LBDIE_Disabled = 0x0
	// LIN break detection interrupt enabled
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_LBDL10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_LBDL11 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xf

	// CR3: Control register 3
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// CTS interrupt disabled
	USART_CR3_CTSIE_Disabled = 0x0
	// CTS interrupt enabled
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS hardware flow control enabled
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS hardware flow control enabled
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_FullDuplex = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_HalfDuplex = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Error interrupt disabled
	USART_CR3_EIE_Disabled = 0x0
	// Error interrupt enabled
	USART_CR3_EIE_Enabled = 0x1

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x8000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x8000
	// I2C peripheral not under reset
	I2C_CR1_SWRST_NotReset = 0x0
	// I2C peripheral under reset
	I2C_CR1_SWRST_Reset = 0x1
	// Position of ALERT field.
	I2C_CR1_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_CR1_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_CR1_ALERT = 0x2000
	// SMBA pin released high
	I2C_CR1_ALERT_Release = 0x0
	// SMBA pin driven low
	I2C_CR1_ALERT_Drive = 0x1
	// Position of PEC field.
	I2C_CR1_PEC_Pos = 0xc
	// Bit mask of PEC field.
	I2C_CR1_PEC_Msk = 0x1000
	// Bit PEC.
	I2C_CR1_PEC = 0x1000
	// No PEC transfer
	I2C_CR1_PEC_Disabled = 0x0
	// PEC transfer
	I2C_CR1_PEC_Enabled = 0x1
	// Position of POS field.
	I2C_CR1_POS_Pos = 0xb
	// Bit mask of POS field.
	I2C_CR1_POS_Msk = 0x800
	// Bit POS.
	I2C_CR1_POS = 0x800
	// ACK bit controls the (N)ACK of the current byte being received
	I2C_CR1_POS_Current = 0x0
	// ACK bit controls the (N)ACK of the next byte to be received
	I2C_CR1_POS_Next = 0x1
	// Position of ACK field.
	I2C_CR1_ACK_Pos = 0xa
	// Bit mask of ACK field.
	I2C_CR1_ACK_Msk = 0x400
	// Bit ACK.
	I2C_CR1_ACK = 0x400
	// No acknowledge returned
	I2C_CR1_ACK_NAK = 0x0
	// Acknowledge returned after a byte is received
	I2C_CR1_ACK_ACK = 0x1
	// Position of STOP field.
	I2C_CR1_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C_CR1_STOP_Msk = 0x200
	// Bit STOP.
	I2C_CR1_STOP = 0x200
	// No Stop generation
	I2C_CR1_STOP_NoStop = 0x0
	// In master mode: stop generation after current byte/start, in slave mode: release SCL and SDA after current byte
	I2C_CR1_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR1_START_Pos = 0x8
	// Bit mask of START field.
	I2C_CR1_START_Msk = 0x100
	// Bit START.
	I2C_CR1_START = 0x100
	// No Start generation
	I2C_CR1_START_NoStart = 0x0
	// In master mode: repeated start generation, in slave mode: start generation when bus is free
	I2C_CR1_START_Start = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x7
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x80
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of ENGC field.
	I2C_CR1_ENGC_Pos = 0x6
	// Bit mask of ENGC field.
	I2C_CR1_ENGC_Msk = 0x40
	// Bit ENGC.
	I2C_CR1_ENGC = 0x40
	// General call disabled
	I2C_CR1_ENGC_Disabled = 0x0
	// General call enabled
	I2C_CR1_ENGC_Enabled = 0x1
	// Position of ENPEC field.
	I2C_CR1_ENPEC_Pos = 0x5
	// Bit mask of ENPEC field.
	I2C_CR1_ENPEC_Msk = 0x20
	// Bit ENPEC.
	I2C_CR1_ENPEC = 0x20
	// PEC calculation disabled
	I2C_CR1_ENPEC_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_ENPEC_Enabled = 0x1
	// Position of ENARP field.
	I2C_CR1_ENARP_Pos = 0x4
	// Bit mask of ENARP field.
	I2C_CR1_ENARP_Msk = 0x10
	// Bit ENARP.
	I2C_CR1_ENARP = 0x10
	// ARP disabled
	I2C_CR1_ENARP_Disabled = 0x0
	// ARP enabled
	I2C_CR1_ENARP_Enabled = 0x1
	// Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Pos = 0x3
	// Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk = 0x8
	// Bit SMBTYPE.
	I2C_CR1_SMBTYPE = 0x8
	// SMBus Device
	I2C_CR1_SMBTYPE_Device = 0x0
	// SMBus Host
	I2C_CR1_SMBTYPE_Host = 0x1
	// Position of SMBUS field.
	I2C_CR1_SMBUS_Pos = 0x1
	// Bit mask of SMBUS field.
	I2C_CR1_SMBUS_Msk = 0x2
	// Bit SMBUS.
	I2C_CR1_SMBUS = 0x2
	// I2C Mode
	I2C_CR1_SMBUS_I2C = 0x0
	// SMBus
	I2C_CR1_SMBUS_SMBus = 0x1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1

	// CR2: Control register 2
	// Position of LAST field.
	I2C_CR2_LAST_Pos = 0xc
	// Bit mask of LAST field.
	I2C_CR2_LAST_Msk = 0x1000
	// Bit LAST.
	I2C_CR2_LAST = 0x1000
	// Next DMA EOT is not the last transfer
	I2C_CR2_LAST_NotLast = 0x0
	// Next DMA EOT is the last transfer
	I2C_CR2_LAST_Last = 0x1
	// Position of DMAEN field.
	I2C_CR2_DMAEN_Pos = 0xb
	// Bit mask of DMAEN field.
	I2C_CR2_DMAEN_Msk = 0x800
	// Bit DMAEN.
	I2C_CR2_DMAEN = 0x800
	// DMA requests disabled
	I2C_CR2_DMAEN_Disabled = 0x0
	// DMA request enabled when TxE=1 or RxNE=1
	I2C_CR2_DMAEN_Enabled = 0x1
	// Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Pos = 0xa
	// Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400
	// Bit ITBUFEN.
	I2C_CR2_ITBUFEN = 0x400
	// TxE=1 or RxNE=1 does not generate any interrupt
	I2C_CR2_ITBUFEN_Disabled = 0x0
	// TxE=1 or RxNE=1 generates Event interrupt
	I2C_CR2_ITBUFEN_Enabled = 0x1
	// Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Pos = 0x9
	// Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200
	// Bit ITEVTEN.
	I2C_CR2_ITEVTEN = 0x200
	// Event interrupt disabled
	I2C_CR2_ITEVTEN_Disabled = 0x0
	// Event interrupt enabled
	I2C_CR2_ITEVTEN_Enabled = 0x1
	// Position of ITERREN field.
	I2C_CR2_ITERREN_Pos = 0x8
	// Bit mask of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100
	// Bit ITERREN.
	I2C_CR2_ITERREN = 0x100
	// Error interrupt disabled
	I2C_CR2_ITERREN_Disabled = 0x0
	// Error interrupt enabled
	I2C_CR2_ITERREN_Enabled = 0x1
	// Position of FREQ field.
	I2C_CR2_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	I2C_CR2_FREQ_Msk = 0x3f

	// OAR1: Own address register 1
	// Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Pos = 0xf
	// Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000
	// Bit ADDMODE.
	I2C_OAR1_ADDMODE = 0x8000
	// 7-bit slave address
	I2C_OAR1_ADDMODE_ADD7 = 0x0
	// 10-bit slave address
	I2C_OAR1_ADDMODE_ADD10 = 0x1
	// Position of ADD field.
	I2C_OAR1_ADD_Pos = 0x0
	// Bit mask of ADD field.
	I2C_OAR1_ADD_Msk = 0x3ff

	// OAR2: Own address register 2
	// Position of ADD2 field.
	I2C_OAR2_ADD2_Pos = 0x1
	// Bit mask of ADD2 field.
	I2C_OAR2_ADD2_Msk = 0xfe
	// Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Pos = 0x0
	// Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1
	// Bit ENDUAL.
	I2C_OAR2_ENDUAL = 0x1
	// Single addressing mode
	I2C_OAR2_ENDUAL_Single = 0x0
	// Dual addressing mode
	I2C_OAR2_ENDUAL_Dual = 0x1

	// DR: Data register
	// Position of DR field.
	I2C_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	I2C_DR_DR_Msk = 0xff

	// SR1: Status register 1
	// Position of SMBALERT field.
	I2C_SR1_SMBALERT_Pos = 0xf
	// Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000
	// Bit SMBALERT.
	I2C_SR1_SMBALERT = 0x8000
	// No SMBALERT occured
	I2C_SR1_SMBALERT_NoAlert = 0x0
	// SMBALERT occurred
	I2C_SR1_SMBALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Pos = 0xe
	// Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk = 0x4000
	// Bit TIMEOUT.
	I2C_SR1_TIMEOUT = 0x4000
	// No Timeout error
	I2C_SR1_TIMEOUT_NoTimeout = 0x0
	// SCL remained LOW for 25 ms
	I2C_SR1_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_SR1_PECERR_Pos = 0xc
	// Bit mask of PECERR field.
	I2C_SR1_PECERR_Msk = 0x1000
	// Bit PECERR.
	I2C_SR1_PECERR = 0x1000
	// no PEC error: receiver returns ACK after PEC reception (if ACK=1)
	I2C_SR1_PECERR_NoError = 0x0
	// PEC error: receiver returns NACK after PEC reception (whatever ACK)
	I2C_SR1_PECERR_Error = 0x1
	// Position of OVR field.
	I2C_SR1_OVR_Pos = 0xb
	// Bit mask of OVR field.
	I2C_SR1_OVR_Msk = 0x800
	// Bit OVR.
	I2C_SR1_OVR = 0x800
	// No overrun/underrun occured
	I2C_SR1_OVR_NoOverrun = 0x0
	// Overrun/underrun occured
	I2C_SR1_OVR_Overrun = 0x1
	// Position of AF field.
	I2C_SR1_AF_Pos = 0xa
	// Bit mask of AF field.
	I2C_SR1_AF_Msk = 0x400
	// Bit AF.
	I2C_SR1_AF = 0x400
	// No acknowledge failure
	I2C_SR1_AF_NoFailure = 0x0
	// Acknowledge failure
	I2C_SR1_AF_Failure = 0x1
	// Position of ARLO field.
	I2C_SR1_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_SR1_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_SR1_ARLO = 0x200
	// No Arbitration Lost detected
	I2C_SR1_ARLO_NoLost = 0x0
	// Arbitration Lost detected
	I2C_SR1_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_SR1_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_SR1_BERR_Msk = 0x100
	// Bit BERR.
	I2C_SR1_BERR = 0x100
	// No misplaced Start or Stop condition
	I2C_SR1_BERR_NoError = 0x0
	// Misplaced Start or Stop condition
	I2C_SR1_BERR_Error = 0x1
	// Position of TxE field.
	I2C_SR1_TxE_Pos = 0x7
	// Bit mask of TxE field.
	I2C_SR1_TxE_Msk = 0x80
	// Bit TxE.
	I2C_SR1_TxE = 0x80
	// Data register not empty
	I2C_SR1_TxE_NotEmpty = 0x0
	// Data register empty
	I2C_SR1_TxE_Empty = 0x1
	// Position of RxNE field.
	I2C_SR1_RxNE_Pos = 0x6
	// Bit mask of RxNE field.
	I2C_SR1_RxNE_Msk = 0x40
	// Bit RxNE.
	I2C_SR1_RxNE = 0x40
	// Data register empty
	I2C_SR1_RxNE_Empty = 0x0
	// Data register not empty
	I2C_SR1_RxNE_NotEmpty = 0x1
	// Position of STOPF field.
	I2C_SR1_STOPF_Pos = 0x4
	// Bit mask of STOPF field.
	I2C_SR1_STOPF_Msk = 0x10
	// Bit STOPF.
	I2C_SR1_STOPF = 0x10
	// No Stop condition detected
	I2C_SR1_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_SR1_STOPF_Stop = 0x1
	// Position of ADD10 field.
	I2C_SR1_ADD10_Pos = 0x3
	// Bit mask of ADD10 field.
	I2C_SR1_ADD10_Msk = 0x8
	// Bit ADD10.
	I2C_SR1_ADD10 = 0x8
	// Position of BTF field.
	I2C_SR1_BTF_Pos = 0x2
	// Bit mask of BTF field.
	I2C_SR1_BTF_Msk = 0x4
	// Bit BTF.
	I2C_SR1_BTF = 0x4
	// Data byte transfer not done
	I2C_SR1_BTF_NotFinished = 0x0
	// Data byte transfer successful
	I2C_SR1_BTF_Finished = 0x1
	// Position of ADDR field.
	I2C_SR1_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	I2C_SR1_ADDR_Msk = 0x2
	// Bit ADDR.
	I2C_SR1_ADDR = 0x2
	// Adress mismatched or not received
	I2C_SR1_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_SR1_ADDR_Match = 0x1
	// Position of SB field.
	I2C_SR1_SB_Pos = 0x0
	// Bit mask of SB field.
	I2C_SR1_SB_Msk = 0x1
	// Bit SB.
	I2C_SR1_SB = 0x1
	// No Start condition
	I2C_SR1_SB_NoStart = 0x0
	// Start condition generated
	I2C_SR1_SB_Start = 0x1

	// SR2: Status register 2
	// Position of PEC field.
	I2C_SR2_PEC_Pos = 0x8
	// Bit mask of PEC field.
	I2C_SR2_PEC_Msk = 0xff00
	// Position of DUALF field.
	I2C_SR2_DUALF_Pos = 0x7
	// Bit mask of DUALF field.
	I2C_SR2_DUALF_Msk = 0x80
	// Bit DUALF.
	I2C_SR2_DUALF = 0x80
	// Position of SMBHOST field.
	I2C_SR2_SMBHOST_Pos = 0x6
	// Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST_Msk = 0x40
	// Bit SMBHOST.
	I2C_SR2_SMBHOST = 0x40
	// Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Pos = 0x5
	// Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20
	// Bit SMBDEFAULT.
	I2C_SR2_SMBDEFAULT = 0x20
	// Position of GENCALL field.
	I2C_SR2_GENCALL_Pos = 0x4
	// Bit mask of GENCALL field.
	I2C_SR2_GENCALL_Msk = 0x10
	// Bit GENCALL.
	I2C_SR2_GENCALL = 0x10
	// Position of TRA field.
	I2C_SR2_TRA_Pos = 0x2
	// Bit mask of TRA field.
	I2C_SR2_TRA_Msk = 0x4
	// Bit TRA.
	I2C_SR2_TRA = 0x4
	// Position of BUSY field.
	I2C_SR2_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	I2C_SR2_BUSY_Msk = 0x2
	// Bit BUSY.
	I2C_SR2_BUSY = 0x2
	// Position of MSL field.
	I2C_SR2_MSL_Pos = 0x0
	// Bit mask of MSL field.
	I2C_SR2_MSL_Msk = 0x1
	// Bit MSL.
	I2C_SR2_MSL = 0x1

	// CCR: Clock control register
	// Position of F_S field.
	I2C_CCR_F_S_Pos = 0xf
	// Bit mask of F_S field.
	I2C_CCR_F_S_Msk = 0x8000
	// Bit F_S.
	I2C_CCR_F_S = 0x8000
	// Standard mode I2C
	I2C_CCR_F_S_Standard = 0x0
	// Fast mode I2C
	I2C_CCR_F_S_Fast = 0x1
	// Position of DUTY field.
	I2C_CCR_DUTY_Pos = 0xe
	// Bit mask of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000
	// Bit DUTY.
	I2C_CCR_DUTY = 0x4000
	// Duty cycle t_low/t_high = 2/1
	I2C_CCR_DUTY_Duty2_1 = 0x0
	// Duty cycle t_low/t_high = 16/9
	I2C_CCR_DUTY_Duty16_9 = 0x1
	// Position of CCR field.
	I2C_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	I2C_CCR_CCR_Msk = 0xfff

	// TRISE: TRISE register
	// Position of TRISE field.
	I2C_TRISE_TRISE_Pos = 0x0
	// Bit mask of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f

	// FLTR: I2C FLTR register
	// Position of DNF field.
	I2C_FLTR_DNF_Pos = 0x0
	// Bit mask of DNF field.
	I2C_FLTR_DNF_Msk = 0xf
	// Position of ANOFF field.
	I2C_FLTR_ANOFF_Pos = 0x4
	// Bit mask of ANOFF field.
	I2C_FLTR_ANOFF_Msk = 0x10
	// Bit ANOFF.
	I2C_FLTR_ANOFF = 0x10
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of DCE field.
	RTC_CR_DCE_Pos = 0x7
	// Bit mask of DCE field.
	RTC_CR_DCE_Msk = 0x80
	// Bit DCE.
	RTC_CR_DCE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CALIBR: calibration register
	// Position of DCS field.
	RTC_CALIBR_DCS_Pos = 0x7
	// Bit mask of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80
	// Bit DCS.
	RTC_CALIBR_DCS = 0x80
	// Position of DC field.
	RTC_CALIBR_DC_Pos = 0x0
	// Bit mask of DC field.
	RTC_CALIBR_DC_Msk = 0x1f

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of ALARMOUTTYPE field.
	RTC_TSTR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TSTR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TSTR_ALARMOUTTYPE = 0x40000
	// Position of TSINSEL field.
	RTC_TSTR_TSINSEL_Pos = 0x11
	// Bit mask of TSINSEL field.
	RTC_TSTR_TSINSEL_Msk = 0x20000
	// Bit TSINSEL.
	RTC_TSTR_TSINSEL = 0x20000
	// Position of TAMP1INSEL field.
	RTC_TSTR_TAMP1INSEL_Pos = 0x10
	// Bit mask of TAMP1INSEL field.
	RTC_TSTR_TAMP1INSEL_Msk = 0x10000
	// Bit TAMP1INSEL.
	RTC_TSTR_TAMP1INSEL = 0x10000
	// Position of TAMPIE field.
	RTC_TSTR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TSTR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TSTR_TAMPIE = 0x4
	// Position of TAMP1TRG field.
	RTC_TSTR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TSTR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TSTR_TAMP1TRG = 0x2
	// Position of TAMP1E field.
	RTC_TSTR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TSTR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TSTR_TAMP1E = 0x1

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAFCR: tamper and alternate function configuration register
	// Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TAFCR_ALARMOUTTYPE = 0x40000
	// Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Pos = 0x11
	// Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk = 0x20000
	// Bit TSINSEL.
	RTC_TAFCR_TSINSEL = 0x20000
	// Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Pos = 0x10
	// Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk = 0x10000
	// Bit TAMP1INSEL.
	RTC_TAFCR_TAMP1INSEL = 0x10000
	// Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPUDIS = 0x8000
	// Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAFCR_TAMPTS = 0x80
	// Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAFCR_TAMP2TRG = 0x10
	// Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAFCR_TAMP2E = 0x8
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAFCR_TAMP1TRG = 0x2
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register 1
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// OC/OCN are disabled or forced idle depending on OSSI
	TIM_BDTR_MOE_DisabledIdle = 0x0
	// OC/OCN are enabled if CCxE/CCxNE are set
	TIM_BDTR_MOE_Enabled = 0x1
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSR_Disabled = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level
	TIM_BDTR_OSSR_IdleLevel = 0x1
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSI_Disabled = 0x0
	// When inactive, OC/OCN outputs are forced to idle level
	TIM_BDTR_OSSI_IdleLevel = 0x1
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff
)

// Bitfields for CRC: Cryptographic processor
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent Data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Bitfields for OTG_FS_GLOBAL: USB on the go full speed
const (
	// GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
	// Position of SRQSCS field.
	USB_OTG_FS_GOTGCTL_SRQSCS_Pos = 0x0
	// Bit mask of SRQSCS field.
	USB_OTG_FS_GOTGCTL_SRQSCS_Msk = 0x1
	// Bit SRQSCS.
	USB_OTG_FS_GOTGCTL_SRQSCS = 0x1
	// Position of SRQ field.
	USB_OTG_FS_GOTGCTL_SRQ_Pos = 0x1
	// Bit mask of SRQ field.
	USB_OTG_FS_GOTGCTL_SRQ_Msk = 0x2
	// Bit SRQ.
	USB_OTG_FS_GOTGCTL_SRQ = 0x2
	// Position of HNGSCS field.
	USB_OTG_FS_GOTGCTL_HNGSCS_Pos = 0x8
	// Bit mask of HNGSCS field.
	USB_OTG_FS_GOTGCTL_HNGSCS_Msk = 0x100
	// Bit HNGSCS.
	USB_OTG_FS_GOTGCTL_HNGSCS = 0x100
	// Position of HNPRQ field.
	USB_OTG_FS_GOTGCTL_HNPRQ_Pos = 0x9
	// Bit mask of HNPRQ field.
	USB_OTG_FS_GOTGCTL_HNPRQ_Msk = 0x200
	// Bit HNPRQ.
	USB_OTG_FS_GOTGCTL_HNPRQ = 0x200
	// Position of HSHNPEN field.
	USB_OTG_FS_GOTGCTL_HSHNPEN_Pos = 0xa
	// Bit mask of HSHNPEN field.
	USB_OTG_FS_GOTGCTL_HSHNPEN_Msk = 0x400
	// Bit HSHNPEN.
	USB_OTG_FS_GOTGCTL_HSHNPEN = 0x400
	// Position of DHNPEN field.
	USB_OTG_FS_GOTGCTL_DHNPEN_Pos = 0xb
	// Bit mask of DHNPEN field.
	USB_OTG_FS_GOTGCTL_DHNPEN_Msk = 0x800
	// Bit DHNPEN.
	USB_OTG_FS_GOTGCTL_DHNPEN = 0x800
	// Position of CIDSTS field.
	USB_OTG_FS_GOTGCTL_CIDSTS_Pos = 0x10
	// Bit mask of CIDSTS field.
	USB_OTG_FS_GOTGCTL_CIDSTS_Msk = 0x10000
	// Bit CIDSTS.
	USB_OTG_FS_GOTGCTL_CIDSTS = 0x10000
	// Position of DBCT field.
	USB_OTG_FS_GOTGCTL_DBCT_Pos = 0x11
	// Bit mask of DBCT field.
	USB_OTG_FS_GOTGCTL_DBCT_Msk = 0x20000
	// Bit DBCT.
	USB_OTG_FS_GOTGCTL_DBCT = 0x20000
	// Position of ASVLD field.
	USB_OTG_FS_GOTGCTL_ASVLD_Pos = 0x12
	// Bit mask of ASVLD field.
	USB_OTG_FS_GOTGCTL_ASVLD_Msk = 0x40000
	// Bit ASVLD.
	USB_OTG_FS_GOTGCTL_ASVLD = 0x40000
	// Position of BSVLD field.
	USB_OTG_FS_GOTGCTL_BSVLD_Pos = 0x13
	// Bit mask of BSVLD field.
	USB_OTG_FS_GOTGCTL_BSVLD_Msk = 0x80000
	// Bit BSVLD.
	USB_OTG_FS_GOTGCTL_BSVLD = 0x80000

	// GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
	// Position of SEDET field.
	USB_OTG_FS_GOTGINT_SEDET_Pos = 0x2
	// Bit mask of SEDET field.
	USB_OTG_FS_GOTGINT_SEDET_Msk = 0x4
	// Bit SEDET.
	USB_OTG_FS_GOTGINT_SEDET = 0x4
	// Position of SRSSCHG field.
	USB_OTG_FS_GOTGINT_SRSSCHG_Pos = 0x8
	// Bit mask of SRSSCHG field.
	USB_OTG_FS_GOTGINT_SRSSCHG_Msk = 0x100
	// Bit SRSSCHG.
	USB_OTG_FS_GOTGINT_SRSSCHG = 0x100
	// Position of HNSSCHG field.
	USB_OTG_FS_GOTGINT_HNSSCHG_Pos = 0x9
	// Bit mask of HNSSCHG field.
	USB_OTG_FS_GOTGINT_HNSSCHG_Msk = 0x200
	// Bit HNSSCHG.
	USB_OTG_FS_GOTGINT_HNSSCHG = 0x200
	// Position of HNGDET field.
	USB_OTG_FS_GOTGINT_HNGDET_Pos = 0x11
	// Bit mask of HNGDET field.
	USB_OTG_FS_GOTGINT_HNGDET_Msk = 0x20000
	// Bit HNGDET.
	USB_OTG_FS_GOTGINT_HNGDET = 0x20000
	// Position of ADTOCHG field.
	USB_OTG_FS_GOTGINT_ADTOCHG_Pos = 0x12
	// Bit mask of ADTOCHG field.
	USB_OTG_FS_GOTGINT_ADTOCHG_Msk = 0x40000
	// Bit ADTOCHG.
	USB_OTG_FS_GOTGINT_ADTOCHG = 0x40000
	// Position of DBCDNE field.
	USB_OTG_FS_GOTGINT_DBCDNE_Pos = 0x13
	// Bit mask of DBCDNE field.
	USB_OTG_FS_GOTGINT_DBCDNE_Msk = 0x80000
	// Bit DBCDNE.
	USB_OTG_FS_GOTGINT_DBCDNE = 0x80000

	// GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
	// Position of GINT field.
	USB_OTG_FS_GAHBCFG_GINT_Pos = 0x0
	// Bit mask of GINT field.
	USB_OTG_FS_GAHBCFG_GINT_Msk = 0x1
	// Bit GINT.
	USB_OTG_FS_GAHBCFG_GINT = 0x1
	// Position of TXFELVL field.
	USB_OTG_FS_GAHBCFG_TXFELVL_Pos = 0x7
	// Bit mask of TXFELVL field.
	USB_OTG_FS_GAHBCFG_TXFELVL_Msk = 0x80
	// Bit TXFELVL.
	USB_OTG_FS_GAHBCFG_TXFELVL = 0x80
	// Position of PTXFELVL field.
	USB_OTG_FS_GAHBCFG_PTXFELVL_Pos = 0x8
	// Bit mask of PTXFELVL field.
	USB_OTG_FS_GAHBCFG_PTXFELVL_Msk = 0x100
	// Bit PTXFELVL.
	USB_OTG_FS_GAHBCFG_PTXFELVL = 0x100

	// GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
	// Position of TOCAL field.
	USB_OTG_FS_GUSBCFG_TOCAL_Pos = 0x0
	// Bit mask of TOCAL field.
	USB_OTG_FS_GUSBCFG_TOCAL_Msk = 0x7
	// Position of PHYSEL field.
	USB_OTG_FS_GUSBCFG_PHYSEL_Pos = 0x6
	// Bit mask of PHYSEL field.
	USB_OTG_FS_GUSBCFG_PHYSEL_Msk = 0x40
	// Bit PHYSEL.
	USB_OTG_FS_GUSBCFG_PHYSEL = 0x40
	// Position of SRPCAP field.
	USB_OTG_FS_GUSBCFG_SRPCAP_Pos = 0x8
	// Bit mask of SRPCAP field.
	USB_OTG_FS_GUSBCFG_SRPCAP_Msk = 0x100
	// Bit SRPCAP.
	USB_OTG_FS_GUSBCFG_SRPCAP = 0x100
	// Position of HNPCAP field.
	USB_OTG_FS_GUSBCFG_HNPCAP_Pos = 0x9
	// Bit mask of HNPCAP field.
	USB_OTG_FS_GUSBCFG_HNPCAP_Msk = 0x200
	// Bit HNPCAP.
	USB_OTG_FS_GUSBCFG_HNPCAP = 0x200
	// Position of TRDT field.
	USB_OTG_FS_GUSBCFG_TRDT_Pos = 0xa
	// Bit mask of TRDT field.
	USB_OTG_FS_GUSBCFG_TRDT_Msk = 0x3c00
	// Position of FHMOD field.
	USB_OTG_FS_GUSBCFG_FHMOD_Pos = 0x1d
	// Bit mask of FHMOD field.
	USB_OTG_FS_GUSBCFG_FHMOD_Msk = 0x20000000
	// Bit FHMOD.
	USB_OTG_FS_GUSBCFG_FHMOD = 0x20000000
	// Position of FDMOD field.
	USB_OTG_FS_GUSBCFG_FDMOD_Pos = 0x1e
	// Bit mask of FDMOD field.
	USB_OTG_FS_GUSBCFG_FDMOD_Msk = 0x40000000
	// Bit FDMOD.
	USB_OTG_FS_GUSBCFG_FDMOD = 0x40000000
	// Position of CTXPKT field.
	USB_OTG_FS_GUSBCFG_CTXPKT_Pos = 0x1f
	// Bit mask of CTXPKT field.
	USB_OTG_FS_GUSBCFG_CTXPKT_Msk = 0x80000000
	// Bit CTXPKT.
	USB_OTG_FS_GUSBCFG_CTXPKT = 0x80000000

	// GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
	// Position of CSRST field.
	USB_OTG_FS_GRSTCTL_CSRST_Pos = 0x0
	// Bit mask of CSRST field.
	USB_OTG_FS_GRSTCTL_CSRST_Msk = 0x1
	// Bit CSRST.
	USB_OTG_FS_GRSTCTL_CSRST = 0x1
	// Position of HSRST field.
	USB_OTG_FS_GRSTCTL_HSRST_Pos = 0x1
	// Bit mask of HSRST field.
	USB_OTG_FS_GRSTCTL_HSRST_Msk = 0x2
	// Bit HSRST.
	USB_OTG_FS_GRSTCTL_HSRST = 0x2
	// Position of FCRST field.
	USB_OTG_FS_GRSTCTL_FCRST_Pos = 0x2
	// Bit mask of FCRST field.
	USB_OTG_FS_GRSTCTL_FCRST_Msk = 0x4
	// Bit FCRST.
	USB_OTG_FS_GRSTCTL_FCRST = 0x4
	// Position of RXFFLSH field.
	USB_OTG_FS_GRSTCTL_RXFFLSH_Pos = 0x4
	// Bit mask of RXFFLSH field.
	USB_OTG_FS_GRSTCTL_RXFFLSH_Msk = 0x10
	// Bit RXFFLSH.
	USB_OTG_FS_GRSTCTL_RXFFLSH = 0x10
	// Position of TXFFLSH field.
	USB_OTG_FS_GRSTCTL_TXFFLSH_Pos = 0x5
	// Bit mask of TXFFLSH field.
	USB_OTG_FS_GRSTCTL_TXFFLSH_Msk = 0x20
	// Bit TXFFLSH.
	USB_OTG_FS_GRSTCTL_TXFFLSH = 0x20
	// Position of TXFNUM field.
	USB_OTG_FS_GRSTCTL_TXFNUM_Pos = 0x6
	// Bit mask of TXFNUM field.
	USB_OTG_FS_GRSTCTL_TXFNUM_Msk = 0x7c0
	// Position of AHBIDL field.
	USB_OTG_FS_GRSTCTL_AHBIDL_Pos = 0x1f
	// Bit mask of AHBIDL field.
	USB_OTG_FS_GRSTCTL_AHBIDL_Msk = 0x80000000
	// Bit AHBIDL.
	USB_OTG_FS_GRSTCTL_AHBIDL = 0x80000000

	// GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
	// Position of CMOD field.
	USB_OTG_FS_GINTSTS_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	USB_OTG_FS_GINTSTS_CMOD_Msk = 0x1
	// Bit CMOD.
	USB_OTG_FS_GINTSTS_CMOD = 0x1
	// Position of MMIS field.
	USB_OTG_FS_GINTSTS_MMIS_Pos = 0x1
	// Bit mask of MMIS field.
	USB_OTG_FS_GINTSTS_MMIS_Msk = 0x2
	// Bit MMIS.
	USB_OTG_FS_GINTSTS_MMIS = 0x2
	// Position of OTGINT field.
	USB_OTG_FS_GINTSTS_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_FS_GINTSTS_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_FS_GINTSTS_OTGINT = 0x4
	// Position of SOF field.
	USB_OTG_FS_GINTSTS_SOF_Pos = 0x3
	// Bit mask of SOF field.
	USB_OTG_FS_GINTSTS_SOF_Msk = 0x8
	// Bit SOF.
	USB_OTG_FS_GINTSTS_SOF = 0x8
	// Position of RXFLVL field.
	USB_OTG_FS_GINTSTS_RXFLVL_Pos = 0x4
	// Bit mask of RXFLVL field.
	USB_OTG_FS_GINTSTS_RXFLVL_Msk = 0x10
	// Bit RXFLVL.
	USB_OTG_FS_GINTSTS_RXFLVL = 0x10
	// Position of NPTXFE field.
	USB_OTG_FS_GINTSTS_NPTXFE_Pos = 0x5
	// Bit mask of NPTXFE field.
	USB_OTG_FS_GINTSTS_NPTXFE_Msk = 0x20
	// Bit NPTXFE.
	USB_OTG_FS_GINTSTS_NPTXFE = 0x20
	// Position of GINAKEFF field.
	USB_OTG_FS_GINTSTS_GINAKEFF_Pos = 0x6
	// Bit mask of GINAKEFF field.
	USB_OTG_FS_GINTSTS_GINAKEFF_Msk = 0x40
	// Bit GINAKEFF.
	USB_OTG_FS_GINTSTS_GINAKEFF = 0x40
	// Position of GOUTNAKEFF field.
	USB_OTG_FS_GINTSTS_GOUTNAKEFF_Pos = 0x7
	// Bit mask of GOUTNAKEFF field.
	USB_OTG_FS_GINTSTS_GOUTNAKEFF_Msk = 0x80
	// Bit GOUTNAKEFF.
	USB_OTG_FS_GINTSTS_GOUTNAKEFF = 0x80
	// Position of ESUSP field.
	USB_OTG_FS_GINTSTS_ESUSP_Pos = 0xa
	// Bit mask of ESUSP field.
	USB_OTG_FS_GINTSTS_ESUSP_Msk = 0x400
	// Bit ESUSP.
	USB_OTG_FS_GINTSTS_ESUSP = 0x400
	// Position of USBSUSP field.
	USB_OTG_FS_GINTSTS_USBSUSP_Pos = 0xb
	// Bit mask of USBSUSP field.
	USB_OTG_FS_GINTSTS_USBSUSP_Msk = 0x800
	// Bit USBSUSP.
	USB_OTG_FS_GINTSTS_USBSUSP = 0x800
	// Position of USBRST field.
	USB_OTG_FS_GINTSTS_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_FS_GINTSTS_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_FS_GINTSTS_USBRST = 0x1000
	// Position of ENUMDNE field.
	USB_OTG_FS_GINTSTS_ENUMDNE_Pos = 0xd
	// Bit mask of ENUMDNE field.
	USB_OTG_FS_GINTSTS_ENUMDNE_Msk = 0x2000
	// Bit ENUMDNE.
	USB_OTG_FS_GINTSTS_ENUMDNE = 0x2000
	// Position of ISOODRP field.
	USB_OTG_FS_GINTSTS_ISOODRP_Pos = 0xe
	// Bit mask of ISOODRP field.
	USB_OTG_FS_GINTSTS_ISOODRP_Msk = 0x4000
	// Bit ISOODRP.
	USB_OTG_FS_GINTSTS_ISOODRP = 0x4000
	// Position of EOPF field.
	USB_OTG_FS_GINTSTS_EOPF_Pos = 0xf
	// Bit mask of EOPF field.
	USB_OTG_FS_GINTSTS_EOPF_Msk = 0x8000
	// Bit EOPF.
	USB_OTG_FS_GINTSTS_EOPF = 0x8000
	// Position of IEPINT field.
	USB_OTG_FS_GINTSTS_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_FS_GINTSTS_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_FS_GINTSTS_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_FS_GINTSTS_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_FS_GINTSTS_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_FS_GINTSTS_OEPINT = 0x80000
	// Position of IISOIXFR field.
	USB_OTG_FS_GINTSTS_IISOIXFR_Pos = 0x14
	// Bit mask of IISOIXFR field.
	USB_OTG_FS_GINTSTS_IISOIXFR_Msk = 0x100000
	// Bit IISOIXFR.
	USB_OTG_FS_GINTSTS_IISOIXFR = 0x100000
	// Position of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Pos = 0x15
	// Bit mask of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Msk = 0x200000
	// Bit IPXFR_INCOMPISOOUT.
	USB_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT = 0x200000
	// Position of HPRTINT field.
	USB_OTG_FS_GINTSTS_HPRTINT_Pos = 0x18
	// Bit mask of HPRTINT field.
	USB_OTG_FS_GINTSTS_HPRTINT_Msk = 0x1000000
	// Bit HPRTINT.
	USB_OTG_FS_GINTSTS_HPRTINT = 0x1000000
	// Position of HCINT field.
	USB_OTG_FS_GINTSTS_HCINT_Pos = 0x19
	// Bit mask of HCINT field.
	USB_OTG_FS_GINTSTS_HCINT_Msk = 0x2000000
	// Bit HCINT.
	USB_OTG_FS_GINTSTS_HCINT = 0x2000000
	// Position of PTXFE field.
	USB_OTG_FS_GINTSTS_PTXFE_Pos = 0x1a
	// Bit mask of PTXFE field.
	USB_OTG_FS_GINTSTS_PTXFE_Msk = 0x4000000
	// Bit PTXFE.
	USB_OTG_FS_GINTSTS_PTXFE = 0x4000000
	// Position of CIDSCHG field.
	USB_OTG_FS_GINTSTS_CIDSCHG_Pos = 0x1c
	// Bit mask of CIDSCHG field.
	USB_OTG_FS_GINTSTS_CIDSCHG_Msk = 0x10000000
	// Bit CIDSCHG.
	USB_OTG_FS_GINTSTS_CIDSCHG = 0x10000000
	// Position of DISCINT field.
	USB_OTG_FS_GINTSTS_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_FS_GINTSTS_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_FS_GINTSTS_DISCINT = 0x20000000
	// Position of SRQINT field.
	USB_OTG_FS_GINTSTS_SRQINT_Pos = 0x1e
	// Bit mask of SRQINT field.
	USB_OTG_FS_GINTSTS_SRQINT_Msk = 0x40000000
	// Bit SRQINT.
	USB_OTG_FS_GINTSTS_SRQINT = 0x40000000
	// Position of WKUPINT field.
	USB_OTG_FS_GINTSTS_WKUPINT_Pos = 0x1f
	// Bit mask of WKUPINT field.
	USB_OTG_FS_GINTSTS_WKUPINT_Msk = 0x80000000
	// Bit WKUPINT.
	USB_OTG_FS_GINTSTS_WKUPINT = 0x80000000

	// GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
	// Position of MMISM field.
	USB_OTG_FS_GINTMSK_MMISM_Pos = 0x1
	// Bit mask of MMISM field.
	USB_OTG_FS_GINTMSK_MMISM_Msk = 0x2
	// Bit MMISM.
	USB_OTG_FS_GINTMSK_MMISM = 0x2
	// Position of OTGINT field.
	USB_OTG_FS_GINTMSK_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_FS_GINTMSK_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_FS_GINTMSK_OTGINT = 0x4
	// Position of SOFM field.
	USB_OTG_FS_GINTMSK_SOFM_Pos = 0x3
	// Bit mask of SOFM field.
	USB_OTG_FS_GINTMSK_SOFM_Msk = 0x8
	// Bit SOFM.
	USB_OTG_FS_GINTMSK_SOFM = 0x8
	// Position of RXFLVLM field.
	USB_OTG_FS_GINTMSK_RXFLVLM_Pos = 0x4
	// Bit mask of RXFLVLM field.
	USB_OTG_FS_GINTMSK_RXFLVLM_Msk = 0x10
	// Bit RXFLVLM.
	USB_OTG_FS_GINTMSK_RXFLVLM = 0x10
	// Position of NPTXFEM field.
	USB_OTG_FS_GINTMSK_NPTXFEM_Pos = 0x5
	// Bit mask of NPTXFEM field.
	USB_OTG_FS_GINTMSK_NPTXFEM_Msk = 0x20
	// Bit NPTXFEM.
	USB_OTG_FS_GINTMSK_NPTXFEM = 0x20
	// Position of GINAKEFFM field.
	USB_OTG_FS_GINTMSK_GINAKEFFM_Pos = 0x6
	// Bit mask of GINAKEFFM field.
	USB_OTG_FS_GINTMSK_GINAKEFFM_Msk = 0x40
	// Bit GINAKEFFM.
	USB_OTG_FS_GINTMSK_GINAKEFFM = 0x40
	// Position of GONAKEFFM field.
	USB_OTG_FS_GINTMSK_GONAKEFFM_Pos = 0x7
	// Bit mask of GONAKEFFM field.
	USB_OTG_FS_GINTMSK_GONAKEFFM_Msk = 0x80
	// Bit GONAKEFFM.
	USB_OTG_FS_GINTMSK_GONAKEFFM = 0x80
	// Position of ESUSPM field.
	USB_OTG_FS_GINTMSK_ESUSPM_Pos = 0xa
	// Bit mask of ESUSPM field.
	USB_OTG_FS_GINTMSK_ESUSPM_Msk = 0x400
	// Bit ESUSPM.
	USB_OTG_FS_GINTMSK_ESUSPM = 0x400
	// Position of USBSUSPM field.
	USB_OTG_FS_GINTMSK_USBSUSPM_Pos = 0xb
	// Bit mask of USBSUSPM field.
	USB_OTG_FS_GINTMSK_USBSUSPM_Msk = 0x800
	// Bit USBSUSPM.
	USB_OTG_FS_GINTMSK_USBSUSPM = 0x800
	// Position of USBRST field.
	USB_OTG_FS_GINTMSK_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_FS_GINTMSK_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_FS_GINTMSK_USBRST = 0x1000
	// Position of ENUMDNEM field.
	USB_OTG_FS_GINTMSK_ENUMDNEM_Pos = 0xd
	// Bit mask of ENUMDNEM field.
	USB_OTG_FS_GINTMSK_ENUMDNEM_Msk = 0x2000
	// Bit ENUMDNEM.
	USB_OTG_FS_GINTMSK_ENUMDNEM = 0x2000
	// Position of ISOODRPM field.
	USB_OTG_FS_GINTMSK_ISOODRPM_Pos = 0xe
	// Bit mask of ISOODRPM field.
	USB_OTG_FS_GINTMSK_ISOODRPM_Msk = 0x4000
	// Bit ISOODRPM.
	USB_OTG_FS_GINTMSK_ISOODRPM = 0x4000
	// Position of EOPFM field.
	USB_OTG_FS_GINTMSK_EOPFM_Pos = 0xf
	// Bit mask of EOPFM field.
	USB_OTG_FS_GINTMSK_EOPFM_Msk = 0x8000
	// Bit EOPFM.
	USB_OTG_FS_GINTMSK_EOPFM = 0x8000
	// Position of EPMISM field.
	USB_OTG_FS_GINTMSK_EPMISM_Pos = 0x11
	// Bit mask of EPMISM field.
	USB_OTG_FS_GINTMSK_EPMISM_Msk = 0x20000
	// Bit EPMISM.
	USB_OTG_FS_GINTMSK_EPMISM = 0x20000
	// Position of IEPINT field.
	USB_OTG_FS_GINTMSK_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_FS_GINTMSK_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_FS_GINTMSK_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_FS_GINTMSK_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_FS_GINTMSK_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_FS_GINTMSK_OEPINT = 0x80000
	// Position of IISOIXFRM field.
	USB_OTG_FS_GINTMSK_IISOIXFRM_Pos = 0x14
	// Bit mask of IISOIXFRM field.
	USB_OTG_FS_GINTMSK_IISOIXFRM_Msk = 0x100000
	// Bit IISOIXFRM.
	USB_OTG_FS_GINTMSK_IISOIXFRM = 0x100000
	// Position of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Pos = 0x15
	// Bit mask of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Msk = 0x200000
	// Bit IPXFRM_IISOOXFRM.
	USB_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM = 0x200000
	// Position of PRTIM field.
	USB_OTG_FS_GINTMSK_PRTIM_Pos = 0x18
	// Bit mask of PRTIM field.
	USB_OTG_FS_GINTMSK_PRTIM_Msk = 0x1000000
	// Bit PRTIM.
	USB_OTG_FS_GINTMSK_PRTIM = 0x1000000
	// Position of HCIM field.
	USB_OTG_FS_GINTMSK_HCIM_Pos = 0x19
	// Bit mask of HCIM field.
	USB_OTG_FS_GINTMSK_HCIM_Msk = 0x2000000
	// Bit HCIM.
	USB_OTG_FS_GINTMSK_HCIM = 0x2000000
	// Position of PTXFEM field.
	USB_OTG_FS_GINTMSK_PTXFEM_Pos = 0x1a
	// Bit mask of PTXFEM field.
	USB_OTG_FS_GINTMSK_PTXFEM_Msk = 0x4000000
	// Bit PTXFEM.
	USB_OTG_FS_GINTMSK_PTXFEM = 0x4000000
	// Position of CIDSCHGM field.
	USB_OTG_FS_GINTMSK_CIDSCHGM_Pos = 0x1c
	// Bit mask of CIDSCHGM field.
	USB_OTG_FS_GINTMSK_CIDSCHGM_Msk = 0x10000000
	// Bit CIDSCHGM.
	USB_OTG_FS_GINTMSK_CIDSCHGM = 0x10000000
	// Position of DISCINT field.
	USB_OTG_FS_GINTMSK_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_FS_GINTMSK_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_FS_GINTMSK_DISCINT = 0x20000000
	// Position of SRQIM field.
	USB_OTG_FS_GINTMSK_SRQIM_Pos = 0x1e
	// Bit mask of SRQIM field.
	USB_OTG_FS_GINTMSK_SRQIM_Msk = 0x40000000
	// Bit SRQIM.
	USB_OTG_FS_GINTMSK_SRQIM = 0x40000000
	// Position of WUIM field.
	USB_OTG_FS_GINTMSK_WUIM_Pos = 0x1f
	// Bit mask of WUIM field.
	USB_OTG_FS_GINTMSK_WUIM_Msk = 0x80000000
	// Bit WUIM.
	USB_OTG_FS_GINTMSK_WUIM = 0x80000000

	// GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
	// Position of EPNUM field.
	USB_OTG_FS_GRXSTSR_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_FS_GRXSTSR_Device_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_GRXSTSR_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_GRXSTSR_Device_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_GRXSTSR_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_GRXSTSR_Device_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_GRXSTSR_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_GRXSTSR_Device_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_FS_GRXSTSR_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_FS_GRXSTSR_Device_FRMNUM_Msk = 0x1e00000

	// GRXSTSR_Host: OTG_FS Receive status debug read(Host mode)
	// Position of EPNUM field.
	USB_OTG_FS_GRXSTSR_Host_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_FS_GRXSTSR_Host_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_GRXSTSR_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_GRXSTSR_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_GRXSTSR_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_GRXSTSR_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_GRXSTSR_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_FS_GRXSTSR_Host_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_FS_GRXSTSR_Host_FRMNUM_Msk = 0x1e00000

	// GRXSTSP_Device: OTG status read and pop (device mode)
	// Position of STSPHST field.
	USB_OTG_FS_GRXSTSP_Device_STSPHST_Pos = 0x1b
	// Bit mask of STSPHST field.
	USB_OTG_FS_GRXSTSP_Device_STSPHST_Msk = 0x8000000
	// Bit STSPHST.
	USB_OTG_FS_GRXSTSP_Device_STSPHST = 0x8000000
	// Position of FRMNUM field.
	USB_OTG_FS_GRXSTSP_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_FS_GRXSTSP_Device_FRMNUM_Msk = 0x1e00000
	// Position of PKTSTS field.
	USB_OTG_FS_GRXSTSP_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_GRXSTSP_Device_PKTSTS_Msk = 0x1e0000
	// Position of DPID field.
	USB_OTG_FS_GRXSTSP_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_GRXSTSP_Device_DPID_Msk = 0x18000
	// Position of BCNT field.
	USB_OTG_FS_GRXSTSP_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_GRXSTSP_Device_BCNT_Msk = 0x7ff0
	// Position of EPNUM field.
	USB_OTG_FS_GRXSTSP_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_FS_GRXSTSP_Device_EPNUM_Msk = 0xf

	// GRXSTSP_Host: OTG status read and pop (host mode)
	// Position of PKTSTS field.
	USB_OTG_FS_GRXSTSP_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000
	// Position of DPID field.
	USB_OTG_FS_GRXSTSP_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_GRXSTSP_Host_DPID_Msk = 0x18000
	// Position of BCNT field.
	USB_OTG_FS_GRXSTSP_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_GRXSTSP_Host_BCNT_Msk = 0x7ff0
	// Position of CHNUM field.
	USB_OTG_FS_GRXSTSP_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_FS_GRXSTSP_Host_CHNUM_Msk = 0xf

	// GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
	// Position of RXFD field.
	USB_OTG_FS_GRXFSIZ_RXFD_Pos = 0x0
	// Bit mask of RXFD field.
	USB_OTG_FS_GRXFSIZ_RXFD_Msk = 0xffff

	// DIEPTXF0: OTG_FS non-periodic transmit FIFO size register (Device mode)
	// Position of TX0FSA field.
	USB_OTG_FS_DIEPTXF0_TX0FSA_Pos = 0x0
	// Bit mask of TX0FSA field.
	USB_OTG_FS_DIEPTXF0_TX0FSA_Msk = 0xffff
	// Position of TX0FD field.
	USB_OTG_FS_DIEPTXF0_TX0FD_Pos = 0x10
	// Bit mask of TX0FD field.
	USB_OTG_FS_DIEPTXF0_TX0FD_Msk = 0xffff0000

	// HNPTXFSIZ: OTG_FS non-periodic transmit FIFO size register (Host mode)
	// Position of NPTXFSA field.
	USB_OTG_FS_HNPTXFSIZ_NPTXFSA_Pos = 0x0
	// Bit mask of NPTXFSA field.
	USB_OTG_FS_HNPTXFSIZ_NPTXFSA_Msk = 0xffff
	// Position of NPTXFD field.
	USB_OTG_FS_HNPTXFSIZ_NPTXFD_Pos = 0x10
	// Bit mask of NPTXFD field.
	USB_OTG_FS_HNPTXFSIZ_NPTXFD_Msk = 0xffff0000

	// GNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
	// Position of NPTXFSAV field.
	USB_OTG_FS_GNPTXSTS_NPTXFSAV_Pos = 0x0
	// Bit mask of NPTXFSAV field.
	USB_OTG_FS_GNPTXSTS_NPTXFSAV_Msk = 0xffff
	// Position of NPTQXSAV field.
	USB_OTG_FS_GNPTXSTS_NPTQXSAV_Pos = 0x10
	// Bit mask of NPTQXSAV field.
	USB_OTG_FS_GNPTXSTS_NPTQXSAV_Msk = 0xff0000
	// Position of NPTXQTOP field.
	USB_OTG_FS_GNPTXSTS_NPTXQTOP_Pos = 0x18
	// Bit mask of NPTXQTOP field.
	USB_OTG_FS_GNPTXSTS_NPTXQTOP_Msk = 0x7f000000

	// GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
	// Position of PWRDWN field.
	USB_OTG_FS_GCCFG_PWRDWN_Pos = 0x10
	// Bit mask of PWRDWN field.
	USB_OTG_FS_GCCFG_PWRDWN_Msk = 0x10000
	// Bit PWRDWN.
	USB_OTG_FS_GCCFG_PWRDWN = 0x10000
	// Position of VBUSASEN field.
	USB_OTG_FS_GCCFG_VBUSASEN_Pos = 0x12
	// Bit mask of VBUSASEN field.
	USB_OTG_FS_GCCFG_VBUSASEN_Msk = 0x40000
	// Bit VBUSASEN.
	USB_OTG_FS_GCCFG_VBUSASEN = 0x40000
	// Position of VBUSBSEN field.
	USB_OTG_FS_GCCFG_VBUSBSEN_Pos = 0x13
	// Bit mask of VBUSBSEN field.
	USB_OTG_FS_GCCFG_VBUSBSEN_Msk = 0x80000
	// Bit VBUSBSEN.
	USB_OTG_FS_GCCFG_VBUSBSEN = 0x80000
	// Position of SOFOUTEN field.
	USB_OTG_FS_GCCFG_SOFOUTEN_Pos = 0x14
	// Bit mask of SOFOUTEN field.
	USB_OTG_FS_GCCFG_SOFOUTEN_Msk = 0x100000
	// Bit SOFOUTEN.
	USB_OTG_FS_GCCFG_SOFOUTEN = 0x100000

	// OTG_CID: core ID register
	// Position of PRODUCT_ID field.
	USB_OTG_FS_OTG_CID_PRODUCT_ID_Pos = 0x0
	// Bit mask of PRODUCT_ID field.
	USB_OTG_FS_OTG_CID_PRODUCT_ID_Msk = 0xffffffff

	// HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
	// Position of PTXSA field.
	USB_OTG_FS_HPTXFSIZ_PTXSA_Pos = 0x0
	// Bit mask of PTXSA field.
	USB_OTG_FS_HPTXFSIZ_PTXSA_Msk = 0xffff
	// Position of PTXFSIZ field.
	USB_OTG_FS_HPTXFSIZ_PTXFSIZ_Pos = 0x10
	// Bit mask of PTXFSIZ field.
	USB_OTG_FS_HPTXFSIZ_PTXFSIZ_Msk = 0xffff0000

	// DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
	// Position of INEPTXSA field.
	USB_OTG_FS_DIEPTXF_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_DIEPTXF_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_DIEPTXF_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_DIEPTXF_INEPTXFD_Msk = 0xffff0000
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO 0 register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: mailbox data high register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB field.
	CAN_FB_FR1_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR1_FB_Msk = 0xffffffff

	// FB.FR2: Filter bank 0 register 2
	// Position of FB field.
	CAN_FB_FR2_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR2_FB_Msk = 0xffffffff
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000

	// IPR18: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000

	// IPR19: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000

	// IPR20: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Msk = 0xff000000
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	FLASH_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0x7
	// 0 wait states
	FLASH_ACR_LATENCY_WS0 = 0x0
	// 1 wait states
	FLASH_ACR_LATENCY_WS1 = 0x1
	// 2 wait states
	FLASH_ACR_LATENCY_WS2 = 0x2
	// 3 wait states
	FLASH_ACR_LATENCY_WS3 = 0x3
	// 4 wait states
	FLASH_ACR_LATENCY_WS4 = 0x4
	// 5 wait states
	FLASH_ACR_LATENCY_WS5 = 0x5
	// 6 wait states
	FLASH_ACR_LATENCY_WS6 = 0x6
	// 7 wait states
	FLASH_ACR_LATENCY_WS7 = 0x7
	// 8 wait states
	FLASH_ACR_LATENCY_WS8 = 0x8
	// 9 wait states
	FLASH_ACR_LATENCY_WS9 = 0x9
	// 10 wait states
	FLASH_ACR_LATENCY_WS10 = 0xa
	// 11 wait states
	FLASH_ACR_LATENCY_WS11 = 0xb
	// 12 wait states
	FLASH_ACR_LATENCY_WS12 = 0xc
	// 13 wait states
	FLASH_ACR_LATENCY_WS13 = 0xd
	// 14 wait states
	FLASH_ACR_LATENCY_WS14 = 0xe
	// 15 wait states
	FLASH_ACR_LATENCY_WS15 = 0xf
	// Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	FLASH_ACR_PRFTEN = 0x100
	// Prefetch is disabled
	FLASH_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	FLASH_ACR_PRFTEN_Enabled = 0x1
	// Position of ICEN field.
	FLASH_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	FLASH_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	FLASH_ACR_ICEN = 0x200
	// Instruction cache is disabled
	FLASH_ACR_ICEN_Disabled = 0x0
	// Instruction cache is enabled
	FLASH_ACR_ICEN_Enabled = 0x1
	// Position of DCEN field.
	FLASH_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	FLASH_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	FLASH_ACR_DCEN = 0x400
	// Data cache is disabled
	FLASH_ACR_DCEN_Disabled = 0x0
	// Data cache is enabled
	FLASH_ACR_DCEN_Enabled = 0x1
	// Position of ICRST field.
	FLASH_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	FLASH_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	FLASH_ACR_ICRST = 0x800
	// Instruction cache is not reset
	FLASH_ACR_ICRST_NotReset = 0x0
	// Instruction cache is reset
	FLASH_ACR_ICRST_Reset = 0x1
	// Position of DCRST field.
	FLASH_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	FLASH_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	FLASH_ACR_DCRST = 0x1000
	// Data cache is not reset
	FLASH_ACR_DCRST_NotReset = 0x0
	// Data cache is reset
	FLASH_ACR_DCRST_Reset = 0x1

	// KEYR: Flash key register
	// Position of KEY field.
	FLASH_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	FLASH_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	FLASH_SR_EOP_Msk = 0x1
	// Bit EOP.
	FLASH_SR_EOP = 0x1
	// Position of OPERR field.
	FLASH_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	FLASH_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	FLASH_SR_OPERR = 0x2
	// Position of WRPERR field.
	FLASH_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	FLASH_SR_WRPERR = 0x10
	// Position of PGAERR field.
	FLASH_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	FLASH_SR_PGAERR = 0x20
	// Position of PGPERR field.
	FLASH_SR_PGPERR_Pos = 0x6
	// Bit mask of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40
	// Bit PGPERR.
	FLASH_SR_PGPERR = 0x40
	// Position of PGSERR field.
	FLASH_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	FLASH_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	FLASH_SR_PGSERR = 0x80
	// Position of RDERR field.
	FLASH_SR_RDERR_Pos = 0x8
	// Bit mask of RDERR field.
	FLASH_SR_RDERR_Msk = 0x100
	// Bit RDERR.
	FLASH_SR_RDERR = 0x100
	// Position of BSY field.
	FLASH_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	FLASH_SR_BSY_Msk = 0x10000
	// Bit BSY.
	FLASH_SR_BSY = 0x10000

	// CR: Control register
	// Position of PG field.
	FLASH_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	FLASH_CR_PG_Msk = 0x1
	// Bit PG.
	FLASH_CR_PG = 0x1
	// Flash programming activated
	FLASH_CR_PG_Program = 0x1
	// Position of SER field.
	FLASH_CR_SER_Pos = 0x1
	// Bit mask of SER field.
	FLASH_CR_SER_Msk = 0x2
	// Bit SER.
	FLASH_CR_SER = 0x2
	// Erase activated for selected sector
	FLASH_CR_SER_SectorErase = 0x1
	// Position of MER field.
	FLASH_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	FLASH_CR_MER_Msk = 0x4
	// Bit MER.
	FLASH_CR_MER = 0x4
	// Erase activated for all user sectors
	FLASH_CR_MER_MassErase = 0x1
	// Position of SNB field.
	FLASH_CR_SNB_Pos = 0x3
	// Bit mask of SNB field.
	FLASH_CR_SNB_Msk = 0x78
	// Position of PSIZE field.
	FLASH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300
	// Program x8
	FLASH_CR_PSIZE_PSIZE8 = 0x0
	// Program x16
	FLASH_CR_PSIZE_PSIZE16 = 0x1
	// Program x32
	FLASH_CR_PSIZE_PSIZE32 = 0x2
	// Program x64
	FLASH_CR_PSIZE_PSIZE64 = 0x3
	// Position of STRT field.
	FLASH_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	FLASH_CR_STRT_Msk = 0x10000
	// Bit STRT.
	FLASH_CR_STRT = 0x10000
	// Trigger an erase operation
	FLASH_CR_STRT_Start = 0x1
	// Position of EOPIE field.
	FLASH_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	FLASH_CR_EOPIE = 0x1000000
	// End of operation interrupt disabled
	FLASH_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	FLASH_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	FLASH_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	FLASH_CR_ERRIE = 0x2000000
	// Error interrupt generation disabled
	FLASH_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	FLASH_CR_ERRIE_Enabled = 0x1
	// Position of LOCK field.
	FLASH_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	FLASH_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	FLASH_CR_LOCK = 0x80000000
	// FLASH_CR register is unlocked
	FLASH_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	FLASH_CR_LOCK_Locked = 0x1

	// OPTCR: Flash option control register
	// Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Pos = 0x0
	// Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk = 0x1
	// Bit OPTLOCK.
	FLASH_OPTCR_OPTLOCK = 0x1
	// Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Pos = 0x1
	// Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk = 0x2
	// Bit OPTSTRT.
	FLASH_OPTCR_OPTSTRT = 0x2
	// Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Pos = 0x2
	// Bit mask of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk = 0xc
	// Position of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Pos = 0x5
	// Bit mask of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Msk = 0x20
	// Bit WDG_SW.
	FLASH_OPTCR_WDG_SW = 0x20
	// Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Pos = 0x6
	// Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk = 0x40
	// Bit NRST_STOP.
	FLASH_OPTCR_NRST_STOP = 0x40
	// Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7
	// Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80
	// Bit NRST_STDBY.
	FLASH_OPTCR_NRST_STDBY = 0x80
	// Position of RDP field.
	FLASH_OPTCR_RDP_Pos = 0x8
	// Bit mask of RDP field.
	FLASH_OPTCR_RDP_Msk = 0xff00
	// Position of NWRP field.
	FLASH_OPTCR_NWRP_Pos = 0x10
	// Bit mask of NWRP field.
	FLASH_OPTCR_NWRP_Msk = 0xff0000
	// Position of SPRMOD field.
	FLASH_OPTCR_SPRMOD_Pos = 0x1f
	// Bit mask of SPRMOD field.
	FLASH_OPTCR_SPRMOD_Msk = 0x80000000
	// Bit SPRMOD.
	FLASH_OPTCR_SPRMOD = 0x80000000
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR22_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR22_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR22_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR22_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWIER22_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR22_Clear = 0x1
)

// Bitfields for OTG_HS_GLOBAL: USB on the go high speed
const (
	// GOTGCTL: OTG_HS control and status register
	// Position of SRQSCS field.
	USB_OTG_HS_GOTGCTL_SRQSCS_Pos = 0x0
	// Bit mask of SRQSCS field.
	USB_OTG_HS_GOTGCTL_SRQSCS_Msk = 0x1
	// Bit SRQSCS.
	USB_OTG_HS_GOTGCTL_SRQSCS = 0x1
	// Position of SRQ field.
	USB_OTG_HS_GOTGCTL_SRQ_Pos = 0x1
	// Bit mask of SRQ field.
	USB_OTG_HS_GOTGCTL_SRQ_Msk = 0x2
	// Bit SRQ.
	USB_OTG_HS_GOTGCTL_SRQ = 0x2
	// Position of HNGSCS field.
	USB_OTG_HS_GOTGCTL_HNGSCS_Pos = 0x8
	// Bit mask of HNGSCS field.
	USB_OTG_HS_GOTGCTL_HNGSCS_Msk = 0x100
	// Bit HNGSCS.
	USB_OTG_HS_GOTGCTL_HNGSCS = 0x100
	// Position of HNPRQ field.
	USB_OTG_HS_GOTGCTL_HNPRQ_Pos = 0x9
	// Bit mask of HNPRQ field.
	USB_OTG_HS_GOTGCTL_HNPRQ_Msk = 0x200
	// Bit HNPRQ.
	USB_OTG_HS_GOTGCTL_HNPRQ = 0x200
	// Position of HSHNPEN field.
	USB_OTG_HS_GOTGCTL_HSHNPEN_Pos = 0xa
	// Bit mask of HSHNPEN field.
	USB_OTG_HS_GOTGCTL_HSHNPEN_Msk = 0x400
	// Bit HSHNPEN.
	USB_OTG_HS_GOTGCTL_HSHNPEN = 0x400
	// Position of DHNPEN field.
	USB_OTG_HS_GOTGCTL_DHNPEN_Pos = 0xb
	// Bit mask of DHNPEN field.
	USB_OTG_HS_GOTGCTL_DHNPEN_Msk = 0x800
	// Bit DHNPEN.
	USB_OTG_HS_GOTGCTL_DHNPEN = 0x800
	// Position of CIDSTS field.
	USB_OTG_HS_GOTGCTL_CIDSTS_Pos = 0x10
	// Bit mask of CIDSTS field.
	USB_OTG_HS_GOTGCTL_CIDSTS_Msk = 0x10000
	// Bit CIDSTS.
	USB_OTG_HS_GOTGCTL_CIDSTS = 0x10000
	// Position of DBCT field.
	USB_OTG_HS_GOTGCTL_DBCT_Pos = 0x11
	// Bit mask of DBCT field.
	USB_OTG_HS_GOTGCTL_DBCT_Msk = 0x20000
	// Bit DBCT.
	USB_OTG_HS_GOTGCTL_DBCT = 0x20000
	// Position of ASVLD field.
	USB_OTG_HS_GOTGCTL_ASVLD_Pos = 0x12
	// Bit mask of ASVLD field.
	USB_OTG_HS_GOTGCTL_ASVLD_Msk = 0x40000
	// Bit ASVLD.
	USB_OTG_HS_GOTGCTL_ASVLD = 0x40000
	// Position of BSVLD field.
	USB_OTG_HS_GOTGCTL_BSVLD_Pos = 0x13
	// Bit mask of BSVLD field.
	USB_OTG_HS_GOTGCTL_BSVLD_Msk = 0x80000
	// Bit BSVLD.
	USB_OTG_HS_GOTGCTL_BSVLD = 0x80000

	// GOTGINT: OTG_HS interrupt register
	// Position of SEDET field.
	USB_OTG_HS_GOTGINT_SEDET_Pos = 0x2
	// Bit mask of SEDET field.
	USB_OTG_HS_GOTGINT_SEDET_Msk = 0x4
	// Bit SEDET.
	USB_OTG_HS_GOTGINT_SEDET = 0x4
	// Position of SRSSCHG field.
	USB_OTG_HS_GOTGINT_SRSSCHG_Pos = 0x8
	// Bit mask of SRSSCHG field.
	USB_OTG_HS_GOTGINT_SRSSCHG_Msk = 0x100
	// Bit SRSSCHG.
	USB_OTG_HS_GOTGINT_SRSSCHG = 0x100
	// Position of HNSSCHG field.
	USB_OTG_HS_GOTGINT_HNSSCHG_Pos = 0x9
	// Bit mask of HNSSCHG field.
	USB_OTG_HS_GOTGINT_HNSSCHG_Msk = 0x200
	// Bit HNSSCHG.
	USB_OTG_HS_GOTGINT_HNSSCHG = 0x200
	// Position of HNGDET field.
	USB_OTG_HS_GOTGINT_HNGDET_Pos = 0x11
	// Bit mask of HNGDET field.
	USB_OTG_HS_GOTGINT_HNGDET_Msk = 0x20000
	// Bit HNGDET.
	USB_OTG_HS_GOTGINT_HNGDET = 0x20000
	// Position of ADTOCHG field.
	USB_OTG_HS_GOTGINT_ADTOCHG_Pos = 0x12
	// Bit mask of ADTOCHG field.
	USB_OTG_HS_GOTGINT_ADTOCHG_Msk = 0x40000
	// Bit ADTOCHG.
	USB_OTG_HS_GOTGINT_ADTOCHG = 0x40000
	// Position of DBCDNE field.
	USB_OTG_HS_GOTGINT_DBCDNE_Pos = 0x13
	// Bit mask of DBCDNE field.
	USB_OTG_HS_GOTGINT_DBCDNE_Msk = 0x80000
	// Bit DBCDNE.
	USB_OTG_HS_GOTGINT_DBCDNE = 0x80000

	// GAHBCFG: OTG_HS AHB configuration register
	// Position of GINT field.
	USB_OTG_HS_GAHBCFG_GINT_Pos = 0x0
	// Bit mask of GINT field.
	USB_OTG_HS_GAHBCFG_GINT_Msk = 0x1
	// Bit GINT.
	USB_OTG_HS_GAHBCFG_GINT = 0x1
	// Position of HBSTLEN field.
	USB_OTG_HS_GAHBCFG_HBSTLEN_Pos = 0x1
	// Bit mask of HBSTLEN field.
	USB_OTG_HS_GAHBCFG_HBSTLEN_Msk = 0x1e
	// Position of DMAEN field.
	USB_OTG_HS_GAHBCFG_DMAEN_Pos = 0x5
	// Bit mask of DMAEN field.
	USB_OTG_HS_GAHBCFG_DMAEN_Msk = 0x20
	// Bit DMAEN.
	USB_OTG_HS_GAHBCFG_DMAEN = 0x20
	// Position of TXFELVL field.
	USB_OTG_HS_GAHBCFG_TXFELVL_Pos = 0x7
	// Bit mask of TXFELVL field.
	USB_OTG_HS_GAHBCFG_TXFELVL_Msk = 0x80
	// Bit TXFELVL.
	USB_OTG_HS_GAHBCFG_TXFELVL = 0x80
	// Position of PTXFELVL field.
	USB_OTG_HS_GAHBCFG_PTXFELVL_Pos = 0x8
	// Bit mask of PTXFELVL field.
	USB_OTG_HS_GAHBCFG_PTXFELVL_Msk = 0x100
	// Bit PTXFELVL.
	USB_OTG_HS_GAHBCFG_PTXFELVL = 0x100

	// GUSBCFG: OTG_HS USB configuration register
	// Position of TOCAL field.
	USB_OTG_HS_GUSBCFG_TOCAL_Pos = 0x0
	// Bit mask of TOCAL field.
	USB_OTG_HS_GUSBCFG_TOCAL_Msk = 0x7
	// Position of PHYSEL field.
	USB_OTG_HS_GUSBCFG_PHYSEL_Pos = 0x6
	// Bit mask of PHYSEL field.
	USB_OTG_HS_GUSBCFG_PHYSEL_Msk = 0x40
	// Bit PHYSEL.
	USB_OTG_HS_GUSBCFG_PHYSEL = 0x40
	// Position of SRPCAP field.
	USB_OTG_HS_GUSBCFG_SRPCAP_Pos = 0x8
	// Bit mask of SRPCAP field.
	USB_OTG_HS_GUSBCFG_SRPCAP_Msk = 0x100
	// Bit SRPCAP.
	USB_OTG_HS_GUSBCFG_SRPCAP = 0x100
	// Position of HNPCAP field.
	USB_OTG_HS_GUSBCFG_HNPCAP_Pos = 0x9
	// Bit mask of HNPCAP field.
	USB_OTG_HS_GUSBCFG_HNPCAP_Msk = 0x200
	// Bit HNPCAP.
	USB_OTG_HS_GUSBCFG_HNPCAP = 0x200
	// Position of TRDT field.
	USB_OTG_HS_GUSBCFG_TRDT_Pos = 0xa
	// Bit mask of TRDT field.
	USB_OTG_HS_GUSBCFG_TRDT_Msk = 0x3c00
	// Position of PHYLPCS field.
	USB_OTG_HS_GUSBCFG_PHYLPCS_Pos = 0xf
	// Bit mask of PHYLPCS field.
	USB_OTG_HS_GUSBCFG_PHYLPCS_Msk = 0x8000
	// Bit PHYLPCS.
	USB_OTG_HS_GUSBCFG_PHYLPCS = 0x8000
	// Position of ULPIFSLS field.
	USB_OTG_HS_GUSBCFG_ULPIFSLS_Pos = 0x11
	// Bit mask of ULPIFSLS field.
	USB_OTG_HS_GUSBCFG_ULPIFSLS_Msk = 0x20000
	// Bit ULPIFSLS.
	USB_OTG_HS_GUSBCFG_ULPIFSLS = 0x20000
	// Position of ULPIAR field.
	USB_OTG_HS_GUSBCFG_ULPIAR_Pos = 0x12
	// Bit mask of ULPIAR field.
	USB_OTG_HS_GUSBCFG_ULPIAR_Msk = 0x40000
	// Bit ULPIAR.
	USB_OTG_HS_GUSBCFG_ULPIAR = 0x40000
	// Position of ULPICSM field.
	USB_OTG_HS_GUSBCFG_ULPICSM_Pos = 0x13
	// Bit mask of ULPICSM field.
	USB_OTG_HS_GUSBCFG_ULPICSM_Msk = 0x80000
	// Bit ULPICSM.
	USB_OTG_HS_GUSBCFG_ULPICSM = 0x80000
	// Position of ULPIEVBUSD field.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSD_Pos = 0x14
	// Bit mask of ULPIEVBUSD field.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSD_Msk = 0x100000
	// Bit ULPIEVBUSD.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSD = 0x100000
	// Position of ULPIEVBUSI field.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSI_Pos = 0x15
	// Bit mask of ULPIEVBUSI field.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSI_Msk = 0x200000
	// Bit ULPIEVBUSI.
	USB_OTG_HS_GUSBCFG_ULPIEVBUSI = 0x200000
	// Position of TSDPS field.
	USB_OTG_HS_GUSBCFG_TSDPS_Pos = 0x16
	// Bit mask of TSDPS field.
	USB_OTG_HS_GUSBCFG_TSDPS_Msk = 0x400000
	// Bit TSDPS.
	USB_OTG_HS_GUSBCFG_TSDPS = 0x400000
	// Position of PCCI field.
	USB_OTG_HS_GUSBCFG_PCCI_Pos = 0x17
	// Bit mask of PCCI field.
	USB_OTG_HS_GUSBCFG_PCCI_Msk = 0x800000
	// Bit PCCI.
	USB_OTG_HS_GUSBCFG_PCCI = 0x800000
	// Position of PTCI field.
	USB_OTG_HS_GUSBCFG_PTCI_Pos = 0x18
	// Bit mask of PTCI field.
	USB_OTG_HS_GUSBCFG_PTCI_Msk = 0x1000000
	// Bit PTCI.
	USB_OTG_HS_GUSBCFG_PTCI = 0x1000000
	// Position of ULPIIPD field.
	USB_OTG_HS_GUSBCFG_ULPIIPD_Pos = 0x19
	// Bit mask of ULPIIPD field.
	USB_OTG_HS_GUSBCFG_ULPIIPD_Msk = 0x2000000
	// Bit ULPIIPD.
	USB_OTG_HS_GUSBCFG_ULPIIPD = 0x2000000
	// Position of FHMOD field.
	USB_OTG_HS_GUSBCFG_FHMOD_Pos = 0x1d
	// Bit mask of FHMOD field.
	USB_OTG_HS_GUSBCFG_FHMOD_Msk = 0x20000000
	// Bit FHMOD.
	USB_OTG_HS_GUSBCFG_FHMOD = 0x20000000
	// Position of FDMOD field.
	USB_OTG_HS_GUSBCFG_FDMOD_Pos = 0x1e
	// Bit mask of FDMOD field.
	USB_OTG_HS_GUSBCFG_FDMOD_Msk = 0x40000000
	// Bit FDMOD.
	USB_OTG_HS_GUSBCFG_FDMOD = 0x40000000
	// Position of CTXPKT field.
	USB_OTG_HS_GUSBCFG_CTXPKT_Pos = 0x1f
	// Bit mask of CTXPKT field.
	USB_OTG_HS_GUSBCFG_CTXPKT_Msk = 0x80000000
	// Bit CTXPKT.
	USB_OTG_HS_GUSBCFG_CTXPKT = 0x80000000

	// GRSTCTL: OTG_HS reset register
	// Position of CSRST field.
	USB_OTG_HS_GRSTCTL_CSRST_Pos = 0x0
	// Bit mask of CSRST field.
	USB_OTG_HS_GRSTCTL_CSRST_Msk = 0x1
	// Bit CSRST.
	USB_OTG_HS_GRSTCTL_CSRST = 0x1
	// Position of HSRST field.
	USB_OTG_HS_GRSTCTL_HSRST_Pos = 0x1
	// Bit mask of HSRST field.
	USB_OTG_HS_GRSTCTL_HSRST_Msk = 0x2
	// Bit HSRST.
	USB_OTG_HS_GRSTCTL_HSRST = 0x2
	// Position of FCRST field.
	USB_OTG_HS_GRSTCTL_FCRST_Pos = 0x2
	// Bit mask of FCRST field.
	USB_OTG_HS_GRSTCTL_FCRST_Msk = 0x4
	// Bit FCRST.
	USB_OTG_HS_GRSTCTL_FCRST = 0x4
	// Position of RXFFLSH field.
	USB_OTG_HS_GRSTCTL_RXFFLSH_Pos = 0x4
	// Bit mask of RXFFLSH field.
	USB_OTG_HS_GRSTCTL_RXFFLSH_Msk = 0x10
	// Bit RXFFLSH.
	USB_OTG_HS_GRSTCTL_RXFFLSH = 0x10
	// Position of TXFFLSH field.
	USB_OTG_HS_GRSTCTL_TXFFLSH_Pos = 0x5
	// Bit mask of TXFFLSH field.
	USB_OTG_HS_GRSTCTL_TXFFLSH_Msk = 0x20
	// Bit TXFFLSH.
	USB_OTG_HS_GRSTCTL_TXFFLSH = 0x20
	// Position of TXFNUM field.
	USB_OTG_HS_GRSTCTL_TXFNUM_Pos = 0x6
	// Bit mask of TXFNUM field.
	USB_OTG_HS_GRSTCTL_TXFNUM_Msk = 0x7c0
	// Position of DMAREQ field.
	USB_OTG_HS_GRSTCTL_DMAREQ_Pos = 0x1e
	// Bit mask of DMAREQ field.
	USB_OTG_HS_GRSTCTL_DMAREQ_Msk = 0x40000000
	// Bit DMAREQ.
	USB_OTG_HS_GRSTCTL_DMAREQ = 0x40000000
	// Position of AHBIDL field.
	USB_OTG_HS_GRSTCTL_AHBIDL_Pos = 0x1f
	// Bit mask of AHBIDL field.
	USB_OTG_HS_GRSTCTL_AHBIDL_Msk = 0x80000000
	// Bit AHBIDL.
	USB_OTG_HS_GRSTCTL_AHBIDL = 0x80000000

	// GINTSTS: OTG_HS core interrupt register
	// Position of CMOD field.
	USB_OTG_HS_GINTSTS_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	USB_OTG_HS_GINTSTS_CMOD_Msk = 0x1
	// Bit CMOD.
	USB_OTG_HS_GINTSTS_CMOD = 0x1
	// Position of MMIS field.
	USB_OTG_HS_GINTSTS_MMIS_Pos = 0x1
	// Bit mask of MMIS field.
	USB_OTG_HS_GINTSTS_MMIS_Msk = 0x2
	// Bit MMIS.
	USB_OTG_HS_GINTSTS_MMIS = 0x2
	// Position of OTGINT field.
	USB_OTG_HS_GINTSTS_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_HS_GINTSTS_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_HS_GINTSTS_OTGINT = 0x4
	// Position of SOF field.
	USB_OTG_HS_GINTSTS_SOF_Pos = 0x3
	// Bit mask of SOF field.
	USB_OTG_HS_GINTSTS_SOF_Msk = 0x8
	// Bit SOF.
	USB_OTG_HS_GINTSTS_SOF = 0x8
	// Position of RXFLVL field.
	USB_OTG_HS_GINTSTS_RXFLVL_Pos = 0x4
	// Bit mask of RXFLVL field.
	USB_OTG_HS_GINTSTS_RXFLVL_Msk = 0x10
	// Bit RXFLVL.
	USB_OTG_HS_GINTSTS_RXFLVL = 0x10
	// Position of NPTXFE field.
	USB_OTG_HS_GINTSTS_NPTXFE_Pos = 0x5
	// Bit mask of NPTXFE field.
	USB_OTG_HS_GINTSTS_NPTXFE_Msk = 0x20
	// Bit NPTXFE.
	USB_OTG_HS_GINTSTS_NPTXFE = 0x20
	// Position of GINAKEFF field.
	USB_OTG_HS_GINTSTS_GINAKEFF_Pos = 0x6
	// Bit mask of GINAKEFF field.
	USB_OTG_HS_GINTSTS_GINAKEFF_Msk = 0x40
	// Bit GINAKEFF.
	USB_OTG_HS_GINTSTS_GINAKEFF = 0x40
	// Position of BOUTNAKEFF field.
	USB_OTG_HS_GINTSTS_BOUTNAKEFF_Pos = 0x7
	// Bit mask of BOUTNAKEFF field.
	USB_OTG_HS_GINTSTS_BOUTNAKEFF_Msk = 0x80
	// Bit BOUTNAKEFF.
	USB_OTG_HS_GINTSTS_BOUTNAKEFF = 0x80
	// Position of ESUSP field.
	USB_OTG_HS_GINTSTS_ESUSP_Pos = 0xa
	// Bit mask of ESUSP field.
	USB_OTG_HS_GINTSTS_ESUSP_Msk = 0x400
	// Bit ESUSP.
	USB_OTG_HS_GINTSTS_ESUSP = 0x400
	// Position of USBSUSP field.
	USB_OTG_HS_GINTSTS_USBSUSP_Pos = 0xb
	// Bit mask of USBSUSP field.
	USB_OTG_HS_GINTSTS_USBSUSP_Msk = 0x800
	// Bit USBSUSP.
	USB_OTG_HS_GINTSTS_USBSUSP = 0x800
	// Position of USBRST field.
	USB_OTG_HS_GINTSTS_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_HS_GINTSTS_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_HS_GINTSTS_USBRST = 0x1000
	// Position of ENUMDNE field.
	USB_OTG_HS_GINTSTS_ENUMDNE_Pos = 0xd
	// Bit mask of ENUMDNE field.
	USB_OTG_HS_GINTSTS_ENUMDNE_Msk = 0x2000
	// Bit ENUMDNE.
	USB_OTG_HS_GINTSTS_ENUMDNE = 0x2000
	// Position of ISOODRP field.
	USB_OTG_HS_GINTSTS_ISOODRP_Pos = 0xe
	// Bit mask of ISOODRP field.
	USB_OTG_HS_GINTSTS_ISOODRP_Msk = 0x4000
	// Bit ISOODRP.
	USB_OTG_HS_GINTSTS_ISOODRP = 0x4000
	// Position of EOPF field.
	USB_OTG_HS_GINTSTS_EOPF_Pos = 0xf
	// Bit mask of EOPF field.
	USB_OTG_HS_GINTSTS_EOPF_Msk = 0x8000
	// Bit EOPF.
	USB_OTG_HS_GINTSTS_EOPF = 0x8000
	// Position of IEPINT field.
	USB_OTG_HS_GINTSTS_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_HS_GINTSTS_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_HS_GINTSTS_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_HS_GINTSTS_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_HS_GINTSTS_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_HS_GINTSTS_OEPINT = 0x80000
	// Position of IISOIXFR field.
	USB_OTG_HS_GINTSTS_IISOIXFR_Pos = 0x14
	// Bit mask of IISOIXFR field.
	USB_OTG_HS_GINTSTS_IISOIXFR_Msk = 0x100000
	// Bit IISOIXFR.
	USB_OTG_HS_GINTSTS_IISOIXFR = 0x100000
	// Position of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Pos = 0x15
	// Bit mask of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Msk = 0x200000
	// Bit PXFR_INCOMPISOOUT.
	USB_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT = 0x200000
	// Position of DATAFSUSP field.
	USB_OTG_HS_GINTSTS_DATAFSUSP_Pos = 0x16
	// Bit mask of DATAFSUSP field.
	USB_OTG_HS_GINTSTS_DATAFSUSP_Msk = 0x400000
	// Bit DATAFSUSP.
	USB_OTG_HS_GINTSTS_DATAFSUSP = 0x400000
	// Position of HPRTINT field.
	USB_OTG_HS_GINTSTS_HPRTINT_Pos = 0x18
	// Bit mask of HPRTINT field.
	USB_OTG_HS_GINTSTS_HPRTINT_Msk = 0x1000000
	// Bit HPRTINT.
	USB_OTG_HS_GINTSTS_HPRTINT = 0x1000000
	// Position of HCINT field.
	USB_OTG_HS_GINTSTS_HCINT_Pos = 0x19
	// Bit mask of HCINT field.
	USB_OTG_HS_GINTSTS_HCINT_Msk = 0x2000000
	// Bit HCINT.
	USB_OTG_HS_GINTSTS_HCINT = 0x2000000
	// Position of PTXFE field.
	USB_OTG_HS_GINTSTS_PTXFE_Pos = 0x1a
	// Bit mask of PTXFE field.
	USB_OTG_HS_GINTSTS_PTXFE_Msk = 0x4000000
	// Bit PTXFE.
	USB_OTG_HS_GINTSTS_PTXFE = 0x4000000
	// Position of CIDSCHG field.
	USB_OTG_HS_GINTSTS_CIDSCHG_Pos = 0x1c
	// Bit mask of CIDSCHG field.
	USB_OTG_HS_GINTSTS_CIDSCHG_Msk = 0x10000000
	// Bit CIDSCHG.
	USB_OTG_HS_GINTSTS_CIDSCHG = 0x10000000
	// Position of DISCINT field.
	USB_OTG_HS_GINTSTS_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_HS_GINTSTS_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_HS_GINTSTS_DISCINT = 0x20000000
	// Position of SRQINT field.
	USB_OTG_HS_GINTSTS_SRQINT_Pos = 0x1e
	// Bit mask of SRQINT field.
	USB_OTG_HS_GINTSTS_SRQINT_Msk = 0x40000000
	// Bit SRQINT.
	USB_OTG_HS_GINTSTS_SRQINT = 0x40000000
	// Position of WKUPINT field.
	USB_OTG_HS_GINTSTS_WKUPINT_Pos = 0x1f
	// Bit mask of WKUPINT field.
	USB_OTG_HS_GINTSTS_WKUPINT_Msk = 0x80000000
	// Bit WKUPINT.
	USB_OTG_HS_GINTSTS_WKUPINT = 0x80000000

	// GINTMSK: OTG_HS interrupt mask register
	// Position of MMISM field.
	USB_OTG_HS_GINTMSK_MMISM_Pos = 0x1
	// Bit mask of MMISM field.
	USB_OTG_HS_GINTMSK_MMISM_Msk = 0x2
	// Bit MMISM.
	USB_OTG_HS_GINTMSK_MMISM = 0x2
	// Position of OTGINT field.
	USB_OTG_HS_GINTMSK_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_HS_GINTMSK_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_HS_GINTMSK_OTGINT = 0x4
	// Position of SOFM field.
	USB_OTG_HS_GINTMSK_SOFM_Pos = 0x3
	// Bit mask of SOFM field.
	USB_OTG_HS_GINTMSK_SOFM_Msk = 0x8
	// Bit SOFM.
	USB_OTG_HS_GINTMSK_SOFM = 0x8
	// Position of RXFLVLM field.
	USB_OTG_HS_GINTMSK_RXFLVLM_Pos = 0x4
	// Bit mask of RXFLVLM field.
	USB_OTG_HS_GINTMSK_RXFLVLM_Msk = 0x10
	// Bit RXFLVLM.
	USB_OTG_HS_GINTMSK_RXFLVLM = 0x10
	// Position of NPTXFEM field.
	USB_OTG_HS_GINTMSK_NPTXFEM_Pos = 0x5
	// Bit mask of NPTXFEM field.
	USB_OTG_HS_GINTMSK_NPTXFEM_Msk = 0x20
	// Bit NPTXFEM.
	USB_OTG_HS_GINTMSK_NPTXFEM = 0x20
	// Position of GINAKEFFM field.
	USB_OTG_HS_GINTMSK_GINAKEFFM_Pos = 0x6
	// Bit mask of GINAKEFFM field.
	USB_OTG_HS_GINTMSK_GINAKEFFM_Msk = 0x40
	// Bit GINAKEFFM.
	USB_OTG_HS_GINTMSK_GINAKEFFM = 0x40
	// Position of GONAKEFFM field.
	USB_OTG_HS_GINTMSK_GONAKEFFM_Pos = 0x7
	// Bit mask of GONAKEFFM field.
	USB_OTG_HS_GINTMSK_GONAKEFFM_Msk = 0x80
	// Bit GONAKEFFM.
	USB_OTG_HS_GINTMSK_GONAKEFFM = 0x80
	// Position of ESUSPM field.
	USB_OTG_HS_GINTMSK_ESUSPM_Pos = 0xa
	// Bit mask of ESUSPM field.
	USB_OTG_HS_GINTMSK_ESUSPM_Msk = 0x400
	// Bit ESUSPM.
	USB_OTG_HS_GINTMSK_ESUSPM = 0x400
	// Position of USBSUSPM field.
	USB_OTG_HS_GINTMSK_USBSUSPM_Pos = 0xb
	// Bit mask of USBSUSPM field.
	USB_OTG_HS_GINTMSK_USBSUSPM_Msk = 0x800
	// Bit USBSUSPM.
	USB_OTG_HS_GINTMSK_USBSUSPM = 0x800
	// Position of USBRST field.
	USB_OTG_HS_GINTMSK_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_HS_GINTMSK_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_HS_GINTMSK_USBRST = 0x1000
	// Position of ENUMDNEM field.
	USB_OTG_HS_GINTMSK_ENUMDNEM_Pos = 0xd
	// Bit mask of ENUMDNEM field.
	USB_OTG_HS_GINTMSK_ENUMDNEM_Msk = 0x2000
	// Bit ENUMDNEM.
	USB_OTG_HS_GINTMSK_ENUMDNEM = 0x2000
	// Position of ISOODRPM field.
	USB_OTG_HS_GINTMSK_ISOODRPM_Pos = 0xe
	// Bit mask of ISOODRPM field.
	USB_OTG_HS_GINTMSK_ISOODRPM_Msk = 0x4000
	// Bit ISOODRPM.
	USB_OTG_HS_GINTMSK_ISOODRPM = 0x4000
	// Position of EOPFM field.
	USB_OTG_HS_GINTMSK_EOPFM_Pos = 0xf
	// Bit mask of EOPFM field.
	USB_OTG_HS_GINTMSK_EOPFM_Msk = 0x8000
	// Bit EOPFM.
	USB_OTG_HS_GINTMSK_EOPFM = 0x8000
	// Position of EPMISM field.
	USB_OTG_HS_GINTMSK_EPMISM_Pos = 0x11
	// Bit mask of EPMISM field.
	USB_OTG_HS_GINTMSK_EPMISM_Msk = 0x20000
	// Bit EPMISM.
	USB_OTG_HS_GINTMSK_EPMISM = 0x20000
	// Position of IEPINT field.
	USB_OTG_HS_GINTMSK_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_HS_GINTMSK_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_HS_GINTMSK_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_HS_GINTMSK_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_HS_GINTMSK_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_HS_GINTMSK_OEPINT = 0x80000
	// Position of IISOIXFRM field.
	USB_OTG_HS_GINTMSK_IISOIXFRM_Pos = 0x14
	// Bit mask of IISOIXFRM field.
	USB_OTG_HS_GINTMSK_IISOIXFRM_Msk = 0x100000
	// Bit IISOIXFRM.
	USB_OTG_HS_GINTMSK_IISOIXFRM = 0x100000
	// Position of PXFRM_IISOOXFRM field.
	USB_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Pos = 0x15
	// Bit mask of PXFRM_IISOOXFRM field.
	USB_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Msk = 0x200000
	// Bit PXFRM_IISOOXFRM.
	USB_OTG_HS_GINTMSK_PXFRM_IISOOXFRM = 0x200000
	// Position of FSUSPM field.
	USB_OTG_HS_GINTMSK_FSUSPM_Pos = 0x16
	// Bit mask of FSUSPM field.
	USB_OTG_HS_GINTMSK_FSUSPM_Msk = 0x400000
	// Bit FSUSPM.
	USB_OTG_HS_GINTMSK_FSUSPM = 0x400000
	// Position of PRTIM field.
	USB_OTG_HS_GINTMSK_PRTIM_Pos = 0x18
	// Bit mask of PRTIM field.
	USB_OTG_HS_GINTMSK_PRTIM_Msk = 0x1000000
	// Bit PRTIM.
	USB_OTG_HS_GINTMSK_PRTIM = 0x1000000
	// Position of HCIM field.
	USB_OTG_HS_GINTMSK_HCIM_Pos = 0x19
	// Bit mask of HCIM field.
	USB_OTG_HS_GINTMSK_HCIM_Msk = 0x2000000
	// Bit HCIM.
	USB_OTG_HS_GINTMSK_HCIM = 0x2000000
	// Position of PTXFEM field.
	USB_OTG_HS_GINTMSK_PTXFEM_Pos = 0x1a
	// Bit mask of PTXFEM field.
	USB_OTG_HS_GINTMSK_PTXFEM_Msk = 0x4000000
	// Bit PTXFEM.
	USB_OTG_HS_GINTMSK_PTXFEM = 0x4000000
	// Position of CIDSCHGM field.
	USB_OTG_HS_GINTMSK_CIDSCHGM_Pos = 0x1c
	// Bit mask of CIDSCHGM field.
	USB_OTG_HS_GINTMSK_CIDSCHGM_Msk = 0x10000000
	// Bit CIDSCHGM.
	USB_OTG_HS_GINTMSK_CIDSCHGM = 0x10000000
	// Position of DISCINT field.
	USB_OTG_HS_GINTMSK_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_HS_GINTMSK_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_HS_GINTMSK_DISCINT = 0x20000000
	// Position of SRQIM field.
	USB_OTG_HS_GINTMSK_SRQIM_Pos = 0x1e
	// Bit mask of SRQIM field.
	USB_OTG_HS_GINTMSK_SRQIM_Msk = 0x40000000
	// Bit SRQIM.
	USB_OTG_HS_GINTMSK_SRQIM = 0x40000000
	// Position of WUIM field.
	USB_OTG_HS_GINTMSK_WUIM_Pos = 0x1f
	// Bit mask of WUIM field.
	USB_OTG_HS_GINTMSK_WUIM_Msk = 0x80000000
	// Bit WUIM.
	USB_OTG_HS_GINTMSK_WUIM = 0x80000000

	// GRXSTSR_Host: OTG_HS Receive status debug read register (host mode)
	// Position of CHNUM field.
	USB_OTG_HS_GRXSTSR_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_HS_GRXSTSR_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_GRXSTSR_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_GRXSTSR_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_GRXSTSR_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_GRXSTSR_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_GRXSTSR_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000

	// GRXSTSR_Peripheral: OTG_HS Receive status debug read register (peripheral mode mode)
	// Position of EPNUM field.
	USB_OTG_HS_GRXSTSR_Peripheral_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_HS_GRXSTSR_Peripheral_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_GRXSTSR_Peripheral_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_GRXSTSR_Peripheral_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_GRXSTSR_Peripheral_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_GRXSTSR_Peripheral_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_GRXSTSR_Peripheral_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_GRXSTSR_Peripheral_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_HS_GRXSTSR_Peripheral_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_HS_GRXSTSR_Peripheral_FRMNUM_Msk = 0x1e00000

	// GRXSTSP_Host: OTG_HS status read and pop register (host mode)
	// Position of CHNUM field.
	USB_OTG_HS_GRXSTSP_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_HS_GRXSTSP_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_GRXSTSP_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_GRXSTSP_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_GRXSTSP_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_GRXSTSP_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_GRXSTSP_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000

	// GRXSTSP_Peripheral: OTG_HS status read and pop register (peripheral mode)
	// Position of EPNUM field.
	USB_OTG_HS_GRXSTSP_Peripheral_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_HS_GRXSTSP_Peripheral_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_GRXSTSP_Peripheral_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_GRXSTSP_Peripheral_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_GRXSTSP_Peripheral_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_GRXSTSP_Peripheral_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_GRXSTSP_Peripheral_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_GRXSTSP_Peripheral_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_HS_GRXSTSP_Peripheral_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_HS_GRXSTSP_Peripheral_FRMNUM_Msk = 0x1e00000

	// GRXFSIZ: OTG_HS Receive FIFO size register
	// Position of RXFD field.
	USB_OTG_HS_GRXFSIZ_RXFD_Pos = 0x0
	// Bit mask of RXFD field.
	USB_OTG_HS_GRXFSIZ_RXFD_Msk = 0xffff

	// GNPTXFSIZ: OTG_HS nonperiodic transmit FIFO size register (host mode)
	// Position of NPTXFSA field.
	USB_OTG_HS_GNPTXFSIZ_NPTXFSA_Pos = 0x0
	// Bit mask of NPTXFSA field.
	USB_OTG_HS_GNPTXFSIZ_NPTXFSA_Msk = 0xffff
	// Position of NPTXFD field.
	USB_OTG_HS_GNPTXFSIZ_NPTXFD_Pos = 0x10
	// Bit mask of NPTXFD field.
	USB_OTG_HS_GNPTXFSIZ_NPTXFD_Msk = 0xffff0000

	// TX0FSIZ: Endpoint 0 transmit FIFO size (peripheral mode)
	// Position of TX0FSA field.
	USB_OTG_HS_TX0FSIZ_TX0FSA_Pos = 0x0
	// Bit mask of TX0FSA field.
	USB_OTG_HS_TX0FSIZ_TX0FSA_Msk = 0xffff
	// Position of TX0FD field.
	USB_OTG_HS_TX0FSIZ_TX0FD_Pos = 0x10
	// Bit mask of TX0FD field.
	USB_OTG_HS_TX0FSIZ_TX0FD_Msk = 0xffff0000

	// GNPTXSTS: OTG_HS nonperiodic transmit FIFO/queue status register
	// Position of NPTXFSAV field.
	USB_OTG_HS_GNPTXSTS_NPTXFSAV_Pos = 0x0
	// Bit mask of NPTXFSAV field.
	USB_OTG_HS_GNPTXSTS_NPTXFSAV_Msk = 0xffff
	// Position of NPTQXSAV field.
	USB_OTG_HS_GNPTXSTS_NPTQXSAV_Pos = 0x10
	// Bit mask of NPTQXSAV field.
	USB_OTG_HS_GNPTXSTS_NPTQXSAV_Msk = 0xff0000
	// Position of NPTXQTOP field.
	USB_OTG_HS_GNPTXSTS_NPTXQTOP_Pos = 0x18
	// Bit mask of NPTXQTOP field.
	USB_OTG_HS_GNPTXSTS_NPTXQTOP_Msk = 0x7f000000

	// GCCFG: OTG_HS general core configuration register
	// Position of PWRDWN field.
	USB_OTG_HS_GCCFG_PWRDWN_Pos = 0x10
	// Bit mask of PWRDWN field.
	USB_OTG_HS_GCCFG_PWRDWN_Msk = 0x10000
	// Bit PWRDWN.
	USB_OTG_HS_GCCFG_PWRDWN = 0x10000
	// Position of I2CPADEN field.
	USB_OTG_HS_GCCFG_I2CPADEN_Pos = 0x11
	// Bit mask of I2CPADEN field.
	USB_OTG_HS_GCCFG_I2CPADEN_Msk = 0x20000
	// Bit I2CPADEN.
	USB_OTG_HS_GCCFG_I2CPADEN = 0x20000
	// Position of VBUSASEN field.
	USB_OTG_HS_GCCFG_VBUSASEN_Pos = 0x12
	// Bit mask of VBUSASEN field.
	USB_OTG_HS_GCCFG_VBUSASEN_Msk = 0x40000
	// Bit VBUSASEN.
	USB_OTG_HS_GCCFG_VBUSASEN = 0x40000
	// Position of VBUSBSEN field.
	USB_OTG_HS_GCCFG_VBUSBSEN_Pos = 0x13
	// Bit mask of VBUSBSEN field.
	USB_OTG_HS_GCCFG_VBUSBSEN_Msk = 0x80000
	// Bit VBUSBSEN.
	USB_OTG_HS_GCCFG_VBUSBSEN = 0x80000
	// Position of SOFOUTEN field.
	USB_OTG_HS_GCCFG_SOFOUTEN_Pos = 0x14
	// Bit mask of SOFOUTEN field.
	USB_OTG_HS_GCCFG_SOFOUTEN_Msk = 0x100000
	// Bit SOFOUTEN.
	USB_OTG_HS_GCCFG_SOFOUTEN = 0x100000
	// Position of NOVBUSSENS field.
	USB_OTG_HS_GCCFG_NOVBUSSENS_Pos = 0x15
	// Bit mask of NOVBUSSENS field.
	USB_OTG_HS_GCCFG_NOVBUSSENS_Msk = 0x200000
	// Bit NOVBUSSENS.
	USB_OTG_HS_GCCFG_NOVBUSSENS = 0x200000

	// CID: OTG_HS core ID register
	// Position of PRODUCT_ID field.
	USB_OTG_HS_CID_PRODUCT_ID_Pos = 0x0
	// Bit mask of PRODUCT_ID field.
	USB_OTG_HS_CID_PRODUCT_ID_Msk = 0xffffffff

	// HPTXFSIZ: OTG_HS Host periodic transmit FIFO size register
	// Position of PTXSA field.
	USB_OTG_HS_HPTXFSIZ_PTXSA_Pos = 0x0
	// Bit mask of PTXSA field.
	USB_OTG_HS_HPTXFSIZ_PTXSA_Msk = 0xffff
	// Position of PTXFD field.
	USB_OTG_HS_HPTXFSIZ_PTXFD_Pos = 0x10
	// Bit mask of PTXFD field.
	USB_OTG_HS_HPTXFSIZ_PTXFD_Msk = 0xffff0000

	// DIEPTXF1: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_DIEPTXF_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_DIEPTXF_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_DIEPTXF_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_DIEPTXF_INEPTXFD_Msk = 0xffff0000
)

// Bitfields for SAI1: Serial audio interface
const (
	// GCR: Global configuration register
	// Position of SYNCIN field.
	SAI_GCR_SYNCIN_Pos = 0x0
	// Bit mask of SYNCIN field.
	SAI_GCR_SYNCIN_Msk = 0x3
	// Position of SYNCOUT field.
	SAI_GCR_SYNCOUT_Pos = 0x4
	// Bit mask of SYNCOUT field.
	SAI_GCR_SYNCOUT_Msk = 0x30

	// CH.CR1: AConfiguration register 1
	// Position of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Pos = 0x14
	// Bit mask of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Msk = 0xf00000
	// Position of NODIV field.
	SAI_CH_CR1_NODIV_Pos = 0x13
	// Bit mask of NODIV field.
	SAI_CH_CR1_NODIV_Msk = 0x80000
	// Bit NODIV.
	SAI_CH_CR1_NODIV = 0x80000
	// Master clock generator is enabled
	SAI_CH_CR1_NODIV_MasterClock = 0x0
	// No divider used in the clock generator (in this case Master Clock Divider bit has no effect)
	SAI_CH_CR1_NODIV_NoDiv = 0x1
	// Position of DMAEN field.
	SAI_CH_CR1_DMAEN_Pos = 0x11
	// Bit mask of DMAEN field.
	SAI_CH_CR1_DMAEN_Msk = 0x20000
	// Bit DMAEN.
	SAI_CH_CR1_DMAEN = 0x20000
	// DMA disabled
	SAI_CH_CR1_DMAEN_Disabled = 0x0
	// DMA enabled
	SAI_CH_CR1_DMAEN_Enabled = 0x1
	// Position of SAIEN field.
	SAI_CH_CR1_SAIEN_Pos = 0x10
	// Bit mask of SAIEN field.
	SAI_CH_CR1_SAIEN_Msk = 0x10000
	// Bit SAIEN.
	SAI_CH_CR1_SAIEN = 0x10000
	// SAI audio block disabled
	SAI_CH_CR1_SAIEN_Disabled = 0x0
	// SAI audio block enabled
	SAI_CH_CR1_SAIEN_Enabled = 0x1
	// Position of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Pos = 0xd
	// Bit mask of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Msk = 0x2000
	// Bit OUTDRIV.
	SAI_CH_CR1_OUTDRIV = 0x2000
	// Audio block output driven when SAIEN is set
	SAI_CH_CR1_OUTDRIV_OnStart = 0x0
	// Audio block output driven immediately after the setting of this bit
	SAI_CH_CR1_OUTDRIV_Immediately = 0x1
	// Position of MONO field.
	SAI_CH_CR1_MONO_Pos = 0xc
	// Bit mask of MONO field.
	SAI_CH_CR1_MONO_Msk = 0x1000
	// Bit MONO.
	SAI_CH_CR1_MONO = 0x1000
	// Stereo mode
	SAI_CH_CR1_MONO_Stereo = 0x0
	// Mono mode
	SAI_CH_CR1_MONO_Mono = 0x1
	// Position of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Pos = 0xa
	// Bit mask of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Msk = 0xc00
	// audio sub-block in asynchronous mode
	SAI_CH_CR1_SYNCEN_Asynchronous = 0x0
	// audio sub-block is synchronous with the other internal audio sub-block. In this case, the audio sub-block must be configured in slave mode
	SAI_CH_CR1_SYNCEN_Internal = 0x1
	// audio sub-block is synchronous with an external SAI embedded peripheral. In this case the audio sub-block should be configured in Slave mode
	SAI_CH_CR1_SYNCEN_External = 0x2
	// Position of CKSTR field.
	SAI_CH_CR1_CKSTR_Pos = 0x9
	// Bit mask of CKSTR field.
	SAI_CH_CR1_CKSTR_Msk = 0x200
	// Bit CKSTR.
	SAI_CH_CR1_CKSTR = 0x200
	// Data strobing edge is falling edge of SCK
	SAI_CH_CR1_CKSTR_FallingEdge = 0x0
	// Data strobing edge is rising edge of SCK
	SAI_CH_CR1_CKSTR_RisingEdge = 0x1
	// Position of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Pos = 0x8
	// Bit mask of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Msk = 0x100
	// Bit LSBFIRST.
	SAI_CH_CR1_LSBFIRST = 0x100
	// Data are transferred with MSB first
	SAI_CH_CR1_LSBFIRST_MsbFirst = 0x0
	// Data are transferred with LSB first
	SAI_CH_CR1_LSBFIRST_LsbFirst = 0x1
	// Position of DS field.
	SAI_CH_CR1_DS_Pos = 0x5
	// Bit mask of DS field.
	SAI_CH_CR1_DS_Msk = 0xe0
	// 8 bits
	SAI_CH_CR1_DS_Bit8 = 0x2
	// 10 bits
	SAI_CH_CR1_DS_Bit10 = 0x3
	// 16 bits
	SAI_CH_CR1_DS_Bit16 = 0x4
	// 20 bits
	SAI_CH_CR1_DS_Bit20 = 0x5
	// 24 bits
	SAI_CH_CR1_DS_Bit24 = 0x6
	// 32 bits
	SAI_CH_CR1_DS_Bit32 = 0x7
	// Position of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Pos = 0x2
	// Bit mask of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Msk = 0xc
	// Free protocol. Free protocol allows to use the powerful configuration of the audio block to address a specific audio protocol
	SAI_CH_CR1_PRTCFG_Free = 0x0
	// SPDIF protocol
	SAI_CH_CR1_PRTCFG_Spdif = 0x1
	// AC’97 protocol
	SAI_CH_CR1_PRTCFG_Ac97 = 0x2
	// Position of MODE field.
	SAI_CH_CR1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SAI_CH_CR1_MODE_Msk = 0x3
	// Master transmitter
	SAI_CH_CR1_MODE_MasterTx = 0x0
	// Master receiver
	SAI_CH_CR1_MODE_MasterRx = 0x1
	// Slave transmitter
	SAI_CH_CR1_MODE_SlaveTx = 0x2
	// Slave receiver
	SAI_CH_CR1_MODE_SlaveRx = 0x3

	// CH.CR2: AConfiguration register 2
	// Position of COMP field.
	SAI_CH_CR2_COMP_Pos = 0xe
	// Bit mask of COMP field.
	SAI_CH_CR2_COMP_Msk = 0xc000
	// No companding algorithm
	SAI_CH_CR2_COMP_NoCompanding = 0x0
	// μ-Law algorithm
	SAI_CH_CR2_COMP_MuLaw = 0x2
	// A-Law algorithm
	SAI_CH_CR2_COMP_ALaw = 0x3
	// Position of CPL field.
	SAI_CH_CR2_CPL_Pos = 0xd
	// Bit mask of CPL field.
	SAI_CH_CR2_CPL_Msk = 0x2000
	// Bit CPL.
	SAI_CH_CR2_CPL = 0x2000
	// 1’s complement representation
	SAI_CH_CR2_CPL_OnesComplement = 0x0
	// 2’s complement representation
	SAI_CH_CR2_CPL_TwosComplement = 0x1
	// Position of MUTECN field.
	SAI_CH_CR2_MUTECN_Pos = 0x7
	// Bit mask of MUTECN field.
	SAI_CH_CR2_MUTECN_Msk = 0x1f80
	// Position of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Pos = 0x6
	// Bit mask of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Msk = 0x40
	// Bit MUTEVAL.
	SAI_CH_CR2_MUTEVAL = 0x40
	// Bit value 0 is sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendZero = 0x0
	// Last values are sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendLast = 0x1
	// Position of MUTE field.
	SAI_CH_CR2_MUTE_Pos = 0x5
	// Bit mask of MUTE field.
	SAI_CH_CR2_MUTE_Msk = 0x20
	// Bit MUTE.
	SAI_CH_CR2_MUTE = 0x20
	// No mute mode
	SAI_CH_CR2_MUTE_Disabled = 0x0
	// Mute mode enabled
	SAI_CH_CR2_MUTE_Enabled = 0x1
	// Position of TRIS field.
	SAI_CH_CR2_TRIS_Pos = 0x4
	// Bit mask of TRIS field.
	SAI_CH_CR2_TRIS_Msk = 0x10
	// Bit TRIS.
	SAI_CH_CR2_TRIS = 0x10
	// Position of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Pos = 0x3
	// Bit mask of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Msk = 0x8
	// Bit FFLUSH.
	SAI_CH_CR2_FFLUSH = 0x8
	// No FIFO flush
	SAI_CH_CR2_FFLUSH_NoFlush = 0x0
	// FIFO flush. Programming this bit to 1 triggers the FIFO Flush. All the internal FIFO pointers (read and write) are cleared
	SAI_CH_CR2_FFLUSH_Flush = 0x1
	// Position of FTH field.
	SAI_CH_CR2_FTH_Pos = 0x0
	// Bit mask of FTH field.
	SAI_CH_CR2_FTH_Msk = 0x7
	// FIFO empty
	SAI_CH_CR2_FTH_Empty = 0x0
	// 1⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter1 = 0x1
	// 1⁄2 FIFO
	SAI_CH_CR2_FTH_Quarter2 = 0x2
	// 3⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter3 = 0x3
	// FIFO full
	SAI_CH_CR2_FTH_Full = 0x4

	// CH.FRCR: AFRCR
	// Position of FSOFF field.
	SAI_CH_FRCR_FSOFF_Pos = 0x12
	// Bit mask of FSOFF field.
	SAI_CH_FRCR_FSOFF_Msk = 0x40000
	// Bit FSOFF.
	SAI_CH_FRCR_FSOFF = 0x40000
	// FS is asserted on the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_OnFirst = 0x0
	// FS is asserted one bit before the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_BeforeFirst = 0x1
	// Position of FSPOL field.
	SAI_CH_FRCR_FSPOL_Pos = 0x11
	// Bit mask of FSPOL field.
	SAI_CH_FRCR_FSPOL_Msk = 0x20000
	// Bit FSPOL.
	SAI_CH_FRCR_FSPOL = 0x20000
	// FS is active low (falling edge)
	SAI_CH_FRCR_FSPOL_FallingEdge = 0x0
	// FS is active high (rising edge)
	SAI_CH_FRCR_FSPOL_RisingEdge = 0x1
	// Position of FSDEF field.
	SAI_CH_FRCR_FSDEF_Pos = 0x10
	// Bit mask of FSDEF field.
	SAI_CH_FRCR_FSDEF_Msk = 0x10000
	// Bit FSDEF.
	SAI_CH_FRCR_FSDEF = 0x10000
	// Position of FSALL field.
	SAI_CH_FRCR_FSALL_Pos = 0x8
	// Bit mask of FSALL field.
	SAI_CH_FRCR_FSALL_Msk = 0x7f00
	// Position of FRL field.
	SAI_CH_FRCR_FRL_Pos = 0x0
	// Bit mask of FRL field.
	SAI_CH_FRCR_FRL_Msk = 0xff

	// CH.SLOTR: ASlot register
	// Position of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Pos = 0x10
	// Bit mask of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Msk = 0xffff0000
	// Inactive slot
	SAI_CH_SLOTR_SLOTEN_Inactive = 0x0
	// Active slot
	SAI_CH_SLOTR_SLOTEN_Active = 0x1
	// Position of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Pos = 0x8
	// Bit mask of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Msk = 0xf00
	// Position of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Pos = 0x6
	// Bit mask of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Msk = 0xc0
	// The slot size is equivalent to the data size (specified in DS[3:0] in the SAI_xCR1 register)
	SAI_CH_SLOTR_SLOTSZ_DataSize = 0x0
	// 16-bit
	SAI_CH_SLOTR_SLOTSZ_Bit16 = 0x1
	// 32-bit
	SAI_CH_SLOTR_SLOTSZ_Bit32 = 0x2
	// Position of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Pos = 0x0
	// Bit mask of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Msk = 0x1f

	// CH.IM: AInterrupt mask register2
	// Position of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Pos = 0x6
	// Bit mask of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Msk = 0x40
	// Bit LFSDETIE.
	SAI_CH_IM_LFSDETIE = 0x40
	// Interrupt is disabled
	SAI_CH_IM_LFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_LFSDETIE_Enabled = 0x1
	// Position of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Pos = 0x5
	// Bit mask of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Msk = 0x20
	// Bit AFSDETIE.
	SAI_CH_IM_AFSDETIE = 0x20
	// Interrupt is disabled
	SAI_CH_IM_AFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_AFSDETIE_Enabled = 0x1
	// Position of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Pos = 0x4
	// Bit mask of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Msk = 0x10
	// Bit CNRDYIE.
	SAI_CH_IM_CNRDYIE = 0x10
	// Interrupt is disabled
	SAI_CH_IM_CNRDYIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_CNRDYIE_Enabled = 0x1
	// Position of FREQIE field.
	SAI_CH_IM_FREQIE_Pos = 0x3
	// Bit mask of FREQIE field.
	SAI_CH_IM_FREQIE_Msk = 0x8
	// Bit FREQIE.
	SAI_CH_IM_FREQIE = 0x8
	// Interrupt is disabled
	SAI_CH_IM_FREQIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_FREQIE_Enabled = 0x1
	// Position of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Pos = 0x2
	// Bit mask of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Msk = 0x4
	// Bit WCKCFGIE.
	SAI_CH_IM_WCKCFGIE = 0x4
	// Interrupt is disabled
	SAI_CH_IM_WCKCFGIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_WCKCFGIE_Enabled = 0x1
	// Position of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Pos = 0x1
	// Bit mask of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Msk = 0x2
	// Bit MUTEDETIE.
	SAI_CH_IM_MUTEDETIE = 0x2
	// Interrupt is disabled
	SAI_CH_IM_MUTEDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_MUTEDETIE_Enabled = 0x1
	// Position of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Pos = 0x0
	// Bit mask of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Msk = 0x1
	// Bit OVRUDRIE.
	SAI_CH_IM_OVRUDRIE = 0x1
	// Interrupt is disabled
	SAI_CH_IM_OVRUDRIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_OVRUDRIE_Enabled = 0x1

	// CH.SR: AStatus register
	// Position of FLVL field.
	SAI_CH_SR_FLVL_Pos = 0x10
	// Bit mask of FLVL field.
	SAI_CH_SR_FLVL_Msk = 0x70000
	// FIFO empty
	SAI_CH_SR_FLVL_Empty = 0x0
	// FIFO <= 1⁄4 but not empty
	SAI_CH_SR_FLVL_Quarter1 = 0x1
	// 1⁄4 < FIFO <= 1⁄2
	SAI_CH_SR_FLVL_Quarter2 = 0x2
	// 1⁄2 < FIFO <= 3⁄4
	SAI_CH_SR_FLVL_Quarter3 = 0x3
	// 3⁄4 < FIFO but not full
	SAI_CH_SR_FLVL_Quarter4 = 0x4
	// FIFO full
	SAI_CH_SR_FLVL_Full = 0x5
	// Position of LFSDET field.
	SAI_CH_SR_LFSDET_Pos = 0x6
	// Bit mask of LFSDET field.
	SAI_CH_SR_LFSDET_Msk = 0x40
	// Bit LFSDET.
	SAI_CH_SR_LFSDET = 0x40
	// No error
	SAI_CH_SR_LFSDET_NoError = 0x0
	// Frame synchronization signal is not present at the right time
	SAI_CH_SR_LFSDET_NoSync = 0x1
	// Position of AFSDET field.
	SAI_CH_SR_AFSDET_Pos = 0x5
	// Bit mask of AFSDET field.
	SAI_CH_SR_AFSDET_Msk = 0x20
	// Bit AFSDET.
	SAI_CH_SR_AFSDET = 0x20
	// No error
	SAI_CH_SR_AFSDET_NoError = 0x0
	// Frame synchronization signal is detected earlier than expected
	SAI_CH_SR_AFSDET_EarlySync = 0x1
	// Position of CNRDY field.
	SAI_CH_SR_CNRDY_Pos = 0x4
	// Bit mask of CNRDY field.
	SAI_CH_SR_CNRDY_Msk = 0x10
	// Bit CNRDY.
	SAI_CH_SR_CNRDY = 0x10
	// External AC’97 Codec is ready
	SAI_CH_SR_CNRDY_Ready = 0x0
	// External AC’97 Codec is not ready
	SAI_CH_SR_CNRDY_NotReady = 0x1
	// Position of FREQ field.
	SAI_CH_SR_FREQ_Pos = 0x3
	// Bit mask of FREQ field.
	SAI_CH_SR_FREQ_Msk = 0x8
	// Bit FREQ.
	SAI_CH_SR_FREQ = 0x8
	// No FIFO request
	SAI_CH_SR_FREQ_NoRequest = 0x0
	// FIFO request to read or to write the SAI_xDR
	SAI_CH_SR_FREQ_Request = 0x1
	// Position of WCKCFG field.
	SAI_CH_SR_WCKCFG_Pos = 0x2
	// Bit mask of WCKCFG field.
	SAI_CH_SR_WCKCFG_Msk = 0x4
	// Bit WCKCFG.
	SAI_CH_SR_WCKCFG = 0x4
	// Clock configuration is correct
	SAI_CH_SR_WCKCFG_Correct = 0x0
	// Clock configuration does not respect the rule concerning the frame length specification
	SAI_CH_SR_WCKCFG_Wrong = 0x1
	// Position of MUTEDET field.
	SAI_CH_SR_MUTEDET_Pos = 0x1
	// Bit mask of MUTEDET field.
	SAI_CH_SR_MUTEDET_Msk = 0x2
	// Bit MUTEDET.
	SAI_CH_SR_MUTEDET = 0x2
	// No MUTE detection on the SD input line
	SAI_CH_SR_MUTEDET_NoMute = 0x0
	// MUTE value detected on the SD input line (0 value) for a specified number of consecutive audio frame
	SAI_CH_SR_MUTEDET_Mute = 0x1
	// Position of OVRUDR field.
	SAI_CH_SR_OVRUDR_Pos = 0x0
	// Bit mask of OVRUDR field.
	SAI_CH_SR_OVRUDR_Msk = 0x1
	// Bit OVRUDR.
	SAI_CH_SR_OVRUDR = 0x1
	// No overrun/underrun error
	SAI_CH_SR_OVRUDR_NoError = 0x0
	// Overrun/underrun error detection
	SAI_CH_SR_OVRUDR_Overrun = 0x1

	// CH.CLRFR: AClear flag register
	// Position of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Pos = 0x6
	// Bit mask of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Msk = 0x40
	// Bit CLFSDET.
	SAI_CH_CLRFR_CLFSDET = 0x40
	// Clears the LFSDET flag
	SAI_CH_CLRFR_CLFSDET_Clear = 0x1
	// Position of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Pos = 0x5
	// Bit mask of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Msk = 0x20
	// Bit CAFSDET.
	SAI_CH_CLRFR_CAFSDET = 0x20
	// Clears the AFSDET flag
	SAI_CH_CLRFR_CAFSDET_Clear = 0x1
	// Position of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Pos = 0x4
	// Bit mask of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Msk = 0x10
	// Bit CCNRDY.
	SAI_CH_CLRFR_CCNRDY = 0x10
	// Clears the CNRDY flag
	SAI_CH_CLRFR_CCNRDY_Clear = 0x1
	// Position of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Pos = 0x2
	// Bit mask of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Msk = 0x4
	// Bit CWCKCFG.
	SAI_CH_CLRFR_CWCKCFG = 0x4
	// Clears the WCKCFG flag
	SAI_CH_CLRFR_CWCKCFG_Clear = 0x1
	// Position of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Pos = 0x1
	// Bit mask of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Msk = 0x2
	// Bit CMUTEDET.
	SAI_CH_CLRFR_CMUTEDET = 0x2
	// Clears the MUTEDET flag
	SAI_CH_CLRFR_CMUTEDET_Clear = 0x1
	// Position of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Pos = 0x0
	// Bit mask of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Msk = 0x1
	// Bit COVRUDR.
	SAI_CH_CLRFR_COVRUDR = 0x1
	// Clears the OVRUDR flag
	SAI_CH_CLRFR_COVRUDR_Clear = 0x1

	// CH.DR: AData register
	// Position of DATA field.
	SAI_CH_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SAI_CH_DR_DATA_Msk = 0xffffffff
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of FPDS field.
	PWR_CR_FPDS_Pos = 0x9
	// Bit mask of FPDS field.
	PWR_CR_FPDS_Msk = 0x200
	// Bit FPDS.
	PWR_CR_FPDS = 0x200
	// Position of LPLVDS field.
	PWR_CR_LPLVDS_Pos = 0xa
	// Bit mask of LPLVDS field.
	PWR_CR_LPLVDS_Msk = 0x400
	// Bit LPLVDS.
	PWR_CR_LPLVDS = 0x400
	// Position of MRLVDS field.
	PWR_CR_MRLVDS_Pos = 0xb
	// Bit mask of MRLVDS field.
	PWR_CR_MRLVDS_Msk = 0x800
	// Bit MRLVDS.
	PWR_CR_MRLVDS = 0x800
	// Position of ADCDC1 field.
	PWR_CR_ADCDC1_Pos = 0xd
	// Bit mask of ADCDC1 field.
	PWR_CR_ADCDC1_Msk = 0x2000
	// Bit ADCDC1.
	PWR_CR_ADCDC1 = 0x2000
	// Position of VOS field.
	PWR_CR_VOS_Pos = 0xe
	// Bit mask of VOS field.
	PWR_CR_VOS_Msk = 0xc000
	// Position of ODEN field.
	PWR_CR_ODEN_Pos = 0x10
	// Bit mask of ODEN field.
	PWR_CR_ODEN_Msk = 0x10000
	// Bit ODEN.
	PWR_CR_ODEN = 0x10000
	// Position of ODSWEN field.
	PWR_CR_ODSWEN_Pos = 0x11
	// Bit mask of ODSWEN field.
	PWR_CR_ODSWEN_Msk = 0x20000
	// Bit ODSWEN.
	PWR_CR_ODSWEN = 0x20000
	// Position of UDEN field.
	PWR_CR_UDEN_Pos = 0x12
	// Bit mask of UDEN field.
	PWR_CR_UDEN_Msk = 0xc0000
	// Position of FMSSR field.
	PWR_CR_FMSSR_Pos = 0x14
	// Bit mask of FMSSR field.
	PWR_CR_FMSSR_Msk = 0x100000
	// Bit FMSSR.
	PWR_CR_FMSSR = 0x100000
	// Position of FISSR field.
	PWR_CR_FISSR_Pos = 0x15
	// Bit mask of FISSR field.
	PWR_CR_FISSR_Msk = 0x200000
	// Bit FISSR.
	PWR_CR_FISSR = 0x200000

	// CSR: power control/status register
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of BRR field.
	PWR_CSR_BRR_Pos = 0x3
	// Bit mask of BRR field.
	PWR_CSR_BRR_Msk = 0x8
	// Bit BRR.
	PWR_CSR_BRR = 0x8
	// Position of EWUP2 field.
	PWR_CSR_EWUP2_Pos = 0x7
	// Bit mask of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x80
	// Bit EWUP2.
	PWR_CSR_EWUP2 = 0x80
	// Position of EWUP field.
	PWR_CSR_EWUP_Pos = 0x8
	// Bit mask of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100
	// Bit EWUP.
	PWR_CSR_EWUP = 0x100
	// Position of BRE field.
	PWR_CSR_BRE_Pos = 0x9
	// Bit mask of BRE field.
	PWR_CSR_BRE_Msk = 0x200
	// Bit BRE.
	PWR_CSR_BRE = 0x200
	// Position of VOSRDY field.
	PWR_CSR_VOSRDY_Pos = 0xe
	// Bit mask of VOSRDY field.
	PWR_CSR_VOSRDY_Msk = 0x4000
	// Bit VOSRDY.
	PWR_CSR_VOSRDY = 0x4000
	// Position of ODRDY field.
	PWR_CSR_ODRDY_Pos = 0x10
	// Bit mask of ODRDY field.
	PWR_CSR_ODRDY_Msk = 0x10000
	// Bit ODRDY.
	PWR_CSR_ODRDY = 0x10000
	// Position of ODSWRDY field.
	PWR_CSR_ODSWRDY_Pos = 0x11
	// Bit mask of ODSWRDY field.
	PWR_CSR_ODSWRDY_Msk = 0x20000
	// Bit ODSWRDY.
	PWR_CSR_ODSWRDY = 0x20000
	// Position of UDRDY field.
	PWR_CSR_UDRDY_Pos = 0x12
	// Bit mask of UDRDY field.
	PWR_CSR_UDRDY_Msk = 0xc0000
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	// Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Pos = 0x18
	// Bit mask of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000
	// Position of PMM field.
	QUADSPI_CR_PMM_Pos = 0x17
	// Bit mask of PMM field.
	QUADSPI_CR_PMM_Msk = 0x800000
	// Bit PMM.
	QUADSPI_CR_PMM = 0x800000
	// Position of APMS field.
	QUADSPI_CR_APMS_Pos = 0x16
	// Bit mask of APMS field.
	QUADSPI_CR_APMS_Msk = 0x400000
	// Bit APMS.
	QUADSPI_CR_APMS = 0x400000
	// Position of TOIE field.
	QUADSPI_CR_TOIE_Pos = 0x14
	// Bit mask of TOIE field.
	QUADSPI_CR_TOIE_Msk = 0x100000
	// Bit TOIE.
	QUADSPI_CR_TOIE = 0x100000
	// Position of SMIE field.
	QUADSPI_CR_SMIE_Pos = 0x13
	// Bit mask of SMIE field.
	QUADSPI_CR_SMIE_Msk = 0x80000
	// Bit SMIE.
	QUADSPI_CR_SMIE = 0x80000
	// Position of FTIE field.
	QUADSPI_CR_FTIE_Pos = 0x12
	// Bit mask of FTIE field.
	QUADSPI_CR_FTIE_Msk = 0x40000
	// Bit FTIE.
	QUADSPI_CR_FTIE = 0x40000
	// Position of TCIE field.
	QUADSPI_CR_TCIE_Pos = 0x11
	// Bit mask of TCIE field.
	QUADSPI_CR_TCIE_Msk = 0x20000
	// Bit TCIE.
	QUADSPI_CR_TCIE = 0x20000
	// Position of TEIE field.
	QUADSPI_CR_TEIE_Pos = 0x10
	// Bit mask of TEIE field.
	QUADSPI_CR_TEIE_Msk = 0x10000
	// Bit TEIE.
	QUADSPI_CR_TEIE = 0x10000
	// Position of FTHRES field.
	QUADSPI_CR_FTHRES_Pos = 0x8
	// Bit mask of FTHRES field.
	QUADSPI_CR_FTHRES_Msk = 0x1f00
	// Position of FSEL field.
	QUADSPI_CR_FSEL_Pos = 0x7
	// Bit mask of FSEL field.
	QUADSPI_CR_FSEL_Msk = 0x80
	// Bit FSEL.
	QUADSPI_CR_FSEL = 0x80
	// Position of DFM field.
	QUADSPI_CR_DFM_Pos = 0x6
	// Bit mask of DFM field.
	QUADSPI_CR_DFM_Msk = 0x40
	// Bit DFM.
	QUADSPI_CR_DFM = 0x40
	// Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Pos = 0x4
	// Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk = 0x10
	// Bit SSHIFT.
	QUADSPI_CR_SSHIFT = 0x10
	// Position of TCEN field.
	QUADSPI_CR_TCEN_Pos = 0x3
	// Bit mask of TCEN field.
	QUADSPI_CR_TCEN_Msk = 0x8
	// Bit TCEN.
	QUADSPI_CR_TCEN = 0x8
	// Position of DMAEN field.
	QUADSPI_CR_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN_Msk = 0x4
	// Bit DMAEN.
	QUADSPI_CR_DMAEN = 0x4
	// Position of ABORT field.
	QUADSPI_CR_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	QUADSPI_CR_ABORT_Msk = 0x2
	// Bit ABORT.
	QUADSPI_CR_ABORT = 0x2
	// Position of EN field.
	QUADSPI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	QUADSPI_CR_EN_Msk = 0x1
	// Bit EN.
	QUADSPI_CR_EN = 0x1

	// DCR: device configuration register
	// Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Pos = 0x10
	// Bit mask of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk = 0x1f0000
	// Position of CSHT field.
	QUADSPI_DCR_CSHT_Pos = 0x8
	// Bit mask of CSHT field.
	QUADSPI_DCR_CSHT_Msk = 0x700
	// Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Pos = 0x0
	// Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1
	// Bit CKMODE.
	QUADSPI_DCR_CKMODE = 0x1

	// SR: status register
	// Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Pos = 0x8
	// Bit mask of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00
	// Position of BUSY field.
	QUADSPI_SR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	QUADSPI_SR_BUSY_Msk = 0x20
	// Bit BUSY.
	QUADSPI_SR_BUSY = 0x20
	// Position of TOF field.
	QUADSPI_SR_TOF_Pos = 0x4
	// Bit mask of TOF field.
	QUADSPI_SR_TOF_Msk = 0x10
	// Bit TOF.
	QUADSPI_SR_TOF = 0x10
	// Position of SMF field.
	QUADSPI_SR_SMF_Pos = 0x3
	// Bit mask of SMF field.
	QUADSPI_SR_SMF_Msk = 0x8
	// Bit SMF.
	QUADSPI_SR_SMF = 0x8
	// Position of FTF field.
	QUADSPI_SR_FTF_Pos = 0x2
	// Bit mask of FTF field.
	QUADSPI_SR_FTF_Msk = 0x4
	// Bit FTF.
	QUADSPI_SR_FTF = 0x4
	// Position of TCF field.
	QUADSPI_SR_TCF_Pos = 0x1
	// Bit mask of TCF field.
	QUADSPI_SR_TCF_Msk = 0x2
	// Bit TCF.
	QUADSPI_SR_TCF = 0x2
	// Position of TEF field.
	QUADSPI_SR_TEF_Pos = 0x0
	// Bit mask of TEF field.
	QUADSPI_SR_TEF_Msk = 0x1
	// Bit TEF.
	QUADSPI_SR_TEF = 0x1

	// FCR: flag clear register
	// Position of CTOF field.
	QUADSPI_FCR_CTOF_Pos = 0x4
	// Bit mask of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10
	// Bit CTOF.
	QUADSPI_FCR_CTOF = 0x10
	// Position of CSMF field.
	QUADSPI_FCR_CSMF_Pos = 0x3
	// Bit mask of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8
	// Bit CSMF.
	QUADSPI_FCR_CSMF = 0x8
	// Position of CTCF field.
	QUADSPI_FCR_CTCF_Pos = 0x1
	// Bit mask of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2
	// Bit CTCF.
	QUADSPI_FCR_CTCF = 0x2
	// Position of CTEF field.
	QUADSPI_FCR_CTEF_Pos = 0x0
	// Bit mask of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1
	// Bit CTEF.
	QUADSPI_FCR_CTEF = 0x1

	// DLR: data length register
	// Position of DL field.
	QUADSPI_DLR_DL_Pos = 0x0
	// Bit mask of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff

	// CCR: communication configuration register
	// Position of DDRM field.
	QUADSPI_CCR_DDRM_Pos = 0x1f
	// Bit mask of DDRM field.
	QUADSPI_CCR_DDRM_Msk = 0x80000000
	// Bit DDRM.
	QUADSPI_CCR_DDRM = 0x80000000
	// Position of DHHC field.
	QUADSPI_CCR_DHHC_Pos = 0x1e
	// Bit mask of DHHC field.
	QUADSPI_CCR_DHHC_Msk = 0x40000000
	// Bit DHHC.
	QUADSPI_CCR_DHHC = 0x40000000
	// Position of SIOO field.
	QUADSPI_CCR_SIOO_Pos = 0x1c
	// Bit mask of SIOO field.
	QUADSPI_CCR_SIOO_Msk = 0x10000000
	// Bit SIOO.
	QUADSPI_CCR_SIOO = 0x10000000
	// Position of FMODE field.
	QUADSPI_CCR_FMODE_Pos = 0x1a
	// Bit mask of FMODE field.
	QUADSPI_CCR_FMODE_Msk = 0xc000000
	// Position of DMODE field.
	QUADSPI_CCR_DMODE_Pos = 0x18
	// Bit mask of DMODE field.
	QUADSPI_CCR_DMODE_Msk = 0x3000000
	// Position of DCYC field.
	QUADSPI_CCR_DCYC_Pos = 0x12
	// Bit mask of DCYC field.
	QUADSPI_CCR_DCYC_Msk = 0x7c0000
	// Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Pos = 0x10
	// Bit mask of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk = 0x30000
	// Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Pos = 0xe
	// Bit mask of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk = 0xc000
	// Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Pos = 0xc
	// Bit mask of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk = 0x3000
	// Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Pos = 0xa
	// Bit mask of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk = 0xc00
	// Position of IMODE field.
	QUADSPI_CCR_IMODE_Pos = 0x8
	// Bit mask of IMODE field.
	QUADSPI_CCR_IMODE_Msk = 0x300
	// Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0
	// Bit mask of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff

	// AR: address register
	// Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff

	// ABR: ABR
	// Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Pos = 0x0
	// Bit mask of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff

	// DR: data register
	// Position of DATA field.
	QUADSPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff

	// PSMKR: polling status mask register
	// Position of MASK field.
	QUADSPI_PSMKR_MASK_Pos = 0x0
	// Bit mask of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff

	// PSMAR: polling status match register
	// Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff

	// PIR: polling interval register
	// Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Pos = 0x0
	// Bit mask of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff

	// LPTR: low-power timeout register
	// Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff
)

// Bitfields for SPDIFRX: Receiver Interface
const (
	// CR: Control register
	// Position of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Pos = 0x0
	// Bit mask of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Msk = 0x3
	// Position of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Pos = 0x2
	// Bit mask of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Msk = 0x4
	// Bit RXDMAEN.
	SPDIF_RX_CR_RXDMAEN = 0x4
	// Position of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Pos = 0x3
	// Bit mask of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Msk = 0x8
	// Bit RXSTEO.
	SPDIF_RX_CR_RXSTEO = 0x8
	// Position of DRFMT field.
	SPDIF_RX_CR_DRFMT_Pos = 0x4
	// Bit mask of DRFMT field.
	SPDIF_RX_CR_DRFMT_Msk = 0x30
	// Position of PMSK field.
	SPDIF_RX_CR_PMSK_Pos = 0x6
	// Bit mask of PMSK field.
	SPDIF_RX_CR_PMSK_Msk = 0x40
	// Bit PMSK.
	SPDIF_RX_CR_PMSK = 0x40
	// Position of VMSK field.
	SPDIF_RX_CR_VMSK_Pos = 0x7
	// Bit mask of VMSK field.
	SPDIF_RX_CR_VMSK_Msk = 0x80
	// Bit VMSK.
	SPDIF_RX_CR_VMSK = 0x80
	// Position of CUMSK field.
	SPDIF_RX_CR_CUMSK_Pos = 0x8
	// Bit mask of CUMSK field.
	SPDIF_RX_CR_CUMSK_Msk = 0x100
	// Bit CUMSK.
	SPDIF_RX_CR_CUMSK = 0x100
	// Position of PTMSK field.
	SPDIF_RX_CR_PTMSK_Pos = 0x9
	// Bit mask of PTMSK field.
	SPDIF_RX_CR_PTMSK_Msk = 0x200
	// Bit PTMSK.
	SPDIF_RX_CR_PTMSK = 0x200
	// Position of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Pos = 0xa
	// Bit mask of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Msk = 0x400
	// Bit CBDMAEN.
	SPDIF_RX_CR_CBDMAEN = 0x400
	// Position of CHSEL field.
	SPDIF_RX_CR_CHSEL_Pos = 0xb
	// Bit mask of CHSEL field.
	SPDIF_RX_CR_CHSEL_Msk = 0x800
	// Bit CHSEL.
	SPDIF_RX_CR_CHSEL = 0x800
	// Position of NBTR field.
	SPDIF_RX_CR_NBTR_Pos = 0xc
	// Bit mask of NBTR field.
	SPDIF_RX_CR_NBTR_Msk = 0x3000
	// Position of WFA field.
	SPDIF_RX_CR_WFA_Pos = 0xe
	// Bit mask of WFA field.
	SPDIF_RX_CR_WFA_Msk = 0x4000
	// Bit WFA.
	SPDIF_RX_CR_WFA = 0x4000
	// Position of INSEL field.
	SPDIF_RX_CR_INSEL_Pos = 0x10
	// Bit mask of INSEL field.
	SPDIF_RX_CR_INSEL_Msk = 0x70000

	// IMR: Interrupt mask register
	// Position of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Pos = 0x0
	// Bit mask of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Msk = 0x1
	// Bit RXNEIE.
	SPDIF_RX_IMR_RXNEIE = 0x1
	// Position of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Pos = 0x1
	// Bit mask of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Msk = 0x2
	// Bit CSRNEIE.
	SPDIF_RX_IMR_CSRNEIE = 0x2
	// Position of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Pos = 0x2
	// Bit mask of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Msk = 0x4
	// Bit PERRIE.
	SPDIF_RX_IMR_PERRIE = 0x4
	// Position of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Pos = 0x3
	// Bit mask of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Msk = 0x8
	// Bit OVRIE.
	SPDIF_RX_IMR_OVRIE = 0x8
	// Position of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Pos = 0x4
	// Bit mask of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Msk = 0x10
	// Bit SBLKIE.
	SPDIF_RX_IMR_SBLKIE = 0x10
	// Position of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Pos = 0x5
	// Bit mask of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Msk = 0x20
	// Bit SYNCDIE.
	SPDIF_RX_IMR_SYNCDIE = 0x20
	// Position of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Pos = 0x6
	// Bit mask of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Msk = 0x40
	// Bit IFEIE.
	SPDIF_RX_IMR_IFEIE = 0x40

	// SR: Status register
	// Position of RXNE field.
	SPDIF_RX_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPDIF_RX_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPDIF_RX_SR_RXNE = 0x1
	// Position of CSRNE field.
	SPDIF_RX_SR_CSRNE_Pos = 0x1
	// Bit mask of CSRNE field.
	SPDIF_RX_SR_CSRNE_Msk = 0x2
	// Bit CSRNE.
	SPDIF_RX_SR_CSRNE = 0x2
	// Position of PERR field.
	SPDIF_RX_SR_PERR_Pos = 0x2
	// Bit mask of PERR field.
	SPDIF_RX_SR_PERR_Msk = 0x4
	// Bit PERR.
	SPDIF_RX_SR_PERR = 0x4
	// Position of OVR field.
	SPDIF_RX_SR_OVR_Pos = 0x3
	// Bit mask of OVR field.
	SPDIF_RX_SR_OVR_Msk = 0x8
	// Bit OVR.
	SPDIF_RX_SR_OVR = 0x8
	// Position of SBD field.
	SPDIF_RX_SR_SBD_Pos = 0x4
	// Bit mask of SBD field.
	SPDIF_RX_SR_SBD_Msk = 0x10
	// Bit SBD.
	SPDIF_RX_SR_SBD = 0x10
	// Position of SYNCD field.
	SPDIF_RX_SR_SYNCD_Pos = 0x5
	// Bit mask of SYNCD field.
	SPDIF_RX_SR_SYNCD_Msk = 0x20
	// Bit SYNCD.
	SPDIF_RX_SR_SYNCD = 0x20
	// Position of FERR field.
	SPDIF_RX_SR_FERR_Pos = 0x6
	// Bit mask of FERR field.
	SPDIF_RX_SR_FERR_Msk = 0x40
	// Bit FERR.
	SPDIF_RX_SR_FERR = 0x40
	// Position of SERR field.
	SPDIF_RX_SR_SERR_Pos = 0x7
	// Bit mask of SERR field.
	SPDIF_RX_SR_SERR_Msk = 0x80
	// Bit SERR.
	SPDIF_RX_SR_SERR = 0x80
	// Position of TERR field.
	SPDIF_RX_SR_TERR_Pos = 0x8
	// Bit mask of TERR field.
	SPDIF_RX_SR_TERR_Msk = 0x100
	// Bit TERR.
	SPDIF_RX_SR_TERR = 0x100
	// Position of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Pos = 0x10
	// Bit mask of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Msk = 0x7fff0000

	// IFCR: Interrupt Flag Clear register
	// Position of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Pos = 0x2
	// Bit mask of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Msk = 0x4
	// Bit PERRCF.
	SPDIF_RX_IFCR_PERRCF = 0x4
	// Position of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Pos = 0x3
	// Bit mask of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Msk = 0x8
	// Bit OVRCF.
	SPDIF_RX_IFCR_OVRCF = 0x8
	// Position of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Pos = 0x4
	// Bit mask of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Msk = 0x10
	// Bit SBDCF.
	SPDIF_RX_IFCR_SBDCF = 0x10
	// Position of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Pos = 0x5
	// Bit mask of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Msk = 0x20
	// Bit SYNCDCF.
	SPDIF_RX_IFCR_SYNCDCF = 0x20

	// DR: Data input register
	// Position of DR field.
	SPDIF_RX_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPDIF_RX_DR_DR_Msk = 0xffffff
	// Position of PE field.
	SPDIF_RX_DR_PE_Pos = 0x18
	// Bit mask of PE field.
	SPDIF_RX_DR_PE_Msk = 0x1000000
	// Bit PE.
	SPDIF_RX_DR_PE = 0x1000000
	// Position of V field.
	SPDIF_RX_DR_V_Pos = 0x19
	// Bit mask of V field.
	SPDIF_RX_DR_V_Msk = 0x2000000
	// Bit V.
	SPDIF_RX_DR_V = 0x2000000
	// Position of U field.
	SPDIF_RX_DR_U_Pos = 0x1a
	// Bit mask of U field.
	SPDIF_RX_DR_U_Msk = 0x4000000
	// Bit U.
	SPDIF_RX_DR_U = 0x4000000
	// Position of C field.
	SPDIF_RX_DR_C_Pos = 0x1b
	// Bit mask of C field.
	SPDIF_RX_DR_C_Msk = 0x8000000
	// Bit C.
	SPDIF_RX_DR_C = 0x8000000
	// Position of PT field.
	SPDIF_RX_DR_PT_Pos = 0x1c
	// Bit mask of PT field.
	SPDIF_RX_DR_PT_Msk = 0x30000000

	// CSR: Channel Status register
	// Position of USR field.
	SPDIF_RX_CSR_USR_Pos = 0x0
	// Bit mask of USR field.
	SPDIF_RX_CSR_USR_Msk = 0xffff
	// Position of CS field.
	SPDIF_RX_CSR_CS_Pos = 0x10
	// Bit mask of CS field.
	SPDIF_RX_CSR_CS_Msk = 0xff0000
	// Position of SOB field.
	SPDIF_RX_CSR_SOB_Pos = 0x18
	// Bit mask of SOB field.
	SPDIF_RX_CSR_SOB_Msk = 0x1000000
	// Bit SOB.
	SPDIF_RX_CSR_SOB = 0x1000000

	// DIR: Debug Information register
	// Position of THI field.
	SPDIF_RX_DIR_THI_Pos = 0x0
	// Bit mask of THI field.
	SPDIF_RX_DIR_THI_Msk = 0x1fff
	// Position of TLO field.
	SPDIF_RX_DIR_TLO_Pos = 0x10
	// Bit mask of TLO field.
	SPDIF_RX_DIR_TLO_Msk = 0x1fff0000
)

// Bitfields for SDIO: Secure digital input/output SD/SDIO MMC card host interface
const (
	// POWER: SDIO power control register
	// Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3
	// Power off
	SDIO_POWER_PWRCTRL_PowerOff = 0x0
	// Power on
	SDIO_POWER_PWRCTRL_PowerOn = 0x3

	// CLKCR: CLKCR register controls the SDIO_CK output clock.
	// Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk = 0xff
	// Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDIO_CLKCR_PWRSAV = 0x200
	// SDIO_CK is only enabled when the bus is active
	SDIO_CLKCR_PWRSAV_Disabled = 0x1
	// SDIO_CK clock is always enabled
	SDIO_CLKCR_PWRSAV_Enabled = 0x0
	// Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk = 0x1800
	// 1 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth1 = 0x0
	// 4 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth4 = 0x1
	// 8 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth8 = 0x2
	// Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDIO_CLKCR_NEGEDGE = 0x2000
	// SDIO_CK generated on the rising edge
	SDIO_CLKCR_NEGEDGE_Rising = 0x0
	// SDIO_CK generated on the falling edge
	SDIO_CLKCR_NEGEDGE_Falling = 0x1
	// Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDIO_CLKCR_HWFC_EN = 0x4000
	// HW Flow Control is disabled
	SDIO_CLKCR_HWFC_EN_Disabled = 0x0
	// HW Flow Control is enabled
	SDIO_CLKCR_HWFC_EN_Enabled = 0x1
	// Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDIO_CLKCR_CLKEN = 0x100
	// Disable clock
	SDIO_CLKCR_CLKEN_Disabled = 0x0
	// Enable clock
	SDIO_CLKCR_CLKEN_Enabled = 0x1
	// Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDIO_CLKCR_BYPASS = 0x400
	// SDIOCLK is divided according to the CLKDIV value before driving the SDIO_CK output signal.
	SDIO_CLKCR_BYPASS_Disabled = 0x0
	// SDIOCLK directly drives the SDIO_CK output signal
	SDIO_CLKCR_BYPASS_Enabled = 0x1

	// ARG: The SDMMC_ARGR register contains a 32-bit command argument, which is sent to a card as part of a command message.
	// Position of CMDARG field.
	SDIO_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff

	// CMD: The SDMMC_CMDR register contains the command index and command type bits. The command index is sent to a card as part of a command message. The command type bits control the command path state machine (CPSM).
	// Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk = 0x3f
	// Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk = 0xc0
	// No response
	SDIO_CMD_WAITRESP_NoResponse = 0x0
	// Short response
	SDIO_CMD_WAITRESP_ShortResponse = 0x1
	// No reponse
	SDIO_CMD_WAITRESP_NoResponse2 = 0x2
	// Long reponse
	SDIO_CMD_WAITRESP_LongResponse = 0x3
	// Position of WAITINT field.
	SDIO_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDIO_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDIO_CMD_WAITINT = 0x100
	// Don't wait for interrupt request
	SDIO_CMD_WAITINT_Disabled = 0x0
	// Wait for interrupt request
	SDIO_CMD_WAITINT_Enabled = 0x1
	// Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDIO_CMD_WAITPEND = 0x200
	// Don't wait for data end
	SDIO_CMD_WAITPEND_Disabled = 0x0
	// Wait for end of data transfer signal before sending command
	SDIO_CMD_WAITPEND_Enabled = 0x1
	// Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDIO_CMD_CPSMEN = 0x400
	// Command path state machine disabled
	SDIO_CMD_CPSMEN_Disabled = 0x0
	// Command path state machine enabled
	SDIO_CMD_CPSMEN_Enabled = 0x1
	// Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDIO_CMD_SDIOSuspend = 0x800
	// Next command is not a SDIO suspend command
	SDIO_CMD_SDIOSuspend_Disabled = 0x0
	// Next command send is a SDIO suspend command
	SDIO_CMD_SDIOSuspend_Enabled = 0x1

	// RESPCMD: The SDMMC_RESPCMDR register contains the command index field of the last command response received. If the command response transmission does not contain the command index field (long or OCR response), the RESPCMD field is unknown, although it must contain 111111b (the value of the reserved field from the response).
	// Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: The SDMMC_RESP1/2/3/4R registers contain the status of a card, which is part of the received response.
	// Position of CARDSTATUS field.
	SDIO_RESP_CARDSTATUS_Pos = 0x0
	// Bit mask of CARDSTATUS field.
	SDIO_RESP_CARDSTATUS_Msk = 0xffffffff

	// DTIMER: The SDMMC_DTIMER register contains the data timeout period, in card bus clock periods. A counter loads the value from the SDMMC_DTIMER register, and starts decrementing when the data path state machine (DPSM) enters the Wait_R or Busy state. If the timer reaches 0 while the DPSM is in either of these states, the timeout status flag is set.
	// Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: The SDMMC_DLENR register contains the number of data bytes to be transferred. The value is loaded into the data counter when data transfer starts.
	// Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: The SDMMC_DCTRL register control the data path state machine (DPSM).
	// Position of DTEN field.
	SDIO_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDIO_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDIO_DCTRL_DTEN = 0x1
	// Disabled
	SDIO_DCTRL_DTEN_Disabled = 0x0
	// Start transfer
	SDIO_DCTRL_DTEN_Enabled = 0x1
	// Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDIO_DCTRL_DTDIR = 0x2
	// From controller to card
	SDIO_DCTRL_DTDIR_ControllerToCard = 0x0
	// From card to controller
	SDIO_DCTRL_DTDIR_CardToController = 0x1
	// Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDIO_DCTRL_DTMODE = 0x4
	// Bloack data transfer
	SDIO_DCTRL_DTMODE_BlockMode = 0x0
	// Stream or SDIO multibyte data transfer
	SDIO_DCTRL_DTMODE_StreamMode = 0x1
	// Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDIO_DCTRL_RWSTART = 0x100
	// Don't start read wait operation
	SDIO_DCTRL_RWSTART_Disabled = 0x0
	// Read wait operation starts
	SDIO_DCTRL_RWSTART_Enabled = 0x1
	// Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDIO_DCTRL_RWSTOP = 0x200
	// Read wait in progress if RWSTART is enabled
	SDIO_DCTRL_RWSTOP_Disabled = 0x0
	// Enable for read wait stop if RWSTART is enabled
	SDIO_DCTRL_RWSTOP_Enabled = 0x1
	// Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDIO_DCTRL_RWMOD = 0x400
	// Read wait control stopping using SDIO_D2
	SDIO_DCTRL_RWMOD_D2 = 0x0
	// Read wait control using SDIO_CK
	SDIO_DCTRL_RWMOD_Ck = 0x1
	// Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDIO_DCTRL_SDIOEN = 0x800
	// SDIO operations disabled
	SDIO_DCTRL_SDIOEN_Disabled = 0x0
	// SDIO operations enabled
	SDIO_DCTRL_SDIOEN_Enabled = 0x1
	// Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDIO_DCTRL_DMAEN = 0x8
	// Dma disabled
	SDIO_DCTRL_DMAEN_Disabled = 0x0
	// Dma enabled
	SDIO_DCTRL_DMAEN_Enabled = 0x1

	// DCOUNT: The SDMMC_DCNTR register loads the value from the data length register (see SDMMC_DLENR) when the DPSM moves from the Idle state to the Wait_R or Wait_S state. As data is transferred, the counter decrements the value until it reaches 0. The DPSM then moves to the Idle state and when there has been no error, the data status end flag (DATAEND) is set.
	// Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: The SDMMC_STAR register is a read-only register. It contains two types of flag:Static flags (bits [29,21,11:0]): these bits remain asserted until they are cleared by writing to the SDMMC interrupt Clear register (see SDMMC_ICR)Dynamic flags (bits [20:12]): these bits change state depending on the state of the underlying logic (for example, FIFO full and empty flags are asserted and de-asserted as data while written to the FIFO)
	// Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDIO_STA_CCRCFAIL = 0x1
	// Command response received, crc check passed
	SDIO_STA_CCRCFAIL_NotFailed = 0x0
	// Command response received, crc check failed
	SDIO_STA_CCRCFAIL_Failed = 0x1
	// Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDIO_STA_DCRCFAIL = 0x2
	// No Data block sent/received crc check fail
	SDIO_STA_DCRCFAIL_NotFailed = 0x0
	// Data block sent/received crc failed
	SDIO_STA_DCRCFAIL_Failed = 0x1
	// Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDIO_STA_CTIMEOUT = 0x4
	// No Command timeout
	SDIO_STA_CTIMEOUT_NoTimeout = 0x0
	// Command timeout
	SDIO_STA_CTIMEOUT_Timeout = 0x1
	// Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDIO_STA_DTIMEOUT = 0x8
	// No data timeout
	SDIO_STA_DTIMEOUT_NoTimeout = 0x0
	// Data timeout
	SDIO_STA_DTIMEOUT_Timeout = 0x1
	// Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDIO_STA_TXUNDERR = 0x10
	// No transmit FIFO underrun error
	SDIO_STA_TXUNDERR_NoUnderrun = 0x0
	// Transmit FIFO underrun error
	SDIO_STA_TXUNDERR_Underrun = 0x1
	// Position of RXOVERR field.
	SDIO_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDIO_STA_RXOVERR = 0x20
	// No FIFO overrun error
	SDIO_STA_RXOVERR_NoOverrun = 0x0
	// Receive FIFO overrun error
	SDIO_STA_RXOVERR_Overrun = 0x1
	// Position of CMDREND field.
	SDIO_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDIO_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDIO_STA_CMDREND = 0x40
	// Command not done
	SDIO_STA_CMDREND_NotDone = 0x0
	// Command response received (CRC check passed)
	SDIO_STA_CMDREND_Done = 0x1
	// Position of CMDSENT field.
	SDIO_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDIO_STA_CMDSENT = 0x80
	// Command not sent
	SDIO_STA_CMDSENT_NotSent = 0x0
	// Command sent (no response required)
	SDIO_STA_CMDSENT_Sent = 0x1
	// Position of DATAEND field.
	SDIO_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDIO_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDIO_STA_DATAEND = 0x100
	// Data end (DCOUNT, is zero)
	SDIO_STA_DATAEND_Done = 0x1
	// Not done
	SDIO_STA_DATAEND_NotDone = 0x0
	// Position of DBCKEND field.
	SDIO_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDIO_STA_DBCKEND = 0x400
	// Data block not sent/received (CRC check failed)
	SDIO_STA_DBCKEND_NotTransferred = 0x0
	// Data block sent/received (CRC check passed)
	SDIO_STA_DBCKEND_Transferred = 0x1
	// Position of CMDACT field.
	SDIO_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDIO_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDIO_STA_CMDACT = 0x800
	// Command transfer not in progress
	SDIO_STA_CMDACT_NotInProgress = 0x0
	// Command tranfer in progress
	SDIO_STA_CMDACT_InProgress = 0x1
	// Position of TXACT field.
	SDIO_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDIO_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDIO_STA_TXACT = 0x1000
	// Data transmit is not in progress
	SDIO_STA_TXACT_NotInProgress = 0x0
	// Data transmit in progress
	SDIO_STA_TXACT_InProgress = 0x1
	// Position of RXACT field.
	SDIO_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDIO_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDIO_STA_RXACT = 0x2000
	// Data receive not in progress
	SDIO_STA_RXACT_NotInProgress = 0x0
	// Data receive in progress
	SDIO_STA_RXACT_InProgress = 0x1
	// Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDIO_STA_TXFIFOHE = 0x4000
	// Transmit FIFO not half empty
	SDIO_STA_TXFIFOHE_NotHalfEmpty = 0x0
	// Transmit FIFO half empty. At least 8 words can be written into the FIFO
	SDIO_STA_TXFIFOHE_HalfEmpty = 0x1
	// Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDIO_STA_RXFIFOHF = 0x8000
	// Receive FIFO not half full
	SDIO_STA_RXFIFOHF_NotHalfFull = 0x0
	// Receive FIFO half full. At least 8 words in the FIFO
	SDIO_STA_RXFIFOHF_HalfFull = 0x1
	// Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDIO_STA_TXFIFOF = 0x10000
	// Transmit FIFO not full
	SDIO_STA_TXFIFOF_NotFull = 0x0
	// Transmit FIFO full
	SDIO_STA_TXFIFOF_Full = 0x1
	// Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDIO_STA_RXFIFOF = 0x20000
	// Transmit FIFO not full
	SDIO_STA_RXFIFOF_NotFull = 0x0
	// Receive FIFO full. When HW Flow Control is enabled, RXFIFOF signals becomes activated 2 words before the FIFO is full.
	SDIO_STA_RXFIFOF_Full = 0x1
	// Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDIO_STA_TXFIFOE = 0x40000
	// Transmit FIFO not empty
	SDIO_STA_TXFIFOE_NotEmpty = 0x0
	// Transmit FIFO empty. When HW Flow Control is enabled, TXFIFOE signals becomes activated when the FIFO contains 2 words.
	SDIO_STA_TXFIFOE_Empty = 0x1
	// Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDIO_STA_RXFIFOE = 0x80000
	// Receive FIFO not empty
	SDIO_STA_RXFIFOE_NotEmpty = 0x0
	// Receive FIFO empty
	SDIO_STA_RXFIFOE_Empty = 0x1
	// Position of TXDAVL field.
	SDIO_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDIO_STA_TXDAVL = 0x100000
	// Data not available in transmit FIFO
	SDIO_STA_TXDAVL_NotAvailable = 0x0
	// Data available in transmit FIFO
	SDIO_STA_TXDAVL_Available = 0x1
	// Position of RXDAVL field.
	SDIO_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDIO_STA_RXDAVL = 0x200000
	// Data not available in receive FIFO
	SDIO_STA_RXDAVL_NotAvailable = 0x0
	// Data available in receive FIFO
	SDIO_STA_RXDAVL_Available = 0x1
	// Position of SDIOIT field.
	SDIO_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDIO_STA_SDIOIT = 0x400000
	// SDIO interrupt not receieved
	SDIO_STA_SDIOIT_NotReceived = 0x0
	// SDIO interrupt received
	SDIO_STA_SDIOIT_Received = 0x1

	// ICR: The SDMMC_ICR register is a write-only register. Writing a bit with 1 clears the corresponding bit in the SDMMC_STAR status register.
	// Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDIO_ICR_CCRCFAILC = 0x1
	// Clear flag
	SDIO_ICR_CCRCFAILC_Clear = 0x1
	// Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDIO_ICR_DCRCFAILC = 0x2
	// Clear flag
	SDIO_ICR_DCRCFAILC_Clear = 0x1
	// Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDIO_ICR_CTIMEOUTC = 0x4
	// Clear flag
	SDIO_ICR_CTIMEOUTC_Clear = 0x1
	// Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDIO_ICR_DTIMEOUTC = 0x8
	// Clear flag
	SDIO_ICR_DTIMEOUTC_Clear = 0x1
	// Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDIO_ICR_TXUNDERRC = 0x10
	// Clear flag
	SDIO_ICR_TXUNDERRC_Clear = 0x1
	// Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDIO_ICR_RXOVERRC = 0x20
	// Clear flag
	SDIO_ICR_RXOVERRC_Clear = 0x1
	// Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDIO_ICR_CMDRENDC = 0x40
	// Clear flag
	SDIO_ICR_CMDRENDC_Clear = 0x1
	// Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDIO_ICR_CMDSENTC = 0x80
	// Clear flag
	SDIO_ICR_CMDSENTC_Clear = 0x1
	// Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDIO_ICR_DATAENDC = 0x100
	// Clear flag
	SDIO_ICR_DATAENDC_Clear = 0x1
	// Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDIO_ICR_DBCKENDC = 0x400
	// Clear flag
	SDIO_ICR_DBCKENDC_Clear = 0x1
	// Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDIO_ICR_SDIOITC = 0x400000
	// Clear flag
	SDIO_ICR_SDIOITC_Clear = 0x1
	// Position of IDMATEC field.
	SDIO_ICR_IDMATEC_Pos = 0x1b
	// Bit mask of IDMATEC field.
	SDIO_ICR_IDMATEC_Msk = 0x8000000
	// Bit IDMATEC.
	SDIO_ICR_IDMATEC = 0x8000000
	// Clear flag
	SDIO_ICR_IDMATEC_Clear = 0x1

	// MASK: The interrupt mask register determines which status flags generate an interrupt request by setting the corresponding bit to 1.
	// Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDIO_MASK_CCRCFAILIE = 0x1
	// Interrupt disabled
	SDIO_MASK_CCRCFAILIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CCRCFAILIE_Enabled = 0x1
	// Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDIO_MASK_DCRCFAILIE = 0x2
	// Interrupt disabled
	SDIO_MASK_DCRCFAILIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DCRCFAILIE_Enabled = 0x1
	// Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE = 0x4
	// Interrupt disabled
	SDIO_MASK_CTIMEOUTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CTIMEOUTIE_Enabled = 0x1
	// Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDIO_MASK_DTIMEOUTIE = 0x8
	// Interrupt disabled
	SDIO_MASK_DTIMEOUTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DTIMEOUTIE_Enabled = 0x1
	// Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDIO_MASK_TXUNDERRIE = 0x10
	// Interrupt disabled
	SDIO_MASK_TXUNDERRIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXUNDERRIE_Enabled = 0x1
	// Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDIO_MASK_RXOVERRIE = 0x20
	// Interrupt disabled
	SDIO_MASK_RXOVERRIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXOVERRIE_Enabled = 0x1
	// Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDIO_MASK_CMDRENDIE = 0x40
	// Interrupt disabled
	SDIO_MASK_CMDRENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDRENDIE_Enabled = 0x1
	// Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDIO_MASK_CMDSENTIE = 0x80
	// Interrupt disabled
	SDIO_MASK_CMDSENTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDSENTIE_Enabled = 0x1
	// Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDIO_MASK_DATAENDIE = 0x100
	// Interrupt disabled
	SDIO_MASK_DATAENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DATAENDIE_Enabled = 0x1
	// Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDIO_MASK_DBCKENDIE = 0x400
	// Interrupt disabled
	SDIO_MASK_DBCKENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DBCKENDIE_Enabled = 0x1
	// Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDIO_MASK_CMDACTIE = 0x800
	// Interrupt disabled
	SDIO_MASK_CMDACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDACTIE_Enabled = 0x1
	// Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDIO_MASK_TXFIFOHEIE = 0x4000
	// Interrupt disabled
	SDIO_MASK_TXFIFOHEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOHEIE_Enabled = 0x1
	// Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDIO_MASK_RXFIFOHFIE = 0x8000
	// Interrupt disabled
	SDIO_MASK_RXFIFOHFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOHFIE_Enabled = 0x1
	// Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDIO_MASK_RXFIFOFIE = 0x20000
	// Interrupt disabled
	SDIO_MASK_RXFIFOFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOFIE_Enabled = 0x1
	// Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDIO_MASK_TXFIFOEIE = 0x40000
	// Interrupt disabled
	SDIO_MASK_TXFIFOEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOEIE_Enabled = 0x1
	// Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDIO_MASK_RXDAVLIE = 0x200000
	// Interrupt disabled
	SDIO_MASK_RXDAVLIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXDAVLIE_Enabled = 0x1
	// Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDIO_MASK_SDIOITIE = 0x400000
	// Interrupt disabled
	SDIO_MASK_SDIOITIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_SDIOITIE_Enabled = 0x1
	// Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDIO_MASK_TXDAVLIE = 0x100000
	// Interrupt disabled
	SDIO_MASK_TXDAVLIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXDAVLIE_Enabled = 0x1
	// Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDIO_MASK_RXFIFOEIE = 0x80000
	// Interrupt disabled
	SDIO_MASK_RXFIFOEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOEIE_Enabled = 0x1
	// Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDIO_MASK_TXFIFOFIE = 0x10000
	// Interrupt disabled
	SDIO_MASK_TXFIFOFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOFIE_Enabled = 0x1
	// Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDIO_MASK_RXACTIE = 0x2000
	// Interrupt disabled
	SDIO_MASK_RXACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXACTIE_Enabled = 0x1
	// Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDIO_MASK_TXACTIE = 0x1000
	// Interrupt disabled
	SDIO_MASK_TXACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXACTIE_Enabled = 0x1

	// FIFOCNT: The SDIO_FIFOCNT register contains the remaining number of words to be written to or read from the FIFO. The FIFO counter loads the value from the data length register (see SDIO_DLEN) when the data transfer enable bit, DTEN, is set in the data control register (SDIO_DCTRL register) and the DPSM is at the Idle state. If the data length is not word-aligned (multiple of 4), the remaining 1 to 3 bytes are regarded as a word.
	// Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: The receive and transmit FIFOs can be only read or written as word (32-bit) wide registers. The FIFOs contain 16 entries on sequential addresses. This allows the CPU to use its load and store multiple operands to read from/write to the FIFO.When accessing SDMMC_FIFOR with half word or byte access an AHB bus fault is generated.
	// Position of FIFOData field.
	SDIO_FIFO_FIFOData_Pos = 0x0
	// Bit mask of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff
)

// Bitfields for HDMI_CEC: HDMI-CEC controller
const (
	// CEC_CR: CEC control register
	// Position of TXEOM field.
	HDMI_CEC_CEC_CR_TXEOM_Pos = 0x2
	// Bit mask of TXEOM field.
	HDMI_CEC_CEC_CR_TXEOM_Msk = 0x4
	// Bit TXEOM.
	HDMI_CEC_CEC_CR_TXEOM = 0x4
	// Position of TXSOM field.
	HDMI_CEC_CEC_CR_TXSOM_Pos = 0x1
	// Bit mask of TXSOM field.
	HDMI_CEC_CEC_CR_TXSOM_Msk = 0x2
	// Bit TXSOM.
	HDMI_CEC_CEC_CR_TXSOM = 0x2
	// Position of CECEN field.
	HDMI_CEC_CEC_CR_CECEN_Pos = 0x0
	// Bit mask of CECEN field.
	HDMI_CEC_CEC_CR_CECEN_Msk = 0x1
	// Bit CECEN.
	HDMI_CEC_CEC_CR_CECEN = 0x1

	// CEC_CFGR: CEC configuration register
	// Position of LSTN field.
	HDMI_CEC_CEC_CFGR_LSTN_Pos = 0x1f
	// Bit mask of LSTN field.
	HDMI_CEC_CEC_CFGR_LSTN_Msk = 0x80000000
	// Bit LSTN.
	HDMI_CEC_CEC_CFGR_LSTN = 0x80000000
	// Position of OAR field.
	HDMI_CEC_CEC_CFGR_OAR_Pos = 0x10
	// Bit mask of OAR field.
	HDMI_CEC_CEC_CFGR_OAR_Msk = 0x7fff0000
	// Position of SFTOP field.
	HDMI_CEC_CEC_CFGR_SFTOP_Pos = 0x8
	// Bit mask of SFTOP field.
	HDMI_CEC_CEC_CFGR_SFTOP_Msk = 0x100
	// Bit SFTOP.
	HDMI_CEC_CEC_CFGR_SFTOP = 0x100
	// Position of BRDNOGEN field.
	HDMI_CEC_CEC_CFGR_BRDNOGEN_Pos = 0x7
	// Bit mask of BRDNOGEN field.
	HDMI_CEC_CEC_CFGR_BRDNOGEN_Msk = 0x80
	// Bit BRDNOGEN.
	HDMI_CEC_CEC_CFGR_BRDNOGEN = 0x80
	// Position of LBPEGEN field.
	HDMI_CEC_CEC_CFGR_LBPEGEN_Pos = 0x6
	// Bit mask of LBPEGEN field.
	HDMI_CEC_CEC_CFGR_LBPEGEN_Msk = 0x40
	// Bit LBPEGEN.
	HDMI_CEC_CEC_CFGR_LBPEGEN = 0x40
	// Position of BREGEN field.
	HDMI_CEC_CEC_CFGR_BREGEN_Pos = 0x5
	// Bit mask of BREGEN field.
	HDMI_CEC_CEC_CFGR_BREGEN_Msk = 0x20
	// Bit BREGEN.
	HDMI_CEC_CEC_CFGR_BREGEN = 0x20
	// Position of BRESTP field.
	HDMI_CEC_CEC_CFGR_BRESTP_Pos = 0x4
	// Bit mask of BRESTP field.
	HDMI_CEC_CEC_CFGR_BRESTP_Msk = 0x10
	// Bit BRESTP.
	HDMI_CEC_CEC_CFGR_BRESTP = 0x10
	// Position of RXTOL field.
	HDMI_CEC_CEC_CFGR_RXTOL_Pos = 0x3
	// Bit mask of RXTOL field.
	HDMI_CEC_CEC_CFGR_RXTOL_Msk = 0x8
	// Bit RXTOL.
	HDMI_CEC_CEC_CFGR_RXTOL = 0x8
	// Position of SFT field.
	HDMI_CEC_CEC_CFGR_SFT_Pos = 0x0
	// Bit mask of SFT field.
	HDMI_CEC_CEC_CFGR_SFT_Msk = 0x7

	// CEC_TXDR: CEC Tx data register
	// Position of TXD field.
	HDMI_CEC_CEC_TXDR_TXD_Pos = 0x0
	// Bit mask of TXD field.
	HDMI_CEC_CEC_TXDR_TXD_Msk = 0xff

	// CEC_RXDR: CEC Rx Data Register
	// Position of RXD field.
	HDMI_CEC_CEC_RXDR_RXD_Pos = 0x0
	// Bit mask of RXD field.
	HDMI_CEC_CEC_RXDR_RXD_Msk = 0xff

	// CEC_ISR: CEC Interrupt and Status Register
	// Position of TXACKE field.
	HDMI_CEC_CEC_ISR_TXACKE_Pos = 0xc
	// Bit mask of TXACKE field.
	HDMI_CEC_CEC_ISR_TXACKE_Msk = 0x1000
	// Bit TXACKE.
	HDMI_CEC_CEC_ISR_TXACKE = 0x1000
	// Position of TXERR field.
	HDMI_CEC_CEC_ISR_TXERR_Pos = 0xb
	// Bit mask of TXERR field.
	HDMI_CEC_CEC_ISR_TXERR_Msk = 0x800
	// Bit TXERR.
	HDMI_CEC_CEC_ISR_TXERR = 0x800
	// Position of TXUDR field.
	HDMI_CEC_CEC_ISR_TXUDR_Pos = 0xa
	// Bit mask of TXUDR field.
	HDMI_CEC_CEC_ISR_TXUDR_Msk = 0x400
	// Bit TXUDR.
	HDMI_CEC_CEC_ISR_TXUDR = 0x400
	// Position of TXEND field.
	HDMI_CEC_CEC_ISR_TXEND_Pos = 0x9
	// Bit mask of TXEND field.
	HDMI_CEC_CEC_ISR_TXEND_Msk = 0x200
	// Bit TXEND.
	HDMI_CEC_CEC_ISR_TXEND = 0x200
	// Position of TXBR field.
	HDMI_CEC_CEC_ISR_TXBR_Pos = 0x8
	// Bit mask of TXBR field.
	HDMI_CEC_CEC_ISR_TXBR_Msk = 0x100
	// Bit TXBR.
	HDMI_CEC_CEC_ISR_TXBR = 0x100
	// Position of ARBLST field.
	HDMI_CEC_CEC_ISR_ARBLST_Pos = 0x7
	// Bit mask of ARBLST field.
	HDMI_CEC_CEC_ISR_ARBLST_Msk = 0x80
	// Bit ARBLST.
	HDMI_CEC_CEC_ISR_ARBLST = 0x80
	// Position of RXACKE field.
	HDMI_CEC_CEC_ISR_RXACKE_Pos = 0x6
	// Bit mask of RXACKE field.
	HDMI_CEC_CEC_ISR_RXACKE_Msk = 0x40
	// Bit RXACKE.
	HDMI_CEC_CEC_ISR_RXACKE = 0x40
	// Position of LBPE field.
	HDMI_CEC_CEC_ISR_LBPE_Pos = 0x5
	// Bit mask of LBPE field.
	HDMI_CEC_CEC_ISR_LBPE_Msk = 0x20
	// Bit LBPE.
	HDMI_CEC_CEC_ISR_LBPE = 0x20
	// Position of SBPE field.
	HDMI_CEC_CEC_ISR_SBPE_Pos = 0x4
	// Bit mask of SBPE field.
	HDMI_CEC_CEC_ISR_SBPE_Msk = 0x10
	// Bit SBPE.
	HDMI_CEC_CEC_ISR_SBPE = 0x10
	// Position of BRE field.
	HDMI_CEC_CEC_ISR_BRE_Pos = 0x3
	// Bit mask of BRE field.
	HDMI_CEC_CEC_ISR_BRE_Msk = 0x8
	// Bit BRE.
	HDMI_CEC_CEC_ISR_BRE = 0x8
	// Position of RXOVR field.
	HDMI_CEC_CEC_ISR_RXOVR_Pos = 0x2
	// Bit mask of RXOVR field.
	HDMI_CEC_CEC_ISR_RXOVR_Msk = 0x4
	// Bit RXOVR.
	HDMI_CEC_CEC_ISR_RXOVR = 0x4
	// Position of RXEND field.
	HDMI_CEC_CEC_ISR_RXEND_Pos = 0x1
	// Bit mask of RXEND field.
	HDMI_CEC_CEC_ISR_RXEND_Msk = 0x2
	// Bit RXEND.
	HDMI_CEC_CEC_ISR_RXEND = 0x2
	// Position of RXBR field.
	HDMI_CEC_CEC_ISR_RXBR_Pos = 0x0
	// Bit mask of RXBR field.
	HDMI_CEC_CEC_ISR_RXBR_Msk = 0x1
	// Bit RXBR.
	HDMI_CEC_CEC_ISR_RXBR = 0x1

	// CEC_IER: CEC interrupt enable register
	// Position of TXACKIE field.
	HDMI_CEC_CEC_IER_TXACKIE_Pos = 0xc
	// Bit mask of TXACKIE field.
	HDMI_CEC_CEC_IER_TXACKIE_Msk = 0x1000
	// Bit TXACKIE.
	HDMI_CEC_CEC_IER_TXACKIE = 0x1000
	// Position of TXERRIE field.
	HDMI_CEC_CEC_IER_TXERRIE_Pos = 0xb
	// Bit mask of TXERRIE field.
	HDMI_CEC_CEC_IER_TXERRIE_Msk = 0x800
	// Bit TXERRIE.
	HDMI_CEC_CEC_IER_TXERRIE = 0x800
	// Position of TXUDRIE field.
	HDMI_CEC_CEC_IER_TXUDRIE_Pos = 0xa
	// Bit mask of TXUDRIE field.
	HDMI_CEC_CEC_IER_TXUDRIE_Msk = 0x400
	// Bit TXUDRIE.
	HDMI_CEC_CEC_IER_TXUDRIE = 0x400
	// Position of TXENDIE field.
	HDMI_CEC_CEC_IER_TXENDIE_Pos = 0x9
	// Bit mask of TXENDIE field.
	HDMI_CEC_CEC_IER_TXENDIE_Msk = 0x200
	// Bit TXENDIE.
	HDMI_CEC_CEC_IER_TXENDIE = 0x200
	// Position of TXBRIE field.
	HDMI_CEC_CEC_IER_TXBRIE_Pos = 0x8
	// Bit mask of TXBRIE field.
	HDMI_CEC_CEC_IER_TXBRIE_Msk = 0x100
	// Bit TXBRIE.
	HDMI_CEC_CEC_IER_TXBRIE = 0x100
	// Position of ARBLSTIE field.
	HDMI_CEC_CEC_IER_ARBLSTIE_Pos = 0x7
	// Bit mask of ARBLSTIE field.
	HDMI_CEC_CEC_IER_ARBLSTIE_Msk = 0x80
	// Bit ARBLSTIE.
	HDMI_CEC_CEC_IER_ARBLSTIE = 0x80
	// Position of RXACKIE field.
	HDMI_CEC_CEC_IER_RXACKIE_Pos = 0x6
	// Bit mask of RXACKIE field.
	HDMI_CEC_CEC_IER_RXACKIE_Msk = 0x40
	// Bit RXACKIE.
	HDMI_CEC_CEC_IER_RXACKIE = 0x40
	// Position of LBPEIE field.
	HDMI_CEC_CEC_IER_LBPEIE_Pos = 0x5
	// Bit mask of LBPEIE field.
	HDMI_CEC_CEC_IER_LBPEIE_Msk = 0x20
	// Bit LBPEIE.
	HDMI_CEC_CEC_IER_LBPEIE = 0x20
	// Position of SBPEIE field.
	HDMI_CEC_CEC_IER_SBPEIE_Pos = 0x4
	// Bit mask of SBPEIE field.
	HDMI_CEC_CEC_IER_SBPEIE_Msk = 0x10
	// Bit SBPEIE.
	HDMI_CEC_CEC_IER_SBPEIE = 0x10
	// Position of BREIE field.
	HDMI_CEC_CEC_IER_BREIE_Pos = 0x3
	// Bit mask of BREIE field.
	HDMI_CEC_CEC_IER_BREIE_Msk = 0x8
	// Bit BREIE.
	HDMI_CEC_CEC_IER_BREIE = 0x8
	// Position of RXOVRIE field.
	HDMI_CEC_CEC_IER_RXOVRIE_Pos = 0x2
	// Bit mask of RXOVRIE field.
	HDMI_CEC_CEC_IER_RXOVRIE_Msk = 0x4
	// Bit RXOVRIE.
	HDMI_CEC_CEC_IER_RXOVRIE = 0x4
	// Position of RXENDIE field.
	HDMI_CEC_CEC_IER_RXENDIE_Pos = 0x1
	// Bit mask of RXENDIE field.
	HDMI_CEC_CEC_IER_RXENDIE_Msk = 0x2
	// Bit RXENDIE.
	HDMI_CEC_CEC_IER_RXENDIE = 0x2
	// Position of RXBRIE field.
	HDMI_CEC_CEC_IER_RXBRIE_Pos = 0x0
	// Bit mask of RXBRIE field.
	HDMI_CEC_CEC_IER_RXBRIE_Msk = 0x1
	// Bit RXBRIE.
	HDMI_CEC_CEC_IER_RXBRIE = 0x1
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control register
	// Position of LSPACT field.
	FPU_FPCCR_LSPACT_Pos = 0x0
	// Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1
	// Bit LSPACT.
	FPU_FPCCR_LSPACT = 0x1
	// Position of USER field.
	FPU_FPCCR_USER_Pos = 0x1
	// Bit mask of USER field.
	FPU_FPCCR_USER_Msk = 0x2
	// Bit USER.
	FPU_FPCCR_USER = 0x2
	// Position of THREAD field.
	FPU_FPCCR_THREAD_Pos = 0x3
	// Bit mask of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8
	// Bit THREAD.
	FPU_FPCCR_THREAD = 0x8
	// Position of HFRDY field.
	FPU_FPCCR_HFRDY_Pos = 0x4
	// Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY_Msk = 0x10
	// Bit HFRDY.
	FPU_FPCCR_HFRDY = 0x10
	// Position of MMRDY field.
	FPU_FPCCR_MMRDY_Pos = 0x5
	// Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY_Msk = 0x20
	// Bit MMRDY.
	FPU_FPCCR_MMRDY = 0x20
	// Position of BFRDY field.
	FPU_FPCCR_BFRDY_Pos = 0x6
	// Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY_Msk = 0x40
	// Bit BFRDY.
	FPU_FPCCR_BFRDY = 0x40
	// Position of MONRDY field.
	FPU_FPCCR_MONRDY_Pos = 0x8
	// Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100
	// Bit MONRDY.
	FPU_FPCCR_MONRDY = 0x100
	// Position of LSPEN field.
	FPU_FPCCR_LSPEN_Pos = 0x1e
	// Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN_Msk = 0x40000000
	// Bit LSPEN.
	FPU_FPCCR_LSPEN = 0x40000000
	// Position of ASPEN field.
	FPU_FPCCR_ASPEN_Pos = 0x1f
	// Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN_Msk = 0x80000000
	// Bit ASPEN.
	FPU_FPCCR_ASPEN = 0x80000000

	// FPCAR: Floating-point context address register
	// Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Pos = 0x3
	// Bit mask of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8

	// FPSCR: Floating-point status control register
	// Position of IOC field.
	FPU_FPSCR_IOC_Pos = 0x0
	// Bit mask of IOC field.
	FPU_FPSCR_IOC_Msk = 0x1
	// Bit IOC.
	FPU_FPSCR_IOC = 0x1
	// Position of DZC field.
	FPU_FPSCR_DZC_Pos = 0x1
	// Bit mask of DZC field.
	FPU_FPSCR_DZC_Msk = 0x2
	// Bit DZC.
	FPU_FPSCR_DZC = 0x2
	// Position of OFC field.
	FPU_FPSCR_OFC_Pos = 0x2
	// Bit mask of OFC field.
	FPU_FPSCR_OFC_Msk = 0x4
	// Bit OFC.
	FPU_FPSCR_OFC = 0x4
	// Position of UFC field.
	FPU_FPSCR_UFC_Pos = 0x3
	// Bit mask of UFC field.
	FPU_FPSCR_UFC_Msk = 0x8
	// Bit UFC.
	FPU_FPSCR_UFC = 0x8
	// Position of IXC field.
	FPU_FPSCR_IXC_Pos = 0x4
	// Bit mask of IXC field.
	FPU_FPSCR_IXC_Msk = 0x10
	// Bit IXC.
	FPU_FPSCR_IXC = 0x10
	// Position of IDC field.
	FPU_FPSCR_IDC_Pos = 0x7
	// Bit mask of IDC field.
	FPU_FPSCR_IDC_Msk = 0x80
	// Bit IDC.
	FPU_FPSCR_IDC = 0x80
	// Position of RMode field.
	FPU_FPSCR_RMode_Pos = 0x16
	// Bit mask of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000
	// Position of FZ field.
	FPU_FPSCR_FZ_Pos = 0x18
	// Bit mask of FZ field.
	FPU_FPSCR_FZ_Msk = 0x1000000
	// Bit FZ.
	FPU_FPSCR_FZ = 0x1000000
	// Position of DN field.
	FPU_FPSCR_DN_Pos = 0x19
	// Bit mask of DN field.
	FPU_FPSCR_DN_Msk = 0x2000000
	// Bit DN.
	FPU_FPSCR_DN = 0x2000000
	// Position of AHP field.
	FPU_FPSCR_AHP_Pos = 0x1a
	// Bit mask of AHP field.
	FPU_FPSCR_AHP_Msk = 0x4000000
	// Bit AHP.
	FPU_FPSCR_AHP = 0x4000000
	// Position of V field.
	FPU_FPSCR_V_Pos = 0x1c
	// Bit mask of V field.
	FPU_FPSCR_V_Msk = 0x10000000
	// Bit V.
	FPU_FPSCR_V = 0x10000000
	// Position of C field.
	FPU_FPSCR_C_Pos = 0x1d
	// Bit mask of C field.
	FPU_FPSCR_C_Msk = 0x20000000
	// Bit C.
	FPU_FPSCR_C = 0x20000000
	// Position of Z field.
	FPU_FPSCR_Z_Pos = 0x1e
	// Bit mask of Z field.
	FPU_FPSCR_Z_Msk = 0x40000000
	// Bit Z.
	FPU_FPSCR_Z = 0x40000000
	// Position of N field.
	FPU_FPSCR_N_Pos = 0x1f
	// Bit mask of N field.
	FPU_FPSCR_N_Msk = 0x80000000
	// Bit N.
	FPU_FPSCR_N = 0x80000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCRS: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCRS_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCRS_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCRS_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCRS_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCRS_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCRS_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCRS_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCRS_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCRS_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCRS_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCRS_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCRS_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)
