/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EndianConverter {
    public static byte[] writeShort(short value) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(value).array();
    }

    public static byte[] writeInt(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
    }

    public static byte[] writeDouble(double value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(Double.doubleToLongBits(value)).array();
    }

    public static short readShort(byte[] value) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).put(value).getShort(0);
    }

    public static int readInt(byte[] value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).put(value).getInt(0);
    }

    public static double readDouble(byte[] value) {
        return Double.longBitsToDouble(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).put(value).getLong(0));
    }
}

