/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.NetMask;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRFilter
extends FilterBase {
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    private final Log log = LogFactory.getLog(RemoteCIDRFilter.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String string) {
        List<String> list = this.fillFromInput(string, this.allow);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            this.log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"allow"}));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String string) {
        List<String> list = this.fillFromInput(string, this.deny);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            this.log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"deny"}));
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isAllowed(servletRequest.getRemoteAddr())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            this.sendErrorWhenNotHttp(servletResponse);
            return;
        }
        ((HttpServletResponse)servletResponse).sendError(403);
    }

    @Override
    public Log getLogger() {
        return this.log;
    }

    private boolean isAllowed(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.log.error((Object)sm.getString("remoteCidrFilter.noRemoteIp"), (Throwable)unknownHostException);
            return false;
        }
        for (NetMask netMask : this.deny) {
            if (!netMask.matches(inetAddress)) continue;
            return false;
        }
        for (NetMask netMask : this.allow) {
            if (!netMask.matches(inetAddress)) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private void sendErrorWhenNotHttp(ServletResponse servletResponse) throws IOException {
        PrintWriter printWriter = servletResponse.getWriter();
        servletResponse.setContentType(PLAIN_TEXT_MIME_TYPE);
        printWriter.write(sm.getString("http.403"));
        printWriter.flush();
    }

    private List<String> fillFromInput(String string, List<NetMask> list) {
        list.clear();
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : string.split("\\s*,\\s*")) {
            try {
                NetMask netMask = new NetMask(string2);
                list.add(netMask);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                linkedList.add(string2 + ": " + illegalArgumentException.getMessage());
            }
        }
        return Collections.unmodifiableList(linkedList);
    }
}

