/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.util.ArrayList;
import java.util.List;

class ReadLineBuffer {
    private int currentIndex = 0;
    private int size;
    private final int capacity;
    private final Line[] lines;

    ReadLineBuffer(int n) {
        this.capacity = n;
        this.lines = new Line[n];
    }

    void addLine(int n, String string) {
        this.lines[this.currentIndex] = new Line(n, string);
        this.currentIndex = (this.currentIndex + 1) % this.capacity;
        if (this.size < this.capacity) {
            ++this.size;
        }
    }

    List<Line> getLines() {
        ArrayList<Line> arrayList = new ArrayList<Line>(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayList.add(this.lines[(this.currentIndex - this.size + i + this.capacity) % this.capacity]);
        }
        return arrayList;
    }

    static class Line {
        private final int number;
        private final String text;

        Line(int n, String string) {
            this.number = n;
            this.text = string;
        }

        int getNumber() {
            return this.number;
        }

        String getText() {
            return this.text;
        }
    }
}

