/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManager.class.getName());
    private final JcaJceHelper helper;
    private final List<KeyStore.Builder> builders;
    private final Map<String, SoftReference<KeyStore.PrivateKeyEntry>> cachedEntries = Collections.synchronizedMap(new LinkedHashMap<String, SoftReference<KeyStore.PrivateKeyEntry>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SoftReference<KeyStore.PrivateKeyEntry>> entry) {
            return this.size() > 16;
        }
    });
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManager.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManager.createFiltersServer();
    private final AtomicLong versions = new AtomicLong();

    private static void addFilter(Map<String, PublicKeyFilter> map, String string) {
        String string2 = string;
        ProvX509KeyManager.addFilter(map, string2, null, 0, string);
    }

    private static void addFilter(Map<String, PublicKeyFilter> map, Class<? extends PublicKey> clazz, String ... stringArray) {
        ProvX509KeyManager.addFilter(map, null, clazz, 0, stringArray);
    }

    private static void addFilter(Map<String, PublicKeyFilter> map, String string, Class<? extends PublicKey> clazz, int n, String ... stringArray) {
        PublicKeyFilter publicKeyFilter = new PublicKeyFilter(string, clazz, n);
        for (String string2 : stringArray) {
            if (null == map.put(string2.toUpperCase(Locale.ENGLISH), publicKeyFilter)) continue;
            throw new IllegalStateException("Duplicate names in filters");
        }
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> hashMap = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(hashMap, "Ed25519");
        ProvX509KeyManager.addFilter(hashMap, "Ed448");
        ProvX509KeyManager.addFilter(hashMap, DSAPublicKey.class, "DSA");
        ProvX509KeyManager.addFilter(hashMap, ECPublicKey.class, "EC");
        ProvX509KeyManager.addFilter(hashMap, RSAPublicKey.class, "RSA");
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> hashMap = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(hashMap, "Ed25519");
        ProvX509KeyManager.addFilter(hashMap, "Ed448");
        ProvX509KeyManager.addFilter(hashMap, DSAPublicKey.class, "DHE_DSS", "SRP_DSS");
        ProvX509KeyManager.addFilter(hashMap, ECPublicKey.class, "ECDHE_ECDSA");
        ProvX509KeyManager.addFilter(hashMap, RSAPublicKey.class, "DHE_RSA", "ECDHE_RSA", "SRP_RSA");
        ProvX509KeyManager.addFilter(hashMap, null, RSAPublicKey.class, 2, "RSA");
        return Collections.unmodifiableMap(hashMap);
    }

    ProvX509KeyManager(JcaJceHelper jcaJceHelper, List<KeyStore.Builder> list) {
        this.helper = jcaJceHelper;
        this.builders = list;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), false);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(string), principalArray, TransportData.from(sSLEngine), true);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(string), principalArray, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry(string);
        return null == privateKeyEntry ? null : (X509Certificate[])privateKeyEntry.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(string), principalArray, null, false);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry(string);
        return null == privateKeyEntry ? null : privateKeyEntry.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(string), principalArray, null, true);
    }

    private String chooseAlias(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        Object object;
        Match match = Match.NOTHING;
        if (!this.builders.isEmpty() && !list.isEmpty()) {
            object = JsseUtils.toX500Names(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManager.getRequestedHostName(transportData, bl);
            int n = this.builders.size();
            for (int i = 0; i < n; ++i) {
                try {
                    Match match2 = this.chooseAliasFromBuilder(i, list, (Set<X500Name>)object, bCAlgorithmConstraints, bl, date, string);
                    if (match2.compareTo(match) >= 0) continue;
                    match = match2;
                    if (Match.Quality.OK != match.quality) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (Match.NOTHING == match) {
            LOG.fine("No matching key found");
            return null;
        }
        object = ProvX509KeyManager.getAlias(match, this.getNextVersionSuffix());
        LOG.fine("Found matching key, returning alias: " + (String)object);
        return object;
    }

    private Match chooseAliasFromBuilder(int n, List<String> list, Set<X500Name> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) throws Exception {
        KeyStore.Builder builder = this.builders.get(n);
        KeyStore keyStore = builder.getKeyStore();
        Match match = Match.NOTHING;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            Match match2 = this.getPotentialMatch(n, keyStore, string2, match.quality, list, set, bCAlgorithmConstraints, bl, date, string);
            if (null == match2) continue;
            match = match2;
            if (Match.Quality.OK != match.quality) continue;
            break;
        }
        return match;
    }

    private String[] getAliases(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        if (!this.builders.isEmpty() && !list.isEmpty()) {
            Set<X500Name> set = JsseUtils.toX500Names(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManager.getRequestedHostName(transportData, bl);
            List<Match> list2 = null;
            int n = this.builders.size();
            for (int i = 0; i < n; ++i) {
                try {
                    List<Match> list3 = this.getAliasesFromBuilder(i, list, set, bCAlgorithmConstraints, bl, date, string);
                    list2 = ProvX509KeyManager.addToAllMatches(list2, list3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null != list2 && !list2.isEmpty()) {
                Collections.sort(list2);
                return ProvX509KeyManager.getAliases(list2, this.getNextVersionSuffix());
            }
        }
        return null;
    }

    private List<Match> getAliasesFromBuilder(int n, List<String> list, Set<X500Name> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) throws Exception {
        KeyStore.Builder builder = this.builders.get(n);
        KeyStore keyStore = builder.getKeyStore();
        List<Match> list2 = null;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            Match match = this.getPotentialMatch(n, keyStore, string2, Match.Quality.NONE, list, set, bCAlgorithmConstraints, bl, date, string);
            if (null == match) continue;
            list2 = ProvX509KeyManager.addToMatches(list2, match);
        }
        return list2;
    }

    private String getNextVersionSuffix() {
        return "." + this.versions.incrementAndGet();
    }

    private Match getPotentialMatch(int n, KeyStore keyStore, String string, Match.Quality quality, List<String> list, Set<X500Name> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string2) throws Exception {
        Match.Quality quality2;
        X509Certificate[] x509CertificateArray;
        if (keyStore.isKeyEntry(string) && this.isSuitableChain(x509CertificateArray = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(string)), list, set, bCAlgorithmConstraints, bl) && (quality2 = ProvX509KeyManager.getCertificateQuality(x509CertificateArray[0], date, string2)).compareTo(quality) < 0) {
            return new Match(n, string, quality2);
        }
        return null;
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        if (null == string) {
            return null;
        }
        SoftReference<KeyStore.PrivateKeyEntry> softReference = this.cachedEntries.get(string);
        if (null != softReference && null != (privateKeyEntry = softReference.get())) {
            return privateKeyEntry;
        }
        privateKeyEntry = this.loadPrivateKeyEntry(string);
        if (null != privateKeyEntry) {
            this.cachedEntries.put(string, new SoftReference<KeyStore.PrivateKeyEntry>(privateKeyEntry));
        }
        return privateKeyEntry;
    }

    private boolean isSuitableChain(X509Certificate[] x509CertificateArray, List<String> list, Set<X500Name> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl) {
        if (null == x509CertificateArray || x509CertificateArray.length < 1 || !ProvX509KeyManager.isSuitableChainForIssuers(x509CertificateArray, set) || !ProvX509KeyManager.isSuitableEECert(x509CertificateArray[0], list, bCAlgorithmConstraints, bl)) {
            return false;
        }
        try {
            Set<X509Certificate> set2 = Collections.emptySet();
            KeyPurposeId keyPurposeId = ProvX509TrustManager.getRequiredExtendedKeyUsage(bl);
            int n = -1;
            ProvAlgorithmChecker.checkChain(this.helper, bCAlgorithmConstraints, set2, x509CertificateArray, keyPurposeId, n);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
        return true;
    }

    private KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = string.indexOf(46, n4);
            if (n5 > n4 && (n3 = string.indexOf(46, n2 = n5 + 1)) > n2 && 0 <= (n = Integer.parseInt(string.substring(n4, n5))) && n < this.builders.size()) {
                KeyStore.ProtectionParameter protectionParameter;
                KeyStore.Builder builder = this.builders.get(n);
                String string2 = string.substring(n2, n3);
                KeyStore keyStore = builder.getKeyStore();
                KeyStore.Entry entry = keyStore.getEntry(string2, protectionParameter = builder.getProtectionParameter(string2));
                if (entry instanceof KeyStore.PrivateKeyEntry) {
                    return (KeyStore.PrivateKeyEntry)entry;
                }
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINER, "Failed to load PrivateKeyEntry: " + string, exception);
        }
        return null;
    }

    private static List<Match> addToAllMatches(List<Match> list, List<Match> list2) {
        if (null != list2 && !list2.isEmpty()) {
            if (null == list) {
                list = list2;
            } else {
                list.addAll(list2);
            }
        }
        return list;
    }

    private static List<Match> addToMatches(List<Match> list, Match match) {
        if (null == list) {
            list = new ArrayList<Match>();
        }
        list.add(match);
        return list;
    }

    private static String getAlias(Match match, String string) {
        return match.builderIndex + "." + match.localAlias + string;
    }

    private static String[] getAliases(List<Match> list, String string) {
        int n = list.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (Match match : list) {
            stringArray[n2++] = ProvX509KeyManager.getAlias(match, string);
        }
        return stringArray;
    }

    private static Match.Quality getCertificateQuality(X509Certificate x509Certificate, Date date, String string) {
        try {
            x509Certificate.checkValidity(date);
        }
        catch (CertificateException certificateException) {
            return Match.Quality.EXPIRED;
        }
        if (null != string) {
            try {
                ProvX509TrustManager.checkEndpointID(string, x509Certificate, "HTTPS");
            }
            catch (CertificateException certificateException) {
                return Match.Quality.MISMATCH_SNI;
            }
        }
        return Match.Quality.OK;
    }

    private static List<String> getKeyTypes(String ... stringArray) {
        if (null != stringArray && stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                if (null == string) continue;
                arrayList.add(string.toUpperCase(Locale.ENGLISH));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static String getRequestedHostName(TransportData transportData, boolean bl) {
        BCSNIHostName bCSNIHostName;
        BCExtendedSSLSession bCExtendedSSLSession;
        if (null != transportData && bl && null != (bCExtendedSSLSession = transportData.getHandshakeSession()) && null != (bCSNIHostName = JsseUtils.getSNIHostName(bCExtendedSSLSession.getRequestedServerNames()))) {
            return bCSNIHostName.getAsciiName();
        }
        return null;
    }

    private static boolean hasSuitableIssuer(X509Certificate x509Certificate, Set<X500Name> set) {
        return set.contains(JsseUtils.toX500Name(x509Certificate.getIssuerX500Principal()));
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] x509CertificateArray, Set<X500Name> set) {
        if (null == set || set.isEmpty()) {
            return true;
        }
        int n = x509CertificateArray.length;
        while (--n >= 0) {
            if (!ProvX509KeyManager.hasSuitableIssuer(x509CertificateArray[n], set)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuitableEECert(X509Certificate x509Certificate, List<String> list, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl) {
        Map<String, PublicKeyFilter> map = bl ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = x509Certificate.getPublicKey();
        boolean[] blArray = x509Certificate.getKeyUsage();
        for (String string : list) {
            PublicKeyFilter publicKeyFilter = map.get(string);
            if (null == publicKeyFilter || !publicKeyFilter.accepts(publicKey, blArray, bCAlgorithmConstraints)) continue;
            return true;
        }
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        PublicKeyFilter(String string, Class<? extends PublicKey> clazz, int n) {
            this.algorithm = string;
            this.clazz = clazz;
            this.keyUsageBit = n;
        }

        boolean accepts(PublicKey publicKey, boolean[] blArray, BCAlgorithmConstraints bCAlgorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, blArray, this.keyUsageBit, bCAlgorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return null != this.algorithm && this.algorithm.equalsIgnoreCase(publicKey.getAlgorithm()) || null != this.clazz && this.clazz.isInstance(publicKey);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Match
    implements Comparable<Match> {
        static final Match NOTHING = new Match(-1, null, Quality.NONE);
        final int builderIndex;
        final String localAlias;
        final Quality quality;

        Match(int n, String string, Quality quality) {
            this.builderIndex = n;
            this.localAlias = string;
            this.quality = quality;
        }

        @Override
        public int compareTo(Match match) {
            return this.quality.compareTo(match.quality);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static enum Quality {
            OK,
            MISMATCH_SNI,
            EXPIRED,
            NONE;

        }
    }
}

