// SDB-CGEN V1.8.0
// gcc -DMAIN=1 xtensa.c ; ./a.out > xtensa.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"abs","absolute value"}, 
  {"abs.s","absolute value single"}, 
  {"add","add"}, 
  {"add.n","narrow add"}, 
  {"add.s","add single"}, 
  {"addi","add immediate"}, 
  {"addi.n","narrow add immediate"}, 
  {"addmi","add immediate with shift by 8"}, 
  {"addx2","add with shift by 1"}, 
  {"addx4","add with shift by 2"}, 
  {"addx8","add with shift by 3"}, 
  {"all4","all 4 booleans true"}, 
  {"all8","all 8 booleans true"}, 
  {"and","bitwise logical and"}, 
  {"andb","boolean and"}, 
  {"andbc","boolean and with complement"}, 
  {"any4","any 4 booleans true"}, 
  {"any8","any 8 booleans true"}, 
  {"ball","branch if all bits set"}, 
  {"bany","branch if any bit set"}, 
  {"bbc","branch if bit clear"}, 
  {"bbci","branch if bit clear immediate"}, 
  {"bbci.l","branch if bit clear immediate LE"}, 
  {"bbs","branch if bit set"}, 
  {"bbsi","branch if bit set immediate"}, 
  {"bbsi.l","branch if bit set immediate LE"}, 
  {"beq","branch if equal"}, 
  {"beqi","branch if equal immediate"}, 
  {"beqz","branch if equal to zero"}, 
  {"beqz.n","narrow branch if equal zero"}, 
  {"bf","branch if false"}, 
  {"bge","branch if greater than or equal"}, 
  {"bgei","branch if greater than or equal immediate"}, 
  {"bgeu","branch if greater than or equal unsigned"}, 
  {"bgeui","i branch if greater than or equal unsigned immediate"}, 
  {"bgez","branch if greater than or equal to zero"}, 
  {"blt","branch if less than"}, 
  {"blti","branch if less than immediate"}, 
  {"bltu","branch if less than unsigned"}, 
  {"bltui","branch if less than unsigned immediate"}, 
  {"bltz","branch if less than zero"}, 
  {"bnall","branch if not-all bits set"}, 
  {"bne","branch if not equal"}, 
  {"bnei","branch if not equal immediate"}, 
  {"bnez","branch if not-equal to zero"}, 
  {"bnez.n","narrow branch if not equal zero"}, 
  {"bnone","branch if no bit set"}, 
  {"break","breakpoint"}, 
  {"break.n","narrow breakpoint"}, 
  {"bt","branch if true"}, 
  {"call0","non-windowed call"}, 
  {"call12","call PC-relative, rotate window by 12"}, 
  {"call4","call PC-relative, rotate window by 4"}, 
  {"call8","call PC-relative, rotate window by 8"}, 
  {"callx0","non-windowed call register"}, 
  {"callx12","call register, rotate window by 12"}, 
  {"callx4","call register, rotate window by 4"}, 
  {"callx8","call register, rotate window by 8"}, 
  {"ceil.s","ceiling single to fixed"}, 
  {"clamps","signed clamp"}, 
  {"dhi","data cache hit invalidate"}, 
  {"dhu","data cache hit unlock"}, 
  {"dhwb","data cache hit writeback"}, 
  {"dhwbi","data cache hit writeback invalidate"}, 
  {"dii","data cache index invalidate"}, 
  {"diu","data cache index unlock"}, 
  {"diwb","data cache index write back"}, 
  {"diwbi","data cache index write back invalidate"}, 
  {"dpfl","data cache prefetch and lock"}, 
  {"dpfr","data cache prefetch for read"}, 
  {"dpfro","data cache prefetch for read once"}, 
  {"dpfw","data cache prefetch for write"}, 
  {"dpfwo","data cache prefetch for write once"}, 
  {"dsync","load/store synchronize"}, 
  {"entry","subroutine entry"}, 
  {"esync","execute synchronize"}, 
  {"excw","exception wait"}, 
  {"extui","extract unsigned immediate"}, 
  {"extw","external wait"}, 
  {"float.s","convert fixed to single"}, 
  {"floor.s","floor single to fixed"}, 
  {"idtlb","invalidate data TLB entry"}, 
  {"ihi","instruction cache hit invalidate"}, 
  {"ihu","instruction cache hit unlock"}, 
  {"iii","instruction cache index invalidate"}, 
  {"iitlb","invalidate instruction TLB entry"}, 
  {"iiu","instruction cache index unlock"}, 
  {"ill","illegal instruction"}, 
  {"ill.n","narrow illegal instruction"}, 
  {"ipf","instruction cache prefetch"}, 
  {"ipfl","instruction cache prefetch and lock"}, 
  {"isync","instruction fetch synchronize"}, 
  {"j","unconditional jump"}, 
  {"j.l","unconditional jump long"}, 
  {"jx","unconditional jump register"}, 
  {"l16si","load 16-bit signed"}, 
  {"l16ui","load 16-bit unsigned"}, 
  {"l32ai","load 32-bit acquire"}, 
  {"l32e","load 32-bit for window exceptions"}, 
  {"l32i","load 32-bit"}, 
  {"l32i.n","narrow load 32-bit"}, 
  {"l32r","load 32-bit PC-relative"}, 
  {"l8ui","load 8-bit unsigned"}, 
  {"ldct","load data cache tag"}, 
  {"lddec","load with autodecrement"}, 
  {"ldinc","load with autoincrement"}, 
  {"lict","load instruction cache tag"}, 
  {"licw","load instruction cache word"}, 
  {"loop","loop"}, 
  {"loopgtz","loop if greater than zero"}, 
  {"loopnez","loop if not-equal zero"}, 
  {"lsi","load single immediate"}, 
  {"lsiu","load single immediate with update"}, 
  {"lsx","load single indexed"}, 
  {"lsxu","load single indexed with update"}, 
  {"madd.s","multiply and add single"}, 
  {"max","maximum value"}, 
  {"maxu","maximum value unsigned"}, 
  {"memw","memory wait"}, 
  {"min","minimum value"}, 
  {"minu","minimum value unsigned"}, 
  {"mov","move"}, 
  {"mov.n","narrow move"}, 
  {"mov.s","move single"}, 
  {"moveqz","move if equal to zero"}, 
  {"moveqz.s","move single if equal to zero"}, 
  {"movf","move if false"}, 
  {"movf.s","move single if false"}, 
  {"movgez","move if greater than or equal to zero"}, 
  {"movgez.s","move single if greater than or equal to zero"}, 
  {"movi","move immediate"}, 
  {"movi.n","narrow move immediate"}, 
  {"movltz","move if less than zero"}, 
  {"movltz.s","move single if less than zero"}, 
  {"movnez","move if not-equal to zero"}, 
  {"movnez.s","move single if not equal to zero"}, 
  {"movsp","move to stack pointer"}, 
  {"movt","move if true"}, 
  {"movt.s","move single if true"}, 
  {"msub.s","multiply and subtract single"}, 
  {"mul.s","multiply single"}, 
  {"mul16s","multiply 16-bit signed"}, 
  {"mul16u","multiply 16-bit unsigned"}, 
  {"mull","multiply low"}, 
  {"mulsh","multiply signed high"}, 
  {"muluh","multiply unsigned high"}, 
  {"neg","negate"}, 
  {"neg.s","negate single"}, 
  {"nop","no-operation"}, 
  {"nop.n","narrow no-operation"}, 
  {"nsa","normalization shift amount"}, 
  {"nsau","normalization shift amount unsigned"}, 
  {"oeq.s","compare single equal"}, 
  {"ole.s","compare single ordered and less than or equal"}, 
  {"olt.s","compare single ordered and less than"}, 
  {"or","bitwise logical or"}, 
  {"orb","boolean or"}, 
  {"orbc","boolean or with complement"}, 
  {"pdtlb","probe data tlb"}, 
  {"pitlb","probe instruction TLB"}, 
  {"quos","quotient signed"}, 
  {"quou","quotient unsigned"}, 
  {"rdtlb0","read data TLB entry virtual"}, 
  {"rdtlb1","read data TLB entry translation"}, 
  {"rems","remainder signed"}, 
  {"remu","remainder unsigned"}, 
  {"rer","read external register"}, 
  {"ret","non-windowed return"}, 
  {"ret.n","narrow non-windowed return"}, 
  {"retw","windowed return"}, 
  {"retw.n","narrow windowed return"}, 
  {"rfdd","return from debug and dispatch"}, 
  {"rfde","return from double exception"}, 
  {"rfdo","return from debug operation"}, 
  {"rfe","return from exception"}, 
  {"rfi","return from high-priority interrupt"}, 
  {"rfme","return from memory error"}, 
  {"rfr","move FR to AR"}, 
  {"rfue","return from user-mode exception"}, 
  {"rfwo","return from window overflow"}, 
  {"rfwu","return from window underflow"}, 
  {"ritlb0","read instruction TLB entry virtual"}, 
  {"ritlb1","read instruction TLB entry translation"}, 
  {"rotw","rotate window"}, 
  {"round.s","round single to fixed"}, 
  {"rsil","read and set interrupt level"}, 
  {"rsr","read special register"}, 
  {"rsync","register read synchronize"}, 
  {"rur","read user register"}, 
  {"s16i","store 16-bit"}, 
  {"s32c1i","store 32-bit compare conditional"}, 
  {"s32e","store 32-bit for window exceptions"}, 
  {"s32i","store 32-bit"}, 
  {"s32i.n","narrow store 32-bit"}, 
  {"s32ri","store 32-bit release"}, 
  {"s8i","store 8-bit"}, 
  {"sdct","store data cache tag"}, 
  {"sext","sign extend"}, 
  {"sict","store instruction cache tag"}, 
  {"sicw","store instruction cache word"}, 
  {"simcall","simulator call"}, 
  {"sll","shift left logical"}, 
  {"slli","shift left logical immediate"}, 
  {"sra","shift right arithmetic"}, 
  {"srai","shift right arithmetic immediate"}, 
  {"src","shift right combined"}, 
  {"srl","shift right logical"}, 
  {"srli","shift right logical immediate"}, 
  {"ssa8b","set shift amount for BE byte shift"}, 
  {"ssa8l","set shift amount for LE byte shift"}, 
  {"ssai","set shift amount immediate"}, 
  {"ssi","store single immediate"}, 
  {"ssiu","store single immediate with update"}, 
  {"ssl","set shift amount for left shift"}, 
  {"ssr","set shift amount for right shift"}, 
  {"ssx","store single indexed"}, 
  {"ssxu","store single indexed with update"}, 
  {"sub","subtract"}, 
  {"sub.s","subtract single"}, 
  {"subx2","subtract with shift by 1"}, 
  {"subx4","subtract with shift by 2"}, 
  {"subx8","subtract with shift by 3"}, 
  {"syscall","system call"}, 
  {"trunc.s","truncate single to fixed"}, 
  {"ueq.s","compare single unordered or equal"}, 
  {"ufloat.s","convert unsigned fixed to single"}, 
  {"ule.s","compare single unord or less than or equal"}, 
  {"ult.s","compare single unordered or less than"}, 
  {"un.s","compare single unordered"}, 
  {"utrunc.s","truncate single to fixed unsigned"}, 
  {"waiti","wait for interrupt"}, 
  {"wdtlb","write data TLB entry"}, 
  {"wer","write external register"}, 
  {"wfr","move AR to FR"}, 
  {"witlb","write instruction TLB entry"}, 
  {"wsr","write special register"}, 
  {"wur","write user register"}, 
  {"xor","bitwise logical exclusive or"}, 
  {"xorb","boolean exclusive or"}, 
  {"xsr","exchange special register"}, 
  {NULL, NULL}
};
// 0x55b0a201a0
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_xtensa_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_xtensa_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_xtensa(x,y) gperf_xtensa_hash(x)
const unsigned int gperf_xtensa_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_xtensa = {
  .name = "xtensa",
  .get = &gperf_xtensa_get,
  .hash = &gperf_xtensa_hash,
  .foreach = &gperf_xtensa_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_xtensa.get)("foo");
	printf ("%s\n", s);
}
#endif
