/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    public static BundleInfo parseManifest(Manifest cloneable) throws ParseException {
        Object object5;
        Object object2 = ((Attributes)(cloneable = ((Manifest)cloneable).getMainAttributes())).getValue("Bundle-ManifestVersion");
        if (object2 == null) {
            throw new ParseException("No Bundle-ManifestVersion in the manifest", 0);
        }
        object2 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Bundle-SymbolicName")).getSingleValue();
        if (object2 == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        Object object3 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Bundle-Description")).getSingleValue();
        if (object3 == null) {
            object3 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Bundle-Description")).getSingleValue();
        }
        Object object42 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Bundle-Version")).getSingleValue();
        try {
            object5 = ManifestParser.versionOf((String)object42);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + (String)object42 + " (" + numberFormatException.getMessage() + ")", 0);
        }
        object2 = new BundleInfo((String)object2, (Version)object5);
        ((BundleInfo)object2).setDescription((String)object3);
        object3 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Bundle-RequiredExecutionEnvironment")).getValues();
        ((BundleInfo)object2).setExecutionEnvironments((List)object3);
        ManifestParser.parseRequirement((BundleInfo)object2, (Attributes)cloneable, "Require-Bundle", "bundle", "bundle-version");
        ManifestParser.parseRequirement((BundleInfo)object2, (Attributes)cloneable, "Import-Package", "package", "version");
        ManifestParser.parseRequirement((BundleInfo)object2, (Attributes)cloneable, "Import-Service", "service", "version");
        object3 = new ManifestHeaderValue(((Attributes)cloneable).getValue("Export-Package"));
        for (Object object42 : ((ManifestHeaderValue)object3).getElements()) {
            Version version;
            object5 = (String)((ManifestHeaderElement)object42).getAttributes().get("version");
            try {
                version = ManifestParser.versionOf((String)object5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The Export-Package has an incorrect version: " + (String)object5 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (Object object5 : ((ManifestHeaderElement)object42).getValues()) {
                object5 = new ExportPackage((String)object5, version);
                String[] stringArray = (String[])((ManifestHeaderElement)object42).getDirectives().get("use");
                if (stringArray != null) {
                    stringArray = stringArray.trim().split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((ExportPackage)object5).addUse(stringArray[i].trim());
                    }
                }
                ((BundleInfo)object2).addCapability((BundleCapability)object5);
            }
        }
        ManifestParser.parseCapability((BundleInfo)object2, (Attributes)cloneable, "Export-Service", "service");
        return object2;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes iterator, String string, String string2, String string3) throws ParseException {
        iterator = new ManifestHeaderValue(((Attributes)((Object)iterator)).getValue(string));
        for (Object object : ((ManifestHeaderValue)((Object)iterator)).getElements()) {
            VersionRange versionRange;
            String string4 = (String)((ManifestHeaderElement)object).getDirectives().get("resolution");
            String string5 = (String)((ManifestHeaderElement)object).getAttributes().get(string3);
            try {
                versionRange = ManifestParser.versionRangeOf(string5);
            }
            catch (ParseException parseException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string5 + " (" + parseException.getMessage() + ")", 0);
            }
            object = ((ManifestHeaderElement)object).getValues().iterator();
            while (object.hasNext()) {
                string5 = (String)object.next();
                bundleInfo.addRequirement(new BundleRequirement(string2, string5, versionRange, string4));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes iterator, String string, String string2) throws ParseException {
        iterator = new ManifestHeaderValue(((Attributes)((Object)iterator)).getValue(string));
        for (Object object : ((ManifestHeaderValue)((Object)iterator)).getElements()) {
            Version version;
            Object object2 = (String)((ManifestHeaderElement)object).getAttributes().get("version");
            try {
                version = ManifestParser.versionOf((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The " + string + " has an incorrect version: " + (String)object2 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            object = ((ManifestHeaderElement)object).getValues().iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                object2 = new BundleCapability(string2, (String)object2, version);
                bundleInfo.addCapability((BundleCapability)object2);
            }
        }
    }

    private static VersionRange versionRangeOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new VersionRange(string);
    }

    private static Version versionOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }
}

