/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class RotPosScalePathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Quat4f tQuat = new Quat4f();
    private Matrix4d tMat = new Matrix4d();
    private Matrix4d sMat = new Matrix4d();
    private Quat4f[] quats;
    private Point3f[] positions;
    private float[] scales;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotPosScalePathInterpolator() {
    }

    public RotPosScalePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Quat4f[] quat4fArray, Point3f[] point3fArray, float[] fArray2) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator1"));
        }
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator0"));
        }
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator2"));
        }
        this.setPathArrays(quat4fArray, point3fArray, fArray2);
    }

    public void setQuat(int n, Quat4f quat4f) {
        this.quats[n].set((Tuple4f)quat4f);
    }

    public void getQuat(int n, Quat4f quat4f) {
        quat4f.set((Tuple4f)this.quats[n]);
    }

    public void setPosition(int n, Point3f point3f) {
        this.positions[n].set((Tuple3f)point3f);
    }

    public void getPosition(int n, Point3f point3f) {
        point3f.set((Tuple3f)this.positions[n]);
    }

    public void setScale(int n, float f) {
        this.scales[n] = f;
    }

    public float getScale(int n) {
        return this.scales[n];
    }

    public void setPathArrays(float[] fArray, Quat4f[] quat4fArray, Point3f[] point3fArray, float[] fArray2) {
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator1"));
        }
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator0"));
        }
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator2"));
        }
        this.setKnots(fArray);
        this.setPathArrays(quat4fArray, point3fArray, fArray2);
    }

    private void setPathArrays(Quat4f[] quat4fArray, Point3f[] point3fArray, float[] fArray) {
        int n;
        this.quats = new Quat4f[quat4fArray.length];
        for (n = 0; n < quat4fArray.length; ++n) {
            this.quats[n] = new Quat4f();
            this.quats[n].set((Tuple4f)quat4fArray[n]);
        }
        this.positions = new Point3f[point3fArray.length];
        for (n = 0; n < point3fArray.length; ++n) {
            this.positions[n] = new Point3f();
            this.positions[n].set((Tuple3f)point3fArray[n]);
        }
        this.scales = new float[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            this.scales[n] = fArray[n];
        }
    }

    public void getQuats(Quat4f[] quat4fArray) {
        for (int i = 0; i < this.quats.length; ++i) {
            quat4fArray[i].set((Tuple4f)this.quats[i]);
        }
    }

    public void getPositions(Point3f[] point3fArray) {
        for (int i = 0; i < this.positions.length; ++i) {
            point3fArray[i].set((Tuple3f)this.positions[i]);
        }
    }

    public void getScales(float[] fArray) {
        for (int i = 0; i < this.scales.length; ++i) {
            fArray[i] = this.scales[i];
        }
    }

    public void setAxisOfRotPosScale(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotPosScale() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float f, Transform3D transform3D) {
        float f2;
        this.computePathInterpolation(f);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
            f2 = this.scales[0];
        } else {
            double d = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (d < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
            f2 = this.scales[this.currentKnotIndex] + (this.scales[this.currentKnotIndex + 1] - this.scales[this.currentKnotIndex]) * this.currentInterpolationValue;
        }
        this.tQuat.normalize();
        this.sMat.set((double)f2);
        this.tMat.set(this.tQuat);
        this.tMat.mul(this.sMat);
        this.tMat.m03 = this.pos.x;
        this.tMat.m13 = this.pos.y;
        this.tMat.m23 = this.pos.z;
        this.rotation.set(this.tMat);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean bl) {
        RotPosScalePathInterpolator rotPosScalePathInterpolator = new RotPosScalePathInterpolator();
        rotPosScalePathInterpolator.duplicateNode(this, bl);
        return rotPosScalePathInterpolator;
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotPosScalePathInterpolator rotPosScalePathInterpolator = (RotPosScalePathInterpolator)node;
        int n = rotPosScalePathInterpolator.getArrayLengths();
        this.positions = new Point3f[n];
        this.quats = new Quat4f[n];
        this.scales = new float[n];
        Point3f point3f = new Point3f();
        Quat4f quat4f = new Quat4f();
        for (int i = 0; i < n; ++i) {
            this.positions[i] = new Point3f();
            rotPosScalePathInterpolator.getPosition(i, point3f);
            this.setPosition(i, point3f);
            this.quats[i] = new Quat4f();
            rotPosScalePathInterpolator.getQuat(i, quat4f);
            this.setQuat(i, quat4f);
            this.setScale(i, rotPosScalePathInterpolator.getScale(i));
        }
    }
}

