/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources.ext;

import sun.util.resources.TimeZoneNamesBundle;

public final class TimeZoneNames_de extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre Normalzeit", "ACT",
                                     "Acre Sommerzeit", "ACST",
                                     "Acre Normalzeit", "ACT"};
        String ADELAIDE[] = new String[] {"Zentrale Normalzeit (S\u00FCdaustralien)", "ACST",
                                          "Zentrale Sommerzeit (S\u00FCdaustralien)", "ACDT",
                                          "Zentrale Zeitzone (S\u00FCdaustralien)", "ACT"};
        String AGT[] = new String[] {"Argentinische Zeit", "ART",
                                     "Argentinische Sommerzeit", "ARST",
                                     "Argentinische Zeit", "ART"};
        String AKST[] = new String[] {"Alaska Normalzeit", "AKST",
                                      "Alaska Sommerzeit", "AKDT",
                                      "Zeitzone f\u00FCr Alaska", "AKT"};
        String AMT[] = new String[] {"Amazonas Normalzeit", "AMT",
                                     "Amazonas Sommerzeit", "AMST",
                                     "Amazonas Normalzeit", "AMT"};
        String ARAST[] = new String[] {"Arabische Normalzeit", "AST",
                                       "Arabische Sommerzeit", "ADT",
                                       "Zeitzone f\u00FCr Arabische Halbinsel", "AT"};
        String ARMT[] = new String[] {"Armenische Zeit", "AMT",
                                      "Armenische Sommerzeit", "AMST",
                                      "Armenische Zeit", "AMT"};
        String AST[] = new String[] {"Atlantik Normalzeit", "AST",
                                     "Atlantik Sommerzeit", "ADT",
                                     "Zeitzone Atlantik", "AT"};
        String BDT[] = new String[] {"Bangladesch Zeit", "BDT",
                                     "Bangladesch Sommerzeit", "BDST",
                                     "Bangladesch Zeit", "BDT"};
        String BRISBANE[] = new String[] {"\u00D6stliche Normalzeit (Queensland)", "AEST",
                                          "\u00D6stliche Sommerzeit (Queensland)", "AEDT",
                                          "\u00D6stliche Zeitzone (Queensland)", "AET"};
        String BROKEN_HILL[] = new String[] {"Zentrale Normalzeit (S\u00FCdaustralien/New South Wales)", "ACST",
                                             "Zentrale Sommerzeit (S\u00FCdaustralien/New South Wales)", "ACDT",
                                             "Zentrale Zeitzone (S\u00FCdaustralien/New South Wales)", "ACT"};
        String BRT[] = new String[] {"Brasilianische Zeit", "BRT",
                                     "Brasilianische Sommerzeit", "BRST",
                                     "Brasilianische Zeit", "BRT"};
        String BTT[] = new String[] {"Bhutanische Zeit", "BTT",
                                     "Bhutanische Sommerzeit", "BTST",
                                     "Bhutanische Zeit", "BTT"};
        String CAT[] = new String[] {"Zentralafrikanische Zeit", "CAT",
                                     "Zentralafrikanische Sommerzeit", "CAST",
                                     "Zentralafrikanische Zeit", "CAT"};
        String CET[] = new String[] {"Mitteleurop\u00e4ische Zeit", "MEZ",
                                     "Mitteleurop\u00e4ische Sommerzeit", "MESZ",
                                     "Mitteleurop\u00E4ische Zeit", "MEZ"};
        String CHAST[] = new String[] {"Chatham Normalzeit", "CHAST",
                                       "Chatham Sommerzeit", "CHADT",
                                       "Zeitzone f\u00FCr Chatham-Inseln", "CHAT"};
        String CHUT[] = new String[] {"Chuuk Zeit", "CHUT",
                                      "Chuuk Sommerzeit", "CHUST",
                                      "Chuuk Zeit", "CHUT"};
        String CIT[] = new String[] {"Zentralindonesische Zeit", "WITA",
                                     "Zentralindonesische Sommerzeit", "CIST",
                                     "Zentralindonesische Zeit", "WITA"};
        String CLT[] = new String[] {"Chilenische Zeit", "CLT",
                                     "Chilenische Sommerzeit", "CLST",
                                     "Chilenische Zeit", "CLT"};
        String CST[] = new String[] {"Zentrale Normalzeit", "CST",
                                     "Zentrale Sommerzeit", "CDT",
                                     "Zentrale Zeitzone", "CT"};
        String CTT[] = new String[] {"Chinesische Normalzeit", "CST",
                                     "Chinesische Sommerzeit", "CDT",
                                     "Zeitzone f\u00FCr China", "CT"};
        String CUBA[] = new String[] {"Kubanische Normalzeit", "CST",
                                      "Kubanische Sommerzeit", "CDT",
                                      "Kubanische Normalzeit", "CT"};
        String DARWIN[] = new String[] {"Zentrale Normalzeit (Northern Territory)", "ACST",
                                        "Zentrale Sommerzeit (Northern Territory)", "ACDT",
                                        "Zentrale Zeitzone (Northern Territory)", "ACT"};
        String DUBLIN[] = new String[] {"Greenwich Zeit", "GMT",
                                        "Irische Sommerzeit", "IST",
                                        "Irische Zeit", "IT"};
        String EAT[] = new String[] {"Ostafrikanische Zeit", "EAT",
                                     "Ostafrikanische Sommerzeit", "EAST",
                                     "Ostafrikanische Zeit", "EAT"};
        String EASTER[] = new String[] {"Osterinseln Zeit", "EAST",
                                        "Osterinseln Sommerzeit", "EASST",
                                        "Osterinseln Zeit", "EAST"};
        String EET[] = new String[] {"Osteurop\u00e4ische Zeit", "OEZ",
                                     "Osteurop\u00e4ische Sommerzeit", "OESZ",
                                     "Osteurop\u00e4ische Zeit", "OEZ"};
        String EGT[] = new String[] {"Ostgr\u00f6nl\u00e4ndische Zeit", "EGT",
                                     "Ostgr\u00f6nl\u00e4ndische Sommerzeit", "EGST",
                                     "Ostgr\u00F6nl\u00E4ndische Zeit", "EGT"};
        String EST[] = new String[] {"\u00d6stliche Normalzeit", "EST",
                                     "\u00d6stliche Sommerzeit", "EDT",
                                     "\u00D6stliche Zeitzone", "ET"};
        String EST_NSW[] = new String[] {"\u00D6stliche Normalzeit (New South Wales)", "AEST",
                                         "\u00D6stliche Sommerzeit (New South Wales)", "AEDT",
                                         "\u00D6stliche Zeitzone (New South Wales)", "AET"};
        String FET[] = new String[] {"Kaliningrader Zeit", "FET",
                                     "Kaliningrader Sommerzeit", "FEST",
                                     "Kaliningrader Zeit", "FET"};
        String GHMT[] = new String[] {"Ghanaische Normalzeit", "GMT",
                                      "Ghanaische Sommerzeit", "GHST",
                                      "Ghanaische Normalzeit", "GMT"};
        String GAMBIER[] =  new String[] {"Gambier Zeit", "GAMT",
                                          "Gambier Sommerzeit", "GAMST",
                                          "Gambier Zeit", "GAMT"};
        String GMT[] = new String[] {"Greenwich Zeit", "GMT",
                                   "Greenwich Zeit", "GMT",
                                   "Greenwich Zeit", "GMT"};
        String GMTBST[] = new String[] {"Greenwich Zeit", "GMT",
                                        "Britische Sommerzeit", "BST",
                                        "Britische Zeit", "BT"};
        String GST[] = new String[] {"Golf Normalzeit", "GST",
                                     "Golf Sommerzeit", "GDT",
                                     "Zeitzone f\u00FCr Persischen Golf", "GT"};
        String HKT[] =  new String[] {"Hongkong Zeit", "HKT",
                                      "Hongkong Sommerzeit", "HKST",
                                      "Hongkong Zeit", "HKT"};
        String HST[] = new String[] {"Hawaii Normalzeit", "HST",
                                     "Hawaii Sommerzeit", "HDT",
                                     "Zeitzone f\u00FCr Hawaii", "HT"};
        String ICT[] = new String[] {"Indochina Zeit", "ICT",
                                     "Indochina Sommerzeit", "ICST",
                                     "Indochina Zeit", "ICT"};
        String IRKT[] = new String[] {"Irkutsk Zeit", "IRKT",
                                      "Irkutsk Sommerzeit", "IRKST",
                                      "Irkutsk Zeit", "IRKT"};
        String IRT[] = new String[] {"Iranische Normalzeit", "IRST",
                                     "Iranische Sommerzeit", "IRDT",
                                     "Iranische Zeit", "IRT"};
        String ISRAEL[] = new String[] {"Israelische Normalzeit", "IST",
                                        "Israelische Sommerzeit", "IDT",
                                        "Zeitzone f\u00FCr Israel", "IT"};
        String IST[] = new String[] {"Indische Normalzeit", "IST",
                                     "Indische Sommerzeit", "IDT",
                                     "Zeitzone f\u00FCr Indien", "IT"};
        String JST[] = new String[] {"Japanische Normalzeit", "JST",
                                     "Japanische Sommerzeit", "JDT",
                                     "Zeitzone f\u00FCr Japan", "JT"};
        String KRAT[] = new String[] {"Krasnojarsker Zeit", "KRAT",
                                      "Krasnojarsker Sommerzeit", "KRAST",
                                      "Krasnojarsker Zeit", "KRAT"};
        String KST[] = new String[] {"Koreanische Normalzeit", "KST",
                                     "Koreanische Sommerzeit", "KDT",
                                     "Zeitzone f\u00FCr Korea", "KT"};
        String LORD_HOWE[] = new String[] {"Lord Howe Normalzeit", "LHST",
                                           "Lord Howe Sommerzeit", "LHDT",
                                           "Lord-Howe Normalzeit", "LHT"};
        String MHT[] = new String[] {"Marshallinseln Zeit", "MHT",
                                     "Marshallinseln Sommerzeit", "MHST",
                                     "Marshallinseln Zeit", "MHT"};
        String MMT[] = new String[] {"Myanmar Zeit", "MMT",
                                     "Myanmar Sommerzeit", "MMST",
                                     "Myanmar Zeit", "MMT"};
        String MSK[] = new String[] {"Moskauer Normalzeit", "MSK",
                                     "Moskauer Sommerzeit", "MSD",
                                     "Zeitzone f\u00FCr Moskau", "MT"};
        String MST[] = new String[] {"Rocky Mountains Normalzeit", "MST",
                                     "Rocky Mountains Sommerzeit", "MDT",
                                     "Zeitzone Mountain", "MT"};
        String MYT[] = new String[] {"Malaysische Zeit", "MYT",
                                     "Malaysische Sommerzeit", "MYST",
                                     "Malaysische Zeit", "MYT"};
        String NORONHA[] = new String[] {"Fernando de Noronha Zeit", "FNT",
                                         "Fernando de Noronha Sommerzeit", "FNST",
                                         "Fernando de Noronha Zeit", "FNT"};
        String NOVT[] = new String[] {"Nowosibirsker Zeit", "NOVT",
                                      "Nowosibirsker Sommerzeit", "NOVST",
                                      "Nowosibirsker Zeit", "NOVT"};
        String NPT[] = new String[] {"Nepalesische Zeit", "NPT",
                                     "Nepalesische Sommerzeit", "NPST",
                                     "Nepalesische Zeit", "NPT"};
        String NST[] = new String[] {"Neufundland Normalzeit", "NST",
                                     "Neufundland Sommerzeit", "NDT",
                                     "Zeitzone f\u00FCr Neufundland", "NT"};
        String NZST[] = new String[] {"Neuseeland Normalzeit", "NZST",
                                      "Neuseeland Sommerzeit", "NZDT",
                                      "Zeitzone f\u00FCr Neuseeland", "NZT"};
        String PITCAIRN[] = new String[] {"Pitcairn Normalzeit", "PST",
                                          "Pitcairn Sommerzeit", "PDT",
                                          "Zeitzone f\u00FCr Pitcairn", "PT"};
        String PKT[] = new String[] {"Pakistanische Zeit", "PKT",
                                     "Pakistanische Sommerzeit", "PKST",
                                     "Pakistanische Zeit", "PKT"};
        String PONT[] = new String[] {"Pohnpei Zeit", "PONT",
                                      "Pohnpei Sommerzeit", "PONST",
                                      "Pohnpei-Inseln Zeit", "PONT"};
        String PST[] = new String[] {"Pazifische Normalzeit", "PST",
                                     "Pazifische Sommerzeit", "PDT",
                                     "Zeitzone Pazifik", "PT"};
        String SAST[] = new String[] {"S\u00fcdafrikanische Normalzeit", "SAST",
                                      "S\u00fcdafrikanische Sommerzeit", "SAST",
                                      "Zeitzone f\u00FCr S\u00FCdafrika", "SAT"};
        String SBT[] = new String[] {"Salomoninseln Zeit", "SBT",
                                     "Salomoninseln Sommerzeit", "SBST",
                                     "Salomoninseln Zeit", "SBT"};
        String SGT[] = new String[] {"Singapur Zeit", "SGT",
                                     "Singapur Sommerzeit", "SGST",
                                     "Singapur Zeit", "SGT"};
        String TASMANIA[] = new String[] {"\u00D6stliche Normalzeit (Tasmanien)", "AEST",
                                          "\u00D6stliche Sommerzeit (Tasmanien)", "AEDT",
                                          "\u00D6stliche Zeitzone (Tasmanien)", "AET"};
        String TMT[] = new String[] {"Turkmenische Zeit", "TMT",
                                     "Turkmenische Sommerzeit", "TMST",
                                     "Turkmenische Zeit", "TMT"};
        String ULAT[]= new String[] {"Ulaanbaatar Zeit", "ULAT",
                                     "Ulaanbaatar Sommerzeit", "ULAST",
                                     "Ulaanbaatar Zeit", "ULAT"};
        String WAT[] = new String[] {"Westafrikanische Zeit", "WAT",
                                     "Westafrikanische Sommerzeit", "WAST",
                                     "Westafrikanische Zeit", "WAT"};
        String WET[] = new String[] {"Westeurop\u00e4ische Zeit", "WEZ",
                                     "Westeurop\u00e4ische Sommerzeit", "WESZ",
                                     "Westeurop\u00E4ische Zeit", "WEZ"};
        String WIT[] = new String[] {"Westindonesische Zeit", "WIB",
                                     "Westindonesische Sommerzeit", "WIST",
                                     "Westindonesische Zeit", "WIB"};
        String WST_AUS[] = new String[] {"Westliche Normalzeit (Australien)", "AWST",
                                         "Westliche Sommerzeit (Australien)", "AWDT",
                                         "Westliche Zeitzone (Australien)", "AWT"};
        String SAMOA[] = new String[] {"Samoa Normalzeit", "SST",
                                       "Samoa Sommerzeit", "SDT",
                                       "Zeitzone f\u00FCr Samoa", "ST"};
        String WST_SAMOA[] = new String[] {"West Samoa Zeit", "WSST",
                                           "West Samoa Sommerzeit", "WSDT",
                                           "West Samoa Zeit", "WST"};
        String ChST[] = new String[] {"Chamorro Normalzeit", "ChST",
                      "Chamorro Sommerzeit", "ChDT",
                      "Zeitzone f\u00FCr die Marianen", "ChT"};
        String VICTORIA[] = new String[] {"\u00D6stliche Normalzeit (Victoria)", "AEST",
                                          "\u00D6stliche Sommerzeit (Victoria)", "AEDT",
                                          "\u00D6stliche Zeitzone (Victoria)", "AET"};
        String UTC[] = new String[] {"Koordinierte Universalzeit", "UTC",
                                     "Koordinierte Universalzeit", "UTC",
                                     "Koordinierte Universalzeit", "UTC"};
        String UZT[] = new String[] {"Usbekistan Zeit", "UZT",
                                     "Usbekistan Sommerzeit", "UZST",
                                     "Usbekistan Zeit", "UZT"};
        String XJT[] = new String[] {"Chinesische Normalzeit", "XJT",
                                     "Chinesische Sommerzeit", "XJDT",
                                     "Zeitzone f\u00FCr China", "XJT"};
        String YAKT[] = new String[] {"Jakutsk Zeit", "YAKT",
                                      "Jakutsk Sommerzeit", "YAKST",
                                      "Jakutsk Zeit", "YAKT"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            {"UTC", UTC},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", CAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", WAT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", CAT},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"Paraguay Zeit", "PYT",
                                               "Paraguay Sommerzeit", "PYST",
                                               "Paraguay Zeit", "PYT"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"Kolumbianische Zeit", "COT",
                                             "Kolumbianische Sommerzeit", "COST",
                                             "Kolumbianische Zeit", "COT"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"Venezuelanische Zeit", "VET",
                                              "Venezuelanische Sommerzeit", "VEST",
                                              "Venezuelanische Zeit", "VET"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"Franz\u00f6sisch-Guiana Zeit", "GFT",
                                              "Franz\u00f6sisch-Guiana Sommerzeit", "GFST",
                                              "Franz\u00F6sisch-Guiana Zeit", "GFT"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"Westgr\u00f6nl\u00e4ndische Zeit", "WGT",
                                              "Westgr\u00f6nl\u00e4ndische Sommerzeit", "WGST",
                                              "Westgr\u00F6nl\u00E4ndische Zeit", "WGT"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"Ecuadorianische Zeit", "ECT",
                                                "Ecuadorianische Sommerzeit", "ECST",
                                                "Ecuadorianische Zeit", "ECT"}},
            {"America/Guyana", new String[] {"Guyanische Zeit", "GYT",
                                             "Guyanische Sommerzeit", "GYST",
                                             "Guyanische Zeit", "GYT"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"Bolivianische Zeit", "BOT",
                                             "Bolivianische Sommerzeit", "BOST",
                                             "Bolivianische Zeit", "BOT"}},
            {"America/Lima", new String[] {"Peruanische Zeit", "PET",
                                           "Peruanische Sommerzeit", "PEST",
                                           "Peruanische Zeit", "PET"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"Pierre & Miquelon Normalzeit", "PMST",
                                               "Pierre & Miquelon Sommerzeit", "PMDT",
                                               "Zeitzone f\u00FCr St. Pierre und Miquelon", "PMT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"Uruguayische Zeit", "UYT",
                                                 "Uruguayische Sommerzeit", "UYST",
                                                 "Uruguayanische Zeit", "UYT"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"Suriname Zeit", "SRT",
                                                 "Suriname Sommerzeit", "SRST",
                                                 "Suriname Zeit", "SRT"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Davis Zeit", "DAVT",
                                               "Davis Sommerzeit", "DAVST",
                                               "Davis Zeit", "DAVT"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville Zeit", "DDUT",
                                                        "Dumont-d'Urville Sommerzeit", "DDUST",
                                                        "Dumont-d'Urville Zeit", "DDUT"}},
            {"Antarctica/Macquarie", new String[] {"Macquarieinsel Zeit", "MIST",
                                                   "Macquarieinsel Sommerzeit", "MIST",
                                                   "Macquarieinsel Zeit", "MIST"}},
            {"Antarctica/Mawson", new String[] {"Mawson Zeit", "MAWT",
                                                "Mawson Sommerzeit", "MAWST",
                                                "Mawson Zeit", "MAWT"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"Rothera Zeit", "ROTT",
                                                 "Rothera Sommerzeit", "ROTST",
                                                 "Rothera Zeit", "ROTT"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa Zeit", "SYOT",
                                               "Syowa Sommerzeit", "SYOST",
                                               "Syowa Zeit", "SYOT"}},
            {"Antarctica/Troll", new String[] {"Koordinierte Universalzeit", "UTC",
                                               "Mitteleurop\u00e4ische Sommerzeit", "MESZ",
                                               "Troll Time", "ATT"}},
            {"Antarctica/Vostok", new String[] {"Vostok Zeit", "VOST",
                                                "Vostok Sommerzeit", "VOSST",
                                                "Vostok Zeit", "VOST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma Ata Zeit", "ALMT",
                                          "Alma-Ata Sommerzeit", "ALMST",
                                          "Alma Ata Zeit", "ALMT"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"Anadyr Zeit", "ANAT",
                                          "Anadyr Sommerzeit", "ANAST",
                                          "Anadyr Zeit", "ANAT"}},
            {"Asia/Aqtau", new String[] {"Aqtau Zeit", "AQTT",
                                         "Aqtau Sommerzeit", "AQTST",
                                         "Aqtau Zeit", "AQTT"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe Zeit", "AQTT",
                                          "Aqtobe Sommerzeit", "AQTST",
                                          "Aqtobe Zeit", "AQTT"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"Aserbaidschanische Zeit", "AZT",
                                        "Aserbaidschanische Sommerzeit", "AZST",
                                        "Aserbaidschanische Zeit", "AZT"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"Kirgisische Zeit", "KGT",
                                           "Kirgisische Sommerzeit", "KGST",
                                           "Kirgisische Zeit", "KGT"}},
            {"Asia/Brunei", new String[] {"Brunei Zeit", "BNT",
                                          "Brunei Sommerzeit", "BNST",
                                          "Brunei Zeit", "BNT"}},
            {"Asia/Calcutta", IST},
            {"Asia/Chita", YAKT},
            {"Asia/Choibalsan", new String[] {"Choibalsan Zeit", "CHOT",
                                              "Choibalsan Sommerzeit", "CHOST",
                                              "Choibalsan Zeit", "CHOT"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"Timor-Leste Normalzeit", "TLT",
                                        "Timor-Leste Sommerzeit", "TLST",
                                        "Timor-Leste Normalzeit", "TLT"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"Tadschikische Zeit", "TJT",
                                            "Tadschikische Sommerzeit", "TJST",
                                            "Tadschikische Zeit", "TJT"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd Zeit", "HOVT",
                                        "Hovd Sommerzeit", "HOVST",
                                        "Hovd Zeit", "HOVT"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"Ostindonesische Zeit", "WIT",
                                            "Ostindonesische Sommerzeit", "EIST",
                                            "Ostindonesische Zeit", "WIT"}},
            {"Asia/Kabul", new String[] {"Afghanistanische Zeit", "AFT",
                                         "Afghanistanische Sommerzeit", "AFST",
                                         "Afghanistanische Zeit", "AFT"}},
            {"Asia/Kamchatka", new String[] {"Petropawlowsk-Kamtschatkische Zeit", "PETT",
                                             "Petropawlowsk-Kamtschatkische Sommerzeit", "PETST",
                                             "Petropawlowsk-Kamtschatkische Zeit", "PETT"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadanische Zeit", "MAGT",
                                           "Magadanische Sommerzeit", "MAGST",
                                           "Magadanische Zeit", "MAGT"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Philippinische Zeit", "PHT",
                                          "Philippinische Sommerzeit", "PHST",
                                          "Philippinische Zeit", "PHT"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral Zeit", "ORAT",
                                        "Oral Sommerzeit", "ORAST",
                                        "Oral Zeit", "ORAT"}},
            {"Asia/Omsk", new String[] {"Omsk Zeit", "OMST",
                                        "Omsk Sommerzeit", "OMSST",
                                        "Omsk Zeit", "OMST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda Zeit", "QYZT",
                                             "Qyzylorda Sommerzeit", "QYZST",
                                             "Qyzylorda Zeit", "QYZT"}},
            {"Asia/Rangoon", MMT},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"Sakhalin Zeit", "SAKT",
                                            "Sakhalin Sommerzeit", "SAKST",
                                            "Sakhalin Zeit", "SAKT"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT",
                                                 "Srednekolymsk Time", "SRET"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"Georgische Zeit", "GET",
                                           "Georgische Sommerzeit", "GEST",
                                           "Georgische Zeit", "GET"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"Ust-Nera Zeit", "VLAT",
                                            "Ust-Nera Sommerzeit", "VLAST",
                                            "Ust-Nera Zeit", "VLAT"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"Wladiwostok Zeit", "VLAT",
                                               "Wladiwostok Sommerzeit", "VLAST",
                                               "Wladiwostok Zeit", "VLAT"}},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yangon", MMT},
            {"Asia/Yekaterinburg", new String[] {"Jekaterinburger Zeit", "YEKT",
                                                 "Jekaterinburger Sommerzeit", "YEKST",
                                                 "Jekaterinburger Zeit", "YEKT"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"Azoren Zeit", "AZOT",
                                              "Azoren Sommerzeit", "AZOST",
                                              "Azoren Zeit", "AZOT"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"Kap Verde Zeit", "CVT",
                                                  "Kap Verde Sommerzeit", "CVST",
                                                  "Kap Verde Zeit", "CVT"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"South Georgia Normalzeit", "GST",
                                                     "South Georgia Sommerzeit", "GDT",
                                                     "Zeitzone f\u00FCr S\u00FCdgeorgien", "GT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"Falkland Inseln Zeit", "FKT",
                                               "Falkland Inseln Sommerzeit", "FKST",
                                               "Falkland Inseln Zeit", "FKT"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"Zentral-Westliche Normalzeit (Australien)", "ACWST",
                                              "Zentral-Westliche Sommerzeit (Australien)", "ACWDT",
                                              "Zentral-Westliche Normalzeit (Australien)", "ACWT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"Samarische Zeit", "SAMT",
                                            "Samarische Sommerzeit", "SAMST",
                                            "Samarische Zeit", "SAMT"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"Indischer Ozean Territorium Zeit", "IOT",
                                            "Indischer Ozean Territorium Sommerzeit", "IOST",
                                            "Indischer Ozean Territorium Zeit", "IOT"}},
            {"Indian/Christmas", new String[] {"Christmas Island Zeit", "CXT",
                                               "Christmas Island Sommerzeit", "CXST",
                                               "Weihnachtsinseln Zeit", "CIT"}},
            {"Indian/Cocos", new String[] {"Cocos Islands Zeit", "CCT",
                                           "Cocos Islands Sommerzeit", "CCST",
                                           "Kokos-Inseln Zeit", "CCT"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"Franz\u00f6sisch S\u00fcd- u. Antarktische Landzeit", "TFT",
                                               "Franz\u00f6sisch S\u00fcd- u. Antarktische Landsommerzeit", "TFST",
                                               "Franz\u00F6sisch S\u00FCd- u. Antarktische Landzeit", "TFT"}},
            {"Indian/Mahe", new String[] {"Seychellen Zeit", "SCT",
                                          "Seychellen Sommerzeit", "SCST",
                                          "Seychellen Zeit", "SCT"}},
            {"Indian/Maldives", new String[] {"Maledivische Zeit", "MVT",
                                              "Maledivische Sommerzeit", "MVST",
                                              "Maledivische Zeit", "MVT"}},
            {"Indian/Mauritius", new String[] {"Mauritius Zeit", "MUT",
                                               "Mauritius Sommerzeit", "MUST",
                                               "Mauritius Zeit", "MUT"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"Reunion Zeit", "RET",
                                             "Reunion Sommerzeit", "REST",
                                             "R\u00E9union Zeit", "RET"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"Zentraleurop\u00e4ische Zeit", "MET",
                                  "Zentraleurop\u00e4ische Sommerzeit", "MEST",
                                  "MET", "MET"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST",
                                                   "Bougainville Time", "BT"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"Vanuatu Zeit", "VUT",
                                            "Vanuatu Sommerzeit", "VUST",
                                            "Vanuatu Zeit", "VUT"}},
            {"Pacific/Enderbury", new String[] {"Phoenix Inseln Zeit", "PHOT",
                                                "Phoenix Inseln Sommerzeit", "PHOST",
                                                "Phoenix Inseln Zeit", "PHOT"}},
            {"Pacific/Fakaofo", new String[] {"Tokelau Zeit", "TKT",
                                              "Tokelau Sommerzeit", "TKST",
                                              "Tokelau Zeit", "TKT"}},
            {"Pacific/Fiji", new String[] {"Fidschi Zeit", "FJT",
                                           "Fidschi Sommerzeit", "FJST",
                                           "Fidschi Zeit", "FJT"}},
            {"Pacific/Funafuti", new String[] {"Tuvalu Zeit", "TVT",
                                               "Tuvalu Sommerzeit", "TVST",
                                               "Tuvalu Zeit", "TVT"}},
            {"Pacific/Galapagos", new String[] {"Galapagos Zeit", "GALT",
                                                "Galapagos Sommerzeit", "GALST",
                                                "Galapagos Zeit", "GALT"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line Inseln Zeit", "LINT",
                                                 "Line Inseln Sommerzeit", "LINST",
                                                 "Line Inseln Zeit", "LINT"}},
            {"Pacific/Kosrae", new String[] {"Kosrae Zeit", "KOST",
                                             "Kosrae Sommerzeit", "KOSST",
                                             "Kosrae Zeit", "KOST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"Marquesas Zeit", "MART",
                                                "Marquesas Sommerzeit", "MARST",
                                                "Marquesas Zeit", "MART"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"Nauru Zeit", "NRT",
                                            "Nauru Sommerzeit", "NRST",
                                            "Nauru Zeit", "NRT"}},
            {"Pacific/Niue", new String[] {"Niue Zeit", "NUT",
                                           "Niue Sommerzeit", "NUST",
                                           "Niue Zeit", "NUT"}},
            {"Pacific/Norfolk", new String[] {"Norfolk Zeit", "NFT",
                                              "Norfolk Sommerzeit", "NFST",
                                              "Norfolk Zeit", "NFT"}},
            {"Pacific/Noumea", new String[] {"Neukaledonische Zeit", "NCT",
                                             "Neukaledonische Sommerzeit", "NCST",
                                             "Neukaledonische Zeit", "NCT"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"Palau Zeit", "PWT",
                                            "Palau Sommerzeit", "PWST",
                                            "Palau Zeit", "PWT"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"Papua-Neuguinea Zeit", "PGT",
                                                   "Papua-Neuguinea Sommerzeit", "PGST",
                                                   "Papua-Neuguinea Zeit", "PGT"}},
            {"Pacific/Rarotonga", new String[] {"Cook-Inseln Zeit", "CKT",
                                                "Cook-Inseln Sommerzeit", "CKHST",
                                                "Cook-Inseln Zeit", "CKT"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"Tahiti Zeit", "TAHT",
                                             "Tahiti Sommerzeit", "TAHST",
                                             "Tahiti Zeit", "TAHT"}},
            {"Pacific/Tarawa", new String[] {"Gilbert-Inseln Zeit", "GILT",
                                             "Gilbert-Inseln Sommerzeit", "GILST",
                                             "Gilbert-Inseln Zeit", "GILT"}},
            {"Pacific/Tongatapu", new String[] {"Tonga Zeit", "TOT",
                                                "Tonga Sommerzeit", "TOST",
                                                "Tonga Zeit", "TOT"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"Wake Zeit", "WAKT",
                                           "Wake Sommerzeit", "WAKST",
                                           "Wake Zeit", "WAKT"}},
            {"Pacific/Wallis", new String[] {"Wallis u. Futuna Zeit", "WFT",
                                             "Wallis u. Futuna Sommerzeit", "WFST",
                                             "Wallis u. Futuna Zeit", "WFT"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
