/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.overview.OverviewViewSupport;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class JFRSnapshotOverviewView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(JFRSnapshotOverviewView.class.getName());
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/overview.png";
    private JFRModel model;

    public JFRSnapshotOverviewView(JFRSnapshot snapshot) {
        super((DataSource)snapshot, NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Overview"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 0, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
        if (this.model == null) {
            LOGGER.log(Level.SEVERE, "No JFR model for " + snapshot.getFile());
        }
    }

    protected void removed() {
        JFRModelFactory.cleanupModel__Workaround(this.model);
    }

    protected DataViewComponent createComponent() {
        if (this.model == null) {
            MasterViewSupport masterView = new MasterViewSupport(this.model){

                @Override
                void firstShown() {
                }
            };
            return new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final OverviewViewSupport.SnapshotsViewSupport snapshotView = new OverviewViewSupport.SnapshotsViewSupport((JFRSnapshot)this.getDataSource());
        MasterViewSupport masterView = new MasterViewSupport(this.model){

            @Override
            void firstShown() {
                JFRSnapshotOverviewView.this.initialize(snapshotView);
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        Properties jvmProperties = this.model.getSystemProperties();
        String jvmargs = this.model.getJvmArgs();
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.25, 0.0, -1.0, -1.0, -1.0, -1.0));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Saved_data"), true), 1);
        dvc.addDetailsView(snapshotView.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Details"), true), 2);
        dvc.addDetailsView(new OverviewViewSupport.JVMArgumentsViewSupport(jvmargs).getDetailsView(), 2);
        dvc.addDetailsView(new OverviewViewSupport.SystemPropertiesViewSupport(jvmProperties).getDetailsView(), 2);
        return dvc;
    }

    private void initialize(final OverviewViewSupport.SnapshotsViewSupport snapshotView) {
        new RequestProcessor("JFR Overview Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotOverviewView.this.model.visitEvents(snapshotView);
            }
        });
    }

    private static abstract class MasterViewSupport
    extends JPanel {
        public MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralProperties(model) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)(model == null ? new ScrollableContainer((JComponent)area) : area), "Center");
            if (model != null) {
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }

        private String getGeneralProperties(JFRModel model) {
            if (model != null) {
                StringBuilder data = new StringBuilder();
                String commandLine = model.getJavaCommand();
                if (commandLine != null) {
                    String mainClass;
                    int firstSpace = commandLine.indexOf(32);
                    String mainArgs = null;
                    if (firstSpace == -1) {
                        mainClass = commandLine;
                    } else {
                        mainClass = commandLine.substring(0, firstSpace);
                        mainArgs = commandLine.substring(firstSpace + 1);
                    }
                    String mainClassLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Main_class");
                    String argsLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Arguments");
                    data.append("<b>" + mainClassLbl + ":</b> " + mainClass + "<br>");
                    data.append("<b>" + argsLbl + ":</b> " + (mainArgs == null ? NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_none") : mainArgs) + "<br>");
                    data.append("<br>");
                }
                String jvmFlags = model.getJvmFlags();
                String jvmLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_JVM");
                String jLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Java");
                String verLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Java_Version");
                String vendorLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Java_Vendor");
                String jhLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_Java_Home");
                String flagsLbl = NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_JVM_Flags");
                String vmnS = model.getVmName();
                String vmvS = model.getVmVersion();
                String vmiS = model.getVmInfo();
                if (vmvS != null || vmiS != null) {
                    vmnS = vmnS + " (";
                    if (vmvS != null) {
                        vmnS = vmnS + vmvS;
                    }
                    if (vmvS != null && vmiS != null) {
                        vmnS = vmnS + ", ";
                    }
                    if (vmiS != null) {
                        vmnS = vmnS + vmiS;
                    }
                    vmnS = vmnS + ")";
                }
                data.append("<b>" + jvmLbl + ":</b> " + vmnS + "<br>");
                Properties props = model.getSystemProperties();
                if (props != null) {
                    boolean spec;
                    String javaVersion = props.getProperty("java.version");
                    String javaVendor = props.getProperty("java.vendor");
                    boolean bl = spec = javaVersion == null && javaVendor == null;
                    if (spec) {
                        javaVersion = props.getProperty("java.vm.specification.version");
                        javaVendor = props.getProperty("java.vm.vendor");
                    }
                    if (javaVersion != null || javaVendor != null) {
                        data.append("<b>" + jLbl + ":</b>");
                        if (javaVersion != null) {
                            if (!spec) {
                                data.append(" " + verLbl + " " + javaVersion);
                            } else {
                                data.append(" spec. version " + javaVersion);
                            }
                        }
                        if (javaVendor != null) {
                            if (javaVersion != null) {
                                data.append(",");
                            }
                            if (!spec) {
                                data.append(" " + vendorLbl + " " + javaVendor);
                            } else {
                                data.append(" VM vendor " + javaVendor);
                            }
                        }
                        data.append("<br>");
                    }
                }
                String javaHome = model.getJavaHome();
                data.append("<b>" + jhLbl + ":</b> " + (javaHome == null || javaHome.length() == 0 ? NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_none") : javaHome) + "<br>");
                data.append("<b>" + flagsLbl + ":</b> " + (jvmFlags == null || jvmFlags.length() == 0 ? NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"LBL_none") : jvmFlags) + "<br><br>");
                return data.toString();
            }
            JFRModelFactory f = JFRModelFactory.getDefault();
            if (!f.hasProviders()) {
                return NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"MSG_JFR_Failed_Install_Generic");
            }
            return NbBundle.getMessage(JFRSnapshotOverviewView.class, (String)"MSG_JFR_Failed_General");
        }
    }
}

