/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.DeleteAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.StreamUtils;

public class SimplifyWayAction
extends JosmAction {
    public SimplifyWayAction() {
        super(I18n.tr("Simplify Way", new Object[0]), "simplify", I18n.tr("Delete unnecessary nodes from a way.", new Object[0]), Shortcut.registerShortcut("tools:simplify", I18n.tr("Tools: {0}", I18n.tr("Simplify Way", new Object[0])), 89, 5005), true);
        this.setHelpId(HelpUtil.ht("/Action/SimplifyWay"));
    }

    protected boolean confirmWayWithNodesOutsideBoundingBox(List<? extends OsmPrimitive> primitives) {
        return DeleteAction.checkAndConfirmOutlyingDelete(primitives, null);
    }

    protected void alertSelectAtLeastOneWay() {
        SwingUtilities.invokeLater(() -> new Notification(I18n.tr("Please select at least one way to simplify.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).setHelpTopic(HelpUtil.ht("/Action/SimplifyWay#SelectAWayToSimplify")).show());
    }

    protected boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes", new Object[0]), new ImageProvider("ok"), I18n.tr("Simplify all selected ways", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Cancel operation", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("The selection contains {0} ways. Are you sure you want to simplify them all?", numWays), I18n.tr("Simplify ways?", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Action/SimplifyWay#ConfirmSimplifyAll"));
    }

    public static double askSimplifyWays(String text, boolean auto) {
        return SimplifyWayAction.askSimplifyWays(Collections.emptyList(), text, auto);
    }

    public static double askSimplifyWays(List<Way> ways, String text, boolean auto) {
        IPreferences s = Config.getPref();
        String key = "simplify-way." + (auto ? "auto." : "");
        String keyRemember = key + "remember";
        String keyError = key + "max-error";
        String r = s.get(keyRemember, "ask");
        if (auto && "no".equals(r)) {
            return -1.0;
        }
        if ("yes".equals(r)) {
            return s.getDouble(keyError, 3.0);
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel("<html><body style=\"width: 375px;\">" + text + "<br><br>" + I18n.tr("This reduces unnecessary nodes along the way and is especially recommended if GPS tracks were recorded by time (e.g. one point per second) or when the accuracy was low (reduces \"zigzag\" tracks).", new Object[0]) + "</body></html>"), GBC.eol());
        p.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        JPanel q = new JPanel(new GridBagLayout());
        q.add(new JLabel(I18n.tr("Maximum error (meters): ", new Object[0])));
        SpinnerNumberModel errorModel = new SpinnerNumberModel((Number)s.getDouble(keyError, 3.0), Double.valueOf(0.01), null, (Number)0.5);
        JSpinner n = new JSpinner(errorModel);
        ((JSpinner.DefaultEditor)n.getEditor()).getTextField().setColumns(4);
        q.add(n);
        JLabel nodesToRemove = new JLabel();
        SimplifyChangeListener l = new SimplifyChangeListener(nodesToRemove, errorModel, ways);
        if (!ways.isEmpty()) {
            errorModel.addChangeListener(l);
            l.stateChanged(null);
            q.add((Component)nodesToRemove, GBC.std().insets(5, 0, 0, 0));
            errorModel.getChangeListeners();
        }
        q.setBorder(BorderFactory.createEmptyBorder(14, 0, 10, 0));
        p.add((Component)q, GBC.eol());
        JCheckBox c = new JCheckBox(I18n.tr("Do not ask again", new Object[0]));
        p.add((Component)c, GBC.eol());
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Simplify way", new Object[0]), I18n.tr("Simplify", new Object[0]), auto ? I18n.tr("Proceed without simplifying", new Object[0]) : I18n.tr("Cancel", new Object[0])).setContent(p).configureContextsensitiveHelp("Action/SimplifyWay", true);
        if (auto) {
            ed.setButtonIcons("simplify", "ok");
        } else {
            ed.setButtonIcons("ok", "cancel");
        }
        int ret = ed.showDialog().getValue();
        double val = (Double)n.getValue();
        if (l.lastCommand != null && l.lastCommand.equals(UndoRedoHandler.getInstance().getLastCommand())) {
            UndoRedoHandler.getInstance().undo();
            l.lastCommand = null;
        }
        if (ret == 1) {
            s.putDouble(keyError, val);
            if (c.isSelected()) {
                s.put(keyRemember, "yes");
            }
            return val;
        }
        if (auto && c.isSelected()) {
            s.put(keyRemember, "no");
        }
        return -1.0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        ds.update(() -> {
            List<Way> ways = ds.getSelectedWays().stream().filter(p -> !p.isIncomplete()).collect(Collectors.toList());
            if (ways.isEmpty()) {
                this.alertSelectAtLeastOneWay();
                return;
            }
            if (!this.confirmWayWithNodesOutsideBoundingBox(ways) || ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
                return;
            }
            String lengthstr = SystemOfMeasurement.getSystemOfMeasurement().getDistText(ways.stream().mapToDouble(Way::getLength).sum());
            Object[] objectArray = new Object[]{ways.size(), lengthstr};
            double err = SimplifyWayAction.askSimplifyWays(ways, I18n.trn("You are about to simplify {0} way with a total length of {1}.", "You are about to simplify {0} ways with a total length of {1}.", ways.size(), objectArray), false);
            if (err > 0.0) {
                SimplifyWayAction.simplifyWays(ways, err);
            }
        });
    }

    protected static boolean isRequiredNode(Way way, Node node, Set<Node> multipleUseNodes) {
        boolean isRequired = node.isTagged();
        if (!isRequired && multipleUseNodes.contains(node)) {
            int frequency = Collections.frequency(way.getNodes(), node);
            if (way.getNode(0) == node && way.getNode(way.getNodesCount() - 1) == node) {
                --frequency;
            }
            boolean bl = isRequired = frequency > 1;
        }
        if (!isRequired) {
            LinkedList<OsmPrimitive> parents = new LinkedList<OsmPrimitive>();
            parents.addAll(node.getReferrers());
            parents.remove(way);
            isRequired = !parents.isEmpty();
        }
        return isRequired;
    }

    private static Set<Node> getMultiUseNodes(Way w) {
        HashSet allNodes = new HashSet();
        return w.getNodes().stream().filter(n -> !allNodes.add(n)).collect(Collectors.toSet());
    }

    public static int simplifyWaysCountNodesRemoved(List<Way> ways, double threshold) {
        SequenceCommand command = SimplifyWayAction.buildSimplifyWaysCommand(ways, threshold);
        if (command == null) {
            return 0;
        }
        return (int)((Command)command).getParticipatingPrimitives().stream().filter(Node.class::isInstance).count();
    }

    public static void simplifyWays(List<Way> ways, double threshold) {
        SequenceCommand command = SimplifyWayAction.buildSimplifyWaysCommand(ways, threshold);
        if (command != null) {
            UndoRedoHandler.getInstance().add(command);
        }
    }

    private static SequenceCommand buildSimplifyWaysCommand(List<Way> ways, double threshold) {
        Collection allCommands = ways.stream().map(way -> SimplifyWayAction.createSimplifyCommand(way, threshold)).filter(Objects::nonNull).collect(StreamUtils.toUnmodifiableList());
        if (allCommands.isEmpty()) {
            return null;
        }
        return new SequenceCommand(I18n.trn("Simplify {0} way", "Simplify {0} ways", allCommands.size(), allCommands.size()), allCommands);
    }

    @Deprecated
    public final SequenceCommand simplifyWay(Way w) {
        return SimplifyWayAction.createSimplifyCommand(w);
    }

    @Deprecated
    public static SequenceCommand simplifyWay(Way w, double threshold) {
        return SimplifyWayAction.createSimplifyCommand(w, threshold);
    }

    public static SequenceCommand createSimplifyCommand(Way w) {
        return SimplifyWayAction.createSimplifyCommand(w, Config.getPref().getDouble("simplify-way.max-error", 3.0));
    }

    public static SequenceCommand createSimplifyCommand(Way w, double threshold) {
        int lower = 0;
        int i = 0;
        Set<Node> multipleUseNodes = SimplifyWayAction.getMultiUseNodes(w);
        ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
        while (i < w.getNodesCount()) {
            if (SimplifyWayAction.isRequiredNode(w, w.getNode(i), multipleUseNodes)) {
                newNodes.add(w.getNode(i));
                ++i;
                ++lower;
                continue;
            }
            ++i;
            while (i < w.getNodesCount() && !SimplifyWayAction.isRequiredNode(w, w.getNode(i), multipleUseNodes)) {
                ++i;
            }
            SimplifyWayAction.buildSimplifiedNodeList(w.getNodes(), lower, Math.min(w.getNodesCount() - 1, i), threshold, newNodes);
            lower = i++;
        }
        if (newNodes.size() > 3 && newNodes.get(0) == newNodes.get(newNodes.size() - 1) && !SimplifyWayAction.isRequiredNode(w, (Node)newNodes.get(0), multipleUseNodes)) {
            List<Node> l1 = Arrays.asList((Node)newNodes.get(newNodes.size() - 2), (Node)newNodes.get(0), (Node)newNodes.get(1));
            ArrayList<Node> l2 = new ArrayList<Node>(3);
            SimplifyWayAction.buildSimplifiedNodeList(l1, 0, 2, threshold, l2);
            if (!l2.contains(newNodes.get(0))) {
                newNodes.remove(0);
                newNodes.set(newNodes.size() - 1, (Node)newNodes.get(0));
            }
        }
        if (newNodes.size() == w.getNodesCount()) {
            return null;
        }
        HashSet<Node> delNodes = new HashSet<Node>(w.getNodes());
        delNodes.removeAll(newNodes);
        if (delNodes.isEmpty()) {
            return null;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        cmds.add(new ChangeNodesCommand(w, (List<Node>)newNodes));
        cmds.add(new DeleteCommand(w.getDataSet(), delNodes));
        w.getDataSet().clearSelection(delNodes);
        return new SequenceCommand(I18n.trn("Simplify Way (remove {0} node)", "Simplify Way (remove {0} nodes)", delNodes.size(), delNodes.size()), cmds);
    }

    protected static void buildSimplifiedNodeList(List<Node> wnew, int from, int to, double threshold, List<Node> simplifiedNodes) {
        Node fromN = wnew.get(from);
        Node toN = wnew.get(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = wnew.get(i);
            double xte = Math.abs(Ellipsoid.WGS84.a * SimplifyWayAction.xtd(fromN.lat() * Math.PI / 180.0, fromN.lon() * Math.PI / 180.0, toN.lat() * Math.PI / 180.0, toN.lon() * Math.PI / 180.0, n.lat() * Math.PI / 180.0, n.lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= threshold) {
            SimplifyWayAction.buildSimplifiedNodeList(wnew, from, imax, threshold, simplifiedNodes);
            SimplifyWayAction.buildSimplifiedNodeList(wnew, imax, to, threshold, simplifiedNodes);
        } else {
            if (simplifiedNodes.isEmpty() || simplifiedNodes.get(simplifiedNodes.size() - 1) != fromN) {
                simplifiedNodes.add(fromN);
            }
            if (fromN != toN) {
                simplifiedNodes.add(toN);
            }
        }
    }

    private static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    private static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    private static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double distAD = SimplifyWayAction.dist(lat1, lon1, lat3, lon3);
        double crsAD = SimplifyWayAction.course(lat1, lon1, lat3, lon3);
        double crsAB = SimplifyWayAction.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(distAD) * Math.sin(crsAD - crsAB));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    private static class SimplifyChangeListener
    implements ChangeListener {
        Command lastCommand;
        private final JLabel nodesToRemove;
        private final SpinnerNumberModel errorModel;
        private final List<Way> ways;

        SimplifyChangeListener(JLabel nodesToRemove, SpinnerNumberModel errorModel, List<Way> ways) {
            this.nodesToRemove = nodesToRemove;
            this.errorModel = errorModel;
            this.ways = ways;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (Objects.equals(UndoRedoHandler.getInstance().getLastCommand(), this.lastCommand)) {
                UndoRedoHandler.getInstance().undo();
            }
            double threshold = this.errorModel.getNumber().doubleValue();
            int removeNodes = SimplifyWayAction.simplifyWaysCountNodesRemoved(this.ways, threshold);
            this.nodesToRemove.setText(I18n.trn("(about {0} node to remove)", "(about {0} nodes to remove)", removeNodes, removeNodes));
            this.lastCommand = SimplifyWayAction.buildSimplifyWaysCommand(this.ways, threshold);
            if (this.lastCommand != null) {
                UndoRedoHandler.getInstance().add(this.lastCommand);
            }
        }
    }
}

