/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.diagram.SDPaintDevice;
import net.sf.sdedit.diagram.SequenceDiagramFactory;
import net.sf.sdedit.editor.DiagramFileHandler;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.plugin.Plugin;
import net.sf.sdedit.editor.plugin.PluginRegistry;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.ui.ImageGraphicsDevice;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.ObjectFactory;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Tooltips;
import net.sf.sdedit.util.Utilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main
implements Constants {
    public static void main(String[] argv) throws Exception {
        Tooltips.addFile(Utilities.getResource("tooltips"));
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        Options options = Main.createBasicOptions();
        try {
            cmd = parser.parse(options, argv);
            if (cmd != null && cmd.hasOption('p')) {
                String[] plugins;
                for (String plugin : plugins = cmd.getOptionValues('p')) {
                    try {
                        Class<?> pluginClass = Class.forName(plugin.trim());
                        PluginRegistry.getInstance().addPlugin((Plugin)pluginClass.newInstance());
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Throwable t) {
                        System.err.println("Warning: cannot load plugin class " + plugin + " (" + t.getMessage() + ")");
                    }
                }
            }
        }
        catch (ParseException plugins) {
            // empty catch block
        }
        options = Main.createBasicOptions();
        Main.addPropertyOptions(options, ConfigurationManager.getDefaultConfigurationBean(SequenceConfiguration.class));
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException pe) {
            Main.printHelp(Main.createBasicOptions());
            return;
        }
        if (cmd.hasOption('h')) {
            Main.printHelp(options);
            return;
        }
        if (cmd.getOptionValue('o') != null) {
            Main.createImage(cmd);
            System.out.println("created image file: " + cmd.getOptionValue('o'));
        } else {
            final String[] files = Main.getInputFiles(cmd);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor editor = Editor.getEditor();
                    editor.start();
                    if (files.length > 0) {
                        boolean loaded = false;
                        for (String file : files) {
                            File sdFile = new File(file);
                            if (sdFile.exists() && sdFile.canRead() && !sdFile.isDirectory()) {
                                try {
                                    loaded = editor.load(sdFile.toURI().toURL()) != null;
                                    continue;
                                }
                                catch (RuntimeException re) {
                                    throw re;
                                }
                                catch (Throwable t) {
                                    editor.getUI().errorMessage(t, null, null);
                                    continue;
                                }
                            }
                            System.err.println("Warning: ignoring file " + file);
                        }
                        if (!loaded) {
                            editor.getUI().addDefaultTab();
                        }
                    } else {
                        editor.getUI().addDefaultTab();
                    }
                }
            });
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("<sdedit-start-command> [options] [input-files]", options);
    }

    private static Options createBasicOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output file");
        Option output = OptionBuilder.create('o');
        options.addOption(output);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output file type");
        OptionBuilder.withDescription("one of " + Main.availableTypes());
        OptionBuilder.hasArg();
        Option type = OptionBuilder.create('t');
        options.addOption(type);
        OptionBuilder.withArgName("orientation");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("one of {Portrait, Landscape}");
        Option orientation = OptionBuilder.create('r');
        options.addOption(orientation);
        OptionBuilder.withArgName("page format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("one of {A0, ..., A6}");
        Option format = OptionBuilder.create('f');
        options.addOption(format);
        OptionBuilder.withDescription("show long options (for diagram preferences)");
        Option help = OptionBuilder.create('h');
        options.addOption(help);
        OptionBuilder.withDescription("plugin classes to be loaded");
        OptionBuilder.hasArgs();
        Option plugins = OptionBuilder.create('p');
        options.addOption(plugins);
        return options;
    }

    private static void addPropertyOptions(Options options, Bean<? extends Configuration> conf) {
        for (PropertyDescriptor property : conf.getProperties()) {
            if (!property.getWriteMethod().getAnnotation(Adjustable.class).editable()) continue;
            String name = property.getName();
            String type = property.getPropertyType().getSimpleName();
            String info = property.getWriteMethod().getAnnotation(Adjustable.class).info();
            OptionBuilder.withArgName(type);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription(info);
            OptionBuilder.withValueSeparator('=');
            OptionBuilder.withLongOpt(name);
            Option option = OptionBuilder.create();
            options.addOption(option);
        }
    }

    private static String[] getInputFiles(CommandLine cmd) {
        return cmd.getArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createImage(CommandLine cmd) throws IOException, DocUtil.XMLException, DiagramError {
        File inFile = new File(Main.getInputFiles(cmd)[0]);
        File outFile = new File(cmd.getOptionValue('o'));
        String type = "png";
        if (cmd.getOptionValue('t') != null) {
            type = cmd.getOptionValue('t').toLowerCase();
        }
        String format = "A4";
        if (cmd.getOptionValue('f') != null) {
            format = cmd.getOptionValue('f').toUpperCase();
        }
        String orientation = "Portrait";
        if (cmd.getOptionValue('r') != null && (orientation = cmd.getOptionValue('r').toLowerCase()).length() > 0) {
            orientation = orientation.substring(0, 1).toUpperCase() + orientation.substring(1);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        in = new FileInputStream(inFile);
        try {
            out = new FileOutputStream(outFile);
            try {
                Pair<String, Bean<? extends Configuration>> pair = new DiagramFileHandler().load(in, ConfigurationManager.getGlobalConfiguration().getFileEncoding());
                String text = pair.getFirst();
                Bean<? extends Configuration> conf = pair.getSecond();
                Main.configure(conf, cmd);
                if (type.equals("png")) {
                    ImageGraphicsDevice graphicDevice = new ImageGraphicsDevice();
                    SDPaintDevice paintDevice = new SDPaintDevice(graphicDevice);
                    SequenceDiagramFactory factory = new SequenceDiagramFactory(text, (PaintDevice)paintDevice);
                    factory.generateDiagram(conf.getDataObject());
                    graphicDevice.writeToStream("png", out);
                } else {
                    Exporter graphicDevice = Exporter.getExporter(type, orientation, format, out);
                    SDPaintDevice paintDevice = new SDPaintDevice(graphicDevice);
                    SequenceDiagramFactory factory = new SequenceDiagramFactory(text, (PaintDevice)paintDevice);
                    factory.generateDiagram(conf.getDataObject());
                    graphicDevice.export();
                }
                out.flush();
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void configure(Bean<? extends Configuration> conf, CommandLine cmd) {
        for (Option option : cmd.getOptions()) {
            if (option.getLongOpt() == null) continue;
            String name = option.getLongOpt();
            String valueString = cmd.getOptionValue(option.getLongOpt());
            if (valueString == null) continue;
            PropertyDescriptor property = conf.getProperty(name);
            Object value = ObjectFactory.createFromString(property.getPropertyType(), valueString);
            conf.setValue(property, value);
        }
    }

    private static String availableTypes() {
        return "{ps, pdf, emf, svg, png, gif, jpg, bmp}";
    }

    static {
        if (OS.TYPE == OS.Type.MAC) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "sdedit");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
    }
}

