// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32g051.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32g051

// STM32G051
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32G051"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// DMAMUX
	IRQ_DMA_Channel4_5_6_7 = 11

	// Advanced-timers
	IRQ_TIM1_BRK_UP_TRG_COM = 13

	// Advanced-timers
	IRQ_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM2 = 15

	IRQ_TIM3 = 16

	// Basic timers
	IRQ_TIM6_DAC = 17

	IRQ_TIM7 = 18

	// General purpose timers
	IRQ_TIM14 = 19

	// General purpose timers
	IRQ_TIM15 = 20

	// General purpose timers
	IRQ_TIM16 = 21

	IRQ_TIM17 = 22

	// Inter-integrated circuit
	IRQ_I2C1 = 23

	IRQ_I2C2 = 24

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2 = 28

	// HDMI-CEC
	IRQ_CEC = 30

	// Highest interrupt number on this device.
	IRQ_max = 30
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel4_5_6_7, "DMA_Channel4_5_6_7_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_UP_TRG_COM, "TIM1_BRK_UP_TRG_COM_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_TIM14, "TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM15, "TIM15_IRQHandler")
	_ = interrupt.Register(IRQ_TIM16, "TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM17, "TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_CEC, "CEC_IRQHandler")
)

// Peripherals.
var (
	// ADC address block description
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// DMAMUX
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// HDMI-CEC
	HDMI_CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// System configuration controller
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))
)

// ADC address block description
type ADC_Type struct {
	ADC_ISR        volatile.Register32 // 0x0
	ADC_IER        volatile.Register32 // 0x4
	ADC_CR         volatile.Register32 // 0x8
	ADC_CFGR1      volatile.Register32 // 0xC
	ADC_CFGR2      volatile.Register32 // 0x10
	ADC_SMPR       volatile.Register32 // 0x14
	_              [8]byte
	ADC_AWD1TR     volatile.Register32 // 0x20
	ADC_AWD2TR     volatile.Register32 // 0x24
	ADC_CHSELRMOD0 volatile.Register32 // 0x28
	ADC_AWD3TR     volatile.Register32 // 0x2C
	_              [16]byte
	ADC_DR         volatile.Register32 // 0x40
	_              [92]byte
	ADC_AWD2CR     volatile.Register32 // 0xA0
	ADC_AWD3CR     volatile.Register32 // 0xA4
	_              [12]byte
	ADC_CALFACT    volatile.Register32 // 0xB4
	_              [592]byte
	ADC_CCR        volatile.Register32 // 0x308
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	CRC_DR   volatile.Register32 // 0x0
	CRC_IDR  volatile.Register32 // 0x4
	CRC_CR   volatile.Register32 // 0x8
	_        [4]byte
	CRC_INIT volatile.Register32 // 0x10
	CRC_POL  volatile.Register32 // 0x14
}

// DAC
type DAC_Type struct {
	DAC_CR      volatile.Register32 // 0x0
	DAC_SWTRGR  volatile.Register32 // 0x4
	DAC_DHR12R1 volatile.Register32 // 0x8
	DAC_DHR12L1 volatile.Register32 // 0xC
	DAC_DHR8R1  volatile.Register32 // 0x10
	DAC_DHR12R2 volatile.Register32 // 0x14
	DAC_DHR12L2 volatile.Register32 // 0x18
	DAC_DHR8R2  volatile.Register32 // 0x1C
	DAC_DHR12RD volatile.Register32 // 0x20
	DAC_DHR12LD volatile.Register32 // 0x24
	DAC_DHR8RD  volatile.Register32 // 0x28
	DAC_DOR1    volatile.Register32 // 0x2C
	DAC_DOR2    volatile.Register32 // 0x30
	DAC_SR      volatile.Register32 // 0x34
	DAC_CCR     volatile.Register32 // 0x38
	DAC_MCR     volatile.Register32 // 0x3C
	DAC_SHSR1   volatile.Register32 // 0x40
	DAC_SHSR2   volatile.Register32 // 0x44
	DAC_SHHR    volatile.Register32 // 0x48
	DAC_SHRR    volatile.Register32 // 0x4C
}

// DMAMUX
type DMAMUX_Type struct {
	DMAMUX_C0CR  volatile.Register32 // 0x0
	DMAMUX_C1CR  volatile.Register32 // 0x4
	DMAMUX_C2CR  volatile.Register32 // 0x8
	DMAMUX_C3CR  volatile.Register32 // 0xC
	DMAMUX_C4CR  volatile.Register32 // 0x10
	DMAMUX_C5CR  volatile.Register32 // 0x14
	DMAMUX_C6CR  volatile.Register32 // 0x18
	_            [100]byte
	DMAMUX_CSR   volatile.Register32 // 0x80
	DMAMUX_CFR   volatile.Register32 // 0x84
	_            [120]byte
	DMAMUX_RG0CR volatile.Register32 // 0x100
	DMAMUX_RG1CR volatile.Register32 // 0x104
	DMAMUX_RG2CR volatile.Register32 // 0x108
	DMAMUX_RG3CR volatile.Register32 // 0x10C
	_            [48]byte
	DMAMUX_RGSR  volatile.Register32 // 0x140
	DMAMUX_RGCFR volatile.Register32 // 0x144
}

// HDMI-CEC
type CEC_Type struct {
	CEC_CR   volatile.Register32 // 0x0
	CEC_CFGR volatile.Register32 // 0x4
	CEC_TXDR volatile.Register32 // 0x8
	CEC_RXDR volatile.Register32 // 0xC
	CEC_ISR  volatile.Register32 // 0x10
	CEC_IER  volatile.Register32 // 0x14
}

// Inter-integrated circuit
type I2C_Type struct {
	I2C_CR1      volatile.Register32 // 0x0
	I2C_CR2      volatile.Register32 // 0x4
	I2C_OAR1     volatile.Register32 // 0x8
	I2C_OAR2     volatile.Register32 // 0xC
	I2C_TIMINGR  volatile.Register32 // 0x10
	I2C_TIMEOUTR volatile.Register32 // 0x14
	I2C_ISR      volatile.Register32 // 0x18
	I2C_ICR      volatile.Register32 // 0x1C
	I2C_PECR     volatile.Register32 // 0x20
	I2C_RXDR     volatile.Register32 // 0x24
	I2C_TXDR     volatile.Register32 // 0x28
}

// Independent watchdog
type IWDG_Type struct {
	IWDG_KR   volatile.Register32 // 0x0
	IWDG_PR   volatile.Register32 // 0x4
	IWDG_RLR  volatile.Register32 // 0x8
	IWDG_SR   volatile.Register32 // 0xC
	IWDG_WINR volatile.Register32 // 0x10
}

// Low power timer
type LPTIM_Type struct {
	LPTIM_ISR   volatile.Register32 // 0x0
	LPTIM_ICR   volatile.Register32 // 0x4
	LPTIM_IER   volatile.Register32 // 0x8
	LPTIM_CFGR  volatile.Register32 // 0xC
	LPTIM_CR    volatile.Register32 // 0x10
	LPTIM_CMP   volatile.Register32 // 0x14
	LPTIM_ARR   volatile.Register32 // 0x18
	LPTIM_CNT   volatile.Register32 // 0x1C
	_           [4]byte
	LPTIM_CFGR2 volatile.Register32 // 0x24
}

// Advanced-timers
type TIM_Type struct {
	TIM1_CR1     volatile.Register32 // 0x0
	TIM1_CR2     volatile.Register32 // 0x4
	TIM1_SMCR    volatile.Register32 // 0x8
	TIM1_DIER    volatile.Register32 // 0xC
	TIM1_SR      volatile.Register32 // 0x10
	TIM1_EGR     volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	TIM1_CCER    volatile.Register32 // 0x20
	TIM1_CNT     volatile.Register32 // 0x24
	TIM1_PSC     volatile.Register32 // 0x28
	TIM1_ARR     volatile.Register32 // 0x2C
	TIM1_RCR     volatile.Register32 // 0x30
	TIM1_CCR1    volatile.Register32 // 0x34
	TIM1_CCR2    volatile.Register32 // 0x38
	TIM1_CCR3    volatile.Register32 // 0x3C
	TIM1_CCR4    volatile.Register32 // 0x40
	TIM1_BDTR    volatile.Register32 // 0x44
	TIM1_DCR     volatile.Register32 // 0x48
	TIM1_DMAR    volatile.Register32 // 0x4C
	TIM1_OR1     volatile.Register32 // 0x50
	CCMR3_Output volatile.Register32 // 0x54
	TIM1_CCR5    volatile.Register32 // 0x58
	TIM1_CCR6    volatile.Register32 // 0x5C
	TIM1_AF1     volatile.Register32 // 0x60
	TIM1_AF2     volatile.Register32 // 0x64
	TIM1_TISEL   volatile.Register32 // 0x68
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1_FIFO_ENABLED volatile.Register32 // 0x0
	CR2              volatile.Register32 // 0x4
	CR3              volatile.Register32 // 0x8
	BRR              volatile.Register32 // 0xC
	GTPR             volatile.Register32 // 0x10
	RTOR             volatile.Register32 // 0x14
	RQR              volatile.Register32 // 0x18
	ISR_FIFO_ENABLED volatile.Register32 // 0x1C
	ICR              volatile.Register32 // 0x20
	RDR              volatile.Register32 // 0x24
	TDR              volatile.Register32 // 0x28
	PRESC            volatile.Register32 // 0x2C
}

// System configuration controller
type VREFBUF_Type struct {
	VREFBUF_CSR volatile.Register32 // 0x0
	VREFBUF_CCR volatile.Register32 // 0x4
}

// System window watchdog
type WWDG_Type struct {
	WWDG_CR  volatile.Register32 // 0x0
	WWDG_CFR volatile.Register32 // 0x4
	WWDG_SR  volatile.Register32 // 0x8
}

// Bitfields for ADC: ADC address block description
const (
	// ADC_ISR: ADC interrupt and status register
	// Position of ADRDY field.
	ADC_ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ADC_ISR_ADRDY = 0x1
	// ADC not yet ready to start conversion (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_ADRDY_B_0x0 = 0x0
	// ADC is ready to start conversion
	ADC_ADC_ISR_ADRDY_B_0x1 = 0x1
	// Position of EOSMP field.
	ADC_ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ADC_ISR_EOSMP = 0x2
	// Not at the end of the sampling phase (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_EOSMP_B_0x0 = 0x0
	// End of sampling phase reached
	ADC_ADC_ISR_EOSMP_B_0x1 = 0x1
	// Position of EOC field.
	ADC_ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ADC_ISR_EOC = 0x4
	// Channel conversion not complete (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_EOC_B_0x0 = 0x0
	// Channel conversion complete
	ADC_ADC_ISR_EOC_B_0x1 = 0x1
	// Position of EOS field.
	ADC_ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ADC_ISR_EOS = 0x8
	// Conversion sequence not complete (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_EOS_B_0x0 = 0x0
	// Conversion sequence complete
	ADC_ADC_ISR_EOS_B_0x1 = 0x1
	// Position of OVR field.
	ADC_ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ADC_ISR_OVR = 0x10
	// No overrun occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_OVR_B_0x0 = 0x0
	// Overrun has occurred
	ADC_ADC_ISR_OVR_B_0x1 = 0x1
	// Position of AWD1 field.
	ADC_ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ADC_ISR_AWD1 = 0x80
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_AWD1_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ADC_ISR_AWD1_B_0x1 = 0x1
	// Position of AWD2 field.
	ADC_ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ADC_ISR_AWD2 = 0x100
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_AWD2_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ADC_ISR_AWD2_B_0x1 = 0x1
	// Position of AWD3 field.
	ADC_ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ADC_ISR_AWD3 = 0x200
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ADC_ISR_AWD3_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ADC_ISR_AWD3_B_0x1 = 0x1
	// Position of EOCAL field.
	ADC_ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ADC_ISR_EOCAL = 0x800
	// Calibration is not complete
	ADC_ADC_ISR_EOCAL_B_0x0 = 0x0
	// Calibration is complete
	ADC_ADC_ISR_EOCAL_B_0x1 = 0x1
	// Position of CCRDY field.
	ADC_ADC_ISR_CCRDY_Pos = 0xd
	// Bit mask of CCRDY field.
	ADC_ADC_ISR_CCRDY_Msk = 0x2000
	// Bit CCRDY.
	ADC_ADC_ISR_CCRDY = 0x2000
	// Channel configuration update not applied.
	ADC_ADC_ISR_CCRDY_B_0x0 = 0x0
	// Channel configuration update is applied.
	ADC_ADC_ISR_CCRDY_B_0x1 = 0x1

	// ADC_IER: ADC interrupt enable register
	// Position of ADRDYIE field.
	ADC_ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_ADC_IER_ADRDYIE = 0x1
	// ADRDY interrupt disabled.
	ADC_ADC_IER_ADRDYIE_B_0x0 = 0x0
	// ADRDY interrupt enabled. An interrupt is generated when the ADRDY bit is set.
	ADC_ADC_IER_ADRDYIE_B_0x1 = 0x1
	// Position of EOSMPIE field.
	ADC_ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_ADC_IER_EOSMPIE = 0x2
	// EOSMP interrupt disabled.
	ADC_ADC_IER_EOSMPIE_B_0x0 = 0x0
	// EOSMP interrupt enabled. An interrupt is generated when the EOSMP bit is set.
	ADC_ADC_IER_EOSMPIE_B_0x1 = 0x1
	// Position of EOCIE field.
	ADC_ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_ADC_IER_EOCIE = 0x4
	// EOC interrupt disabled
	ADC_ADC_IER_EOCIE_B_0x0 = 0x0
	// EOC interrupt enabled. An interrupt is generated when the EOC bit is set.
	ADC_ADC_IER_EOCIE_B_0x1 = 0x1
	// Position of EOSIE field.
	ADC_ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_ADC_IER_EOSIE = 0x8
	// EOS interrupt disabled
	ADC_ADC_IER_EOSIE_B_0x0 = 0x0
	// EOS interrupt enabled. An interrupt is generated when the EOS bit is set.
	ADC_ADC_IER_EOSIE_B_0x1 = 0x1
	// Position of OVRIE field.
	ADC_ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_ADC_IER_OVRIE = 0x10
	// Overrun interrupt disabled
	ADC_ADC_IER_OVRIE_B_0x0 = 0x0
	// Overrun interrupt enabled. An interrupt is generated when the OVR bit is set.
	ADC_ADC_IER_OVRIE_B_0x1 = 0x1
	// Position of AWD1IE field.
	ADC_ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_ADC_IER_AWD1IE = 0x80
	// Analog watchdog interrupt disabled
	ADC_ADC_IER_AWD1IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_ADC_IER_AWD1IE_B_0x1 = 0x1
	// Position of AWD2IE field.
	ADC_ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_ADC_IER_AWD2IE = 0x100
	// Analog watchdog interrupt disabled
	ADC_ADC_IER_AWD2IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_ADC_IER_AWD2IE_B_0x1 = 0x1
	// Position of AWD3IE field.
	ADC_ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_ADC_IER_AWD3IE = 0x200
	// Analog watchdog interrupt disabled
	ADC_ADC_IER_AWD3IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_ADC_IER_AWD3IE_B_0x1 = 0x1
	// Position of EOCALIE field.
	ADC_ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_ADC_IER_EOCALIE = 0x800
	// End of calibration interrupt disabled
	ADC_ADC_IER_EOCALIE_B_0x0 = 0x0
	// End of calibration interrupt enabled
	ADC_ADC_IER_EOCALIE_B_0x1 = 0x1
	// Position of CCRDYIE field.
	ADC_ADC_IER_CCRDYIE_Pos = 0xd
	// Bit mask of CCRDYIE field.
	ADC_ADC_IER_CCRDYIE_Msk = 0x2000
	// Bit CCRDYIE.
	ADC_ADC_IER_CCRDYIE = 0x2000
	// Channel configuration ready interrupt disabled
	ADC_ADC_IER_CCRDYIE_B_0x0 = 0x0
	// Channel configuration ready interrupt enabled
	ADC_ADC_IER_CCRDYIE_B_0x1 = 0x1

	// ADC_CR: ADC control register
	// Position of ADEN field.
	ADC_ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_ADC_CR_ADEN = 0x1
	// ADC is disabled (OFF state)
	ADC_ADC_CR_ADEN_B_0x0 = 0x0
	// Write 1 to enable the ADC.
	ADC_ADC_CR_ADEN_B_0x1 = 0x1
	// Position of ADDIS field.
	ADC_ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_ADC_CR_ADDIS = 0x2
	// No ADDIS command ongoing
	ADC_ADC_CR_ADDIS_B_0x0 = 0x0
	// Write 1 to disable the ADC. Read 1 means that an ADDIS command is in progress.
	ADC_ADC_CR_ADDIS_B_0x1 = 0x1
	// Position of ADSTART field.
	ADC_ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_ADC_CR_ADSTART = 0x4
	// No ADC conversion is ongoing.
	ADC_ADC_CR_ADSTART_B_0x0 = 0x0
	// Write 1 to start the ADC. Read 1 means that the ADC is operating and may be converting.
	ADC_ADC_CR_ADSTART_B_0x1 = 0x1
	// Position of ADSTP field.
	ADC_ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_ADC_CR_ADSTP = 0x10
	// No ADC stop conversion command ongoing
	ADC_ADC_CR_ADSTP_B_0x0 = 0x0
	// Write 1 to stop the ADC. Read 1 means that an ADSTP command is in progress.
	ADC_ADC_CR_ADSTP_B_0x1 = 0x1
	// Position of ADVREGEN field.
	ADC_ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_ADC_CR_ADVREGEN = 0x10000000
	// ADC voltage regulator disabled
	ADC_ADC_CR_ADVREGEN_B_0x0 = 0x0
	// ADC voltage regulator enabled
	ADC_ADC_CR_ADVREGEN_B_0x1 = 0x1
	// Position of ADCAL field.
	ADC_ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_ADC_CR_ADCAL = 0x80000000
	// Calibration complete
	ADC_ADC_CR_ADCAL_B_0x0 = 0x0
	// Write 1 to calibrate the ADC. Read at 1 means that a calibration is in progress.
	ADC_ADC_CR_ADCAL_B_0x1 = 0x1

	// ADC_CFGR1: ADC configuration register 1
	// Position of DMAEN field.
	ADC_ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_ADC_CFGR1_DMAEN = 0x1
	// DMA disabled
	ADC_ADC_CFGR1_DMAEN_B_0x0 = 0x0
	// DMA enabled
	ADC_ADC_CFGR1_DMAEN_B_0x1 = 0x1
	// Position of DMACFG field.
	ADC_ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_ADC_CFGR1_DMACFG = 0x2
	// DMA one shot mode selected
	ADC_ADC_CFGR1_DMACFG_B_0x0 = 0x0
	// DMA circular mode selected
	ADC_ADC_CFGR1_DMACFG_B_0x1 = 0x1
	// Position of SCANDIR field.
	ADC_ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_ADC_CFGR1_SCANDIR = 0x4
	// Upward scan (from CHSEL0 to CHSEL18)
	ADC_ADC_CFGR1_SCANDIR_B_0x0 = 0x0
	// Backward scan (from CHSEL18 to CHSEL0)
	ADC_ADC_CFGR1_SCANDIR_B_0x1 = 0x1
	// Position of RES field.
	ADC_ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_ADC_CFGR1_RES_Msk = 0x18
	// 12 bits
	ADC_ADC_CFGR1_RES_B_0x0 = 0x0
	// 10 bits
	ADC_ADC_CFGR1_RES_B_0x1 = 0x1
	// 8 bits
	ADC_ADC_CFGR1_RES_B_0x2 = 0x2
	// 6 bits
	ADC_ADC_CFGR1_RES_B_0x3 = 0x3
	// Position of ALIGN field.
	ADC_ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_ADC_CFGR1_ALIGN = 0x20
	// Right alignment
	ADC_ADC_CFGR1_ALIGN_B_0x0 = 0x0
	// Left alignment
	ADC_ADC_CFGR1_ALIGN_B_0x1 = 0x1
	// Position of EXTSEL field.
	ADC_ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// TRG0
	ADC_ADC_CFGR1_EXTSEL_B_0x0 = 0x0
	// TRG1
	ADC_ADC_CFGR1_EXTSEL_B_0x1 = 0x1
	// TRG2
	ADC_ADC_CFGR1_EXTSEL_B_0x2 = 0x2
	// TRG3
	ADC_ADC_CFGR1_EXTSEL_B_0x3 = 0x3
	// TRG4
	ADC_ADC_CFGR1_EXTSEL_B_0x4 = 0x4
	// TRG5
	ADC_ADC_CFGR1_EXTSEL_B_0x5 = 0x5
	// TRG6
	ADC_ADC_CFGR1_EXTSEL_B_0x6 = 0x6
	// TRG7
	ADC_ADC_CFGR1_EXTSEL_B_0x7 = 0x7
	// Position of EXTEN field.
	ADC_ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_ADC_CFGR1_EXTEN_Msk = 0xc00
	// Hardware trigger detection disabled (conversions can be started by software)
	ADC_ADC_CFGR1_EXTEN_B_0x0 = 0x0
	// Hardware trigger detection on the rising edge
	ADC_ADC_CFGR1_EXTEN_B_0x1 = 0x1
	// Hardware trigger detection on the falling edge
	ADC_ADC_CFGR1_EXTEN_B_0x2 = 0x2
	// Hardware trigger detection on both the rising and falling edges
	ADC_ADC_CFGR1_EXTEN_B_0x3 = 0x3
	// Position of OVRMOD field.
	ADC_ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_ADC_CFGR1_OVRMOD = 0x1000
	// ADC_DR register is preserved with the old data when an overrun is detected.
	ADC_ADC_CFGR1_OVRMOD_B_0x0 = 0x0
	// ADC_DR register is overwritten with the last conversion result when an overrun is detected.
	ADC_ADC_CFGR1_OVRMOD_B_0x1 = 0x1
	// Position of CONT field.
	ADC_ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_ADC_CFGR1_CONT = 0x2000
	// Single conversion mode
	ADC_ADC_CFGR1_CONT_B_0x0 = 0x0
	// Continuous conversion mode
	ADC_ADC_CFGR1_CONT_B_0x1 = 0x1
	// Position of WAIT field.
	ADC_ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_ADC_CFGR1_WAIT = 0x4000
	// Wait conversion mode off
	ADC_ADC_CFGR1_WAIT_B_0x0 = 0x0
	// Wait conversion mode on
	ADC_ADC_CFGR1_WAIT_B_0x1 = 0x1
	// Position of AUTOFF field.
	ADC_ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_ADC_CFGR1_AUTOFF = 0x8000
	// Auto-off mode disabled
	ADC_ADC_CFGR1_AUTOFF_B_0x0 = 0x0
	// Auto-off mode enabled
	ADC_ADC_CFGR1_AUTOFF_B_0x1 = 0x1
	// Position of DISCEN field.
	ADC_ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_ADC_CFGR1_DISCEN = 0x10000
	// Discontinuous mode disabled
	ADC_ADC_CFGR1_DISCEN_B_0x0 = 0x0
	// Discontinuous mode enabled
	ADC_ADC_CFGR1_DISCEN_B_0x1 = 0x1
	// Position of CHSELRMOD field.
	ADC_ADC_CFGR1_CHSELRMOD_Pos = 0x15
	// Bit mask of CHSELRMOD field.
	ADC_ADC_CFGR1_CHSELRMOD_Msk = 0x200000
	// Bit CHSELRMOD.
	ADC_ADC_CFGR1_CHSELRMOD = 0x200000
	// Each bit of the ADC_CHSELR register enables an input
	ADC_ADC_CFGR1_CHSELRMOD_B_0x0 = 0x0
	// ADC_CHSELR register is able to sequence up to 8 channels
	ADC_ADC_CFGR1_CHSELRMOD_B_0x1 = 0x1
	// Position of AWD1SGL field.
	ADC_ADC_CFGR1_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_ADC_CFGR1_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_ADC_CFGR1_AWD1SGL = 0x400000
	// Analog watchdog 1 enabled on all channels
	ADC_ADC_CFGR1_AWD1SGL_B_0x0 = 0x0
	// Analog watchdog 1 enabled on a single channel
	ADC_ADC_CFGR1_AWD1SGL_B_0x1 = 0x1
	// Position of AWD1EN field.
	ADC_ADC_CFGR1_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_ADC_CFGR1_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_ADC_CFGR1_AWD1EN = 0x800000
	// Analog watchdog 1 disabled
	ADC_ADC_CFGR1_AWD1EN_B_0x0 = 0x0
	// Analog watchdog 1 enabled
	ADC_ADC_CFGR1_AWD1EN_B_0x1 = 0x1
	// Position of AWD1CH field.
	ADC_ADC_CFGR1_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_ADC_CFGR1_AWD1CH_Msk = 0x7c000000
	// ADC analog input Channel 0 monitored by AWD
	ADC_ADC_CFGR1_AWD1CH_B_0x0 = 0x0
	// ADC analog input Channel 1 monitored by AWD
	ADC_ADC_CFGR1_AWD1CH_B_0x1 = 0x1
	// ADC analog input Channel 17 monitored by AWD
	ADC_ADC_CFGR1_AWD1CH_B_0x11 = 0x11
	// ADC analog input Channel 18 monitored by AWD
	ADC_ADC_CFGR1_AWD1CH_B_0x12 = 0x12

	// ADC_CFGR2: ADC configuration register 2
	// Position of OVSE field.
	ADC_ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_ADC_CFGR2_OVSE = 0x1
	// Oversampler disabled
	ADC_ADC_CFGR2_OVSE_B_0x0 = 0x0
	// Oversampler enabled
	ADC_ADC_CFGR2_OVSE_B_0x1 = 0x1
	// Position of OVSR field.
	ADC_ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_ADC_CFGR2_OVSR_Msk = 0x1c
	// 2x
	ADC_ADC_CFGR2_OVSR_B_0x0 = 0x0
	// 4x
	ADC_ADC_CFGR2_OVSR_B_0x1 = 0x1
	// 8x
	ADC_ADC_CFGR2_OVSR_B_0x2 = 0x2
	// 16x
	ADC_ADC_CFGR2_OVSR_B_0x3 = 0x3
	// 32x
	ADC_ADC_CFGR2_OVSR_B_0x4 = 0x4
	// 64x
	ADC_ADC_CFGR2_OVSR_B_0x5 = 0x5
	// 128x
	ADC_ADC_CFGR2_OVSR_B_0x6 = 0x6
	// 256x
	ADC_ADC_CFGR2_OVSR_B_0x7 = 0x7
	// Position of OVSS field.
	ADC_ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_ADC_CFGR2_OVSS_Msk = 0x1e0
	// No shift
	ADC_ADC_CFGR2_OVSS_B_0x0 = 0x0
	// Shift 1-bit
	ADC_ADC_CFGR2_OVSS_B_0x1 = 0x1
	// Shift 2-bits
	ADC_ADC_CFGR2_OVSS_B_0x2 = 0x2
	// Shift 3-bits
	ADC_ADC_CFGR2_OVSS_B_0x3 = 0x3
	// Shift 4-bits
	ADC_ADC_CFGR2_OVSS_B_0x4 = 0x4
	// Shift 5-bits
	ADC_ADC_CFGR2_OVSS_B_0x5 = 0x5
	// Shift 6-bits
	ADC_ADC_CFGR2_OVSS_B_0x6 = 0x6
	// Shift 7-bits
	ADC_ADC_CFGR2_OVSS_B_0x7 = 0x7
	// Shift 8-bits
	ADC_ADC_CFGR2_OVSS_B_0x8 = 0x8
	// Position of TOVS field.
	ADC_ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_ADC_CFGR2_TOVS = 0x200
	// All oversampled conversions for a channel are done consecutively after a trigger
	ADC_ADC_CFGR2_TOVS_B_0x0 = 0x0
	// Each oversampled conversion for a channel needs a trigger
	ADC_ADC_CFGR2_TOVS_B_0x1 = 0x1
	// Position of LFTRIG field.
	ADC_ADC_CFGR2_LFTRIG_Pos = 0x1d
	// Bit mask of LFTRIG field.
	ADC_ADC_CFGR2_LFTRIG_Msk = 0x20000000
	// Bit LFTRIG.
	ADC_ADC_CFGR2_LFTRIG = 0x20000000
	// Low Frequency Trigger Mode disabled
	ADC_ADC_CFGR2_LFTRIG_B_0x0 = 0x0
	// Low Frequency Trigger Mode enabled
	ADC_ADC_CFGR2_LFTRIG_B_0x1 = 0x1
	// Position of CKMODE field.
	ADC_ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_ADC_CFGR2_CKMODE_Msk = 0xc0000000
	// ADCCLK (Asynchronous clock mode), generated at product level (refer to RCC section)
	ADC_ADC_CFGR2_CKMODE_B_0x0 = 0x0
	// PCLK/2 (Synchronous clock mode)
	ADC_ADC_CFGR2_CKMODE_B_0x1 = 0x1
	// PCLK/4 (Synchronous clock mode)
	ADC_ADC_CFGR2_CKMODE_B_0x2 = 0x2
	// PCLK (Synchronous clock mode). This configuration must be enabled only if PCLK has a 50% duty clock cycle (APB prescaler configured inside the RCC must be bypassed and the system clock must by 50% duty cycle)
	ADC_ADC_CFGR2_CKMODE_B_0x3 = 0x3

	// ADC_SMPR: ADC sampling time register
	// Position of SMP1 field.
	ADC_ADC_SMPR_SMP1_Pos = 0x0
	// Bit mask of SMP1 field.
	ADC_ADC_SMPR_SMP1_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x0 = 0x0
	// 3.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x1 = 0x1
	// 7.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x2 = 0x2
	// 12.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x3 = 0x3
	// 19.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x4 = 0x4
	// 39.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x5 = 0x5
	// 79.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x6 = 0x6
	// 160.5 ADC clock cycles
	ADC_ADC_SMPR_SMP1_B_0x7 = 0x7
	// Position of SMP2 field.
	ADC_ADC_SMPR_SMP2_Pos = 0x4
	// Bit mask of SMP2 field.
	ADC_ADC_SMPR_SMP2_Msk = 0x70
	// 1.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x0 = 0x0
	// 3.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x1 = 0x1
	// 7.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x2 = 0x2
	// 12.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x3 = 0x3
	// 19.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x4 = 0x4
	// 39.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x5 = 0x5
	// 79.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x6 = 0x6
	// 160.5 ADC clock cycles
	ADC_ADC_SMPR_SMP2_B_0x7 = 0x7
	// Position of SMPSEL0 field.
	ADC_ADC_SMPR_SMPSEL0_Pos = 0x8
	// Bit mask of SMPSEL0 field.
	ADC_ADC_SMPR_SMPSEL0_Msk = 0x100
	// Bit SMPSEL0.
	ADC_ADC_SMPR_SMPSEL0 = 0x100
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL0_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL0_B_0x1 = 0x1
	// Position of SMPSEL1 field.
	ADC_ADC_SMPR_SMPSEL1_Pos = 0x9
	// Bit mask of SMPSEL1 field.
	ADC_ADC_SMPR_SMPSEL1_Msk = 0x200
	// Bit SMPSEL1.
	ADC_ADC_SMPR_SMPSEL1 = 0x200
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL1_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL1_B_0x1 = 0x1
	// Position of SMPSEL2 field.
	ADC_ADC_SMPR_SMPSEL2_Pos = 0xa
	// Bit mask of SMPSEL2 field.
	ADC_ADC_SMPR_SMPSEL2_Msk = 0x400
	// Bit SMPSEL2.
	ADC_ADC_SMPR_SMPSEL2 = 0x400
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL2_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL2_B_0x1 = 0x1
	// Position of SMPSEL3 field.
	ADC_ADC_SMPR_SMPSEL3_Pos = 0xb
	// Bit mask of SMPSEL3 field.
	ADC_ADC_SMPR_SMPSEL3_Msk = 0x800
	// Bit SMPSEL3.
	ADC_ADC_SMPR_SMPSEL3 = 0x800
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL3_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL3_B_0x1 = 0x1
	// Position of SMPSEL4 field.
	ADC_ADC_SMPR_SMPSEL4_Pos = 0xc
	// Bit mask of SMPSEL4 field.
	ADC_ADC_SMPR_SMPSEL4_Msk = 0x1000
	// Bit SMPSEL4.
	ADC_ADC_SMPR_SMPSEL4 = 0x1000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL4_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL4_B_0x1 = 0x1
	// Position of SMPSEL5 field.
	ADC_ADC_SMPR_SMPSEL5_Pos = 0xd
	// Bit mask of SMPSEL5 field.
	ADC_ADC_SMPR_SMPSEL5_Msk = 0x2000
	// Bit SMPSEL5.
	ADC_ADC_SMPR_SMPSEL5 = 0x2000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL5_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL5_B_0x1 = 0x1
	// Position of SMPSEL6 field.
	ADC_ADC_SMPR_SMPSEL6_Pos = 0xe
	// Bit mask of SMPSEL6 field.
	ADC_ADC_SMPR_SMPSEL6_Msk = 0x4000
	// Bit SMPSEL6.
	ADC_ADC_SMPR_SMPSEL6 = 0x4000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL6_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL6_B_0x1 = 0x1
	// Position of SMPSEL7 field.
	ADC_ADC_SMPR_SMPSEL7_Pos = 0xf
	// Bit mask of SMPSEL7 field.
	ADC_ADC_SMPR_SMPSEL7_Msk = 0x8000
	// Bit SMPSEL7.
	ADC_ADC_SMPR_SMPSEL7 = 0x8000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL7_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL7_B_0x1 = 0x1
	// Position of SMPSEL8 field.
	ADC_ADC_SMPR_SMPSEL8_Pos = 0x10
	// Bit mask of SMPSEL8 field.
	ADC_ADC_SMPR_SMPSEL8_Msk = 0x10000
	// Bit SMPSEL8.
	ADC_ADC_SMPR_SMPSEL8 = 0x10000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL8_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL8_B_0x1 = 0x1
	// Position of SMPSEL9 field.
	ADC_ADC_SMPR_SMPSEL9_Pos = 0x11
	// Bit mask of SMPSEL9 field.
	ADC_ADC_SMPR_SMPSEL9_Msk = 0x20000
	// Bit SMPSEL9.
	ADC_ADC_SMPR_SMPSEL9 = 0x20000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL9_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL9_B_0x1 = 0x1
	// Position of SMPSEL10 field.
	ADC_ADC_SMPR_SMPSEL10_Pos = 0x12
	// Bit mask of SMPSEL10 field.
	ADC_ADC_SMPR_SMPSEL10_Msk = 0x40000
	// Bit SMPSEL10.
	ADC_ADC_SMPR_SMPSEL10 = 0x40000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL10_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL10_B_0x1 = 0x1
	// Position of SMPSEL11 field.
	ADC_ADC_SMPR_SMPSEL11_Pos = 0x13
	// Bit mask of SMPSEL11 field.
	ADC_ADC_SMPR_SMPSEL11_Msk = 0x80000
	// Bit SMPSEL11.
	ADC_ADC_SMPR_SMPSEL11 = 0x80000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL11_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL11_B_0x1 = 0x1
	// Position of SMPSEL12 field.
	ADC_ADC_SMPR_SMPSEL12_Pos = 0x14
	// Bit mask of SMPSEL12 field.
	ADC_ADC_SMPR_SMPSEL12_Msk = 0x100000
	// Bit SMPSEL12.
	ADC_ADC_SMPR_SMPSEL12 = 0x100000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL12_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL12_B_0x1 = 0x1
	// Position of SMPSEL13 field.
	ADC_ADC_SMPR_SMPSEL13_Pos = 0x15
	// Bit mask of SMPSEL13 field.
	ADC_ADC_SMPR_SMPSEL13_Msk = 0x200000
	// Bit SMPSEL13.
	ADC_ADC_SMPR_SMPSEL13 = 0x200000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL13_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL13_B_0x1 = 0x1
	// Position of SMPSEL14 field.
	ADC_ADC_SMPR_SMPSEL14_Pos = 0x16
	// Bit mask of SMPSEL14 field.
	ADC_ADC_SMPR_SMPSEL14_Msk = 0x400000
	// Bit SMPSEL14.
	ADC_ADC_SMPR_SMPSEL14 = 0x400000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL14_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL14_B_0x1 = 0x1
	// Position of SMPSEL15 field.
	ADC_ADC_SMPR_SMPSEL15_Pos = 0x17
	// Bit mask of SMPSEL15 field.
	ADC_ADC_SMPR_SMPSEL15_Msk = 0x800000
	// Bit SMPSEL15.
	ADC_ADC_SMPR_SMPSEL15 = 0x800000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL15_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL15_B_0x1 = 0x1
	// Position of SMPSEL16 field.
	ADC_ADC_SMPR_SMPSEL16_Pos = 0x18
	// Bit mask of SMPSEL16 field.
	ADC_ADC_SMPR_SMPSEL16_Msk = 0x1000000
	// Bit SMPSEL16.
	ADC_ADC_SMPR_SMPSEL16 = 0x1000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL16_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL16_B_0x1 = 0x1
	// Position of SMPSEL17 field.
	ADC_ADC_SMPR_SMPSEL17_Pos = 0x19
	// Bit mask of SMPSEL17 field.
	ADC_ADC_SMPR_SMPSEL17_Msk = 0x2000000
	// Bit SMPSEL17.
	ADC_ADC_SMPR_SMPSEL17 = 0x2000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL17_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL17_B_0x1 = 0x1
	// Position of SMPSEL18 field.
	ADC_ADC_SMPR_SMPSEL18_Pos = 0x1a
	// Bit mask of SMPSEL18 field.
	ADC_ADC_SMPR_SMPSEL18_Msk = 0x4000000
	// Bit SMPSEL18.
	ADC_ADC_SMPR_SMPSEL18 = 0x4000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_ADC_SMPR_SMPSEL18_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_ADC_SMPR_SMPSEL18_B_0x1 = 0x1

	// ADC_AWD1TR: ADC watchdog threshold register
	// Position of LT1 field.
	ADC_ADC_AWD1TR_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_ADC_AWD1TR_LT1_Msk = 0xfff
	// Position of HT1 field.
	ADC_ADC_AWD1TR_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_ADC_AWD1TR_HT1_Msk = 0xfff0000

	// ADC_AWD2TR: ADC watchdog threshold register
	// Position of LT2 field.
	ADC_ADC_AWD2TR_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_ADC_AWD2TR_LT2_Msk = 0xfff
	// Position of HT2 field.
	ADC_ADC_AWD2TR_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_ADC_AWD2TR_HT2_Msk = 0xfff0000

	// ADC_CHSELRMOD0: ADC channel selection register
	// Position of CHSEL0 field.
	ADC_ADC_CHSELRMOD0_CHSEL0_Pos = 0x0
	// Bit mask of CHSEL0 field.
	ADC_ADC_CHSELRMOD0_CHSEL0_Msk = 0x1
	// Bit CHSEL0.
	ADC_ADC_CHSELRMOD0_CHSEL0 = 0x1
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL0_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL0_B_0x1 = 0x1
	// Position of CHSEL1 field.
	ADC_ADC_CHSELRMOD0_CHSEL1_Pos = 0x1
	// Bit mask of CHSEL1 field.
	ADC_ADC_CHSELRMOD0_CHSEL1_Msk = 0x2
	// Bit CHSEL1.
	ADC_ADC_CHSELRMOD0_CHSEL1 = 0x2
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL1_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL1_B_0x1 = 0x1
	// Position of CHSEL2 field.
	ADC_ADC_CHSELRMOD0_CHSEL2_Pos = 0x2
	// Bit mask of CHSEL2 field.
	ADC_ADC_CHSELRMOD0_CHSEL2_Msk = 0x4
	// Bit CHSEL2.
	ADC_ADC_CHSELRMOD0_CHSEL2 = 0x4
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL2_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL2_B_0x1 = 0x1
	// Position of CHSEL3 field.
	ADC_ADC_CHSELRMOD0_CHSEL3_Pos = 0x3
	// Bit mask of CHSEL3 field.
	ADC_ADC_CHSELRMOD0_CHSEL3_Msk = 0x8
	// Bit CHSEL3.
	ADC_ADC_CHSELRMOD0_CHSEL3 = 0x8
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL3_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL3_B_0x1 = 0x1
	// Position of CHSEL4 field.
	ADC_ADC_CHSELRMOD0_CHSEL4_Pos = 0x4
	// Bit mask of CHSEL4 field.
	ADC_ADC_CHSELRMOD0_CHSEL4_Msk = 0x10
	// Bit CHSEL4.
	ADC_ADC_CHSELRMOD0_CHSEL4 = 0x10
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL4_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL4_B_0x1 = 0x1
	// Position of CHSEL5 field.
	ADC_ADC_CHSELRMOD0_CHSEL5_Pos = 0x5
	// Bit mask of CHSEL5 field.
	ADC_ADC_CHSELRMOD0_CHSEL5_Msk = 0x20
	// Bit CHSEL5.
	ADC_ADC_CHSELRMOD0_CHSEL5 = 0x20
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL5_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL5_B_0x1 = 0x1
	// Position of CHSEL6 field.
	ADC_ADC_CHSELRMOD0_CHSEL6_Pos = 0x6
	// Bit mask of CHSEL6 field.
	ADC_ADC_CHSELRMOD0_CHSEL6_Msk = 0x40
	// Bit CHSEL6.
	ADC_ADC_CHSELRMOD0_CHSEL6 = 0x40
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL6_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL6_B_0x1 = 0x1
	// Position of CHSEL7 field.
	ADC_ADC_CHSELRMOD0_CHSEL7_Pos = 0x7
	// Bit mask of CHSEL7 field.
	ADC_ADC_CHSELRMOD0_CHSEL7_Msk = 0x80
	// Bit CHSEL7.
	ADC_ADC_CHSELRMOD0_CHSEL7 = 0x80
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL7_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL7_B_0x1 = 0x1
	// Position of CHSEL8 field.
	ADC_ADC_CHSELRMOD0_CHSEL8_Pos = 0x8
	// Bit mask of CHSEL8 field.
	ADC_ADC_CHSELRMOD0_CHSEL8_Msk = 0x100
	// Bit CHSEL8.
	ADC_ADC_CHSELRMOD0_CHSEL8 = 0x100
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL8_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL8_B_0x1 = 0x1
	// Position of CHSEL9 field.
	ADC_ADC_CHSELRMOD0_CHSEL9_Pos = 0x9
	// Bit mask of CHSEL9 field.
	ADC_ADC_CHSELRMOD0_CHSEL9_Msk = 0x200
	// Bit CHSEL9.
	ADC_ADC_CHSELRMOD0_CHSEL9 = 0x200
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL9_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL9_B_0x1 = 0x1
	// Position of CHSEL10 field.
	ADC_ADC_CHSELRMOD0_CHSEL10_Pos = 0xa
	// Bit mask of CHSEL10 field.
	ADC_ADC_CHSELRMOD0_CHSEL10_Msk = 0x400
	// Bit CHSEL10.
	ADC_ADC_CHSELRMOD0_CHSEL10 = 0x400
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL10_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL10_B_0x1 = 0x1
	// Position of CHSEL11 field.
	ADC_ADC_CHSELRMOD0_CHSEL11_Pos = 0xb
	// Bit mask of CHSEL11 field.
	ADC_ADC_CHSELRMOD0_CHSEL11_Msk = 0x800
	// Bit CHSEL11.
	ADC_ADC_CHSELRMOD0_CHSEL11 = 0x800
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL11_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL11_B_0x1 = 0x1
	// Position of CHSEL12 field.
	ADC_ADC_CHSELRMOD0_CHSEL12_Pos = 0xc
	// Bit mask of CHSEL12 field.
	ADC_ADC_CHSELRMOD0_CHSEL12_Msk = 0x1000
	// Bit CHSEL12.
	ADC_ADC_CHSELRMOD0_CHSEL12 = 0x1000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL12_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL12_B_0x1 = 0x1
	// Position of CHSEL13 field.
	ADC_ADC_CHSELRMOD0_CHSEL13_Pos = 0xd
	// Bit mask of CHSEL13 field.
	ADC_ADC_CHSELRMOD0_CHSEL13_Msk = 0x2000
	// Bit CHSEL13.
	ADC_ADC_CHSELRMOD0_CHSEL13 = 0x2000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL13_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL13_B_0x1 = 0x1
	// Position of CHSEL14 field.
	ADC_ADC_CHSELRMOD0_CHSEL14_Pos = 0xe
	// Bit mask of CHSEL14 field.
	ADC_ADC_CHSELRMOD0_CHSEL14_Msk = 0x4000
	// Bit CHSEL14.
	ADC_ADC_CHSELRMOD0_CHSEL14 = 0x4000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL14_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL14_B_0x1 = 0x1
	// Position of CHSEL15 field.
	ADC_ADC_CHSELRMOD0_CHSEL15_Pos = 0xf
	// Bit mask of CHSEL15 field.
	ADC_ADC_CHSELRMOD0_CHSEL15_Msk = 0x8000
	// Bit CHSEL15.
	ADC_ADC_CHSELRMOD0_CHSEL15 = 0x8000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL15_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL15_B_0x1 = 0x1
	// Position of CHSEL16 field.
	ADC_ADC_CHSELRMOD0_CHSEL16_Pos = 0x10
	// Bit mask of CHSEL16 field.
	ADC_ADC_CHSELRMOD0_CHSEL16_Msk = 0x10000
	// Bit CHSEL16.
	ADC_ADC_CHSELRMOD0_CHSEL16 = 0x10000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL16_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL16_B_0x1 = 0x1
	// Position of CHSEL17 field.
	ADC_ADC_CHSELRMOD0_CHSEL17_Pos = 0x11
	// Bit mask of CHSEL17 field.
	ADC_ADC_CHSELRMOD0_CHSEL17_Msk = 0x20000
	// Bit CHSEL17.
	ADC_ADC_CHSELRMOD0_CHSEL17 = 0x20000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL17_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL17_B_0x1 = 0x1
	// Position of CHSEL18 field.
	ADC_ADC_CHSELRMOD0_CHSEL18_Pos = 0x12
	// Bit mask of CHSEL18 field.
	ADC_ADC_CHSELRMOD0_CHSEL18_Msk = 0x40000
	// Bit CHSEL18.
	ADC_ADC_CHSELRMOD0_CHSEL18 = 0x40000
	// Input Channel-x is not selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL18_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_ADC_CHSELRMOD0_CHSEL18_B_0x1 = 0x1

	// ADC_CHSELRMOD1: ADC channel selection register
	// Position of SQ1 field.
	ADC_ADC_CHSELRMOD1_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_ADC_CHSELRMOD1_SQ1_Msk = 0xf
	// Position of SQ2 field.
	ADC_ADC_CHSELRMOD1_SQ2_Pos = 0x4
	// Bit mask of SQ2 field.
	ADC_ADC_CHSELRMOD1_SQ2_Msk = 0xf0
	// Position of SQ3 field.
	ADC_ADC_CHSELRMOD1_SQ3_Pos = 0x8
	// Bit mask of SQ3 field.
	ADC_ADC_CHSELRMOD1_SQ3_Msk = 0xf00
	// Position of SQ4 field.
	ADC_ADC_CHSELRMOD1_SQ4_Pos = 0xc
	// Bit mask of SQ4 field.
	ADC_ADC_CHSELRMOD1_SQ4_Msk = 0xf000
	// Position of SQ5 field.
	ADC_ADC_CHSELRMOD1_SQ5_Pos = 0x10
	// Bit mask of SQ5 field.
	ADC_ADC_CHSELRMOD1_SQ5_Msk = 0xf0000
	// Position of SQ6 field.
	ADC_ADC_CHSELRMOD1_SQ6_Pos = 0x14
	// Bit mask of SQ6 field.
	ADC_ADC_CHSELRMOD1_SQ6_Msk = 0xf00000
	// Position of SQ7 field.
	ADC_ADC_CHSELRMOD1_SQ7_Pos = 0x18
	// Bit mask of SQ7 field.
	ADC_ADC_CHSELRMOD1_SQ7_Msk = 0xf000000
	// Position of SQ8 field.
	ADC_ADC_CHSELRMOD1_SQ8_Pos = 0x1c
	// Bit mask of SQ8 field.
	ADC_ADC_CHSELRMOD1_SQ8_Msk = 0xf0000000
	// CH0
	ADC_ADC_CHSELRMOD1_SQ8_B_0x0 = 0x0
	// CH1
	ADC_ADC_CHSELRMOD1_SQ8_B_0x1 = 0x1
	// CH12
	ADC_ADC_CHSELRMOD1_SQ8_B_0xC = 0xc
	// CH13
	ADC_ADC_CHSELRMOD1_SQ8_B_0xD = 0xd
	// CH14
	ADC_ADC_CHSELRMOD1_SQ8_B_0xE = 0xe
	// No channel selected (End of sequence)
	ADC_ADC_CHSELRMOD1_SQ8_B_0xF = 0xf

	// ADC_AWD3TR: ADC watchdog threshold register
	// Position of LT3 field.
	ADC_ADC_AWD3TR_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_ADC_AWD3TR_LT3_Msk = 0xfff
	// Position of HT3 field.
	ADC_ADC_AWD3TR_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_ADC_AWD3TR_HT3_Msk = 0xfff0000

	// ADC_DR: ADC data register
	// Position of DATA field.
	ADC_ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_ADC_DR_DATA_Msk = 0xffff

	// ADC_AWD2CR: ADC Analog Watchdog 2 Configuration register
	// Position of AWD2CH0 field.
	ADC_ADC_AWD2CR_AWD2CH0_Pos = 0x0
	// Bit mask of AWD2CH0 field.
	ADC_ADC_AWD2CR_AWD2CH0_Msk = 0x1
	// Bit AWD2CH0.
	ADC_ADC_AWD2CR_AWD2CH0 = 0x1
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH0_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH0_B_0x1 = 0x1
	// Position of AWD2CH1 field.
	ADC_ADC_AWD2CR_AWD2CH1_Pos = 0x1
	// Bit mask of AWD2CH1 field.
	ADC_ADC_AWD2CR_AWD2CH1_Msk = 0x2
	// Bit AWD2CH1.
	ADC_ADC_AWD2CR_AWD2CH1 = 0x2
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH1_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH1_B_0x1 = 0x1
	// Position of AWD2CH2 field.
	ADC_ADC_AWD2CR_AWD2CH2_Pos = 0x2
	// Bit mask of AWD2CH2 field.
	ADC_ADC_AWD2CR_AWD2CH2_Msk = 0x4
	// Bit AWD2CH2.
	ADC_ADC_AWD2CR_AWD2CH2 = 0x4
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH2_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH2_B_0x1 = 0x1
	// Position of AWD2CH3 field.
	ADC_ADC_AWD2CR_AWD2CH3_Pos = 0x3
	// Bit mask of AWD2CH3 field.
	ADC_ADC_AWD2CR_AWD2CH3_Msk = 0x8
	// Bit AWD2CH3.
	ADC_ADC_AWD2CR_AWD2CH3 = 0x8
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH3_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH3_B_0x1 = 0x1
	// Position of AWD2CH4 field.
	ADC_ADC_AWD2CR_AWD2CH4_Pos = 0x4
	// Bit mask of AWD2CH4 field.
	ADC_ADC_AWD2CR_AWD2CH4_Msk = 0x10
	// Bit AWD2CH4.
	ADC_ADC_AWD2CR_AWD2CH4 = 0x10
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH4_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH4_B_0x1 = 0x1
	// Position of AWD2CH5 field.
	ADC_ADC_AWD2CR_AWD2CH5_Pos = 0x5
	// Bit mask of AWD2CH5 field.
	ADC_ADC_AWD2CR_AWD2CH5_Msk = 0x20
	// Bit AWD2CH5.
	ADC_ADC_AWD2CR_AWD2CH5 = 0x20
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH5_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH5_B_0x1 = 0x1
	// Position of AWD2CH6 field.
	ADC_ADC_AWD2CR_AWD2CH6_Pos = 0x6
	// Bit mask of AWD2CH6 field.
	ADC_ADC_AWD2CR_AWD2CH6_Msk = 0x40
	// Bit AWD2CH6.
	ADC_ADC_AWD2CR_AWD2CH6 = 0x40
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH6_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH6_B_0x1 = 0x1
	// Position of AWD2CH7 field.
	ADC_ADC_AWD2CR_AWD2CH7_Pos = 0x7
	// Bit mask of AWD2CH7 field.
	ADC_ADC_AWD2CR_AWD2CH7_Msk = 0x80
	// Bit AWD2CH7.
	ADC_ADC_AWD2CR_AWD2CH7 = 0x80
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH7_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH7_B_0x1 = 0x1
	// Position of AWD2CH8 field.
	ADC_ADC_AWD2CR_AWD2CH8_Pos = 0x8
	// Bit mask of AWD2CH8 field.
	ADC_ADC_AWD2CR_AWD2CH8_Msk = 0x100
	// Bit AWD2CH8.
	ADC_ADC_AWD2CR_AWD2CH8 = 0x100
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH8_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH8_B_0x1 = 0x1
	// Position of AWD2CH9 field.
	ADC_ADC_AWD2CR_AWD2CH9_Pos = 0x9
	// Bit mask of AWD2CH9 field.
	ADC_ADC_AWD2CR_AWD2CH9_Msk = 0x200
	// Bit AWD2CH9.
	ADC_ADC_AWD2CR_AWD2CH9 = 0x200
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH9_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH9_B_0x1 = 0x1
	// Position of AWD2CH10 field.
	ADC_ADC_AWD2CR_AWD2CH10_Pos = 0xa
	// Bit mask of AWD2CH10 field.
	ADC_ADC_AWD2CR_AWD2CH10_Msk = 0x400
	// Bit AWD2CH10.
	ADC_ADC_AWD2CR_AWD2CH10 = 0x400
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH10_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH10_B_0x1 = 0x1
	// Position of AWD2CH11 field.
	ADC_ADC_AWD2CR_AWD2CH11_Pos = 0xb
	// Bit mask of AWD2CH11 field.
	ADC_ADC_AWD2CR_AWD2CH11_Msk = 0x800
	// Bit AWD2CH11.
	ADC_ADC_AWD2CR_AWD2CH11 = 0x800
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH11_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH11_B_0x1 = 0x1
	// Position of AWD2CH12 field.
	ADC_ADC_AWD2CR_AWD2CH12_Pos = 0xc
	// Bit mask of AWD2CH12 field.
	ADC_ADC_AWD2CR_AWD2CH12_Msk = 0x1000
	// Bit AWD2CH12.
	ADC_ADC_AWD2CR_AWD2CH12 = 0x1000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH12_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH12_B_0x1 = 0x1
	// Position of AWD2CH13 field.
	ADC_ADC_AWD2CR_AWD2CH13_Pos = 0xd
	// Bit mask of AWD2CH13 field.
	ADC_ADC_AWD2CR_AWD2CH13_Msk = 0x2000
	// Bit AWD2CH13.
	ADC_ADC_AWD2CR_AWD2CH13 = 0x2000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH13_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH13_B_0x1 = 0x1
	// Position of AWD2CH14 field.
	ADC_ADC_AWD2CR_AWD2CH14_Pos = 0xe
	// Bit mask of AWD2CH14 field.
	ADC_ADC_AWD2CR_AWD2CH14_Msk = 0x4000
	// Bit AWD2CH14.
	ADC_ADC_AWD2CR_AWD2CH14 = 0x4000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH14_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH14_B_0x1 = 0x1
	// Position of AWD2CH15 field.
	ADC_ADC_AWD2CR_AWD2CH15_Pos = 0xf
	// Bit mask of AWD2CH15 field.
	ADC_ADC_AWD2CR_AWD2CH15_Msk = 0x8000
	// Bit AWD2CH15.
	ADC_ADC_AWD2CR_AWD2CH15 = 0x8000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH15_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH15_B_0x1 = 0x1
	// Position of AWD2CH16 field.
	ADC_ADC_AWD2CR_AWD2CH16_Pos = 0x10
	// Bit mask of AWD2CH16 field.
	ADC_ADC_AWD2CR_AWD2CH16_Msk = 0x10000
	// Bit AWD2CH16.
	ADC_ADC_AWD2CR_AWD2CH16 = 0x10000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH16_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH16_B_0x1 = 0x1
	// Position of AWD2CH17 field.
	ADC_ADC_AWD2CR_AWD2CH17_Pos = 0x11
	// Bit mask of AWD2CH17 field.
	ADC_ADC_AWD2CR_AWD2CH17_Msk = 0x20000
	// Bit AWD2CH17.
	ADC_ADC_AWD2CR_AWD2CH17 = 0x20000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH17_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH17_B_0x1 = 0x1
	// Position of AWD2CH18 field.
	ADC_ADC_AWD2CR_AWD2CH18_Pos = 0x12
	// Bit mask of AWD2CH18 field.
	ADC_ADC_AWD2CR_AWD2CH18_Msk = 0x40000
	// Bit AWD2CH18.
	ADC_ADC_AWD2CR_AWD2CH18 = 0x40000
	// ADC analog channel-x is not monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH18_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_ADC_AWD2CR_AWD2CH18_B_0x1 = 0x1

	// ADC_AWD3CR: ADC Analog Watchdog 3 Configuration register
	// Position of AWD3CH0 field.
	ADC_ADC_AWD3CR_AWD3CH0_Pos = 0x0
	// Bit mask of AWD3CH0 field.
	ADC_ADC_AWD3CR_AWD3CH0_Msk = 0x1
	// Bit AWD3CH0.
	ADC_ADC_AWD3CR_AWD3CH0 = 0x1
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH0_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH0_B_0x1 = 0x1
	// Position of AWD3CH1 field.
	ADC_ADC_AWD3CR_AWD3CH1_Pos = 0x1
	// Bit mask of AWD3CH1 field.
	ADC_ADC_AWD3CR_AWD3CH1_Msk = 0x2
	// Bit AWD3CH1.
	ADC_ADC_AWD3CR_AWD3CH1 = 0x2
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH1_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH1_B_0x1 = 0x1
	// Position of AWD3CH2 field.
	ADC_ADC_AWD3CR_AWD3CH2_Pos = 0x2
	// Bit mask of AWD3CH2 field.
	ADC_ADC_AWD3CR_AWD3CH2_Msk = 0x4
	// Bit AWD3CH2.
	ADC_ADC_AWD3CR_AWD3CH2 = 0x4
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH2_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH2_B_0x1 = 0x1
	// Position of AWD3CH3 field.
	ADC_ADC_AWD3CR_AWD3CH3_Pos = 0x3
	// Bit mask of AWD3CH3 field.
	ADC_ADC_AWD3CR_AWD3CH3_Msk = 0x8
	// Bit AWD3CH3.
	ADC_ADC_AWD3CR_AWD3CH3 = 0x8
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH3_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH3_B_0x1 = 0x1
	// Position of AWD3CH4 field.
	ADC_ADC_AWD3CR_AWD3CH4_Pos = 0x4
	// Bit mask of AWD3CH4 field.
	ADC_ADC_AWD3CR_AWD3CH4_Msk = 0x10
	// Bit AWD3CH4.
	ADC_ADC_AWD3CR_AWD3CH4 = 0x10
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH4_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH4_B_0x1 = 0x1
	// Position of AWD3CH5 field.
	ADC_ADC_AWD3CR_AWD3CH5_Pos = 0x5
	// Bit mask of AWD3CH5 field.
	ADC_ADC_AWD3CR_AWD3CH5_Msk = 0x20
	// Bit AWD3CH5.
	ADC_ADC_AWD3CR_AWD3CH5 = 0x20
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH5_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH5_B_0x1 = 0x1
	// Position of AWD3CH6 field.
	ADC_ADC_AWD3CR_AWD3CH6_Pos = 0x6
	// Bit mask of AWD3CH6 field.
	ADC_ADC_AWD3CR_AWD3CH6_Msk = 0x40
	// Bit AWD3CH6.
	ADC_ADC_AWD3CR_AWD3CH6 = 0x40
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH6_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH6_B_0x1 = 0x1
	// Position of AWD3CH7 field.
	ADC_ADC_AWD3CR_AWD3CH7_Pos = 0x7
	// Bit mask of AWD3CH7 field.
	ADC_ADC_AWD3CR_AWD3CH7_Msk = 0x80
	// Bit AWD3CH7.
	ADC_ADC_AWD3CR_AWD3CH7 = 0x80
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH7_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH7_B_0x1 = 0x1
	// Position of AWD3CH8 field.
	ADC_ADC_AWD3CR_AWD3CH8_Pos = 0x8
	// Bit mask of AWD3CH8 field.
	ADC_ADC_AWD3CR_AWD3CH8_Msk = 0x100
	// Bit AWD3CH8.
	ADC_ADC_AWD3CR_AWD3CH8 = 0x100
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH8_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH8_B_0x1 = 0x1
	// Position of AWD3CH9 field.
	ADC_ADC_AWD3CR_AWD3CH9_Pos = 0x9
	// Bit mask of AWD3CH9 field.
	ADC_ADC_AWD3CR_AWD3CH9_Msk = 0x200
	// Bit AWD3CH9.
	ADC_ADC_AWD3CR_AWD3CH9 = 0x200
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH9_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH9_B_0x1 = 0x1
	// Position of AWD3CH10 field.
	ADC_ADC_AWD3CR_AWD3CH10_Pos = 0xa
	// Bit mask of AWD3CH10 field.
	ADC_ADC_AWD3CR_AWD3CH10_Msk = 0x400
	// Bit AWD3CH10.
	ADC_ADC_AWD3CR_AWD3CH10 = 0x400
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH10_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH10_B_0x1 = 0x1
	// Position of AWD3CH11 field.
	ADC_ADC_AWD3CR_AWD3CH11_Pos = 0xb
	// Bit mask of AWD3CH11 field.
	ADC_ADC_AWD3CR_AWD3CH11_Msk = 0x800
	// Bit AWD3CH11.
	ADC_ADC_AWD3CR_AWD3CH11 = 0x800
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH11_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH11_B_0x1 = 0x1
	// Position of AWD3CH12 field.
	ADC_ADC_AWD3CR_AWD3CH12_Pos = 0xc
	// Bit mask of AWD3CH12 field.
	ADC_ADC_AWD3CR_AWD3CH12_Msk = 0x1000
	// Bit AWD3CH12.
	ADC_ADC_AWD3CR_AWD3CH12 = 0x1000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH12_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH12_B_0x1 = 0x1
	// Position of AWD3CH13 field.
	ADC_ADC_AWD3CR_AWD3CH13_Pos = 0xd
	// Bit mask of AWD3CH13 field.
	ADC_ADC_AWD3CR_AWD3CH13_Msk = 0x2000
	// Bit AWD3CH13.
	ADC_ADC_AWD3CR_AWD3CH13 = 0x2000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH13_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH13_B_0x1 = 0x1
	// Position of AWD3CH14 field.
	ADC_ADC_AWD3CR_AWD3CH14_Pos = 0xe
	// Bit mask of AWD3CH14 field.
	ADC_ADC_AWD3CR_AWD3CH14_Msk = 0x4000
	// Bit AWD3CH14.
	ADC_ADC_AWD3CR_AWD3CH14 = 0x4000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH14_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH14_B_0x1 = 0x1
	// Position of AWD3CH15 field.
	ADC_ADC_AWD3CR_AWD3CH15_Pos = 0xf
	// Bit mask of AWD3CH15 field.
	ADC_ADC_AWD3CR_AWD3CH15_Msk = 0x8000
	// Bit AWD3CH15.
	ADC_ADC_AWD3CR_AWD3CH15 = 0x8000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH15_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH15_B_0x1 = 0x1
	// Position of AWD3CH16 field.
	ADC_ADC_AWD3CR_AWD3CH16_Pos = 0x10
	// Bit mask of AWD3CH16 field.
	ADC_ADC_AWD3CR_AWD3CH16_Msk = 0x10000
	// Bit AWD3CH16.
	ADC_ADC_AWD3CR_AWD3CH16 = 0x10000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH16_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH16_B_0x1 = 0x1
	// Position of AWD3CH17 field.
	ADC_ADC_AWD3CR_AWD3CH17_Pos = 0x11
	// Bit mask of AWD3CH17 field.
	ADC_ADC_AWD3CR_AWD3CH17_Msk = 0x20000
	// Bit AWD3CH17.
	ADC_ADC_AWD3CR_AWD3CH17 = 0x20000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH17_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH17_B_0x1 = 0x1
	// Position of AWD3CH18 field.
	ADC_ADC_AWD3CR_AWD3CH18_Pos = 0x12
	// Bit mask of AWD3CH18 field.
	ADC_ADC_AWD3CR_AWD3CH18_Msk = 0x40000
	// Bit AWD3CH18.
	ADC_ADC_AWD3CR_AWD3CH18 = 0x40000
	// ADC analog channel-x is not monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH18_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_ADC_AWD3CR_AWD3CH18_B_0x1 = 0x1

	// ADC_CALFACT: ADC Calibration factor
	// Position of CALFACT field.
	ADC_ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_ADC_CALFACT_CALFACT_Msk = 0x7f

	// ADC_CCR: ADC common configuration register
	// Position of PRESC field.
	ADC_ADC_CCR_PRESC_Pos = 0x12
	// Bit mask of PRESC field.
	ADC_ADC_CCR_PRESC_Msk = 0x3c0000
	// input ADC clock not divided
	ADC_ADC_CCR_PRESC_B_0x0 = 0x0
	// input ADC clock divided by 2
	ADC_ADC_CCR_PRESC_B_0x1 = 0x1
	// input ADC clock divided by 4
	ADC_ADC_CCR_PRESC_B_0x2 = 0x2
	// input ADC clock divided by 6
	ADC_ADC_CCR_PRESC_B_0x3 = 0x3
	// input ADC clock divided by 8
	ADC_ADC_CCR_PRESC_B_0x4 = 0x4
	// input ADC clock divided by 10
	ADC_ADC_CCR_PRESC_B_0x5 = 0x5
	// input ADC clock divided by 12
	ADC_ADC_CCR_PRESC_B_0x6 = 0x6
	// input ADC clock divided by 16
	ADC_ADC_CCR_PRESC_B_0x7 = 0x7
	// input ADC clock divided by 32
	ADC_ADC_CCR_PRESC_B_0x8 = 0x8
	// input ADC clock divided by 64
	ADC_ADC_CCR_PRESC_B_0x9 = 0x9
	// input ADC clock divided by 128
	ADC_ADC_CCR_PRESC_B_0xA = 0xa
	// input ADC clock divided by 256
	ADC_ADC_CCR_PRESC_B_0xB = 0xb
	// Position of VREFEN field.
	ADC_ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_ADC_CCR_VREFEN = 0x400000
	// VREFINT disabled
	ADC_ADC_CCR_VREFEN_B_0x0 = 0x0
	// VREFINT enabled
	ADC_ADC_CCR_VREFEN_B_0x1 = 0x1
	// Position of TSEN field.
	ADC_ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_ADC_CCR_TSEN = 0x800000
	// Temperature sensor disabled, DAC_OUT1 connected to ADC channel 12
	ADC_ADC_CCR_TSEN_B_0x0 = 0x0
	// Temperature sensor enabled
	ADC_ADC_CCR_TSEN_B_0x1 = 0x1
	// Position of VBATEN field.
	ADC_ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_ADC_CCR_VBATEN = 0x1000000
	// VBAT channel disabled, DAC_OUT2 connected to ADC channel 14
	ADC_ADC_CCR_VBATEN_B_0x0 = 0x0
	// VBAT channel enabled
	ADC_ADC_CCR_VBATEN_B_0x1 = 0x1
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// CRC_DR: Data register
	// Position of DR field.
	CRC_CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_CRC_DR_DR_Msk = 0xffffffff

	// CRC_IDR: Independent data register
	// Position of IDR field.
	CRC_CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_CRC_IDR_IDR_Msk = 0xffffffff

	// CRC_CR: Control register
	// Position of REV_OUT field.
	CRC_CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CRC_CR_REV_OUT_B_0x0 = 0x0
	// Bit-reversed output format
	CRC_CRC_CR_REV_OUT_B_0x1 = 0x1
	// Position of REV_IN field.
	CRC_CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CRC_CR_REV_IN_B_0x0 = 0x0
	// Bit reversal done by byte
	CRC_CRC_CR_REV_IN_B_0x1 = 0x1
	// Bit reversal done by half-word
	CRC_CRC_CR_REV_IN_B_0x2 = 0x2
	// Bit reversal done by word
	CRC_CRC_CR_REV_IN_B_0x3 = 0x3
	// Position of POLYSIZE field.
	CRC_CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CRC_CR_POLYSIZE_Msk = 0x18
	// 32 bit polynomial
	CRC_CRC_CR_POLYSIZE_B_0x0 = 0x0
	// 16 bit polynomial
	CRC_CRC_CR_POLYSIZE_B_0x1 = 0x1
	// 8 bit polynomial
	CRC_CRC_CR_POLYSIZE_B_0x2 = 0x2
	// 7 bit polynomial
	CRC_CRC_CR_POLYSIZE_B_0x3 = 0x3
	// Position of RESET field.
	CRC_CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CRC_CR_RESET = 0x1

	// CRC_INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// CRC_POL: polynomial
	// Position of POL field.
	CRC_CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for DAC: DAC
const (
	// DAC_CR: DAC control register
	// Position of EN1 field.
	DAC_DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_DAC_CR_EN1 = 0x1
	// DAC channel1 disabled
	DAC_DAC_CR_EN1_B_0x0 = 0x0
	// DAC channel1 enabled
	DAC_DAC_CR_EN1_B_0x1 = 0x1
	// Position of TEN1 field.
	DAC_DAC_CR_TEN1_Pos = 0x1
	// Bit mask of TEN1 field.
	DAC_DAC_CR_TEN1_Msk = 0x2
	// Bit TEN1.
	DAC_DAC_CR_TEN1 = 0x2
	// DAC channel1 trigger disabled and data written into the DAC_DHR1 register are transferred one dac_pclk clock cycle later to the DAC_DOR1 register
	DAC_DAC_CR_TEN1_B_0x0 = 0x0
	// DAC channel1 trigger enabled and data from the DAC_DHR1 register are transferred three dac_pclk clock cycles later to the DAC_DOR1 register
	DAC_DAC_CR_TEN1_B_0x1 = 0x1
	// Position of TSEL1 field.
	DAC_DAC_CR_TSEL1_Pos = 0x2
	// Bit mask of TSEL1 field.
	DAC_DAC_CR_TSEL1_Msk = 0x3c
	// SWTRIG1
	DAC_DAC_CR_TSEL1_B_0x0 = 0x0
	// dac_ch1_trg1
	DAC_DAC_CR_TSEL1_B_0x1 = 0x1
	// dac_ch1_trg2
	DAC_DAC_CR_TSEL1_B_0x2 = 0x2
	// dac_ch1_trg15
	DAC_DAC_CR_TSEL1_B_0xF = 0xf
	// Position of WAVE1 field.
	DAC_DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_DAC_CR_WAVE1_Msk = 0xc0
	// wave generation disabled
	DAC_DAC_CR_WAVE1_B_0x0 = 0x0
	// Noise wave generation enabled
	DAC_DAC_CR_WAVE1_B_0x1 = 0x1
	// Position of MAMP1 field.
	DAC_DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_DAC_CR_MAMP1_Msk = 0xf00
	// Unmask bit0 of LFSR/ triangle amplitude equal to 1
	DAC_DAC_CR_MAMP1_B_0x0 = 0x0
	// Unmask bits[1:0] of LFSR/ triangle amplitude equal to 3
	DAC_DAC_CR_MAMP1_B_0x1 = 0x1
	// Unmask bits[2:0] of LFSR/ triangle amplitude equal to 7
	DAC_DAC_CR_MAMP1_B_0x2 = 0x2
	// Unmask bits[3:0] of LFSR/ triangle amplitude equal to 15
	DAC_DAC_CR_MAMP1_B_0x3 = 0x3
	// Unmask bits[4:0] of LFSR/ triangle amplitude equal to 31
	DAC_DAC_CR_MAMP1_B_0x4 = 0x4
	// Unmask bits[5:0] of LFSR/ triangle amplitude equal to 63
	DAC_DAC_CR_MAMP1_B_0x5 = 0x5
	// Unmask bits[6:0] of LFSR/ triangle amplitude equal to 127
	DAC_DAC_CR_MAMP1_B_0x6 = 0x6
	// Unmask bits[7:0] of LFSR/ triangle amplitude equal to 255
	DAC_DAC_CR_MAMP1_B_0x7 = 0x7
	// Unmask bits[8:0] of LFSR/ triangle amplitude equal to 511
	DAC_DAC_CR_MAMP1_B_0x8 = 0x8
	// Unmask bits[9:0] of LFSR/ triangle amplitude equal to 1023
	DAC_DAC_CR_MAMP1_B_0x9 = 0x9
	// Unmask bits[10:0] of LFSR/ triangle amplitude equal to 2047
	DAC_DAC_CR_MAMP1_B_0xA = 0xa
	// Position of DMAEN1 field.
	DAC_DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_DAC_CR_DMAEN1 = 0x1000
	// DAC channel1 DMA mode disabled
	DAC_DAC_CR_DMAEN1_B_0x0 = 0x0
	// DAC channel1 DMA mode enabled
	DAC_DAC_CR_DMAEN1_B_0x1 = 0x1
	// Position of DMAUDRIE1 field.
	DAC_DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel1 DMA Underrun Interrupt disabled
	DAC_DAC_CR_DMAUDRIE1_B_0x0 = 0x0
	// DAC channel1 DMA Underrun Interrupt enabled
	DAC_DAC_CR_DMAUDRIE1_B_0x1 = 0x1
	// Position of CEN1 field.
	DAC_DAC_CR_CEN1_Pos = 0xe
	// Bit mask of CEN1 field.
	DAC_DAC_CR_CEN1_Msk = 0x4000
	// Bit CEN1.
	DAC_DAC_CR_CEN1 = 0x4000
	// DAC channel1 in Normal operating mode
	DAC_DAC_CR_CEN1_B_0x0 = 0x0
	// DAC channel1 in calibration mode
	DAC_DAC_CR_CEN1_B_0x1 = 0x1
	// Position of EN2 field.
	DAC_DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_DAC_CR_EN2 = 0x10000
	// DAC channel2 disabled
	DAC_DAC_CR_EN2_B_0x0 = 0x0
	// DAC channel2 enabled
	DAC_DAC_CR_EN2_B_0x1 = 0x1
	// Position of TEN2 field.
	DAC_DAC_CR_TEN2_Pos = 0x11
	// Bit mask of TEN2 field.
	DAC_DAC_CR_TEN2_Msk = 0x20000
	// Bit TEN2.
	DAC_DAC_CR_TEN2 = 0x20000
	// DAC channel2 trigger disabled and data written into the DAC_DHR2 register are transferred one dac_pclk clock cycle later to the DAC_DOR2 register
	DAC_DAC_CR_TEN2_B_0x0 = 0x0
	// DAC channel2 trigger enabled and data from the DAC_DHR2 register are transferred three dac_pclk clock cycles later to the DAC_DOR2 register
	DAC_DAC_CR_TEN2_B_0x1 = 0x1
	// Position of TSEL2 field.
	DAC_DAC_CR_TSEL2_Pos = 0x12
	// Bit mask of TSEL2 field.
	DAC_DAC_CR_TSEL2_Msk = 0x3c0000
	// SWTRIG2
	DAC_DAC_CR_TSEL2_B_0x0 = 0x0
	// dac_ch2_trg1
	DAC_DAC_CR_TSEL2_B_0x1 = 0x1
	// dac_ch2_trg2
	DAC_DAC_CR_TSEL2_B_0x2 = 0x2
	// dac_ch2_trg15
	DAC_DAC_CR_TSEL2_B_0xF = 0xf
	// Position of WAVE2 field.
	DAC_DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_DAC_CR_WAVE2_Msk = 0xc00000
	// wave generation disabled
	DAC_DAC_CR_WAVE2_B_0x0 = 0x0
	// Noise wave generation enabled
	DAC_DAC_CR_WAVE2_B_0x1 = 0x1
	// Position of MAMP2 field.
	DAC_DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_DAC_CR_MAMP2_Msk = 0xf000000
	// Unmask bit0 of LFSR/ triangle amplitude equal to 1
	DAC_DAC_CR_MAMP2_B_0x0 = 0x0
	// Unmask bits[1:0] of LFSR/ triangle amplitude equal to 3
	DAC_DAC_CR_MAMP2_B_0x1 = 0x1
	// Unmask bits[2:0] of LFSR/ triangle amplitude equal to 7
	DAC_DAC_CR_MAMP2_B_0x2 = 0x2
	// Unmask bits[3:0] of LFSR/ triangle amplitude equal to 15
	DAC_DAC_CR_MAMP2_B_0x3 = 0x3
	// Unmask bits[4:0] of LFSR/ triangle amplitude equal to 31
	DAC_DAC_CR_MAMP2_B_0x4 = 0x4
	// Unmask bits[5:0] of LFSR/ triangle amplitude equal to 63
	DAC_DAC_CR_MAMP2_B_0x5 = 0x5
	// Unmask bits[6:0] of LFSR/ triangle amplitude equal to 127
	DAC_DAC_CR_MAMP2_B_0x6 = 0x6
	// Unmask bits[7:0] of LFSR/ triangle amplitude equal to 255
	DAC_DAC_CR_MAMP2_B_0x7 = 0x7
	// Unmask bits[8:0] of LFSR/ triangle amplitude equal to 511
	DAC_DAC_CR_MAMP2_B_0x8 = 0x8
	// Unmask bits[9:0] of LFSR/ triangle amplitude equal to 1023
	DAC_DAC_CR_MAMP2_B_0x9 = 0x9
	// Unmask bits[10:0] of LFSR/ triangle amplitude equal to 2047
	DAC_DAC_CR_MAMP2_B_0xA = 0xa
	// Position of DMAEN2 field.
	DAC_DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_DAC_CR_DMAEN2 = 0x10000000
	// DAC channel2 DMA mode disabled
	DAC_DAC_CR_DMAEN2_B_0x0 = 0x0
	// DAC channel2 DMA mode enabled
	DAC_DAC_CR_DMAEN2_B_0x1 = 0x1
	// Position of DMAUDRIE2 field.
	DAC_DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel2 DMA underrun interrupt disabled
	DAC_DAC_CR_DMAUDRIE2_B_0x0 = 0x0
	// DAC channel2 DMA underrun interrupt enabled
	DAC_DAC_CR_DMAUDRIE2_B_0x1 = 0x1
	// Position of CEN2 field.
	DAC_DAC_CR_CEN2_Pos = 0x1e
	// Bit mask of CEN2 field.
	DAC_DAC_CR_CEN2_Msk = 0x40000000
	// Bit CEN2.
	DAC_DAC_CR_CEN2 = 0x40000000
	// DAC channel2 in Normal operating mode
	DAC_DAC_CR_CEN2_B_0x0 = 0x0
	// DAC channel2 in calibration mode
	DAC_DAC_CR_CEN2_B_0x1 = 0x1

	// DAC_SWTRGR: DAC software trigger register
	// Position of SWTRIG1 field.
	DAC_DAC_SWTRGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_DAC_SWTRGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_DAC_SWTRGR_SWTRIG1 = 0x1
	// No trigger
	DAC_DAC_SWTRGR_SWTRIG1_B_0x0 = 0x0
	// Trigger
	DAC_DAC_SWTRGR_SWTRIG1_B_0x1 = 0x1
	// Position of SWTRIG2 field.
	DAC_DAC_SWTRGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_DAC_SWTRGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_DAC_SWTRGR_SWTRIG2 = 0x2
	// No trigger
	DAC_DAC_SWTRGR_SWTRIG2_B_0x0 = 0x0
	// Trigger
	DAC_DAC_SWTRGR_SWTRIG2_B_0x1 = 0x1

	// DAC_DHR12R1: DAC channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DAC_DHR12L1: DAC channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DAC_DHR8R1: DAC channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DAC_DHR12R2: DAC channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DAC_DHR12L2: DAC channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DAC_DHR8R2: DAC channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DAC_DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR12RD_DACC1DHR_Msk = 0xfff
	// Position of DACC2DHR field.
	DAC_DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000

	// DAC_DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR12LD_DACC1DHR_Msk = 0xfff0
	// Position of DACC2DHR field.
	DAC_DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000

	// DAC_DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DAC_DHR8RD_DACC1DHR_Msk = 0xff
	// Position of DACC2DHR field.
	DAC_DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DAC_DHR8RD_DACC2DHR_Msk = 0xff00

	// DAC_DOR1: DAC channel1 data output register
	// Position of DACC1DOR field.
	DAC_DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DAC_DOR2: DAC channel2 data output register
	// Position of DACC2DOR field.
	DAC_DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DAC_DOR2_DACC2DOR_Msk = 0xfff

	// DAC_SR: DAC status register
	// Position of DMAUDR1 field.
	DAC_DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel1
	DAC_DAC_SR_DMAUDR1_B_0x0 = 0x0
	// DMA underrun error condition occurred for DAC channel1 (the currently selected trigger is driving DAC channel1 conversion at a frequency higher than the DMA service capability rate)
	DAC_DAC_SR_DMAUDR1_B_0x1 = 0x1
	// Position of CAL_FLAG1 field.
	DAC_DAC_SR_CAL_FLAG1_Pos = 0xe
	// Bit mask of CAL_FLAG1 field.
	DAC_DAC_SR_CAL_FLAG1_Msk = 0x4000
	// Bit CAL_FLAG1.
	DAC_DAC_SR_CAL_FLAG1 = 0x4000
	// calibration trimming value is lower than the offset correction value
	DAC_DAC_SR_CAL_FLAG1_B_0x0 = 0x0
	// calibration trimming value is equal or greater than the offset correction value
	DAC_DAC_SR_CAL_FLAG1_B_0x1 = 0x1
	// Position of BWST1 field.
	DAC_DAC_SR_BWST1_Pos = 0xf
	// Bit mask of BWST1 field.
	DAC_DAC_SR_BWST1_Msk = 0x8000
	// Bit BWST1.
	DAC_DAC_SR_BWST1 = 0x8000
	// There is no write operation of DAC_SHSR1 ongoing: DAC_SHSR1 can be written
	DAC_DAC_SR_BWST1_B_0x0 = 0x0
	// There is a write operation of DAC_SHSR1 ongoing: DAC_SHSR1 cannot be written
	DAC_DAC_SR_BWST1_B_0x1 = 0x1
	// Position of DMAUDR2 field.
	DAC_DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel2
	DAC_DAC_SR_DMAUDR2_B_0x0 = 0x0
	// DMA underrun error condition occurred for DAC channel2 (the currently selected trigger is driving DAC channel2 conversion at a frequency higher than the DMA service capability rate).
	DAC_DAC_SR_DMAUDR2_B_0x1 = 0x1
	// Position of CAL_FLAG2 field.
	DAC_DAC_SR_CAL_FLAG2_Pos = 0x1e
	// Bit mask of CAL_FLAG2 field.
	DAC_DAC_SR_CAL_FLAG2_Msk = 0x40000000
	// Bit CAL_FLAG2.
	DAC_DAC_SR_CAL_FLAG2 = 0x40000000
	// calibration trimming value is lower than the offset correction value
	DAC_DAC_SR_CAL_FLAG2_B_0x0 = 0x0
	// calibration trimming value is equal or greater than the offset correction value
	DAC_DAC_SR_CAL_FLAG2_B_0x1 = 0x1
	// Position of BWST2 field.
	DAC_DAC_SR_BWST2_Pos = 0x1f
	// Bit mask of BWST2 field.
	DAC_DAC_SR_BWST2_Msk = 0x80000000
	// Bit BWST2.
	DAC_DAC_SR_BWST2 = 0x80000000
	// There is no write operation of DAC_SHSR2 ongoing: DAC_SHSR2 can be written
	DAC_DAC_SR_BWST2_B_0x0 = 0x0
	// There is a write operation of DAC_SHSR2 ongoing: DAC_SHSR2 cannot be written
	DAC_DAC_SR_BWST2_B_0x1 = 0x1

	// DAC_CCR: DAC calibration control register
	// Position of OTRIM1 field.
	DAC_DAC_CCR_OTRIM1_Pos = 0x0
	// Bit mask of OTRIM1 field.
	DAC_DAC_CCR_OTRIM1_Msk = 0x1f
	// Position of OTRIM2 field.
	DAC_DAC_CCR_OTRIM2_Pos = 0x10
	// Bit mask of OTRIM2 field.
	DAC_DAC_CCR_OTRIM2_Msk = 0x1f0000

	// DAC_MCR: DAC mode control register
	// Position of MODE1 field.
	DAC_DAC_MCR_MODE1_Pos = 0x0
	// Bit mask of MODE1 field.
	DAC_DAC_MCR_MODE1_Msk = 0x7
	// DAC channel1 is connected to external pin with Buffer enabled
	DAC_DAC_MCR_MODE1_B_0x0 = 0x0
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_DAC_MCR_MODE1_B_0x1 = 0x1
	// DAC channel1 is connected to external pin with Buffer disabled
	DAC_DAC_MCR_MODE1_B_0x2 = 0x2
	// DAC channel1 is connected to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE1_B_0x3 = 0x3
	// DAC channel1 is connected to external pin with Buffer enabled
	DAC_DAC_MCR_MODE1_B_0x4 = 0x4
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_DAC_MCR_MODE1_B_0x5 = 0x5
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE1_B_0x6 = 0x6
	// DAC channel1 is connected to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE1_B_0x7 = 0x7
	// Position of MODE2 field.
	DAC_DAC_MCR_MODE2_Pos = 0x10
	// Bit mask of MODE2 field.
	DAC_DAC_MCR_MODE2_Msk = 0x70000
	// DAC channel2 is connected to external pin with Buffer enabled
	DAC_DAC_MCR_MODE2_B_0x0 = 0x0
	// DAC channel2 is connected to external pin and to on chip peripherals with buffer enabled
	DAC_DAC_MCR_MODE2_B_0x1 = 0x1
	// DAC channel2 is connected to external pin with buffer disabled
	DAC_DAC_MCR_MODE2_B_0x2 = 0x2
	// DAC channel2 is connected to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE2_B_0x3 = 0x3
	// DAC channel2 is connected to external pin with Buffer enabled
	DAC_DAC_MCR_MODE2_B_0x4 = 0x4
	// DAC channel2 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_DAC_MCR_MODE2_B_0x5 = 0x5
	// DAC channel2 is connected to external pin and to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE2_B_0x6 = 0x6
	// DAC channel2 is connected to on chip peripherals with Buffer disabled
	DAC_DAC_MCR_MODE2_B_0x7 = 0x7

	// DAC_SHSR1: DAC Sample and Hold sample time register 1
	// Position of TSAMPLE1 field.
	DAC_DAC_SHSR1_TSAMPLE1_Pos = 0x0
	// Bit mask of TSAMPLE1 field.
	DAC_DAC_SHSR1_TSAMPLE1_Msk = 0x3ff

	// DAC_SHSR2: DAC Sample and Hold sample time register 2
	// Position of TSAMPLE2 field.
	DAC_DAC_SHSR2_TSAMPLE2_Pos = 0x0
	// Bit mask of TSAMPLE2 field.
	DAC_DAC_SHSR2_TSAMPLE2_Msk = 0x3ff

	// DAC_SHHR: DAC Sample and Hold hold time register
	// Position of THOLD1 field.
	DAC_DAC_SHHR_THOLD1_Pos = 0x0
	// Bit mask of THOLD1 field.
	DAC_DAC_SHHR_THOLD1_Msk = 0x3ff
	// Position of THOLD2 field.
	DAC_DAC_SHHR_THOLD2_Pos = 0x10
	// Bit mask of THOLD2 field.
	DAC_DAC_SHHR_THOLD2_Msk = 0x3ff0000

	// DAC_SHRR: DAC Sample and Hold refresh time register
	// Position of TREFRESH1 field.
	DAC_DAC_SHRR_TREFRESH1_Pos = 0x0
	// Bit mask of TREFRESH1 field.
	DAC_DAC_SHRR_TREFRESH1_Msk = 0xff
	// Position of TREFRESH2 field.
	DAC_DAC_SHRR_TREFRESH2_Pos = 0x10
	// Bit mask of TREFRESH2 field.
	DAC_DAC_SHRR_TREFRESH2_Msk = 0xff0000
)

// Bitfields for DMAMUX: DMAMUX
const (
	// DMAMUX_C0CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C0CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C0CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C0CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C0CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C0CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C0CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C0CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C0CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C0CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C0CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C0CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C0CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C0CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C0CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C0CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C1CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C1CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C1CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C1CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C1CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C1CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C1CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C1CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C1CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C1CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C1CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C1CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C1CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C1CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C1CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C1CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C2CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C2CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C2CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C2CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C2CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C2CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C2CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C2CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C2CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C2CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C2CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C2CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C2CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C2CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C2CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C2CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C3CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C3CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C3CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C3CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C3CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C3CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C3CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C3CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C3CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C3CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C3CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C3CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C3CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C3CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C3CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C3CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C4CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C4CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C4CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C4CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C4CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C4CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C4CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C4CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C4CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C4CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C4CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C4CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C4CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C4CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C4CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C4CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C5CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C5CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C5CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C5CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C5CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C5CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C5CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C5CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C5CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C5CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C5CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C5CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C5CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C5CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C5CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C5CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_C6CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C6CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_DMAMUX_C6CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_DMAMUX_C6CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_DMAMUX_C6CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_DMAMUX_C6CR_EGE = 0x200
	// event generation disabled
	DMAMUX_DMAMUX_C6CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_DMAMUX_C6CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_DMAMUX_C6CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_DMAMUX_C6CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_DMAMUX_C6CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_DMAMUX_C6CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_DMAMUX_C6CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_C6CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_C6CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_C6CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000

	// DMAMUX_CSR: DMAMUX request line multiplexer interrupt channel status register
	// Position of SOF0 field.
	DMAMUX_DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_DMAMUX_CSR_SOF0 = 0x1
	// Position of SOF1 field.
	DMAMUX_DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF2 field.
	DMAMUX_DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF3 field.
	DMAMUX_DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF4 field.
	DMAMUX_DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF5 field.
	DMAMUX_DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF6 field.
	DMAMUX_DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_DMAMUX_CSR_SOF6 = 0x40

	// DMAMUX_CFR: DMAMUX request line multiplexer interrupt clear flag register
	// Position of CSOF0 field.
	DMAMUX_DMAMUX_CFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_DMAMUX_CFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_DMAMUX_CFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_DMAMUX_CFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_DMAMUX_CFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_DMAMUX_CFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_DMAMUX_CFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_DMAMUX_CFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_DMAMUX_CFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_DMAMUX_CFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_DMAMUX_CFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_DMAMUX_CFR_CSOF3 = 0x8
	// Position of CSOF4 field.
	DMAMUX_DMAMUX_CFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_DMAMUX_CFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_DMAMUX_CFR_CSOF4 = 0x10
	// Position of CSOF5 field.
	DMAMUX_DMAMUX_CFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_DMAMUX_CFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_DMAMUX_CFR_CSOF5 = 0x20
	// Position of CSOF6 field.
	DMAMUX_DMAMUX_CFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_DMAMUX_CFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_DMAMUX_CFR_CSOF6 = 0x40

	// DMAMUX_RG0CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG0CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_DMAMUX_RG0CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_DMAMUX_RG0CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_DMAMUX_RG0CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_DMAMUX_RG0CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_DMAMUX_RG0CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_DMAMUX_RG0CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_DMAMUX_RG0CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_RG0CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_RG0CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_RG0CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000

	// DMAMUX_RG1CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG1CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_DMAMUX_RG1CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_DMAMUX_RG1CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_DMAMUX_RG1CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_DMAMUX_RG1CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_DMAMUX_RG1CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_DMAMUX_RG1CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_DMAMUX_RG1CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_RG1CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_RG1CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_RG1CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000

	// DMAMUX_RG2CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG2CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_DMAMUX_RG2CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_DMAMUX_RG2CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_DMAMUX_RG2CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_DMAMUX_RG2CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_DMAMUX_RG2CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_DMAMUX_RG2CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_DMAMUX_RG2CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_RG2CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_RG2CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_RG2CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000

	// DMAMUX_RG3CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG3CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_DMAMUX_RG3CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_DMAMUX_RG3CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_DMAMUX_RG3CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_DMAMUX_RG3CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_DMAMUX_RG3CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_DMAMUX_RG3CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_DMAMUX_RG3CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_DMAMUX_RG3CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_DMAMUX_RG3CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_DMAMUX_RG3CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000

	// DMAMUX_RGSR: DMAMUX request generator interrupt status register
	// Position of OF0 field.
	DMAMUX_DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_DMAMUX_RGSR_OF0 = 0x1
	// Position of OF1 field.
	DMAMUX_DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_DMAMUX_RGSR_OF1 = 0x2
	// Position of OF2 field.
	DMAMUX_DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_DMAMUX_RGSR_OF2 = 0x4
	// Position of OF3 field.
	DMAMUX_DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_DMAMUX_RGSR_OF3 = 0x8

	// DMAMUX_RGCFR: DMAMUX request generator interrupt clear flag register
	// Position of COF0 field.
	DMAMUX_DMAMUX_RGCFR_COF0_Pos = 0x0
	// Bit mask of COF0 field.
	DMAMUX_DMAMUX_RGCFR_COF0_Msk = 0x1
	// Bit COF0.
	DMAMUX_DMAMUX_RGCFR_COF0 = 0x1
	// Position of COF1 field.
	DMAMUX_DMAMUX_RGCFR_COF1_Pos = 0x1
	// Bit mask of COF1 field.
	DMAMUX_DMAMUX_RGCFR_COF1_Msk = 0x2
	// Bit COF1.
	DMAMUX_DMAMUX_RGCFR_COF1 = 0x2
	// Position of COF2 field.
	DMAMUX_DMAMUX_RGCFR_COF2_Pos = 0x2
	// Bit mask of COF2 field.
	DMAMUX_DMAMUX_RGCFR_COF2_Msk = 0x4
	// Bit COF2.
	DMAMUX_DMAMUX_RGCFR_COF2 = 0x4
	// Position of COF3 field.
	DMAMUX_DMAMUX_RGCFR_COF3_Pos = 0x3
	// Bit mask of COF3 field.
	DMAMUX_DMAMUX_RGCFR_COF3_Msk = 0x8
	// Bit COF3.
	DMAMUX_DMAMUX_RGCFR_COF3 = 0x8
)

// Bitfields for HDMI_CEC: HDMI-CEC
const (
	// CEC_CR: CEC control register
	// Position of CECEN field.
	CEC_CEC_CR_CECEN_Pos = 0x0
	// Bit mask of CECEN field.
	CEC_CEC_CR_CECEN_Msk = 0x1
	// Bit CECEN.
	CEC_CEC_CR_CECEN = 0x1
	// CEC peripheral is off.
	CEC_CEC_CR_CECEN_B_0x0 = 0x0
	// CEC peripheral is on.
	CEC_CEC_CR_CECEN_B_0x1 = 0x1
	// Position of TXSOM field.
	CEC_CEC_CR_TXSOM_Pos = 0x1
	// Bit mask of TXSOM field.
	CEC_CEC_CR_TXSOM_Msk = 0x2
	// Bit TXSOM.
	CEC_CEC_CR_TXSOM = 0x2
	// No CEC transmission is on-going
	CEC_CEC_CR_TXSOM_B_0x0 = 0x0
	// CEC transmission command
	CEC_CEC_CR_TXSOM_B_0x1 = 0x1
	// Position of TXEOM field.
	CEC_CEC_CR_TXEOM_Pos = 0x2
	// Bit mask of TXEOM field.
	CEC_CEC_CR_TXEOM_Msk = 0x4
	// Bit TXEOM.
	CEC_CEC_CR_TXEOM = 0x4
	// TXDR data byte is transmitted with EOM = 0
	CEC_CEC_CR_TXEOM_B_0x0 = 0x0
	// TXDR data byte is transmitted with EOM = 1
	CEC_CEC_CR_TXEOM_B_0x1 = 0x1

	// CEC_CFGR: This register is used to configure the HDMI-CEC controller. It is mandatory to write CEC_CFGR only when CECEN=0.
	// Position of SFT field.
	CEC_CEC_CFGR_SFT_Pos = 0x0
	// Bit mask of SFT field.
	CEC_CEC_CFGR_SFT_Msk = 0x7
	// 0.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x1 = 0x1
	// 1.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x2 = 0x2
	// 2.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x3 = 0x3
	// 3.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x4 = 0x4
	// 4.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x5 = 0x5
	// 5.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x6 = 0x6
	// 6.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x7 = 0x7
	// Position of RXTOL field.
	CEC_CEC_CFGR_RXTOL_Pos = 0x3
	// Bit mask of RXTOL field.
	CEC_CEC_CFGR_RXTOL_Msk = 0x8
	// Bit RXTOL.
	CEC_CEC_CFGR_RXTOL = 0x8
	// Standard tolerance margin:
	CEC_CEC_CFGR_RXTOL_B_0x0 = 0x0
	// Extended tolerance
	CEC_CEC_CFGR_RXTOL_B_0x1 = 0x1
	// Position of BRESTP field.
	CEC_CEC_CFGR_BRESTP_Pos = 0x4
	// Bit mask of BRESTP field.
	CEC_CEC_CFGR_BRESTP_Msk = 0x10
	// Bit BRESTP.
	CEC_CEC_CFGR_BRESTP = 0x10
	// BRE detection does not stop reception of the CEC message. Data bit is sampled at 1.05 ms.
	CEC_CEC_CFGR_BRESTP_B_0x0 = 0x0
	// BRE detection stops message reception.
	CEC_CEC_CFGR_BRESTP_B_0x1 = 0x1
	// Position of BREGEN field.
	CEC_CEC_CFGR_BREGEN_Pos = 0x5
	// Bit mask of BREGEN field.
	CEC_CEC_CFGR_BREGEN_Msk = 0x20
	// Bit BREGEN.
	CEC_CEC_CFGR_BREGEN = 0x20
	// BRE detection does not generate an error-bit on the CEC line.
	CEC_CEC_CFGR_BREGEN_B_0x0 = 0x0
	// BRE detection generates an error-bit on the CEC line (if BRESTP is set).
	CEC_CEC_CFGR_BREGEN_B_0x1 = 0x1
	// Position of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN_Pos = 0x6
	// Bit mask of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN_Msk = 0x40
	// Bit LBPEGEN.
	CEC_CEC_CFGR_LBPEGEN = 0x40
	// LBPE detection does not generate an error-bit on the CEC line.
	CEC_CEC_CFGR_LBPEGEN_B_0x0 = 0x0
	// LBPE detection generates an error-bit on the CEC line.
	CEC_CEC_CFGR_LBPEGEN_B_0x1 = 0x1
	// Position of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN_Pos = 0x7
	// Bit mask of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN_Msk = 0x80
	// Bit BRDNOGEN.
	CEC_CEC_CFGR_BRDNOGEN = 0x80
	// BRE detection with BRESTP = 1 and BREGEN = 0 on a broadcast message generates an
	CEC_CEC_CFGR_BRDNOGEN_B_0x0 = 0x0
	// Error-bit is not generated in the same condition as above. An error-bit is not generated even in case of an SBPE detection in a broadcast message if listen mode is set.
	CEC_CEC_CFGR_BRDNOGEN_B_0x1 = 0x1
	// Position of SFTOP field.
	CEC_CEC_CFGR_SFTOP_Pos = 0x8
	// Bit mask of SFTOP field.
	CEC_CEC_CFGR_SFTOP_Msk = 0x100
	// Bit SFTOP.
	CEC_CEC_CFGR_SFTOP = 0x100
	// SFT timer starts when TXSOM is set by software.
	CEC_CEC_CFGR_SFTOP_B_0x0 = 0x0
	// SFT timer starts automatically at the end of message transmission/reception.
	CEC_CEC_CFGR_SFTOP_B_0x1 = 0x1
	// Position of OAR field.
	CEC_CEC_CFGR_OAR_Pos = 0x10
	// Bit mask of OAR field.
	CEC_CEC_CFGR_OAR_Msk = 0x7fff0000
	// Position of LSTN field.
	CEC_CEC_CFGR_LSTN_Pos = 0x1f
	// Bit mask of LSTN field.
	CEC_CEC_CFGR_LSTN_Msk = 0x80000000
	// Bit LSTN.
	CEC_CEC_CFGR_LSTN = 0x80000000
	// CEC peripheral receives only message addressed to its own address (OAR). Messages addressed to different destination are ignored. Broadcast messages are always received.
	CEC_CEC_CFGR_LSTN_B_0x0 = 0x0
	// CEC peripheral receives messages addressed to its own address (OAR) with positive acknowledge. Messages addressed to different destination are received, but without interfering with the CEC bus: no acknowledge sent.
	CEC_CEC_CFGR_LSTN_B_0x1 = 0x1

	// CEC_TXDR: CEC Tx data register
	// Position of TXD field.
	CEC_CEC_TXDR_TXD_Pos = 0x0
	// Bit mask of TXD field.
	CEC_CEC_TXDR_TXD_Msk = 0xff

	// CEC_RXDR: CEC Rx Data Register
	// Position of RXD field.
	CEC_CEC_RXDR_RXD_Pos = 0x0
	// Bit mask of RXD field.
	CEC_CEC_RXDR_RXD_Msk = 0xff

	// CEC_ISR: CEC Interrupt and Status Register
	// Position of RXBR field.
	CEC_CEC_ISR_RXBR_Pos = 0x0
	// Bit mask of RXBR field.
	CEC_CEC_ISR_RXBR_Msk = 0x1
	// Bit RXBR.
	CEC_CEC_ISR_RXBR = 0x1
	// Position of RXEND field.
	CEC_CEC_ISR_RXEND_Pos = 0x1
	// Bit mask of RXEND field.
	CEC_CEC_ISR_RXEND_Msk = 0x2
	// Bit RXEND.
	CEC_CEC_ISR_RXEND = 0x2
	// Position of RXOVR field.
	CEC_CEC_ISR_RXOVR_Pos = 0x2
	// Bit mask of RXOVR field.
	CEC_CEC_ISR_RXOVR_Msk = 0x4
	// Bit RXOVR.
	CEC_CEC_ISR_RXOVR = 0x4
	// Position of BRE field.
	CEC_CEC_ISR_BRE_Pos = 0x3
	// Bit mask of BRE field.
	CEC_CEC_ISR_BRE_Msk = 0x8
	// Bit BRE.
	CEC_CEC_ISR_BRE = 0x8
	// Position of SBPE field.
	CEC_CEC_ISR_SBPE_Pos = 0x4
	// Bit mask of SBPE field.
	CEC_CEC_ISR_SBPE_Msk = 0x10
	// Bit SBPE.
	CEC_CEC_ISR_SBPE = 0x10
	// Position of LBPE field.
	CEC_CEC_ISR_LBPE_Pos = 0x5
	// Bit mask of LBPE field.
	CEC_CEC_ISR_LBPE_Msk = 0x20
	// Bit LBPE.
	CEC_CEC_ISR_LBPE = 0x20
	// Position of RXACKE field.
	CEC_CEC_ISR_RXACKE_Pos = 0x6
	// Bit mask of RXACKE field.
	CEC_CEC_ISR_RXACKE_Msk = 0x40
	// Bit RXACKE.
	CEC_CEC_ISR_RXACKE = 0x40
	// Position of ARBLST field.
	CEC_CEC_ISR_ARBLST_Pos = 0x7
	// Bit mask of ARBLST field.
	CEC_CEC_ISR_ARBLST_Msk = 0x80
	// Bit ARBLST.
	CEC_CEC_ISR_ARBLST = 0x80
	// Position of TXBR field.
	CEC_CEC_ISR_TXBR_Pos = 0x8
	// Bit mask of TXBR field.
	CEC_CEC_ISR_TXBR_Msk = 0x100
	// Bit TXBR.
	CEC_CEC_ISR_TXBR = 0x100
	// Position of TXEND field.
	CEC_CEC_ISR_TXEND_Pos = 0x9
	// Bit mask of TXEND field.
	CEC_CEC_ISR_TXEND_Msk = 0x200
	// Bit TXEND.
	CEC_CEC_ISR_TXEND = 0x200
	// Position of TXUDR field.
	CEC_CEC_ISR_TXUDR_Pos = 0xa
	// Bit mask of TXUDR field.
	CEC_CEC_ISR_TXUDR_Msk = 0x400
	// Bit TXUDR.
	CEC_CEC_ISR_TXUDR = 0x400
	// Position of TXERR field.
	CEC_CEC_ISR_TXERR_Pos = 0xb
	// Bit mask of TXERR field.
	CEC_CEC_ISR_TXERR_Msk = 0x800
	// Bit TXERR.
	CEC_CEC_ISR_TXERR = 0x800
	// Position of TXACKE field.
	CEC_CEC_ISR_TXACKE_Pos = 0xc
	// Bit mask of TXACKE field.
	CEC_CEC_ISR_TXACKE_Msk = 0x1000
	// Bit TXACKE.
	CEC_CEC_ISR_TXACKE = 0x1000

	// CEC_IER: CEC interrupt enable register
	// Position of RXBRIE field.
	CEC_CEC_IER_RXBRIE_Pos = 0x0
	// Bit mask of RXBRIE field.
	CEC_CEC_IER_RXBRIE_Msk = 0x1
	// Bit RXBRIE.
	CEC_CEC_IER_RXBRIE = 0x1
	// RXBR interrupt disabled
	CEC_CEC_IER_RXBRIE_B_0x0 = 0x0
	// RXBR interrupt enabled
	CEC_CEC_IER_RXBRIE_B_0x1 = 0x1
	// Position of RXENDIE field.
	CEC_CEC_IER_RXENDIE_Pos = 0x1
	// Bit mask of RXENDIE field.
	CEC_CEC_IER_RXENDIE_Msk = 0x2
	// Bit RXENDIE.
	CEC_CEC_IER_RXENDIE = 0x2
	// RXEND interrupt disabled
	CEC_CEC_IER_RXENDIE_B_0x0 = 0x0
	// RXEND interrupt enabled
	CEC_CEC_IER_RXENDIE_B_0x1 = 0x1
	// Position of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE_Pos = 0x2
	// Bit mask of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE_Msk = 0x4
	// Bit RXOVRIE.
	CEC_CEC_IER_RXOVRIE = 0x4
	// RXOVR interrupt disabled
	CEC_CEC_IER_RXOVRIE_B_0x0 = 0x0
	// RXOVR interrupt enabled
	CEC_CEC_IER_RXOVRIE_B_0x1 = 0x1
	// Position of BREIE field.
	CEC_CEC_IER_BREIE_Pos = 0x3
	// Bit mask of BREIE field.
	CEC_CEC_IER_BREIE_Msk = 0x8
	// Bit BREIE.
	CEC_CEC_IER_BREIE = 0x8
	// BRE interrupt disabled
	CEC_CEC_IER_BREIE_B_0x0 = 0x0
	// BRE interrupt enabled
	CEC_CEC_IER_BREIE_B_0x1 = 0x1
	// Position of SBPEIE field.
	CEC_CEC_IER_SBPEIE_Pos = 0x4
	// Bit mask of SBPEIE field.
	CEC_CEC_IER_SBPEIE_Msk = 0x10
	// Bit SBPEIE.
	CEC_CEC_IER_SBPEIE = 0x10
	// SBPE interrupt disabled
	CEC_CEC_IER_SBPEIE_B_0x0 = 0x0
	// SBPE interrupt enabled
	CEC_CEC_IER_SBPEIE_B_0x1 = 0x1
	// Position of LBPEIE field.
	CEC_CEC_IER_LBPEIE_Pos = 0x5
	// Bit mask of LBPEIE field.
	CEC_CEC_IER_LBPEIE_Msk = 0x20
	// Bit LBPEIE.
	CEC_CEC_IER_LBPEIE = 0x20
	// LBPE interrupt disabled
	CEC_CEC_IER_LBPEIE_B_0x0 = 0x0
	// LBPE interrupt enabled
	CEC_CEC_IER_LBPEIE_B_0x1 = 0x1
	// Position of RXACKIE field.
	CEC_CEC_IER_RXACKIE_Pos = 0x6
	// Bit mask of RXACKIE field.
	CEC_CEC_IER_RXACKIE_Msk = 0x40
	// Bit RXACKIE.
	CEC_CEC_IER_RXACKIE = 0x40
	// RXACKE interrupt disabled
	CEC_CEC_IER_RXACKIE_B_0x0 = 0x0
	// RXACKE interrupt enabled
	CEC_CEC_IER_RXACKIE_B_0x1 = 0x1
	// Position of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE_Pos = 0x7
	// Bit mask of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE_Msk = 0x80
	// Bit ARBLSTIE.
	CEC_CEC_IER_ARBLSTIE = 0x80
	// ARBLST interrupt disabled
	CEC_CEC_IER_ARBLSTIE_B_0x0 = 0x0
	// ARBLST interrupt enabled
	CEC_CEC_IER_ARBLSTIE_B_0x1 = 0x1
	// Position of TXBRIE field.
	CEC_CEC_IER_TXBRIE_Pos = 0x8
	// Bit mask of TXBRIE field.
	CEC_CEC_IER_TXBRIE_Msk = 0x100
	// Bit TXBRIE.
	CEC_CEC_IER_TXBRIE = 0x100
	// TXBR interrupt disabled
	CEC_CEC_IER_TXBRIE_B_0x0 = 0x0
	// TXBR interrupt enabled
	CEC_CEC_IER_TXBRIE_B_0x1 = 0x1
	// Position of TXENDIE field.
	CEC_CEC_IER_TXENDIE_Pos = 0x9
	// Bit mask of TXENDIE field.
	CEC_CEC_IER_TXENDIE_Msk = 0x200
	// Bit TXENDIE.
	CEC_CEC_IER_TXENDIE = 0x200
	// TXEND interrupt disabled
	CEC_CEC_IER_TXENDIE_B_0x0 = 0x0
	// TXEND interrupt enabled
	CEC_CEC_IER_TXENDIE_B_0x1 = 0x1
	// Position of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE_Pos = 0xa
	// Bit mask of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE_Msk = 0x400
	// Bit TXUDRIE.
	CEC_CEC_IER_TXUDRIE = 0x400
	// TXUDR interrupt disabled
	CEC_CEC_IER_TXUDRIE_B_0x0 = 0x0
	// TXUDR interrupt enabled
	CEC_CEC_IER_TXUDRIE_B_0x1 = 0x1
	// Position of TXERRIE field.
	CEC_CEC_IER_TXERRIE_Pos = 0xb
	// Bit mask of TXERRIE field.
	CEC_CEC_IER_TXERRIE_Msk = 0x800
	// Bit TXERRIE.
	CEC_CEC_IER_TXERRIE = 0x800
	// TXERR interrupt disabled
	CEC_CEC_IER_TXERRIE_B_0x0 = 0x0
	// TXERR interrupt enabled
	CEC_CEC_IER_TXERRIE_B_0x1 = 0x1
	// Position of TXACKIE field.
	CEC_CEC_IER_TXACKIE_Pos = 0xc
	// Bit mask of TXACKIE field.
	CEC_CEC_IER_TXACKIE_Msk = 0x1000
	// Bit TXACKIE.
	CEC_CEC_IER_TXACKIE = 0x1000
	// TXACKE interrupt disabled
	CEC_CEC_IER_TXACKIE_B_0x0 = 0x0
	// TXACKE interrupt enabled
	CEC_CEC_IER_TXACKIE_B_0x1 = 0x1
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// I2C_CR1: Control register 1
	// Position of PE field.
	I2C_I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_I2C_CR1_PE = 0x1
	// Peripheral disable
	I2C_I2C_CR1_PE_B_0x0 = 0x0
	// Peripheral enable
	I2C_I2C_CR1_PE_B_0x1 = 0x1
	// Position of TXIE field.
	I2C_I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_I2C_CR1_TXIE_B_0x0 = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_I2C_CR1_TXIE_B_0x1 = 0x1
	// Position of RXIE field.
	I2C_I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_I2C_CR1_RXIE_B_0x0 = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_I2C_CR1_RXIE_B_0x1 = 0x1
	// Position of ADDRIE field.
	I2C_I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_I2C_CR1_ADDRIE_B_0x0 = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_I2C_CR1_ADDRIE_B_0x1 = 0x1
	// Position of NACKIE field.
	I2C_I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_I2C_CR1_NACKIE_B_0x0 = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_I2C_CR1_NACKIE_B_0x1 = 0x1
	// Position of STOPIE field.
	I2C_I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_I2C_CR1_STOPIE_B_0x0 = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_I2C_CR1_STOPIE_B_0x1 = 0x1
	// Position of TCIE field.
	I2C_I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_I2C_CR1_TCIE_B_0x0 = 0x0
	// Transfer Complete interrupt enabled
	I2C_I2C_CR1_TCIE_B_0x1 = 0x1
	// Position of ERRIE field.
	I2C_I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_I2C_CR1_ERRIE_B_0x0 = 0x0
	// Error detection interrupts enabled
	I2C_I2C_CR1_ERRIE_B_0x1 = 0x1
	// Position of DNF field.
	I2C_I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_I2C_CR1_DNF_B_0x0 = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_I2C_CR1_DNF_B_0x1 = 0x1
	// digital filter enabled and filtering capability up to15 tI2CCLK
	I2C_I2C_CR1_DNF_B_0xF = 0xf
	// Position of ANFOFF field.
	I2C_I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_I2C_CR1_ANFOFF_B_0x0 = 0x0
	// Analog noise filter disabled
	I2C_I2C_CR1_ANFOFF_B_0x1 = 0x1
	// Position of TXDMAEN field.
	I2C_I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_I2C_CR1_TXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for transmission
	I2C_I2C_CR1_TXDMAEN_B_0x1 = 0x1
	// Position of RXDMAEN field.
	I2C_I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_I2C_CR1_RXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for reception
	I2C_I2C_CR1_RXDMAEN_B_0x1 = 0x1
	// Position of SBC field.
	I2C_I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_I2C_CR1_SBC_B_0x0 = 0x0
	// Slave byte control enabled
	I2C_I2C_CR1_SBC_B_0x1 = 0x1
	// Position of NOSTRETCH field.
	I2C_I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_I2C_CR1_NOSTRETCH_B_0x0 = 0x0
	// Clock stretching disabled
	I2C_I2C_CR1_NOSTRETCH_B_0x1 = 0x1
	// Position of WUPEN field.
	I2C_I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disable.
	I2C_I2C_CR1_WUPEN_B_0x0 = 0x0
	// Wakeup from Stop mode enable.
	I2C_I2C_CR1_WUPEN_B_0x1 = 0x1
	// Position of GCEN field.
	I2C_I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed.
	I2C_I2C_CR1_GCEN_B_0x0 = 0x0
	// General call enabled. Address 0b00000000 is ACKed.
	I2C_I2C_CR1_GCEN_B_0x1 = 0x1
	// Position of SMBHEN field.
	I2C_I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_I2C_CR1_SMBHEN = 0x100000
	// Host Address disabled. Address 0b0001000x is NACKed.
	I2C_I2C_CR1_SMBHEN_B_0x0 = 0x0
	// Host Address enabled. Address 0b0001000x is ACKed.
	I2C_I2C_CR1_SMBHEN_B_0x1 = 0x1
	// Position of SMBDEN field.
	I2C_I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_I2C_CR1_SMBDEN = 0x200000
	// Device Default Address disabled. Address 0b1100001x is NACKed.
	I2C_I2C_CR1_SMBDEN_B_0x0 = 0x0
	// Device Default Address enabled. Address 0b1100001x is ACKed.
	I2C_I2C_CR1_SMBDEN_B_0x1 = 0x1
	// Position of ALERTEN field.
	I2C_I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_I2C_CR1_ALERTEN = 0x400000
	// The SMBus alert pin (SMBA) is not supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is released and the Alert Response Address header is disabled (0001100x followed by NACK).
	I2C_I2C_CR1_ALERTEN_B_0x0 = 0x0
	// The SMBus alert pin is supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is driven low and the Alert Response Address header is enabled (0001100x followed by ACK).
	I2C_I2C_CR1_ALERTEN_B_0x1 = 0x1
	// Position of PECEN field.
	I2C_I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_I2C_CR1_PECEN_B_0x0 = 0x0
	// PEC calculation enabled
	I2C_I2C_CR1_PECEN_B_0x1 = 0x1

	// I2C_CR2: Control register 2
	// Position of SADD field.
	I2C_I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_I2C_CR2_SADD_Msk = 0x3ff
	// Position of RD_WRN field.
	I2C_I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer.
	I2C_I2C_CR2_RD_WRN_B_0x0 = 0x0
	// Master requests a read transfer.
	I2C_I2C_CR2_RD_WRN_B_0x1 = 0x1
	// Position of ADD10 field.
	I2C_I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode,
	I2C_I2C_CR2_ADD10_B_0x0 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_I2C_CR2_ADD10_B_0x1 = 0x1
	// Position of HEAD10R field.
	I2C_I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence: Start + 2 bytes 10bit address in write direction + Restart + 1st 7 bits of the 10 bit address in read direction.
	I2C_I2C_CR2_HEAD10R_B_0x0 = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction.
	I2C_I2C_CR2_HEAD10R_B_0x1 = 0x1
	// Position of START field.
	I2C_I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_I2C_CR2_START = 0x2000
	// No Start generation.
	I2C_I2C_CR2_START_B_0x0 = 0x0
	// Restart/Start generation:
	I2C_I2C_CR2_START_B_0x1 = 0x1
	// Position of STOP field.
	I2C_I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_I2C_CR2_STOP = 0x4000
	// No Stop generation.
	I2C_I2C_CR2_STOP_B_0x0 = 0x0
	// Stop generation after current byte transfer.
	I2C_I2C_CR2_STOP_B_0x1 = 0x1
	// Position of NACK field.
	I2C_I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte.
	I2C_I2C_CR2_NACK_B_0x0 = 0x0
	// a NACK is sent after current received byte.
	I2C_I2C_CR2_NACK_B_0x1 = 0x1
	// Position of NBYTES field.
	I2C_I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of RELOAD field.
	I2C_I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART follows).
	I2C_I2C_CR2_RELOAD_B_0x0 = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES is reloaded). TCR flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_I2C_CR2_RELOAD_B_0x1 = 0x1
	// Position of AUTOEND field.
	I2C_I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_I2C_CR2_AUTOEND = 0x2000000
	// software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_I2C_CR2_AUTOEND_B_0x0 = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred.
	I2C_I2C_CR2_AUTOEND_B_0x1 = 0x1
	// Position of PECBYTE field.
	I2C_I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer.
	I2C_I2C_CR2_PECBYTE_B_0x0 = 0x0
	// PEC transmission/reception is requested
	I2C_I2C_CR2_PECBYTE_B_0x1 = 0x1

	// I2C_OAR1: Own address register 1
	// Position of OA1 field.
	I2C_I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address.
	I2C_I2C_OAR1_OA1MODE_B_0x0 = 0x0
	// Own address 1 is a 10-bit address.
	I2C_I2C_OAR1_OA1MODE_B_0x1 = 0x1
	// Position of OA1EN field.
	I2C_I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed.
	I2C_I2C_OAR1_OA1EN_B_0x0 = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed.
	I2C_I2C_OAR1_OA1EN_B_0x1 = 0x1

	// I2C_OAR2: Own address register 2
	// Position of OA2 field.
	I2C_I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_I2C_OAR2_OA2MSK_B_0x0 = 0x0
	// OA2[1] is masked and donât care. Only OA2[7:2] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x1 = 0x1
	// OA2[2:1] are masked and donât care. Only OA2[7:3] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x2 = 0x2
	// OA2[3:1] are masked and donât care. Only OA2[7:4] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x3 = 0x3
	// OA2[4:1] are masked and donât care. Only OA2[7:5] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x4 = 0x4
	// OA2[5:1] are masked and donât care. Only OA2[7:6] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x5 = 0x5
	// OA2[6:1] are masked and donât care. Only OA2[7] is compared.
	I2C_I2C_OAR2_OA2MSK_B_0x6 = 0x6
	// OA2[7:1] are masked and donât care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged.
	I2C_I2C_OAR2_OA2MSK_B_0x7 = 0x7
	// Position of OA2EN field.
	I2C_I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed.
	I2C_I2C_OAR2_OA2EN_B_0x0 = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed.
	I2C_I2C_OAR2_OA2EN_B_0x1 = 0x1

	// I2C_TIMINGR: Timing register
	// Position of SCLL field.
	I2C_I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// I2C_TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_I2C_TIMEOUTR_TIDLE_B_0x0 = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_I2C_TIMEOUTR_TIDLE_B_0x1 = 0x1
	// Position of TIMOUTEN field.
	I2C_I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_I2C_TIMEOUTR_TIMOUTEN_B_0x0 = 0x0
	// SCL timeout detection is enabled: when SCL is low for more than tTIMEOUT (TIDLE=0) or high for more than tIDLE (TIDLE=1), a timeout error is detected (TIMEOUT=1).
	I2C_I2C_TIMEOUTR_TIMOUTEN_B_0x1 = 0x1
	// Position of TIMEOUTB field.
	I2C_I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_I2C_TIMEOUTR_TEXTEN_B_0x0 = 0x0
	// Extended clock timeout detection is enabled. When a cumulative SCL stretch for more than tLOW:EXT is done by the I2C interface, a timeout error is detected (TIMEOUT=1).
	I2C_I2C_TIMEOUTR_TEXTEN_B_0x1 = 0x1

	// I2C_ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode.
	I2C_I2C_ISR_DIR_B_0x0 = 0x0
	// Read transfer, slave enters transmitter mode.
	I2C_I2C_ISR_DIR_B_0x1 = 0x1
	// Position of BUSY field.
	I2C_I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_I2C_ISR_TXE = 0x1

	// I2C_ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_I2C_ICR_ADDRCF = 0x8

	// I2C_PECR: PEC register
	// Position of PEC field.
	I2C_I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_I2C_PECR_PEC_Msk = 0xff

	// I2C_RXDR: Receive data register
	// Position of RXDATA field.
	I2C_I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_I2C_RXDR_RXDATA_Msk = 0xff

	// I2C_TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for IWDG: Independent watchdog
const (
	// IWDG_KR: Key register
	// Position of KEY field.
	IWDG_IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_IWDG_KR_KEY_Msk = 0xffff

	// IWDG_PR: Prescaler register
	// Position of PR field.
	IWDG_IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_IWDG_PR_PR_Msk = 0x7
	// divider /4
	IWDG_IWDG_PR_PR_B_0x0 = 0x0
	// divider /8
	IWDG_IWDG_PR_PR_B_0x1 = 0x1
	// divider /16
	IWDG_IWDG_PR_PR_B_0x2 = 0x2
	// divider /32
	IWDG_IWDG_PR_PR_B_0x3 = 0x3
	// divider /64
	IWDG_IWDG_PR_PR_B_0x4 = 0x4
	// divider /128
	IWDG_IWDG_PR_PR_B_0x5 = 0x5
	// divider /256
	IWDG_IWDG_PR_PR_B_0x6 = 0x6
	// divider /256
	IWDG_IWDG_PR_PR_B_0x7 = 0x7

	// IWDG_RLR: Reload register
	// Position of RL field.
	IWDG_IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_IWDG_RLR_RL_Msk = 0xfff

	// IWDG_SR: Status register
	// Position of PVU field.
	IWDG_IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_IWDG_SR_PVU = 0x1
	// Position of RVU field.
	IWDG_IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_IWDG_SR_RVU = 0x2
	// Position of WVU field.
	IWDG_IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_IWDG_SR_WVU = 0x4

	// IWDG_WINR: Window register
	// Position of WIN field.
	IWDG_IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for LPTIM1: Low power timer
const (
	// LPTIM_ISR: Interrupt and Status Register
	// Position of CMPM field.
	LPTIM_LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_LPTIM_ISR_CMPM = 0x1
	// Position of ARRM field.
	LPTIM_LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_LPTIM_ISR_ARRM = 0x2
	// Position of EXTTRIG field.
	LPTIM_LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_LPTIM_ISR_EXTTRIG = 0x4
	// Position of CMPOK field.
	LPTIM_LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_LPTIM_ISR_CMPOK = 0x8
	// Position of ARROK field.
	LPTIM_LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_LPTIM_ISR_ARROK = 0x10
	// Position of UP field.
	LPTIM_LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_LPTIM_ISR_UP = 0x20
	// Position of DOWN field.
	LPTIM_LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_LPTIM_ISR_DOWN = 0x40

	// LPTIM_ICR: Interrupt Clear Register
	// Position of CMPMCF field.
	LPTIM_LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_LPTIM_ICR_CMPMCF = 0x1
	// Position of ARRMCF field.
	LPTIM_LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_LPTIM_ICR_ARRMCF = 0x2
	// Position of EXTTRIGCF field.
	LPTIM_LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of CMPOKCF field.
	LPTIM_LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_LPTIM_ICR_CMPOKCF = 0x8
	// Position of ARROKCF field.
	LPTIM_LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_LPTIM_ICR_ARROKCF = 0x10
	// Position of UPCF field.
	LPTIM_LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_LPTIM_ICR_UPCF = 0x20
	// Position of DOWNCF field.
	LPTIM_LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_LPTIM_ICR_DOWNCF = 0x40

	// LPTIM_IER: Interrupt Enable Register
	// Position of CMPMIE field.
	LPTIM_LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_LPTIM_IER_CMPMIE = 0x1
	// CMPM interrupt disabled
	LPTIM_LPTIM_IER_CMPMIE_B_0x0 = 0x0
	// CMPM interrupt enabled
	LPTIM_LPTIM_IER_CMPMIE_B_0x1 = 0x1
	// Position of ARRMIE field.
	LPTIM_LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_LPTIM_IER_ARRMIE = 0x2
	// ARRM interrupt disabled
	LPTIM_LPTIM_IER_ARRMIE_B_0x0 = 0x0
	// ARRM interrupt enabled
	LPTIM_LPTIM_IER_ARRMIE_B_0x1 = 0x1
	// Position of EXTTRIGIE field.
	LPTIM_LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_LPTIM_IER_EXTTRIGIE = 0x4
	// EXTTRIG interrupt disabled
	LPTIM_LPTIM_IER_EXTTRIGIE_B_0x0 = 0x0
	// EXTTRIG interrupt enabled
	LPTIM_LPTIM_IER_EXTTRIGIE_B_0x1 = 0x1
	// Position of CMPOKIE field.
	LPTIM_LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_LPTIM_IER_CMPOKIE = 0x8
	// CMPOK interrupt disabled
	LPTIM_LPTIM_IER_CMPOKIE_B_0x0 = 0x0
	// CMPOK interrupt enabled
	LPTIM_LPTIM_IER_CMPOKIE_B_0x1 = 0x1
	// Position of ARROKIE field.
	LPTIM_LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_LPTIM_IER_ARROKIE = 0x10
	// ARROK interrupt disabled
	LPTIM_LPTIM_IER_ARROKIE_B_0x0 = 0x0
	// ARROK interrupt enabled
	LPTIM_LPTIM_IER_ARROKIE_B_0x1 = 0x1
	// Position of UPIE field.
	LPTIM_LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_LPTIM_IER_UPIE = 0x20
	// UP interrupt disabled
	LPTIM_LPTIM_IER_UPIE_B_0x0 = 0x0
	// UP interrupt enabled
	LPTIM_LPTIM_IER_UPIE_B_0x1 = 0x1
	// Position of DOWNIE field.
	LPTIM_LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_LPTIM_IER_DOWNIE = 0x40
	// DOWN interrupt disabled
	LPTIM_LPTIM_IER_DOWNIE_B_0x0 = 0x0
	// DOWN interrupt enabled
	LPTIM_LPTIM_IER_DOWNIE_B_0x1 = 0x1

	// LPTIM_CFGR: Configuration Register
	// Position of CKSEL field.
	LPTIM_LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_LPTIM_CFGR_CKSEL = 0x1
	// LPTIM is clocked by internal clock source (APB clock or any of the embedded oscillators)
	LPTIM_LPTIM_CFGR_CKSEL_B_0x0 = 0x0
	// LPTIM is clocked by an external clock source through the LPTIM external Input1
	LPTIM_LPTIM_CFGR_CKSEL_B_0x1 = 0x1
	// Position of CKPOL field.
	LPTIM_LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_LPTIM_CFGR_CKPOL_Msk = 0x6
	// the rising edge is the active edge used for counting.
	LPTIM_LPTIM_CFGR_CKPOL_B_0x0 = 0x0
	// the falling edge is the active edge used for counting
	LPTIM_LPTIM_CFGR_CKPOL_B_0x1 = 0x1
	// both edges are active edges. When both external clock signal edges are considered active ones, the LPTIM must also be clocked by an internal clock source with a frequency equal to at least four times the external clock frequency.If the LPTIM is configured in Encoder mode (ENC bit is set), the encoder sub-mode 3 is active.
	LPTIM_LPTIM_CFGR_CKPOL_B_0x2 = 0x2
	// not allowed
	LPTIM_LPTIM_CFGR_CKPOL_B_0x3 = 0x3
	// Position of CKFLT field.
	LPTIM_LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_LPTIM_CFGR_CKFLT_Msk = 0x18
	// any external clock signal level change is considered as a valid transition
	LPTIM_LPTIM_CFGR_CKFLT_B_0x0 = 0x0
	// external clock signal level change must be stable for at least 2 clock periods before it is considered as valid transition.
	LPTIM_LPTIM_CFGR_CKFLT_B_0x1 = 0x1
	// external clock signal level change must be stable for at least 4 clock periods before it is considered as valid transition.
	LPTIM_LPTIM_CFGR_CKFLT_B_0x2 = 0x2
	// external clock signal level change must be stable for at least 8 clock periods before it is considered as valid transition.
	LPTIM_LPTIM_CFGR_CKFLT_B_0x3 = 0x3
	// Position of TRGFLT field.
	LPTIM_LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// any trigger active level change is considered as a valid trigger
	LPTIM_LPTIM_CFGR_TRGFLT_B_0x0 = 0x0
	// trigger active level change must be stable for at least 2 clock periods before it is considered as valid trigger.
	LPTIM_LPTIM_CFGR_TRGFLT_B_0x1 = 0x1
	// trigger active level change must be stable for at least 4 clock periods before it is considered as valid trigger.
	LPTIM_LPTIM_CFGR_TRGFLT_B_0x2 = 0x2
	// trigger active level change must be stable for at least 8 clock periods before it is considered as valid trigger.
	LPTIM_LPTIM_CFGR_TRGFLT_B_0x3 = 0x3
	// Position of PRESC field.
	LPTIM_LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_LPTIM_CFGR_PRESC_Msk = 0xe00
	// /1
	LPTIM_LPTIM_CFGR_PRESC_B_0x0 = 0x0
	// /2
	LPTIM_LPTIM_CFGR_PRESC_B_0x1 = 0x1
	// /4
	LPTIM_LPTIM_CFGR_PRESC_B_0x2 = 0x2
	// /8
	LPTIM_LPTIM_CFGR_PRESC_B_0x3 = 0x3
	// /16
	LPTIM_LPTIM_CFGR_PRESC_B_0x4 = 0x4
	// /32
	LPTIM_LPTIM_CFGR_PRESC_B_0x5 = 0x5
	// /64
	LPTIM_LPTIM_CFGR_PRESC_B_0x6 = 0x6
	// /128
	LPTIM_LPTIM_CFGR_PRESC_B_0x7 = 0x7
	// Position of TRIGSEL field.
	LPTIM_LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// lptim_ext_trig0
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x0 = 0x0
	// lptim_ext_trig1
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x1 = 0x1
	// lptim_ext_trig2
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x2 = 0x2
	// lptim_ext_trig3
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x3 = 0x3
	// lptim_ext_trig4
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x4 = 0x4
	// lptim_ext_trig5
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x5 = 0x5
	// lptim_ext_trig6
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x6 = 0x6
	// lptim_ext_trig7
	LPTIM_LPTIM_CFGR_TRIGSEL_B_0x7 = 0x7
	// Position of TRIGEN field.
	LPTIM_LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// software trigger (counting start is initiated by software)
	LPTIM_LPTIM_CFGR_TRIGEN_B_0x0 = 0x0
	// rising edge is the active edge
	LPTIM_LPTIM_CFGR_TRIGEN_B_0x1 = 0x1
	// falling edge is the active edge
	LPTIM_LPTIM_CFGR_TRIGEN_B_0x2 = 0x2
	// both edges are active edges
	LPTIM_LPTIM_CFGR_TRIGEN_B_0x3 = 0x3
	// Position of TIMOUT field.
	LPTIM_LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_LPTIM_CFGR_TIMOUT = 0x80000
	// A trigger event arriving when the timer is already started will be ignored
	LPTIM_LPTIM_CFGR_TIMOUT_B_0x0 = 0x0
	// A trigger event arriving when the timer is already started will reset and restart the counter
	LPTIM_LPTIM_CFGR_TIMOUT_B_0x1 = 0x1
	// Position of WAVE field.
	LPTIM_LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_LPTIM_CFGR_WAVE = 0x100000
	// Deactivate Set-once mode, PWM or One Pulse waveform depending on how the timer was started, CNTSTRT for PWM or SNGSTRT for One Pulse waveform.
	LPTIM_LPTIM_CFGR_WAVE_B_0x0 = 0x0
	// Activate the Set-once mode
	LPTIM_LPTIM_CFGR_WAVE_B_0x1 = 0x1
	// Position of WAVPOL field.
	LPTIM_LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_LPTIM_CFGR_WAVPOL = 0x200000
	// The LPTIM output reflects the compare results between LPTIM_CNT and LPTIM_CMP registers
	LPTIM_LPTIM_CFGR_WAVPOL_B_0x0 = 0x0
	// The LPTIM output reflects the inverse of the compare results between LPTIM_CNT and LPTIM_CMP registers
	LPTIM_LPTIM_CFGR_WAVPOL_B_0x1 = 0x1
	// Position of PRELOAD field.
	LPTIM_LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_LPTIM_CFGR_PRELOAD = 0x400000
	// Registers are updated after each APB bus write access
	LPTIM_LPTIM_CFGR_PRELOAD_B_0x0 = 0x0
	// Registers are updated at the end of the current LPTIM period
	LPTIM_LPTIM_CFGR_PRELOAD_B_0x1 = 0x1
	// Position of COUNTMODE field.
	LPTIM_LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_LPTIM_CFGR_COUNTMODE = 0x800000
	// the counter is incremented following each internal clock pulse
	LPTIM_LPTIM_CFGR_COUNTMODE_B_0x0 = 0x0
	// the counter is incremented following each valid clock pulse on the LPTIM external Input1
	LPTIM_LPTIM_CFGR_COUNTMODE_B_0x1 = 0x1
	// Position of ENC field.
	LPTIM_LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_LPTIM_CFGR_ENC = 0x1000000
	// Encoder mode disabled
	LPTIM_LPTIM_CFGR_ENC_B_0x0 = 0x0
	// Encoder mode enabled
	LPTIM_LPTIM_CFGR_ENC_B_0x1 = 0x1

	// LPTIM_CR: Control Register
	// Position of ENABLE field.
	LPTIM_LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_LPTIM_CR_ENABLE = 0x1
	// LPTIM is disabled
	LPTIM_LPTIM_CR_ENABLE_B_0x0 = 0x0
	// LPTIM is enabled
	LPTIM_LPTIM_CR_ENABLE_B_0x1 = 0x1
	// Position of SNGSTRT field.
	LPTIM_LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_LPTIM_CR_SNGSTRT = 0x2
	// Position of CNTSTRT field.
	LPTIM_LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_LPTIM_CR_CNTSTRT = 0x4
	// Position of COUNTRST field.
	LPTIM_LPTIM_CR_COUNTRST_Pos = 0x3
	// Bit mask of COUNTRST field.
	LPTIM_LPTIM_CR_COUNTRST_Msk = 0x8
	// Bit COUNTRST.
	LPTIM_LPTIM_CR_COUNTRST = 0x8
	// Position of RSTARE field.
	LPTIM_LPTIM_CR_RSTARE_Pos = 0x4
	// Bit mask of RSTARE field.
	LPTIM_LPTIM_CR_RSTARE_Msk = 0x10
	// Bit RSTARE.
	LPTIM_LPTIM_CR_RSTARE = 0x10

	// LPTIM_CMP: Compare Register
	// Position of CMP field.
	LPTIM_LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_LPTIM_CMP_CMP_Msk = 0xffff

	// LPTIM_ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_LPTIM_ARR_ARR_Msk = 0xffff

	// LPTIM_CNT: Counter Register
	// Position of CNT field.
	LPTIM_LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_LPTIM_CNT_CNT_Msk = 0xffff

	// LPTIM_CFGR2: LPTIM configuration register 2
	// Position of IN1SEL field.
	LPTIM_LPTIM_CFGR2_IN1SEL_Pos = 0x0
	// Bit mask of IN1SEL field.
	LPTIM_LPTIM_CFGR2_IN1SEL_Msk = 0x3
	// lptim_in1_mux0
	LPTIM_LPTIM_CFGR2_IN1SEL_B_0x0 = 0x0
	// lptim_in1_mux1
	LPTIM_LPTIM_CFGR2_IN1SEL_B_0x1 = 0x1
	// lptim_in1_mux2
	LPTIM_LPTIM_CFGR2_IN1SEL_B_0x2 = 0x2
	// lptim_in1_mux3
	LPTIM_LPTIM_CFGR2_IN1SEL_B_0x3 = 0x3
	// Position of IN2SEL field.
	LPTIM_LPTIM_CFGR2_IN2SEL_Pos = 0x4
	// Bit mask of IN2SEL field.
	LPTIM_LPTIM_CFGR2_IN2SEL_Msk = 0x30
	// lptim_in2_mux0
	LPTIM_LPTIM_CFGR2_IN2SEL_B_0x0 = 0x0
	// lptim_in2_mux1
	LPTIM_LPTIM_CFGR2_IN2SEL_B_0x1 = 0x1
	// lptim_in2_mux2
	LPTIM_LPTIM_CFGR2_IN2SEL_B_0x2 = 0x2
	// lptim_in2_mux3
	LPTIM_LPTIM_CFGR2_IN2SEL_B_0x3 = 0x3
)

// Bitfields for TIM1: Advanced-timers
const (
	// TIM1_CR1: control register 1
	// Position of CEN field.
	TIM_TIM1_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_TIM1_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_TIM1_CR1_CEN = 0x1
	// Counter disabled
	TIM_TIM1_CR1_CEN_B_0x0 = 0x0
	// Counter enabled
	TIM_TIM1_CR1_CEN_B_0x1 = 0x1
	// Position of UDIS field.
	TIM_TIM1_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_TIM1_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_TIM1_CR1_UDIS = 0x2
	// UEV enabled. The Update (UEV) event is generated by one of the following events:
	TIM_TIM1_CR1_UDIS_B_0x0 = 0x0
	// UEV disabled. The Update event is not generated, shadow registers keep their value (ARR, PSC, CCRx). However the counter and the prescaler are reinitialized if the UG bit is set or if a hardware reset is received from the slave mode controller.
	TIM_TIM1_CR1_UDIS_B_0x1 = 0x1
	// Position of URS field.
	TIM_TIM1_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_TIM1_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_TIM1_CR1_URS = 0x4
	// Any of the following events generate an update interrupt or DMA request if enabled. These events can be:
	TIM_TIM1_CR1_URS_B_0x0 = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request if enabled.
	TIM_TIM1_CR1_URS_B_0x1 = 0x1
	// Position of OPM field.
	TIM_TIM1_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_TIM1_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_TIM1_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_TIM1_CR1_OPM_B_0x0 = 0x0
	// Counter stops counting at the next update event (clearing the bit CEN)
	TIM_TIM1_CR1_OPM_B_0x1 = 0x1
	// Position of DIR field.
	TIM_TIM1_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_TIM1_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_TIM1_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_TIM1_CR1_DIR_B_0x0 = 0x0
	// Counter used as downcounter
	TIM_TIM1_CR1_DIR_B_0x1 = 0x1
	// Position of CMS field.
	TIM_TIM1_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_TIM1_CR1_CMS_Msk = 0x60
	// Edge-aligned mode. The counter counts up or down depending on the direction bit (DIR).
	TIM_TIM1_CR1_CMS_B_0x0 = 0x0
	// Center-aligned mode 1. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set only when the counter is counting down.
	TIM_TIM1_CR1_CMS_B_0x1 = 0x1
	// Center-aligned mode 2. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set only when the counter is counting up.
	TIM_TIM1_CR1_CMS_B_0x2 = 0x2
	// Center-aligned mode 3. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set both when the counter is counting up or down.
	TIM_TIM1_CR1_CMS_B_0x3 = 0x3
	// Position of ARPE field.
	TIM_TIM1_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_TIM1_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_TIM1_CR1_ARPE = 0x80
	// TIMx_ARR register is not buffered
	TIM_TIM1_CR1_ARPE_B_0x0 = 0x0
	// TIMx_ARR register is buffered
	TIM_TIM1_CR1_ARPE_B_0x1 = 0x1
	// Position of CKD field.
	TIM_TIM1_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_TIM1_CR1_CKD_Msk = 0x300
	// tDTS=tCK_INT
	TIM_TIM1_CR1_CKD_B_0x0 = 0x0
	// tDTS=2*tCK_INT
	TIM_TIM1_CR1_CKD_B_0x1 = 0x1
	// tDTS=4*tCK_INT
	TIM_TIM1_CR1_CKD_B_0x2 = 0x2
	// Reserved, do not program this value
	TIM_TIM1_CR1_CKD_B_0x3 = 0x3
	// Position of UIFREMAP field.
	TIM_TIM1_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_TIM1_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIM_TIM1_CR1_UIFREMAP = 0x800
	// No remapping. UIF status bit is not copied to TIMx_CNT register bit 31.
	TIM_TIM1_CR1_UIFREMAP_B_0x0 = 0x0
	// Remapping enabled. UIF status bit is copied to TIMx_CNT register bit 31.
	TIM_TIM1_CR1_UIFREMAP_B_0x1 = 0x1

	// TIM1_CR2: control register 2
	// Position of CCPC field.
	TIM_TIM1_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_TIM1_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_TIM1_CR2_CCPC = 0x1
	// CCxE, CCxNE and OCxM bits are not preloaded
	TIM_TIM1_CR2_CCPC_B_0x0 = 0x0
	// CCxE, CCxNE and OCxM bits are preloaded, after having been written, they are updated only when a commutation event (COM) occurs (COMG bit set or rising edge detected on TRGI, depending on the CCUS bit).
	TIM_TIM1_CR2_CCPC_B_0x1 = 0x1
	// Position of CCUS field.
	TIM_TIM1_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_TIM1_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_TIM1_CR2_CCUS = 0x4
	// When capture/compare control bits are preloaded (CCPC=1), they are updated by setting the COMG bit only
	TIM_TIM1_CR2_CCUS_B_0x0 = 0x0
	// When capture/compare control bits are preloaded (CCPC=1), they are updated by setting the COMG bit or when an rising edge occurs on TRGI
	TIM_TIM1_CR2_CCUS_B_0x1 = 0x1
	// Position of CCDS field.
	TIM_TIM1_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_TIM1_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_TIM1_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_TIM1_CR2_CCDS_B_0x0 = 0x0
	// CCx DMA requests sent when update event occurs
	TIM_TIM1_CR2_CCDS_B_0x1 = 0x1
	// Position of MMS field.
	TIM_TIM1_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_TIM1_CR2_MMS_Msk = 0x70
	// Reset - the UG bit from the TIMx_EGR register is used as trigger output (TRGO). If the reset is generated by the trigger input (slave mode controller configured in reset mode) then the signal on TRGO is delayed compared to the actual reset.
	TIM_TIM1_CR2_MMS_B_0x0 = 0x0
	// Enable - the Counter Enable signal CNT_EN is used as trigger output (TRGO). It is useful to start several timers at the same time or to control a window in which a slave timer is enable. The Counter Enable signal is generated by a logic AND between CEN control bit and the trigger input when configured in gated mode. When the Counter Enable signal is controlled by the trigger input, there is a delay on TRGO, except if the master/slave mode is selected (see the MSM bit description in TIMx_SMCR register).
	TIM_TIM1_CR2_MMS_B_0x1 = 0x1
	// Update - The update event is selected as trigger output (TRGO). For instance a master timer can then be used as a prescaler for a slave timer.
	TIM_TIM1_CR2_MMS_B_0x2 = 0x2
	// Compare Pulse - The trigger output send a positive pulse when the CC1IF flag is to be set (even if it was already high), as soon as a capture or a compare match occurred. (TRGO).
	TIM_TIM1_CR2_MMS_B_0x3 = 0x3
	// Compare - OC1REFC signal is used as trigger output (TRGO)
	TIM_TIM1_CR2_MMS_B_0x4 = 0x4
	// Compare - OC2REFC signal is used as trigger output (TRGO)
	TIM_TIM1_CR2_MMS_B_0x5 = 0x5
	// Compare - OC3REFC signal is used as trigger output (TRGO)
	TIM_TIM1_CR2_MMS_B_0x6 = 0x6
	// Compare - OC4REFC signal is used as trigger output (TRGO)
	TIM_TIM1_CR2_MMS_B_0x7 = 0x7
	// Position of TI1S field.
	TIM_TIM1_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_TIM1_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_TIM1_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_TIM1_CR2_TI1S_B_0x0 = 0x0
	// The TIMx_CH1, CH2 and CH3 pins are connected to the TI1 input (XOR combination)
	TIM_TIM1_CR2_TI1S_B_0x1 = 0x1
	// Position of OIS1 field.
	TIM_TIM1_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_TIM1_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_TIM1_CR2_OIS1 = 0x100
	// OC1=0 (after a dead-time if OC1N is implemented) when MOE=0
	TIM_TIM1_CR2_OIS1_B_0x0 = 0x0
	// OC1=1 (after a dead-time if OC1N is implemented) when MOE=0
	TIM_TIM1_CR2_OIS1_B_0x1 = 0x1
	// Position of OIS1N field.
	TIM_TIM1_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_TIM1_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_TIM1_CR2_OIS1N = 0x200
	// OC1N=0 after a dead-time when MOE=0
	TIM_TIM1_CR2_OIS1N_B_0x0 = 0x0
	// OC1N=1 after a dead-time when MOE=0
	TIM_TIM1_CR2_OIS1N_B_0x1 = 0x1
	// Position of OIS2 field.
	TIM_TIM1_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_TIM1_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_TIM1_CR2_OIS2 = 0x400
	// Position of OIS2N field.
	TIM_TIM1_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_TIM1_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_TIM1_CR2_OIS2N = 0x800
	// Position of OIS3 field.
	TIM_TIM1_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_TIM1_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_TIM1_CR2_OIS3 = 0x1000
	// Position of OIS3N field.
	TIM_TIM1_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_TIM1_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_TIM1_CR2_OIS3N = 0x2000
	// Position of OIS4 field.
	TIM_TIM1_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_TIM1_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_TIM1_CR2_OIS4 = 0x4000
	// Position of OIS5 field.
	TIM_TIM1_CR2_OIS5_Pos = 0x10
	// Bit mask of OIS5 field.
	TIM_TIM1_CR2_OIS5_Msk = 0x10000
	// Bit OIS5.
	TIM_TIM1_CR2_OIS5 = 0x10000
	// Position of OIS6 field.
	TIM_TIM1_CR2_OIS6_Pos = 0x12
	// Bit mask of OIS6 field.
	TIM_TIM1_CR2_OIS6_Msk = 0x40000
	// Bit OIS6.
	TIM_TIM1_CR2_OIS6 = 0x40000
	// Position of MMS2 field.
	TIM_TIM1_CR2_MMS2_Pos = 0x14
	// Bit mask of MMS2 field.
	TIM_TIM1_CR2_MMS2_Msk = 0xf00000
	// Reset - the UG bit from the TIMx_EGR register is used as trigger output (TRGO2). If the reset is generated by the trigger input (slave mode controller configured in reset mode), the signal on TRGO2 is delayed compared to the actual reset.
	TIM_TIM1_CR2_MMS2_B_0x0 = 0x0
	// Enable - the Counter Enable signal CNT_EN is used as trigger output (TRGO2). It is useful to start several timers at the same time or to control a window in which a slave timer is enabled. The Counter Enable signal is generated by a logic AND between the CEN control bit and the trigger input when configured in Gated mode. When the Counter Enable signal is controlled by the trigger input, there is a delay on TRGO2, except if the Master/Slave mode is selected (see the MSM bit description in TIMx_SMCR register).
	TIM_TIM1_CR2_MMS2_B_0x1 = 0x1
	// Update - the update event is selected as trigger output (TRGO2). For instance, a master timer can then be used as a prescaler for a slave timer.
	TIM_TIM1_CR2_MMS2_B_0x2 = 0x2
	// Compare pulse - the trigger output sends a positive pulse when the CC1IF flag is to be set (even if it was already high), as soon as a capture or compare match occurs (TRGO2).
	TIM_TIM1_CR2_MMS2_B_0x3 = 0x3
	// Compare - OC1REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x4 = 0x4
	// Compare - OC2REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x5 = 0x5
	// Compare - OC3REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x6 = 0x6
	// Compare - OC4REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x7 = 0x7
	// Compare - OC5REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x8 = 0x8
	// Compare - OC6REFC signal is used as trigger output (TRGO2)
	TIM_TIM1_CR2_MMS2_B_0x9 = 0x9
	// Compare Pulse - OC4REFC rising or falling edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xA = 0xa
	// Compare Pulse - OC6REFC rising or falling edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xB = 0xb
	// Compare Pulse - OC4REFC or OC6REFC rising edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xC = 0xc
	// Compare Pulse - OC4REFC rising or OC6REFC falling edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xD = 0xd
	// Compare Pulse - OC5REFC or OC6REFC rising edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xE = 0xe
	// Compare Pulse - OC5REFC rising or OC6REFC falling edges generate pulses on TRGO2
	TIM_TIM1_CR2_MMS2_B_0xF = 0xf

	// TIM1_SMCR: slave mode control register
	// Position of SMS1 field.
	TIM_TIM1_SMCR_SMS1_Pos = 0x0
	// Bit mask of SMS1 field.
	TIM_TIM1_SMCR_SMS1_Msk = 0x7
	// Slave mode disabled - if CEN = '1â then the prescaler is clocked directly by the internal clock.
	TIM_TIM1_SMCR_SMS1_B_0x0 = 0x0
	// Encoder mode 1 - Counter counts up/down on TI1FP1 edge depending on TI2FP2 level.
	TIM_TIM1_SMCR_SMS1_B_0x1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI2FP2 edge depending on TI1FP1 level.
	TIM_TIM1_SMCR_SMS1_B_0x2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_TIM1_SMCR_SMS1_B_0x3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_TIM1_SMCR_SMS1_B_0x4 = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_TIM1_SMCR_SMS1_B_0x5 = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_TIM1_SMCR_SMS1_B_0x6 = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_TIM1_SMCR_SMS1_B_0x7 = 0x7
	// Combined reset + trigger mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter, generates an update of the registers and starts the counter.Codes above 1000: Reserved.
	TIM_TIM1_SMCR_SMS1_B_0x8 = 0x8
	// Position of OCCS field.
	TIM_TIM1_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	TIM_TIM1_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	TIM_TIM1_SMCR_OCCS = 0x8
	// OCREF_CLR_INT is connected to COMP1 or COMP2 output depending on TIM1_OR1.OCREF_CLR
	TIM_TIM1_SMCR_OCCS_B_0x0 = 0x0
	// OCREF_CLR_INT is connected to ETRF
	TIM_TIM1_SMCR_OCCS_B_0x1 = 0x1
	// Position of TS1 field.
	TIM_TIM1_SMCR_TS1_Pos = 0x4
	// Bit mask of TS1 field.
	TIM_TIM1_SMCR_TS1_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_TIM1_SMCR_TS1_B_0x0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_TIM1_SMCR_TS1_B_0x1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_TIM1_SMCR_TS1_B_0x2 = 0x2
	// Internal Trigger 3 (ITR3)
	TIM_TIM1_SMCR_TS1_B_0x3 = 0x3
	// TI1 Edge Detector (TI1F_ED)
	TIM_TIM1_SMCR_TS1_B_0x4 = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_TIM1_SMCR_TS1_B_0x5 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_TIM1_SMCR_TS1_B_0x6 = 0x6
	// External Trigger input (ETRF)
	TIM_TIM1_SMCR_TS1_B_0x7 = 0x7
	// Position of MSM field.
	TIM_TIM1_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_TIM1_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_TIM1_SMCR_MSM = 0x80
	// No action
	TIM_TIM1_SMCR_MSM_B_0x0 = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_TIM1_SMCR_MSM_B_0x1 = 0x1
	// Position of ETF field.
	TIM_TIM1_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_TIM1_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_TIM1_SMCR_ETF_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_TIM1_SMCR_ETF_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_TIM1_SMCR_ETF_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_TIM1_SMCR_ETF_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_TIM1_SMCR_ETF_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_TIM1_SMCR_ETF_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_TIM1_SMCR_ETF_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_TIM1_SMCR_ETF_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_TIM1_SMCR_ETF_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_TIM1_SMCR_ETF_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_TIM1_SMCR_ETF_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_TIM1_SMCR_ETF_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_TIM1_SMCR_ETF_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_TIM1_SMCR_ETF_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_TIM1_SMCR_ETF_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_TIM1_SMCR_ETF_B_0xF = 0xf
	// Position of ETPS field.
	TIM_TIM1_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_TIM1_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_TIM1_SMCR_ETPS_B_0x0 = 0x0
	// ETRP frequency divided by 2
	TIM_TIM1_SMCR_ETPS_B_0x1 = 0x1
	// ETRP frequency divided by 4
	TIM_TIM1_SMCR_ETPS_B_0x2 = 0x2
	// ETRP frequency divided by 8
	TIM_TIM1_SMCR_ETPS_B_0x3 = 0x3
	// Position of ECE field.
	TIM_TIM1_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_TIM1_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_TIM1_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_TIM1_SMCR_ECE_B_0x0 = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_TIM1_SMCR_ECE_B_0x1 = 0x1
	// Position of ETP field.
	TIM_TIM1_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_TIM1_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_TIM1_SMCR_ETP = 0x8000
	// ETR is non-inverted, active at high level or rising edge.
	TIM_TIM1_SMCR_ETP_B_0x0 = 0x0
	// ETR is inverted, active at low level or falling edge.
	TIM_TIM1_SMCR_ETP_B_0x1 = 0x1
	// Position of SMS2 field.
	TIM_TIM1_SMCR_SMS2_Pos = 0x10
	// Bit mask of SMS2 field.
	TIM_TIM1_SMCR_SMS2_Msk = 0x10000
	// Bit SMS2.
	TIM_TIM1_SMCR_SMS2 = 0x10000
	// Slave mode disabled - if CEN = '1â then the prescaler is clocked directly by the internal clock.
	TIM_TIM1_SMCR_SMS2_B_0x0 = 0x0
	// Encoder mode 1 - Counter counts up/down on TI1FP1 edge depending on TI2FP2 level.
	TIM_TIM1_SMCR_SMS2_B_0x1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI2FP2 edge depending on TI1FP1 level.
	TIM_TIM1_SMCR_SMS2_B_0x2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_TIM1_SMCR_SMS2_B_0x3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_TIM1_SMCR_SMS2_B_0x4 = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_TIM1_SMCR_SMS2_B_0x5 = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_TIM1_SMCR_SMS2_B_0x6 = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_TIM1_SMCR_SMS2_B_0x7 = 0x7
	// Combined reset + trigger mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter, generates an update of the registers and starts the counter.Codes above 1000: Reserved.
	TIM_TIM1_SMCR_SMS2_B_0x8 = 0x8
	// Position of TS2 field.
	TIM_TIM1_SMCR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	TIM_TIM1_SMCR_TS2_Msk = 0x300000
	// Internal Trigger 0 (ITR0)
	TIM_TIM1_SMCR_TS2_B_0x0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_TIM1_SMCR_TS2_B_0x1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_TIM1_SMCR_TS2_B_0x2 = 0x2
	// Internal Trigger 3 (ITR3)
	TIM_TIM1_SMCR_TS2_B_0x3 = 0x3
	// TI1 Edge Detector (TI1F_ED)
	TIM_TIM1_SMCR_TS2_B_0x4 = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_TIM1_SMCR_TS2_B_0x5 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_TIM1_SMCR_TS2_B_0x6 = 0x6
	// External Trigger input (ETRF)
	TIM_TIM1_SMCR_TS2_B_0x7 = 0x7

	// TIM1_DIER: DMA/Interrupt enable register
	// Position of UIE field.
	TIM_TIM1_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_TIM1_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_TIM1_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_TIM1_DIER_UIE_B_0x0 = 0x0
	// Update interrupt enabled
	TIM_TIM1_DIER_UIE_B_0x1 = 0x1
	// Position of CC1IE field.
	TIM_TIM1_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_TIM1_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_TIM1_DIER_CC1IE = 0x2
	// CC1 interrupt disabled
	TIM_TIM1_DIER_CC1IE_B_0x0 = 0x0
	// CC1 interrupt enabled
	TIM_TIM1_DIER_CC1IE_B_0x1 = 0x1
	// Position of CC2IE field.
	TIM_TIM1_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_TIM1_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_TIM1_DIER_CC2IE = 0x4
	// CC2 interrupt disabled
	TIM_TIM1_DIER_CC2IE_B_0x0 = 0x0
	// CC2 interrupt enabled
	TIM_TIM1_DIER_CC2IE_B_0x1 = 0x1
	// Position of CC3IE field.
	TIM_TIM1_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_TIM1_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_TIM1_DIER_CC3IE = 0x8
	// CC3 interrupt disabled
	TIM_TIM1_DIER_CC3IE_B_0x0 = 0x0
	// CC3 interrupt enabled
	TIM_TIM1_DIER_CC3IE_B_0x1 = 0x1
	// Position of CC4IE field.
	TIM_TIM1_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_TIM1_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_TIM1_DIER_CC4IE = 0x10
	// CC4 interrupt disabled
	TIM_TIM1_DIER_CC4IE_B_0x0 = 0x0
	// CC4 interrupt enabled
	TIM_TIM1_DIER_CC4IE_B_0x1 = 0x1
	// Position of COMIE field.
	TIM_TIM1_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_TIM1_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_TIM1_DIER_COMIE = 0x20
	// COM interrupt disabled
	TIM_TIM1_DIER_COMIE_B_0x0 = 0x0
	// COM interrupt enabled
	TIM_TIM1_DIER_COMIE_B_0x1 = 0x1
	// Position of TIE field.
	TIM_TIM1_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_TIM1_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_TIM1_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_TIM1_DIER_TIE_B_0x0 = 0x0
	// Trigger interrupt enabled
	TIM_TIM1_DIER_TIE_B_0x1 = 0x1
	// Position of BIE field.
	TIM_TIM1_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_TIM1_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_TIM1_DIER_BIE = 0x80
	// Break interrupt disabled
	TIM_TIM1_DIER_BIE_B_0x0 = 0x0
	// Break interrupt enabled
	TIM_TIM1_DIER_BIE_B_0x1 = 0x1
	// Position of UDE field.
	TIM_TIM1_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_TIM1_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_TIM1_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_TIM1_DIER_UDE_B_0x0 = 0x0
	// Update DMA request enabled
	TIM_TIM1_DIER_UDE_B_0x1 = 0x1
	// Position of CC1DE field.
	TIM_TIM1_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_TIM1_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_TIM1_DIER_CC1DE = 0x200
	// CC1 DMA request disabled
	TIM_TIM1_DIER_CC1DE_B_0x0 = 0x0
	// CC1 DMA request enabled
	TIM_TIM1_DIER_CC1DE_B_0x1 = 0x1
	// Position of CC2DE field.
	TIM_TIM1_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_TIM1_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_TIM1_DIER_CC2DE = 0x400
	// CC2 DMA request disabled
	TIM_TIM1_DIER_CC2DE_B_0x0 = 0x0
	// CC2 DMA request enabled
	TIM_TIM1_DIER_CC2DE_B_0x1 = 0x1
	// Position of CC3DE field.
	TIM_TIM1_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_TIM1_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_TIM1_DIER_CC3DE = 0x800
	// CC3 DMA request disabled
	TIM_TIM1_DIER_CC3DE_B_0x0 = 0x0
	// CC3 DMA request enabled
	TIM_TIM1_DIER_CC3DE_B_0x1 = 0x1
	// Position of CC4DE field.
	TIM_TIM1_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_TIM1_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_TIM1_DIER_CC4DE = 0x1000
	// CC4 DMA request disabled
	TIM_TIM1_DIER_CC4DE_B_0x0 = 0x0
	// CC4 DMA request enabled
	TIM_TIM1_DIER_CC4DE_B_0x1 = 0x1
	// Position of COMDE field.
	TIM_TIM1_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_TIM1_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_TIM1_DIER_COMDE = 0x2000
	// COM DMA request disabled
	TIM_TIM1_DIER_COMDE_B_0x0 = 0x0
	// COM DMA request enabled
	TIM_TIM1_DIER_COMDE_B_0x1 = 0x1
	// Position of TDE field.
	TIM_TIM1_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_TIM1_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_TIM1_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_TIM1_DIER_TDE_B_0x0 = 0x0
	// Trigger DMA request enabled
	TIM_TIM1_DIER_TDE_B_0x1 = 0x1

	// TIM1_SR: status register
	// Position of UIF field.
	TIM_TIM1_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_TIM1_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_TIM1_SR_UIF = 0x1
	// No update occurred.
	TIM_TIM1_SR_UIF_B_0x0 = 0x0
	// Update interrupt pending. This bit is set by hardware when the registers are updated:
	TIM_TIM1_SR_UIF_B_0x1 = 0x1
	// Position of CC1IF field.
	TIM_TIM1_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_TIM1_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_TIM1_SR_CC1IF = 0x2
	// No compare match / No input capture occurred
	TIM_TIM1_SR_CC1IF_B_0x0 = 0x0
	// A compare match or an input capture occurred.
	TIM_TIM1_SR_CC1IF_B_0x1 = 0x1
	// Position of CC2IF field.
	TIM_TIM1_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_TIM1_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_TIM1_SR_CC2IF = 0x4
	// Position of CC3IF field.
	TIM_TIM1_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_TIM1_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_TIM1_SR_CC3IF = 0x8
	// Position of CC4IF field.
	TIM_TIM1_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_TIM1_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_TIM1_SR_CC4IF = 0x10
	// Position of COMIF field.
	TIM_TIM1_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_TIM1_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_TIM1_SR_COMIF = 0x20
	// No COM event occurred.
	TIM_TIM1_SR_COMIF_B_0x0 = 0x0
	// COM interrupt pending.
	TIM_TIM1_SR_COMIF_B_0x1 = 0x1
	// Position of TIF field.
	TIM_TIM1_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_TIM1_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_TIM1_SR_TIF = 0x40
	// No trigger event occurred.
	TIM_TIM1_SR_TIF_B_0x0 = 0x0
	// Trigger interrupt pending.
	TIM_TIM1_SR_TIF_B_0x1 = 0x1
	// Position of BIF field.
	TIM_TIM1_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_TIM1_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_TIM1_SR_BIF = 0x80
	// No break event occurred.
	TIM_TIM1_SR_BIF_B_0x0 = 0x0
	// An active level has been detected on the break input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_TIM1_SR_BIF_B_0x1 = 0x1
	// Position of B2IF field.
	TIM_TIM1_SR_B2IF_Pos = 0x8
	// Bit mask of B2IF field.
	TIM_TIM1_SR_B2IF_Msk = 0x100
	// Bit B2IF.
	TIM_TIM1_SR_B2IF = 0x100
	// No break event occurred.
	TIM_TIM1_SR_B2IF_B_0x0 = 0x0
	// An active level has been detected on the break 2 input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_TIM1_SR_B2IF_B_0x1 = 0x1
	// Position of CC1OF field.
	TIM_TIM1_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_TIM1_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_TIM1_SR_CC1OF = 0x200
	// No overcapture has been detected.
	TIM_TIM1_SR_CC1OF_B_0x0 = 0x0
	// The counter value has been captured in TIMx_CCR1 register while CC1IF flag was already set
	TIM_TIM1_SR_CC1OF_B_0x1 = 0x1
	// Position of CC2OF field.
	TIM_TIM1_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_TIM1_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_TIM1_SR_CC2OF = 0x400
	// Position of CC3OF field.
	TIM_TIM1_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_TIM1_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_TIM1_SR_CC3OF = 0x800
	// Position of CC4OF field.
	TIM_TIM1_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_TIM1_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_TIM1_SR_CC4OF = 0x1000
	// Position of SBIF field.
	TIM_TIM1_SR_SBIF_Pos = 0xd
	// Bit mask of SBIF field.
	TIM_TIM1_SR_SBIF_Msk = 0x2000
	// Bit SBIF.
	TIM_TIM1_SR_SBIF = 0x2000
	// No break event occurred.
	TIM_TIM1_SR_SBIF_B_0x0 = 0x0
	// An active level has been detected on the system break input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_TIM1_SR_SBIF_B_0x1 = 0x1
	// Position of CC5IF field.
	TIM_TIM1_SR_CC5IF_Pos = 0x10
	// Bit mask of CC5IF field.
	TIM_TIM1_SR_CC5IF_Msk = 0x10000
	// Bit CC5IF.
	TIM_TIM1_SR_CC5IF = 0x10000
	// Position of CC6IF field.
	TIM_TIM1_SR_CC6IF_Pos = 0x11
	// Bit mask of CC6IF field.
	TIM_TIM1_SR_CC6IF_Msk = 0x20000
	// Bit CC6IF.
	TIM_TIM1_SR_CC6IF = 0x20000

	// TIM1_EGR: event generation register
	// Position of UG field.
	TIM_TIM1_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_TIM1_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_TIM1_EGR_UG = 0x1
	// No action
	TIM_TIM1_EGR_UG_B_0x0 = 0x0
	// Reinitialize the counter and generates an update of the registers. The prescaler internal counter is also cleared (the prescaler ratio is not affected). The counter is cleared if the center-aligned mode is selected or if DIR=0 (upcounting), else it takes the auto-reload value (TIMx_ARR) if DIR=1 (downcounting).
	TIM_TIM1_EGR_UG_B_0x1 = 0x1
	// Position of CC1G field.
	TIM_TIM1_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_TIM1_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_TIM1_EGR_CC1G = 0x2
	// No action
	TIM_TIM1_EGR_CC1G_B_0x0 = 0x0
	// A capture/compare event is generated on channel 1:
	TIM_TIM1_EGR_CC1G_B_0x1 = 0x1
	// Position of CC2G field.
	TIM_TIM1_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_TIM1_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_TIM1_EGR_CC2G = 0x4
	// Position of CC3G field.
	TIM_TIM1_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_TIM1_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_TIM1_EGR_CC3G = 0x8
	// Position of CC4G field.
	TIM_TIM1_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_TIM1_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_TIM1_EGR_CC4G = 0x10
	// Position of COMG field.
	TIM_TIM1_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_TIM1_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_TIM1_EGR_COMG = 0x20
	// No action
	TIM_TIM1_EGR_COMG_B_0x0 = 0x0
	// When CCPC bit is set, it allows CCxE, CCxNE and OCxM bits to be updated.
	TIM_TIM1_EGR_COMG_B_0x1 = 0x1
	// Position of TG field.
	TIM_TIM1_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_TIM1_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_TIM1_EGR_TG = 0x40
	// No action
	TIM_TIM1_EGR_TG_B_0x0 = 0x0
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_TIM1_EGR_TG_B_0x1 = 0x1
	// Position of BG field.
	TIM_TIM1_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_TIM1_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_TIM1_EGR_BG = 0x80
	// No action
	TIM_TIM1_EGR_BG_B_0x0 = 0x0
	// A break event is generated. MOE bit is cleared and BIF flag is set. Related interrupt or DMA transfer can occur if enabled.
	TIM_TIM1_EGR_BG_B_0x1 = 0x1
	// Position of B2G field.
	TIM_TIM1_EGR_B2G_Pos = 0x8
	// Bit mask of B2G field.
	TIM_TIM1_EGR_B2G_Msk = 0x100
	// Bit B2G.
	TIM_TIM1_EGR_B2G = 0x100
	// No action
	TIM_TIM1_EGR_B2G_B_0x0 = 0x0
	// A break 2 event is generated. MOE bit is cleared and B2IF flag is set. Related interrupt can occur if enabled.
	TIM_TIM1_EGR_B2G_B_0x1 = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_B_0x0 = 0x0
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Output_CC1S_B_0x1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Output_CC1S_B_0x2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Output_CC1S_B_0x3 = 0x3
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// CC1 behaves normally depending on counter and CCR1 values even when the trigger is ON. The minimum delay to activate CC1 output when an edge occurs on the trigger input is 5 clock cycles.
	TIM_CCMR1_Output_OC1FE_B_0x0 = 0x0
	// An active edge on the trigger input acts like a compare match on CC1 output. Then, OC is set to the compare level independently from the result of the comparison. Delay to sample the trigger input and to activate CC1 output is reduced to 3 clock cycles. OCFE acts only if the channel is configured in PWM1 or PWM2 mode.
	TIM_CCMR1_Output_OC1FE_B_0x1 = 0x1
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on TIMx_CCR1 disabled. TIMx_CCR1 can be written at anytime, the new value is taken in account immediately.
	TIM_CCMR1_Output_OC1PE_B_0x0 = 0x0
	// Preload register on TIMx_CCR1 enabled. Read/Write operations access the preload register. TIMx_CCR1 preload value is loaded in the active register at each update event.
	TIM_CCMR1_Output_OC1PE_B_0x1 = 0x1
	// Position of OC1M1 field.
	TIM_CCMR1_Output_OC1M1_Pos = 0x4
	// Bit mask of OC1M1 field.
	TIM_CCMR1_Output_OC1M1_Msk = 0x70
	// Frozen - The comparison between the output compare register TIMx_CCR1 and the counter TIMx_CNT has no effect on the outputs.(this mode is used to generate a timing base).
	TIM_CCMR1_Output_OC1M1_B_0x0 = 0x0
	// Set channel 1 to active level on match. OC1REF signal is forced high when the counter TIMx_CNT matches the capture/compare register 1 (TIMx_CCR1).
	TIM_CCMR1_Output_OC1M1_B_0x1 = 0x1
	// Set channel 1 to inactive level on match. OC1REF signal is forced low when the counter TIMx_CNT matches the capture/compare register 1 (TIMx_CCR1).
	TIM_CCMR1_Output_OC1M1_B_0x2 = 0x2
	// Toggle - OC1REF toggles when TIMx_CNT=TIMx_CCR1.
	TIM_CCMR1_Output_OC1M1_B_0x3 = 0x3
	// Force inactive level - OC1REF is forced low.
	TIM_CCMR1_Output_OC1M1_B_0x4 = 0x4
	// Force active level - OC1REF is forced high.
	TIM_CCMR1_Output_OC1M1_B_0x5 = 0x5
	// PWM mode 1 - In upcounting, channel 1 is active as long as TIMx_CNT<TIMx_CCR1 else inactive. In downcounting, channel 1 is inactive (OC1REF='0â) as long as TIMx_CNT>TIMx_CCR1 else active (OC1REF=â1â).
	TIM_CCMR1_Output_OC1M1_B_0x6 = 0x6
	// PWM mode 2 - In upcounting, channel 1 is inactive as long as TIMx_CNT<TIMx_CCR1 else active. In downcounting, channel 1 is active as long as TIMx_CNT>TIMx_CCR1 else inactive.
	TIM_CCMR1_Output_OC1M1_B_0x7 = 0x7
	// Retrigerrable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes active again at the next update. In down-counting mode, the channel is inactive until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes inactive again at the next update.
	TIM_CCMR1_Output_OC1M1_B_0x8 = 0x8
	// Retrigerrable OPM mode 2 - In up-counting mode, the channel is inactive until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 2 and the channels becomes inactive again at the next update. In down-counting mode, the channel is active until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes active again at the next update.
	TIM_CCMR1_Output_OC1M1_B_0x9 = 0x9
	// Combined PWM mode 1 - OC1REF has the same behavior as in PWM mode 1. OC1REFC is the logical OR between OC1REF and OC2REF.
	TIM_CCMR1_Output_OC1M1_B_0xC = 0xc
	// Combined PWM mode 2 - OC1REF has the same behavior as in PWM mode 2. OC1REFC is the logical AND between OC1REF and OC2REF.
	TIM_CCMR1_Output_OC1M1_B_0xD = 0xd
	// Asymmetric PWM mode 1 - OC1REF has the same behavior as in PWM mode 1. OC1REFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down.
	TIM_CCMR1_Output_OC1M1_B_0xE = 0xe
	// Asymmetric PWM mode 2 - OC1REF has the same behavior as in PWM mode 2. OC1REFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down.
	TIM_CCMR1_Output_OC1M1_B_0xF = 0xf
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// OC1Ref is not affected by the ocref_clr_int signal
	TIM_CCMR1_Output_OC1CE_B_0x0 = 0x0
	// OC1Ref is cleared as soon as a High level is detected on ocref_clr_int signal (OCREF_CLR input or ETRF input)
	TIM_CCMR1_Output_OC1CE_B_0x1 = 0x1
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_B_0x0 = 0x0
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Output_CC2S_B_0x1 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Output_CC2S_B_0x2 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC. This mode is working only if an internal trigger input is selected through the TS bit (TIMx_SMCR register)
	TIM_CCMR1_Output_CC2S_B_0x3 = 0x3
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Position of OC2M1 field.
	TIM_CCMR1_Output_OC2M1_Pos = 0xc
	// Bit mask of OC2M1 field.
	TIM_CCMR1_Output_OC2M1_Msk = 0x7000
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC1M2 field.
	TIM_CCMR1_Output_OC1M2_Pos = 0x10
	// Bit mask of OC1M2 field.
	TIM_CCMR1_Output_OC1M2_Msk = 0x10000
	// Bit OC1M2.
	TIM_CCMR1_Output_OC1M2 = 0x10000
	// Frozen - The comparison between the output compare register TIMx_CCR1 and the counter TIMx_CNT has no effect on the outputs.(this mode is used to generate a timing base).
	TIM_CCMR1_Output_OC1M2_B_0x0 = 0x0
	// Set channel 1 to active level on match. OC1REF signal is forced high when the counter TIMx_CNT matches the capture/compare register 1 (TIMx_CCR1).
	TIM_CCMR1_Output_OC1M2_B_0x1 = 0x1
	// Set channel 1 to inactive level on match. OC1REF signal is forced low when the counter TIMx_CNT matches the capture/compare register 1 (TIMx_CCR1).
	TIM_CCMR1_Output_OC1M2_B_0x2 = 0x2
	// Toggle - OC1REF toggles when TIMx_CNT=TIMx_CCR1.
	TIM_CCMR1_Output_OC1M2_B_0x3 = 0x3
	// Force inactive level - OC1REF is forced low.
	TIM_CCMR1_Output_OC1M2_B_0x4 = 0x4
	// Force active level - OC1REF is forced high.
	TIM_CCMR1_Output_OC1M2_B_0x5 = 0x5
	// PWM mode 1 - In upcounting, channel 1 is active as long as TIMx_CNT<TIMx_CCR1 else inactive. In downcounting, channel 1 is inactive (OC1REF='0â) as long as TIMx_CNT>TIMx_CCR1 else active (OC1REF=â1â).
	TIM_CCMR1_Output_OC1M2_B_0x6 = 0x6
	// PWM mode 2 - In upcounting, channel 1 is inactive as long as TIMx_CNT<TIMx_CCR1 else active. In downcounting, channel 1 is active as long as TIMx_CNT>TIMx_CCR1 else inactive.
	TIM_CCMR1_Output_OC1M2_B_0x7 = 0x7
	// Retrigerrable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes active again at the next update. In down-counting mode, the channel is inactive until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes inactive again at the next update.
	TIM_CCMR1_Output_OC1M2_B_0x8 = 0x8
	// Retrigerrable OPM mode 2 - In up-counting mode, the channel is inactive until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 2 and the channels becomes inactive again at the next update. In down-counting mode, the channel is active until a trigger event is detected (on TRGI signal). Then, a comparison is performed as in PWM mode 1 and the channels becomes active again at the next update.
	TIM_CCMR1_Output_OC1M2_B_0x9 = 0x9
	// Combined PWM mode 1 - OC1REF has the same behavior as in PWM mode 1. OC1REFC is the logical OR between OC1REF and OC2REF.
	TIM_CCMR1_Output_OC1M2_B_0xC = 0xc
	// Combined PWM mode 2 - OC1REF has the same behavior as in PWM mode 2. OC1REFC is the logical AND between OC1REF and OC2REF.
	TIM_CCMR1_Output_OC1M2_B_0xD = 0xd
	// Asymmetric PWM mode 1 - OC1REF has the same behavior as in PWM mode 1. OC1REFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down.
	TIM_CCMR1_Output_OC1M2_B_0xE = 0xe
	// Asymmetric PWM mode 2 - OC1REF has the same behavior as in PWM mode 2. OC1REFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down.
	TIM_CCMR1_Output_OC1M2_B_0xF = 0xf
	// Position of OC2M2 field.
	TIM_CCMR1_Output_OC2M2_Pos = 0x18
	// Bit mask of OC2M2 field.
	TIM_CCMR1_Output_OC2M2_Msk = 0x1000000
	// Bit OC2M2.
	TIM_CCMR1_Output_OC2M2 = 0x1000000

	// CCMR1_Input: capture/compare mode register 1 (output mode)
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Input_CC1S_B_0x0 = 0x0
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_B_0x1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_B_0x2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Input_CC1S_B_0x3 = 0x3
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// no prescaler, capture is done each time an edge is detected on the capture input
	TIM_CCMR1_Input_IC1PSC_B_0x0 = 0x0
	// capture is done once every 2 events
	TIM_CCMR1_Input_IC1PSC_B_0x1 = 0x1
	// capture is done once every 4 events
	TIM_CCMR1_Input_IC1PSC_B_0x2 = 0x2
	// capture is done once every 8 events
	TIM_CCMR1_Input_IC1PSC_B_0x3 = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_B_0xF = 0xf
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Input_CC2S_B_0x0 = 0x0
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_B_0x1 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_B_0x2 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Input_CC2S_B_0x3 = 0x3
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_B_0x0 = 0x0
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Output_CC3S_B_0x1 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Output_CC3S_B_0x2 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Output_CC3S_B_0x3 = 0x3
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Position of OC3M1 field.
	TIM_CCMR2_Output_OC3M1_Pos = 0x4
	// Bit mask of OC3M1 field.
	TIM_CCMR2_Output_OC3M1_Msk = 0x70
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_B_0x0 = 0x0
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Output_CC4S_B_0x1 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Output_CC4S_B_0x2 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Output_CC4S_B_0x3 = 0x3
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Position of OC4M1 field.
	TIM_CCMR2_Output_OC4M1_Pos = 0xc
	// Bit mask of OC4M1 field.
	TIM_CCMR2_Output_OC4M1_Msk = 0x7000
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC3M2 field.
	TIM_CCMR2_Output_OC3M2_Pos = 0x10
	// Bit mask of OC3M2 field.
	TIM_CCMR2_Output_OC3M2_Msk = 0x10000
	// Bit OC3M2.
	TIM_CCMR2_Output_OC3M2 = 0x10000
	// Position of OC4M2 field.
	TIM_CCMR2_Output_OC4M2_Pos = 0x18
	// Bit mask of OC4M2 field.
	TIM_CCMR2_Output_OC4M2_Msk = 0x1000000
	// Bit OC4M2.
	TIM_CCMR2_Output_OC4M2 = 0x1000000

	// CCMR2_Input: capture/compare mode register 2 (output mode)
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Input_CC3S_B_0x0 = 0x0
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_B_0x1 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_B_0x2 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Input_CC3S_B_0x3 = 0x3
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Input_CC4S_B_0x0 = 0x0
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_B_0x1 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_B_0x2 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Input_CC4S_B_0x3 = 0x3
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000

	// TIM1_CCER: capture/compare enable register
	// Position of CC1E field.
	TIM_TIM1_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_TIM1_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_TIM1_CCER_CC1E = 0x1
	// Capture mode disabled / OC1 is not active (see below)
	TIM_TIM1_CCER_CC1E_B_0x0 = 0x0
	// Capture mode enabled / OC1 signal is output on the corresponding output pin
	TIM_TIM1_CCER_CC1E_B_0x1 = 0x1
	// Position of CC1P field.
	TIM_TIM1_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_TIM1_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_TIM1_CCER_CC1P = 0x2
	// OC1 active high (output mode) / Edge sensitivity selection (input mode, see below)
	TIM_TIM1_CCER_CC1P_B_0x0 = 0x0
	// OC1 active low (output mode) / Edge sensitivity selection (input mode, see below)
	TIM_TIM1_CCER_CC1P_B_0x1 = 0x1
	// Position of CC1NE field.
	TIM_TIM1_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_TIM1_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_TIM1_CCER_CC1NE = 0x4
	// Off - OC1N is not active. OC1N level is then function of MOE, OSSI, OSSR, OIS1, OIS1N and CC1E bits.
	TIM_TIM1_CCER_CC1NE_B_0x0 = 0x0
	// On - OC1N signal is output on the corresponding output pin depending on MOE, OSSI, OSSR, OIS1, OIS1N and CC1E bits.
	TIM_TIM1_CCER_CC1NE_B_0x1 = 0x1
	// Position of CC1NP field.
	TIM_TIM1_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_TIM1_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_TIM1_CCER_CC1NP = 0x8
	// OC1N active high.
	TIM_TIM1_CCER_CC1NP_B_0x0 = 0x0
	// OC1N active low.
	TIM_TIM1_CCER_CC1NP_B_0x1 = 0x1
	// Position of CC2E field.
	TIM_TIM1_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_TIM1_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_TIM1_CCER_CC2E = 0x10
	// Position of CC2P field.
	TIM_TIM1_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_TIM1_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_TIM1_CCER_CC2P = 0x20
	// Position of CC2NE field.
	TIM_TIM1_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_TIM1_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_TIM1_CCER_CC2NE = 0x40
	// Position of CC2NP field.
	TIM_TIM1_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_TIM1_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_TIM1_CCER_CC2NP = 0x80
	// Position of CC3E field.
	TIM_TIM1_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_TIM1_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_TIM1_CCER_CC3E = 0x100
	// Position of CC3P field.
	TIM_TIM1_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_TIM1_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_TIM1_CCER_CC3P = 0x200
	// Position of CC3NE field.
	TIM_TIM1_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_TIM1_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_TIM1_CCER_CC3NE = 0x400
	// Position of CC3NP field.
	TIM_TIM1_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_TIM1_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_TIM1_CCER_CC3NP = 0x800
	// Position of CC4E field.
	TIM_TIM1_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_TIM1_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_TIM1_CCER_CC4E = 0x1000
	// Position of CC4P field.
	TIM_TIM1_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_TIM1_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_TIM1_CCER_CC4P = 0x2000
	// Position of CC4NP field.
	TIM_TIM1_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_TIM1_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_TIM1_CCER_CC4NP = 0x8000
	// Position of CC5E field.
	TIM_TIM1_CCER_CC5E_Pos = 0x10
	// Bit mask of CC5E field.
	TIM_TIM1_CCER_CC5E_Msk = 0x10000
	// Bit CC5E.
	TIM_TIM1_CCER_CC5E = 0x10000
	// Position of CC5P field.
	TIM_TIM1_CCER_CC5P_Pos = 0x11
	// Bit mask of CC5P field.
	TIM_TIM1_CCER_CC5P_Msk = 0x20000
	// Bit CC5P.
	TIM_TIM1_CCER_CC5P = 0x20000
	// Position of CC6E field.
	TIM_TIM1_CCER_CC6E_Pos = 0x14
	// Bit mask of CC6E field.
	TIM_TIM1_CCER_CC6E_Msk = 0x100000
	// Bit CC6E.
	TIM_TIM1_CCER_CC6E = 0x100000
	// Position of CC6P field.
	TIM_TIM1_CCER_CC6P_Pos = 0x15
	// Bit mask of CC6P field.
	TIM_TIM1_CCER_CC6P_Msk = 0x200000
	// Bit CC6P.
	TIM_TIM1_CCER_CC6P = 0x200000

	// TIM1_CNT: counter
	// Position of CNT field.
	TIM_TIM1_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_TIM1_CNT_CNT_Msk = 0xffff
	// Position of UIFCPY field.
	TIM_TIM1_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	TIM_TIM1_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	TIM_TIM1_CNT_UIFCPY = 0x80000000

	// TIM1_PSC: prescaler
	// Position of PSC field.
	TIM_TIM1_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_TIM1_PSC_PSC_Msk = 0xffff

	// TIM1_ARR: auto-reload register
	// Position of ARR field.
	TIM_TIM1_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_TIM1_ARR_ARR_Msk = 0xffff

	// TIM1_RCR: repetition counter register
	// Position of REP field.
	TIM_TIM1_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_TIM1_RCR_REP_Msk = 0xffff

	// TIM1_CCR1: capture/compare register 1
	// Position of CCR1 field.
	TIM_TIM1_CCR1_CCR1_Pos = 0x0
	// Bit mask of CCR1 field.
	TIM_TIM1_CCR1_CCR1_Msk = 0xffff

	// TIM1_CCR2: capture/compare register 2
	// Position of CCR2 field.
	TIM_TIM1_CCR2_CCR2_Pos = 0x0
	// Bit mask of CCR2 field.
	TIM_TIM1_CCR2_CCR2_Msk = 0xffff

	// TIM1_CCR3: capture/compare register 3
	// Position of CCR3 field.
	TIM_TIM1_CCR3_CCR3_Pos = 0x0
	// Bit mask of CCR3 field.
	TIM_TIM1_CCR3_CCR3_Msk = 0xffff

	// TIM1_CCR4: capture/compare register 4
	// Position of CCR4 field.
	TIM_TIM1_CCR4_CCR4_Pos = 0x0
	// Bit mask of CCR4 field.
	TIM_TIM1_CCR4_CCR4_Msk = 0xffff

	// TIM1_BDTR: break and dead-time register
	// Position of DTG field.
	TIM_TIM1_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_TIM1_BDTR_DTG_Msk = 0xff
	// Position of LOCK field.
	TIM_TIM1_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_TIM1_BDTR_LOCK_Msk = 0x300
	// LOCK OFF - No bit is write protected.
	TIM_TIM1_BDTR_LOCK_B_0x0 = 0x0
	// LOCK Level 1 = DTG bits in TIMx_BDTR register, OISx and OISxN bits in TIMx_CR2 register and BK2BID, BKBID, BK2DSRM, BKDSRM, BK2P, BK2E, BK2F[3:0], BKF[3:0], AOE, BKP, BKE, OSSI, OSSR and DTG[7:0] bits in TIMx_BDTR register can no longer be written.
	TIM_TIM1_BDTR_LOCK_B_0x1 = 0x1
	// LOCK Level 2 = LOCK Level 1 + CC Polarity bits (CCxP/CCxNP bits in TIMx_CCER register, as long as the related channel is configured in output through the CCxS bits) as well as OSSR and OSSI bits can no longer be written.
	TIM_TIM1_BDTR_LOCK_B_0x2 = 0x2
	// LOCK Level 3 = LOCK Level 2 + CC Control bits (OCxM and OCxPE bits in TIMx_CCMRx registers, as long as the related channel is configured in output through the CCxS bits) can no longer be written.
	TIM_TIM1_BDTR_LOCK_B_0x3 = 0x3
	// Position of OSSI field.
	TIM_TIM1_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_TIM1_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_TIM1_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled (the timer releases the output control which is taken over by the GPIO logic and which imposes a Hi-Z state).
	TIM_TIM1_BDTR_OSSI_B_0x0 = 0x0
	// When inactive, OC/OCN outputs are first forced with their inactive level then forced to their idle level after the deadtime. The timer maintains its control over the output.
	TIM_TIM1_BDTR_OSSI_B_0x1 = 0x1
	// Position of OSSR field.
	TIM_TIM1_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_TIM1_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_TIM1_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled (the timer releases the output control which is taken over by the GPIO logic, which forces a Hi-Z state).
	TIM_TIM1_BDTR_OSSR_B_0x0 = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level as soon as CCxE=1 or CCxNE=1 (the output is still controlled by the timer).
	TIM_TIM1_BDTR_OSSR_B_0x1 = 0x1
	// Position of BKE field.
	TIM_TIM1_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_TIM1_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_TIM1_BDTR_BKE = 0x1000
	// Break function disabled
	TIM_TIM1_BDTR_BKE_B_0x0 = 0x0
	// Break function enabled
	TIM_TIM1_BDTR_BKE_B_0x1 = 0x1
	// Position of BKP field.
	TIM_TIM1_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_TIM1_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_TIM1_BDTR_BKP = 0x2000
	// Break input BRK is active low
	TIM_TIM1_BDTR_BKP_B_0x0 = 0x0
	// Break input BRK is active high
	TIM_TIM1_BDTR_BKP_B_0x1 = 0x1
	// Position of AOE field.
	TIM_TIM1_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_TIM1_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_TIM1_BDTR_AOE = 0x4000
	// MOE can be set only by software
	TIM_TIM1_BDTR_AOE_B_0x0 = 0x0
	// MOE can be set by software or automatically at the next update event (if none of the break inputs BRK and BRK2 is active)
	TIM_TIM1_BDTR_AOE_B_0x1 = 0x1
	// Position of MOE field.
	TIM_TIM1_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_TIM1_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_TIM1_BDTR_MOE = 0x8000
	// In response to a break 2 event. OC and OCN outputs are disabled
	TIM_TIM1_BDTR_MOE_B_0x0 = 0x0
	// OC and OCN outputs are enabled if their respective enable bits are set (CCxE, CCxNE in TIMx_CCER register).
	TIM_TIM1_BDTR_MOE_B_0x1 = 0x1
	// Position of BKF field.
	TIM_TIM1_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	TIM_TIM1_BDTR_BKF_Msk = 0xf0000
	// No filter, BRK acts asynchronously
	TIM_TIM1_BDTR_BKF_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_TIM1_BDTR_BKF_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_TIM1_BDTR_BKF_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_TIM1_BDTR_BKF_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_TIM1_BDTR_BKF_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_TIM1_BDTR_BKF_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_TIM1_BDTR_BKF_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_TIM1_BDTR_BKF_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_TIM1_BDTR_BKF_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_TIM1_BDTR_BKF_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_TIM1_BDTR_BKF_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_TIM1_BDTR_BKF_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_TIM1_BDTR_BKF_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_TIM1_BDTR_BKF_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_TIM1_BDTR_BKF_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_TIM1_BDTR_BKF_B_0xF = 0xf
	// Position of BK2F field.
	TIM_TIM1_BDTR_BK2F_Pos = 0x14
	// Bit mask of BK2F field.
	TIM_TIM1_BDTR_BK2F_Msk = 0xf00000
	// No filter, BRK2 acts asynchronously
	TIM_TIM1_BDTR_BK2F_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_TIM1_BDTR_BK2F_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_TIM1_BDTR_BK2F_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_TIM1_BDTR_BK2F_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_TIM1_BDTR_BK2F_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_TIM1_BDTR_BK2F_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_TIM1_BDTR_BK2F_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_TIM1_BDTR_BK2F_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_TIM1_BDTR_BK2F_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_TIM1_BDTR_BK2F_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_TIM1_BDTR_BK2F_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_TIM1_BDTR_BK2F_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_TIM1_BDTR_BK2F_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_TIM1_BDTR_BK2F_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_TIM1_BDTR_BK2F_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_TIM1_BDTR_BK2F_B_0xF = 0xf
	// Position of BK2E field.
	TIM_TIM1_BDTR_BK2E_Pos = 0x18
	// Bit mask of BK2E field.
	TIM_TIM1_BDTR_BK2E_Msk = 0x1000000
	// Bit BK2E.
	TIM_TIM1_BDTR_BK2E = 0x1000000
	// Break input BRK2 disabled
	TIM_TIM1_BDTR_BK2E_B_0x0 = 0x0
	// Break input BRK2 enabled
	TIM_TIM1_BDTR_BK2E_B_0x1 = 0x1
	// Position of BK2P field.
	TIM_TIM1_BDTR_BK2P_Pos = 0x19
	// Bit mask of BK2P field.
	TIM_TIM1_BDTR_BK2P_Msk = 0x2000000
	// Bit BK2P.
	TIM_TIM1_BDTR_BK2P = 0x2000000
	// Break input BRK2 is active low
	TIM_TIM1_BDTR_BK2P_B_0x0 = 0x0
	// Break input BRK2 is active high
	TIM_TIM1_BDTR_BK2P_B_0x1 = 0x1
	// Position of BKDSRM field.
	TIM_TIM1_BDTR_BKDSRM_Pos = 0x1a
	// Bit mask of BKDSRM field.
	TIM_TIM1_BDTR_BKDSRM_Msk = 0x4000000
	// Bit BKDSRM.
	TIM_TIM1_BDTR_BKDSRM = 0x4000000
	// Break input BRK is armed
	TIM_TIM1_BDTR_BKDSRM_B_0x0 = 0x0
	// Break input BRK is disarmed
	TIM_TIM1_BDTR_BKDSRM_B_0x1 = 0x1
	// Position of BK2DSRM field.
	TIM_TIM1_BDTR_BK2DSRM_Pos = 0x1b
	// Bit mask of BK2DSRM field.
	TIM_TIM1_BDTR_BK2DSRM_Msk = 0x8000000
	// Bit BK2DSRM.
	TIM_TIM1_BDTR_BK2DSRM = 0x8000000
	// Position of BKBID field.
	TIM_TIM1_BDTR_BKBID_Pos = 0x1c
	// Bit mask of BKBID field.
	TIM_TIM1_BDTR_BKBID_Msk = 0x10000000
	// Bit BKBID.
	TIM_TIM1_BDTR_BKBID = 0x10000000
	// Break input BRK in input mode
	TIM_TIM1_BDTR_BKBID_B_0x0 = 0x0
	// Break input BRK in bidirectional mode
	TIM_TIM1_BDTR_BKBID_B_0x1 = 0x1
	// Position of BK2BID field.
	TIM_TIM1_BDTR_BK2BID_Pos = 0x1d
	// Bit mask of BK2BID field.
	TIM_TIM1_BDTR_BK2BID_Msk = 0x20000000
	// Bit BK2BID.
	TIM_TIM1_BDTR_BK2BID = 0x20000000

	// TIM1_DCR: DMA control register
	// Position of DBA field.
	TIM_TIM1_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_TIM1_DCR_DBA_Msk = 0x1f
	// TIMx_CR1,
	TIM_TIM1_DCR_DBA_B_0x0 = 0x0
	// TIMx_CR2,
	TIM_TIM1_DCR_DBA_B_0x1 = 0x1
	// TIMx_SMCR,
	TIM_TIM1_DCR_DBA_B_0x2 = 0x2
	// Position of DBL field.
	TIM_TIM1_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_TIM1_DCR_DBL_Msk = 0x1f00
	// 1 transfer
	TIM_TIM1_DCR_DBL_B_0x0 = 0x0
	// 2 transfers
	TIM_TIM1_DCR_DBL_B_0x1 = 0x1
	// 3 transfers
	TIM_TIM1_DCR_DBL_B_0x2 = 0x2
	// 18 transfers
	TIM_TIM1_DCR_DBL_B_0x11 = 0x11

	// TIM1_DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_TIM1_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_TIM1_DMAR_DMAB_Msk = 0xffffffff

	// TIM1_OR1: option register 1
	// Position of OCREF_CLR field.
	TIM_TIM1_OR1_OCREF_CLR_Pos = 0x0
	// Bit mask of OCREF_CLR field.
	TIM_TIM1_OR1_OCREF_CLR_Msk = 0x1
	// Bit OCREF_CLR.
	TIM_TIM1_OR1_OCREF_CLR = 0x1
	// COMP1 output is connected to the OCREF_CLR input
	TIM_TIM1_OR1_OCREF_CLR_B_0x0 = 0x0
	// COMP2 output is connected to the OCREF_CLR input
	TIM_TIM1_OR1_OCREF_CLR_B_0x1 = 0x1

	// CCMR3_Output: capture/compare mode register 2 (output mode)
	// Position of OC6M_bit3 field.
	TIM_CCMR3_Output_OC6M_bit3_Pos = 0x18
	// Bit mask of OC6M_bit3 field.
	TIM_CCMR3_Output_OC6M_bit3_Msk = 0x1000000
	// Bit OC6M_bit3.
	TIM_CCMR3_Output_OC6M_bit3 = 0x1000000
	// Position of OC5M_bit3 field.
	TIM_CCMR3_Output_OC5M_bit3_Pos = 0x10
	// Bit mask of OC5M_bit3 field.
	TIM_CCMR3_Output_OC5M_bit3_Msk = 0x10000
	// Bit OC5M_bit3.
	TIM_CCMR3_Output_OC5M_bit3 = 0x10000
	// Position of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Pos = 0xf
	// Bit mask of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Msk = 0x8000
	// Bit OC6CE.
	TIM_CCMR3_Output_OC6CE = 0x8000
	// Position of OC6M field.
	TIM_CCMR3_Output_OC6M_Pos = 0xc
	// Bit mask of OC6M field.
	TIM_CCMR3_Output_OC6M_Msk = 0x7000
	// Position of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Pos = 0xb
	// Bit mask of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Msk = 0x800
	// Bit OC6PE.
	TIM_CCMR3_Output_OC6PE = 0x800
	// Position of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Pos = 0xa
	// Bit mask of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Msk = 0x400
	// Bit OC6FE.
	TIM_CCMR3_Output_OC6FE = 0x400
	// Position of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Pos = 0x7
	// Bit mask of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Msk = 0x80
	// Bit OC5CE.
	TIM_CCMR3_Output_OC5CE = 0x80
	// Position of OC5M field.
	TIM_CCMR3_Output_OC5M_Pos = 0x4
	// Bit mask of OC5M field.
	TIM_CCMR3_Output_OC5M_Msk = 0x70
	// Position of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Pos = 0x3
	// Bit mask of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Msk = 0x8
	// Bit OC5PE.
	TIM_CCMR3_Output_OC5PE = 0x8
	// Position of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Pos = 0x2
	// Bit mask of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Msk = 0x4
	// Bit OC5FE.
	TIM_CCMR3_Output_OC5FE = 0x4

	// TIM1_CCR5: capture/compare register 4
	// Position of CCR5 field.
	TIM_TIM1_CCR5_CCR5_Pos = 0x0
	// Bit mask of CCR5 field.
	TIM_TIM1_CCR5_CCR5_Msk = 0xffff
	// Position of GC5C1 field.
	TIM_TIM1_CCR5_GC5C1_Pos = 0x1d
	// Bit mask of GC5C1 field.
	TIM_TIM1_CCR5_GC5C1_Msk = 0x20000000
	// Bit GC5C1.
	TIM_TIM1_CCR5_GC5C1 = 0x20000000
	// No effect of OC5REF on OC1REFC5
	TIM_TIM1_CCR5_GC5C1_B_0x0 = 0x0
	// OC1REFC is the logical AND of OC1REFC and OC5REF
	TIM_TIM1_CCR5_GC5C1_B_0x1 = 0x1
	// Position of GC5C2 field.
	TIM_TIM1_CCR5_GC5C2_Pos = 0x1e
	// Bit mask of GC5C2 field.
	TIM_TIM1_CCR5_GC5C2_Msk = 0x40000000
	// Bit GC5C2.
	TIM_TIM1_CCR5_GC5C2 = 0x40000000
	// No effect of OC5REF on OC2REFC
	TIM_TIM1_CCR5_GC5C2_B_0x0 = 0x0
	// OC2REFC is the logical AND of OC2REFC and OC5REF
	TIM_TIM1_CCR5_GC5C2_B_0x1 = 0x1
	// Position of GC5C3 field.
	TIM_TIM1_CCR5_GC5C3_Pos = 0x1f
	// Bit mask of GC5C3 field.
	TIM_TIM1_CCR5_GC5C3_Msk = 0x80000000
	// Bit GC5C3.
	TIM_TIM1_CCR5_GC5C3 = 0x80000000
	// No effect of OC5REF on OC3REFC
	TIM_TIM1_CCR5_GC5C3_B_0x0 = 0x0
	// OC3REFC is the logical AND of OC3REFC and OC5REF
	TIM_TIM1_CCR5_GC5C3_B_0x1 = 0x1

	// TIM1_CCR6: capture/compare register 4
	// Position of CCR6 field.
	TIM_TIM1_CCR6_CCR6_Pos = 0x0
	// Bit mask of CCR6 field.
	TIM_TIM1_CCR6_CCR6_Msk = 0xffff

	// TIM1_AF1: DMA address for full transfer
	// Position of BKINE field.
	TIM_TIM1_AF1_BKINE_Pos = 0x0
	// Bit mask of BKINE field.
	TIM_TIM1_AF1_BKINE_Msk = 0x1
	// Bit BKINE.
	TIM_TIM1_AF1_BKINE = 0x1
	// BKIN input disabled
	TIM_TIM1_AF1_BKINE_B_0x0 = 0x0
	// BKIN input enabled
	TIM_TIM1_AF1_BKINE_B_0x1 = 0x1
	// Position of BKCMP1E field.
	TIM_TIM1_AF1_BKCMP1E_Pos = 0x1
	// Bit mask of BKCMP1E field.
	TIM_TIM1_AF1_BKCMP1E_Msk = 0x2
	// Bit BKCMP1E.
	TIM_TIM1_AF1_BKCMP1E = 0x2
	// COMP1 input disabled
	TIM_TIM1_AF1_BKCMP1E_B_0x0 = 0x0
	// COMP1 input enabled
	TIM_TIM1_AF1_BKCMP1E_B_0x1 = 0x1
	// Position of BKCMP2E field.
	TIM_TIM1_AF1_BKCMP2E_Pos = 0x2
	// Bit mask of BKCMP2E field.
	TIM_TIM1_AF1_BKCMP2E_Msk = 0x4
	// Bit BKCMP2E.
	TIM_TIM1_AF1_BKCMP2E = 0x4
	// COMP2 input disabled
	TIM_TIM1_AF1_BKCMP2E_B_0x0 = 0x0
	// COMP2 input enabled
	TIM_TIM1_AF1_BKCMP2E_B_0x1 = 0x1
	// Position of BKINP field.
	TIM_TIM1_AF1_BKINP_Pos = 0x9
	// Bit mask of BKINP field.
	TIM_TIM1_AF1_BKINP_Msk = 0x200
	// Bit BKINP.
	TIM_TIM1_AF1_BKINP = 0x200
	// BKIN input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_TIM1_AF1_BKINP_B_0x0 = 0x0
	// BKIN input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_TIM1_AF1_BKINP_B_0x1 = 0x1
	// Position of BKCMP1P field.
	TIM_TIM1_AF1_BKCMP1P_Pos = 0xa
	// Bit mask of BKCMP1P field.
	TIM_TIM1_AF1_BKCMP1P_Msk = 0x400
	// Bit BKCMP1P.
	TIM_TIM1_AF1_BKCMP1P = 0x400
	// COMP1 input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_TIM1_AF1_BKCMP1P_B_0x0 = 0x0
	// COMP1 input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_TIM1_AF1_BKCMP1P_B_0x1 = 0x1
	// Position of BKCMP2P field.
	TIM_TIM1_AF1_BKCMP2P_Pos = 0xb
	// Bit mask of BKCMP2P field.
	TIM_TIM1_AF1_BKCMP2P_Msk = 0x800
	// Bit BKCMP2P.
	TIM_TIM1_AF1_BKCMP2P = 0x800
	// COMP2 input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_TIM1_AF1_BKCMP2P_B_0x0 = 0x0
	// COMP2 input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_TIM1_AF1_BKCMP2P_B_0x1 = 0x1
	// Position of ETRSEL field.
	TIM_TIM1_AF1_ETRSEL_Pos = 0xe
	// Bit mask of ETRSEL field.
	TIM_TIM1_AF1_ETRSEL_Msk = 0x3c000
	// ETR legacy mode
	TIM_TIM1_AF1_ETRSEL_B_0x0 = 0x0
	// COMP1 output
	TIM_TIM1_AF1_ETRSEL_B_0x1 = 0x1
	// COMP2 output
	TIM_TIM1_AF1_ETRSEL_B_0x2 = 0x2
	// ADC1 AWD1
	TIM_TIM1_AF1_ETRSEL_B_0x3 = 0x3
	// ADC1 AWD2
	TIM_TIM1_AF1_ETRSEL_B_0x4 = 0x4
	// ADC1 AWD3
	TIM_TIM1_AF1_ETRSEL_B_0x5 = 0x5

	// TIM1_AF2: DMA address for full transfer
	// Position of BK2INE field.
	TIM_TIM1_AF2_BK2INE_Pos = 0x0
	// Bit mask of BK2INE field.
	TIM_TIM1_AF2_BK2INE_Msk = 0x1
	// Bit BK2INE.
	TIM_TIM1_AF2_BK2INE = 0x1
	// BKIN2 input disabled
	TIM_TIM1_AF2_BK2INE_B_0x0 = 0x0
	// BKIN2 input enabled
	TIM_TIM1_AF2_BK2INE_B_0x1 = 0x1
	// Position of BK2CMP1E field.
	TIM_TIM1_AF2_BK2CMP1E_Pos = 0x1
	// Bit mask of BK2CMP1E field.
	TIM_TIM1_AF2_BK2CMP1E_Msk = 0x2
	// Bit BK2CMP1E.
	TIM_TIM1_AF2_BK2CMP1E = 0x2
	// COMP1 input disabled
	TIM_TIM1_AF2_BK2CMP1E_B_0x0 = 0x0
	// COMP1 input enabled
	TIM_TIM1_AF2_BK2CMP1E_B_0x1 = 0x1
	// Position of BK2CMP2E field.
	TIM_TIM1_AF2_BK2CMP2E_Pos = 0x2
	// Bit mask of BK2CMP2E field.
	TIM_TIM1_AF2_BK2CMP2E_Msk = 0x4
	// Bit BK2CMP2E.
	TIM_TIM1_AF2_BK2CMP2E = 0x4
	// COMP2 input disabled
	TIM_TIM1_AF2_BK2CMP2E_B_0x0 = 0x0
	// COMP2 input enabled
	TIM_TIM1_AF2_BK2CMP2E_B_0x1 = 0x1
	// Position of BK2INP field.
	TIM_TIM1_AF2_BK2INP_Pos = 0x9
	// Bit mask of BK2INP field.
	TIM_TIM1_AF2_BK2INP_Msk = 0x200
	// Bit BK2INP.
	TIM_TIM1_AF2_BK2INP = 0x200
	// BKIN2 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_TIM1_AF2_BK2INP_B_0x0 = 0x0
	// BKIN2 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_TIM1_AF2_BK2INP_B_0x1 = 0x1
	// Position of BK2CMP1P field.
	TIM_TIM1_AF2_BK2CMP1P_Pos = 0xa
	// Bit mask of BK2CMP1P field.
	TIM_TIM1_AF2_BK2CMP1P_Msk = 0x400
	// Bit BK2CMP1P.
	TIM_TIM1_AF2_BK2CMP1P = 0x400
	// COMP1 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_TIM1_AF2_BK2CMP1P_B_0x0 = 0x0
	// COMP1 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_TIM1_AF2_BK2CMP1P_B_0x1 = 0x1
	// Position of BK2CMP2P field.
	TIM_TIM1_AF2_BK2CMP2P_Pos = 0xb
	// Bit mask of BK2CMP2P field.
	TIM_TIM1_AF2_BK2CMP2P_Msk = 0x800
	// Bit BK2CMP2P.
	TIM_TIM1_AF2_BK2CMP2P = 0x800
	// COMP2 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_TIM1_AF2_BK2CMP2P_B_0x0 = 0x0
	// COMP2 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_TIM1_AF2_BK2CMP2P_B_0x1 = 0x1

	// TIM1_TISEL: TIM1 timer input selection register
	// Position of TI1SEL field.
	TIM_TIM1_TISEL_TI1SEL_Pos = 0x0
	// Bit mask of TI1SEL field.
	TIM_TIM1_TISEL_TI1SEL_Msk = 0xf
	// TIM1_CH1 input
	TIM_TIM1_TISEL_TI1SEL_B_0x0 = 0x0
	// COMP1 output
	TIM_TIM1_TISEL_TI1SEL_B_0x1 = 0x1
	// Position of TI2SEL field.
	TIM_TIM1_TISEL_TI2SEL_Pos = 0x8
	// Bit mask of TI2SEL field.
	TIM_TIM1_TISEL_TI2SEL_Msk = 0xf00
	// TIM1_CH2 input
	TIM_TIM1_TISEL_TI2SEL_B_0x0 = 0x0
	// COMP2 output
	TIM_TIM1_TISEL_TI2SEL_B_0x1 = 0x1
	// Position of TI3SEL field.
	TIM_TIM1_TISEL_TI3SEL_Pos = 0x10
	// Bit mask of TI3SEL field.
	TIM_TIM1_TISEL_TI3SEL_Msk = 0xf0000
	// TIM1_CH3 input
	TIM_TIM1_TISEL_TI3SEL_B_0x0 = 0x0
	// Position of TI4SEL field.
	TIM_TIM1_TISEL_TI4SEL_Pos = 0x18
	// Bit mask of TI4SEL field.
	TIM_TIM1_TISEL_TI4SEL_Msk = 0xf000000
	// TIM1_CH4 input
	TIM_TIM1_TISEL_TI4SEL_B_0x0 = 0x0
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1_FIFO_ENABLED: Control register 1
	// Position of UE field.
	USART_CR1_FIFO_ENABLED_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_FIFO_ENABLED_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_FIFO_ENABLED_UE = 0x1
	// USART prescaler and outputs disabled, low-power mode
	USART_CR1_FIFO_ENABLED_UE_B_0x0 = 0x0
	// USART enabled
	USART_CR1_FIFO_ENABLED_UE_B_0x1 = 0x1
	// Position of UESM field.
	USART_CR1_FIFO_ENABLED_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_FIFO_ENABLED_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_FIFO_ENABLED_UESM = 0x2
	// USART not able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_ENABLED_UESM_B_0x0 = 0x0
	// USART able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_ENABLED_UESM_B_0x1 = 0x1
	// Position of RE field.
	USART_CR1_FIFO_ENABLED_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_FIFO_ENABLED_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_FIFO_ENABLED_RE = 0x4
	// Receiver is disabled
	USART_CR1_FIFO_ENABLED_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	USART_CR1_FIFO_ENABLED_RE_B_0x1 = 0x1
	// Position of TE field.
	USART_CR1_FIFO_ENABLED_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_FIFO_ENABLED_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_FIFO_ENABLED_TE = 0x8
	// Transmitter is disabled
	USART_CR1_FIFO_ENABLED_TE_B_0x0 = 0x0
	// Transmitter is enabled
	USART_CR1_FIFO_ENABLED_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	USART_CR1_FIFO_ENABLED_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_FIFO_ENABLED_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_FIFO_ENABLED_IDLEIE = 0x10
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_IDLEIE_B_0x0 = 0x0
	// USART interrupt generated whenever IDLE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_IDLEIE_B_0x1 = 0x1
	// Position of RXFNEIE field.
	USART_CR1_FIFO_ENABLED_RXFNEIE_Pos = 0x5
	// Bit mask of RXFNEIE field.
	USART_CR1_FIFO_ENABLED_RXFNEIE_Msk = 0x20
	// Bit RXFNEIE.
	USART_CR1_FIFO_ENABLED_RXFNEIE = 0x20
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RXFNEIE_B_0x0 = 0x0
	// USART interrupt generated whenever ORE = 1 or RXFNE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_RXFNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	USART_CR1_FIFO_ENABLED_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_FIFO_ENABLED_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_FIFO_ENABLED_TCIE = 0x40
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TCIE_B_0x0 = 0x0
	// USART interrupt generated whenever TC = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TCIE_B_0x1 = 0x1
	// Position of TXFNFIE field.
	USART_CR1_FIFO_ENABLED_TXFNFIE_Pos = 0x7
	// Bit mask of TXFNFIE field.
	USART_CR1_FIFO_ENABLED_TXFNFIE_Msk = 0x80
	// Bit TXFNFIE.
	USART_CR1_FIFO_ENABLED_TXFNFIE = 0x80
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TXFNFIE_B_0x0 = 0x0
	// USART interrupt generated whenever TXFNF =1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TXFNFIE_B_0x1 = 0x1
	// Position of PEIE field.
	USART_CR1_FIFO_ENABLED_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_FIFO_ENABLED_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_FIFO_ENABLED_PEIE = 0x100
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_PEIE_B_0x0 = 0x0
	// USART interrupt generated whenever PE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_PEIE_B_0x1 = 0x1
	// Position of PS field.
	USART_CR1_FIFO_ENABLED_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_FIFO_ENABLED_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_FIFO_ENABLED_PS = 0x200
	// Even parity
	USART_CR1_FIFO_ENABLED_PS_B_0x0 = 0x0
	// Odd parity
	USART_CR1_FIFO_ENABLED_PS_B_0x1 = 0x1
	// Position of PCE field.
	USART_CR1_FIFO_ENABLED_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_FIFO_ENABLED_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_FIFO_ENABLED_PCE = 0x400
	// Parity control disabled
	USART_CR1_FIFO_ENABLED_PCE_B_0x0 = 0x0
	// Parity control enabled
	USART_CR1_FIFO_ENABLED_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	USART_CR1_FIFO_ENABLED_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_FIFO_ENABLED_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_FIFO_ENABLED_WAKE = 0x800
	// Idle line
	USART_CR1_FIFO_ENABLED_WAKE_B_0x0 = 0x0
	// Address mark
	USART_CR1_FIFO_ENABLED_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	USART_CR1_FIFO_ENABLED_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_FIFO_ENABLED_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_FIFO_ENABLED_M0 = 0x1000
	// Position of MME field.
	USART_CR1_FIFO_ENABLED_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_FIFO_ENABLED_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_FIFO_ENABLED_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_FIFO_ENABLED_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	USART_CR1_FIFO_ENABLED_MME_B_0x1 = 0x1
	// Position of CMIE field.
	USART_CR1_FIFO_ENABLED_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_FIFO_ENABLED_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_FIFO_ENABLED_CMIE = 0x4000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_CMIE_B_0x0 = 0x0
	// USART interrupt generated when the CMF bit is set in the USART_ISR register.
	USART_CR1_FIFO_ENABLED_CMIE_B_0x1 = 0x1
	// Position of OVER8 field.
	USART_CR1_FIFO_ENABLED_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_FIFO_ENABLED_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_FIFO_ENABLED_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_FIFO_ENABLED_OVER8_B_0x0 = 0x0
	// Oversampling by 8
	USART_CR1_FIFO_ENABLED_OVER8_B_0x1 = 0x1
	// Position of DEDT field.
	USART_CR1_FIFO_ENABLED_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_FIFO_ENABLED_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	USART_CR1_FIFO_ENABLED_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_FIFO_ENABLED_DEAT_Msk = 0x3e00000
	// Position of RTOIE field.
	USART_CR1_FIFO_ENABLED_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_FIFO_ENABLED_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_FIFO_ENABLED_RTOIE = 0x4000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RTOIE_B_0x0 = 0x0
	// USART interrupt generated when the RTOF bit is set in the USART_ISR register.
	USART_CR1_FIFO_ENABLED_RTOIE_B_0x1 = 0x1
	// Position of EOBIE field.
	USART_CR1_FIFO_ENABLED_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_FIFO_ENABLED_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_FIFO_ENABLED_EOBIE = 0x8000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_EOBIE_B_0x0 = 0x0
	// USART interrupt generated when the EOBF flag is set in the USART_ISR register
	USART_CR1_FIFO_ENABLED_EOBIE_B_0x1 = 0x1
	// Position of M1 field.
	USART_CR1_FIFO_ENABLED_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_FIFO_ENABLED_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_FIFO_ENABLED_M1 = 0x10000000
	// Position of FIFOEN field.
	USART_CR1_FIFO_ENABLED_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFO_ENABLED_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFO_ENABLED_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	USART_CR1_FIFO_ENABLED_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	USART_CR1_FIFO_ENABLED_FIFOEN_B_0x1 = 0x1
	// Position of TXFEIE field.
	USART_CR1_FIFO_ENABLED_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	USART_CR1_FIFO_ENABLED_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	USART_CR1_FIFO_ENABLED_TXFEIE = 0x40000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TXFEIE_B_0x0 = 0x0
	// USART interrupt generated when TXFE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TXFEIE_B_0x1 = 0x1
	// Position of RXFFIE field.
	USART_CR1_FIFO_ENABLED_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	USART_CR1_FIFO_ENABLED_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	USART_CR1_FIFO_ENABLED_RXFFIE = 0x80000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RXFFIE_B_0x0 = 0x0
	// USART interrupt generated when RXFF = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_RXFFIE_B_0x1 = 0x1

	// CR1_FIFO_DISABLED: Control register 1
	// Position of UE field.
	USART_CR1_FIFO_DISABLED_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_FIFO_DISABLED_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_FIFO_DISABLED_UE = 0x1
	// USART prescaler and outputs disabled, low-power mode
	USART_CR1_FIFO_DISABLED_UE_B_0x0 = 0x0
	// USART enabled
	USART_CR1_FIFO_DISABLED_UE_B_0x1 = 0x1
	// Position of UESM field.
	USART_CR1_FIFO_DISABLED_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_FIFO_DISABLED_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_FIFO_DISABLED_UESM = 0x2
	// USART not able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_DISABLED_UESM_B_0x0 = 0x0
	// USART able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_DISABLED_UESM_B_0x1 = 0x1
	// Position of RE field.
	USART_CR1_FIFO_DISABLED_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_FIFO_DISABLED_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_FIFO_DISABLED_RE = 0x4
	// Receiver is disabled
	USART_CR1_FIFO_DISABLED_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	USART_CR1_FIFO_DISABLED_RE_B_0x1 = 0x1
	// Position of TE field.
	USART_CR1_FIFO_DISABLED_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_FIFO_DISABLED_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_FIFO_DISABLED_TE = 0x8
	// Transmitter is disabled
	USART_CR1_FIFO_DISABLED_TE_B_0x0 = 0x0
	// Transmitter is enabled
	USART_CR1_FIFO_DISABLED_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	USART_CR1_FIFO_DISABLED_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_FIFO_DISABLED_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_FIFO_DISABLED_IDLEIE = 0x10
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_IDLEIE_B_0x0 = 0x0
	// USART interrupt generated whenever IDLE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_IDLEIE_B_0x1 = 0x1
	// Position of RXNEIE field.
	USART_CR1_FIFO_DISABLED_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_FIFO_DISABLED_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_FIFO_DISABLED_RXNEIE = 0x20
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_RXNEIE_B_0x0 = 0x0
	// USART interrupt generated whenever ORE = 1 or RXNE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_RXNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	USART_CR1_FIFO_DISABLED_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_FIFO_DISABLED_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_FIFO_DISABLED_TCIE = 0x40
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_TCIE_B_0x0 = 0x0
	// USART interrupt generated whenever TC = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_TCIE_B_0x1 = 0x1
	// Position of TXEIE field.
	USART_CR1_FIFO_DISABLED_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_FIFO_DISABLED_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_FIFO_DISABLED_TXEIE = 0x80
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_TXEIE_B_0x0 = 0x0
	// USART interrupt generated whenever TXE =1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_TXEIE_B_0x1 = 0x1
	// Position of PEIE field.
	USART_CR1_FIFO_DISABLED_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_FIFO_DISABLED_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_FIFO_DISABLED_PEIE = 0x100
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_PEIE_B_0x0 = 0x0
	// USART interrupt generated whenever PE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_PEIE_B_0x1 = 0x1
	// Position of PS field.
	USART_CR1_FIFO_DISABLED_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_FIFO_DISABLED_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_FIFO_DISABLED_PS = 0x200
	// Even parity
	USART_CR1_FIFO_DISABLED_PS_B_0x0 = 0x0
	// Odd parity
	USART_CR1_FIFO_DISABLED_PS_B_0x1 = 0x1
	// Position of PCE field.
	USART_CR1_FIFO_DISABLED_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_FIFO_DISABLED_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_FIFO_DISABLED_PCE = 0x400
	// Parity control disabled
	USART_CR1_FIFO_DISABLED_PCE_B_0x0 = 0x0
	// Parity control enabled
	USART_CR1_FIFO_DISABLED_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	USART_CR1_FIFO_DISABLED_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_FIFO_DISABLED_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_FIFO_DISABLED_WAKE = 0x800
	// Idle line
	USART_CR1_FIFO_DISABLED_WAKE_B_0x0 = 0x0
	// Address mark
	USART_CR1_FIFO_DISABLED_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	USART_CR1_FIFO_DISABLED_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_FIFO_DISABLED_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_FIFO_DISABLED_M0 = 0x1000
	// Position of MME field.
	USART_CR1_FIFO_DISABLED_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_FIFO_DISABLED_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_FIFO_DISABLED_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_FIFO_DISABLED_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	USART_CR1_FIFO_DISABLED_MME_B_0x1 = 0x1
	// Position of CMIE field.
	USART_CR1_FIFO_DISABLED_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_FIFO_DISABLED_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_FIFO_DISABLED_CMIE = 0x4000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_CMIE_B_0x0 = 0x0
	// USART interrupt generated when the CMF bit is set in the USART_ISR register.
	USART_CR1_FIFO_DISABLED_CMIE_B_0x1 = 0x1
	// Position of OVER8 field.
	USART_CR1_FIFO_DISABLED_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_FIFO_DISABLED_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_FIFO_DISABLED_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_FIFO_DISABLED_OVER8_B_0x0 = 0x0
	// Oversampling by 8
	USART_CR1_FIFO_DISABLED_OVER8_B_0x1 = 0x1
	// Position of DEDT field.
	USART_CR1_FIFO_DISABLED_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_FIFO_DISABLED_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	USART_CR1_FIFO_DISABLED_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_FIFO_DISABLED_DEAT_Msk = 0x3e00000
	// Position of RTOIE field.
	USART_CR1_FIFO_DISABLED_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_FIFO_DISABLED_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_FIFO_DISABLED_RTOIE = 0x4000000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_RTOIE_B_0x0 = 0x0
	// USART interrupt generated when the RTOF bit is set in the USART_ISR register.
	USART_CR1_FIFO_DISABLED_RTOIE_B_0x1 = 0x1
	// Position of EOBIE field.
	USART_CR1_FIFO_DISABLED_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_FIFO_DISABLED_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_FIFO_DISABLED_EOBIE = 0x8000000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_EOBIE_B_0x0 = 0x0
	// USART interrupt generated when the EOBF flag is set in the USART_ISR register
	USART_CR1_FIFO_DISABLED_EOBIE_B_0x1 = 0x1
	// Position of M1 field.
	USART_CR1_FIFO_DISABLED_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_FIFO_DISABLED_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_FIFO_DISABLED_M1 = 0x10000000
	// Position of FIFOEN field.
	USART_CR1_FIFO_DISABLED_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFO_DISABLED_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFO_DISABLED_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	USART_CR1_FIFO_DISABLED_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	USART_CR1_FIFO_DISABLED_FIFOEN_B_0x1 = 0x1

	// CR2: Control register 2
	// Position of SLVEN field.
	USART_CR2_SLVEN_Pos = 0x0
	// Bit mask of SLVEN field.
	USART_CR2_SLVEN_Msk = 0x1
	// Bit SLVEN.
	USART_CR2_SLVEN = 0x1
	// Slave mode disabled.
	USART_CR2_SLVEN_B_0x0 = 0x0
	// Slave mode enabled.
	USART_CR2_SLVEN_B_0x1 = 0x1
	// Position of DIS_NSS field.
	USART_CR2_DIS_NSS_Pos = 0x3
	// Bit mask of DIS_NSS field.
	USART_CR2_DIS_NSS_Msk = 0x8
	// Bit DIS_NSS.
	USART_CR2_DIS_NSS = 0x8
	// SPI slave selection depends on NSS input pin.
	USART_CR2_DIS_NSS_B_0x0 = 0x0
	// SPI slave is always selected and NSS input pin is ignored.
	USART_CR2_DIS_NSS_B_0x1 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_B_0x0 = 0x0
	// 7-bit address detection (in 8-bit data mode)
	USART_CR2_ADDM7_B_0x1 = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_B_0x0 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_B_0x1 = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_B_0x0 = 0x0
	// An interrupt is generated whenever LBDF = 1 in the USART_ISR register
	USART_CR2_LBDIE_B_0x1 = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the SCLK pin
	USART_CR2_LBCL_B_0x0 = 0x0
	// The clock pulse of the last data bit is output to the SCLK pin
	USART_CR2_LBCL_B_0x1 = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_B_0x0 = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_B_0x1 = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on SCLK pin outside transmission window
	USART_CR2_CPOL_B_0x0 = 0x0
	// Steady high value on SCLK pin outside transmission window
	USART_CR2_CPOL_B_0x1 = 0x1
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// SCLK pin disabled
	USART_CR2_CLKEN_B_0x0 = 0x0
	// SCLK pin enabled
	USART_CR2_CLKEN_B_0x1 = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_B_0x0 = 0x0
	// 0.5 stop bit.
	USART_CR2_STOP_B_0x1 = 0x1
	// 2 stop bits
	USART_CR2_STOP_B_0x2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_B_0x3 = 0x3
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_B_0x0 = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_B_0x1 = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_B_0x0 = 0x0
	// The TX and RX pins functions are swapped. This enables to work in the case of a cross-wired connection to another UART.
	USART_CR2_SWAP_B_0x1 = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels (VDD =1/idle, Gnd = 0/mark)
	USART_CR2_RXINV_B_0x0 = 0x0
	// RX pin signal values are inverted (VDD =0/mark, Gnd = 1/idle).
	USART_CR2_RXINV_B_0x1 = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels (VDD =1/idle, Gnd = 0/mark)
	USART_CR2_TXINV_B_0x0 = 0x0
	// TX pin signal values are inverted (VDD =0/mark, Gnd = 1/idle).
	USART_CR2_TXINV_B_0x1 = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic. (1 = H, 0 = L)
	USART_CR2_DATAINV_B_0x0 = 0x0
	// Logical data from the data register are send/received in negative/inverse logic. (1 = L, 0 = H). The parity bit is also inverted.
	USART_CR2_DATAINV_B_0x1 = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit.
	USART_CR2_MSBFIRST_B_0x0 = 0x0
	// data is transmitted/received with the MSB (bit 7/8) first, following the start bit.
	USART_CR2_MSBFIRST_B_0x1 = 0x1
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled.
	USART_CR2_ABREN_B_0x0 = 0x0
	// Auto baud rate detection is enabled.
	USART_CR2_ABREN_B_0x1 = 0x1
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate.
	USART_CR2_ABRMOD_B_0x0 = 0x0
	// Falling edge to falling edge measurement (the received frame must start with a single bit = 1 and Frame = Start10xxxxxx)
	USART_CR2_ABRMOD_B_0x1 = 0x1
	// 0x7F frame detection.
	USART_CR2_ABRMOD_B_0x2 = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_B_0x3 = 0x3
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled.
	USART_CR2_RTOEN_B_0x0 = 0x0
	// Receiver timeout feature enabled.
	USART_CR2_RTOEN_B_0x1 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000

	// CR3: Control register 3
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt inhibited
	USART_CR3_EIE_B_0x0 = 0x0
	// interrupt generated when FE = 1 or ORE = 1 or NE = 1 or UDR = 1 (in SPI slave mode) in the USART_ISR register.
	USART_CR3_EIE_B_0x1 = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_B_0x0 = 0x0
	// IrDA enabled
	USART_CR3_IREN_B_0x1 = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_B_0x0 = 0x0
	// Low-power mode
	USART_CR3_IRLP_B_0x1 = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_B_0x0 = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_B_0x1 = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_B_0x0 = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_B_0x1 = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_B_0x0 = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_B_0x1 = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is enabled for reception
	USART_CR3_DMAR_B_0x1 = 0x1
	// DMA mode is disabled for reception
	USART_CR3_DMAR_B_0x0 = 0x0
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_B_0x1 = 0x1
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_B_0x0 = 0x0
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_B_0x0 = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer. The transmission of data is expected to cease after the current character has been transmitted. The nRTS output is asserted (pulled to 0) when data can be received.
	USART_CR3_RTSE_B_0x1 = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_B_0x0 = 0x0
	// CTS mode enabled, data is only transmitted when the nCTS input is asserted (tied to 0). If the nCTS input is deasserted while data is being transmitted, then the transmission is completed before stopping. If data is written into the data register while nCTS is asserted, the transmission is postponed until nCTS is asserted.
	USART_CR3_CTSE_B_0x1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_B_0x0 = 0x0
	// An interrupt is generated whenever CTSIF = 1 in the USART_ISR register
	USART_CR3_CTSIE_B_0x1 = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_B_0x0 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_B_0x1 = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data.
	USART_CR3_OVRDIS_B_0x0 = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set
	USART_CR3_OVRDIS_B_0x1 = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error. The corresponding error flag is set but RXNE is kept 0 preventing from overrun. As a consequence, the DMA request is not asserted, so the erroneous data is not transferred (no DMA request), but next correct received data is transferred (used for Smartcard mode).
	USART_CR3_DDRE_B_0x0 = 0x0
	// DMA is disabled following a reception error. The corresponding error flag is set, as well as RXNE. The DMA request is masked until the error flag is cleared. This means that the software must first disable the DMA request (DMAR = 0) or clear RXNE/RXFNE is case FIFO mode is enabled) before clearing the error flag.
	USART_CR3_DDRE_B_0x1 = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled.
	USART_CR3_DEM_B_0x0 = 0x0
	// DE function is enabled. The DE signal is output on the RTS pin.
	USART_CR3_DEM_B_0x1 = 0x1
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high.
	USART_CR3_DEP_B_0x0 = 0x0
	// DE signal is active low.
	USART_CR3_DEP_B_0x1 = 0x1
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// retransmission disabled - No automatic retransmission in transmit mode.
	USART_CR3_SCARCNT_B_0x0 = 0x0
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x1 = 0x1
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x2 = 0x2
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x3 = 0x3
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x4 = 0x4
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x5 = 0x5
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x6 = 0x6
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x7 = 0x7
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match (as defined by ADD[7:0] and ADDM7)
	USART_CR3_WUS_B_0x0 = 0x0
	// WUF active on start bit detection
	USART_CR3_WUS_B_0x2 = 0x2
	// WUF active on RXNE/RXFNE.
	USART_CR3_WUS_B_0x3 = 0x3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt inhibited
	USART_CR3_WUFIE_B_0x0 = 0x0
	// USART interrupt generated whenever WUF = 1 in the USART_ISR register
	USART_CR3_WUFIE_B_0x1 = 0x1
	// Position of TXFTIE field.
	USART_CR3_TXFTIE_Pos = 0x17
	// Bit mask of TXFTIE field.
	USART_CR3_TXFTIE_Msk = 0x800000
	// Bit TXFTIE.
	USART_CR3_TXFTIE = 0x800000
	// Interrupt inhibited
	USART_CR3_TXFTIE_B_0x0 = 0x0
	// USART interrupt generated when TXFIFO reaches the threshold programmed in TXFTCFG.
	USART_CR3_TXFTIE_B_0x1 = 0x1
	// Position of TCBGTIE field.
	USART_CR3_TCBGTIE_Pos = 0x18
	// Bit mask of TCBGTIE field.
	USART_CR3_TCBGTIE_Msk = 0x1000000
	// Bit TCBGTIE.
	USART_CR3_TCBGTIE = 0x1000000
	// Interrupt inhibited
	USART_CR3_TCBGTIE_B_0x0 = 0x0
	// USART interrupt generated whenever TCBGT=1 in the USART_ISR register
	USART_CR3_TCBGTIE_B_0x1 = 0x1
	// Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Pos = 0x19
	// Bit mask of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000
	// Receive FIFO reaches 1/8 of its depth
	USART_CR3_RXFTCFG_B_0x0 = 0x0
	// Receive FIFO reaches 1/4 of its depth
	USART_CR3_RXFTCFG_B_0x1 = 0x1
	// Receive FIFO reaches 1/2 of its depth
	USART_CR3_RXFTCFG_B_0x2 = 0x2
	// Receive FIFO reaches 3/4 of its depth
	USART_CR3_RXFTCFG_B_0x3 = 0x3
	// Receive FIFO reaches 7/8 of its depth
	USART_CR3_RXFTCFG_B_0x4 = 0x4
	// Receive FIFO becomes full
	USART_CR3_RXFTCFG_B_0x5 = 0x5
	// Position of RXFTIE field.
	USART_CR3_RXFTIE_Pos = 0x1c
	// Bit mask of RXFTIE field.
	USART_CR3_RXFTIE_Msk = 0x10000000
	// Bit RXFTIE.
	USART_CR3_RXFTIE = 0x10000000
	// Interrupt inhibited
	USART_CR3_RXFTIE_B_0x0 = 0x0
	// USART interrupt generated when Receive FIFO reaches the threshold programmed in RXFTCFG.
	USART_CR3_RXFTIE_B_0x1 = 0x1
	// Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Pos = 0x1d
	// Bit mask of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000
	// TXFIFO reaches 1/8 of its depth
	USART_CR3_TXFTCFG_B_0x0 = 0x0
	// TXFIFO reaches 1/4 of its depth
	USART_CR3_TXFTCFG_B_0x1 = 0x1
	// TXFIFO reaches 1/2 of its depth
	USART_CR3_TXFTCFG_B_0x2 = 0x2
	// TXFIFO reaches 3/4 of its depth
	USART_CR3_TXFTCFG_B_0x3 = 0x3
	// TXFIFO reaches 7/8 of its depth
	USART_CR3_TXFTCFG_B_0x4 = 0x4
	// TXFIFO becomes empty
	USART_CR3_TXFTCFG_B_0x5 = 0x5

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
	// Reserved - do not program this value
	USART_GTPR_PSC_B_0x0 = 0x0
	// Divides the source clock by 1 (IrDA mode) / by 2 (Smarcard mode)
	USART_GTPR_PSC_B_0x1 = 0x1
	// Divides the source clock by 2 (IrDA mode) / by 4 (Smartcard mode)
	USART_GTPR_PSC_B_0x2 = 0x2
	// Divides the source clock by 3 (IrDA mode) / by 6 (Smartcard mode)
	USART_GTPR_PSC_B_0x3 = 0x3
	// Divides the source clock by 31 (IrDA mode) / by 62 (Smartcard mode)
	USART_GTPR_PSC_B_0x1F = 0x1f
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00

	// RTOR: Receiver timeout register
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000

	// RQR: Request register
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10

	// ISR_FIFO_ENABLED: Interrupt & status register
	// Position of PE field.
	USART_ISR_FIFO_ENABLED_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_FIFO_ENABLED_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_FIFO_ENABLED_PE = 0x1
	// No parity error
	USART_ISR_FIFO_ENABLED_PE_B_0x0 = 0x0
	// Parity error
	USART_ISR_FIFO_ENABLED_PE_B_0x1 = 0x1
	// Position of FE field.
	USART_ISR_FIFO_ENABLED_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FIFO_ENABLED_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FIFO_ENABLED_FE = 0x2
	// No Framing error is detected
	USART_ISR_FIFO_ENABLED_FE_B_0x0 = 0x0
	// Framing error or break character is detected
	USART_ISR_FIFO_ENABLED_FE_B_0x1 = 0x1
	// Position of NE field.
	USART_ISR_FIFO_ENABLED_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_FIFO_ENABLED_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_FIFO_ENABLED_NE = 0x4
	// No noise is detected
	USART_ISR_FIFO_ENABLED_NE_B_0x0 = 0x0
	// Noise is detected
	USART_ISR_FIFO_ENABLED_NE_B_0x1 = 0x1
	// Position of ORE field.
	USART_ISR_FIFO_ENABLED_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_FIFO_ENABLED_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_FIFO_ENABLED_ORE = 0x8
	// No overrun error
	USART_ISR_FIFO_ENABLED_ORE_B_0x0 = 0x0
	// Overrun error is detected
	USART_ISR_FIFO_ENABLED_ORE_B_0x1 = 0x1
	// Position of IDLE field.
	USART_ISR_FIFO_ENABLED_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_FIFO_ENABLED_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_FIFO_ENABLED_IDLE = 0x10
	// No Idle line is detected
	USART_ISR_FIFO_ENABLED_IDLE_B_0x0 = 0x0
	// Idle line is detected
	USART_ISR_FIFO_ENABLED_IDLE_B_0x1 = 0x1
	// Position of RXFNE field.
	USART_ISR_FIFO_ENABLED_RXFNE_Pos = 0x5
	// Bit mask of RXFNE field.
	USART_ISR_FIFO_ENABLED_RXFNE_Msk = 0x20
	// Bit RXFNE.
	USART_ISR_FIFO_ENABLED_RXFNE = 0x20
	// Data is not received
	USART_ISR_FIFO_ENABLED_RXFNE_B_0x0 = 0x0
	// Received data is ready to be read.
	USART_ISR_FIFO_ENABLED_RXFNE_B_0x1 = 0x1
	// Position of TC field.
	USART_ISR_FIFO_ENABLED_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_FIFO_ENABLED_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_FIFO_ENABLED_TC = 0x40
	// Transmission is not complete
	USART_ISR_FIFO_ENABLED_TC_B_0x0 = 0x0
	// Transmission is complete
	USART_ISR_FIFO_ENABLED_TC_B_0x1 = 0x1
	// Position of TXFNF field.
	USART_ISR_FIFO_ENABLED_TXFNF_Pos = 0x7
	// Bit mask of TXFNF field.
	USART_ISR_FIFO_ENABLED_TXFNF_Msk = 0x80
	// Bit TXFNF.
	USART_ISR_FIFO_ENABLED_TXFNF = 0x80
	// Transmit FIFO is full
	USART_ISR_FIFO_ENABLED_TXFNF_B_0x0 = 0x0
	// Transmit FIFO is not full
	USART_ISR_FIFO_ENABLED_TXFNF_B_0x1 = 0x1
	// Position of LBDF field.
	USART_ISR_FIFO_ENABLED_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_FIFO_ENABLED_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_FIFO_ENABLED_LBDF = 0x100
	// LIN Break not detected
	USART_ISR_FIFO_ENABLED_LBDF_B_0x0 = 0x0
	// LIN break detected
	USART_ISR_FIFO_ENABLED_LBDF_B_0x1 = 0x1
	// Position of CTSIF field.
	USART_ISR_FIFO_ENABLED_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_FIFO_ENABLED_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_FIFO_ENABLED_CTSIF = 0x200
	// No change occurred on the nCTS status line
	USART_ISR_FIFO_ENABLED_CTSIF_B_0x0 = 0x0
	// A change occurred on the nCTS status line
	USART_ISR_FIFO_ENABLED_CTSIF_B_0x1 = 0x1
	// Position of CTS field.
	USART_ISR_FIFO_ENABLED_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_FIFO_ENABLED_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_FIFO_ENABLED_CTS = 0x400
	// nCTS line set
	USART_ISR_FIFO_ENABLED_CTS_B_0x0 = 0x0
	// nCTS line reset
	USART_ISR_FIFO_ENABLED_CTS_B_0x1 = 0x1
	// Position of RTOF field.
	USART_ISR_FIFO_ENABLED_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_FIFO_ENABLED_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_FIFO_ENABLED_RTOF = 0x800
	// Timeout value not reached
	USART_ISR_FIFO_ENABLED_RTOF_B_0x0 = 0x0
	// Timeout value reached without any data reception
	USART_ISR_FIFO_ENABLED_RTOF_B_0x1 = 0x1
	// Position of EOBF field.
	USART_ISR_FIFO_ENABLED_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_FIFO_ENABLED_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_FIFO_ENABLED_EOBF = 0x1000
	// End of Block not reached
	USART_ISR_FIFO_ENABLED_EOBF_B_0x0 = 0x0
	// End of Block (number of characters) reached
	USART_ISR_FIFO_ENABLED_EOBF_B_0x1 = 0x1
	// Position of UDR field.
	USART_ISR_FIFO_ENABLED_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_FIFO_ENABLED_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_FIFO_ENABLED_UDR = 0x2000
	// No underrun error
	USART_ISR_FIFO_ENABLED_UDR_B_0x0 = 0x0
	// underrun error
	USART_ISR_FIFO_ENABLED_UDR_B_0x1 = 0x1
	// Position of ABRE field.
	USART_ISR_FIFO_ENABLED_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_FIFO_ENABLED_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_FIFO_ENABLED_ABRE = 0x4000
	// Position of ABRF field.
	USART_ISR_FIFO_ENABLED_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_FIFO_ENABLED_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_FIFO_ENABLED_ABRF = 0x8000
	// Position of BUSY field.
	USART_ISR_FIFO_ENABLED_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_FIFO_ENABLED_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_FIFO_ENABLED_BUSY = 0x10000
	// USART is idle (no reception)
	USART_ISR_FIFO_ENABLED_BUSY_B_0x0 = 0x0
	// Reception on going
	USART_ISR_FIFO_ENABLED_BUSY_B_0x1 = 0x1
	// Position of CMF field.
	USART_ISR_FIFO_ENABLED_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_FIFO_ENABLED_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_FIFO_ENABLED_CMF = 0x20000
	// No Character match detected
	USART_ISR_FIFO_ENABLED_CMF_B_0x0 = 0x0
	// Character Match detected
	USART_ISR_FIFO_ENABLED_CMF_B_0x1 = 0x1
	// Position of SBKF field.
	USART_ISR_FIFO_ENABLED_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_FIFO_ENABLED_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_FIFO_ENABLED_SBKF = 0x40000
	// Break character transmitted
	USART_ISR_FIFO_ENABLED_SBKF_B_0x0 = 0x0
	// Break character requested by setting SBKRQ bit in USART_RQR register
	USART_ISR_FIFO_ENABLED_SBKF_B_0x1 = 0x1
	// Position of RWU field.
	USART_ISR_FIFO_ENABLED_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_FIFO_ENABLED_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_FIFO_ENABLED_RWU = 0x80000
	// Receiver in active mode
	USART_ISR_FIFO_ENABLED_RWU_B_0x0 = 0x0
	// Receiver in Mute mode
	USART_ISR_FIFO_ENABLED_RWU_B_0x1 = 0x1
	// Position of WUF field.
	USART_ISR_FIFO_ENABLED_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_FIFO_ENABLED_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_FIFO_ENABLED_WUF = 0x100000
	// Position of TEACK field.
	USART_ISR_FIFO_ENABLED_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_FIFO_ENABLED_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_FIFO_ENABLED_TEACK = 0x200000
	// Position of REACK field.
	USART_ISR_FIFO_ENABLED_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_FIFO_ENABLED_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_FIFO_ENABLED_REACK = 0x400000
	// Position of TXFE field.
	USART_ISR_FIFO_ENABLED_TXFE_Pos = 0x17
	// Bit mask of TXFE field.
	USART_ISR_FIFO_ENABLED_TXFE_Msk = 0x800000
	// Bit TXFE.
	USART_ISR_FIFO_ENABLED_TXFE = 0x800000
	// TXFIFO not empty.
	USART_ISR_FIFO_ENABLED_TXFE_B_0x0 = 0x0
	// TXFIFO empty.
	USART_ISR_FIFO_ENABLED_TXFE_B_0x1 = 0x1
	// Position of RXFF field.
	USART_ISR_FIFO_ENABLED_RXFF_Pos = 0x18
	// Bit mask of RXFF field.
	USART_ISR_FIFO_ENABLED_RXFF_Msk = 0x1000000
	// Bit RXFF.
	USART_ISR_FIFO_ENABLED_RXFF = 0x1000000
	// RXFIFO not full.
	USART_ISR_FIFO_ENABLED_RXFF_B_0x0 = 0x0
	// RXFIFO Full.
	USART_ISR_FIFO_ENABLED_RXFF_B_0x1 = 0x1
	// Position of TCBGT field.
	USART_ISR_FIFO_ENABLED_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_FIFO_ENABLED_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_FIFO_ENABLED_TCBGT = 0x2000000
	// Transmission is not complete or transmission is complete unsuccessfully (i.e. a NACK is received from the card)
	USART_ISR_FIFO_ENABLED_TCBGT_B_0x0 = 0x0
	// Transmission is complete successfully (before Guard time completion and there is no NACK from the smart card).
	USART_ISR_FIFO_ENABLED_TCBGT_B_0x1 = 0x1
	// Position of RXFT field.
	USART_ISR_FIFO_ENABLED_RXFT_Pos = 0x1a
	// Bit mask of RXFT field.
	USART_ISR_FIFO_ENABLED_RXFT_Msk = 0x4000000
	// Bit RXFT.
	USART_ISR_FIFO_ENABLED_RXFT = 0x4000000
	// Receive FIFO does not reach the programmed threshold.
	USART_ISR_FIFO_ENABLED_RXFT_B_0x0 = 0x0
	// Receive FIFO reached the programmed threshold.
	USART_ISR_FIFO_ENABLED_RXFT_B_0x1 = 0x1
	// Position of TXFT field.
	USART_ISR_FIFO_ENABLED_TXFT_Pos = 0x1b
	// Bit mask of TXFT field.
	USART_ISR_FIFO_ENABLED_TXFT_Msk = 0x8000000
	// Bit TXFT.
	USART_ISR_FIFO_ENABLED_TXFT = 0x8000000
	// TXFIFO does not reach the programmed threshold.
	USART_ISR_FIFO_ENABLED_TXFT_B_0x0 = 0x0
	// TXFIFO reached the programmed threshold.
	USART_ISR_FIFO_ENABLED_TXFT_B_0x1 = 0x1

	// ISR_FIFO_DISABLED: Interrupt & status register
	// Position of PE field.
	USART_ISR_FIFO_DISABLED_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_FIFO_DISABLED_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_FIFO_DISABLED_PE = 0x1
	// No parity error
	USART_ISR_FIFO_DISABLED_PE_B_0x0 = 0x0
	// Parity error
	USART_ISR_FIFO_DISABLED_PE_B_0x1 = 0x1
	// Position of FE field.
	USART_ISR_FIFO_DISABLED_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FIFO_DISABLED_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FIFO_DISABLED_FE = 0x2
	// No Framing error is detected
	USART_ISR_FIFO_DISABLED_FE_B_0x0 = 0x0
	// Framing error or break character is detected
	USART_ISR_FIFO_DISABLED_FE_B_0x1 = 0x1
	// Position of NE field.
	USART_ISR_FIFO_DISABLED_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_FIFO_DISABLED_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_FIFO_DISABLED_NE = 0x4
	// No noise is detected
	USART_ISR_FIFO_DISABLED_NE_B_0x0 = 0x0
	// Noise is detected
	USART_ISR_FIFO_DISABLED_NE_B_0x1 = 0x1
	// Position of ORE field.
	USART_ISR_FIFO_DISABLED_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_FIFO_DISABLED_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_FIFO_DISABLED_ORE = 0x8
	// No overrun error
	USART_ISR_FIFO_DISABLED_ORE_B_0x0 = 0x0
	// Overrun error is detected
	USART_ISR_FIFO_DISABLED_ORE_B_0x1 = 0x1
	// Position of IDLE field.
	USART_ISR_FIFO_DISABLED_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_FIFO_DISABLED_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_FIFO_DISABLED_IDLE = 0x10
	// No Idle line is detected
	USART_ISR_FIFO_DISABLED_IDLE_B_0x0 = 0x0
	// Idle line is detected
	USART_ISR_FIFO_DISABLED_IDLE_B_0x1 = 0x1
	// Position of RXNE field.
	USART_ISR_FIFO_DISABLED_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_FIFO_DISABLED_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_FIFO_DISABLED_RXNE = 0x20
	// Data is not received
	USART_ISR_FIFO_DISABLED_RXNE_B_0x0 = 0x0
	// Received data is ready to be read.
	USART_ISR_FIFO_DISABLED_RXNE_B_0x1 = 0x1
	// Position of TC field.
	USART_ISR_FIFO_DISABLED_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_FIFO_DISABLED_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_FIFO_DISABLED_TC = 0x40
	// Transmission is not complete
	USART_ISR_FIFO_DISABLED_TC_B_0x0 = 0x0
	// Transmission is complete
	USART_ISR_FIFO_DISABLED_TC_B_0x1 = 0x1
	// Position of TXE field.
	USART_ISR_FIFO_DISABLED_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_FIFO_DISABLED_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_FIFO_DISABLED_TXE = 0x80
	// Data register full
	USART_ISR_FIFO_DISABLED_TXE_B_0x0 = 0x0
	// Data register not full
	USART_ISR_FIFO_DISABLED_TXE_B_0x1 = 0x1
	// Position of LBDF field.
	USART_ISR_FIFO_DISABLED_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_FIFO_DISABLED_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_FIFO_DISABLED_LBDF = 0x100
	// LIN Break not detected
	USART_ISR_FIFO_DISABLED_LBDF_B_0x0 = 0x0
	// LIN break detected
	USART_ISR_FIFO_DISABLED_LBDF_B_0x1 = 0x1
	// Position of CTSIF field.
	USART_ISR_FIFO_DISABLED_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_FIFO_DISABLED_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_FIFO_DISABLED_CTSIF = 0x200
	// No change occurred on the nCTS status line
	USART_ISR_FIFO_DISABLED_CTSIF_B_0x0 = 0x0
	// A change occurred on the nCTS status line
	USART_ISR_FIFO_DISABLED_CTSIF_B_0x1 = 0x1
	// Position of CTS field.
	USART_ISR_FIFO_DISABLED_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_FIFO_DISABLED_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_FIFO_DISABLED_CTS = 0x400
	// nCTS line set
	USART_ISR_FIFO_DISABLED_CTS_B_0x0 = 0x0
	// nCTS line reset
	USART_ISR_FIFO_DISABLED_CTS_B_0x1 = 0x1
	// Position of RTOF field.
	USART_ISR_FIFO_DISABLED_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_FIFO_DISABLED_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_FIFO_DISABLED_RTOF = 0x800
	// Timeout value not reached
	USART_ISR_FIFO_DISABLED_RTOF_B_0x0 = 0x0
	// Timeout value reached without any data reception
	USART_ISR_FIFO_DISABLED_RTOF_B_0x1 = 0x1
	// Position of EOBF field.
	USART_ISR_FIFO_DISABLED_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_FIFO_DISABLED_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_FIFO_DISABLED_EOBF = 0x1000
	// End of Block not reached
	USART_ISR_FIFO_DISABLED_EOBF_B_0x0 = 0x0
	// End of Block (number of characters) reached
	USART_ISR_FIFO_DISABLED_EOBF_B_0x1 = 0x1
	// Position of UDR field.
	USART_ISR_FIFO_DISABLED_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_FIFO_DISABLED_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_FIFO_DISABLED_UDR = 0x2000
	// No underrun error
	USART_ISR_FIFO_DISABLED_UDR_B_0x0 = 0x0
	// underrun error
	USART_ISR_FIFO_DISABLED_UDR_B_0x1 = 0x1
	// Position of ABRE field.
	USART_ISR_FIFO_DISABLED_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_FIFO_DISABLED_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_FIFO_DISABLED_ABRE = 0x4000
	// Position of ABRF field.
	USART_ISR_FIFO_DISABLED_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_FIFO_DISABLED_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_FIFO_DISABLED_ABRF = 0x8000
	// Position of BUSY field.
	USART_ISR_FIFO_DISABLED_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_FIFO_DISABLED_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_FIFO_DISABLED_BUSY = 0x10000
	// USART is idle (no reception)
	USART_ISR_FIFO_DISABLED_BUSY_B_0x0 = 0x0
	// Reception on going
	USART_ISR_FIFO_DISABLED_BUSY_B_0x1 = 0x1
	// Position of CMF field.
	USART_ISR_FIFO_DISABLED_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_FIFO_DISABLED_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_FIFO_DISABLED_CMF = 0x20000
	// No Character match detected
	USART_ISR_FIFO_DISABLED_CMF_B_0x0 = 0x0
	// Character Match detected
	USART_ISR_FIFO_DISABLED_CMF_B_0x1 = 0x1
	// Position of SBKF field.
	USART_ISR_FIFO_DISABLED_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_FIFO_DISABLED_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_FIFO_DISABLED_SBKF = 0x40000
	// Break character transmitted
	USART_ISR_FIFO_DISABLED_SBKF_B_0x0 = 0x0
	// Break character requested by setting SBKRQ bit in USART_RQR register
	USART_ISR_FIFO_DISABLED_SBKF_B_0x1 = 0x1
	// Position of RWU field.
	USART_ISR_FIFO_DISABLED_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_FIFO_DISABLED_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_FIFO_DISABLED_RWU = 0x80000
	// Receiver in active mode
	USART_ISR_FIFO_DISABLED_RWU_B_0x0 = 0x0
	// Receiver in Mute mode
	USART_ISR_FIFO_DISABLED_RWU_B_0x1 = 0x1
	// Position of WUF field.
	USART_ISR_FIFO_DISABLED_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_FIFO_DISABLED_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_FIFO_DISABLED_WUF = 0x100000
	// Position of TEACK field.
	USART_ISR_FIFO_DISABLED_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_FIFO_DISABLED_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_FIFO_DISABLED_TEACK = 0x200000
	// Position of REACK field.
	USART_ISR_FIFO_DISABLED_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_FIFO_DISABLED_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_FIFO_DISABLED_REACK = 0x400000
	// Position of TCBGT field.
	USART_ISR_FIFO_DISABLED_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_FIFO_DISABLED_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_FIFO_DISABLED_TCBGT = 0x2000000
	// Transmission is not complete or transmission is complete unsuccessfully (i.e. a NACK is received from the card)
	USART_ISR_FIFO_DISABLED_TCBGT_B_0x0 = 0x0
	// Transmission is complete successfully (before Guard time completion and there is no NACK from the smart card).
	USART_ISR_FIFO_DISABLED_TCBGT_B_0x1 = 0x1

	// ICR: Interrupt flag clear register
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Position of NECF field.
	USART_ICR_NECF_Pos = 0x2
	// Bit mask of NECF field.
	USART_ICR_NECF_Msk = 0x4
	// Bit NECF.
	USART_ICR_NECF = 0x4
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Position of TXFECF field.
	USART_ICR_TXFECF_Pos = 0x5
	// Bit mask of TXFECF field.
	USART_ICR_TXFECF_Msk = 0x20
	// Bit TXFECF.
	USART_ICR_TXFECF = 0x20
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Position of TCBGTCF field.
	USART_ICR_TCBGTCF_Pos = 0x7
	// Bit mask of TCBGTCF field.
	USART_ICR_TCBGTCF_Msk = 0x80
	// Bit TCBGTCF.
	USART_ICR_TCBGTCF = 0x80
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Position of UDRCF field.
	USART_ICR_UDRCF_Pos = 0xd
	// Bit mask of UDRCF field.
	USART_ICR_UDRCF_Msk = 0x2000
	// Bit UDRCF.
	USART_ICR_UDRCF = 0x2000
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff

	// PRESC: Prescaler register
	// Position of PRESCALER field.
	USART_PRESC_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf
	// input clock not divided
	USART_PRESC_PRESCALER_B_0x0 = 0x0
	// input clock divided by 2
	USART_PRESC_PRESCALER_B_0x1 = 0x1
	// input clock divided by 4
	USART_PRESC_PRESCALER_B_0x2 = 0x2
	// input clock divided by 6
	USART_PRESC_PRESCALER_B_0x3 = 0x3
	// input clock divided by 8
	USART_PRESC_PRESCALER_B_0x4 = 0x4
	// input clock divided by 10
	USART_PRESC_PRESCALER_B_0x5 = 0x5
	// input clock divided by 12
	USART_PRESC_PRESCALER_B_0x6 = 0x6
	// input clock divided by 16
	USART_PRESC_PRESCALER_B_0x7 = 0x7
	// input clock divided by 32
	USART_PRESC_PRESCALER_B_0x8 = 0x8
	// input clock divided by 64
	USART_PRESC_PRESCALER_B_0x9 = 0x9
	// input clock divided by 128
	USART_PRESC_PRESCALER_B_0xA = 0xa
	// input clock divided by 256
	USART_PRESC_PRESCALER_B_0xB = 0xb
)

// Bitfields for VREFBUF: System configuration controller
const (
	// VREFBUF_CSR: VREFBUF control and status register
	// Position of ENVR field.
	VREFBUF_VREFBUF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREFBUF_VREFBUF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREFBUF_VREFBUF_CSR_ENVR = 0x1
	// Internal voltage reference mode disable (external voltage reference mode).
	VREFBUF_VREFBUF_CSR_ENVR_B_0x0 = 0x0
	// Internal voltage reference mode (reference buffer enable or hold mode) enable.
	VREFBUF_VREFBUF_CSR_ENVR_B_0x1 = 0x1
	// Position of HIZ field.
	VREFBUF_VREFBUF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREFBUF_VREFBUF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREFBUF_VREFBUF_CSR_HIZ = 0x2
	// VREF+ pin is internally connected to the voltage reference buffer output.
	VREFBUF_VREFBUF_CSR_HIZ_B_0x0 = 0x0
	// VREF+ pin is high impedance.
	VREFBUF_VREFBUF_CSR_HIZ_B_0x1 = 0x1
	// Position of VRS field.
	VREFBUF_VREFBUF_CSR_VRS_Pos = 0x2
	// Bit mask of VRS field.
	VREFBUF_VREFBUF_CSR_VRS_Msk = 0x4
	// Bit VRS.
	VREFBUF_VREFBUF_CSR_VRS = 0x4
	// Voltage reference set to VREF_OUT1 (around 2.048 V).
	VREFBUF_VREFBUF_CSR_VRS_B_0x0 = 0x0
	// Voltage reference set to VREF_OUT2 (around 2.5 V).
	VREFBUF_VREFBUF_CSR_VRS_B_0x1 = 0x1
	// Position of VRR field.
	VREFBUF_VREFBUF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREFBUF_VREFBUF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREFBUF_VREFBUF_CSR_VRR = 0x8
	// the voltage reference buffer output is not ready.
	VREFBUF_VREFBUF_CSR_VRR_B_0x0 = 0x0
	// the voltage reference buffer output reached the requested level.
	VREFBUF_VREFBUF_CSR_VRR_B_0x1 = 0x1

	// VREFBUF_CCR: VREFBUF calibration control register
	// Position of TRIM field.
	VREFBUF_VREFBUF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREFBUF_VREFBUF_CCR_TRIM_Msk = 0x3f
)

// Bitfields for WWDG: System window watchdog
const (
	// WWDG_CR: Control register
	// Position of T field.
	WWDG_WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_WWDG_CR_T_Msk = 0x7f
	// Position of WDGA field.
	WWDG_WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_WWDG_CR_WDGA_B_0x0 = 0x0
	// Watchdog enabled
	WWDG_WWDG_CR_WDGA_B_0x1 = 0x1

	// WWDG_CFR: Configuration register
	// Position of W field.
	WWDG_WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_WWDG_CFR_W_Msk = 0x7f
	// Position of EWI field.
	WWDG_WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_WWDG_CFR_EWI = 0x200
	// Position of WDGTB field.
	WWDG_WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_WWDG_CFR_WDGTB_Msk = 0x3800
	// CK Counter Clock (PCLK div 4096) div 1
	WWDG_WWDG_CFR_WDGTB_B_0x0 = 0x0
	// CK Counter Clock (PCLK div 4096) div 2
	WWDG_WWDG_CFR_WDGTB_B_0x1 = 0x1
	// CK Counter Clock (PCLK div 4096) div 4
	WWDG_WWDG_CFR_WDGTB_B_0x2 = 0x2
	// CK Counter Clock (PCLK div 4096) div 8
	WWDG_WWDG_CFR_WDGTB_B_0x3 = 0x3
	// CK Counter Clock (PCLK div 4096) div 16
	WWDG_WWDG_CFR_WDGTB_B_0x4 = 0x4
	// CK Counter Clock (PCLK div 4096) div 32
	WWDG_WWDG_CFR_WDGTB_B_0x5 = 0x5
	// CK Counter Clock (PCLK div 4096) div 64
	WWDG_WWDG_CFR_WDGTB_B_0x6 = 0x6
	// CK Counter Clock (PCLK div 4096) div 128
	WWDG_WWDG_CFR_WDGTB_B_0x7 = 0x7

	// WWDG_SR: Status register
	// Position of EWIF field.
	WWDG_WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_WWDG_SR_EWIF = 0x1
)
