/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.util.logging.OutputController;

public class DocumentAdapter
implements DocumentListener {
    String[] fields;
    int index;
    String property;
    DeploymentConfiguration config;
    int mode;

    public DocumentAdapter(String[] fields, int index) {
        this.fields = fields;
        this.index = index;
        this.mode = 1;
    }

    public DocumentAdapter(DeploymentConfiguration config, String property) {
        this.property = property;
        this.config = config;
        this.mode = 2;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void update(DocumentEvent e) {
        Document d = e.getDocument();
        try {
            String value = d.getText(0, d.getLength()).trim();
            String string = value = value.length() == 0 ? null : value;
            if (this.mode == 1) {
                this.fields[this.index] = value;
            } else if (this.mode == 2) {
                this.config.setProperty(this.property, value);
            }
        }
        catch (BadLocationException e1) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e1);
        }
    }
}

