/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.jmlr;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.generic.MathAccent;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.StoreDataCs;
import com.dickimawbooks.texparserlib.latex.jmlr.AtJmlrIfGraphicxLoaded;
import com.dickimawbooks.texparserlib.latex.jmlr.FloatConts;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrNewTheorem;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrObjectRef;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrObjectTypeRef;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrSet;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrSubFloatRef;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrTheorem;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrVec;
import com.dickimawbooks.texparserlib.latex.jmlr.Proof;
import com.dickimawbooks.texparserlib.latex.jmlr.SubFloat;
import com.dickimawbooks.texparserlib.latex.jmlr.SubFloatLabel;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;

public class JmlrUtilsSty
extends LaTeXSty {
    private boolean supportTheorems = true;
    private boolean supportMaths = true;
    private boolean supportSubFloats = true;

    public JmlrUtilsSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(keyValList, "jmlrutils", laTeXParserListener, bl);
    }

    public JmlrUtilsSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        TeXParser teXParser = this.getParser();
        if (teXParser.getControlSequence("iftablecaptiontop") == null) {
            NewIf.createConditional(true, teXParser, "iftablecaptiontop", true);
        }
        this.registerControlSequence(new GenericCommand("@jmlr@reflistsep", null, laTeXParserListener.createString(", ")));
        this.registerControlSequence(new GenericCommand("@jmlr@reflistlastsep", null, laTeXParserListener.createString(" and ")));
        this.registerControlSequence(new GenericCommand("sectionrefname", null, laTeXParserListener.createString("Section")));
        this.registerControlSequence(new GenericCommand("sectionsrefname", null, laTeXParserListener.createString("Sections")));
        this.registerControlSequence(new GenericCommand("equationrefname", null, laTeXParserListener.createString("Equation")));
        this.registerControlSequence(new GenericCommand("equationsrefname", null, laTeXParserListener.createString("Equations")));
        this.registerControlSequence(new GenericCommand("tablerefname", null, laTeXParserListener.createString("Table")));
        this.registerControlSequence(new GenericCommand("tablesrefname", null, laTeXParserListener.createString("Tables")));
        this.registerControlSequence(new GenericCommand("figurerefname", null, laTeXParserListener.createString("Figure")));
        this.registerControlSequence(new GenericCommand("figuresrefname", null, laTeXParserListener.createString("Figures")));
        this.registerControlSequence(new GenericCommand("algorithmrefname", null, laTeXParserListener.createString("Algorithm")));
        this.registerControlSequence(new GenericCommand("algorithmsrefname", null, laTeXParserListener.createString("Algorithms")));
        this.registerControlSequence(new GenericCommand("theoremrefname", null, laTeXParserListener.createString("Theorem")));
        this.registerControlSequence(new GenericCommand("theoremsrefname", null, laTeXParserListener.createString("Theorems")));
        this.registerControlSequence(new GenericCommand("lemmarefname", null, laTeXParserListener.createString("Lemma")));
        this.registerControlSequence(new GenericCommand("lemmasrefname", null, laTeXParserListener.createString("Lemmas")));
        this.registerControlSequence(new GenericCommand("remarkrefname", null, laTeXParserListener.createString("Remark")));
        this.registerControlSequence(new GenericCommand("remarksrefname", null, laTeXParserListener.createString("Remarks")));
        this.registerControlSequence(new GenericCommand("corollaryrefname", null, laTeXParserListener.createString("Corollary")));
        this.registerControlSequence(new GenericCommand("corollarysrefname", null, laTeXParserListener.createString("Corollaries")));
        this.registerControlSequence(new GenericCommand("definitionrefname", null, laTeXParserListener.createString("Definition")));
        this.registerControlSequence(new GenericCommand("definitionsrefname", null, laTeXParserListener.createString("Definitions")));
        this.registerControlSequence(new GenericCommand("conjecturerefname", null, laTeXParserListener.createString("Conjecture")));
        this.registerControlSequence(new GenericCommand("conjecturesrefname", null, laTeXParserListener.createString("Conjectures")));
        this.registerControlSequence(new GenericCommand("axiomrefname", null, laTeXParserListener.createString("Axiom")));
        this.registerControlSequence(new GenericCommand("axiomsrefname", null, laTeXParserListener.createString("Axioms")));
        this.registerControlSequence(new GenericCommand("examplerefname", null, laTeXParserListener.createString("Example")));
        this.registerControlSequence(new GenericCommand("examplesrefname", null, laTeXParserListener.createString("Examples")));
        this.registerControlSequence(new GenericCommand("appendixrefname", null, laTeXParserListener.createString("Appendix")));
        this.registerControlSequence(new GenericCommand("appendixsrefname", null, laTeXParserListener.createString("Appendices")));
        this.registerControlSequence(new GenericCommand("partrefname", null, laTeXParserListener.createString("Part")));
        this.registerControlSequence(new GenericCommand("partsrefname", null, laTeXParserListener.createString("Parts")));
        this.registerControlSequence(new JmlrObjectRef());
        this.registerControlSequence(new JmlrObjectTypeRef("section"));
        this.registerControlSequence(new JmlrObjectTypeRef("equation", laTeXParserListener.createString("("), laTeXParserListener.createString(")")));
        this.registerControlSequence(new JmlrObjectTypeRef("table"));
        this.registerControlSequence(new JmlrObjectTypeRef("figure"));
        this.registerControlSequence(new JmlrObjectTypeRef("algorithm"));
        this.registerControlSequence(new JmlrObjectTypeRef("theorem"));
        this.registerControlSequence(new JmlrObjectTypeRef("lemma"));
        this.registerControlSequence(new JmlrObjectTypeRef("remark"));
        this.registerControlSequence(new JmlrObjectTypeRef("corollary"));
        this.registerControlSequence(new JmlrObjectTypeRef("definition"));
        this.registerControlSequence(new JmlrObjectTypeRef("conjecture"));
        this.registerControlSequence(new JmlrObjectTypeRef("axiom"));
        this.registerControlSequence(new JmlrObjectTypeRef("exampleref"));
        this.registerControlSequence(new JmlrObjectTypeRef("appendix"));
        this.registerControlSequence(new JmlrObjectTypeRef("part"));
        this.registerControlSequence(new FloatConts());
        this.registerControlSequence(new FloatConts("table"));
        this.registerControlSequence(new FloatConts("figure"));
        this.registerControlSequence(new AtJmlrIfGraphicxLoaded());
        if (this.supportSubFloats) {
            this.newsubfloat("figure", "fig");
            this.newsubfloat("table", "tab");
            NewIf.createConditional(true, teXParser, "ifjmlrutilssubfloats", true);
        } else {
            NewIf.createConditional(true, teXParser, "ifjmlrutilssubfloats", false);
        }
        if (this.supportMaths) {
            this.registerControlSequence(new JmlrSet());
            this.registerControlSequence(new MathAccent("orgvec", 8407));
            this.registerControlSequence(new JmlrVec());
            NewIf.createConditional(true, teXParser, "ifjmlrutilsmaths", true);
        } else {
            NewIf.createConditional(true, teXParser, "ifjmlrutilsmaths", false);
        }
        if (this.supportTheorems) {
            this.registerControlSequence(new GenericCommand("jmlrBlackBox", null, laTeXParserListener.createString("\u220e")));
            this.registerControlSequence(new GenericCommand(false, "jmlrQED", null, new TeXObject[]{new TeXCsRef("hfill"), new TeXCsRef("textup"), new TeXCsRef("jmlrBlackBox"), new TeXCsRef("par"), new TeXCsRef("bigskip")}));
            this.registerControlSequence(new Proof());
            this.registerControlSequence(new GenericCommand("proofname", null, laTeXParserListener.createString("Proof")));
            this.registerControlSequence(new GenericCommand(true, "@theorembodyfont", null, new TeXObject[]{new TeXCsRef("normalfont"), new TeXCsRef("itshape")}));
            this.registerControlSequence(new GenericCommand(true, "@theoremheaderfont", null, new TeXObject[]{new TeXCsRef("normalfont"), new TeXCsRef("bfseries")}));
            this.registerControlSequence(new GenericCommand("@theoremsep"));
            this.registerControlSequence(new GenericCommand("@theorempostheader"));
            this.registerControlSequence(new StoreDataCs("theorembodyfont"));
            this.registerControlSequence(new StoreDataCs("theoremheaderfont"));
            this.registerControlSequence(new StoreDataCs("theoremsep"));
            this.registerControlSequence(new StoreDataCs("theorempostheader"));
            this.registerControlSequence(new JmlrNewTheorem(this));
            this.newtheorem("theorem", "theorem", "Theorem", null);
            this.newtheorem("example", "example", "Example", null);
            this.newtheorem("lemma", "theorem", "Lemma", null);
            this.newtheorem("proposition", "theorem", "Proposition", null);
            this.newtheorem("remark", "theorem", "Remark", null);
            this.newtheorem("corollary", "theorem", "Corollary", null);
            this.newtheorem("definition", "theorem", "Definition", null);
            this.newtheorem("conjecture", "theorem", "Conjecture", null);
            this.newtheorem("axiom", "theorem", "Axiom", null);
            NewIf.createConditional(true, teXParser, "ifjmlrutilstheorems", true);
        } else {
            NewIf.createConditional(true, teXParser, "ifjmlrutilstheorems", false);
        }
    }

    @Override
    protected void postOptions() throws IOException {
        this.getListener().requirepackage(null, "etoolbox", false);
        if (this.supportMaths) {
            this.getListener().requirepackage(null, "amsmath", false);
        }
        this.addDefinitions();
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("maths")) {
            this.supportMaths = true;
        } else if (string.equals("nomaths")) {
            this.supportMaths = false;
        } else if (string.equals("theorems")) {
            this.supportTheorems = true;
        } else if (string.equals("notheorems")) {
            this.supportTheorems = false;
        } else if (string.equals("subfloats")) {
            this.supportSubFloats = true;
        } else if (string.equals("nosubfloats")) {
            this.supportSubFloats = false;
        }
    }

    public void newsubfloat(String string, String string2) {
        String string3 = "sub" + string;
        this.listener.newcounter(string3, null, "@alph");
        this.listener.addtoreset(string3, string);
        this.registerControlSequence(new SubFloat(string));
        String string4 = String.format("sub%slabel", string);
        this.registerControlSequence(new SubFloatLabel(string4));
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this.listener.getParam(1));
        teXObjectList.add(new TeXCsRef(string4));
        this.registerControlSequence(new GenericCommand(this.listener, true, String.format("@%slabel", string3), 1, teXObjectList));
        this.registerControlSequence(new JmlrSubFloatRef(String.format("sub%sref", string2), string));
    }

    public void newtheorem(String string, String string2, String string3, String string4) {
        this.newtheorem(string, string2, this.getListener().createString(string3), string4);
    }

    public void newtheorem(String string, String string2, TeXObject teXObject, String string3) {
        this.addTheoremControlSequence(string, "body@font", "@theorembodyfont");
        this.addTheoremControlSequence(string, "header@font", "@theoremheaderfont");
        this.addTheoremControlSequence(string, "sep", "@theoremsep");
        this.addTheoremControlSequence(string, "postheader", "@theorempostheader");
        if (string2 != null && this.getParser().getSettings().getRegister("c@" + string2) == null) {
            this.getListener().newcounter(string2, string3);
        }
        this.registerControlSequence(new JmlrTheorem(string, string2, teXObject));
    }

    protected void addTheoremControlSequence(String string, String string2, String string3) {
        TeXParser teXParser = this.getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(string3);
        TeXObjectList teXObjectList = null;
        if (controlSequence instanceof GenericCommand) {
            teXObjectList = ((GenericCommand)controlSequence).getDefinition();
        } else if (controlSequence instanceof Expandable) {
            try {
                teXObjectList = ((Expandable)((Object)controlSequence)).expandonce(teXParser);
            }
            catch (IOException iOException) {
                this.getListener().getTeXApp().warning(this.getParser(), iOException.getMessage());
            }
        }
        if (teXObjectList == null) {
            teXObjectList = new TeXObjectList();
            teXObjectList.add(controlSequence);
        }
        this.registerControlSequence(new GenericCommand(String.format("jmlr@thm@%s@%s", string, string2), null, teXObjectList));
    }
}

