/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class RightAngleBuildingTest
extends Test {
    protected double maxAngleDelta;
    protected double minAngleDelta;

    public RightAngleBuildingTest() {
        super(I18n.tr("Almost right angle buildings", new Object[0]), I18n.tr("Checks for buildings that have angles close to right angle and are not orthogonalized.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (!(w.isUsable() && w.isClosed() && RightAngleBuildingTest.isBuilding(w) && IN_DOWNLOADED_AREA_STRICT.test(w))) {
            return;
        }
        List<Pair<Double, Node>> angles = w.getAngles();
        for (Pair<Double, Node> pair : angles) {
            if (!this.checkAngle((Double)pair.a)) continue;
            TestError.Builder builder = TestError.builder(this, Severity.OTHER, 3701).message(I18n.tr("Building with an almost square angle", new Object[0])).primitives(w).highlight((OsmPrimitive)pair.b);
            this.errors.add(builder.build());
            return;
        }
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.maxAngleDelta = Config.getPref().getDouble("validator.RightAngleBuilding.maximumDelta", 10.0);
        this.minAngleDelta = Config.getPref().getDouble("validator.RightAngleBuilding.minimumDelta", 1.0);
    }

    private boolean checkAngle(double angle) {
        double difference = Math.abs(angle - 90.0);
        return difference > this.minAngleDelta && difference < this.maxAngleDelta;
    }
}

