/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.UserConfig;
import org.languagetool.language.Demo;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleCacheTest {
    private JLanguageTool lt;
    private ResultCache cache;
    private RemoteRule rule;
    private final ExecutorService remoteRulePool = Executors.newCachedThreadPool();

    @Before
    public void init() {
        this.cache = new ResultCache(1000L);
        this.lt = new JLanguageTool((Language)new FakeLanguage(), this.cache, new UserConfig());
        this.rule = new TestRemoteRule();
        this.lt.addRule((Rule)this.rule);
    }

    private List<RuleMatch> check(String text) {
        AnnotatedText annotatedText = new AnnotatedTextBuilder().addText(text).build();
        try {
            return this.lt.check(annotatedText, true, JLanguageTool.ParagraphHandling.NORMAL, null, JLanguageTool.Mode.ALL, JLanguageTool.Level.DEFAULT, this.remoteRulePool);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testDuplicateSentence() throws IOException {
        String text = "Foo. Foo. Bar.";
        List sentences = this.lt.analyzeText(text);
        List<AnalyzedSentence> distinct = sentences.stream().distinct().collect(Collectors.toList());
        System.out.println("distinct sentences");
        distinct.forEach(System.out::println);
        Assert.assertThat((Object)distinct.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        List<RuleMatch> directMatches = sentences.stream().flatMap(s -> {
            try {
                return Arrays.stream(this.rule.match(s));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List<RuleMatch> matches = this.check(text);
        System.out.println("direct matches");
        directMatches.forEach(System.out::println);
        System.out.println("matches");
        matches.forEach(System.out::println);
        Assert.assertThat((String)"Test rule matches when called directly", (Object)directMatches.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        Assert.assertThat((String)"Matches are collected and transformed correctly", (Object)matches.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        Assert.assertThat((String)"Correct offsets", matches.stream().map(RuleMatch::getFromPos).collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(0, 5, 10)));
        List<RuleMatch> cachedMatches = this.check(text);
        Assert.assertThat((String)"Cached Matches are collected and transformed correctly", (Object)cachedMatches.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        Assert.assertThat((String)"Correct cached offsets", cachedMatches.stream().map(RuleMatch::getFromPos).collect(Collectors.toList()), (Matcher)CoreMatchers.equalTo(Arrays.asList(0, 5, 10)));
    }

    static class TestRemoteRule
    extends RemoteRule {
        private static final RemoteRuleConfig testConfig = new RemoteRuleConfig("TEST_REMOTE_RULE", "example.com", Integer.valueOf(1234), Integer.valueOf(0), Long.valueOf(0L), Float.valueOf(0.0f), Integer.valueOf(1), Long.valueOf(10L), Collections.emptyMap());

        TestRemoteRule() {
            super((Language)new Demo(), JLanguageTool.getMessageBundle(), testConfig, false);
        }

        protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences, Long textSessionId) {
            return new TestRemoteRequest(sentences);
        }

        private RuleMatch testMatch(AnalyzedSentence s) {
            return new RuleMatch((Rule)this, s, 0, 1, "Test match");
        }

        protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest request, long timeoutMilliseconds) throws TimeoutException {
            return () -> {
                TestRemoteRequest req = (TestRemoteRequest)request;
                List matches = req.sentences.stream().map(this::testMatch).collect(Collectors.toList());
                return new RemoteRuleResult(true, true, matches, req.sentences);
            };
        }

        protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
            TestRemoteRequest req = (TestRemoteRequest)request;
            return new RemoteRuleResult(false, false, Collections.emptyList(), req.sentences);
        }

        public String getDescription() {
            return "TEST REMOTE RULE";
        }

        class TestRemoteRequest
        extends RemoteRule.RemoteRequest {
            private final List<AnalyzedSentence> sentences;

            TestRemoteRequest(List<AnalyzedSentence> sentences) {
                super((RemoteRule)TestRemoteRule.this);
                this.sentences = sentences;
            }
        }
    }
}

