/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.configuration;

import com.hankcs.hanlp.dependency.perceptron.structures.Sentence;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import java.io.Serializable;
import java.util.ArrayList;

public class Configuration
implements Comparable,
Cloneable,
Serializable {
    public Sentence sentence;
    public State state;
    public ArrayList<Integer> actionHistory;
    public float score;

    public Configuration(Sentence sentence, boolean rootFirst) {
        this.sentence = sentence;
        this.state = new State(sentence.size(), rootFirst);
        this.score = 0.0f;
        this.actionHistory = new ArrayList(2 * (sentence.size() + 1));
    }

    public Configuration(Sentence sentence) {
        this.sentence = sentence;
        this.state = new State(sentence.size());
        this.score = 0.0f;
        this.actionHistory = new ArrayList(2 * (sentence.size() + 1));
    }

    public float getScore(boolean normalized) {
        return this.score;
    }

    public void addScore(float score) {
        this.score += score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void addAction(int action) {
        this.actionHistory.add(action);
    }

    public int compareTo(Object o) {
        if (!(o instanceof Configuration)) {
            return this.hashCode() - o.hashCode();
        }
        Configuration configuration = (Configuration)o;
        float diff = this.getScore(true) - configuration.getScore(true);
        if (diff > 0.0f) {
            return (int)Math.ceil(diff);
        }
        if (diff < 0.0f) {
            return (int)Math.floor(diff);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Configuration) {
            Configuration configuration = (Configuration)o;
            if (configuration.score != this.score) {
                return false;
            }
            if (configuration.actionHistory.size() != this.actionHistory.size()) {
                return false;
            }
            for (int i = 0; i < this.actionHistory.size(); ++i) {
                if (this.actionHistory.get(i).equals(configuration.actionHistory.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Configuration clone() {
        Configuration configuration = new Configuration(this.sentence);
        configuration.actionHistory = new ArrayList<Integer>(this.actionHistory);
        configuration.score = this.score;
        configuration.state = this.state.clone();
        return configuration;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        for (int action : this.actionHistory) {
            hashCode += action << i++;
        }
        hashCode = (int)((float)hashCode + this.score);
        return hashCode;
    }
}

