/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.GeneralizedStrip;
import com.sun.j3d.utils.geometry.compression.GeneralizedStripFlags;
import java.util.ArrayList;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.PointArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class GeneralizedVertexList
implements GeneralizedStripFlags {
    private ArrayList vertices;
    private boolean hasColor3 = false;
    private boolean hasColor4 = false;
    private boolean hasNormals = false;
    private int frontFace;
    int stripCount;
    int vertexCount;
    int triangleCount;
    int vertexFormat;

    GeneralizedVertexList(int n, int n2, int n3) {
        this.frontFace = n2;
        this.setVertexFormat(n);
        this.vertices = n3 == 0 ? new ArrayList() : new ArrayList(n3);
        this.stripCount = 0;
        this.vertexCount = 0;
        this.triangleCount = 0;
    }

    GeneralizedVertexList(int n, int n2) {
        this(n, n2, 0);
    }

    void setVertexFormat(int n) {
        this.vertexFormat = n;
        if ((n & 2) != 0) {
            this.hasNormals = true;
        }
        if ((n & 0xC) == 12) {
            this.hasColor4 = true;
        } else if ((n & 4) == 4) {
            this.hasColor3 = true;
        }
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
        this.vertices.add(new Vertex(point3f, vector3f, color4f, n));
    }

    int size() {
        return this.vertices.size();
    }

    public int getFlagCount() {
        return this.vertices.size();
    }

    public int getFlag(int n) {
        return ((Vertex)this.vertices.get((int)n)).flag;
    }

    private void copyVertexData(GeometryArray geometryArray, GeneralizedStrip.IntList intList) {
        Point3f[] point3fArray = new Point3f[intList.count];
        if (this.hasNormals) {
            Vector3f[] vector3fArray = new Vector3f[intList.count];
            if (this.hasColor3) {
                Color3f[] color3fArray = new Color3f[intList.count];
                for (int i = 0; i < intList.count; ++i) {
                    Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                    point3fArray[i] = vertex.coord;
                    vector3fArray[i] = vertex.normal;
                    color3fArray[i] = vertex.color3;
                }
                geometryArray.setColors(0, color3fArray);
            } else if (this.hasColor4) {
                Color4f[] color4fArray = new Color4f[intList.count];
                for (int i = 0; i < intList.count; ++i) {
                    Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                    point3fArray[i] = vertex.coord;
                    vector3fArray[i] = vertex.normal;
                    color4fArray[i] = vertex.color4;
                }
                geometryArray.setColors(0, color4fArray);
            } else {
                for (int i = 0; i < intList.count; ++i) {
                    Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                    point3fArray[i] = vertex.coord;
                    vector3fArray[i] = vertex.normal;
                }
            }
            geometryArray.setNormals(0, vector3fArray);
        } else if (this.hasColor3) {
            Color3f[] color3fArray = new Color3f[intList.count];
            for (int i = 0; i < intList.count; ++i) {
                Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                point3fArray[i] = vertex.coord;
                color3fArray[i] = vertex.color3;
            }
            geometryArray.setColors(0, color3fArray);
        } else if (this.hasColor4) {
            Color4f[] color4fArray = new Color4f[intList.count];
            for (int i = 0; i < intList.count; ++i) {
                Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                point3fArray[i] = vertex.coord;
                color4fArray[i] = vertex.color4;
            }
            geometryArray.setColors(0, color4fArray);
        } else {
            for (int i = 0; i < intList.count; ++i) {
                Vertex vertex = (Vertex)this.vertices.get(intList.ints[i]);
                point3fArray[i] = vertex.coord;
            }
        }
        geometryArray.setCoordinates(0, point3fArray);
    }

    PointArray toPointArray() {
        int n = this.vertices.size();
        if (n > 0) {
            PointArray pointArray = new PointArray(n, this.vertexFormat);
            GeneralizedStrip.IntList intList = new GeneralizedStrip.IntList(n);
            intList.fillAscending();
            this.copyVertexData((GeometryArray)pointArray, intList);
            this.vertexCount += n;
            return pointArray;
        }
        return null;
    }

    TriangleArray toTriangleArray() {
        int[] nArray = GeneralizedStrip.toTriangles(this, this.frontFace);
        if (nArray != null) {
            TriangleArray triangleArray = new TriangleArray(nArray.length, this.vertexFormat);
            GeneralizedStrip.IntList intList = new GeneralizedStrip.IntList(nArray);
            this.copyVertexData((GeometryArray)triangleArray, intList);
            this.vertexCount += nArray.length;
            this.triangleCount += nArray.length / 3;
            return triangleArray;
        }
        return null;
    }

    LineStripArray toLineStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toLineStrips(this);
        if (stripArray != null) {
            LineStripArray lineStripArray = new LineStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData((GeometryArray)lineStripArray, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return lineStripArray;
        }
        return null;
    }

    TriangleStripArray toTriangleStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toTriangleStrips(this, this.frontFace);
        if (stripArray != null) {
            TriangleStripArray triangleStripArray = new TriangleStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData((GeometryArray)triangleStripArray, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return triangleStripArray;
        }
        return null;
    }

    GeometryStripArray[] toStripAndFanArrays() {
        GeneralizedStrip.StripArray[] stripArrayArray = GeneralizedStrip.toStripsAndFans(this, this.frontFace);
        GeometryStripArray[] geometryStripArrayArray = new GeometryStripArray[2];
        if (stripArrayArray[0] != null) {
            geometryStripArrayArray[0] = new TriangleStripArray(stripArrayArray[0].vertices.count, this.vertexFormat, stripArrayArray[0].stripCounts.trim());
            this.copyVertexData((GeometryArray)geometryStripArrayArray[0], stripArrayArray[0].vertices);
            this.vertexCount += stripArrayArray[0].vertices.count;
            this.stripCount += stripArrayArray[0].stripCounts.count;
        }
        if (stripArrayArray[1] != null) {
            geometryStripArrayArray[1] = new TriangleFanArray(stripArrayArray[1].vertices.count, this.vertexFormat, stripArrayArray[1].stripCounts.trim());
            this.copyVertexData((GeometryArray)geometryStripArrayArray[1], stripArrayArray[1].vertices);
            this.vertexCount += stripArrayArray[1].vertices.count;
            this.stripCount += stripArrayArray[1].stripCounts.count;
        }
        return geometryStripArrayArray;
    }

    GeometryArray[] toStripAndTriangleArrays() {
        GeneralizedStrip.StripArray[] stripArrayArray = GeneralizedStrip.toStripsAndTriangles(this, this.frontFace, 4, 12);
        GeometryArray[] geometryArrayArray = new GeometryArray[2];
        if (stripArrayArray[0] != null) {
            geometryArrayArray[0] = new TriangleStripArray(stripArrayArray[0].vertices.count, this.vertexFormat, stripArrayArray[0].stripCounts.trim());
            this.copyVertexData(geometryArrayArray[0], stripArrayArray[0].vertices);
            this.vertexCount += stripArrayArray[0].vertices.count;
            this.stripCount += stripArrayArray[0].stripCounts.count;
        }
        if (stripArrayArray[1] != null) {
            geometryArrayArray[1] = new TriangleArray(stripArrayArray[1].vertices.count, this.vertexFormat);
            this.copyVertexData(geometryArrayArray[1], stripArrayArray[1].vertices);
            this.triangleCount += stripArrayArray[1].vertices.count / 3;
        }
        return geometryArrayArray;
    }

    class Vertex {
        int flag;
        Point3f coord;
        Color3f color3;
        Color4f color4;
        Vector3f normal;

        Vertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
            this.flag = n;
            this.coord = new Point3f(point3f);
            if (GeneralizedVertexList.this.hasNormals) {
                this.normal = new Vector3f(vector3f);
            }
            if (GeneralizedVertexList.this.hasColor3) {
                this.color3 = new Color3f(color4f.x, color4f.y, color4f.z);
            } else if (GeneralizedVertexList.this.hasColor4) {
                this.color4 = new Color4f(color4f);
            }
        }
    }
}

