/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.MetaIndex;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.misc.VM;
import sun.net.www.ParseUtil;
import sun.nio.fs.DefaultFileSystemProvider;

public class Launcher {
    private static URLStreamHandlerFactory factory = new Factory();
    private static Launcher launcher = new Launcher();
    private static String bootClassPath = System.getProperty("sun.boot.class.path");
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    public Launcher() {
        ExtClassLoader extcl;
        try {
            extcl = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException e) {
            throw new InternalError("Could not create extension class loader");
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extcl);
        }
        catch (IOException e) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        String s = System.getProperty("java.security.manager");
        if (s != null) {
            DefaultFileSystemProvider.create();
            SecurityManager sm = null;
            if ("".equals(s) || "default".equals(s)) {
                sm = new SecurityManager();
            } else {
                try {
                    sm = (SecurityManager)this.loader.loadClass(s).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (sm != null) {
                System.setSecurityManager(sm);
            } else {
                throw new InternalError("Could not create SecurityManager: " + s);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static URLClassPath getBootstrapClassPath() {
        return BootClassPathHolder.bcp;
    }

    private static URL[] pathToURLs(File[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = Launcher.getFileURL(path[i]);
        }
        return urls;
    }

    private static File[] getClassPath(String cp) {
        File[] path;
        if (cp != null) {
            int count = 0;
            int maxCount = 1;
            int pos = 0;
            int lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                ++maxCount;
                lastPos = pos + 1;
            }
            path = new File[maxCount];
            pos = 0;
            lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                path[count++] = pos - lastPos > 0 ? new File(cp.substring(lastPos, pos)) : new File(".");
                lastPos = pos + 1;
            }
            path[count++] = lastPos < cp.length() ? new File(cp.substring(lastPos)) : new File(".");
            if (count != maxCount) {
                File[] tmp = new File[count];
                System.arraycopy(path, 0, tmp, 0, count);
                path = tmp;
            }
        } else {
            path = new File[]{};
        }
        return path;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException e) {
            throw new InternalError();
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            String name = PREFIX + "." + protocol + ".Handler";
            try {
                Class<?> c = Class.forName(name);
                return (URLStreamHandler)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            throw new InternalError("could not load " + protocol + "system protocol handler");
        }
    }

    private static class BootClassPathHolder {
        static final URLClassPath bcp;

        private BootClassPathHolder() {
        }

        static {
            URL[] urls = bootClassPath != null ? AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

                @Override
                public URL[] run() {
                    File[] classPath = Launcher.getClassPath(bootClassPath);
                    int len = classPath.length;
                    HashSet<File> seenDirs = new HashSet<File>();
                    for (int i = 0; i < len; ++i) {
                        File curEntry = classPath[i];
                        if (!curEntry.isDirectory()) {
                            curEntry = curEntry.getParentFile();
                        }
                        if (curEntry == null || !seenDirs.add(curEntry)) continue;
                        MetaIndex.registerDirectory(curEntry);
                    }
                    return Launcher.pathToURLs(classPath);
                }
            }) : new URL[]{};
            bcp = new URLClassPath(urls, factory, null);
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(final ClassLoader extcl) throws IOException {
            final String s = System.getProperty("java.class.path");
            final File[] path = s == null ? new File[]{} : Launcher.getClassPath(s);
            return AccessController.doPrivileged(new PrivilegedAction<AppClassLoader>(){

                @Override
                public AppClassLoader run() {
                    URL[] urls = s == null ? new URL[]{} : Launcher.pathToURLs(path);
                    return new AppClassLoader(urls, extcl);
                }
            });
        }

        AppClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent, factory);
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            SecurityManager sm;
            int i = name.lastIndexOf(46);
            if (i != -1 && (sm = System.getSecurityManager()) != null) {
                sm.checkPackageAccess(name.substring(0, i));
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(new RuntimePermission("exitVM"));
            return perms;
        }

        private void appendToClassPathForInstrumentation(String path) {
            assert (Thread.holdsLock(this));
            super.addURL(Launcher.getFileURL(new File(path)));
        }

        private static AccessControlContext getContext(File[] cp) throws MalformedURLException {
            PathPermissions perms = new PathPermissions(cp);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private static volatile ExtClassLoader instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ExtClassLoader getExtClassLoader() throws IOException {
            if (instance != null) return instance;
            Class<ExtClassLoader> clazz = ExtClassLoader.class;
            synchronized (ExtClassLoader.class) {
                if (instance != null) return instance;
                instance = ExtClassLoader.createExtClassLoader();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static ExtClassLoader createExtClassLoader() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ExtClassLoader>(){

                    @Override
                    public ExtClassLoader run() throws IOException {
                        File[] dirs = ExtClassLoader.getExtDirs();
                        int len = dirs.length;
                        for (int i = 0; i < len; ++i) {
                            MetaIndex.registerDirectory(dirs[i]);
                        }
                        return new ExtClassLoader(dirs);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }

        void addExtURL(URL url) {
            super.addURL(url);
        }

        public ExtClassLoader(File[] dirs) throws IOException {
            super(ExtClassLoader.getExtURLs(dirs), null, factory);
        }

        private static File[] getExtDirs() {
            File[] dirs;
            String s = System.getProperty("java.ext.dirs");
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
                int count = st.countTokens();
                dirs = new File[count];
                for (int i = 0; i < count; ++i) {
                    dirs[i] = new File(st.nextToken());
                }
            } else {
                dirs = new File[]{};
            }
            return dirs;
        }

        private static URL[] getExtURLs(File[] dirs) throws IOException {
            Vector<URL> urls = new Vector<URL>();
            for (int i = 0; i < dirs.length; ++i) {
                String[] files = dirs[i].list();
                if (files == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    if (files[j].equals("meta-index")) continue;
                    File f = new File(dirs[i], files[j]);
                    urls.add(Launcher.getFileURL(f));
                }
            }
            Object[] ua = new URL[urls.size()];
            urls.copyInto(ua);
            return ua;
        }

        @Override
        public String findLibrary(String name) {
            name = System.mapLibraryName(name);
            URL[] urls = super.getURLs();
            File prevDir = null;
            for (int i = 0; i < urls.length; ++i) {
                URI uri;
                try {
                    uri = urls[i].toURI();
                }
                catch (URISyntaxException ue) {
                    continue;
                }
                File dir = new File(uri).getParentFile();
                if (dir != null && !dir.equals(prevDir)) {
                    File file;
                    String arch = VM.getSavedProperty("os.arch");
                    if (arch != null && (file = new File(new File(dir, arch), name)).exists()) {
                        return file.getAbsolutePath();
                    }
                    file = new File(dir, name);
                    if (file.exists()) {
                        return file.getAbsolutePath();
                    }
                }
                prevDir = dir;
            }
            return null;
        }

        private static AccessControlContext getContext(File[] dirs) throws IOException {
            PathPermissions perms = new PathPermissions(dirs);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }

        static {
            ClassLoader.registerAsParallelCapable();
            instance = null;
        }
    }
}

