/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.AprStatus;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.LibraryNotFoundError;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 2;
    protected static final int TCN_REQUIRED_PATCH = 14;
    protected static final int TCN_RECOMMENDED_MINOR = 2;
    protected static final int TCN_RECOMMENDED_PV = 30;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAprAvailable() {
        if (AprStatus.isInstanceCreated()) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
            }
        }
        return AprStatus.isAprAvailable();
    }

    public AprLifecycleListener() {
        AprStatus.setInstanceCreated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_init".equals(lifecycleEvent.getType())) {
            Object object = lock;
            synchronized (object) {
                Object object2;
                AprLifecycleListener.init();
                for (String object3 : initInfoLogMessages) {
                    log.info((Object)object3);
                }
                initInfoLogMessages.clear();
                if (AprStatus.isAprAvailable()) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable throwable) {
                        object2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                        ExceptionUtils.handleThrowable((Throwable)object2);
                        log.error((Object)sm.getString("aprListener.sslInit"), (Throwable)object2);
                    }
                }
                if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                    object2 = sm.getString("aprListener.initializeFIPSFailed");
                    Error error = new Error((String)object2);
                    log.fatal(object2, (Throwable)error);
                    throw error;
                }
            }
        }
        if ("after_destroy".equals(lifecycleEvent.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!AprStatus.isAprAvailable()) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                    ExceptionUtils.handleThrowable((Throwable)throwable2);
                    log.info((Object)sm.getString("aprListener.aprDestroy"));
                }
            }
        }
    }

    private static void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(string, null);
        method.invoke(null, (Object[])null);
        AprStatus.setAprAvailable(false);
        AprStatus.setAprInitialized(false);
        sslInitialized = false;
        fipsModeActive = false;
    }

    private static void init() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1214;
        int n6 = 1230;
        if (AprStatus.isAprInitialized()) {
            return;
        }
        AprStatus.setAprInitialized(true);
        try {
            Library.initialize(null);
            n = Library.TCN_MAJOR_VERSION;
            n2 = Library.TCN_MINOR_VERSION;
            n3 = Library.TCN_PATCH_VERSION;
            n4 = n * 1000 + n2 * 100 + n3;
        }
        catch (LibraryNotFoundError libraryNotFoundError) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.aprInitDebug", new Object[]{libraryNotFoundError.getLibraryNames(), System.getProperty("java.library.path"), libraryNotFoundError.getMessage()}), (Throwable)libraryNotFoundError);
            }
            initInfoLogMessages.add(sm.getString("aprListener.aprInit", new Object[]{System.getProperty("java.library.path")}));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            log.warn((Object)sm.getString("aprListener.aprInitError", new Object[]{throwable2.getMessage()}), throwable2);
            return;
        }
        if (n4 < n5) {
            log.error((Object)sm.getString("aprListener.tcnInvalid", new Object[]{Library.versionString(), "1.2.14"}));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable3);
            }
            return;
        }
        if (n4 < n6) {
            initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", new Object[]{Library.versionString(), "1.2.30"}));
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", new Object[]{Library.versionString(), Library.aprVersionString()}));
        initInfoLogMessages.add(sm.getString("aprListener.flags", new Object[]{Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM, Library.APR_HAVE_UNIX}));
        AprStatus.setAprAvailable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeSSL() throws Exception {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String string = "randSet";
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(string, classArray);
        method.invoke(null, objectArray);
        string = "initialize";
        objectArray[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(string, classArray);
        method.invoke(null, objectArray);
        if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean bl;
            fipsModeActive = false;
            int n = SSL.fipsModeGet();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.currentFIPSMode", new Object[]{n}));
            }
            if ("on".equalsIgnoreCase(FIPSMode)) {
                if (n == 1) {
                    log.info((Object)sm.getString("aprListener.skipFIPSInitialization"));
                    fipsModeActive = true;
                    bl = false;
                } else {
                    bl = true;
                }
            } else if ("require".equalsIgnoreCase(FIPSMode)) {
                if (n != 1) throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                fipsModeActive = true;
                bl = false;
            } else {
                if (!"enter".equalsIgnoreCase(FIPSMode)) throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", new Object[]{FIPSMode}));
                if (n != 0) throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", new Object[]{n}));
                bl = true;
            }
            if (bl) {
                log.info((Object)sm.getString("aprListener.initializingFIPS"));
                n = SSL.fipsModeSet((int)1);
                if (n != 1) {
                    String string2 = sm.getString("aprListener.initializeFIPSFailed");
                    log.error((Object)string2);
                    throw new IllegalStateException(string2);
                }
                fipsModeActive = true;
                log.info((Object)sm.getString("aprListener.initializeFIPSSuccess"));
            }
        }
        log.info((Object)sm.getString("aprListener.initializedOpenSSL", new Object[]{SSL.versionString()}));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String string) {
        if (!string.equals(SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            SSLEngine = string;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String string) {
        if (!string.equals(SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            SSLRandomSeed = string;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String string) {
        if (!string.equals(FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            FIPSMode = string;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseOpenSSL(boolean bl) {
        if (bl != AprStatus.getUseOpenSSL()) {
            AprStatus.setUseOpenSSL(bl);
        }
    }

    public static boolean getUseOpenSSL() {
        return AprStatus.getUseOpenSSL();
    }

    public static boolean isInstanceCreated() {
        return AprStatus.isInstanceCreated();
    }
}

