/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProcessor<S>
extends AbstractProcessor<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected static final byte[] endMessageArray;
    protected static final byte[] endAndCloseMessageArray;
    protected static final byte[] flushMessageArray;
    protected static final byte[] pongMessageArray;
    private static final Set<String> javaxAttributes;
    private static final Set<String> iisTlsAttributes;
    protected final byte[] getBodyMessageArray;
    protected int packetSize;
    protected AjpMessage requestHeaderMessage = null;
    protected AjpMessage responseMessage = null;
    protected AjpMessage bodyMessage = null;
    protected MessageBytes bodyBytes = MessageBytes.newInstance();
    protected MessageBytes tmpMB = MessageBytes.newInstance();
    protected MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    protected boolean replay = false;
    private boolean swallowResponse = false;
    protected boolean finished = false;
    protected long bytesWritten = 0L;
    protected boolean ajpFlush = true;
    protected int keepAliveTimeout = -1;
    protected boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    @Deprecated
    protected String requiredSecret = null;
    protected String secret = null;
    protected String clientCertProvider = null;
    private Pattern allowedRequestAttributesPatternPattern;

    public AbstractAjpProcessor(int n, AbstractEndpoint<S> abstractEndpoint) {
        super(abstractEndpoint);
        this.packetSize = n;
        this.request.setInputBuffer(new SocketInputBuffer());
        this.requestHeaderMessage = new AjpMessage(n);
        this.responseMessage = new AjpMessage(n);
        this.bodyMessage = new AjpMessage(n);
        AjpMessage ajpMessage = new AjpMessage(16);
        ajpMessage.reset();
        ajpMessage.appendByte(6);
        ajpMessage.appendInt(8186 + n - 8192);
        ajpMessage.end();
        this.getBodyMessageArray = new byte[ajpMessage.getLen()];
        System.arraycopy(ajpMessage.getBuffer(), 0, this.getBodyMessageArray, 0, ajpMessage.getLen());
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean bl) {
        this.ajpFlush = bl;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean bl) {
        this.tomcatAuthentication = bl;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean bl) {
        this.tomcatAuthorization = bl;
    }

    public void setSecret(String string) {
        this.secret = string;
        this.requiredSecret = string;
    }

    @Deprecated
    public void setRequiredSecret(String string) {
        this.setSecret(string);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String string) {
        this.clientCertProvider = string;
    }

    public void setAllowedRequestAttributesPatternPattern(Pattern pattern) {
        this.allowedRequestAttributesPatternPattern = pattern;
    }

    @Override
    public final void action(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case COMMIT: {
                if (this.response.isCommitted()) {
                    return;
                }
                try {
                    this.prepareResponse();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                try {
                    this.flush(false);
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case CLIENT_FLUSH: {
                if (!this.response.isCommitted()) {
                    try {
                        this.prepareResponse();
                    }
                    catch (IOException iOException) {
                        this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                        return;
                    }
                }
                try {
                    this.flush(true);
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)object).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                break;
            }
            case CLOSE: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                if (this.certificates.isNull()) break;
                ByteChunk byteChunk = this.certificates.getByteChunk();
                X509Certificate[] x509CertificateArray = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
                try {
                    CertificateFactory certificateFactory = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                    while (byteArrayInputStream.available() > 0) {
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                        if (x509CertificateArray == null) {
                            x509CertificateArray = new X509Certificate[]{x509Certificate};
                            continue;
                        }
                        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
                        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
                        x509CertificateArray2[x509CertificateArray.length] = x509Certificate;
                        x509CertificateArray = x509CertificateArray2;
                    }
                }
                catch (CertificateException certificateException) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)certificateException);
                    return;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)noSuchProviderException);
                    return;
                }
                this.request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (!this.request.remoteHost().isNull()) break;
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iOException) {}
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (!this.request.localAddr().isNull()) break;
                this.request.localAddr().setString(this.request.localName().toString());
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk byteChunk = (ByteChunk)object;
                int n = byteChunk.getLength();
                this.bodyBytes.setBytes(byteChunk.getBytes(), byteChunk.getStart(), n);
                this.request.setContentLength(n);
                this.first = false;
                this.empty = false;
                this.replay = true;
                this.endOfStream = false;
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)object);
                this.getSocketWrapper().access();
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)object);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case UPGRADE_TOMCAT: {
                break;
            }
            case CLOSE_NOW: {
                this.swallowResponse = true;
                if (object instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)object);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case END_REQUEST: {
                break;
            }
            default: {
                this.actionInternal(actionCode, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus socketStatus) {
        AbstractEndpoint.Handler.SocketState socketState;
        RequestInfo requestInfo = this.request.getRequestProcessor();
        try {
            requestInfo.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, socketStatus)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            this.resetTimeouts();
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.setErrorState(ErrorState.CLOSE_NOW, throwable);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), throwable);
        }
        finally {
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        requestInfo.setStage(7);
        if (this.isAsync()) {
            if (this.getErrorState().isError()) {
                this.request.updateCounters();
                socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
            } else {
                socketState = AbstractEndpoint.Handler.SocketState.LONG;
            }
        } else {
            this.request.updateCounters();
            if (this.getErrorState().isError() || this.endpoint.isPaused()) {
                socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
            } else {
                this.recycle(false);
                socketState = AbstractEndpoint.Handler.SocketState.OPEN;
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Socket: [" + this.socketWrapper + "], Status in: [" + (Object)((Object)socketStatus) + "], State out: [" + (Object)((Object)socketState) + "]"));
        }
        return socketState;
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
        throw new IllegalStateException(sm.getString("ajpprocessor.ssl.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus socketStatus) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.comet.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    @Deprecated
    public UpgradeInbound getUpgradeInbound() {
        return null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus socketStatus) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public HttpUpgradeHandler getHttpUpgradeHandler() {
        throw new IllegalStateException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public void recycle(boolean bl) {
        this.getAdapter().checkRecycled(this.request, this.response);
        this.asyncStateMachine.recycle();
        this.first = true;
        this.endOfStream = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
        this.swallowResponse = false;
        this.bytesWritten = 0L;
        this.resetErrorState();
    }

    protected abstract void actionInternal(ActionCode var1, Object var2);

    protected abstract void resetTimeouts();

    protected abstract void output(byte[] var1, int var2, int var3) throws IOException;

    protected abstract boolean receive() throws IOException;

    @Override
    public final boolean isComet() {
        return false;
    }

    @Override
    public final boolean isUpgrade() {
        return false;
    }

    protected boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        this.output(this.getBodyMessageArray, 0, this.getBodyMessageArray.length);
        boolean bl = this.receive();
        if (!bl) {
            this.endOfStream = true;
        }
        return bl;
    }

    protected void prepareRequest() {
        ByteChunk byteChunk;
        byte by;
        int n;
        boolean bl;
        byte by2 = this.requestHeaderMessage.getByte();
        if (by2 != -1) {
            String string = org.apache.coyote.ajp.Constants.getMethodForCode(by2 - 1);
            this.request.method().setString(string);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl2 = bl = this.requestHeaderMessage.getByte() != 0;
        if (bl) {
            this.request.scheme().setString("https");
        }
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        mimeHeaders.setLimit(this.endpoint.getMaxHeaderCount());
        this.request.getCookies().setLimit(this.getMaxCookieCount());
        boolean bl3 = false;
        int n2 = this.requestHeaderMessage.getInt();
        for (n = 0; n < n2; ++n) {
            ByteChunk byteChunk2;
            String string = null;
            int n3 = this.requestHeaderMessage.peekInt();
            int n4 = n3 & 0xFF;
            MessageBytes messageBytes = null;
            if (40960 == (n3 &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                string = org.apache.coyote.ajp.Constants.getHeaderForCode(n4 - 1);
                messageBytes = mimeHeaders.addValue(string);
            } else {
                n4 = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                byteChunk2 = this.tmpMB.getByteChunk();
                messageBytes = mimeHeaders.addValue(byteChunk2.getBuffer(), byteChunk2.getStart(), byteChunk2.getLength());
            }
            this.requestHeaderMessage.getBytes(messageBytes);
            if (n4 == 8 || n4 == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long l = messageBytes.getLong();
                if (bl3) {
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue;
                }
                bl3 = true;
                this.request.setContentLength(l);
                continue;
            }
            if (n4 != 7 && (n4 != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            byteChunk2 = messageBytes.getByteChunk();
            this.request.contentType().setBytes(byteChunk2.getBytes(), byteChunk2.getOffset(), byteChunk2.getLength());
        }
        n = 0;
        block18: while ((by = this.requestHeaderMessage.getByte()) != -1) {
            switch (by) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String string = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String string2 = this.tmpMB.toString();
                    if (string.equals("AJP_LOCAL_ADDR")) {
                        this.request.localAddr().setString(string2);
                        continue block18;
                    }
                    if (string.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(string2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block18;
                    }
                    if (string.equals("AJP_SSL_PROTOCOL")) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", string2);
                        continue block18;
                    }
                    if (string.equals("JK_LB_ACTIVATION")) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (javaxAttributes.contains(string)) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (iisTlsAttributes.contains(string)) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (this.allowedRequestAttributesPatternPattern != null && this.allowedRequestAttributesPatternPattern.matcher(string).matches()) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    this.getLog().warn((Object)sm.getString("ajpprocessor.unknownAttribute", new Object[]{string}));
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue block18;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 3: {
                    if (this.tomcatAuthorization || !this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                        this.request.setRemoteUserNeedsAuthorization(this.tomcatAuthorization);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    continue block18;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    continue block18;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    continue block18;
                }
                case 7: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.certificates);
                    continue block18;
                }
                case 8: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    continue block18;
                }
                case 9: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", this.tmpMB.toString());
                    continue block18;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", this.requestHeaderMessage.getInt());
                    continue block18;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    continue block18;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.secret == null || this.secret.length() <= 0) continue block18;
                    n = 1;
                    if (this.tmpMB.equals(this.secret)) continue block18;
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue block18;
                }
            }
        }
        if (this.secret != null && this.secret.length() > 0 && n == 0) {
            this.response.setStatus(403);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        }
        if ((byteChunk = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int n5 = byteChunk.indexOf("://", 0, 3, 4);
            int n6 = byteChunk.getStart();
            int n7 = -1;
            if (n5 != -1) {
                byte[] byArray = byteChunk.getBytes();
                n7 = byteChunk.indexOf('/', n5 + 3);
                if (n7 == -1) {
                    n7 = byteChunk.getLength();
                    this.request.requestURI().setBytes(byArray, n6 + n5 + 1, 1);
                } else {
                    this.request.requestURI().setBytes(byArray, n6 + n7, byteChunk.getLength() - n7);
                }
                MessageBytes messageBytes = mimeHeaders.setValue("host");
                messageBytes.setBytes(byArray, n6 + n5 + 3, n7 - n5 - 3);
            }
        }
        MessageBytes messageBytes = this.request.getMimeHeaders().getValue("host");
        this.parseHost(messageBytes);
        if (this.getErrorState().isError()) {
            this.adapter.log(this.request, this.response, 0L);
        }
    }

    @Override
    protected void populateHost() {
        try {
            this.request.serverName().duplicate(this.request.localName());
        }
        catch (IOException iOException) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, iOException);
        }
    }

    @Override
    protected void populatePort() {
        this.request.setServerPort(this.request.getLocalPort());
    }

    protected void prepareResponse() throws IOException {
        long l;
        String string;
        MessageBytes messageBytes;
        this.response.setCommitted(true);
        this.responseMessage.reset();
        this.responseMessage.appendByte(4);
        int n = this.response.getStatus();
        if (n < 200 || n == 204 || n == 205 || n == 304) {
            this.swallowResponse = true;
        }
        if ((messageBytes = this.request.method()).equals("HEAD")) {
            this.swallowResponse = true;
        }
        this.responseMessage.appendInt(n);
        String string2 = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            string2 = this.response.getMessage();
        }
        if (string2 == null) {
            string2 = HttpMessages.getInstance(this.response.getLocale()).getMessage(this.response.getStatus());
        }
        if (string2 == null) {
            string2 = Integer.toString(this.response.getStatus());
        }
        this.tmpMB.setString(string2);
        this.responseMessage.appendBytes(this.tmpMB);
        MimeHeaders mimeHeaders = this.response.getMimeHeaders();
        String string3 = this.response.getContentType();
        if (string3 != null) {
            mimeHeaders.setValue("Content-Type").setString(string3);
        }
        if ((string = this.response.getContentLanguage()) != null) {
            mimeHeaders.setValue("Content-Language").setString(string);
        }
        if ((l = this.response.getContentLengthLong()) >= 0L) {
            mimeHeaders.setValue("Content-Length").setLong(l);
        }
        int n2 = mimeHeaders.size();
        this.responseMessage.appendInt(n2);
        for (int i = 0; i < n2; ++i) {
            MessageBytes messageBytes2 = mimeHeaders.getName(i);
            int n3 = org.apache.coyote.ajp.Constants.getResponseAjpIndex(messageBytes2.toString());
            if (n3 > 0) {
                this.responseMessage.appendInt(n3);
            } else {
                this.responseMessage.appendBytes(messageBytes2);
            }
            MessageBytes messageBytes3 = mimeHeaders.getValue(i);
            this.responseMessage.appendBytes(messageBytes3);
        }
        this.responseMessage.end();
        this.output(this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
    }

    protected void flush(boolean bl) throws IOException {
        if (this.ajpFlush && bl && !this.finished) {
            this.output(flushMessageArray, 0, flushMessageArray.length);
        }
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                return;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.first && this.request.getContentLengthLong() > 0L) {
            this.receive();
        }
        if (this.getErrorState().isError()) {
            this.output(endAndCloseMessageArray, 0, endAndCloseMessageArray.length);
        } else {
            this.output(endMessageArray, 0, endMessageArray.length);
        }
    }

    static {
        AjpMessage ajpMessage = new AjpMessage(16);
        ajpMessage.reset();
        ajpMessage.appendByte(5);
        ajpMessage.appendByte(1);
        ajpMessage.end();
        endMessageArray = new byte[ajpMessage.getLen()];
        System.arraycopy(ajpMessage.getBuffer(), 0, endMessageArray, 0, ajpMessage.getLen());
        AjpMessage ajpMessage2 = new AjpMessage(16);
        ajpMessage2.reset();
        ajpMessage2.appendByte(5);
        ajpMessage2.appendByte(0);
        ajpMessage2.end();
        endAndCloseMessageArray = new byte[ajpMessage2.getLen()];
        System.arraycopy(ajpMessage2.getBuffer(), 0, endAndCloseMessageArray, 0, ajpMessage2.getLen());
        AjpMessage ajpMessage3 = new AjpMessage(16);
        ajpMessage3.reset();
        ajpMessage3.appendByte(3);
        ajpMessage3.appendInt(0);
        ajpMessage3.appendByte(0);
        ajpMessage3.end();
        flushMessageArray = new byte[ajpMessage3.getLen()];
        System.arraycopy(ajpMessage3.getBuffer(), 0, flushMessageArray, 0, ajpMessage3.getLen());
        AjpMessage ajpMessage4 = new AjpMessage(16);
        ajpMessage4.reset();
        ajpMessage4.appendByte(9);
        ajpMessage4.end();
        pongMessageArray = new byte[ajpMessage4.getLen()];
        System.arraycopy(ajpMessage4.getBuffer(), 0, pongMessageArray, 0, ajpMessage4.getLen());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.servlet.request.cipher_suite");
        hashSet.add("javax.servlet.request.key_size");
        hashSet.add("javax.servlet.request.ssl_session");
        hashSet.add("javax.servlet.request.X509Certificate");
        javaxAttributes = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("CERT_ISSUER");
        hashSet2.add("CERT_SUBJECT");
        hashSet2.add("CERT_COOKIE");
        hashSet2.add("HTTPS_SERVER_SUBJECT");
        hashSet2.add("CERT_FLAGS");
        hashSet2.add("HTTPS_SECRETKEYSIZE");
        hashSet2.add("CERT_SERIALNUMBER");
        hashSet2.add("HTTPS_SERVER_ISSUER");
        hashSet2.add("HTTPS_KEYSIZE");
        iisTlsAttributes = Collections.unmodifiableSet(hashSet2);
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
            if (!AbstractAjpProcessor.this.response.isCommitted()) {
                try {
                    AbstractAjpProcessor.this.prepareResponse();
                }
                catch (IOException iOException) {
                    AbstractAjpProcessor.this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                }
            }
            if (!AbstractAjpProcessor.this.swallowResponse) {
                try {
                    int n = byteChunk.getLength();
                    int n2 = 8184 + AbstractAjpProcessor.this.packetSize - 8192;
                    int n3 = 0;
                    while (n > 0) {
                        int n4 = n;
                        if (n4 > n2) {
                            n4 = n2;
                        }
                        n -= n4;
                        AbstractAjpProcessor.this.responseMessage.reset();
                        AbstractAjpProcessor.this.responseMessage.appendByte(3);
                        AbstractAjpProcessor.this.responseMessage.appendBytes(byteChunk.getBytes(), byteChunk.getOffset() + n3, n4);
                        AbstractAjpProcessor.this.responseMessage.end();
                        AbstractAjpProcessor.this.output(AbstractAjpProcessor.this.responseMessage.getBuffer(), 0, AbstractAjpProcessor.this.responseMessage.getLen());
                        n3 += n4;
                    }
                    AbstractAjpProcessor.this.bytesWritten += (long)byteChunk.getLength();
                }
                catch (IOException iOException) {
                    AbstractAjpProcessor.this.response.action(ActionCode.CLOSE_NOW, iOException);
                    throw iOException;
                }
            }
            return byteChunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return AbstractAjpProcessor.this.bytesWritten;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk byteChunk, Request request) throws IOException {
            if (AbstractAjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AbstractAjpProcessor.this.first && request.getContentLengthLong() > 0L) {
                if (!AbstractAjpProcessor.this.receive()) {
                    return 0;
                }
            } else if (AbstractAjpProcessor.this.empty && !AbstractAjpProcessor.this.refillReadBuffer()) {
                return -1;
            }
            ByteChunk byteChunk2 = AbstractAjpProcessor.this.bodyBytes.getByteChunk();
            byteChunk.setBytes(byteChunk2.getBuffer(), byteChunk2.getStart(), byteChunk2.getLength());
            AbstractAjpProcessor.this.empty = true;
            return byteChunk.getLength();
        }

        @Override
        public int available() {
            if (AbstractAjpProcessor.this.empty) {
                return 0;
            }
            return AbstractAjpProcessor.this.bodyBytes.getByteChunk().getLength();
        }
    }
}

