/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;

public class FileHandler
extends Handler {
    public static final int DEFAULT_MAX_DAYS = -1;
    private static final ExecutorService DELETE_FILES_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String NAME_PREFIX = "FileHandlerLogFilesCleaner-";
        private final boolean isSecurityEnabled;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.isSecurityEnabled = false;
                this.group = Thread.currentThread().getThreadGroup();
            } else {
                this.isSecurityEnabled = true;
                this.group = securityManager.getThreadGroup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread;
            block7: {
                ClassLoader classLoader;
                block6: {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        if (this.isSecurityEnabled) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                    return null;
                                }
                            });
                        } else {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        }
                        Thread thread2 = new Thread(this.group, runnable, NAME_PREFIX + this.threadNumber.getAndIncrement());
                        thread2.setDaemon(true);
                        thread = thread2;
                        if (!this.isSecurityEnabled) break block6;
                    }
                    catch (Throwable throwable) {
                        if (this.isSecurityEnabled) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(classLoader){
                                final /* synthetic */ ClassLoader val$loader;
                                {
                                    this.val$loader = classLoader;
                                }

                                @Override
                                public Void run() {
                                    Thread.currentThread().setContextClassLoader(this.val$loader);
                                    return null;
                                }
                            });
                        } else {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        throw throwable;
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    break block7;
                }
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            return thread;
        }
    });
    private volatile String date = "";
    private String directory = null;
    private String prefix = null;
    private String suffix = null;
    private boolean rotatable = true;
    private int maxDays = -1;
    private volatile PrintWriter writer = null;
    protected ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private int bufferSize = -1;
    private Pattern pattern;

    public FileHandler() {
        this(null, null, null, -1);
    }

    public FileHandler(String string, String string2, String string3) {
        this(string, string2, string3, -1);
    }

    public FileHandler(String string, String string2, String string3, int n) {
        this.directory = string;
        this.prefix = string2;
        this.suffix = string3;
        this.maxDays = n;
        this.configure();
        this.openWriter();
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        block17: {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string = timestamp.toString().substring(0, 10);
            this.writerLock.readLock().lock();
            try {
                if (this.rotatable && !this.date.equals(string)) {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    try {
                        if (!this.date.equals(string)) {
                            this.closeWriter();
                            this.date = string;
                            this.openWriter();
                            this.clean();
                        }
                    }
                    finally {
                        this.writerLock.readLock().lock();
                        this.writerLock.writeLock().unlock();
                    }
                }
                String string2 = null;
                try {
                    string2 = this.getFormatter().format(logRecord);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 5);
                    this.writerLock.readLock().unlock();
                    return;
                }
                try {
                    if (this.writer != null) {
                        this.writer.write(string2);
                        if (this.bufferSize < 0) {
                            this.writer.flush();
                        }
                        break block17;
                    }
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + string2 + "]", null, 1);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 1);
                }
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }
    }

    @Override
    public void close() {
        this.closeWriter();
    }

    protected void closeWriter() {
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = "";
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void configure() {
        String string;
        boolean bl;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.date = timestamp.toString().substring(0, 10);
        String string2 = this.getClass().getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.rotatable = Boolean.parseBoolean(this.getProperty(string2 + ".rotatable", "true"));
        if (this.directory == null) {
            this.directory = this.getProperty(string2 + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(string2 + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(string2 + ".suffix", ".log");
        }
        boolean bl2 = bl = !this.rotatable && !this.prefix.isEmpty() && !this.suffix.isEmpty();
        if (bl && this.prefix.charAt(this.prefix.length() - 1) == this.suffix.charAt(0)) {
            this.suffix = this.suffix.substring(1);
        }
        this.pattern = Pattern.compile("^(" + Pattern.quote(this.prefix) + ")\\d{4}-\\d{1,2}-\\d{1,2}(" + Pattern.quote(this.suffix) + ")$");
        String string3 = this.getProperty(string2 + ".maxDays", String.valueOf(-1));
        if (this.maxDays <= 0) {
            try {
                this.maxDays = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string4 = this.getProperty(string2 + ".bufferSize", String.valueOf(this.bufferSize));
        try {
            this.bufferSize = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string5 = this.getProperty(string2 + ".encoding", null);
        if (string5 != null && string5.length() > 0) {
            try {
                this.setEncoding(string5);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(string2 + ".level", "" + Level.ALL)));
        String string6 = this.getProperty(string2 + ".filter", null);
        if (string6 != null) {
            try {
                this.setFilter((Filter)classLoader.loadClass(string6).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.getProperty(string2 + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)classLoader.loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                this.setFormatter(new SimpleFormatter());
            }
        } else {
            this.setFormatter(new SimpleFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String string, String string2) {
        String string3 = LogManager.getLogManager().getProperty(string);
        string3 = string3 == null ? string2 : string3.trim();
        return string3;
    }

    protected void open() {
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        File file = new File(this.directory);
        if (!file.mkdirs() && !file.isDirectory()) {
            this.reportError("Unable to create [" + file + "]", null, 4);
            this.writer = null;
            return;
        }
        this.writerLock.writeLock().lock();
        FileOutputStream fileOutputStream = null;
        OutputStream outputStream = null;
        try {
            File file2 = new File(file.getAbsoluteFile(), this.prefix + (this.rotatable ? this.date : "") + this.suffix);
            File file3 = file2.getParentFile();
            if (!file3.mkdirs() && !file3.isDirectory()) {
                this.reportError("Unable to create [" + file3 + "]", null, 4);
                this.writer = null;
                return;
            }
            String string = this.getEncoding();
            fileOutputStream = new FileOutputStream(file2, true);
            outputStream = this.bufferSize > 0 ? new BufferedOutputStream(fileOutputStream, this.bufferSize) : fileOutputStream;
            this.writer = new PrintWriter((Writer)(string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception exception) {
            this.reportError(null, exception, 4);
            this.writer = null;
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    private void clean() {
        if (this.maxDays <= 0) {
            return;
        }
        DELETE_FILES_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                for (File file : FileHandler.this.streamFilesForDelete()) {
                    if (file.delete()) continue;
                    FileHandler.this.reportError("Unable to delete log files older than [" + FileHandler.this.maxDays + "] days", null, 0);
                }
            }
        });
    }

    private File[] streamFilesForDelete() {
        final Date date = this.getMaxDaysOffset();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return new File(this.directory).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                boolean bl = false;
                String string2 = FileHandler.this.obtainDateFromFilename(string);
                if (string2 != null) {
                    try {
                        Date date2 = simpleDateFormat.parse(string2);
                        bl = date2.before(date);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return bl;
            }
        });
    }

    private String obtainDateFromFilename(String string) {
        String string2 = string;
        if (this.pattern.matcher(string2).matches()) {
            string2 = string2.substring(this.prefix.length());
            return string2.substring(0, string2.length() - this.suffix.length());
        }
        return null;
    }

    private Date getMaxDaysOffset() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -this.maxDays);
        return calendar.getTime();
    }
}

