/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import mediathek.Main;
import mediathek.SplashScreen;
import mediathek.config.Config;
import mediathek.config.MVColor;
import mediathek.config.Messages;
import mediathek.controller.IoXmlLesen;
import mediathek.controller.IoXmlSchreiben;
import mediathek.controller.history.AboHistoryController;
import mediathek.controller.starter.StarterClass;
import mediathek.daten.DownloadInfos;
import mediathek.daten.ListeAbo;
import mediathek.daten.ListeDownloads;
import mediathek.daten.ListeFilme;
import mediathek.daten.ListeMediaDB;
import mediathek.daten.ListeMediaPath;
import mediathek.daten.ListePset;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.TimerEvent;
import mediathek.javafx.bookmark.BookmarkDataList;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.ReplaceList;
import mediathek.tool.notification.INotificationCenter;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.config.BusConfiguration;
import net.engio.mbassy.bus.config.Feature;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class Daten {
    public static final MVColor mVColor = new MVColor();
    public static final AtomicBoolean dontWriteFilmlistOnStartup = new AtomicBoolean(true);
    private static final Logger logger = LogManager.getLogger(Daten.class);
    private static final int MAX_COPY = 5;
    private static final ScheduledThreadPoolExecutor timerPool = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() / 2, new TimerPoolThreadFactory());
    public static ListePset listePset;
    private static Daten instance;
    private static boolean reset;
    private static String basisverzeichnis;
    private final Cleaner cleaner = Cleaner.create();
    private final FilmeLaden filmeLaden;
    private final ListeFilme listeFilme;
    private final ListeFilme listeFilmeNachBlackList;
    private final ListeDownloads listeDownloads;
    private final ListeDownloads listeDownloadsButton;
    private final ListeBlacklist listeBlacklist;
    private final BookmarkDataList listeBookmarkList;
    private final ListeMediaDB listeMediaDB;
    private final ListeMediaPath listeMediaPath;
    private final ListeAbo listeAbo;
    private final DownloadInfos downloadInfos;
    private final MVSenderIconCache senderIconCache;
    public StarterClass starterClass;
    private INotificationCenter notificationCenter;
    private AboHistoryController erledigteAbos;
    private boolean alreadyMadeBackup;
    private MBassador<BaseEvent> messageBus;
    private ListenableFuture<AboHistoryController> aboHistoryFuture;

    private Daten() {
        this.setupMessageBus();
        this.listeFilme = new ListeFilme();
        this.filmeLaden = new FilmeLaden(this);
        this.senderIconCache = new MVSenderIconCache(this);
        this.listeFilmeNachBlackList = new ListeFilme();
        this.listeBlacklist = new ListeBlacklist();
        this.listeBookmarkList = BookmarkDataList.getInstance(this);
        listePset = new ListePset();
        this.listeAbo = new ListeAbo(this);
        this.listeDownloads = new ListeDownloads(this);
        this.listeDownloadsButton = new ListeDownloads(this);
        this.listeMediaDB = new ListeMediaDB(this);
        this.listeMediaPath = new ListeMediaPath();
        this.downloadInfos = new DownloadInfos(this.messageBus);
        this.starterClass = new StarterClass(this);
        this.setupTimerPool();
    }

    public static boolean resetConfigurationData() {
        return reset;
    }

    public static void setResetConfigurationData(boolean aIsReset) {
        reset = aIsReset;
    }

    public static Daten getInstance(@NotNull String aBasisverzeichnis) {
        basisverzeichnis = aBasisverzeichnis;
        return Daten.getInstance();
    }

    public static Daten getInstance() {
        return instance == null ? (instance = new Daten()) : instance;
    }

    public static String getDateiFilmliste() {
        String filePart = File.separator + "filme.json";
        String strFile = Config.isPortableMode() ? Daten.getSettingsDirectory_String() + filePart : (SystemUtils.IS_OS_MAC_OSX ? GuiFunktionen.getHomePath() + File.separator + "Library/Caches/MediathekView" + filePart : Daten.getSettingsDirectory_String() + filePart);
        return strFile;
    }

    private static Path getSettingsDirectory() throws IllegalStateException {
        Path baseDirectoryPath = basisverzeichnis == null || basisverzeichnis.isEmpty() ? Paths.get(System.getProperty("user.home"), ".mediathek3") : Paths.get(basisverzeichnis, new String[0]);
        if (Files.notExists(baseDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(baseDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                Messages.logMessage(Messages.ERROR_CANT_CREATE_FOLDER, ioException, baseDirectoryPath.toString());
                throw new IllegalStateException(Messages.ERROR_CANT_CREATE_FOLDER.getTextFormatted(baseDirectoryPath.toString()), ioException);
            }
        }
        return baseDirectoryPath;
    }

    public static String getSettingsDirectory_String() {
        return Daten.getSettingsDirectory().toString();
    }

    public static Path getMediathekXmlFilePath() {
        return Daten.getSettingsDirectory().resolve("mediathek.xml");
    }

    private static List<Path> getMediathekXmlCopyFilePath() {
        ArrayList<Path> xmlFilePath = new ArrayList<Path>();
        for (int i = 1; i <= 5; ++i) {
            Path path = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + i);
            if (!Files.exists(path, new LinkOption[0])) continue;
            xmlFilePath.add(path);
        }
        return xmlFilePath;
    }

    public static Path getBookmarkFilePath() {
        return Daten.getSettingsDirectory().resolve("bookmarks.json");
    }

    public void loadBookMarkData() {
        this.listeBookmarkList.loadFromFile(Daten.getBookmarkFilePath());
    }

    private long getHeute_0Uhr() {
        LocalDateTime todayMidnight = LocalDateTime.of(LocalDate.now(), LocalTime.MIDNIGHT);
        ZonedDateTime zdt = ZonedDateTime.of(todayMidnight, ZoneId.systemDefault());
        return zdt.toInstant().toEpochMilli();
    }

    public INotificationCenter notificationCenter() {
        return this.notificationCenter;
    }

    public void setNotificationCenter(INotificationCenter center) {
        this.notificationCenter = center;
    }

    public MVSenderIconCache getSenderIconCache() {
        return this.senderIconCache;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MBassador<BaseEvent> getMessageBus() {
        return this.messageBus;
    }

    private void setupMessageBus() {
        this.messageBus = new MBassador(new BusConfiguration().addFeature(Feature.SyncPubSub.Default()).addFeature(Feature.AsynchronousHandlerInvocation.Default()).addFeature(Feature.AsynchronousMessageDispatch.Default()).addPublicationErrorHandler(error -> logger.error(error.getMessage(), error.getCause())).setProperty("bus.id", "global bus"));
    }

    public void setAboHistoryList(AboHistoryController controller) {
        this.erledigteAbos = controller;
    }

    public AboHistoryController getAboHistoryController() {
        return this.erledigteAbos;
    }

    public ScheduledThreadPoolExecutor getTimerPool() {
        return timerPool;
    }

    private void setupTimerPool() {
        timerPool.setRemoveOnCancelPolicy(true);
        timerPool.scheduleWithFixedDelay(() -> this.messageBus.publishAsync(new TimerEvent()), 4L, 1L, TimeUnit.SECONDS);
    }

    public boolean allesLaden() {
        if (!this.load()) {
            logger.info("Weder Konfig noch Backup konnte geladen werden!");
            this.clearKonfig();
            return false;
        }
        logger.info("Konfig wurde gelesen!");
        mVColor.load();
        return true;
    }

    public void launchHistoryDataLoading() {
        logger.trace("launching async history data loading");
        ListeningExecutorService decoratedPool = MoreExecutors.listeningDecorator(ForkJoinPool.commonPool());
        this.aboHistoryFuture = this.launchAboHistoryController(decoratedPool);
    }

    private ListenableFuture<AboHistoryController> launchAboHistoryController(ListeningExecutorService decoratedPool) {
        Future aboHistoryFuture = decoratedPool.submit(AboHistoryController::new);
        Futures.addCallback(aboHistoryFuture, new FutureCallback<AboHistoryController>(){

            @Override
            public void onSuccess(@Nullable AboHistoryController aboHistoryController) {
                Daten.this.setAboHistoryList(aboHistoryController);
            }

            @Override
            public void onFailure(@NotNull Throwable throwable) {
                logger.error("launchAboHistoryController", throwable);
            }
        }, decoratedPool);
        return aboHistoryFuture;
    }

    public void waitForHistoryDataLoadingToComplete() throws ExecutionException, InterruptedException {
        this.aboHistoryFuture.get();
        this.aboHistoryFuture = null;
    }

    private void clearKonfig() {
        listePset.clear();
        ReplaceList.clear();
        this.listeAbo.clear();
        this.listeDownloads.clear();
        this.listeBlacklist.clear();
        this.listeBookmarkList.clear();
    }

    private boolean load() {
        boolean ret = false;
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        if (Files.exists(xmlFilePath, new LinkOption[0])) {
            IoXmlLesen configReader = new IoXmlLesen();
            if (configReader.datenLesen(xmlFilePath)) {
                return true;
            }
            logger.info("Konfig konnte nicht gelesen werden!");
        } else {
            logger.info("Konfig existiert nicht!");
        }
        if (this.loadBackup()) {
            ret = true;
        }
        return ret;
    }

    private boolean loadBackup() {
        boolean ret = false;
        List<Path> path = Daten.getMediathekXmlCopyFilePath();
        if (path.isEmpty()) {
            logger.info("Es gibt kein Backup");
            return false;
        }
        Main.splashScreen.ifPresent(SplashScreen::close);
        logger.info("Es gibt ein Backup");
        Boolean loadBackup = JavaFxUtils.invokeInFxThreadAndWait(() -> {
            ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.OK_DONE);
            ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.WARNING, "Die Einstellungen sind besch\u00e4digt und k\u00f6nnen nicht geladen werden. Soll versucht werden diese aus einem Backup wiederherzustellen?", btnYes, btnNo);
            alert.setTitle("MediathekView");
            alert.setHeaderText("Gesicherte Einstellungen laden");
            Optional result = alert.showAndWait();
            if (result.orElse(btnNo) == btnNo) {
                logger.info("User will kein Backup laden.");
                return false;
            }
            return true;
        });
        if (loadBackup.booleanValue()) {
            for (Path p : path) {
                this.clearKonfig();
                logger.info("Versuch Backup zu laden: {}", (Object)p.toString());
                IoXmlLesen configReader = new IoXmlLesen();
                if (!configReader.datenLesen(p)) continue;
                logger.info("Backup hat geklappt: {}", (Object)p.toString());
                ret = true;
                break;
            }
        }
        return ret;
    }

    public void allesSpeichern() {
        block4: {
            this.createConfigurationBackupCopies();
            IoXmlSchreiben configWriter = new IoXmlSchreiben();
            configWriter.writeConfigurationFile(Daten.getMediathekXmlFilePath());
            if (Daten.resetConfigurationData()) {
                String dir1 = Daten.getSettingsDirectory_String();
                if (dir1.endsWith(File.separator)) {
                    dir1 = dir1.substring(0, dir1.length() - 1);
                }
                try {
                    Path path1 = Paths.get(dir1, new String[0]);
                    String nowStr = DateTimeFormatter.ofPattern("yyyy.MM.dd__HH.mm.ss").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
                    String dir2 = dir1 + "--" + nowStr;
                    Files.move(path1, Paths.get(dir2, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Files.deleteIfExists(path1);
                }
                catch (IOException e) {
                    logger.error("Die Einstellungen konnten nicht zur\u00fcckgesetzt werden.", (Throwable)e);
                    if (MediathekGui.ui() == null) break block4;
                    JavaFxUtils.invokeInFxThreadAndWait(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setHeaderText("Fehler beim Zur\u00fccksetzen der Einstellungen");
                        alert.setContentText("Die Einstellungen konnten nicht zur\u00fcckgesetzt werden.\nSie m\u00fcssen jetzt das Programm beenden und dann den Ordner:\n" + Daten.getSettingsDirectory_String() + "\nvon Hand l\u00f6schen und dann das Programm wieder starten.\n\nIm Forum erhalten Sie weitere Hilfe.");
                        JFXHiddenApplication.showAlert(alert, MediathekGui.ui());
                    });
                }
            }
        }
    }

    private void createConfigurationBackupCopies() {
        if (!this.alreadyMadeBackup) {
            logger.info("-------------------------------------------------------");
            logger.info("Einstellungen sichern");
            try {
                Path xmlFilePath = Daten.getMediathekXmlFilePath();
                long creatTime = -1L;
                Path xmlFilePathCopy_1 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_1");
                if (Files.exists(xmlFilePathCopy_1, new LinkOption[0])) {
                    BasicFileAttributes attrs = Files.readAttributes(xmlFilePathCopy_1, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime d = attrs.lastModifiedTime();
                    creatTime = d.toMillis();
                }
                if (creatTime == -1L || creatTime < this.getHeute_0Uhr()) {
                    for (int i = 5; i > 1; --i) {
                        xmlFilePathCopy_1 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + (i - 1));
                        Path xmlFilePathCopy_2 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + i);
                        if (!Files.exists(xmlFilePathCopy_1, new LinkOption[0])) continue;
                        Files.move(xmlFilePathCopy_1, xmlFilePathCopy_2, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (Files.exists(xmlFilePath, new LinkOption[0])) {
                        Files.move(xmlFilePath, Daten.getSettingsDirectory().resolve("mediathek.xml_copy_1"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    logger.info("Einstellungen wurden gesichert");
                } else {
                    logger.info("Einstellungen wurden heute schon gesichert");
                }
            }
            catch (IOException e) {
                logger.error("Die Einstellungen konnten nicht komplett gesichert werden!", (Throwable)e);
            }
            this.alreadyMadeBackup = true;
            logger.info("-------------------------------------------------------");
        }
    }

    public FilmeLaden getFilmeLaden() {
        return this.filmeLaden;
    }

    public ListeFilme getListeFilme() {
        return this.listeFilme;
    }

    public ListeFilme getListeFilmeNachBlackList() {
        return this.listeFilmeNachBlackList;
    }

    public ListeDownloads getListeDownloads() {
        return this.listeDownloads;
    }

    public ListeDownloads getListeDownloadsButton() {
        return this.listeDownloadsButton;
    }

    public ListeBlacklist getListeBlacklist() {
        return this.listeBlacklist;
    }

    public BookmarkDataList getListeBookmarkList() {
        return this.listeBookmarkList;
    }

    public ListeMediaDB getListeMediaDB() {
        return this.listeMediaDB;
    }

    public ListeMediaPath getListeMediaPath() {
        return this.listeMediaPath;
    }

    public ListeAbo getListeAbo() {
        return this.listeAbo;
    }

    public DownloadInfos getDownloadInfos() {
        return this.downloadInfos;
    }

    private static class TimerPoolThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        TimerPoolThreadFactory() {
            SecurityManager s2 = System.getSecurityManager();
            this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "timerPool-thread-";
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

