/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmListDownloadType;
import mediathek.filmlisten.ImportFilmliste;
import mediathek.filmlisten.reader.FilmListReader;
import mediathek.gui.actions.FilmListWriteWorkerTask;
import mediathek.javafx.FilmListFilterTask;
import mediathek.javafx.tool.FXProgressPane;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVHttpClient;
import mediathek.tool.javafx.FXErrorDialog;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilmeLaden {
    private static final Logger logger = LogManager.getLogger(FilmeLaden.class);
    private static final String NETWORK_NOT_AVAILABLE = "Netzwerk nicht verf\u00fcgbar";
    private static final String DIALOG_TITLE = "Filmliste laden";
    private static final String NO_UPDATE_AVAILABLE = "Keine aktuellere Liste verf\u00fcgbar";
    private static final int HTTP_NOT_FOUND = 404;
    private final HashSet<String> hashSet = new HashSet();
    private final ListeFilme diffListe = new ListeFilme();
    private final Daten daten;
    private final ImportFilmliste importFilmliste;
    private final EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen;
    private boolean onlyOne;

    public FilmeLaden(Daten aDaten) {
        this.daten = aDaten;
        this.importFilmliste = new ImportFilmliste();
        this.importFilmliste.addAdListener(new ListenerFilmeLaden(){

            @Override
            public synchronized void start(ListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyStart(event);
            }

            @Override
            public synchronized void progress(ListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyProgress(event);
            }

            @Override
            public synchronized void fertig(ListenerFilmeLadenEvent event) {
                logger.trace("Filme laden, ende");
                FilmeLaden.this.undEnde(event);
            }
        });
    }

    private void showNoUpdateAvailableDialog() {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("MediathekView");
            alert.setHeaderText(DIALOG_TITLE);
            alert.setContentText(NO_UPDATE_AVAILABLE);
            alert.showAndWait();
        });
    }

    private boolean hasNewRemoteFilmlist() {
        boolean result;
        block26: {
            result = false;
            logger.trace("hasNewRemoteFilmList()");
            String id = Daten.getInstance().getListeFilme().metaData().getId();
            boolean showDialogs = true;
            if (GuiFunktionen.getImportArtFilme() == FilmListUpdateType.AUTOMATIC) {
                showDialogs = false;
            }
            HttpUrl filmListUrl = Konstanten.ROUTER_BASE_URL.resolve("filmliste.id");
            Request request = new Request.Builder().url(Objects.requireNonNull(filmListUrl)).build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (body != null && response.isSuccessful()) {
                    String remoteId = body.string();
                    if (!remoteId.isEmpty() && !remoteId.equalsIgnoreCase(id)) {
                        result = true;
                    }
                } else {
                    logger.warn("hasNewRemoteFilmlist HTTP Response Code: {} for {}", (Object)response.code(), (Object)response.request().url());
                    if (response.code() == 404) {
                        result = true;
                    }
                }
                if (!result) {
                    if (showDialogs) {
                        this.showNoUpdateAvailableDialog();
                    } else {
                        logger.info(NO_UPDATE_AVAILABLE);
                    }
                }
            }
            catch (UnknownHostException ex) {
                logger.debug(ex);
                if (showDialogs) {
                    Platform.runLater(() -> FXErrorDialog.showErrorDialog("MediathekView", DIALOG_TITLE, NETWORK_NOT_AVAILABLE, ex));
                } else {
                    logger.warn(NETWORK_NOT_AVAILABLE);
                }
            }
            catch (IOException ex) {
                logger.error("IOxception:", (Throwable)ex);
                Platform.runLater(() -> FXErrorDialog.showErrorDialog("MediathekView", DIALOG_TITLE, "Netzwerkfehler aufgetreten!", ex));
            }
            catch (Exception ex) {
                logger.error("check for filmliste.id failed", (Throwable)ex);
                if (!showDialogs) break block26;
                Platform.runLater(() -> FXErrorDialog.showErrorDialog("MediathekView", DIALOG_TITLE, "Ein unbekannter Fehler ist aufgetreten.", ex));
            }
        }
        return result;
    }

    private boolean performUpdateCheck(ListeFilme listeFilme, String dateiUrl) {
        boolean result = true;
        if (listeFilme.isEmpty()) {
            return true;
        }
        if ((dateiUrl.isEmpty() || dateiUrl.startsWith("http")) && !listeFilme.metaData().canUseDiffList() && !this.hasNewRemoteFilmlist()) {
            result = false;
        }
        return result;
    }

    private void prepareHashTable() {
        this.hashSet.clear();
        this.fillHash(this.daten.getListeFilme());
    }

    public boolean loadFilmlist(String dateiUrl, boolean immerNeuLaden) {
        ListeFilme listeFilme = this.daten.getListeFilme();
        if (!this.performUpdateCheck(listeFilme, dateiUrl)) {
            return false;
        }
        logger.trace("loadFilmlist(String,boolean)");
        logger.info("");
        logger.info("Alte Liste erstellt am: {}", (Object)listeFilme.metaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        logger.info("  Anzahl Neue: {}", (Object)listeFilme.countNewFilms());
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.prepareHashTable();
            if (immerNeuLaden) {
                listeFilme.clear();
            }
            this.daten.getListeFilmeNachBlackList().clear();
            int days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
            if (dateiUrl.isEmpty()) {
                logger.info("Filmliste laden (Netzwerk)");
                this.importFilmliste.importFromUrl(listeFilme, this.diffListe, days);
            } else {
                logger.info("Filmliste laden von: {}", (Object)dateiUrl);
                listeFilme.clear();
                this.importFilmliste.importFromFile(dateiUrl, listeFilme, days);
            }
        }
        return true;
    }

    public void updateFilmlist(String dateiUrl) {
        logger.debug("Filme laden (Update), start");
        logger.info("");
        logger.info("Alte Liste erstellt am: {}", (Object)this.daten.getListeFilme().metaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)this.daten.getListeFilme().size());
        logger.info("  Anzahl Neue: {}", (Object)this.daten.getListeFilme().countNewFilms());
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.prepareHashTable();
            this.daten.getListeFilmeNachBlackList().clear();
            logger.info("Filmliste laden von: " + dateiUrl);
            int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
            if (dateiUrl.isEmpty()) {
                dateiUrl = GuiFunktionen.getFilmListUrl(FilmListDownloadType.FULL);
            }
            this.importFilmliste.importFromFile(dateiUrl, this.diffListe, num_days);
        }
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private void undEnde(ListenerFilmeLadenEvent event) {
        boolean writeFilmList;
        logger.debug("undEnde()");
        ListeFilme listeFilme = this.daten.getListeFilme();
        String readDate = DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        if (!this.diffListe.isEmpty()) {
            logger.info("Liste Diff gelesen am: {}", (Object)readDate);
            logger.info("  Liste Diff erstellt am: {}", (Object)this.diffListe.metaData().getGenerationDateTimeAsString());
            logger.info("  Anzahl Filme: {}", (Object)this.diffListe.size());
            listeFilme.updateFromFilmList(this.diffListe);
            listeFilme.setMetaData(this.diffListe.metaData());
            Collections.sort(listeFilme);
            this.diffListe.clear();
        } else {
            logger.info("Liste Kompl. gelesen am: {}", (Object)readDate);
            logger.info("  Liste Kompl erstellt am: {}", (Object)listeFilme.metaData().getGenerationDateTimeAsString());
            logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        }
        this.findAndMarkNewFilms(this.daten.getListeFilme());
        MediathekGui ui = MediathekGui.ui();
        this.istAmLaufen = false;
        if (event.fehler) {
            logger.info("");
            logger.info("Filmliste laden war fehlerhaft, alte Liste wird wieder geladen");
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setHeaderText("Fehler");
                alert.setContentText("Das Laden der Filmliste hat nicht geklappt!");
                JFXHiddenApplication.showAlert(alert, ui);
            });
            listeFilme.clear();
            try (FilmListReader reader = new FilmListReader();){
                int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
                reader.readFilmListe(Daten.getDateiFilmliste(), listeFilme, num_days);
            }
            logger.info("");
            writeFilmList = false;
        } else {
            writeFilmList = !Daten.dontWriteFilmlistOnStartup.get();
        }
        logger.info("");
        logger.info("Jetzige Liste erstellt am: {}", (Object)listeFilme.metaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        logger.info("  Anzahl Neue:  {}", (Object)listeFilme.countNewFilms());
        logger.info("");
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            FXProgressPane hb = new FXProgressPane();
            FilmListFilterTask task = new FilmListFilterTask(true);
            task.setOnRunning(e -> {
                ui.getStatusBarController().getStatusBar().getRightItems().add(hb);
                hb.lb.textProperty().bind(task.messageProperty());
                hb.prog.progressProperty().bind(task.progressProperty());
            });
            CompletionStage<Void> workerTask = CompletableFuture.runAsync(task);
            if (writeFilmList) {
                FilmListWriteWorkerTask writerTask = new FilmListWriteWorkerTask(Daten.getInstance());
                writerTask.setOnRunning(e -> {
                    hb.lb.textProperty().bind(writerTask.messageProperty());
                    hb.prog.progressProperty().bind(writerTask.progressProperty());
                });
                workerTask = workerTask.thenRun(writerTask);
            }
            workerTask.thenRun(() -> JavaFxUtils.invokeInFxThreadAndWait(() -> ui.getStatusBarController().getStatusBar().getRightItems().remove(hb)));
        });
    }

    private void fillHash(ListeFilme listeFilme) {
        this.hashSet.addAll(listeFilme.parallelStream().map(DatenFilm::getUrl).collect(Collectors.toList()));
    }

    private void findAndMarkNewFilms(ListeFilme listeFilme) {
        listeFilme.neueFilme = false;
        Stopwatch stopwatch = Stopwatch.createStarted();
        listeFilme.parallelStream().peek(film -> film.setNew(false)).filter(film -> !this.hashSet.contains(film.getUrl())).forEach(film -> {
            film.setNew(true);
            listeFilme.neueFilme = true;
        });
        stopwatch.stop();
        logger.debug("findAndMarkNewFilms() took: {}", (Object)stopwatch);
        this.hashSet.clear();
    }

    public void notifyStart(ListenerFilmeLadenEvent e) {
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.start(e);
                }
            });
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }

    public void notifyProgress(ListenerFilmeLadenEvent e) {
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.progress(e);
                }
            });
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }

    public void notifyFertig(ListenerFilmeLadenEvent e) {
        ListenerFilmeLaden[] listListeners = (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class);
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden lst : listListeners) {
                    lst.fertig(e);
                }
            });
            if (!this.onlyOne) {
                this.onlyOne = true;
                SwingUtilities.invokeLater(() -> {
                    for (ListenerFilmeLaden lst : listListeners) {
                        lst.fertigOnlyOne(e);
                    }
                });
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }
}

