/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Constructor;
import java.security.PrivilegedExceptionAction;

class SystemClassLoaderAction
implements PrivilegedExceptionAction<ClassLoader> {
    private ClassLoader parent;

    SystemClassLoaderAction(ClassLoader parent) {
        this.parent = parent;
    }

    @Override
    public ClassLoader run() throws Exception {
        String cls = System.getProperty("java.system.class.loader");
        if (cls == null) {
            return this.parent;
        }
        Constructor<?> ctor = Class.forName(cls, true, this.parent).getDeclaredConstructor(ClassLoader.class);
        ClassLoader sys = (ClassLoader)ctor.newInstance(this.parent);
        Thread.currentThread().setContextClassLoader(sys);
        return sys;
    }
}

