/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;

public class TeXPath {
    private Path base;
    private Path relative;
    private boolean foundByKpsewhich = false;

    public TeXPath(TeXParser teXParser, String string) throws IOException {
        this(teXParser, string, true, "tex");
    }

    public TeXPath(TeXParser teXParser, String string, boolean bl) throws IOException {
        this(teXParser, string, bl, "tex");
    }

    public TeXPath(TeXParser teXParser, String string, String ... stringArray) throws IOException {
        this(teXParser, string, true, stringArray);
    }

    public TeXPath(TeXParser teXParser, String string, String string2, boolean bl) throws IOException {
        this.init(teXParser, string, bl, string2);
    }

    public TeXPath(TeXParser teXParser, String string, boolean bl, String ... stringArray) throws IOException {
        this.init(teXParser, string, bl, stringArray);
    }

    public TeXPath(TeXParser teXParser, File file) throws IOException {
        this.init(teXParser, file);
    }

    private void init(TeXParser teXParser, File file) throws IOException {
        File file2 = teXParser == null ? null : teXParser.getCurrentParentFile();
        Path path = file.toPath();
        if (path.isAbsolute()) {
            this.base = null;
            this.relative = path;
        } else {
            this.base = file2 == null ? null : file2.toPath();
            this.relative = this.base == null ? path : this.base.relativize(path);
        }
    }

    private void init(TeXParser teXParser, String string, String ... stringArray) throws IOException {
        this.init(teXParser, string, true, stringArray);
    }

    private void init(TeXParser teXParser, String string, boolean bl, String ... stringArray) throws IOException {
        String[] stringArray2;
        File file = teXParser == null ? null : teXParser.getCurrentParentFile();
        Path path = this.base = file == null ? null : file.toPath();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        File file2 = new File((stringArray2 = string.split("/")).length == 1 ? stringArray2[0] : stringArray2[0] + File.separator);
        int n = 0;
        if (file2.isAbsolute()) {
            this.base = null;
            file = file2;
            n = 1;
        }
        int n2 = stringArray2.length - 1;
        while (n < n2) {
            if (!stringArray2[n].isEmpty()) {
                file = file == null ? new File(stringArray2[n]) : new File(file, stringArray2[n]);
            }
            ++n;
        }
        if (stringArray2[n2].startsWith("\"") && stringArray2[n2].endsWith("\"")) {
            stringArray2[n2] = stringArray2[n2].substring(1, stringArray2[n2].length() - 1);
        }
        File file3 = null;
        String string2 = stringArray2[n2];
        boolean bl2 = string2.contains(".");
        if (bl2 && file != null && file.isAbsolute() && (file3 = new File(file, stringArray2[n2])).exists()) {
            this.relative = file3.toPath();
            return;
        }
        if (stringArray.length > 0 && !bl2) {
            for (String string3 : stringArray) {
                stringArray2[n2] = string3.isEmpty() ? string2 : string2 + "." + string3;
                File file4 = file3 = file == null ? new File(stringArray2[n2]) : new File(file, stringArray2[n2]);
                if (file3.exists()) {
                    this.relative = this.base == null ? file3.toPath() : this.base.relativize(file3.toPath());
                    return;
                }
                if (!bl || teXParser == null) continue;
                try {
                    String string4 = teXParser.getListener().getTeXApp().kpsewhich(stringArray2[n2]);
                    if (string4 == null || string4.isEmpty()) continue;
                    this.foundByKpsewhich = true;
                    this.init(teXParser, string4, false, "");
                    return;
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
            stringArray2[n2] = string2 + "." + stringArray[0];
            bl = false;
        }
        file3 = file == null ? new File(stringArray2[n2]) : new File(file, stringArray2[n2]);
        this.relative = this.base == null ? file3.toPath() : this.base.relativize(file3.toPath());
        if (!file3.exists() && bl && teXParser != null) {
            try {
                String string5 = teXParser.getListener().getTeXApp().kpsewhich(stringArray2[n2]);
                if (string5 != null && !string5.isEmpty()) {
                    this.foundByKpsewhich = true;
                    this.init(teXParser, string5, false, "");
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
    }

    public Path getRelativePath() {
        return this.relative;
    }

    public Path getBaseDir() {
        return this.base;
    }

    public boolean isHidden() {
        String string;
        int n;
        if (this.base != null) {
            for (n = this.base.getNameCount() - 1; n >= 0; --n) {
                string = this.base.getName(n).toString();
                if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
                return true;
            }
        }
        for (n = this.relative.getNameCount() - 1; n >= 0; --n) {
            string = this.relative.getName(n).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public String getTeXPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Path> iterator = this.relative.iterator();
        while (iterator.hasNext()) {
            Path path = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(path.toString());
                stringBuilder.append('/');
                continue;
            }
            if (bl) {
                String string = path.toString();
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(path.toString());
        }
        return stringBuilder.toString();
    }

    public File getFile() {
        Path path = this.base == null ? this.relative : this.base.resolve(this.relative);
        return path.toFile();
    }

    public Path getPath() {
        return this.base == null ? this.relative : this.base.resolve(this.relative);
    }

    public Path getRelative() {
        return this.relative;
    }

    public Path getLeaf() {
        return this.relative.getName(this.relative.getNameCount() - 1);
    }

    public String getExtension() {
        String string = this.getLeaf().toString();
        int n = string.lastIndexOf(".");
        return n == -1 ? null : string.substring(n);
    }

    public Path getFileName() {
        return this.relative.getFileName();
    }

    public boolean isAbsolute() {
        return this.relative.isAbsolute();
    }

    public boolean exists() {
        File file = this.getFile();
        return file == null ? false : file.exists();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TeXPath)) {
            return false;
        }
        TeXPath teXPath = (TeXPath)object;
        if (this.base == null && teXPath.base == null) {
            return this.relative.equals(teXPath.relative);
        }
        if (this.base == null || teXPath.base == null) {
            return false;
        }
        return this.relative.equals(teXPath.relative);
    }

    public String toString() {
        return this.base == null ? this.relative.toString() : this.base.resolve(this.relative).toString();
    }

    public boolean wasFoundByKpsewhich() {
        return this.foundByKpsewhich;
    }
}

